"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NagRules = exports.NagRuleCompliance = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * The compliance level of a resource in relation to a rule.
 */
var NagRuleCompliance;
(function (NagRuleCompliance) {
    NagRuleCompliance["COMPLIANT"] = "Compliant";
    NagRuleCompliance["NON_COMPLIANT"] = "Non-Compliant";
    NagRuleCompliance["NOT_APPLICABLE"] = "N/A";
})(NagRuleCompliance = exports.NagRuleCompliance || (exports.NagRuleCompliance = {}));
/**
 * Helper class with methods for rule creation
 */
class NagRules {
    /**
     * Use in cases where a primitive value must be known to pass a rule.
     * https://developer.mozilla.org/en-US/docs/Glossary/Primitive
     * @param node The CfnResource to check.
     * @param parameter The value to attempt to resolve.
     * @returns Return a value if resolves to a primitive data type, otherwise throw an error.
     */
    static resolveIfPrimitive(node, parameter) {
        const resolvedValue = aws_cdk_lib_1.Stack.of(node).resolve(parameter);
        if (resolvedValue === Object(resolvedValue)) {
            throw Error(`The parameter resolved to to a non-primitive value "${JSON.stringify(resolvedValue)}", therefore the rule could not be validated.`);
        }
        else {
            return resolvedValue;
        }
    }
    /**
     * Use in cases where a token resolves to an intrinsic function and the referenced resource must be known to pass a rule.
     * @param node The CfnResource to check.
     * @param parameter The value to attempt to resolve.
     * @returns Return the Logical resource Id if resolves to a intrinsic function, otherwise the resolved provided value.
     */
    static resolveResourceFromInstrinsic(node, parameter) {
        const resolvedValue = aws_cdk_lib_1.Stack.of(node).resolve(parameter);
        const ref = resolvedValue?.Ref;
        const getAtt = resolvedValue?.['Fn::GetAtt'];
        if (ref != undefined) {
            return ref;
        }
        else if (Array.isArray(getAtt) && getAtt.length > 0) {
            return getAtt[0];
        }
        return resolvedValue;
    }
}
exports.NagRules = NagRules;
_a = JSII_RTTI_SYMBOL_1;
NagRules[_a] = { fqn: "cdk-nag.NagRules", version: "2.21.45" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibmFnLXJ1bGVzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL25hZy1ydWxlcy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBOzs7RUFHRTtBQUNGLDZDQUFpRDtBQUVqRDs7R0FFRztBQUNILElBQVksaUJBSVg7QUFKRCxXQUFZLGlCQUFpQjtJQUMzQiw0Q0FBdUIsQ0FBQTtJQUN2QixvREFBK0IsQ0FBQTtJQUMvQiwyQ0FBc0IsQ0FBQTtBQUN4QixDQUFDLEVBSlcsaUJBQWlCLEdBQWpCLHlCQUFpQixLQUFqQix5QkFBaUIsUUFJNUI7QUFZRDs7R0FFRztBQUNILE1BQWEsUUFBUTtJQUNuQjs7Ozs7O09BTUc7SUFDSCxNQUFNLENBQUMsa0JBQWtCLENBQUMsSUFBaUIsRUFBRSxTQUFjO1FBQ3pELE1BQU0sYUFBYSxHQUFHLG1CQUFLLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxDQUFDLE9BQU8sQ0FBQyxTQUFTLENBQUMsQ0FBQztRQUN4RCxJQUFJLGFBQWEsS0FBSyxNQUFNLENBQUMsYUFBYSxDQUFDLEVBQUU7WUFDM0MsTUFBTSxLQUFLLENBQ1QsdURBQXVELElBQUksQ0FBQyxTQUFTLENBQ25FLGFBQWEsQ0FDZCwrQ0FBK0MsQ0FDakQsQ0FBQztTQUNIO2FBQU07WUFDTCxPQUFPLGFBQWEsQ0FBQztTQUN0QjtJQUNILENBQUM7SUFFRDs7Ozs7T0FLRztJQUNILE1BQU0sQ0FBQyw2QkFBNkIsQ0FBQyxJQUFpQixFQUFFLFNBQWM7UUFDcEUsTUFBTSxhQUFhLEdBQUcsbUJBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUMsT0FBTyxDQUFDLFNBQVMsQ0FBQyxDQUFDO1FBQ3hELE1BQU0sR0FBRyxHQUFHLGFBQWEsRUFBRSxHQUFHLENBQUM7UUFDL0IsTUFBTSxNQUFNLEdBQUcsYUFBYSxFQUFFLENBQUMsWUFBWSxDQUFDLENBQUM7UUFDN0MsSUFBSSxHQUFHLElBQUksU0FBUyxFQUFFO1lBQ3BCLE9BQU8sR0FBRyxDQUFDO1NBQ1o7YUFBTSxJQUFJLEtBQUssQ0FBQyxPQUFPLENBQUMsTUFBTSxDQUFDLElBQUksTUFBTSxDQUFDLE1BQU0sR0FBRyxDQUFDLEVBQUU7WUFDckQsT0FBTyxNQUFNLENBQUMsQ0FBQyxDQUFDLENBQUM7U0FDbEI7UUFDRCxPQUFPLGFBQWEsQ0FBQztJQUN2QixDQUFDOztBQXJDSCw0QkFzQ0MiLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuQ29weXJpZ2h0IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG5TUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuKi9cbmltcG9ydCB7IENmblJlc291cmNlLCBTdGFjayB9IGZyb20gJ2F3cy1jZGstbGliJztcblxuLyoqXG4gKiBUaGUgY29tcGxpYW5jZSBsZXZlbCBvZiBhIHJlc291cmNlIGluIHJlbGF0aW9uIHRvIGEgcnVsZS5cbiAqL1xuZXhwb3J0IGVudW0gTmFnUnVsZUNvbXBsaWFuY2Uge1xuICBDT01QTElBTlQgPSAnQ29tcGxpYW50JyxcbiAgTk9OX0NPTVBMSUFOVCA9ICdOb24tQ29tcGxpYW50JyxcbiAgTk9UX0FQUExJQ0FCTEUgPSAnTi9BJyxcbn1cblxuZXhwb3J0IHR5cGUgTmFnUnVsZUZpbmRpbmcgPSBzdHJpbmc7XG5cbmV4cG9ydCB0eXBlIE5hZ1J1bGVGaW5kaW5ncyA9IE5hZ1J1bGVGaW5kaW5nW107XG5cbi8qKlxuICogVGhlIHJlc3VsdCBvZiBhIHJ1bGUgY2hlY2suIENhbiBlaXRoZXIgYmUgYE5hZ1J1bGVDb21wbGlhbmNlYFxuICogb3IgYW4gYXJyYXkgb2YgaW5kaXZpZHVhbCBmaW5kaW5nc1xuICovXG5leHBvcnQgdHlwZSBOYWdSdWxlUmVzdWx0ID0gTmFnUnVsZUNvbXBsaWFuY2UgfCBOYWdSdWxlRmluZGluZ3M7XG5cbi8qKlxuICogSGVscGVyIGNsYXNzIHdpdGggbWV0aG9kcyBmb3IgcnVsZSBjcmVhdGlvblxuICovXG5leHBvcnQgY2xhc3MgTmFnUnVsZXMge1xuICAvKipcbiAgICogVXNlIGluIGNhc2VzIHdoZXJlIGEgcHJpbWl0aXZlIHZhbHVlIG11c3QgYmUga25vd24gdG8gcGFzcyBhIHJ1bGUuXG4gICAqIGh0dHBzOi8vZGV2ZWxvcGVyLm1vemlsbGEub3JnL2VuLVVTL2RvY3MvR2xvc3NhcnkvUHJpbWl0aXZlXG4gICAqIEBwYXJhbSBub2RlIFRoZSBDZm5SZXNvdXJjZSB0byBjaGVjay5cbiAgICogQHBhcmFtIHBhcmFtZXRlciBUaGUgdmFsdWUgdG8gYXR0ZW1wdCB0byByZXNvbHZlLlxuICAgKiBAcmV0dXJucyBSZXR1cm4gYSB2YWx1ZSBpZiByZXNvbHZlcyB0byBhIHByaW1pdGl2ZSBkYXRhIHR5cGUsIG90aGVyd2lzZSB0aHJvdyBhbiBlcnJvci5cbiAgICovXG4gIHN0YXRpYyByZXNvbHZlSWZQcmltaXRpdmUobm9kZTogQ2ZuUmVzb3VyY2UsIHBhcmFtZXRlcjogYW55KTogYW55IHtcbiAgICBjb25zdCByZXNvbHZlZFZhbHVlID0gU3RhY2sub2Yobm9kZSkucmVzb2x2ZShwYXJhbWV0ZXIpO1xuICAgIGlmIChyZXNvbHZlZFZhbHVlID09PSBPYmplY3QocmVzb2x2ZWRWYWx1ZSkpIHtcbiAgICAgIHRocm93IEVycm9yKFxuICAgICAgICBgVGhlIHBhcmFtZXRlciByZXNvbHZlZCB0byB0byBhIG5vbi1wcmltaXRpdmUgdmFsdWUgXCIke0pTT04uc3RyaW5naWZ5KFxuICAgICAgICAgIHJlc29sdmVkVmFsdWVcbiAgICAgICAgKX1cIiwgdGhlcmVmb3JlIHRoZSBydWxlIGNvdWxkIG5vdCBiZSB2YWxpZGF0ZWQuYFxuICAgICAgKTtcbiAgICB9IGVsc2Uge1xuICAgICAgcmV0dXJuIHJlc29sdmVkVmFsdWU7XG4gICAgfVxuICB9XG5cbiAgLyoqXG4gICAqIFVzZSBpbiBjYXNlcyB3aGVyZSBhIHRva2VuIHJlc29sdmVzIHRvIGFuIGludHJpbnNpYyBmdW5jdGlvbiBhbmQgdGhlIHJlZmVyZW5jZWQgcmVzb3VyY2UgbXVzdCBiZSBrbm93biB0byBwYXNzIGEgcnVsZS5cbiAgICogQHBhcmFtIG5vZGUgVGhlIENmblJlc291cmNlIHRvIGNoZWNrLlxuICAgKiBAcGFyYW0gcGFyYW1ldGVyIFRoZSB2YWx1ZSB0byBhdHRlbXB0IHRvIHJlc29sdmUuXG4gICAqIEByZXR1cm5zIFJldHVybiB0aGUgTG9naWNhbCByZXNvdXJjZSBJZCBpZiByZXNvbHZlcyB0byBhIGludHJpbnNpYyBmdW5jdGlvbiwgb3RoZXJ3aXNlIHRoZSByZXNvbHZlZCBwcm92aWRlZCB2YWx1ZS5cbiAgICovXG4gIHN0YXRpYyByZXNvbHZlUmVzb3VyY2VGcm9tSW5zdHJpbnNpYyhub2RlOiBDZm5SZXNvdXJjZSwgcGFyYW1ldGVyOiBhbnkpOiBhbnkge1xuICAgIGNvbnN0IHJlc29sdmVkVmFsdWUgPSBTdGFjay5vZihub2RlKS5yZXNvbHZlKHBhcmFtZXRlcik7XG4gICAgY29uc3QgcmVmID0gcmVzb2x2ZWRWYWx1ZT8uUmVmO1xuICAgIGNvbnN0IGdldEF0dCA9IHJlc29sdmVkVmFsdWU/LlsnRm46OkdldEF0dCddO1xuICAgIGlmIChyZWYgIT0gdW5kZWZpbmVkKSB7XG4gICAgICByZXR1cm4gcmVmO1xuICAgIH0gZWxzZSBpZiAoQXJyYXkuaXNBcnJheShnZXRBdHQpICYmIGdldEF0dC5sZW5ndGggPiAwKSB7XG4gICAgICByZXR1cm4gZ2V0QXR0WzBdO1xuICAgIH1cbiAgICByZXR1cm4gcmVzb2x2ZWRWYWx1ZTtcbiAgfVxufVxuIl19