"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const path_1 = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const nag_rules_1 = require("../../nag-rules");
const flatten_cfn_reference_1 = require("../../utils/flatten-cfn-reference");
/**
 * IAM users, roles, and groups do not use AWS managed policies
 * @param node the CfnResource to check
 */
exports.default = Object.defineProperty((node) => {
    if (node instanceof aws_iam_1.CfnGroup ||
        node instanceof aws_iam_1.CfnUser ||
        node instanceof aws_iam_1.CfnRole) {
        const managedPolicyArns = (aws_cdk_lib_1.Stack.of(node).resolve(node.managedPolicyArns));
        const findings = new Set();
        if (managedPolicyArns !== undefined) {
            managedPolicyArns
                .map((policy) => flatten_cfn_reference_1.flattenCfnReference(aws_cdk_lib_1.Stack.of(node).resolve(policy)))
                .filter((policy) => policy.includes(':iam::aws:'))
                .forEach((policy) => findings.add(`Policy::${policy}`));
        }
        return findings.size ? [...findings] : nag_rules_1.NagRuleCompliance.COMPLIANT;
    }
    else {
        return nag_rules_1.NagRuleCompliance.NOT_APPLICABLE;
    }
}, 'name', { value: path_1.parse(__filename).name });
//# sourceMappingURL=data:application/json;base64,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