# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .usage_snapshot import UsageSnapshot


class BillingPeriodUsage(UniversalBaseModel):
    """
    Complete usage data for a billing period.
    """

    period_id: str = pydantic.Field()
    """
    Billing period ID
    """

    period_start: dt.datetime = pydantic.Field()
    """
    Period start date
    """

    period_end: dt.datetime = pydantic.Field()
    """
    Period end date
    """

    status: str = pydantic.Field()
    """
    Period status (active, trial, ended, etc)
    """

    plan: str = pydantic.Field()
    """
    Subscription plan for this period
    """

    usage: UsageSnapshot = pydantic.Field()
    """
    Current usage snapshot
    """

    daily_usage: typing.Optional[typing.List[UsageSnapshot]] = pydantic.Field(default=None)
    """
    Daily snapshots for trend visualization
    """

    days_remaining: typing.Optional[int] = pydantic.Field(default=None)
    """
    Days left in period
    """

    is_current: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether this is the current period
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
