# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class OAuthBrowserAuthentication(UniversalBaseModel):
    """
    OAuth authentication via browser flow.
    """

    redirect_uri: typing.Optional[str] = pydantic.Field(default=None)
    """
    OAuth redirect URI
    """

    client_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    OAuth client ID (for custom apps)
    """

    client_secret: typing.Optional[str] = pydantic.Field(default=None)
    """
    OAuth client secret (for custom apps)
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
