# mypy-boto3-lex-models

[![PyPI - mypy-boto3-lex-models](https://img.shields.io/pypi/v/mypy-boto3-lex-models.svg?color=blue)](https://pypi.org/project/mypy-boto3-lex-models)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-lex-models.svg?color=blue)](https://pypi.org/project/mypy-boto3-lex-models)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.LexModelBuildingService 1.16.28](https://boto3.amazonaws.com/v1/documentation/api/1.16.28/reference/services/lex-models.html#LexModelBuildingService) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 4.0.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-lex-models](#mypy-boto3-lex-models)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `LexModelBuildingService` service.

```bash
python -m pip install boto3-stubs[lex-models]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[lex-models]` in your environment: `python -m pip install 'boto3-stubs[lex-models]'`

Both type checking and auto-complete should work for `LexModelBuildingService` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[lex-models]` in your environment: `python -m pip install 'boto3-stubs[lex-models]'`

Both type checking and auto-complete should work for `LexModelBuildingService` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[lex-models]` in your environment: `python -m pip install 'boto3-stubs[lex-models]'`
- Run `mypy` as usual

Type checking should work for `LexModelBuildingService` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[lex-models]` in your environment: `python -m pip install 'boto3-stubs[lex-models]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `LexModelBuildingService` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`LexModelBuildingServiceClient` provides annotations for `boto3.client("lex-models")`.

```python
import boto3

from mypy_boto3_lex_models import LexModelBuildingServiceClient

client: LexModelBuildingServiceClient = boto3.client("lex-models")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: LexModelBuildingServiceClient = session.client("lex-models")
```

### Paginators annotations

`mypy_boto3_lex_models.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_lex_models import LexModelBuildingServiceClient
from mypy_boto3_lex_models.paginator import (
    GetBotAliasesPaginator,
    GetBotChannelAssociationsPaginator,
    GetBotsPaginator,
    GetBotVersionsPaginator,
    GetBuiltinIntentsPaginator,
    GetBuiltinSlotTypesPaginator,
    GetIntentsPaginator,
    GetIntentVersionsPaginator,
    GetSlotTypesPaginator,
    GetSlotTypeVersionsPaginator,
)

client: LexModelBuildingServiceClient = boto3.client("lex-models")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
get_bot_aliases_paginator: GetBotAliasesPaginator = client.get_paginator("get_bot_aliases")
get_bot_channel_associations_paginator: GetBotChannelAssociationsPaginator = client.get_paginator("get_bot_channel_associations")
get_bot_versions_paginator: GetBotVersionsPaginator = client.get_paginator("get_bot_versions")
get_bots_paginator: GetBotsPaginator = client.get_paginator("get_bots")
get_builtin_intents_paginator: GetBuiltinIntentsPaginator = client.get_paginator("get_builtin_intents")
get_builtin_slot_types_paginator: GetBuiltinSlotTypesPaginator = client.get_paginator("get_builtin_slot_types")
get_intent_versions_paginator: GetIntentVersionsPaginator = client.get_paginator("get_intent_versions")
get_intents_paginator: GetIntentsPaginator = client.get_paginator("get_intents")
get_slot_type_versions_paginator: GetSlotTypeVersionsPaginator = client.get_paginator("get_slot_type_versions")
get_slot_types_paginator: GetSlotTypesPaginator = client.get_paginator("get_slot_types")
```







### Typed dictionations

`mypy_boto3_lex_models.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_lex_models.type_defs import (
    BotAliasMetadataTypeDef,
    BotChannelAssociationTypeDef,
    BotMetadataTypeDef,
    BuiltinIntentMetadataTypeDef,
    BuiltinIntentSlotTypeDef,
    BuiltinSlotTypeMetadataTypeDef,
    CodeHookTypeDef,
    ConversationLogsRequestTypeDef,
    ConversationLogsResponseTypeDef,
    CreateBotVersionResponseTypeDef,
    CreateIntentVersionResponseTypeDef,
    CreateSlotTypeVersionResponseTypeDef,
    EnumerationValueTypeDef,
    FollowUpPromptTypeDef,
    FulfillmentActivityTypeDef,
    GetBotAliasesResponseTypeDef,
    GetBotAliasResponseTypeDef,
    GetBotChannelAssociationResponseTypeDef,
    GetBotChannelAssociationsResponseTypeDef,
    GetBotResponseTypeDef,
    GetBotsResponseTypeDef,
    GetBotVersionsResponseTypeDef,
    GetBuiltinIntentResponseTypeDef,
    GetBuiltinIntentsResponseTypeDef,
    GetBuiltinSlotTypesResponseTypeDef,
    GetExportResponseTypeDef,
    GetImportResponseTypeDef,
    GetIntentResponseTypeDef,
    GetIntentsResponseTypeDef,
    GetIntentVersionsResponseTypeDef,
    GetSlotTypeResponseTypeDef,
    GetSlotTypesResponseTypeDef,
    GetSlotTypeVersionsResponseTypeDef,
    GetUtterancesViewResponseTypeDef,
    InputContextTypeDef,
    IntentMetadataTypeDef,
    IntentTypeDef,
    KendraConfigurationTypeDef,
    ListTagsForResourceResponseTypeDef,
    LogSettingsRequestTypeDef,
    LogSettingsResponseTypeDef,
    MessageTypeDef,
    OutputContextTypeDef,
    PaginatorConfigTypeDef,
    PromptTypeDef,
    PutBotAliasResponseTypeDef,
    PutBotResponseTypeDef,
    PutIntentResponseTypeDef,
    PutSlotTypeResponseTypeDef,
    SlotDefaultValueSpecTypeDef,
    SlotDefaultValueTypeDef,
    SlotTypeConfigurationTypeDef,
    SlotTypeDef,
    SlotTypeMetadataTypeDef,
    SlotTypeRegexConfigurationTypeDef,
    StartImportResponseTypeDef,
    StatementTypeDef,
    TagTypeDef,
    UtteranceDataTypeDef,
    UtteranceListTypeDef,
)

def get_structure() -> BotAliasMetadataTypeDef:
    return {
      ...
    }
```
