import { SchemaBindOptions, ISchema, ISchemaConfig, IGraphqlApi } from 'aws-cdk-lib/aws-appsync';
import { IIntermediateType } from './schema-base';
import { Field, ResolvableField } from './schema-field';
import { ObjectType } from './schema-intermediate';
export * from './schema-base';
export * from './schema-field';
export * from './schema-intermediate';
export * from './source-api-association-merge';
export declare class CodeFirstSchema implements ISchema {
    /**
     * The definition for this schema
     */
    definition: string;
    private query?;
    private mutation?;
    private subscription?;
    private types;
    constructor();
    /**
     * Called when the GraphQL Api is initialized to allow this object to bind
     * to the stack.
     *
     * @param api The binding GraphQL Api
     */
    bind(api: IGraphqlApi, _options?: SchemaBindOptions): ISchemaConfig;
    /**
     * Escape hatch to add to Schema as desired. Will always result
     * in a newline.
     *
     * @param addition the addition to add to schema
     * @param delimiter the delimiter between schema and addition
     * @default - ''
     *
     */
    addToSchema(addition: string, delimiter?: string): void;
    /**
     * Add a query field to the schema's Query. CDK will create an
     * Object Type called 'Query'. For example,
     *
     * type Query {
     *   fieldName: Field.returnType
     * }
     *
     * @param fieldName the name of the query
     * @param field the resolvable field to for this query
     */
    addQuery(fieldName: string, field: ResolvableField): ObjectType;
    /**
     * Add a mutation field to the schema's Mutation. CDK will create an
     * Object Type called 'Mutation'. For example,
     *
     * type Mutation {
     *   fieldName: Field.returnType
     * }
     *
     * @param fieldName the name of the Mutation
     * @param field the resolvable field to for this Mutation
     */
    addMutation(fieldName: string, field: ResolvableField): ObjectType;
    /**
     * Add a subscription field to the schema's Subscription. CDK will create an
     * Object Type called 'Subscription'. For example,
     *
     * type Subscription {
     *   fieldName: Field.returnType
     * }
     *
     * @param fieldName the name of the Subscription
     * @param field the resolvable field to for this Subscription
     */
    addSubscription(fieldName: string, field: Field): ObjectType;
    /**
     * Add type to the schema
     *
     * @param type the intermediate type to add to the schema
     *
     */
    addType(type: IIntermediateType): IIntermediateType;
    /**
     * Set the root types of this schema if they are defined.
     *
     * For example:
     * schema {
     *   query: Query
     *   mutation: Mutation
     *   subscription: Subscription
     * }
     */
    private declareSchema;
}
