"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isComplete = exports.onEvent = void 0;
// eslint-disable-next-line import/no-extraneous-dependencies
const client_appsync_1 = require("@aws-sdk/client-appsync");
const appSyncClient = new client_appsync_1.AppSyncClient();
async function onEvent(event) {
    const params = {
        associationId: event.ResourceProperties.associationId,
        mergedApiIdentifier: event.ResourceProperties.mergedApiIdentifier,
    };
    switch (event.RequestType) {
        case 'Update':
        case 'Create':
            return performSchemaMerge(params);
        case 'Delete':
        default:
            return {
                ...params,
                PhysicalResourceId: params.associationId,
            };
    }
}
exports.onEvent = onEvent;
async function isComplete(event) {
    const params = {
        associationId: event.ResourceProperties.associationId,
        mergedApiIdentifier: event.ResourceProperties.mergedApiIdentifier,
    };
    return getSchemaMergeStatus(params);
}
exports.isComplete = isComplete;
async function performSchemaMerge(params) {
    const command = new client_appsync_1.StartSchemaMergeCommand(params);
    try {
        const response = await appSyncClient.send(command);
        switch (response.sourceApiAssociationStatus) {
            case client_appsync_1.SourceApiAssociationStatus.MERGE_SCHEDULED:
            case client_appsync_1.SourceApiAssociationStatus.MERGE_IN_PROGRESS:
            case client_appsync_1.SourceApiAssociationStatus.MERGE_SUCCESS:
                break;
            default:
                throw new Error('Unexpected status after starting schema merge:' + response.sourceApiAssociationStatus);
        }
        return {
            ...params,
            PhysicalResourceId: params.associationId,
            sourceApiAssociationStatus: response.sourceApiAssociationStatus,
        };
    }
    catch (error) {
        // eslint-disable-next-line no-console
        console.error('An error occurred submitting the schema merge', error);
        throw error;
    }
}
async function getSchemaMergeStatus(params) {
    const command = new client_appsync_1.GetSourceApiAssociationCommand(params);
    var response;
    try {
        response = await appSyncClient.send(command);
    }
    catch (error) {
        // eslint-disable-next-line no-console
        console.error('Error starting the schema merge operation', error);
        throw error;
    }
    if (!response.sourceApiAssociation) {
        throw new Error(`SourceApiAssociation ${params.associationId} not found.`);
    }
    switch (response.sourceApiAssociation.sourceApiAssociationStatus) {
        case client_appsync_1.SourceApiAssociationStatus.MERGE_SCHEDULED:
        case client_appsync_1.SourceApiAssociationStatus.MERGE_IN_PROGRESS:
        case client_appsync_1.SourceApiAssociationStatus.DELETION_SCHEDULED:
        case client_appsync_1.SourceApiAssociationStatus.DELETION_IN_PROGRESS:
            return {
                IsComplete: false,
            };
        case client_appsync_1.SourceApiAssociationStatus.MERGE_SUCCESS:
            return {
                IsComplete: true,
                Data: {
                    ...params,
                    sourceApiAssociationStatus: response.sourceApiAssociation.sourceApiAssociationStatus,
                    sourceApiAssociationStatusDetail: response.sourceApiAssociation.sourceApiAssociationStatusDetail,
                    lastSuccessfulMergeDate: response.sourceApiAssociation.lastSuccessfulMergeDate?.toString(),
                },
            };
        case client_appsync_1.SourceApiAssociationStatus.MERGE_FAILED:
        case client_appsync_1.SourceApiAssociationStatus.DELETION_FAILED:
        case client_appsync_1.SourceApiAssociationStatus.AUTO_MERGE_SCHEDULE_FAILED:
            throw new Error(`Source API Association: ${response.sourceApiAssociation.associationArn} failed to merge with status: `
                + `${response.sourceApiAssociation.sourceApiAssociationStatus} and message: ${response.sourceApiAssociation.sourceApiAssociationStatusDetail}`);
        default:
            throw new Error(`Unexpected source api association status: ${response.sourceApiAssociation.sourceApiAssociationStatus}`);
    }
}
//# sourceMappingURL=data:application/json;base64,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