"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResolvableField = exports.Field = exports.GraphqlType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const schema_base_1 = require("./schema-base");
/**
 * The GraphQL Types in AppSync's GraphQL. GraphQL Types are the
 * building blocks for object types, queries, mutations, etc. They are
 * types like String, Int, Id or even Object Types you create.
 *
 * i.e. `String`, `String!`, `[String]`, `[String!]`, `[String]!`
 *
 * GraphQL Types are used to define the entirety of schema.
 */
class GraphqlType {
    constructor(type, options) {
        this.type = type;
        this.isList = options?.isList ?? false;
        this.isRequired = options?.isRequired ?? false;
        this.isRequiredList = options?.isRequiredList ?? false;
        this.intermediateType = options?.intermediateType;
    }
    /**
     * `ID` scalar type is a unique identifier. `ID` type is serialized similar to `String`.
     *
     * Often used as a key for a cache and not intended to be human-readable.
     *
     * @param options the options to configure this attribute
     * - isList
     * - isRequired
     * - isRequiredList
     */
    static id(options) {
        return new GraphqlType(schema_base_1.Type.ID, options);
    }
    /**
     * `String` scalar type is a free-form human-readable text.
     *
     * @param options the options to configure this attribute
     * - isList
     * - isRequired
     * - isRequiredList
     */
    static string(options) {
        return new GraphqlType(schema_base_1.Type.STRING, options);
    }
    /**
     * `Int` scalar type is a signed non-fractional numerical value.
     *
     * @param options the options to configure this attribute
     * - isList
     * - isRequired
     * - isRequiredList
     */
    static int(options) {
        return new GraphqlType(schema_base_1.Type.INT, options);
    }
    /**
     * `Float` scalar type is a signed double-precision fractional value.
     *
     * @param options the options to configure this attribute
     * - isList
     * - isRequired
     * - isRequiredList
     */
    static float(options) {
        return new GraphqlType(schema_base_1.Type.FLOAT, options);
    }
    /**
     * `Boolean` scalar type is a boolean value: true or false.
     *
     * @param options the options to configure this attribute
     * - isList
     * - isRequired
     * - isRequiredList
     */
    static boolean(options) {
        return new GraphqlType(schema_base_1.Type.BOOLEAN, options);
    }
    /**
     * `AWSDate` scalar type represents a valid extended `ISO 8601 Date` string.
     *
     * In other words, accepts date strings in the form of `YYYY-MM-DD`. It accepts time zone offsets.
     *
     * @param options the options to configure this attribute
     * - isList
     * - isRequired
     * - isRequiredList
     */
    static awsDate(options) {
        return new GraphqlType(schema_base_1.Type.AWS_DATE, options);
    }
    /**
     * `AWSTime` scalar type represents a valid extended `ISO 8601 Time` string.
     *
     * In other words, accepts date strings in the form of `hh:mm:ss.sss`. It accepts time zone offsets.
     *
     * @param options the options to configure this attribute
     * - isList
     * - isRequired
     * - isRequiredList
     */
    static awsTime(options) {
        return new GraphqlType(schema_base_1.Type.AWS_TIME, options);
    }
    /**
     * `AWSDateTime` scalar type represents a valid extended `ISO 8601 DateTime` string.
     *
     * In other words, accepts date strings in the form of `YYYY-MM-DDThh:mm:ss.sssZ`. It accepts time zone offsets.
     *
     * @param options the options to configure this attribute
     * - isList
     * - isRequired
     * - isRequiredList
     */
    static awsDateTime(options) {
        return new GraphqlType(schema_base_1.Type.AWS_DATE_TIME, options);
    }
    /**
     * `AWSTimestamp` scalar type represents the number of seconds since `1970-01-01T00:00Z`.
     *
     * Timestamps are serialized and deserialized as numbers.
     *
     * @param options the options to configure this attribute
     * - isList
     * - isRequired
     * - isRequiredList
     */
    static awsTimestamp(options) {
        return new GraphqlType(schema_base_1.Type.AWS_TIMESTAMP, options);
    }
    /**
     * `AWSEmail` scalar type represents an email address string (i.e.`username@example.com`)
     *
     * @param options the options to configure this attribute
     * - isList
     * - isRequired
     * - isRequiredList
     */
    static awsEmail(options) {
        return new GraphqlType(schema_base_1.Type.AWS_EMAIL, options);
    }
    /**
     * `AWSJson` scalar type represents a JSON string.
     *
     * @param options the options to configure this attribute
     * - isList
     * - isRequired
     * - isRequiredList
     */
    static awsJson(options) {
        return new GraphqlType(schema_base_1.Type.AWS_JSON, options);
    }
    /**
     * `AWSURL` scalar type represetns a valid URL string.
     *
     * URLs wihtout schemes or contain double slashes are considered invalid.
     *
     * @param options the options to configure this attribute
     * - isList
     * - isRequired
     * - isRequiredList
     */
    static awsUrl(options) {
        return new GraphqlType(schema_base_1.Type.AWS_URL, options);
    }
    /**
     * `AWSPhone` scalar type represents a valid phone number. Phone numbers maybe be whitespace delimited or hyphenated.
     *
     * The number can specify a country code at the beginning, but is not required for US phone numbers.
     *
     * @param options the options to configure this attribute
     * - isList
     * - isRequired
     * - isRequiredList
     */
    static awsPhone(options) {
        return new GraphqlType(schema_base_1.Type.AWS_PHONE, options);
    }
    /**
     * `AWSIPAddress` scalar type respresents a valid `IPv4` of `IPv6` address string.
     *
     * @param options the options to configure this attribute
     * - isList
     * - isRequired
     * - isRequiredList
     */
    static awsIpAddress(options) {
        return new GraphqlType(schema_base_1.Type.AWS_IP_ADDRESS, options);
    }
    /**
     * an intermediate type to be added as an attribute
     * (i.e. an interface or an object type)
     *
     * @param options the options to configure this attribute
     * - isList
     * - isRequired
     * - isRequiredList
     * - intermediateType
     */
    static intermediate(options) {
        if (!options?.intermediateType) {
            throw new Error('GraphQL Type of interface must be configured with corresponding Intermediate Type');
        }
        return new GraphqlType(schema_base_1.Type.INTERMEDIATE, options);
    }
    /**
     * Generate the string for this attribute
     */
    toString() {
        // If an Object Type, we use the name of the Object Type
        let type = this.intermediateType ? this.intermediateType?.name : this.type;
        // If configured as required, the GraphQL Type becomes required
        type = this.isRequired ? `${type}!` : type;
        // If configured with isXxxList, the GraphQL Type becomes a list
        type = this.isList || this.isRequiredList ? `[${type}]` : type;
        // If configured with isRequiredList, the list becomes required
        type = this.isRequiredList ? `${type}!` : type;
        return type;
    }
    /**
     * Generate the arguments for this field
     */
    argsToString() {
        return '';
    }
    /**
     * Generate the directives for this field
     */
    directivesToString(_modes) {
        return '';
    }
}
exports.GraphqlType = GraphqlType;
_a = JSII_RTTI_SYMBOL_1;
GraphqlType[_a] = { fqn: "awscdk-appsync-utils.GraphqlType", version: "0.0.438" };
/**
 * Fields build upon Graphql Types and provide typing
 * and arguments.
 */
class Field extends GraphqlType {
    constructor(options) {
        const props = {
            isList: options.returnType.isList,
            isRequired: options.returnType.isRequired,
            isRequiredList: options.returnType.isRequiredList,
            intermediateType: options.returnType.intermediateType,
        };
        super(options.returnType.type, props);
        this.fieldOptions = options;
    }
    /**
     * Generate the args string of this resolvable field
     */
    argsToString() {
        if (!this.fieldOptions || !this.fieldOptions.args) {
            return '';
        }
        return Object.keys(this.fieldOptions.args).reduce((acc, key) => `${acc}${key}: ${this.fieldOptions?.args?.[key].toString()} `, '(').slice(0, -1) + ')';
    }
    /**
     * Generate the directives for this field
     */
    directivesToString(modes) {
        if (!this.fieldOptions || !this.fieldOptions.directives) {
            return '';
        }
        return this.fieldOptions.directives.reduce((acc, directive) => `${acc}${directive._bindToAuthModes(modes).toString()} `, '\n  ').slice(0, -1);
    }
}
exports.Field = Field;
_b = JSII_RTTI_SYMBOL_1;
Field[_b] = { fqn: "awscdk-appsync-utils.Field", version: "0.0.438" };
/**
 * Resolvable Fields build upon Graphql Types and provide fields
 * that can resolve into operations on a data source.
 */
class ResolvableField extends Field {
    constructor(options) {
        const props = {
            returnType: options.returnType,
            args: options.args,
        };
        super(props);
        this.fieldOptions = options;
    }
}
exports.ResolvableField = ResolvableField;
_c = JSII_RTTI_SYMBOL_1;
ResolvableField[_c] = { fqn: "awscdk-appsync-utils.ResolvableField", version: "0.0.438" };
//# sourceMappingURL=data:application/json;base64,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