"""
This type stub file was generated by pyright.
"""

import redis.asyncio as redis
from dataclasses import dataclass
from datetime import datetime, timedelta
from typing import Optional
from aiohttp.web_request import Request
from aiohttp.web_response import Response

def cookie_expiry(dt: datetime) -> str:
  ...

async def secure_hset(redis: redis.Redis, name: str, secure_value: str) -> str:
  """
  Using a hash map called {name} this stores the secure_value under a randomly named key
  which is returned. The main usecase is storing the random key in a browser cookie
  that the backend can later lookup to find teh real value.
  """
  ...

async def secure_hget(redis: redis.Redis, name: str, cookie_value: str) -> Optional[str]:
  """
  Using a hash map called {name} this retrieves the secure_value via the randomly named
  cookie value. The main usecase is storing the random key in a browser cookie
  that the backend can later lookup to find teh real value.
  """
  ...

@dataclass
class PlainCookie:
  """
  A cookie that JS can read
  """
  name: str
  expiry_delta: timedelta
  def set(self, res: Response, cookie_value: str, expiry_delta: timedelta | None = ...) -> None:
    ...
  
  def get(self, req: Request) -> str | None:
    ...
  
  def unset(self, res: Response) -> None:
    ...
  


@dataclass
class HiddenCookie(PlainCookie):
  """
  A cookie {name} that JS cannot read, along with a companion cookie {name}_is_set that JS can
  query to see if the hidden cookie is currently set.
  """
  def set(self, res: Response, cookie_value: str, expiry_delta: timedelta | None = ...) -> None:
    ...
  
  def get(self, req: Request) -> str | None:
    ...
  
  def unset(self, res: Response) -> None:
    ...
  


@dataclass
class RedisHiddenCookie(HiddenCookie):
  """
  A cookie {name} that JS cannot read, along with a companion cookie {name}_is_set that JS can
  query to see if the hidden cookie is currently set. The value of the hidden cookie is a random
  value that can be used by the backend to lookup a truly secret value.
  """
  async def set(self, redis: redis.Redis, res: Response, secure_value: str, expiry_delta: timedelta | None = ...) -> None:
    ...
  
  async def get(self, redis: redis.Redis, req: Request) -> str | None:
    ...
  


