"""
This type stub file was generated by pyright.
"""

import asyncpg
import pydantic
from typing import Annotated, Any, Dict, List, Optional, Tuple, Type, TypeVar
from aiohttp.web import HTTPError, HTTPSuccessful
from alxhttp.typescript.type_checks import TypeType
from alxhttp.typescript.types import TSEnum

def recursive_json_loads(type: TypeType, data) -> Any:
  """
  json loads anything that requires recursive model verification
  """
  ...

BaseModelType = TypeVar('BaseModelType', bound='BaseModel')
def replace_datetime_values_with_timestamps(value: Dict | List) -> Dict | List:
  ...

class BaseModel(pydantic.BaseModel):
  """
  A Pydantic model with some opinions:
  - extra values are not allowed
  - datetimes are serialized as float timestamps
  """
  model_config = ...
  @pydantic.field_serializer('*', mode='wrap')
  def datetimes_as_timestamps(self, value: Any, nxt: pydantic.SerializerFunctionWrapHandler) -> Any:
    ...
  
  @classmethod
  def from_record(cls: Type[BaseModelType], record: asyncpg.Record | None) -> BaseModelType:
    ...
  
  def exception(self, status_code: int = ...): # -> BaseModelException[Self]:
    """
    Wrap the model in an exception that will render as JSON
    """
    ...
  


class Empty(BaseModel):
  ...


class ErrorModel(BaseModel):
  """
  Our base class for 4XX/5XX responses. 'error' is used to allow us to treat this as
  a discriminated union and switch on it in typescript.
  """
  error: str = ...
  status_code: int = ...
  request_id: Optional[str] = ...
  def exception(self): # -> ErrorModelException[Self]:
    """
    Wrap the model in an exception that will render as JSON

    Intentionally does not take a status_code argument. override it on your derived class instead
    """
    ...
  


BaseModelType = TypeVar('BaseModelType', bound=BaseModel)
class BaseModelException[BaseModelType](HTTPSuccessful):
  """
  Pydantic models can't be used in mixin-inheritance so instead if we want to
  raise a model as an exception we have to store it inside a real exception.

  To help the type hinting work this is a generic class parameterized over
  your derived error type.
  """
  status_code: int = ...
  def __init__(self, model: BaseModelType, status_code: int = ...) -> None:
    ...
  


ErrorModelType = TypeVar('ErrorModelType', bound=ErrorModel)
class ErrorModelException[ErrorModelType](HTTPError):
  """
  Pydantic models can't be used in mixin-inheritance so instead if we want to
  raise a model as an exception we have to store it inside a real exception.

  To help the type hinting work this is a generic class parameterized over
  your derived error type.
  """
  status_code: int = ...
  def __init__(self, model: ErrorModelType) -> None:
    ...
  


class PydanticErrorDetails(BaseModel):
  """
  How a pydantic validation error is represented to the UI
  """
  type: str
  loc: List[int | str]
  msg: str
  input: str
  ctx: Optional[Dict[str, str]] = ...


class PydanticValidationError(ErrorModel):
  """
  How a pydantic validation error is represented to the UI
  """
  error: Annotated[str, TSEnum('ErrorCode', 'PydanticValidationError')] = ...
  errors: List[PydanticErrorDetails]


def fix_loc_list(loc: Tuple[int | str, ...]) -> List[int | str]:
  ...

