# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.collection import Collection
from ..types.filter import Filter
from ..types.query_expansion_strategy import QueryExpansionStrategy
from ..types.response_type import ResponseType
from ..types.search_response import SearchResponse
from ..types.source_connection_job import SourceConnectionJob
from .raw_client import AsyncRawCollectionsClient, RawCollectionsClient
from .types.search_request_search_method import SearchRequestSearchMethod

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class CollectionsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawCollectionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawCollectionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawCollectionsClient
        """
        return self._raw_client

    def list(
        self,
        *,
        skip: typing.Optional[int] = None,
        limit: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[Collection]:
        """
        List all collections that belong to your organization.

        Parameters
        ----------
        skip : typing.Optional[int]
            Number of collections to skip for pagination

        limit : typing.Optional[int]
            Maximum number of collections to return (1-1000)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Collection]
            Successful Response

        Examples
        --------
        from airweave import AirweaveSDK

        client = AirweaveSDK(
            api_key="YOUR_API_KEY",
        )
        client.collections.list()
        """
        _response = self._raw_client.list(skip=skip, limit=limit, request_options=request_options)
        return _response.data

    def create(
        self,
        *,
        name: str,
        readable_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Collection:
        """
        Create a new collection.

        The newly created collection is initially empty and does not contain any data
        until you explicitly add source connections to it.

        Parameters
        ----------
        name : str
            Human-readable display name for the collection. This appears in the UI and should clearly describe the data contained within (e.g., 'Finance Data').

        readable_id : typing.Optional[str]
            URL-safe unique identifier used in API endpoints. Must contain only lowercase letters, numbers, and hyphens. If not provided, it will be automatically generated from the collection name with a random suffix for uniqueness (e.g., 'finance-data-ab123').

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Collection
            Successful Response

        Examples
        --------
        from airweave import AirweaveSDK

        client = AirweaveSDK(
            api_key="YOUR_API_KEY",
        )
        client.collections.create(
            name="Finance Data",
            readable_id="finance-data-reports",
        )
        """
        _response = self._raw_client.create(name=name, readable_id=readable_id, request_options=request_options)
        return _response.data

    def get(self, readable_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Collection:
        """
        Retrieve a specific collection by its readable ID.

        Parameters
        ----------
        readable_id : str
            The unique readable identifier of the collection (e.g., 'finance-data-ab123')

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Collection
            Successful Response

        Examples
        --------
        from airweave import AirweaveSDK

        client = AirweaveSDK(
            api_key="YOUR_API_KEY",
        )
        client.collections.get(
            readable_id="readable_id",
        )
        """
        _response = self._raw_client.get(readable_id, request_options=request_options)
        return _response.data

    def update(
        self,
        readable_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Collection:
        """
        Update a collection's properties.

        Modifies the display name of an existing collection.
        Note that the readable ID cannot be changed after creation to maintain stable
        API endpoints and preserve any existing integrations or bookmarks.

        Parameters
        ----------
        readable_id : str
            The unique readable identifier of the collection to update

        name : typing.Optional[str]
            Updated display name for the collection. Must be between 4 and 64 characters.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Collection
            Successful Response

        Examples
        --------
        from airweave import AirweaveSDK

        client = AirweaveSDK(
            api_key="YOUR_API_KEY",
        )
        client.collections.update(
            readable_id="readable_id",
            name="Updated Finance Data",
        )
        """
        _response = self._raw_client.update(readable_id, name=name, request_options=request_options)
        return _response.data

    def delete(self, readable_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Collection:
        """
        Delete a collection and all associated data.

        Permanently removes a collection from your organization including all synced data
        from the destination systems. All source connections within this collection
        will also be deleted as part of the cleanup process. This action cannot be undone.

        Parameters
        ----------
        readable_id : str
            The unique readable identifier of the collection to delete

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Collection
            Successful Response

        Examples
        --------
        from airweave import AirweaveSDK

        client = AirweaveSDK(
            api_key="YOUR_API_KEY",
        )
        client.collections.delete(
            readable_id="readable_id",
        )
        """
        _response = self._raw_client.delete(readable_id, request_options=request_options)
        return _response.data

    def search(
        self,
        readable_id: str,
        *,
        query: str,
        response_type: typing.Optional[ResponseType] = None,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        recency_bias: typing.Optional[float] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SearchResponse:
        """
        Search across all data sources within the specified collection.

        This GET endpoint provides basic search functionality. For advanced filtering
        and options, use the POST /search endpoint.

        Parameters
        ----------
        readable_id : str
            The unique readable identifier of the collection to search

        query : str
            The search query text to find relevant documents and data

        response_type : typing.Optional[ResponseType]
            Format of the response: 'raw' returns search results, 'completion' returns AI-generated answers

        limit : typing.Optional[int]
            Maximum number of results to return

        offset : typing.Optional[int]
            Number of results to skip for pagination

        recency_bias : typing.Optional[float]
            How much to weigh recency vs similarity (0..1). 0 = no recency effect; 1 = rank by recency only.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SearchResponse
            Successful Response

        Examples
        --------
        from airweave import AirweaveSDK

        client = AirweaveSDK(
            api_key="YOUR_API_KEY",
        )
        client.collections.search(
            readable_id="readable_id",
            query="customer payment issues",
        )
        """
        _response = self._raw_client.search(
            readable_id,
            query=query,
            response_type=response_type,
            limit=limit,
            offset=offset,
            recency_bias=recency_bias,
            request_options=request_options,
        )
        return _response.data

    def search_advanced(
        self,
        readable_id: str,
        *,
        query: str,
        filter: typing.Optional[Filter] = OMIT,
        offset: typing.Optional[int] = OMIT,
        limit: typing.Optional[int] = OMIT,
        score_threshold: typing.Optional[float] = OMIT,
        response_type: typing.Optional[ResponseType] = OMIT,
        search_method: typing.Optional[SearchRequestSearchMethod] = OMIT,
        recency_bias: typing.Optional[float] = OMIT,
        expansion_strategy: typing.Optional[QueryExpansionStrategy] = OMIT,
        enable_reranking: typing.Optional[bool] = OMIT,
        enable_query_interpretation: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SearchResponse:
        """
        Advanced search with comprehensive filtering and options.

        This endpoint supports:
        - Metadata filtering using Qdrant's native filter syntax
        - Pagination with offset and limit
        - Score threshold filtering
        - Query expansion strategies (default: AUTO, generates up to 4 variations)
        - Automatic filter extraction from natural language (default: ON)
        - LLM-based result reranking (default: ON)

        Default behavior:
        - Query expansion: ON (AUTO strategy)
        - Query interpretation: ON (extracts filters from natural language)
        - Reranking: ON (improves relevance using LLM)
        - Score threshold: None (no filtering)

        To disable features, explicitly set:
        - enable_reranking: false
        - enable_query_interpretation: false
        - expansion_strategy: "no_expansion"

        Parameters
        ----------
        readable_id : str
            The unique readable identifier of the collection to search

        query : str
            The search query text

        filter : typing.Optional[Filter]
            Qdrant native filter for metadata-based filtering

        offset : typing.Optional[int]
            Number of results to skip (DEFAULT: 0)

        limit : typing.Optional[int]
            Maximum number of results to return (DEFAULT: 20)

        score_threshold : typing.Optional[float]
            Minimum similarity score threshold (DEFAULT: None - no filtering)

        response_type : typing.Optional[ResponseType]
            Type of response - 'raw' or 'completion' (DEFAULT: 'raw')

        search_method : typing.Optional[SearchRequestSearchMethod]
            Search method to use (DEFAULT: 'hybrid' - combines neural + BM25)

        recency_bias : typing.Optional[float]
            How much document age penalizes the similarity score (0..1). 0 = no age penalty (pure similarity); 0.5 = old docs lose up to 50% of their score; 1 = old docs get zero score (pure recency). Applied as: score × (1 - bias + bias × age_factor). Works within top ~10,000 semantic matches. DEFAULT: 0.3

        expansion_strategy : typing.Optional[QueryExpansionStrategy]
            Query expansion strategy (DEFAULT: 'auto' - generates up to 4 query variations). Options: 'auto', 'llm', 'no_expansion'

        enable_reranking : typing.Optional[bool]
            Enable LLM-based reranking to improve result relevance (DEFAULT: True - enabled, set to False to disable)

        enable_query_interpretation : typing.Optional[bool]
            Enable automatic filter extraction from natural language query (DEFAULT: True - enabled, set to False to disable)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SearchResponse
            Successful Response

        Examples
        --------
        from airweave import AirweaveSDK, FieldCondition, Filter

        client = AirweaveSDK(
            api_key="YOUR_API_KEY",
        )
        client.collections.search_advanced(
            readable_id="readable_id",
            query="customer payment issues",
            filter=Filter(
                must=FieldCondition(
                    key="key",
                ),
            ),
            limit=10,
            score_threshold=0.7,
            response_type="completion",
        )
        """
        _response = self._raw_client.search_advanced(
            readable_id,
            query=query,
            filter=filter,
            offset=offset,
            limit=limit,
            score_threshold=score_threshold,
            response_type=response_type,
            search_method=search_method,
            recency_bias=recency_bias,
            expansion_strategy=expansion_strategy,
            enable_reranking=enable_reranking,
            enable_query_interpretation=enable_query_interpretation,
            request_options=request_options,
        )
        return _response.data

    def refresh_all_source_connections(
        self, readable_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[SourceConnectionJob]:
        """
        Trigger data synchronization for all source connections in the collection.

        The sync jobs run asynchronously in the background, so this endpoint
        returns immediately with job details that you can use to track progress. You can
        monitor the status of individual data synchronization using the source connection
        endpoints.

        Parameters
        ----------
        readable_id : str
            The unique readable identifier of the collection to refresh

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[SourceConnectionJob]
            Successful Response

        Examples
        --------
        from airweave import AirweaveSDK

        client = AirweaveSDK(
            api_key="YOUR_API_KEY",
        )
        client.collections.refresh_all_source_connections(
            readable_id="readable_id",
        )
        """
        _response = self._raw_client.refresh_all_source_connections(readable_id, request_options=request_options)
        return _response.data


class AsyncCollectionsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawCollectionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawCollectionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawCollectionsClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        skip: typing.Optional[int] = None,
        limit: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[Collection]:
        """
        List all collections that belong to your organization.

        Parameters
        ----------
        skip : typing.Optional[int]
            Number of collections to skip for pagination

        limit : typing.Optional[int]
            Maximum number of collections to return (1-1000)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Collection]
            Successful Response

        Examples
        --------
        import asyncio

        from airweave import AsyncAirweaveSDK

        client = AsyncAirweaveSDK(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.collections.list()


        asyncio.run(main())
        """
        _response = await self._raw_client.list(skip=skip, limit=limit, request_options=request_options)
        return _response.data

    async def create(
        self,
        *,
        name: str,
        readable_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Collection:
        """
        Create a new collection.

        The newly created collection is initially empty and does not contain any data
        until you explicitly add source connections to it.

        Parameters
        ----------
        name : str
            Human-readable display name for the collection. This appears in the UI and should clearly describe the data contained within (e.g., 'Finance Data').

        readable_id : typing.Optional[str]
            URL-safe unique identifier used in API endpoints. Must contain only lowercase letters, numbers, and hyphens. If not provided, it will be automatically generated from the collection name with a random suffix for uniqueness (e.g., 'finance-data-ab123').

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Collection
            Successful Response

        Examples
        --------
        import asyncio

        from airweave import AsyncAirweaveSDK

        client = AsyncAirweaveSDK(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.collections.create(
                name="Finance Data",
                readable_id="finance-data-reports",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(name=name, readable_id=readable_id, request_options=request_options)
        return _response.data

    async def get(self, readable_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Collection:
        """
        Retrieve a specific collection by its readable ID.

        Parameters
        ----------
        readable_id : str
            The unique readable identifier of the collection (e.g., 'finance-data-ab123')

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Collection
            Successful Response

        Examples
        --------
        import asyncio

        from airweave import AsyncAirweaveSDK

        client = AsyncAirweaveSDK(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.collections.get(
                readable_id="readable_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(readable_id, request_options=request_options)
        return _response.data

    async def update(
        self,
        readable_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Collection:
        """
        Update a collection's properties.

        Modifies the display name of an existing collection.
        Note that the readable ID cannot be changed after creation to maintain stable
        API endpoints and preserve any existing integrations or bookmarks.

        Parameters
        ----------
        readable_id : str
            The unique readable identifier of the collection to update

        name : typing.Optional[str]
            Updated display name for the collection. Must be between 4 and 64 characters.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Collection
            Successful Response

        Examples
        --------
        import asyncio

        from airweave import AsyncAirweaveSDK

        client = AsyncAirweaveSDK(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.collections.update(
                readable_id="readable_id",
                name="Updated Finance Data",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(readable_id, name=name, request_options=request_options)
        return _response.data

    async def delete(self, readable_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Collection:
        """
        Delete a collection and all associated data.

        Permanently removes a collection from your organization including all synced data
        from the destination systems. All source connections within this collection
        will also be deleted as part of the cleanup process. This action cannot be undone.

        Parameters
        ----------
        readable_id : str
            The unique readable identifier of the collection to delete

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Collection
            Successful Response

        Examples
        --------
        import asyncio

        from airweave import AsyncAirweaveSDK

        client = AsyncAirweaveSDK(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.collections.delete(
                readable_id="readable_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(readable_id, request_options=request_options)
        return _response.data

    async def search(
        self,
        readable_id: str,
        *,
        query: str,
        response_type: typing.Optional[ResponseType] = None,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        recency_bias: typing.Optional[float] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SearchResponse:
        """
        Search across all data sources within the specified collection.

        This GET endpoint provides basic search functionality. For advanced filtering
        and options, use the POST /search endpoint.

        Parameters
        ----------
        readable_id : str
            The unique readable identifier of the collection to search

        query : str
            The search query text to find relevant documents and data

        response_type : typing.Optional[ResponseType]
            Format of the response: 'raw' returns search results, 'completion' returns AI-generated answers

        limit : typing.Optional[int]
            Maximum number of results to return

        offset : typing.Optional[int]
            Number of results to skip for pagination

        recency_bias : typing.Optional[float]
            How much to weigh recency vs similarity (0..1). 0 = no recency effect; 1 = rank by recency only.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SearchResponse
            Successful Response

        Examples
        --------
        import asyncio

        from airweave import AsyncAirweaveSDK

        client = AsyncAirweaveSDK(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.collections.search(
                readable_id="readable_id",
                query="customer payment issues",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.search(
            readable_id,
            query=query,
            response_type=response_type,
            limit=limit,
            offset=offset,
            recency_bias=recency_bias,
            request_options=request_options,
        )
        return _response.data

    async def search_advanced(
        self,
        readable_id: str,
        *,
        query: str,
        filter: typing.Optional[Filter] = OMIT,
        offset: typing.Optional[int] = OMIT,
        limit: typing.Optional[int] = OMIT,
        score_threshold: typing.Optional[float] = OMIT,
        response_type: typing.Optional[ResponseType] = OMIT,
        search_method: typing.Optional[SearchRequestSearchMethod] = OMIT,
        recency_bias: typing.Optional[float] = OMIT,
        expansion_strategy: typing.Optional[QueryExpansionStrategy] = OMIT,
        enable_reranking: typing.Optional[bool] = OMIT,
        enable_query_interpretation: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SearchResponse:
        """
        Advanced search with comprehensive filtering and options.

        This endpoint supports:
        - Metadata filtering using Qdrant's native filter syntax
        - Pagination with offset and limit
        - Score threshold filtering
        - Query expansion strategies (default: AUTO, generates up to 4 variations)
        - Automatic filter extraction from natural language (default: ON)
        - LLM-based result reranking (default: ON)

        Default behavior:
        - Query expansion: ON (AUTO strategy)
        - Query interpretation: ON (extracts filters from natural language)
        - Reranking: ON (improves relevance using LLM)
        - Score threshold: None (no filtering)

        To disable features, explicitly set:
        - enable_reranking: false
        - enable_query_interpretation: false
        - expansion_strategy: "no_expansion"

        Parameters
        ----------
        readable_id : str
            The unique readable identifier of the collection to search

        query : str
            The search query text

        filter : typing.Optional[Filter]
            Qdrant native filter for metadata-based filtering

        offset : typing.Optional[int]
            Number of results to skip (DEFAULT: 0)

        limit : typing.Optional[int]
            Maximum number of results to return (DEFAULT: 20)

        score_threshold : typing.Optional[float]
            Minimum similarity score threshold (DEFAULT: None - no filtering)

        response_type : typing.Optional[ResponseType]
            Type of response - 'raw' or 'completion' (DEFAULT: 'raw')

        search_method : typing.Optional[SearchRequestSearchMethod]
            Search method to use (DEFAULT: 'hybrid' - combines neural + BM25)

        recency_bias : typing.Optional[float]
            How much document age penalizes the similarity score (0..1). 0 = no age penalty (pure similarity); 0.5 = old docs lose up to 50% of their score; 1 = old docs get zero score (pure recency). Applied as: score × (1 - bias + bias × age_factor). Works within top ~10,000 semantic matches. DEFAULT: 0.3

        expansion_strategy : typing.Optional[QueryExpansionStrategy]
            Query expansion strategy (DEFAULT: 'auto' - generates up to 4 query variations). Options: 'auto', 'llm', 'no_expansion'

        enable_reranking : typing.Optional[bool]
            Enable LLM-based reranking to improve result relevance (DEFAULT: True - enabled, set to False to disable)

        enable_query_interpretation : typing.Optional[bool]
            Enable automatic filter extraction from natural language query (DEFAULT: True - enabled, set to False to disable)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SearchResponse
            Successful Response

        Examples
        --------
        import asyncio

        from airweave import AsyncAirweaveSDK, FieldCondition, Filter

        client = AsyncAirweaveSDK(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.collections.search_advanced(
                readable_id="readable_id",
                query="customer payment issues",
                filter=Filter(
                    must=FieldCondition(
                        key="key",
                    ),
                ),
                limit=10,
                score_threshold=0.7,
                response_type="completion",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.search_advanced(
            readable_id,
            query=query,
            filter=filter,
            offset=offset,
            limit=limit,
            score_threshold=score_threshold,
            response_type=response_type,
            search_method=search_method,
            recency_bias=recency_bias,
            expansion_strategy=expansion_strategy,
            enable_reranking=enable_reranking,
            enable_query_interpretation=enable_query_interpretation,
            request_options=request_options,
        )
        return _response.data

    async def refresh_all_source_connections(
        self, readable_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[SourceConnectionJob]:
        """
        Trigger data synchronization for all source connections in the collection.

        The sync jobs run asynchronously in the background, so this endpoint
        returns immediately with job details that you can use to track progress. You can
        monitor the status of individual data synchronization using the source connection
        endpoints.

        Parameters
        ----------
        readable_id : str
            The unique readable identifier of the collection to refresh

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[SourceConnectionJob]
            Successful Response

        Examples
        --------
        import asyncio

        from airweave import AsyncAirweaveSDK

        client = AsyncAirweaveSDK(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.collections.refresh_all_source_connections(
                readable_id="readable_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.refresh_all_source_connections(readable_id, request_options=request_options)
        return _response.data
