# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class TransformerUpdate(UniversalBaseModel):
    """
    Schema for updating a transformer.
    """

    name: str
    description: typing.Optional[str] = None
    method_name: str
    module_name: str
    input_entity_definition_ids: typing.List[str]
    output_entity_definition_ids: typing.List[str]
    config_schema: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
