# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class UsageSnapshot(UniversalBaseModel):
    """
    Point-in-time usage data with limits.
    """

    syncs: int = pydantic.Field()
    """
    Number of syncs executed
    """

    entities: int = pydantic.Field()
    """
    Total entities processed
    """

    queries: int = pydantic.Field()
    """
    Search queries executed
    """

    collections: int = pydantic.Field()
    """
    Collections created
    """

    source_connections: int = pydantic.Field()
    """
    Source connections configured
    """

    max_syncs: typing.Optional[int] = pydantic.Field(default=None)
    """
    Maximum syncs allowed
    """

    max_entities: typing.Optional[int] = pydantic.Field(default=None)
    """
    Maximum entities allowed
    """

    max_queries: typing.Optional[int] = pydantic.Field(default=None)
    """
    Maximum queries allowed
    """

    max_collections: typing.Optional[int] = pydantic.Field(default=None)
    """
    Maximum collections allowed
    """

    max_source_connections: typing.Optional[int] = pydantic.Field(default=None)
    """
    Maximum source connections allowed
    """

    timestamp: dt.datetime = pydantic.Field()
    """
    When this snapshot was taken
    """

    billing_period_id: str = pydantic.Field()
    """
    Associated billing period
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
