# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..core.serialization import convert_and_respect_annotation_metadata
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.http_validation_error import HttpValidationError
from ..types.source_connection import SourceConnection
from ..types.source_connection_create_with_white_label import SourceConnectionCreateWithWhiteLabel
from ..types.source_connection_list_item import SourceConnectionListItem
from ..types.white_label import WhiteLabel

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawWhiteLabelsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list_white_labels(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[typing.List[WhiteLabel]]:
        """
        List all white label integrations for your organization.

        <br/><br/>
        Returns all custom OAuth integrations configured with your own branding and
        credentials. These integrations allow you to present OAuth consent screens with
        your company name instead of Airweave.<br/><br/>**White label integrations only
        work with OAuth2.0 sources** like Slack, Google Drive, or HubSpot that require
        OAuth consent flows.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[WhiteLabel]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "white-labels/list",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[WhiteLabel],
                    parse_obj_as(
                        type_=typing.List[WhiteLabel],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create_white_label(
        self,
        *,
        name: str,
        source_short_name: str,
        redirect_url: str,
        client_id: str,
        client_secret: str,
        allowed_origins: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[WhiteLabel]:
        """
        Create a new white label integration.

        <br/><br/>
        **This only works for sources that use OAuth2.0 authentication** like Slack,
        Google Drive, GitHub, or HubSpot.<br/><br/>Sets up a custom OAuth integration
        using your own OAuth application credentials and branding. Once created,
        customers will see your company name during OAuth consent flows instead of
        Airweave. This requires you to have already configured your own OAuth
        application with the target service provider.

        Parameters
        ----------
        name : str
            Human-readable name for the white label integration. This helps you identify the integration in the UI and should clearly describe its purpose (e.g., 'Customer Portal Slack Integration', 'Enterprise Google Drive Access').

        source_short_name : str
            Technical identifier of the source type that this integration supports (e.g., 'slack', 'google_drive', 'github'). This determines which service provider the OAuth integration connects to.

        redirect_url : str
            OAuth2 callback URL where users are redirected after completing authentication. This must be a valid HTTPS URL that your application can handle to receive the authorization code.

        client_id : str
            OAuth2 client identifier provided by the service provider. This identifies your application during the OAuth consent flow and must match the client ID configured in the service provider's developer console.

        client_secret : str
            OAuth2 client secret from your registered application. This is used to securely authenticate your application when exchanging authorization codes for access tokens. Keep this value secure and never expose it in client-side code.

        allowed_origins : str
            Comma-separated list of allowed domains for OAuth flows and CORS. This prevents unauthorized websites from using your OAuth credentials and should include all domains where your application is hosted.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[WhiteLabel]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "white-labels",
            method="POST",
            json={
                "name": name,
                "source_short_name": source_short_name,
                "redirect_url": redirect_url,
                "client_id": client_id,
                "client_secret": client_secret,
                "allowed_origins": allowed_origins,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    WhiteLabel,
                    parse_obj_as(
                        type_=WhiteLabel,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_white_label(
        self, white_label_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[WhiteLabel]:
        """
        Retrieve a specific white label integration by its ID.

        Parameters
        ----------
        white_label_id : str
            The unique identifier of the white label integration

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[WhiteLabel]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"white-labels/{jsonable_encoder(white_label_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    WhiteLabel,
                    parse_obj_as(
                        type_=WhiteLabel,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update_white_label(
        self,
        white_label_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        redirect_url: typing.Optional[str] = OMIT,
        client_id: typing.Optional[str] = OMIT,
        client_secret: typing.Optional[str] = OMIT,
        allowed_origins: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[WhiteLabel]:
        """
        Update a white label integration's configuration.

        Parameters
        ----------
        white_label_id : str
            The unique identifier of the white label integration to update

        name : typing.Optional[str]
            Updated name for the white label integration.

        redirect_url : typing.Optional[str]
            Updated OAuth callback URL. Must be a valid HTTPS URL that matches your OAuth application configuration.

        client_id : typing.Optional[str]
            Updated OAuth2 client ID. Must match the client ID in your service provider's developer console.

        client_secret : typing.Optional[str]
            Updated OAuth2 client secret. This will replace the existing secret and affect all future OAuth flows.

        allowed_origins : typing.Optional[str]
            Updated comma-separated list of allowed domains for OAuth flows.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[WhiteLabel]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"white-labels/{jsonable_encoder(white_label_id)}",
            method="PUT",
            json={
                "name": name,
                "redirect_url": redirect_url,
                "client_id": client_id,
                "client_secret": client_secret,
                "allowed_origins": allowed_origins,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    WhiteLabel,
                    parse_obj_as(
                        type_=WhiteLabel,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete_white_label(
        self, white_label_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[WhiteLabel]:
        """
        Delete a white label integration.

        <br/><br/>
        Permanently removes the white label configuration and OAuth credentials.
        Existing source connections created through this integration will continue to work,
        but no new OAuth flows can be initiated until a new white label integration is created.

        Parameters
        ----------
        white_label_id : str
            The unique identifier of the white label integration to delete

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[WhiteLabel]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"white-labels/{jsonable_encoder(white_label_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    WhiteLabel,
                    parse_obj_as(
                        type_=WhiteLabel,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_white_label_oauth_2_auth_url(
        self, white_label_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[str]:
        """
        Generate a branded OAuth2 authorization URL for customer authentication.

        <br/><br/>
        Creates the OAuth consent URL that customers should be redirected to for
        authentication. The OAuth consent screen will display your company name and
        branding instead of Airweave.

        Parameters
        ----------
        white_label_id : str
            The unique identifier of the white label integration

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[str]
            OAuth2 authorization URL with your branding
        """
        _response = self._client_wrapper.httpx_client.request(
            f"white-labels/{jsonable_encoder(white_label_id)}/oauth2/auth_url",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    str,
                    parse_obj_as(
                        type_=str,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def list_white_label_source_connections(
        self, white_label_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[typing.List[SourceConnectionListItem]]:
        """
        List all source connections created through a specific white label integration.

        <br/><br/>
        Returns source connections that were established using this white label's OAuth flow.

        Parameters
        ----------
        white_label_id : str
            The unique identifier of the white label integration

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[SourceConnectionListItem]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"white-labels/{jsonable_encoder(white_label_id)}/source-connections",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[SourceConnectionListItem],
                    parse_obj_as(
                        type_=typing.List[SourceConnectionListItem],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def exchange_white_label_oauth_2_code(
        self,
        white_label_id: str,
        *,
        code: str,
        source_connection_in: typing.Optional[SourceConnectionCreateWithWhiteLabel] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[SourceConnection]:
        """
        Complete the OAuth flow and create a source connection.

        <br/><br/>
        **This is the core endpoint that converts OAuth authorization codes into working
        source connections.**<br/><br/>The OAuth credentials are obtained automatically
        from the authorization code - you do not need to provide auth_fields. The white
        label integration is automatically linked to the created source connection for
        tracking and branding purposes.

        Parameters
        ----------
        white_label_id : str
            The unique identifier of the white label integration

        code : str
            The OAuth2 authorization code received from the OAuth callback after customer authentication

        source_connection_in : typing.Optional[SourceConnectionCreateWithWhiteLabel]
            Optional configuration for the source connection. If not provided, a source connection will be created automatically with default settings. The white label integration is automatically linked to the source connection.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[SourceConnection]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"white-labels/{jsonable_encoder(white_label_id)}/oauth2/code",
            method="POST",
            json={
                "code": code,
                "source_connection_in": convert_and_respect_annotation_metadata(
                    object_=source_connection_in, annotation=SourceConnectionCreateWithWhiteLabel, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SourceConnection,
                    parse_obj_as(
                        type_=SourceConnection,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawWhiteLabelsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list_white_labels(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[typing.List[WhiteLabel]]:
        """
        List all white label integrations for your organization.

        <br/><br/>
        Returns all custom OAuth integrations configured with your own branding and
        credentials. These integrations allow you to present OAuth consent screens with
        your company name instead of Airweave.<br/><br/>**White label integrations only
        work with OAuth2.0 sources** like Slack, Google Drive, or HubSpot that require
        OAuth consent flows.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[WhiteLabel]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "white-labels/list",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[WhiteLabel],
                    parse_obj_as(
                        type_=typing.List[WhiteLabel],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create_white_label(
        self,
        *,
        name: str,
        source_short_name: str,
        redirect_url: str,
        client_id: str,
        client_secret: str,
        allowed_origins: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[WhiteLabel]:
        """
        Create a new white label integration.

        <br/><br/>
        **This only works for sources that use OAuth2.0 authentication** like Slack,
        Google Drive, GitHub, or HubSpot.<br/><br/>Sets up a custom OAuth integration
        using your own OAuth application credentials and branding. Once created,
        customers will see your company name during OAuth consent flows instead of
        Airweave. This requires you to have already configured your own OAuth
        application with the target service provider.

        Parameters
        ----------
        name : str
            Human-readable name for the white label integration. This helps you identify the integration in the UI and should clearly describe its purpose (e.g., 'Customer Portal Slack Integration', 'Enterprise Google Drive Access').

        source_short_name : str
            Technical identifier of the source type that this integration supports (e.g., 'slack', 'google_drive', 'github'). This determines which service provider the OAuth integration connects to.

        redirect_url : str
            OAuth2 callback URL where users are redirected after completing authentication. This must be a valid HTTPS URL that your application can handle to receive the authorization code.

        client_id : str
            OAuth2 client identifier provided by the service provider. This identifies your application during the OAuth consent flow and must match the client ID configured in the service provider's developer console.

        client_secret : str
            OAuth2 client secret from your registered application. This is used to securely authenticate your application when exchanging authorization codes for access tokens. Keep this value secure and never expose it in client-side code.

        allowed_origins : str
            Comma-separated list of allowed domains for OAuth flows and CORS. This prevents unauthorized websites from using your OAuth credentials and should include all domains where your application is hosted.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[WhiteLabel]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "white-labels",
            method="POST",
            json={
                "name": name,
                "source_short_name": source_short_name,
                "redirect_url": redirect_url,
                "client_id": client_id,
                "client_secret": client_secret,
                "allowed_origins": allowed_origins,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    WhiteLabel,
                    parse_obj_as(
                        type_=WhiteLabel,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_white_label(
        self, white_label_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[WhiteLabel]:
        """
        Retrieve a specific white label integration by its ID.

        Parameters
        ----------
        white_label_id : str
            The unique identifier of the white label integration

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[WhiteLabel]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"white-labels/{jsonable_encoder(white_label_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    WhiteLabel,
                    parse_obj_as(
                        type_=WhiteLabel,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update_white_label(
        self,
        white_label_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        redirect_url: typing.Optional[str] = OMIT,
        client_id: typing.Optional[str] = OMIT,
        client_secret: typing.Optional[str] = OMIT,
        allowed_origins: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[WhiteLabel]:
        """
        Update a white label integration's configuration.

        Parameters
        ----------
        white_label_id : str
            The unique identifier of the white label integration to update

        name : typing.Optional[str]
            Updated name for the white label integration.

        redirect_url : typing.Optional[str]
            Updated OAuth callback URL. Must be a valid HTTPS URL that matches your OAuth application configuration.

        client_id : typing.Optional[str]
            Updated OAuth2 client ID. Must match the client ID in your service provider's developer console.

        client_secret : typing.Optional[str]
            Updated OAuth2 client secret. This will replace the existing secret and affect all future OAuth flows.

        allowed_origins : typing.Optional[str]
            Updated comma-separated list of allowed domains for OAuth flows.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[WhiteLabel]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"white-labels/{jsonable_encoder(white_label_id)}",
            method="PUT",
            json={
                "name": name,
                "redirect_url": redirect_url,
                "client_id": client_id,
                "client_secret": client_secret,
                "allowed_origins": allowed_origins,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    WhiteLabel,
                    parse_obj_as(
                        type_=WhiteLabel,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete_white_label(
        self, white_label_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[WhiteLabel]:
        """
        Delete a white label integration.

        <br/><br/>
        Permanently removes the white label configuration and OAuth credentials.
        Existing source connections created through this integration will continue to work,
        but no new OAuth flows can be initiated until a new white label integration is created.

        Parameters
        ----------
        white_label_id : str
            The unique identifier of the white label integration to delete

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[WhiteLabel]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"white-labels/{jsonable_encoder(white_label_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    WhiteLabel,
                    parse_obj_as(
                        type_=WhiteLabel,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_white_label_oauth_2_auth_url(
        self, white_label_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[str]:
        """
        Generate a branded OAuth2 authorization URL for customer authentication.

        <br/><br/>
        Creates the OAuth consent URL that customers should be redirected to for
        authentication. The OAuth consent screen will display your company name and
        branding instead of Airweave.

        Parameters
        ----------
        white_label_id : str
            The unique identifier of the white label integration

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[str]
            OAuth2 authorization URL with your branding
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"white-labels/{jsonable_encoder(white_label_id)}/oauth2/auth_url",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    str,
                    parse_obj_as(
                        type_=str,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def list_white_label_source_connections(
        self, white_label_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[typing.List[SourceConnectionListItem]]:
        """
        List all source connections created through a specific white label integration.

        <br/><br/>
        Returns source connections that were established using this white label's OAuth flow.

        Parameters
        ----------
        white_label_id : str
            The unique identifier of the white label integration

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[SourceConnectionListItem]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"white-labels/{jsonable_encoder(white_label_id)}/source-connections",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[SourceConnectionListItem],
                    parse_obj_as(
                        type_=typing.List[SourceConnectionListItem],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def exchange_white_label_oauth_2_code(
        self,
        white_label_id: str,
        *,
        code: str,
        source_connection_in: typing.Optional[SourceConnectionCreateWithWhiteLabel] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[SourceConnection]:
        """
        Complete the OAuth flow and create a source connection.

        <br/><br/>
        **This is the core endpoint that converts OAuth authorization codes into working
        source connections.**<br/><br/>The OAuth credentials are obtained automatically
        from the authorization code - you do not need to provide auth_fields. The white
        label integration is automatically linked to the created source connection for
        tracking and branding purposes.

        Parameters
        ----------
        white_label_id : str
            The unique identifier of the white label integration

        code : str
            The OAuth2 authorization code received from the OAuth callback after customer authentication

        source_connection_in : typing.Optional[SourceConnectionCreateWithWhiteLabel]
            Optional configuration for the source connection. If not provided, a source connection will be created automatically with default settings. The white label integration is automatically linked to the source connection.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[SourceConnection]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"white-labels/{jsonable_encoder(white_label_id)}/oauth2/code",
            method="POST",
            json={
                "code": code,
                "source_connection_in": convert_and_respect_annotation_metadata(
                    object_=source_connection_in, annotation=SourceConnectionCreateWithWhiteLabel, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SourceConnection,
                    parse_obj_as(
                        type_=SourceConnection,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
