'''
Relation sets and mappings for the corpora annotated within the RST
'''

# General mapping for all corpora to the 18 coarse grained classes (Carlson et al. 2001)
mapping = {
    u'ahalbideratzea': 'Enablement',
    u'alderantzizko-baldintza': 'Condition',
    u'alternativa': 'Condition',
    u'analogy': 'Comparison',
    u'antitesia': 'Contrast',
    u'antithesis': 'Contrast',
    u'antítesis': 'Contrast',
    u'arazo-soluzioa': 'Topic-Comment',
    u'attribution': 'Attribution',
    u'attribution-negative': 'Attribution',
    u'aukera': 'Condition',
    u'background': 'Background',
    u'baldintza': 'Condition',
    u'bateratzea': 'Joint',
    u'birformulazioa': 'Summary',
    u'capacitación': 'Enablement',
    u'causa': 'Cause',
    u'cause': 'Cause',
    u'cause-result': 'Cause',
    u'circumstance': 'Background',
    u'circunstancia': 'Background',
    u'comment': 'Evaluation',
    u'comment-topic': 'Topic-Comment',
    u'comparison': 'Comparison',
    u'concesión': 'Contrast',
    u'concession': 'Contrast',
    u'conclusion': 'Evaluation',
    u'condición': 'Condition',
    u'condición-inversa': 'Condition',
    u'condition': 'Condition',
    u'conjunción': 'Joint',
    u'conjunction': 'Joint',
    u'consequence': 'Cause',
    u'contingency': 'Condition',
    u'contrast': 'Contrast',
    u'contraste': 'Contrast',
    u'definition': 'Elaboration',
    u'definitu-gabeko-erlazioa': 'Summary',
    u'disjunction': 'Joint',
    u'disjuntzioa': 'Joint',
    u'disyunción': 'Joint',
    u'e-elaboration': 'Elaboration',
    u'ebaluazioa': 'Evaluation',
    u'ebidentzia': 'Explanation',
    u'elaboración': 'Elaboration',
    u'elaboration': 'Elaboration',
    u'elaboration-additional': 'Elaboration',
    u'elaboration-general-specific': 'Elaboration',
    u'elaboration-object-attribute': 'Elaboration',
    u'elaboration-part-whole': 'Elaboration',
    u'elaboration-process-step': 'Elaboration',
    u'elaboration-set-member': 'Elaboration',
    u'elaborazioa': 'Elaboration',
    u'enablement': 'Enablement',
    u'evaluación': 'Evaluation',
    u'evaluation': 'Evaluation',
    u'evidence': 'Explanation',
    u'evidencia': 'Explanation',
    u'example': 'Elaboration',
    u'explanation': 'Explanation',
    u'explanation-argumentative': 'Explanation',
    u'ez-baldintzatzailea': 'Condition',
    u'fondo': 'Background',
    u'helburua': 'Enablement',
    u'hypothetical': 'Condition',
    u'interpretación': 'Evaluation',
    u'interpretation': 'Evaluation',
    u'interpretazioa': 'Evaluation',
    u'inverted-sequence': 'Temporal',
    u'joint': 'Joint',
    u'justificación': 'Explanation',
    u'justifikazioa': 'Explanation',
    u'justify': 'Explanation',
    u'kausa': 'Cause',
    u'konjuntzioa': 'Joint',
    u'kontrastea': 'Contrast',
    u'kontzesioa': 'Contrast',
    u'laburpena': 'Summary',
    u'list': 'Joint',
    u'lista': 'Joint',
    u'manner': 'Manner-Means',
    u'means': 'Manner-Means',
    u'medio': 'Manner-Means',
    u'metodoa': 'Manner-Means',
    u'motibazioa': 'Explanation',
    u'motivación': 'Explanation',
    u'motivation': 'Explanation',
    u'non-volitional-cause': 'Cause',
    u'non-volitional-result': 'Cause',
    u'nonvolitional-cause': 'Cause',
    u'nonvolitional-result': 'Cause',
    u'ondorioa': 'Cause',
    u'otherwise': 'Condition',
    u'parenthetical': 'Elaboration',
    u'preference': 'Comparison',
    u'preparación': 'Background',
    u'preparation': 'Background',
    u'prestatzea': 'Background',
    u'problem-solution': 'Topic-Comment',
    u'proportion': 'Comparison',
    u'propósito': 'Enablement',
    u'purpose': 'Enablement',
    u'question-answer': 'Topic-Comment',
    u'reason': 'Explanation',
    u'reformulación': 'Summary',
    u'restatement': 'Summary',
    u'restatement-mn': 'Summary',
    u'result': 'Cause',
    u'resultado': 'Cause',
    u'resumen': 'Summary',
    u'rhetorical-question': 'Topic-Comment',
    u'same-unit': 'Same-unit',
    u'secuencia': 'Temporal',
    u'sekuentzia': 'Temporal',
    u'sequence': 'Temporal',
    u'solución': 'Topic-Comment',
    u'solutionhood': 'Topic-Comment',
    u'statement-response': 'Topic-Comment',
    u'summary': 'Summary',
    u'temporal-after': 'Temporal',
    u'temporal-before': 'Temporal',
    u'temporal-same-time': 'Temporal',
    u'testuingurua': 'Background',
    u'textual-organization': 'Textual-organization',
    u'textualorganization': 'Textual-organization',
    u'topic-comment': 'Topic-Comment',
    u'topic-drift': 'Topic-Change',
    u'topic-shift': 'Topic-Change',
    u'unconditional': 'Condition',
    u'unión': 'Joint',
    u'unless': 'Condition',
    u'volitional-cause': 'Cause',
    u'volitional-result': 'Cause',
    u'zirkunstantzia': 'Background',
    u'question': 'Topic-Comment',  # Shi Ke added for gum dataset
}

# English RST DT usual mapping
rstdt_mapping18 = {
    'analogy': 'Comparison',
    'antithesis': 'Contrast',
    'attribution': 'Attribution',
    'attribution-negative': 'Attribution',
    'background': 'Background',
    'cause': 'Cause',
    'cause-result': 'Cause',
    'circumstance': 'Background',
    'comment': 'Evaluation',
    'comment-topic': 'Topic-Comment',
    'comparison': 'Comparison',
    'concession': 'Contrast',
    'conclusion': 'Evaluation',
    'condition': 'Condition',
    'consequence': 'Cause',
    'contingency': 'Condition',
    'contrast': 'Contrast',
    'definition': 'Elaboration',
    'disjunction': 'Joint',
    'elaboration-additional': 'Elaboration',
    'elaboration-general-specific': 'Elaboration',
    'elaboration-object-attribute': 'Elaboration',
    'elaboration-part-whole': 'Elaboration',
    'elaboration-process-step': 'Elaboration',
    'elaboration-set-member': 'Elaboration',
    'enablement': 'Enablement',
    'evaluation': 'Evaluation',
    'evidence': 'Explanation',
    'example': 'Elaboration',
    'explanation-argumentative': 'Explanation',
    'hypothetical': 'Condition',
    'interpretation': 'Evaluation',
    'inverted-sequence': 'Temporal',
    'list': 'Joint',
    'manner': 'Manner-Means',
    'means': 'Manner-Means',
    'otherwise': 'Condition',
    'preference': 'Comparison',
    'problem-solution': 'Topic-Comment',
    'proportion': 'Comparison',
    'purpose': 'Enablement',
    'question-answer': 'Topic-Comment',
    'reason': 'Explanation',
    'restatement': 'Summary',
    'result': 'Cause',
    'rhetorical-question': 'Topic-Comment',
    'same-unit': 'Same-unit',
    'sequence': 'Temporal',
    'statement-response': 'Topic-Comment',
    'summary': 'Summary',
    'temporal-after': 'Temporal',
    'temporal-before': 'Temporal',
    'temporal-same-time': 'Temporal',
    'textual-organization': 'Textual-organization',
    'textualorganization': 'Textual-organization',
    'topic-comment': 'Topic-Comment',
    'topic-drift': 'Topic-Change',
    'topic-shift': 'Topic-Change'
}

# Dictionnaries with original labels as annotated in the data and possible
# corrections if needed (ie translation to English, correction of errors)

basque_labels = {
    u'ahalbideratzea': u'enablement',
    u'alderantzizko-baldintza': u'unless',
    u'antitesia': u'antithesis',
    u'arazo-soluzioa': u'solutionhood',  # solution-hood changed to 'solutionhood'
    u'aukera': u'otherwise',
    u'baldintza': u'condition',
    u'bateratzea': u'joint',  # Join on the website but Joint is a most common name
    u'birformulazioa': u'restatement',
    u'definitu-gabeko-erlazioa': u'reformulation',
    u'disjuntzioa': u'disjunction',
    u'ebaluazioa': u'evaluation',
    u'ebidentzia': u'evidence',
    u'elaborazioa': u'elaboration',
    u'ez-baldintzatzailea': u'unconditional',
    u'helburua': u'purpose',
    u'interpretazioa': u'interpretation',
    u'justifikazioa': u'justify',
    u'kausa': u'cause',
    u'konjuntzioa': u'conjunction',
    u'kontrastea': u'contrast',
    u'kontzesioa': u'concession',
    u'laburpena': u'summary',
    u'lista': u'list',
    u'metodoa': u'means',
    u'motibazioa': u'motivation',
    u'ondorioa': u'result',
    u'prestatzea': u'preparation',
    u'same-unit': u'same-unit',
    u'sekuentzia': u'sequence',
    u'testuingurua': u'background',
    u'zirkunstantzia': u'circumstance'
}

brazilianCst_labels = {  # The most similar to the RST
    u'antithesis': u'antithesis',
    u'attribution': u'attribution',
    u'background': u'background',
    u'circumstance': u'circumstance',
    u'comparison': u'comparison',
    u'concession': u'concession',
    u'conclusion': u'conclusion',
    u'condition': u'condition',
    u'contrast': u'contrast',
    u'elaboration': u'elaboration',
    u'enablement': u'enablement',
    u'evaluation': u'evaluation',
    u'evidence': u'evidence',
    u'explanation': u'explanation',
    u'interpretation': u'interpretation',
    u'joint': u'joint',
    u'justify': u'justify',
    u'list': u'list',
    u'means': u'means',
    u'motivation': u'motivation',
    u'non-volitional-cause': u'non-volitional-cause',
    u'non-volitional-result': u'non-volitional-result',
    u'otherwise': u'otherwise',
    u'parenthetical': u'parenthetical',
    u'purpose': u'purpose',
    u'restatement': u'restatement',
    u'same-unit': u'same-unit',
    u'sequence': u'sequence',
    u'solutionhood': u'solutionhood',
    u'volitional-cause': u'volitional-cause',
    u'volitional-result': u'volitional-result'
}

brazilianSum_labels = {
    u'antithesis': u'antithesis',
    u'attribution': u'attribution',
    u'background': u'background',
    u'circumstance': u'circumstance',
    u'comparison': u'comparison',
    u'concession': u'concession',
    u'conclusion': u'conclusion',
    u'condition': u'condition',
    u'contrast': u'contrast',
    u'elaboration': u'elaboration',
    u'evaluation': u'evaluation',
    u'evidence': u'evidence',
    u'explanation': u'explanation',
    u'interpretation': u'interpretation',
    u'joint': u'joint',
    u'justify': u'justify',
    u'list': u'list',
    u'means': u'means',
    u'non-volitional-cause': u'non-volitional-cause',
    u'non-volitional-result': u'non-volitional-result',
    u'otherwise': u'otherwise',
    u'parenthetical': u'parenthetical',
    u'purpose': u'purpose',
    u'restatement': u'restatement',
    u'same-unit': u'same-unit',
    u'sequence': u'sequence',
    u'solutionhood': u'solutionhood',
    u'summary': u'summary',
    u'volitional-cause': u'volitional-cause'
}

brazilianTCC_labels = {
    u'antithesis': u'antithesis',
    u'attribution': u'attribution',
    u'background': u'background',
    u'circumstance': u'circumstance',
    u'comparison': u'comparison',
    u'concession': u'concession',
    u'conclusion': u'conclusion',
    u'condition': u'condition',
    u'contrast': u'contrast',
    u'elaboration': u'elaboration',
    u'enablement': u'enablement',
    u'evaluation': u'evaluation',
    u'evidence': u'evidence',
    u'explanation': u'explanation',
    u'interpretation': u'interpretation',
    u'joint': u'joint',
    u'justify': u'justify',
    u'list': u'list',
    u'means': u'means',
    u'motivation': u'motivation',
    u'non-volitional-cause': u'non-volitional-cause',
    u'non-volitional-result': u'non-volitional-result',
    u'otherwise': u'otherwise',
    u'parenthetical': u'parenthetical',
    u'purpose': u'purpose',
    u'restatement': u'restatement',
    u'same-unit': u'same-unit',
    u'sequence': u'sequence',
    u'solutionhood': u'solutionhood',
    u'summary': u'summary',
    u'volitional-cause': u'volitional-cause',
    u'volitional-result': u'volitional-result'
}

germanPcc_labels = {
    u'antithesis': u'antithesis',
    u'background': u'background',
    u'cause': u'cause',
    u'circumstance': u'circumstance',
    u'concession': u'concession',
    u'condition': u'condition',
    u'conjunction': u'conjunction',
    u'contrast': u'contrast',
    u'disjunction': u'disjunction',
    u'e-elaboration': u'entity-elaboration',
    u'elaboration': u'elaboration',
    u'enablement': u'enablement',
    u'evaluation': u'evaluation',
    u'evidence': u'evidence',
    u'interpretation': u'interpretation',
    u'joint': u'joint',
    u'justify': u'justify',
    u'list': u'list',
    u'means': u'means',
    u'motivation': u'motivation',
    u'otherwise': u'otherwise',
    u'preparation': u'preparation',
    u'purpose': u'purpose',
    u'reason': u'reason',
    u'restatement': u'restatement',
    u'result': u'result',
    u'sequence': u'sequence',
    u'solutionhood': u'solutionhood',
    u'summary': u'summary',
    u'unless': u'unless'
}

spanish_labels = {
    u'alternativa': u'alternative',
    u'antítesis': u'antithesis',
    u'capacitación': u'enablement',
    u'causa': u'cause',
    u'circunstancia': u'circumstance',
    u'concesión': u'concession',
    u'condición': u'condition',
    u'condición-inversa': u'unconditional',
    u'conjunción': u'conjunction',
    u'contraste': u'contrast',
    u'disyunción': u'disjunction',
    u'elaboración': u'elaboration',
    u'evaluación': u'evaluation',
    u'evidencia': u'evidence',
    u'fondo': u'background',
    u'interpretación': u'interpretation',
    u'justificación': u'justify',
    u'lista': u'list',
    u'medio': u'means',
    u'motivación': u'motivation',
    u'preparación': u'preparation',
    u'propósito': u'purpose',
    u'reformulación': u'restatement',
    u'resultado': u'result',
    u'resumen': u'summary',
    u'same-unit': u'same-unit',
    u'secuencia': u'sequence',
    u'solución': u'solutionhood',
    u'unión': u'union',
    u'unless': u'unless'
}

dutch_labels = {
    u'antithesis': u'antithesis',
    u'background': u'background',
    u'circumstance': u'circumstance',
    u'concession': u'concession',
    u'condition': u'condition',
    u'conjunction': u'conjunction',
    u'contrast': u'contrast',
    u'disjunction': u'disjunction',
    u'elaboration': u'elaboration',
    u'enablement': u'enablement',
    u'evaluation': u'evaluation',
    u'evidence': u'evidence',
    u'interpretation': u'interpretation',
    u'joint': u'joint',
    u'justify': u'justify',
    u'list': u'list',
    u'means': u'means',
    u'motivation': u'motivation',
    u'nonvolitional-cause': u'non-volitional-cause',
    u'nonvolitional-result': u'non-volitional-result',
    u'otherwise': u'otherwise',
    u'preparation': u'preparation',
    u'purpose': u'purpose',
    u'restatement': u'restatement',
    u'restatement-mn': u'restatement',  # multinuclear version
    u'sequence': u'sequence',
    u'solutionhood': u'solutionhood',
    u'summary': u'summary',
    u'unconditional': u'unconditional',
    u'unless': u'unless',
    u'volitional-cause': u'volitional-cause',
    u'volitional-result': u'volitional-result'
}
