# XMind 测试脚本集合

这个目录包含了 XMind 项目的所有测试脚本，经过精简整合后形成了4个核心测试文件，总代码量从原来的1662行精简到920行，精简比例达到44.6%。

## 测试脚本结构

### 1. test_core.py - 核心功能测试 (182行)
- **功能**: 测试XMind MCP服务器的核心功能
- **测试内容**:
  - 服务器健康检查
  - 文件转换测试（支持txt, md, json格式）
  - MCP工具测试（read_xmind_file, create_xmind_file等）
  - 测试报告生成
- **特点**: 支持中英文切换，详细的测试报告，异步实现

### 2. test_batch.py - 批量转换测试 (216行)
- **功能**: 测试批量文件转换功能
- **测试内容**:
  - 批量转换测试（处理多个文件）
  - 单个文件转换测试
  - 转换统计报告
- **特点**: 支持多种格式文件，生成转换统计信息

### 3. test_setup.py - 安装配置测试 (223行)
- **功能**: 验证XMind环境安装配置
- **测试内容**:
  - Python版本检查（要求3.8+）
  - 关键依赖检查（xmind, requests, fastapi, uvicorn）
  - 目录结构验证
  - 核心文件完整性检查
  - 示例文件检查
- **特点**: 全面的环境验证，详细的错误提示

### 4. test_client.py - 客户端交互测试 (299行)
- **功能**: 测试客户端与服务器的交互
- **测试内容**:
  - 连接测试（响应时间测量）
  - 文件操作测试（读取、创建、批量转换）
  - API端点测试（/health, /convert, /batch, /list_tools）
  - 错误处理测试（无效路径、不支持格式等）
- **特点**: 异步实现，响应时间统计，全面的API测试

## 使用方法

### 运行所有测试
```bash
# 运行核心功能测试
python test_core.py

# 运行批量转换测试
python test_batch.py

# 运行安装配置测试
python test_setup.py

# 运行客户端测试
python test_client.py
```

### 语言选项
所有测试脚本都支持中英文切换：
```bash
# 英文模式
python test_core.py --english
python test_setup.py --english
python test_client.py --english
```

## 测试覆盖范围

新的测试脚本集合覆盖了以下方面：

1. **功能测试**: 核心XMind功能验证
2. **性能测试**: 批量处理和响应时间
3. **环境测试**: 安装配置完整性
4. **集成测试**: 客户端-服务器交互
5. **错误处理**: 异常情况处理验证

## 精简优势

相比原始测试脚本，新的集合具有以下优势：

- **代码精简**: 44.6%的代码量减少，更易于维护
- **功能聚焦**: 每个脚本专注于特定测试领域
- **重复消除**: 移除冗余功能，避免测试重叠
- **标准统一**: 统一的输出格式和错误处理
- **易于扩展**: 模块化设计便于添加新测试

## 测试报告

每个测试脚本都会生成详细的测试报告，包括：
- 测试执行结果（通过/失败）
- 性能统计信息
- 错误详细信息
- 建议和解决方案

所有测试都支持中英文双语输出，方便不同语言环境的用户使用。