from PyQt5.QtCore import Qt
from PyQt5.QtWidgets import QTabWidget, QVBoxLayout, QWidget, QSplitter, QHBoxLayout, QFrame, QFrame
from track2p.gui.fluo_plot import FluorescencePlotWidget
from track2p.gui.roi_plot import ZoomPlotWidget
from track2p.gui.cell_plot import CellPlotWidget
from track2p.gui.data_management import DataManagement
from track2p.gui.raster_wd import RasterWindow

class CentralWidget(QWidget):
    def __init__(self, main_window):
        super().__init__()

        self.main_window = main_window
        self.fluorescences_plotting = None
        self.rois_plotting = None
        self.selected_roi = None
        self.cell_plot = None
        self.track_ops_dict=None
        self.data_management = DataManagement(self)
        self.vector_curation_t2p = self.data_management.vector_curation_t2p
        self.init_central_widget()

    def init_central_widget(self):
        self.top = QFrame()
        self.top.setFrameShape(QFrame.StyledPanel)
        self.top_layout = QHBoxLayout(self.top)

        self.top_right = QFrame()
        self.top_right.setFrameShape(QFrame.StyledPanel)
        self.top_layout_right = QVBoxLayout(self.top_right)

        self.tabs = QTabWidget(self)

        self.splitter1 = QSplitter(Qt.Horizontal)
        self.splitter1.addWidget(self.tabs)
        self.splitter1.addWidget(self.top)
        self.splitter1.setSizes([100, 100])

        self.splitter2 = QSplitter(Qt.Horizontal)
        self.splitter2.addWidget(self.top_right)

        self.splitter3 = QSplitter(Qt.Vertical)
        self.splitter3.addWidget(self.splitter1)
        self.splitter3.addWidget(self.splitter2)
        self.splitter3.setSizes([100, 100])

        central_layout = QVBoxLayout()
        central_layout.addWidget(self.splitter3)
        self.setLayout(central_layout)
        
        
    def create_mean_img(self):
        for i, (ops, stat_t2p) in enumerate(zip(self.data_management.all_ops, self.data_management.all_stat_t2p)):
            tab = QWidget()
            self.cell_plot = CellPlotWidget(tab, ops=ops, stat_t2p=stat_t2p, f_t2p=self.data_management.all_f_t2p[i],
                                       colors=self.data_management.colors, update_selection_callback=self.update_selection,
                                       all_f_t2p=self.data_management.all_f_t2p, all_ops=self.data_management.all_ops)
            layout = QVBoxLayout(tab)
            layout.addWidget(self.cell_plot)
            tab.setLayout(layout)
            self.tabs.addTab(tab, f"Day {i + 1}")
            self.cell_plot.cell_selected.connect(self.update_selection)
            
    
    def create_mean_img_from_curation(self):
        import_window = self.main_window.window_manager.import_window
        t2p_window = self.main_window.window_manager.t2p_window

        if import_window is not None and import_window.plane is not None:
            self.data_management.import_files(import_window.path_to_t2p, import_window.plane)
        elif t2p_window is not None and t2p_window.saved_directory is not None:
            self.data_management.import_files(t2p_window.saved_directory, t2p_window.plane)
        else:
            print("Both import_window and t2p_window are None or not properly initialized.")
        
    def clear(self):
        self.data_management.reset_attributes()
        if self.fluorescences_plotting:
            self.top_layout_right.removeWidget(self.fluorescences_plotting)
            self.fluorescences_plotting.deleteLater()
            self.fluorescences_plotting = None
        if self.rois_plotting:
            self.top_layout.removeWidget(self.rois_plotting)
            self.rois_plotting.deleteLater()
            self.rois_plotting = None
        for i in range(self.tabs.count()):
            self.tabs.removeTab(0)
            
            
    def update_selection(self, selected_cell_index):
        self.selected_roi = selected_cell_index
        self.main_window.status_bar.spin_box.setValue(selected_cell_index) 
        self.main_window.status_bar.roi_state_value.setText(f"{self.vector_curation_t2p[selected_cell_index]}")        
        #it removes the underline of the previsouly selected cell even if the tab is not visible (not the current tab)
        for i in range(self.tabs.count()): 
            tab_widget = self.tabs.widget(i)
            cell_object = tab_widget.findChild(CellPlotWidget)
            cell_object.remove_previous_underline()
        current_tab_index = self.tabs.currentIndex()
        current_tab_widget = self.tabs.widget(current_tab_index)
        cell_plot = current_tab_widget.findChild(CellPlotWidget)
        if cell_plot:
            cell_plot.underline_cell(selected_cell_index)
        if self.fluorescences_plotting is None:
            self.fluorescences_plotting = FluorescencePlotWidget(all_f_t2p=self.data_management.all_f_t2p,
                                                           all_ops=self.data_management.all_ops,
                                                          colors=self.data_management.colors)
            self.top_layout_right.addWidget(self.fluorescences_plotting)
        if self.rois_plotting is None:
            self.rois_plotting = ZoomPlotWidget(all_ops=self.data_management.all_ops,
                                            all_stat_t2p=self.data_management.all_stat_t2p,
                                            colors=self.data_management.colors,
                                            all_iscell_t2p=self.data_management.all_iscell,
                                            t2p_match_mat_allday=self.data_management.t2p_match_mat_allday,track_ops=self.track_ops)
            self.top_layout.addWidget(self.rois_plotting)
        self.fluorescences_plotting.display_all_f_t2p(selected_cell_index)
        self.rois_plotting.display_zooms(selected_cell_index)
            
                   
    def display_first_ROI(self,index):
        """it displays the first cell of the t2p_match_mat_allday and its fluorescence and zooms across days. It is called when the application is opened.
        An instance of FluorescencePlotWidget and an instance of ZoomPlotWidget are created and added to attributes of the MainWindow class. """
        tab_widget = self.tabs.widget(0)
        cell_object = tab_widget.findChild(CellPlotWidget) #It finds the instance of the CellPlotWidget class in the first tab of the QTabWidget
        cell_object.underline_cell(index)
        cell_object.draw()
        if self.fluorescences_plotting is None:
            self.fluorescences_plotting = FluorescencePlotWidget(all_f_t2p=self.data_management.all_f_t2p,
                                                           all_ops=self.data_management.all_ops,
                                                           colors=self.data_management.colors, all_stat_t2p=self.data_management.all_stat_t2p)
            self.top_layout_right.addWidget(self.fluorescences_plotting)
        if self.rois_plotting is None:
            self.rois_plotting = ZoomPlotWidget(all_ops=self.data_management.all_ops,
                                            all_stat_t2p=self.data_management.all_stat_t2p,
                                            colors=self.data_management.colors,
                                            all_iscell_t2p=self.data_management.all_iscell,
                                            t2p_match_mat_allday=self.data_management.t2p_match_mat_allday,track_ops=self.data_management.track_ops)
            self.top_layout.addWidget(self.rois_plotting)
        self.fluorescences_plotting.display_all_f_t2p(index)
        self.rois_plotting.display_zooms(index)
        self.main_window.status_bar.roi_state_value.setText(f"{self.vector_curation_t2p[self.main_window.status_bar.spin_box.value()]}") #
