
from track2p.gui.window_manager import WindowManager
from track2p.gui.toolbar import Toolbar
from track2p.gui.statusbar import StatusBar
from track2p.gui.data_management import DataManagement
from track2p.gui.central_widget import CentralWidget
from PyQt5.QtWidgets import QApplication,QMainWindow

class MainWindow(QMainWindow):
    
    def __init__(self):
        super(MainWindow, self).__init__()
        self.main_window = self
        self.window_manager = WindowManager(self)
        self.data_management = DataManagement(self)
        self.central_widget = CentralWidget(self)
        self.toolbar = Toolbar(self)
        self.status_bar = StatusBar(self)
        
        
        self.initUI()

    def initUI(self):
        
        
        self.setStyleSheet(
            "QTabWidget::pane { border: 1px solid #666; }"
            "QTabWidget::tab-bar { alignment: center; }"
            "QTabBar::tab { background-color: #666; color: white; }"
            "QTabBar::tab:selected { background-color: #222; color: white; }"
            "QSplitter::handle { background: #888; }"
            "QFrame { background-color: black; color: black;  border: 1px solid black;}"
            "QLabel { color: black; background-color: none; border: none; font-size: 13px}"
            "QPushButton { background-color: #666; color: white; border: 1px solid #888; }"
            "QPushButton:hover { background-color: #888; color: white; }"
            "QPushButton:pressed { background-color: #333; color: white; }"
            "QToolButton:pressed { background-color: #888; }"
            "QComboBox { background-color: black; color: white; }"
            "QComboBox QAbstractItemView { background-color: #666; color: white; }"
            )
        
        self.setWindowTitle("track2p GUI")

        self.setCentralWidget(self.central_widget)
        self.addToolBar(self.toolbar)
        self.setStatusBar(self.status_bar)
        QApplication.setStyle('Cleanlooks')
        self.show()
        


        


            
