from PyQt5.QtWidgets import QStatusBar,QWidget,  QHBoxLayout, QSpinBox,QPushButton,QLabel
import numpy as np 
import os 

class StatusBar(QStatusBar):
    def __init__(self, main_window):
        super().__init__()

        self.main_window = main_window
        self.central_widget = self.main_window.central_widget
        self.vector_curation_t2p=None 
        self.init_status_bar()

    def init_status_bar(self):
        status_widget = QWidget()
        layout = QHBoxLayout()

        self.spin_box = QSpinBox()
        self.spin_box.setFixedWidth(100)
        self.spin_box.valueChanged.connect(self.iterate_all_rois)

        self.roi_state = QLabel("state of ROI: ")
        self.roi_state.setFixedWidth(100)
        self.roi_state_value = QLabel()
        self.roi_state_value.setFixedWidth(30)

        not_cell_button = QPushButton('✖️')
        not_cell_button.setFixedSize(20, 20)
        not_cell_button.setStyleSheet("background-color: red; color: white; border: none;")
        not_cell_button.clicked.connect(self.set_roi_as_not_cell)

        cell_button = QPushButton('✓')
        cell_button.setFixedSize(20, 20)
        cell_button.setStyleSheet("background-color: green; color: white; border: none;")
        cell_button.clicked.connect(self.set_roi_as_cell)

        reset_button = QPushButton('Apply curation')
        reset_button.setFixedSize(100, 20)
        reset_button.setStyleSheet("background-color: grey; color: white; border: none;")
        reset_button.clicked.connect(self.main_window.central_widget.create_mean_img_from_curation)


        layout.addWidget(self.spin_box)
        layout.addWidget(self.roi_state)
        layout.addWidget(self.roi_state_value)
        layout.addWidget(not_cell_button)
        layout.addWidget(cell_button)
        layout.addWidget(reset_button)

        status_widget.setLayout(layout)
        self.addWidget(status_widget)
        
    def iterate_all_rois(self):
        current_ROI = self.spin_box.value()
        value=self.vector_curation_t2p[current_ROI] 
        self.roi_state_value.setText(f"{value}") 
        self.central_widget.update_selection(current_ROI) 

    def set_roi_as_not_cell(self):
        plane=self.central_widget.data_management.plane
        key='vector_curation_plane_' + str(plane)
        self.vector_curation_t2p = self.main_window.central_widget.data_management.vector_curation_t2p
        if self.vector_curation_t2p[self.spin_box.value()] ==1:
            self.vector_curation_t2p[self.spin_box.value()]= 0
            current_ROI = self.spin_box.value() 
            value=self.vector_curation_t2p [current_ROI] 
            self.roi_state_value.setText(f"{value}")
            self.central_widget.track_ops_dict[key] = self.vector_curation_t2p
            np.save(os.path.join(self.central_widget.data_management.track_ops.save_path, "track_ops.npy"), self.central_widget.track_ops_dict)
           
    def set_roi_as_cell(self):
        plane=self.central_widget.data_management.plane
        key='vector_curation_plane_' + str(plane)
        self.vector_curation_t2p = self.main_window.central_widget.data_management.vector_curation_t2p
        if self.vector_curation_t2p[self.spin_box.value()] ==0:
            self.vector_curation_t2p[self.spin_box.value()]= 1
            current_ROI = self.spin_box.value() 
            value=self.vector_curation_t2p[current_ROI] 
            self.roi_state_value.setText(f"{value}")
            self.central_widget.track_ops_dict[key] = self.vector_curation_t2p
            np.save(os.path.join(self.central_widget.data_management.track_ops.save_path, "track_ops.npy"), self.central_widget.track_ops_dict)


    
    