from PyQt5.QtWidgets import QToolBar,QMenu,QAction,QToolButton

class Toolbar(QToolBar):
    def __init__(self, main_window):
        super().__init__()

        self.main_window = main_window
        self.init_tool_bar()

    def init_tool_bar(self):
        data_menu = QMenu(self)
        run_menu = QMenu(self)
        visualization_menu = QMenu(self)

        import_action = QAction("Load processed data (⌘L or Ctrl+L)", self)
        import_action.setShortcut("Ctrl+L")
        import_action.triggered.connect(self.main_window.window_manager.open_import_wd)
        data_menu.addAction(import_action)

        track2p_action = QAction("Run track2p algorithm (⌘R or Ctrl+R)", self)
        track2p_action.setShortcut("Ctrl+R")
        track2p_action.triggered.connect(self.main_window.window_manager.open_track2p_wd)
        run_menu.addAction(track2p_action)

        raster_action = QAction("Generate raster plot (⌘G or Ctrl+G)", self)
        raster_action.setShortcut("Ctrl+G")
        raster_action.triggered.connect(self.main_window.window_manager.open_raster_wd)
        visualization_menu.addAction(raster_action)

        self.add_tool_menu("File", data_menu)
        self.add_tool_menu("Run", run_menu)
        self.add_tool_menu("Visualization", visualization_menu)

    def add_tool_menu(self, name, menu):
        button = QToolButton(self)
        button.setText(name)
        button.setMenu(menu)
        button.setPopupMode(QToolButton.InstantPopup)
        button.setStyleSheet("font-size: 13px")
        self.addWidget(button)
        
    