[![codecov](https://codecov.io/github/LSSTDESC/sacc/graph/badge.svg?token=YZf4IXbzA0)](https://codecov.io/github/LSSTDESC/sacc)

Sacc
====

SACC (Save All Correlations and Covariances) is a format and reference library for general storage
of summary statistic measurements for the Dark Energy Science Collaboration (DESC) within the Large Synoptic
Survey Telescope (LSST) project.


Installation
------------

You can install sacc with the command:

``pip install sacc``

(For local installation you might need to add `--user`)

Or for development versions you can download the repository with git and install from there using ``python setup.py install``


Documentation & Examples
------------------------

Documentation can be found [on ReadTheDocs](https://sacc.readthedocs.io/en/latest/).

The [examples directory](https://github.com/LSSTDESC/sacc/tree/master/examples) on github contains ipython notebooks showing various ways of constructing and using sacc data files.

If you have a problem you've not been able to debug, or a feature request/suggestion the you can [open an issue](https://github.com/LSSTDESC/sacc/issues) to discuss it.

Versions
--------

The current release is [version 0.12](https://github.com/LSSTDESC/sacc/releases/tag/0.12).

You can find a list of [previous releases here](https://github.com/LSSTDESC/sacc/releases).  The releases above 0.2 are all backwards compatible; 0.1 is a previous version of the format.

The master branch includes more recent (non-released) development changes.


Citation
--------

Sacc has been submitted to the [Astrophysics Source Code Library](https://ascl.net/code/v/2277); follow the link that will appear there to NASA ADS to export a bibtex citation.

The core developers of Sacc are Joe Zuntz (maintainer), David Alonso, and Matt Becker.
