# generated by datamodel-codegen:
#   filename:  schema.json
#   timestamp: 2025-10-09T19:10:06+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import BaseModel, Field


class MiniSeriesDTO(BaseModel):
    losses: int
    progress: str
    target: int
    wins: int


class LeagueEntryDTO(BaseModel):
    league_id: Optional[str] = Field(None, alias="leagueId")
    puuid: str = Field(..., description="Player's encrypted puuid.")
    queue_type: str = Field(..., alias="queueType")
    tier: Optional[str] = None
    rank: Optional[str] = Field(
        None, description="The player's division within a tier."
    )
    league_points: int = Field(..., alias="leaguePoints")
    wins: int = Field(..., description="Winning team on Summoners Rift.")
    losses: int = Field(..., description="Losing team on Summoners Rift.")
    hot_streak: bool = Field(..., alias="hotStreak")
    veteran: bool
    fresh_blood: bool = Field(..., alias="freshBlood")
    inactive: bool
    mini_series: Optional[MiniSeriesDTO] = Field(None, alias="miniSeries")
    summoner_id: Optional[str] = Field(
        None,
        alias="summonerId",
        description="Encrypted summoner ID. This field is deprecated and will be removed. Use `puuid` instead.",
    )


class LeagueItemDTO(BaseModel):
    fresh_blood: bool = Field(..., alias="freshBlood")
    wins: int = Field(..., description="Winning team on Summoners Rift.")
    mini_series: Optional[MiniSeriesDTO] = Field(None, alias="miniSeries")
    inactive: bool
    veteran: bool
    hot_streak: bool = Field(..., alias="hotStreak")
    rank: str
    league_points: int = Field(..., alias="leaguePoints")
    losses: int = Field(..., description="Losing team on Summoners Rift.")
    puuid: str = Field(..., description="Player's encrypted puuid.")
    summoner_id: Optional[str] = Field(
        None,
        alias="summonerId",
        description="Encrypted summoner ID. This field is deprecated and will be removed. Use `puuid` instead.",
    )


class LeagueListDTO(BaseModel):
    league_id: Optional[str] = Field(None, alias="leagueId")
    entries: List[LeagueItemDTO]
    tier: str
    name: Optional[str] = None
    queue: Optional[str] = None
