# generated by datamodel-codegen:
#   filename:  schema.json
#   timestamp: 2025-10-09T19:10:06+00:00

from __future__ import annotations

from enum import Enum
from typing import Dict, List, Optional

from pydantic import BaseModel, Field


class MetadataDto(BaseModel):
    data_version: str = Field(
        ..., alias="dataVersion", description="Match data version."
    )
    match_id: str = Field(..., alias="matchId", description="Match id.")
    participants: List[str] = Field(..., description="A list of participant PUUIDs.")


class FasterSupportQuestCompletion(Enum):
    integer_0 = 0
    integer_1 = 1


class HadAfkTeammate(Enum):
    integer_0 = 0
    integer_1 = 1


class HighestCrowdControlScore(Enum):
    integer_0 = 0
    integer_1 = 1


class HighestWardKills(Enum):
    integer_0 = 0
    integer_1 = 1


class LaningPhaseGoldExpAdvantage(Enum):
    integer_0 = 0
    integer_1 = 1


class PlayedChampSelectPosition(Enum):
    integer_0 = 0
    integer_1 = 1


class ChallengesDto(BaseModel):
    field_12_assist_streak_count: Optional[int] = Field(
        None, alias="12AssistStreakCount"
    )
    baron_buff_gold_advantage_over_threshold: Optional[int] = Field(
        None, alias="baronBuffGoldAdvantageOverThreshold"
    )
    control_ward_time_coverage_in_river_or_enemy_half: Optional[float] = Field(
        None, alias="controlWardTimeCoverageInRiverOrEnemyHalf"
    )
    earliest_baron: Optional[float] = Field(None, alias="earliestBaron")
    earliest_dragon_takedown: Optional[float] = Field(
        None, alias="earliestDragonTakedown"
    )
    earliest_elder_dragon: Optional[float] = Field(None, alias="earliestElderDragon")
    early_laning_phase_gold_exp_advantage: Optional[float] = Field(
        None, alias="earlyLaningPhaseGoldExpAdvantage"
    )
    faster_support_quest_completion: Optional[FasterSupportQuestCompletion] = Field(
        None, alias="fasterSupportQuestCompletion"
    )
    fastest_legendary: Optional[float] = Field(None, alias="fastestLegendary")
    had_afk_teammate: Optional[HadAfkTeammate] = Field(None, alias="hadAfkTeammate")
    highest_champion_damage: Optional[int] = Field(None, alias="highestChampionDamage")
    highest_crowd_control_score: Optional[HighestCrowdControlScore] = Field(
        None, alias="highestCrowdControlScore"
    )
    highest_ward_kills: Optional[HighestWardKills] = Field(
        None, alias="highestWardKills"
    )
    jungler_kills_early_jungle: Optional[int] = Field(
        None, alias="junglerKillsEarlyJungle"
    )
    kills_on_laners_early_jungle_as_jungler: Optional[int] = Field(
        None, alias="killsOnLanersEarlyJungleAsJungler"
    )
    laning_phase_gold_exp_advantage: Optional[LaningPhaseGoldExpAdvantage] = Field(
        None, alias="laningPhaseGoldExpAdvantage"
    )
    legendary_count: Optional[int] = Field(None, alias="legendaryCount")
    max_cs_advantage_on_lane_opponent: Optional[float] = Field(
        None, alias="maxCsAdvantageOnLaneOpponent"
    )
    max_level_lead_lane_opponent: Optional[int] = Field(
        None, alias="maxLevelLeadLaneOpponent"
    )
    most_wards_destroyed_one_sweeper: Optional[int] = Field(
        None, alias="mostWardsDestroyedOneSweeper"
    )
    mythic_item_used: Optional[int] = Field(None, alias="mythicItemUsed")
    played_champ_select_position: Optional[PlayedChampSelectPosition] = Field(
        None, alias="playedChampSelectPosition"
    )
    solo_turrets_lategame: Optional[int] = Field(None, alias="soloTurretsLategame")
    takedowns_first25_minutes: Optional[int] = Field(
        None, alias="takedownsFirst25Minutes"
    )
    teleport_takedowns: Optional[int] = Field(None, alias="teleportTakedowns")
    third_inhibitor_destroyed_time: Optional[float] = Field(
        None, alias="thirdInhibitorDestroyedTime"
    )
    three_wards_one_sweeper_count: Optional[int] = Field(
        None, alias="threeWardsOneSweeperCount"
    )
    vision_score_advantage_lane_opponent: Optional[float] = Field(
        None, alias="visionScoreAdvantageLaneOpponent"
    )
    infernal_scale_pickup: Optional[int] = Field(None, alias="InfernalScalePickup")
    fist_bump_participation: Optional[int] = Field(None, alias="fistBumpParticipation")
    void_monster_kill: Optional[int] = Field(None, alias="voidMonsterKill")
    ability_uses: Optional[int] = Field(None, alias="abilityUses")
    aces_before15_minutes: Optional[int] = Field(None, alias="acesBefore15Minutes")
    allied_jungle_monster_kills: Optional[float] = Field(
        None, alias="alliedJungleMonsterKills"
    )
    baron_takedowns: Optional[int] = Field(None, alias="baronTakedowns")
    blast_cone_opposite_opponent_count: Optional[int] = Field(
        None, alias="blastConeOppositeOpponentCount"
    )
    bounty_gold: Optional[float] = Field(None, alias="bountyGold")
    buffs_stolen: Optional[int] = Field(None, alias="buffsStolen")
    complete_support_quest_in_time: Optional[int] = Field(
        None, alias="completeSupportQuestInTime"
    )
    control_wards_placed: Optional[int] = Field(None, alias="controlWardsPlaced")
    damage_per_minute: Optional[float] = Field(None, alias="damagePerMinute")
    damage_taken_on_team_percentage: Optional[float] = Field(
        None, alias="damageTakenOnTeamPercentage"
    )
    danced_with_rift_herald: Optional[int] = Field(None, alias="dancedWithRiftHerald")
    deaths_by_enemy_champs: Optional[int] = Field(None, alias="deathsByEnemyChamps")
    dodge_skill_shots_small_window: Optional[int] = Field(
        None, alias="dodgeSkillShotsSmallWindow"
    )
    double_aces: Optional[int] = Field(None, alias="doubleAces")
    dragon_takedowns: Optional[int] = Field(None, alias="dragonTakedowns")
    legendary_item_used: Optional[List[int]] = Field(None, alias="legendaryItemUsed")
    effective_heal_and_shielding: Optional[float] = Field(
        None, alias="effectiveHealAndShielding"
    )
    elder_dragon_kills_with_opposing_soul: Optional[int] = Field(
        None, alias="elderDragonKillsWithOpposingSoul"
    )
    elder_dragon_multikills: Optional[int] = Field(None, alias="elderDragonMultikills")
    enemy_champion_immobilizations: Optional[int] = Field(
        None, alias="enemyChampionImmobilizations"
    )
    enemy_jungle_monster_kills: Optional[float] = Field(
        None, alias="enemyJungleMonsterKills"
    )
    epic_monster_kills_near_enemy_jungler: Optional[int] = Field(
        None, alias="epicMonsterKillsNearEnemyJungler"
    )
    epic_monster_kills_within30_seconds_of_spawn: Optional[int] = Field(
        None, alias="epicMonsterKillsWithin30SecondsOfSpawn"
    )
    epic_monster_steals: Optional[int] = Field(None, alias="epicMonsterSteals")
    epic_monster_stolen_without_smite: Optional[int] = Field(
        None, alias="epicMonsterStolenWithoutSmite"
    )
    first_turret_killed: Optional[float] = Field(None, alias="firstTurretKilled")
    first_turret_killed_time: Optional[float] = Field(
        None, alias="firstTurretKilledTime"
    )
    flawless_aces: Optional[int] = Field(None, alias="flawlessAces")
    full_team_takedown: Optional[int] = Field(None, alias="fullTeamTakedown")
    game_length: Optional[float] = Field(None, alias="gameLength")
    get_takedowns_in_all_lanes_early_jungle_as_laner: Optional[int] = Field(
        None, alias="getTakedownsInAllLanesEarlyJungleAsLaner"
    )
    gold_per_minute: Optional[float] = Field(None, alias="goldPerMinute")
    had_open_nexus: Optional[int] = Field(None, alias="hadOpenNexus")
    immobilize_and_kill_with_ally: Optional[int] = Field(
        None, alias="immobilizeAndKillWithAlly"
    )
    initial_buff_count: Optional[int] = Field(None, alias="initialBuffCount")
    initial_crab_count: Optional[int] = Field(None, alias="initialCrabCount")
    jungle_cs_before10_minutes: Optional[float] = Field(
        None, alias="jungleCsBefore10Minutes"
    )
    jungler_takedowns_near_damaged_epic_monster: Optional[int] = Field(
        None, alias="junglerTakedownsNearDamagedEpicMonster"
    )
    kda: Optional[float] = None
    kill_after_hidden_with_ally: Optional[int] = Field(
        None, alias="killAfterHiddenWithAlly"
    )
    killed_champ_took_full_team_damage_survived: Optional[int] = Field(
        None, alias="killedChampTookFullTeamDamageSurvived"
    )
    killing_sprees: Optional[int] = Field(None, alias="killingSprees")
    kill_participation: Optional[float] = Field(None, alias="killParticipation")
    kills_near_enemy_turret: Optional[int] = Field(None, alias="killsNearEnemyTurret")
    kills_on_other_lanes_early_jungle_as_laner: Optional[int] = Field(
        None, alias="killsOnOtherLanesEarlyJungleAsLaner"
    )
    kills_on_recently_healed_by_aram_pack: Optional[int] = Field(
        None, alias="killsOnRecentlyHealedByAramPack"
    )
    kills_under_own_turret: Optional[int] = Field(None, alias="killsUnderOwnTurret")
    kills_with_help_from_epic_monster: Optional[int] = Field(
        None, alias="killsWithHelpFromEpicMonster"
    )
    knock_enemy_into_team_and_kill: Optional[int] = Field(
        None, alias="knockEnemyIntoTeamAndKill"
    )
    k_turrets_destroyed_before_plates_fall: Optional[int] = Field(
        None, alias="kTurretsDestroyedBeforePlatesFall"
    )
    land_skill_shots_early_game: Optional[int] = Field(
        None, alias="landSkillShotsEarlyGame"
    )
    lane_minions_first10_minutes: Optional[int] = Field(
        None, alias="laneMinionsFirst10Minutes"
    )
    lost_an_inhibitor: Optional[int] = Field(None, alias="lostAnInhibitor")
    max_kill_deficit: Optional[int] = Field(None, alias="maxKillDeficit")
    mejais_full_stack_in_time: Optional[int] = Field(
        None, alias="mejaisFullStackInTime"
    )
    more_enemy_jungle_than_opponent: Optional[float] = Field(
        None, alias="moreEnemyJungleThanOpponent"
    )
    multi_kill_one_spell: Optional[int] = Field(
        None,
        alias="multiKillOneSpell",
        description="This is an offshoot of the OneStone challenge. The code checks if a spell with the same instance ID does the final point of damage to at least 2 Champions. It doesn't matter if they're enemies, but you cannot hurt your friends.",
    )
    multikills: Optional[int] = None
    multikills_after_aggressive_flash: Optional[int] = Field(
        None, alias="multikillsAfterAggressiveFlash"
    )
    multi_turret_rift_herald_count: Optional[int] = Field(
        None, alias="multiTurretRiftHeraldCount"
    )
    outer_turret_executes_before10_minutes: Optional[int] = Field(
        None, alias="outerTurretExecutesBefore10Minutes"
    )
    outnumbered_kills: Optional[int] = Field(None, alias="outnumberedKills")
    outnumbered_nexus_kill: Optional[int] = Field(None, alias="outnumberedNexusKill")
    perfect_dragon_souls_taken: Optional[int] = Field(
        None, alias="perfectDragonSoulsTaken"
    )
    perfect_game: Optional[int] = Field(None, alias="perfectGame")
    pick_kill_with_ally: Optional[int] = Field(None, alias="pickKillWithAlly")
    poro_explosions: Optional[int] = Field(None, alias="poroExplosions")
    quick_cleanse: Optional[int] = Field(None, alias="quickCleanse")
    quick_first_turret: Optional[int] = Field(None, alias="quickFirstTurret")
    quick_solo_kills: Optional[int] = Field(None, alias="quickSoloKills")
    rift_herald_takedowns: Optional[int] = Field(None, alias="riftHeraldTakedowns")
    save_ally_from_death: Optional[int] = Field(None, alias="saveAllyFromDeath")
    scuttle_crab_kills: Optional[int] = Field(None, alias="scuttleCrabKills")
    shortest_time_to_ace_from_first_takedown: Optional[float] = Field(
        None, alias="shortestTimeToAceFromFirstTakedown"
    )
    skillshots_dodged: Optional[int] = Field(None, alias="skillshotsDodged")
    skillshots_hit: Optional[int] = Field(None, alias="skillshotsHit")
    snowballs_hit: Optional[int] = Field(None, alias="snowballsHit")
    solo_baron_kills: Optional[int] = Field(None, alias="soloBaronKills")
    swarm_defeat_aatrox: Optional[int] = Field(None, alias="SWARM_DefeatAatrox")
    swarm_defeat_briar: Optional[int] = Field(None, alias="SWARM_DefeatBriar")
    swarm_defeat_mini_bosses: Optional[int] = Field(
        None, alias="SWARM_DefeatMiniBosses"
    )
    swarm_evolve_weapon: Optional[int] = Field(None, alias="SWARM_EvolveWeapon")
    swarm_have3_passives: Optional[int] = Field(None, alias="SWARM_Have3Passives")
    swarm_kill_enemy: Optional[int] = Field(None, alias="SWARM_KillEnemy")
    swarm_pickup_gold: Optional[float] = Field(None, alias="SWARM_PickupGold")
    swarm_reach_level50: Optional[int] = Field(None, alias="SWARM_ReachLevel50")
    swarm_survive15_min: Optional[int] = Field(None, alias="SWARM_Survive15Min")
    swarm_win_with5_evolved_weapons: Optional[int] = Field(
        None, alias="SWARM_WinWith5EvolvedWeapons"
    )
    solo_kills: Optional[int] = Field(None, alias="soloKills")
    stealth_wards_placed: Optional[int] = Field(None, alias="stealthWardsPlaced")
    survived_single_digit_hp_count: Optional[int] = Field(
        None, alias="survivedSingleDigitHpCount"
    )
    survived_three_immobilizes_in_fight: Optional[int] = Field(
        None, alias="survivedThreeImmobilizesInFight"
    )
    takedown_on_first_turret: Optional[int] = Field(None, alias="takedownOnFirstTurret")
    takedowns: Optional[int] = None
    takedowns_after_gaining_level_advantage: Optional[int] = Field(
        None, alias="takedownsAfterGainingLevelAdvantage"
    )
    takedowns_before_jungle_minion_spawn: Optional[int] = Field(
        None, alias="takedownsBeforeJungleMinionSpawn"
    )
    takedowns_first_x_minutes: Optional[int] = Field(
        None, alias="takedownsFirstXMinutes"
    )
    takedowns_in_alcove: Optional[int] = Field(None, alias="takedownsInAlcove")
    takedowns_in_enemy_fountain: Optional[int] = Field(
        None, alias="takedownsInEnemyFountain"
    )
    team_baron_kills: Optional[int] = Field(None, alias="teamBaronKills")
    team_damage_percentage: Optional[float] = Field(None, alias="teamDamagePercentage")
    team_elder_dragon_kills: Optional[int] = Field(None, alias="teamElderDragonKills")
    team_rift_herald_kills: Optional[int] = Field(None, alias="teamRiftHeraldKills")
    took_large_damage_survived: Optional[int] = Field(
        None, alias="tookLargeDamageSurvived"
    )
    turret_plates_taken: Optional[int] = Field(None, alias="turretPlatesTaken")
    turrets_taken_with_rift_herald: Optional[int] = Field(
        None,
        alias="turretsTakenWithRiftHerald",
        description="Any player who damages a tower that is destroyed within 30 seconds of a Rift Herald charge will receive credit. A player who does not damage the tower will not receive credit.",
    )
    turret_takedowns: Optional[int] = Field(None, alias="turretTakedowns")
    twenty_minions_in3_seconds_count: Optional[int] = Field(
        None, alias="twentyMinionsIn3SecondsCount"
    )
    two_wards_one_sweeper_count: Optional[int] = Field(
        None, alias="twoWardsOneSweeperCount"
    )
    unseen_recalls: Optional[int] = Field(None, alias="unseenRecalls")
    vision_score_per_minute: Optional[float] = Field(None, alias="visionScorePerMinute")
    wards_guarded: Optional[int] = Field(None, alias="wardsGuarded")
    ward_takedowns: Optional[int] = Field(None, alias="wardTakedowns")
    ward_takedowns_before20_m: Optional[int] = Field(
        None, alias="wardTakedownsBefore20M"
    )
    heal_from_map_sources: Optional[float] = Field(None, alias="HealFromMapSources")


class MissionsDto(BaseModel):
    player_score0: Optional[float] = Field(None, alias="playerScore0")
    player_score1: Optional[float] = Field(None, alias="playerScore1")
    player_score2: Optional[float] = Field(None, alias="playerScore2")
    player_score3: Optional[float] = Field(None, alias="playerScore3")
    player_score4: Optional[float] = Field(None, alias="playerScore4")
    player_score5: Optional[float] = Field(None, alias="playerScore5")
    player_score6: Optional[float] = Field(None, alias="playerScore6")
    player_score7: Optional[float] = Field(None, alias="playerScore7")
    player_score8: Optional[float] = Field(None, alias="playerScore8")
    player_score9: Optional[float] = Field(None, alias="playerScore9")
    player_score10: Optional[float] = Field(None, alias="playerScore10")
    player_score11: Optional[float] = Field(None, alias="playerScore11")


class PerkStatsDto(BaseModel):
    defense: int
    flex: int
    offense: int


class PerkStyleSelectionDto(BaseModel):
    perk: int
    var1: int
    var2: int
    var3: int


class BanDto(BaseModel):
    champion_id: int = Field(..., alias="championId")
    pick_turn: int = Field(..., alias="pickTurn")


class ObjectiveDto(BaseModel):
    first: bool
    kills: int


class MetadataTimeLineDto(BaseModel):
    data_version: str = Field(
        ..., alias="dataVersion", description="Match data version."
    )
    match_id: str = Field(..., alias="matchId", description="Match id.")
    participants: List[str] = Field(..., description="A list of participant PUUIDs.")


class ParticipantTimeLineDto(BaseModel):
    participant_id: int = Field(..., alias="participantId")
    puuid: str


class ChampionStatsDto(BaseModel):
    ability_haste: Optional[int] = Field(None, alias="abilityHaste")
    ability_power: int = Field(..., alias="abilityPower")
    armor: int
    armor_pen: int = Field(..., alias="armorPen")
    armor_pen_percent: int = Field(..., alias="armorPenPercent")
    attack_damage: int = Field(..., alias="attackDamage")
    attack_speed: int = Field(..., alias="attackSpeed")
    bonus_armor_pen_percent: int = Field(..., alias="bonusArmorPenPercent")
    bonus_magic_pen_percent: int = Field(..., alias="bonusMagicPenPercent")
    cc_reduction: int = Field(..., alias="ccReduction")
    cooldown_reduction: int = Field(..., alias="cooldownReduction")
    health: int
    health_max: int = Field(..., alias="healthMax")
    health_regen: int = Field(..., alias="healthRegen")
    lifesteal: int
    magic_pen: int = Field(..., alias="magicPen")
    magic_pen_percent: int = Field(..., alias="magicPenPercent")
    magic_resist: int = Field(..., alias="magicResist")
    movement_speed: int = Field(..., alias="movementSpeed")
    omnivamp: Optional[int] = None
    physical_vamp: Optional[int] = Field(None, alias="physicalVamp")
    power: int
    power_max: int = Field(..., alias="powerMax")
    power_regen: int = Field(..., alias="powerRegen")
    spell_vamp: int = Field(..., alias="spellVamp")


class DamageStatsDto(BaseModel):
    magic_damage_done: int = Field(..., alias="magicDamageDone")
    magic_damage_done_to_champions: int = Field(..., alias="magicDamageDoneToChampions")
    magic_damage_taken: int = Field(..., alias="magicDamageTaken")
    physical_damage_done: int = Field(..., alias="physicalDamageDone")
    physical_damage_done_to_champions: int = Field(
        ..., alias="physicalDamageDoneToChampions"
    )
    physical_damage_taken: int = Field(..., alias="physicalDamageTaken")
    total_damage_done: int = Field(..., alias="totalDamageDone")
    total_damage_done_to_champions: int = Field(..., alias="totalDamageDoneToChampions")
    total_damage_taken: int = Field(..., alias="totalDamageTaken")
    true_damage_done: int = Field(..., alias="trueDamageDone")
    true_damage_done_to_champions: int = Field(..., alias="trueDamageDoneToChampions")
    true_damage_taken: int = Field(..., alias="trueDamageTaken")


class PositionDto(BaseModel):
    x: int
    y: int


class MatchTimelineVictimDamage(BaseModel):
    basic: bool
    magic_damage: int = Field(..., alias="magicDamage")
    name: str
    participant_id: int = Field(..., alias="participantId")
    physical_damage: int = Field(..., alias="physicalDamage")
    spell_name: str = Field(..., alias="spellName")
    spell_slot: int = Field(..., alias="spellSlot")
    true_damage: int = Field(..., alias="trueDamage")
    type: str


class FeatDto(BaseModel):
    feat_state: Optional[int] = Field(None, alias="featState")


class PerkStyleDto(BaseModel):
    description: str
    selections: List[PerkStyleSelectionDto]
    style: int


class ObjectivesDto(BaseModel):
    baron: ObjectiveDto
    champion: ObjectiveDto
    dragon: ObjectiveDto
    horde: Optional[ObjectiveDto] = None
    inhibitor: ObjectiveDto
    rift_herald: ObjectiveDto = Field(..., alias="riftHerald")
    tower: ObjectiveDto
    atakhan: Optional[ObjectiveDto] = None


class EventsTimeLineDto(BaseModel):
    timestamp: int
    real_timestamp: Optional[int] = Field(None, alias="realTimestamp")
    type: str
    item_id: Optional[int] = Field(None, alias="itemId")
    participant_id: Optional[int] = Field(None, alias="participantId")
    level_up_type: Optional[str] = Field(None, alias="levelUpType")
    skill_slot: Optional[int] = Field(None, alias="skillSlot")
    creator_id: Optional[int] = Field(None, alias="creatorId")
    ward_type: Optional[str] = Field(None, alias="wardType")
    level: Optional[int] = None
    assisting_participant_ids: Optional[List[int]] = Field(
        None, alias="assistingParticipantIds"
    )
    bounty: Optional[int] = None
    kill_streak_length: Optional[int] = Field(None, alias="killStreakLength")
    killer_id: Optional[int] = Field(None, alias="killerId")
    position: Optional[PositionDto] = None
    victim_damage_dealt: Optional[List[MatchTimelineVictimDamage]] = Field(
        None, alias="victimDamageDealt"
    )
    victim_damage_received: Optional[List[MatchTimelineVictimDamage]] = Field(
        None, alias="victimDamageReceived"
    )
    victim_id: Optional[int] = Field(None, alias="victimId")
    kill_type: Optional[str] = Field(None, alias="killType")
    lane_type: Optional[str] = Field(None, alias="laneType")
    team_id: Optional[int] = Field(None, alias="teamId")
    multi_kill_length: Optional[int] = Field(None, alias="multiKillLength")
    killer_team_id: Optional[int] = Field(None, alias="killerTeamId")
    monster_type: Optional[str] = Field(None, alias="monsterType")
    monster_sub_type: Optional[str] = Field(None, alias="monsterSubType")
    building_type: Optional[str] = Field(None, alias="buildingType")
    tower_type: Optional[str] = Field(None, alias="towerType")
    after_id: Optional[int] = Field(None, alias="afterId")
    before_id: Optional[int] = Field(None, alias="beforeId")
    gold_gain: Optional[int] = Field(None, alias="goldGain")
    game_id: Optional[int] = Field(None, alias="gameId")
    winning_team: Optional[int] = Field(None, alias="winningTeam")
    transform_type: Optional[str] = Field(None, alias="transformType")
    name: Optional[str] = None
    shutdown_bounty: Optional[int] = Field(None, alias="shutdownBounty")
    actual_start_time: Optional[int] = Field(None, alias="actualStartTime")
    feat_type: Optional[int] = Field(None, alias="featType")
    feat_value: Optional[int] = Field(None, alias="featValue")


class ParticipantFrameDto(BaseModel):
    champion_stats: ChampionStatsDto = Field(..., alias="championStats")
    current_gold: int = Field(..., alias="currentGold")
    damage_stats: DamageStatsDto = Field(..., alias="damageStats")
    gold_per_second: int = Field(..., alias="goldPerSecond")
    jungle_minions_killed: int = Field(..., alias="jungleMinionsKilled")
    level: int
    minions_killed: int = Field(..., alias="minionsKilled")
    participant_id: int = Field(..., alias="participantId")
    position: PositionDto
    time_enemy_spent_controlled: int = Field(..., alias="timeEnemySpentControlled")
    total_gold: int = Field(..., alias="totalGold")
    xp: int


class FeatsDto(BaseModel):
    epic_monster_kill: Optional[FeatDto] = Field(None, alias="EPIC_MONSTER_KILL")
    first_blood: Optional[FeatDto] = Field(None, alias="FIRST_BLOOD")
    first_turret: Optional[FeatDto] = Field(None, alias="FIRST_TURRET")


class PerksDto(BaseModel):
    stat_perks: PerkStatsDto = Field(..., alias="statPerks")
    styles: List[PerkStyleDto]


class TeamDto(BaseModel):
    bans: List[BanDto]
    objectives: ObjectivesDto
    team_id: int = Field(..., alias="teamId")
    win: bool
    feats: Optional[FeatsDto] = None


class FramesTimeLineDto(BaseModel):
    events: List[EventsTimeLineDto]
    participant_frames: Optional[Dict[str, ParticipantFrameDto]] = Field(
        None, alias="participantFrames"
    )
    timestamp: int


class ParticipantFramesDto(BaseModel):
    field_1_9: ParticipantFrameDto = Field(
        ..., alias="1-9", description="Key value mapping for each participant"
    )


class ParticipantDto(BaseModel):
    all_in_pings: Optional[int] = Field(
        None, alias="allInPings", description="Yellow crossed swords"
    )
    assist_me_pings: Optional[int] = Field(
        None, alias="assistMePings", description="Green flag"
    )
    assists: int
    baron_kills: int = Field(..., alias="baronKills")
    bounty_level: Optional[int] = Field(None, alias="bountyLevel")
    champ_experience: int = Field(..., alias="champExperience")
    champ_level: int = Field(..., alias="champLevel")
    champion_id: int = Field(
        ...,
        alias="championId",
        description="Prior to patch 11.4, on Feb 18th, 2021, this field returned invalid championIds. We recommend determining the champion based on the championName field for matches played prior to patch 11.4.",
    )
    champion_name: str = Field(..., alias="championName")
    command_pings: Optional[int] = Field(
        None, alias="commandPings", description="Blue generic ping (ALT+click)"
    )
    champion_transform: int = Field(
        ...,
        alias="championTransform",
        description="This field is currently only utilized for Kayn's transformations. (Legal values: 0 - None, 1 - Slayer, 2 - Assassin)",
    )
    consumables_purchased: int = Field(..., alias="consumablesPurchased")
    challenges: Optional[ChallengesDto] = None
    damage_dealt_to_buildings: Optional[int] = Field(
        None, alias="damageDealtToBuildings"
    )
    damage_dealt_to_objectives: int = Field(..., alias="damageDealtToObjectives")
    damage_dealt_to_turrets: int = Field(..., alias="damageDealtToTurrets")
    damage_self_mitigated: int = Field(..., alias="damageSelfMitigated")
    deaths: int
    detector_wards_placed: int = Field(..., alias="detectorWardsPlaced")
    double_kills: int = Field(..., alias="doubleKills")
    dragon_kills: int = Field(..., alias="dragonKills")
    eligible_for_progression: Optional[bool] = Field(
        None, alias="eligibleForProgression"
    )
    enemy_missing_pings: Optional[int] = Field(
        None, alias="enemyMissingPings", description="Yellow questionmark"
    )
    enemy_vision_pings: Optional[int] = Field(
        None, alias="enemyVisionPings", description="Red eyeball"
    )
    first_blood_assist: bool = Field(..., alias="firstBloodAssist")
    first_blood_kill: bool = Field(..., alias="firstBloodKill")
    first_tower_assist: bool = Field(..., alias="firstTowerAssist")
    first_tower_kill: bool = Field(..., alias="firstTowerKill")
    game_ended_in_early_surrender: bool = Field(
        ...,
        alias="gameEndedInEarlySurrender",
        description="This is an offshoot of the OneStone challenge. The code checks if a spell with the same instance ID does the final point of damage to at least 2 Champions. It doesn't matter if they're enemies, but you cannot hurt your friends.",
    )
    game_ended_in_surrender: bool = Field(..., alias="gameEndedInSurrender")
    hold_pings: Optional[int] = Field(None, alias="holdPings")
    get_back_pings: Optional[int] = Field(
        None, alias="getBackPings", description="Yellow circle with horizontal line"
    )
    gold_earned: int = Field(..., alias="goldEarned")
    gold_spent: int = Field(..., alias="goldSpent")
    individual_position: str = Field(
        ...,
        alias="individualPosition",
        description="Both individualPosition and teamPosition are computed by the game server and are different versions of the most likely position played by a player. The individualPosition is the best guess for which position the player actually played in isolation of anything else. The teamPosition is the best guess for which position the player actually played if we add the constraint that each team must have one top player, one jungle, one middle, etc. Generally the recommendation is to use the teamPosition field over the individualPosition field.",
    )
    inhibitor_kills: int = Field(..., alias="inhibitorKills")
    inhibitor_takedowns: Optional[int] = Field(None, alias="inhibitorTakedowns")
    inhibitors_lost: Optional[int] = Field(None, alias="inhibitorsLost")
    item0: int
    item1: int
    item2: int
    item3: int
    item4: int
    item5: int
    item6: int
    items_purchased: int = Field(..., alias="itemsPurchased")
    killing_sprees: int = Field(..., alias="killingSprees")
    kills: int
    lane: str
    largest_critical_strike: int = Field(..., alias="largestCriticalStrike")
    largest_killing_spree: int = Field(..., alias="largestKillingSpree")
    largest_multi_kill: int = Field(..., alias="largestMultiKill")
    longest_time_spent_living: int = Field(..., alias="longestTimeSpentLiving")
    magic_damage_dealt: int = Field(..., alias="magicDamageDealt")
    magic_damage_dealt_to_champions: int = Field(
        ..., alias="magicDamageDealtToChampions"
    )
    magic_damage_taken: int = Field(..., alias="magicDamageTaken")
    missions: Optional[MissionsDto] = None
    neutral_minions_killed: int = Field(
        ...,
        alias="neutralMinionsKilled",
        description="neutralMinionsKilled = mNeutralMinionsKilled, which is incremented on kills of kPet and kJungleMonster",
    )
    need_vision_pings: Optional[int] = Field(
        None, alias="needVisionPings", description="Green ward"
    )
    nexus_kills: int = Field(..., alias="nexusKills")
    nexus_takedowns: Optional[int] = Field(None, alias="nexusTakedowns")
    nexus_lost: Optional[int] = Field(None, alias="nexusLost")
    objectives_stolen: int = Field(..., alias="objectivesStolen")
    objectives_stolen_assists: int = Field(..., alias="objectivesStolenAssists")
    on_my_way_pings: Optional[int] = Field(
        None, alias="onMyWayPings", description="Blue arrow pointing at ground"
    )
    participant_id: int = Field(..., alias="participantId")
    player_score0: Optional[float] = Field(None, alias="playerScore0")
    player_score1: Optional[float] = Field(None, alias="playerScore1")
    player_score2: Optional[float] = Field(None, alias="playerScore2")
    player_score3: Optional[float] = Field(None, alias="playerScore3")
    player_score4: Optional[float] = Field(None, alias="playerScore4")
    player_score5: Optional[float] = Field(None, alias="playerScore5")
    player_score6: Optional[float] = Field(None, alias="playerScore6")
    player_score7: Optional[float] = Field(None, alias="playerScore7")
    player_score8: Optional[float] = Field(None, alias="playerScore8")
    player_score9: Optional[float] = Field(None, alias="playerScore9")
    player_score10: Optional[float] = Field(None, alias="playerScore10")
    player_score11: Optional[float] = Field(None, alias="playerScore11")
    penta_kills: int = Field(..., alias="pentaKills")
    perks: PerksDto
    physical_damage_dealt: int = Field(..., alias="physicalDamageDealt")
    physical_damage_dealt_to_champions: int = Field(
        ..., alias="physicalDamageDealtToChampions"
    )
    physical_damage_taken: int = Field(..., alias="physicalDamageTaken")
    placement: Optional[int] = None
    player_augment1: Optional[int] = Field(None, alias="playerAugment1")
    player_augment2: Optional[int] = Field(None, alias="playerAugment2")
    player_augment3: Optional[int] = Field(None, alias="playerAugment3")
    player_augment4: Optional[int] = Field(None, alias="playerAugment4")
    player_subteam_id: Optional[int] = Field(None, alias="playerSubteamId")
    push_pings: Optional[int] = Field(
        None, alias="pushPings", description="Green minion"
    )
    profile_icon: int = Field(..., alias="profileIcon")
    puuid: str
    quadra_kills: int = Field(..., alias="quadraKills")
    riot_id_game_name: Optional[str] = Field(None, alias="riotIdGameName")
    riot_id_tagline: Optional[str] = Field(None, alias="riotIdTagline")
    role: str
    sight_wards_bought_in_game: int = Field(..., alias="sightWardsBoughtInGame")
    spell1_casts: int = Field(..., alias="spell1Casts")
    spell2_casts: int = Field(..., alias="spell2Casts")
    spell3_casts: int = Field(..., alias="spell3Casts")
    spell4_casts: int = Field(..., alias="spell4Casts")
    subteam_placement: Optional[int] = Field(None, alias="subteamPlacement")
    summoner1_casts: int = Field(..., alias="summoner1Casts")
    summoner1_id: int = Field(..., alias="summoner1Id")
    summoner2_casts: int = Field(..., alias="summoner2Casts")
    summoner2_id: int = Field(..., alias="summoner2Id")
    summoner_id: str = Field(..., alias="summonerId")
    summoner_level: int = Field(..., alias="summonerLevel")
    summoner_name: str = Field(..., alias="summonerName")
    team_early_surrendered: bool = Field(..., alias="teamEarlySurrendered")
    team_id: int = Field(..., alias="teamId")
    team_position: str = Field(
        ...,
        alias="teamPosition",
        description="Both individualPosition and teamPosition are computed by the game server and are different versions of the most likely position played by a player. The individualPosition is the best guess for which position the player actually played in isolation of anything else. The teamPosition is the best guess for which position the player actually played if we add the constraint that each team must have one top player, one jungle, one middle, etc. Generally the recommendation is to use the teamPosition field over the individualPosition field.",
    )
    time_c_cing_others: int = Field(..., alias="timeCCingOthers")
    time_played: int = Field(..., alias="timePlayed")
    total_ally_jungle_minions_killed: Optional[int] = Field(
        None, alias="totalAllyJungleMinionsKilled"
    )
    total_damage_dealt: int = Field(..., alias="totalDamageDealt")
    total_damage_dealt_to_champions: int = Field(
        ..., alias="totalDamageDealtToChampions"
    )
    total_damage_shielded_on_teammates: int = Field(
        ..., alias="totalDamageShieldedOnTeammates"
    )
    total_damage_taken: int = Field(..., alias="totalDamageTaken")
    total_enemy_jungle_minions_killed: Optional[int] = Field(
        None, alias="totalEnemyJungleMinionsKilled"
    )
    total_heal: int = Field(
        ...,
        alias="totalHeal",
        description="Whenever positive health is applied (which translates to all heals in the game but not things like regeneration), totalHeal is incremented by the amount of health received. This includes healing enemies, jungle monsters, yourself, etc",
    )
    total_heals_on_teammates: int = Field(
        ...,
        alias="totalHealsOnTeammates",
        description="Whenever positive health is applied (which translates to all heals in the game but not things like regeneration), totalHealsOnTeammates is incremented by the amount of health received.  This is post modified, so if you heal someone missing 5 health for 100 you will get +5 totalHealsOnTeammates",
    )
    total_minions_killed: int = Field(
        ...,
        alias="totalMinionsKilled",
        description="totalMillionsKilled = mMinionsKilled, which is only incremented on kills of kTeamMinion, kMeleeLaneMinion, kSuperLaneMinion, kRangedLaneMinion and kSiegeLaneMinion",
    )
    total_time_cc_dealt: int = Field(..., alias="totalTimeCCDealt")
    total_time_spent_dead: int = Field(..., alias="totalTimeSpentDead")
    total_units_healed: int = Field(..., alias="totalUnitsHealed")
    triple_kills: int = Field(..., alias="tripleKills")
    true_damage_dealt: int = Field(..., alias="trueDamageDealt")
    true_damage_dealt_to_champions: int = Field(..., alias="trueDamageDealtToChampions")
    true_damage_taken: int = Field(..., alias="trueDamageTaken")
    turret_kills: int = Field(..., alias="turretKills")
    turret_takedowns: Optional[int] = Field(None, alias="turretTakedowns")
    turrets_lost: Optional[int] = Field(None, alias="turretsLost")
    unreal_kills: int = Field(..., alias="unrealKills")
    vision_score: int = Field(..., alias="visionScore")
    vision_cleared_pings: Optional[int] = Field(None, alias="visionClearedPings")
    vision_wards_bought_in_game: int = Field(..., alias="visionWardsBoughtInGame")
    wards_killed: int = Field(..., alias="wardsKilled")
    wards_placed: int = Field(..., alias="wardsPlaced")
    win: bool
    bait_pings: Optional[int] = Field(None, alias="baitPings")
    danger_pings: Optional[int] = Field(
        None,
        alias="dangerPings",
        description="https://github.com/RiotGames/developer-relations/issues/870",
    )
    basic_pings: Optional[int] = Field(
        None,
        alias="basicPings",
        description="https://github.com/RiotGames/developer-relations/issues/814",
    )
    player_augment5: Optional[int] = Field(None, alias="playerAugment5")
    player_augment6: Optional[int] = Field(None, alias="playerAugment6")
    riot_id_name: Optional[str] = Field(
        None,
        alias="riotIdName",
        description="Deprecated, use `riotIdGameName`. This field name was briefly used instead of `riotIdGameName`, prior to patch 14.5.",
    )
    retreat_pings: Optional[int] = Field(
        None,
        alias="retreatPings",
        description="https://github.com/RiotGames/developer-relations/issues/814",
    )
    champion_skin_id: Optional[int] = Field(None, alias="championSkinId")


class InfoTimeLineDto(BaseModel):
    end_of_game_result: Optional[str] = Field(
        None,
        alias="endOfGameResult",
        description="Refer to indicate if the game ended in termination.",
    )
    frame_interval: int = Field(..., alias="frameInterval")
    game_id: Optional[int] = Field(None, alias="gameId")
    participants: Optional[List[ParticipantTimeLineDto]] = None
    frames: List[FramesTimeLineDto]


class InfoDto(BaseModel):
    end_of_game_result: Optional[str] = Field(
        None,
        alias="endOfGameResult",
        description="Refer to indicate if the game ended in termination.",
    )
    game_creation: int = Field(
        ...,
        alias="gameCreation",
        description="Unix timestamp for when the game is created on the game server (i.e., the loading screen).",
    )
    game_duration: int = Field(
        ...,
        alias="gameDuration",
        description="Prior to patch 11.20, this field returns the game length in milliseconds calculated from gameEndTimestamp - gameStartTimestamp. Post patch 11.20, this field returns the max timePlayed of any participant in the game in seconds, which makes the behavior of this field consistent with that of match-v4. The best way to handling the change in this field is to treat the value as milliseconds if the gameEndTimestamp field isn't in the response and to treat the value as seconds if gameEndTimestamp is in the response.",
    )
    game_end_timestamp: Optional[int] = Field(
        None,
        alias="gameEndTimestamp",
        description='Unix timestamp for when match ends on the game server. This timestamp can occasionally be significantly longer than when the match "ends". The most reliable way of determining the timestamp for the end of the match would be to add the max time played of any participant to the gameStartTimestamp. This field was added to match-v5 in patch 11.20 on Oct 5th, 2021.',
    )
    game_id: int = Field(..., alias="gameId")
    game_mode: str = Field(
        ..., alias="gameMode", description="Refer to the Game Constants documentation."
    )
    game_name: str = Field(..., alias="gameName")
    game_start_timestamp: int = Field(
        ...,
        alias="gameStartTimestamp",
        description="Unix timestamp for when match starts on the game server.",
    )
    game_type: str = Field(..., alias="gameType")
    game_version: str = Field(
        ...,
        alias="gameVersion",
        description="The first two parts can be used to determine the patch a game was played on.",
    )
    map_id: int = Field(
        ..., alias="mapId", description="Refer to the Game Constants documentation."
    )
    participants: List[ParticipantDto]
    platform_id: str = Field(
        ..., alias="platformId", description="Platform where the match was played."
    )
    queue_id: int = Field(
        ..., alias="queueId", description="Refer to the Game Constants documentation."
    )
    teams: List[TeamDto]
    tournament_code: Optional[str] = Field(
        None,
        alias="tournamentCode",
        description="Tournament code used to generate the match. This field was added to match-v5 in patch 11.13 on June 23rd, 2021.",
    )
    game_mode_mutators: Optional[List[str]] = Field(None, alias="gameModeMutators")


class TimelineDto(BaseModel):
    metadata: MetadataTimeLineDto = Field(..., description="Match metadata.")
    info: InfoTimeLineDto = Field(..., description="Match info.")


class MatchDto(BaseModel):
    metadata: MetadataDto = Field(..., description="Match metadata.")
    info: InfoDto = Field(..., description="Match info.")
