# fastapi-easylimit

Simple async rate-limiting middleware for FastAPI with Redis or in-memory caching.


## Simple design
- Async rate limiting
- Redis or in-memory cache


## Installation

```bash
pip install fastapi-easylimit
```

---

## Usage

```python
from fastapi import FastAPI
from fastapi_easylimiter import AsyncRedisBackend, InMemoryBackend
import redis.asyncio as redis_async

app = FastAPI()

REDIS_URL = "redis://localhost:6379/0"

# Redis client
redis_client = redis_async.from_url(REDIS_URL, decode_responses=True)
backend = AsyncRedisBackend(redis_client)

# Or for local development:
# backend = InMemoryBackend()

rules = {
    "/api/users": {"limit": 1, "period": 2},
    "/api/": {"limit": 60, "period": 60}, # GLOBAL ONES GO LAST
}

app.add_middleware(
    RateLimiterMiddleware,
    rules=rules,
    backend=backend,
    backoff_threshold=3,
    max_backoff=60
)
```