# pyipxact-de - Accellera SPIRIT/IP-XACT DE (Design Environment) and Python Bindings

<p align="center">
   <img src="https://github.com/amal-khailtash/pyipxact-de/raw/refs/heads/main/docs/_static/logo-256x256.svg" alt="IP-XACT DE" width="256"/>
</p>

<div align="center">

[![github](https://img.shields.io/badge/pyipxact--de-29b6f6.svg?longCache=true&logo=GitHub&labelColor=0277bd)](https://github.com/amal-khailtash/pyipxact-de/)
![GitHub forks](https://img.shields.io/github/forks/amal-khailtash/pyipxact-de?longCache=true&logoColor=0277bd&labelColor=0277bd)
![GitHub Repo stars](https://img.shields.io/github/stars/amal-khailtash/pyipxact-de?longCache=true&logoColor=0277bd&labelColor=0277bd)
![GitHub contributors](https://img.shields.io/github/contributors/amal-khailtash/pyipxact-de)
[![Commit activity](https://img.shields.io/github/commit-activity/m/amal-khailtash/pyipxact-de)](https://img.shields.io/github/commit-activity/m/amal-khailtash/pyipxact-de)

<!--
![GitHub Actions Workflow Status](https://img.shields.io/github/actions/workflow/status/amal-khailtash/pyipxact-de/.github%2Fworkflows%2Fdocs.yml?label=Documentation%20Build%20Status)
 -->

[![GitHub - License](https://img.shields.io/github/license/amal-khailtash/pyipxact-de?longCache=true)](LICENSE)
[![Documentation](https://img.shields.io/website?longCache=true&label=amal-khailtash.github.io%2Fpyipxact-de&logo=GitHub&logoColor=fff&up_color=blueviolet&up_message=Read%20now%20%E2%9E%9A&url=https%3A%2F%2Famal-khailtash.github.io%2Fpyipxact-de%2Findex.html)](https://amal-khailtash.github.io/pyipxact-de/)[![Documentation (GitHub deployments)](https://img.shields.io/github/deployments/amal-khailtash/pyipxact-de/github-pages?label=)](https://amal-khailtash.github.io/pyipxact-de/)

<!--
![Read the Docs](https://img.shields.io/readthedocs/pyipxact-de?logo=readthedocs)
![Read the Docs (version)](https://img.shields.io/readthedocs/:packageName/:version)
 -->

<!--
[![GitHub - License](https://img.shields.io/github/license/amal-khailtash/pyipxact-de?longCache=true&logo=Apache)](LICENSE)
![GitHub License](https://img.shields.io/github/license/amal-khailtash/pyipxact-de?longCache=true&logo=Apache)
![PyPI - License](https://img.shields.io/pypi/l/pyipxact-de?longCache=true&logo=Apache)
[![PyPI - License](https://img.shields.io/pypi/l/pyipxact-de?longCache=true&logo=Apache)](LICENSE)

---
[![PyPI version](https://badge.fury.io/py/pyipxact-de.svg?logo=PyPI)](https://badge.fury.io/py/pyipxact-de)

[![PyPI](https://img.shields.io/pypi/v/pyipxact-de?longCache=true&logo=PyPI&logoColor=FBE072)](https://pypi.org/project/pyipxact-de/)
![PyPI - Status](https://img.shields.io/pypi/status/pyipxact-de?longCache=true&logo=PyPI&logoColor=FBE072)
![PyPI - Python Version](https://img.shields.io/pypi/pyversions/pyipxact-de?longCache=true&logo=PyPI&logoColor=FBE072)

[![Release](https://img.shields.io/github/v/release/amal-khailtash/pyipxact-de)](https://img.shields.io/github/v/release/amal-khailtash/pyipxact-de)


---
[![Build status](https://img.shields.io/github/actions/workflow/status/amal-khailtash/pyipxact-de/main.yml?branch=main)](https://github.com/amal-khailtash/pyipxact-de/actions/workflows/main.yml?query=branch%3Amain)

[![GitHub Workflow - Build and Test Status](https://img.shields.io/github/actions/workflow/status/amal-khailtash/pyipxact-de/Pipeline.yml?longCache=true&label=Build%20and%20Test&logo=GitHub%20Actions&logoColor=FFFFFF)](https://GitHub.com/amal-khailtash/pyipxact-de/actions/workflows/Pipeline.yml)
[![Libraries.io status for latest release](https://img.shields.io/librariesio/release/pypi/pyipxact-de?longCache=true&logo=Libraries.io&logoColor=fff)](https://libraries.io/github/amal-khailtash/pyipxact-de)


---
[![codecov](https://codecov.io/gh/amal-khailtash/pyipxact-de/branch/main/graph/badge.svg)](https://codecov.io/gh/amal-khailtash/pyipxact-de)

![Codecov](https://img.shields.io/codecov/c/github/amal-khailtash/pyipxact-de?longCache=true&logo=Codecov)

[![Codacy - Quality](https://img.shields.io/codacy/grade/xxxxxxxxxxxxxxxxxxxxxxxx?longCache=true&logo=Codecov)](https://app.codacy.com/gh/amal-khailtash/pyipxact-de)
[![Codacy - Coverage](https://img.shields.io/codacy/coverage/xxxxxxxxxxxxxxxxxxxxxxxx?longCache=true&logo=Codecov)](https://app.codacy.com/gh/amal-khailtash/pyipxact-de)
[![Codecov - Branch Coverage](https://img.shields.io/codecov/c/github/amal-khailtash/pyipxact-de?longCache=true&logo=Codecov)](https://codecov.io/gh/amal-khailtash/pyipxact-de)
-->

<!--
---
[![Ruff](https://img.shields.io/badge/lint-ruff-46aef7?logo=ruff&logoColor=white)](https://docs.astral.sh/ruff/)
[![Tests](https://img.shields.io/badge/tests-pytest-0a9edc?logo=pytest)](https://docs.pytest.org/)
![PEP Badge](https://img.shields.io/badge/PEP-B52E31?style=flat&logo=pep)
[![Type hints](https://img.shields.io/badge/typing-PEP%20484-informational&logo=pep)](https://peps.python.org/pep-0484/)

[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)

[![Checked with mypy](http://www.mypy-lang.org/static/mypy_badge.svg)](http://mypy-lang.org/)

[![pydocstyle](https://img.shields.io/badge/pydocstyle-enabled-AD4CD3)](http://www.pydocstyle.org/en/stable/)
-->



<!--
[![Dependent repos (via libraries.io)](https://img.shields.io/librariesio/dependent-repos/pypi/pyipxact-de?longCache=true&logo=GitHub)](https://GitHub.com/amal-khailtash/pyipxact-de/network/dependents)
[![Requires.io](https://img.shields.io/requires/github/amal-khailtash/pyipxact-de?longCache=true)](https://requires.io/github/amal-khailtash/pyipxact-de/requirements/?branch=main)
[![Libraries.io SourceRank](https://img.shields.io/librariesio/sourcerank/pypi/pyipxact-de?longCache=true)](https://libraries.io/github/amal-khailtash/pyipxact-de/sourcerank)
-->

[![Python](https://img.shields.io/badge/python-3.13-blue?logo=python)](https://www.python.org/)
[![SemVer](https://img.shields.io/badge/SemVer-2.0.0-333333.svg?logo=semver)](https://semver.org/)
[![Keep a Changelog](https://img.shields.io/badge/Keep%20a%20Changelog-1.1.0-0c7fb0.svg?logo=keepachangelog)](https://keepachangelog.com/en/1.1.0/)

<!--
---
[![FastAPI](https://img.shields.io/badge/FastAPI-116.1-009688.svg?logo=FastAPI&logoColor=white)](https://fastapi.tiangolo.com)
-->
</div>


`pyipxact-de` is a Python-based Design Environment and bindings for Accellera SPIRIT/IP-XACT.  It targets SPIRIT v1.x and IP-XACT 1685-2009/2014/2022, enabling parsing, validation, transformation, and programmatic manipulation of IP-XACT artifacts (components, buses, designs, memory maps).

Key features:
- Generated, schema-accurate models via xsData[^1] (initial version used PyXB[^2]) under `org.accellera/*.`
- High-level APIs, CLI tools, and TGI helpers for common workflows (convert, validate, query, diff).
- Optional GUI and web front ends for interactive exploration.
- Modern Python 3.13 tooling and type-annotated, docstring-rich codebase.

See the documentation for detailed guides, examples, and API references.

## Documentation

Documentation can be found [here](https://amal-khailtash.github.io/pyipxact-de/).

# Installation
```bash
pip install ipxact-de[cli,gui,web]
```

## Getting started with your project



## Directory Structure

Different Python bindings for Accellera Spirit and Accellera versions are generated under org.accellera.* namespace.

```
src/
├── amal
│   ├── eda
│   │   └── ipxact_de
│   │       ├── cli
│   │       ├── gui
│   │       │   └── ui
│   │       │       └── icons
│   │       ├── tgi
│   │       │   └── ipxact
│   │       │       └── v1685_2022
│   │       └── web
│   └── utilities
└── org
    └── accellera
        ├── ipxact
        │   ├── v1685_2014
        │   └── v1685_2022
        │       ├── tgi
        │       └── ve
        ├── spirit
        │   ├── v1_0
        │   ├── v1_1
        │   ├── v1_2
        │   ├── v1_4
        │   │   └── tgi
        │   ├── v1_5
        │   │   └── tgi
        │   └── v1685_2009
        │       ├── tgi
        │       └── ve
        │           ├── ams
        │           ├── core
        │           ├── pdp
        │           └── power
        └── xsl
```


## Examples

[^1]: [xsData - Naive XML & JSON Bindings for python](https://github.com/tefra/xsdata)
[^2]: [PyXB: Python XML Schema Bindings](https://pyxb.sourceforge.net/)
