from dataclasses import dataclass, field
from typing import Optional

from org.accellera.ipxact.v1685_2014.clock_driver_type import ClockDriverType

__NAMESPACE__ = "http://www.accellera.org/XMLSchema/IPXACT/1685-2014"


@dataclass(slots=True)
class OtherClockDriver(ClockDriverType):
    """Describes a clock not directly associated with an input port.

    The clockSource attribute can be used on these clocks to indicate
    the actual clock source (e.g. an output port of a clock generator
    cell).

    :ivar clock_name: Indicates the name of the clock.
    :ivar clock_source: Indicates the name of the actual clock source
        (e.g. an output pin of a clock generator cell).
    """

    class Meta:
        name = "otherClockDriver"
        namespace = "http://www.accellera.org/XMLSchema/IPXACT/1685-2014"

    clock_name: Optional[str] = field(
        default=None,
        metadata={
            "name": "clockName",
            "type": "Attribute",
            "required": True,
        },
    )
    clock_source: Optional[str] = field(
        default=None,
        metadata={
            "name": "clockSource",
            "type": "Attribute",
        },
    )
