from collections.abc import Iterable, Mapping
from dataclasses import dataclass, field
from typing import Optional

from org.accellera.ipxact.v1685_2022.dependency import Dependency
from org.accellera.ipxact.v1685_2022.file_type import FileType
from org.accellera.ipxact.v1685_2022.ipxact_uri import IpxactUri
from org.accellera.ipxact.v1685_2022.name_value_pair_type import (
    NameValuePairType,
)
from org.accellera.ipxact.v1685_2022.string_expression import StringExpression
from org.accellera.ipxact.v1685_2022.unsigned_bit_expression import (
    UnsignedBitExpression,
)
from org.accellera.ipxact.v1685_2022.vendor_extensions import VendorExtensions

__NAMESPACE__ = "http://www.accellera.org/XMLSchema/IPXACT/1685-2022"


@dataclass(slots=True)
class File:
    """
    IP-XACT reference to a file or directory.

    :ivar name: Path to the file or directory. If this path is a
        relative path, then it is relative to the containing XML file.
    :ivar file_type:
    :ivar is_structural: Indicates that the current file is purely
        structural.
    :ivar is_include_file: Indicate that the file is include file.
    :ivar logical_name: Logical name for this file or directory e.g.
        VHDL library name.
    :ivar exported_name: Defines exported names that can be accessed
        externally, e.g. exported function names from a C source file.
    :ivar build_command: Command and flags used to build derived files
        from the sourceName files. If this element is present, the
        command and/or flags used to to build the file will override or
        augment any default builders at a higher level.
    :ivar dependency:
    :ivar define: Specifies define symbols that are used in the source
        file.  The ipxact:name element gives the name to be defined and
        the text content of the ipxact:value element holds the value.
        This element supports full configurability.
    :ivar image_type: Relates the current file to a certain executable
        image type in the design.
    :ivar description: String for describing this file to users
    :ivar vendor_extensions:
    :ivar file_id: Unique ID for this file, referenced in
        fileSet/function/fileRef
    :ivar other_attributes:
    :ivar id:
    """

    class Meta:
        name = "file"
        namespace = "http://www.accellera.org/XMLSchema/IPXACT/1685-2022"

    name: Optional[IpxactUri] = field(
        default=None,
        metadata={
            "type": "Element",
            "required": True,
        },
    )
    file_type: Iterable[FileType] = field(
        default_factory=list,
        metadata={
            "name": "fileType",
            "type": "Element",
            "min_occurs": 1,
        },
    )
    is_structural: Optional[bool] = field(
        default=None,
        metadata={
            "name": "isStructural",
            "type": "Element",
        },
    )
    is_include_file: Optional["File.IsIncludeFile"] = field(
        default=None,
        metadata={
            "name": "isIncludeFile",
            "type": "Element",
        },
    )
    logical_name: Optional["File.LogicalName"] = field(
        default=None,
        metadata={
            "name": "logicalName",
            "type": "Element",
        },
    )
    exported_name: Iterable["File.ExportedName"] = field(
        default_factory=list,
        metadata={
            "name": "exportedName",
            "type": "Element",
        },
    )
    build_command: Optional["File.BuildCommand"] = field(
        default=None,
        metadata={
            "name": "buildCommand",
            "type": "Element",
        },
    )
    dependency: Iterable[Dependency] = field(
        default_factory=list,
        metadata={
            "type": "Element",
        },
    )
    define: Iterable[NameValuePairType] = field(
        default_factory=list,
        metadata={
            "type": "Element",
        },
    )
    image_type: Iterable["File.ImageType"] = field(
        default_factory=list,
        metadata={
            "name": "imageType",
            "type": "Element",
        },
    )
    description: Optional[str] = field(
        default=None,
        metadata={
            "type": "Element",
        },
    )
    vendor_extensions: Optional[VendorExtensions] = field(
        default=None,
        metadata={
            "name": "vendorExtensions",
            "type": "Element",
        },
    )
    file_id: Optional[str] = field(
        default=None,
        metadata={
            "name": "fileId",
            "type": "Attribute",
        },
    )
    other_attributes: Mapping[str, str] = field(
        default_factory=dict,
        metadata={
            "type": "Attributes",
            "namespace": "##other",
        },
    )
    id: Optional[str] = field(
        default=None,
        metadata={
            "type": "Attribute",
            "namespace": "http://www.w3.org/XML/1998/namespace",
        },
    )

    @dataclass(slots=True)
    class IsIncludeFile:
        """
        :ivar value:
        :ivar external_declarations: the File contains some declarations
            that are needed in top file
        """

        value: Optional[bool] = field(
            default=None,
            metadata={
                "required": True,
            },
        )
        external_declarations: bool = field(
            default=False,
            metadata={
                "name": "externalDeclarations",
                "type": "Attribute",
            },
        )

    @dataclass(slots=True)
    class LogicalName:
        """
        :ivar value:
        :ivar default: The logical name shall only be used as a default
            and another process may override this name.
        """

        value: str = field(
            default="",
            metadata={
                "required": True,
            },
        )
        default: bool = field(
            default=False,
            metadata={
                "type": "Attribute",
            },
        )

    @dataclass(slots=True)
    class ExportedName:
        value: str = field(
            default="",
            metadata={
                "required": True,
            },
        )
        id: Optional[str] = field(
            default=None,
            metadata={
                "type": "Attribute",
                "namespace": "http://www.w3.org/XML/1998/namespace",
            },
        )

    @dataclass(slots=True)
    class BuildCommand:
        """
        :ivar command: Command used to build this file.
        :ivar flags: Flags given to the build command when building this
            file. If the optional attribute "append" is "true", this
            string will be appended to any existing flags, otherwise
            these flags will replace any existing default flags.
        :ivar replace_default_flags: If true, the value of the sibling
            element "flags" should replace any default flags specified
            at a more global level. If this is true and the sibling
            element "flags" is empty or missing, this has the effect of
            clearing any default flags.
        :ivar target_name: Pathname to the file that is derived (built)
            from the source file.
        """

        command: Optional[StringExpression] = field(
            default=None,
            metadata={
                "type": "Element",
            },
        )
        flags: Optional["File.BuildCommand.Flags"] = field(
            default=None,
            metadata={
                "type": "Element",
            },
        )
        replace_default_flags: Optional[UnsignedBitExpression] = field(
            default=None,
            metadata={
                "name": "replaceDefaultFlags",
                "type": "Element",
            },
        )
        target_name: Optional[IpxactUri] = field(
            default=None,
            metadata={
                "name": "targetName",
                "type": "Element",
            },
        )

        @dataclass(slots=True)
        class Flags(StringExpression):
            """
            :ivar append: "true" indicates that the flags shall be
                appended to any existing flags, "false"indicates these
                flags will replace any existing default flags.
            """

            append: Optional[bool] = field(
                default=None,
                metadata={
                    "type": "Attribute",
                },
            )

    @dataclass(slots=True)
    class ImageType:
        value: str = field(
            default="",
            metadata={
                "required": True,
            },
        )
        id: Optional[str] = field(
            default=None,
            metadata={
                "type": "Attribute",
                "namespace": "http://www.w3.org/XML/1998/namespace",
            },
        )
