import nanoget
from argparse import ArgumentParser
from nanoplotter.timeplots import check_valid_time_and_sort


def main():
    args = get_args()

    dfs = check_valid_time_and_sort(
        nanoget.get_input(
            source="summary",
            files=args.summaries,
            threads=8,
            readtype="1D",
            names=None,
            barcoded=False,
            combine="track"),
        timescol="start_time"
    ).set_index("start_time")

    cumsums = [get_cumsum(dfs, dataset) for dataset in dfs["dataset"].unique()]
    print(
        cumsums[0].join(cumsums[1:], how="outer").to_csv(sep="\t", na_rep='NaN')
    )


def get_cumsum(df, dataset):
    return df.loc[df["dataset"] == dataset, "lengths"] \
        .cumsum() \
        .resample('10T')\
        .max() \
        .divide(1e9) \
        .to_frame() \
        .rename(columns={"lengths": dataset})


def get_args():
    parser = ArgumentParser(description="Extract cumulative yield information to table.")
    parser.add_argument("summaries",
                        help="(compressed) summary files generated by albacore or guppy.",
                        nargs='+')
    return parser.parse_args()


if __name__ == '__main__':
    main()
