# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.alert_page_public import AlertPagePublic
from ..types.alert_public import AlertPublic
from ..types.alert_trigger_write import AlertTriggerWrite
from ..types.webhook_examples import WebhookExamples
from ..types.webhook_test_result import WebhookTestResult
from ..types.webhook_write import WebhookWrite
from .raw_client import AsyncRawAlertsClient, RawAlertsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class AlertsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawAlertsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawAlertsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawAlertsClient
        """
        return self._raw_client

    def find_alerts(
        self,
        *,
        page: typing.Optional[int] = None,
        size: typing.Optional[int] = None,
        sorting: typing.Optional[str] = None,
        filters: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AlertPagePublic:
        """
        Find alerts

        Parameters
        ----------
        page : typing.Optional[int]

        size : typing.Optional[int]

        sorting : typing.Optional[str]

        filters : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AlertPagePublic
            OK

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.alerts.find_alerts()
        """
        _response = self._raw_client.find_alerts(
            page=page, size=size, sorting=sorting, filters=filters, request_options=request_options
        )
        return _response.data

    def create_alert(
        self,
        *,
        name: str,
        webhook: WebhookWrite,
        id: typing.Optional[str] = OMIT,
        enabled: typing.Optional[bool] = OMIT,
        triggers: typing.Optional[typing.Sequence[AlertTriggerWrite]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Create alert

        Parameters
        ----------
        name : str

        webhook : WebhookWrite

        id : typing.Optional[str]

        enabled : typing.Optional[bool]

        triggers : typing.Optional[typing.Sequence[AlertTriggerWrite]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import OpikApi
        from Opik import WebhookWrite
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.alerts.create_alert(name='name', webhook=WebhookWrite(url='url', ), )
        """
        _response = self._raw_client.create_alert(
            name=name, webhook=webhook, id=id, enabled=enabled, triggers=triggers, request_options=request_options
        )
        return _response.data

    def delete_alert_batch(
        self, *, ids: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Delete multiple alerts by their IDs

        Parameters
        ----------
        ids : typing.Sequence[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.alerts.delete_alert_batch(ids=['ids'], )
        """
        _response = self._raw_client.delete_alert_batch(ids=ids, request_options=request_options)
        return _response.data

    def get_alert_by_id(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> AlertPublic:
        """
        Get Alert by id

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AlertPublic
            Alert resource

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.alerts.get_alert_by_id(id='id', )
        """
        _response = self._raw_client.get_alert_by_id(id, request_options=request_options)
        return _response.data

    def update_alert(
        self,
        id_: str,
        *,
        name: str,
        webhook: WebhookWrite,
        id: typing.Optional[str] = OMIT,
        enabled: typing.Optional[bool] = OMIT,
        triggers: typing.Optional[typing.Sequence[AlertTriggerWrite]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Update alert

        Parameters
        ----------
        id_ : str

        name : str

        webhook : WebhookWrite

        id : typing.Optional[str]

        enabled : typing.Optional[bool]

        triggers : typing.Optional[typing.Sequence[AlertTriggerWrite]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import OpikApi
        from Opik import WebhookWrite
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.alerts.update_alert(id_='id', name='name', webhook=WebhookWrite(url='url', ), )
        """
        _response = self._raw_client.update_alert(
            id_, name=name, webhook=webhook, id=id, enabled=enabled, triggers=triggers, request_options=request_options
        )
        return _response.data

    def get_webhook_examples(self, *, request_options: typing.Optional[RequestOptions] = None) -> WebhookExamples:
        """
        Get webhook payload examples for all alert event types

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WebhookExamples
            Webhook examples

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.alerts.get_webhook_examples()
        """
        _response = self._raw_client.get_webhook_examples(request_options=request_options)
        return _response.data

    def test_webhook(
        self,
        *,
        name: str,
        webhook: WebhookWrite,
        id: typing.Optional[str] = OMIT,
        enabled: typing.Optional[bool] = OMIT,
        triggers: typing.Optional[typing.Sequence[AlertTriggerWrite]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WebhookTestResult:
        """
        Test alert webhook

        Parameters
        ----------
        name : str

        webhook : WebhookWrite

        id : typing.Optional[str]

        enabled : typing.Optional[bool]

        triggers : typing.Optional[typing.Sequence[AlertTriggerWrite]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WebhookTestResult
            Webhook test

        Examples
        --------
        from Opik import OpikApi
        from Opik import WebhookWrite
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.alerts.test_webhook(name='name', webhook=WebhookWrite(url='url', ), )
        """
        _response = self._raw_client.test_webhook(
            name=name, webhook=webhook, id=id, enabled=enabled, triggers=triggers, request_options=request_options
        )
        return _response.data


class AsyncAlertsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawAlertsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawAlertsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawAlertsClient
        """
        return self._raw_client

    async def find_alerts(
        self,
        *,
        page: typing.Optional[int] = None,
        size: typing.Optional[int] = None,
        sorting: typing.Optional[str] = None,
        filters: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AlertPagePublic:
        """
        Find alerts

        Parameters
        ----------
        page : typing.Optional[int]

        size : typing.Optional[int]

        sorting : typing.Optional[str]

        filters : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AlertPagePublic
            OK

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.alerts.find_alerts()
        asyncio.run(main())
        """
        _response = await self._raw_client.find_alerts(
            page=page, size=size, sorting=sorting, filters=filters, request_options=request_options
        )
        return _response.data

    async def create_alert(
        self,
        *,
        name: str,
        webhook: WebhookWrite,
        id: typing.Optional[str] = OMIT,
        enabled: typing.Optional[bool] = OMIT,
        triggers: typing.Optional[typing.Sequence[AlertTriggerWrite]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Create alert

        Parameters
        ----------
        name : str

        webhook : WebhookWrite

        id : typing.Optional[str]

        enabled : typing.Optional[bool]

        triggers : typing.Optional[typing.Sequence[AlertTriggerWrite]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import AsyncOpikApi
        from Opik import WebhookWrite
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.alerts.create_alert(name='name', webhook=WebhookWrite(url='url', ), )
        asyncio.run(main())
        """
        _response = await self._raw_client.create_alert(
            name=name, webhook=webhook, id=id, enabled=enabled, triggers=triggers, request_options=request_options
        )
        return _response.data

    async def delete_alert_batch(
        self, *, ids: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Delete multiple alerts by their IDs

        Parameters
        ----------
        ids : typing.Sequence[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.alerts.delete_alert_batch(ids=['ids'], )
        asyncio.run(main())
        """
        _response = await self._raw_client.delete_alert_batch(ids=ids, request_options=request_options)
        return _response.data

    async def get_alert_by_id(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> AlertPublic:
        """
        Get Alert by id

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AlertPublic
            Alert resource

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.alerts.get_alert_by_id(id='id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_alert_by_id(id, request_options=request_options)
        return _response.data

    async def update_alert(
        self,
        id_: str,
        *,
        name: str,
        webhook: WebhookWrite,
        id: typing.Optional[str] = OMIT,
        enabled: typing.Optional[bool] = OMIT,
        triggers: typing.Optional[typing.Sequence[AlertTriggerWrite]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Update alert

        Parameters
        ----------
        id_ : str

        name : str

        webhook : WebhookWrite

        id : typing.Optional[str]

        enabled : typing.Optional[bool]

        triggers : typing.Optional[typing.Sequence[AlertTriggerWrite]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import AsyncOpikApi
        from Opik import WebhookWrite
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.alerts.update_alert(id_='id', name='name', webhook=WebhookWrite(url='url', ), )
        asyncio.run(main())
        """
        _response = await self._raw_client.update_alert(
            id_, name=name, webhook=webhook, id=id, enabled=enabled, triggers=triggers, request_options=request_options
        )
        return _response.data

    async def get_webhook_examples(self, *, request_options: typing.Optional[RequestOptions] = None) -> WebhookExamples:
        """
        Get webhook payload examples for all alert event types

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WebhookExamples
            Webhook examples

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.alerts.get_webhook_examples()
        asyncio.run(main())
        """
        _response = await self._raw_client.get_webhook_examples(request_options=request_options)
        return _response.data

    async def test_webhook(
        self,
        *,
        name: str,
        webhook: WebhookWrite,
        id: typing.Optional[str] = OMIT,
        enabled: typing.Optional[bool] = OMIT,
        triggers: typing.Optional[typing.Sequence[AlertTriggerWrite]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WebhookTestResult:
        """
        Test alert webhook

        Parameters
        ----------
        name : str

        webhook : WebhookWrite

        id : typing.Optional[str]

        enabled : typing.Optional[bool]

        triggers : typing.Optional[typing.Sequence[AlertTriggerWrite]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WebhookTestResult
            Webhook test

        Examples
        --------
        from Opik import AsyncOpikApi
        from Opik import WebhookWrite
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.alerts.test_webhook(name='name', webhook=WebhookWrite(url='url', ), )
        asyncio.run(main())
        """
        _response = await self._raw_client.test_webhook(
            name=name, webhook=webhook, id=id, enabled=enabled, triggers=triggers, request_options=request_options
        )
        return _response.data
