# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.annotation_queue_page_public import AnnotationQueuePagePublic
from ..types.annotation_queue_public import AnnotationQueuePublic
from ..types.annotation_queue_write import AnnotationQueueWrite
from ..types.annotation_queue_write_scope import AnnotationQueueWriteScope
from .raw_client import AsyncRawAnnotationQueuesClient, RawAnnotationQueuesClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class AnnotationQueuesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawAnnotationQueuesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawAnnotationQueuesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawAnnotationQueuesClient
        """
        return self._raw_client

    def add_items_to_annotation_queue(
        self, id: str, *, ids: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Add traces or threads to annotation queue

        Parameters
        ----------
        id : str

        ids : typing.Sequence[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.annotation_queues.add_items_to_annotation_queue(id='id', ids=['ids'], )
        """
        _response = self._raw_client.add_items_to_annotation_queue(id, ids=ids, request_options=request_options)
        return _response.data

    def find_annotation_queues(
        self,
        *,
        page: typing.Optional[int] = None,
        size: typing.Optional[int] = None,
        name: typing.Optional[str] = None,
        filters: typing.Optional[str] = None,
        sorting: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AnnotationQueuePagePublic:
        """
        Find annotation queues with filtering and sorting

        Parameters
        ----------
        page : typing.Optional[int]

        size : typing.Optional[int]

        name : typing.Optional[str]

        filters : typing.Optional[str]

        sorting : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AnnotationQueuePagePublic
            Annotation queues page

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.annotation_queues.find_annotation_queues()
        """
        _response = self._raw_client.find_annotation_queues(
            page=page, size=size, name=name, filters=filters, sorting=sorting, request_options=request_options
        )
        return _response.data

    def create_annotation_queue(
        self,
        *,
        project_id: str,
        name: str,
        scope: AnnotationQueueWriteScope,
        id: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        instructions: typing.Optional[str] = OMIT,
        comments_enabled: typing.Optional[bool] = OMIT,
        feedback_definition_names: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Create annotation queue for human annotation workflows

        Parameters
        ----------
        project_id : str

        name : str

        scope : AnnotationQueueWriteScope

        id : typing.Optional[str]

        description : typing.Optional[str]

        instructions : typing.Optional[str]

        comments_enabled : typing.Optional[bool]

        feedback_definition_names : typing.Optional[typing.Sequence[str]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.annotation_queues.create_annotation_queue(project_id='project_id', name='name', scope="trace", )
        """
        _response = self._raw_client.create_annotation_queue(
            project_id=project_id,
            name=name,
            scope=scope,
            id=id,
            description=description,
            instructions=instructions,
            comments_enabled=comments_enabled,
            feedback_definition_names=feedback_definition_names,
            request_options=request_options,
        )
        return _response.data

    def create_annotation_queue_batch(
        self,
        *,
        annotation_queues: typing.Sequence[AnnotationQueueWrite],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Create multiple annotation queues for human annotation workflows

        Parameters
        ----------
        annotation_queues : typing.Sequence[AnnotationQueueWrite]
            List of annotation queues to create

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import OpikApi
        from Opik import AnnotationQueueWrite
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.annotation_queues.create_annotation_queue_batch(annotation_queues=[AnnotationQueueWrite(project_id='project_id', name='name', scope="trace", )], )
        """
        _response = self._raw_client.create_annotation_queue_batch(
            annotation_queues=annotation_queues, request_options=request_options
        )
        return _response.data

    def delete_annotation_queue_batch(
        self, *, ids: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Delete multiple annotation queues by their IDs

        Parameters
        ----------
        ids : typing.Sequence[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.annotation_queues.delete_annotation_queue_batch(ids=['ids'], )
        """
        _response = self._raw_client.delete_annotation_queue_batch(ids=ids, request_options=request_options)
        return _response.data

    def get_annotation_queue_by_id(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AnnotationQueuePublic:
        """
        Get annotation queue by id

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AnnotationQueuePublic
            Annotation queue resource

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.annotation_queues.get_annotation_queue_by_id(id='id', )
        """
        _response = self._raw_client.get_annotation_queue_by_id(id, request_options=request_options)
        return _response.data

    def update_annotation_queue(
        self,
        id: str,
        *,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        instructions: typing.Optional[str] = OMIT,
        comments_enabled: typing.Optional[bool] = OMIT,
        feedback_definition_names: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Update annotation queue by id

        Parameters
        ----------
        id : str

        name : typing.Optional[str]

        description : typing.Optional[str]

        instructions : typing.Optional[str]

        comments_enabled : typing.Optional[bool]

        feedback_definition_names : typing.Optional[typing.Sequence[str]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.annotation_queues.update_annotation_queue(id='id', )
        """
        _response = self._raw_client.update_annotation_queue(
            id,
            name=name,
            description=description,
            instructions=instructions,
            comments_enabled=comments_enabled,
            feedback_definition_names=feedback_definition_names,
            request_options=request_options,
        )
        return _response.data

    def remove_items_from_annotation_queue(
        self, id: str, *, ids: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Remove items from annotation queue

        Parameters
        ----------
        id : str

        ids : typing.Sequence[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.annotation_queues.remove_items_from_annotation_queue(id='id', ids=['ids'], )
        """
        _response = self._raw_client.remove_items_from_annotation_queue(id, ids=ids, request_options=request_options)
        return _response.data


class AsyncAnnotationQueuesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawAnnotationQueuesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawAnnotationQueuesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawAnnotationQueuesClient
        """
        return self._raw_client

    async def add_items_to_annotation_queue(
        self, id: str, *, ids: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Add traces or threads to annotation queue

        Parameters
        ----------
        id : str

        ids : typing.Sequence[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.annotation_queues.add_items_to_annotation_queue(id='id', ids=['ids'], )
        asyncio.run(main())
        """
        _response = await self._raw_client.add_items_to_annotation_queue(id, ids=ids, request_options=request_options)
        return _response.data

    async def find_annotation_queues(
        self,
        *,
        page: typing.Optional[int] = None,
        size: typing.Optional[int] = None,
        name: typing.Optional[str] = None,
        filters: typing.Optional[str] = None,
        sorting: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AnnotationQueuePagePublic:
        """
        Find annotation queues with filtering and sorting

        Parameters
        ----------
        page : typing.Optional[int]

        size : typing.Optional[int]

        name : typing.Optional[str]

        filters : typing.Optional[str]

        sorting : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AnnotationQueuePagePublic
            Annotation queues page

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.annotation_queues.find_annotation_queues()
        asyncio.run(main())
        """
        _response = await self._raw_client.find_annotation_queues(
            page=page, size=size, name=name, filters=filters, sorting=sorting, request_options=request_options
        )
        return _response.data

    async def create_annotation_queue(
        self,
        *,
        project_id: str,
        name: str,
        scope: AnnotationQueueWriteScope,
        id: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        instructions: typing.Optional[str] = OMIT,
        comments_enabled: typing.Optional[bool] = OMIT,
        feedback_definition_names: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Create annotation queue for human annotation workflows

        Parameters
        ----------
        project_id : str

        name : str

        scope : AnnotationQueueWriteScope

        id : typing.Optional[str]

        description : typing.Optional[str]

        instructions : typing.Optional[str]

        comments_enabled : typing.Optional[bool]

        feedback_definition_names : typing.Optional[typing.Sequence[str]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.annotation_queues.create_annotation_queue(project_id='project_id', name='name', scope="trace", )
        asyncio.run(main())
        """
        _response = await self._raw_client.create_annotation_queue(
            project_id=project_id,
            name=name,
            scope=scope,
            id=id,
            description=description,
            instructions=instructions,
            comments_enabled=comments_enabled,
            feedback_definition_names=feedback_definition_names,
            request_options=request_options,
        )
        return _response.data

    async def create_annotation_queue_batch(
        self,
        *,
        annotation_queues: typing.Sequence[AnnotationQueueWrite],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Create multiple annotation queues for human annotation workflows

        Parameters
        ----------
        annotation_queues : typing.Sequence[AnnotationQueueWrite]
            List of annotation queues to create

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import AsyncOpikApi
        from Opik import AnnotationQueueWrite
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.annotation_queues.create_annotation_queue_batch(annotation_queues=[AnnotationQueueWrite(project_id='project_id', name='name', scope="trace", )], )
        asyncio.run(main())
        """
        _response = await self._raw_client.create_annotation_queue_batch(
            annotation_queues=annotation_queues, request_options=request_options
        )
        return _response.data

    async def delete_annotation_queue_batch(
        self, *, ids: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Delete multiple annotation queues by their IDs

        Parameters
        ----------
        ids : typing.Sequence[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.annotation_queues.delete_annotation_queue_batch(ids=['ids'], )
        asyncio.run(main())
        """
        _response = await self._raw_client.delete_annotation_queue_batch(ids=ids, request_options=request_options)
        return _response.data

    async def get_annotation_queue_by_id(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AnnotationQueuePublic:
        """
        Get annotation queue by id

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AnnotationQueuePublic
            Annotation queue resource

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.annotation_queues.get_annotation_queue_by_id(id='id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_annotation_queue_by_id(id, request_options=request_options)
        return _response.data

    async def update_annotation_queue(
        self,
        id: str,
        *,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        instructions: typing.Optional[str] = OMIT,
        comments_enabled: typing.Optional[bool] = OMIT,
        feedback_definition_names: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Update annotation queue by id

        Parameters
        ----------
        id : str

        name : typing.Optional[str]

        description : typing.Optional[str]

        instructions : typing.Optional[str]

        comments_enabled : typing.Optional[bool]

        feedback_definition_names : typing.Optional[typing.Sequence[str]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.annotation_queues.update_annotation_queue(id='id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.update_annotation_queue(
            id,
            name=name,
            description=description,
            instructions=instructions,
            comments_enabled=comments_enabled,
            feedback_definition_names=feedback_definition_names,
            request_options=request_options,
        )
        return _response.data

    async def remove_items_from_annotation_queue(
        self, id: str, *, ids: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Remove items from annotation queue

        Parameters
        ----------
        id : str

        ids : typing.Sequence[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.annotation_queues.remove_items_from_annotation_queue(id='id', ids=['ids'], )
        asyncio.run(main())
        """
        _response = await self._raw_client.remove_items_from_annotation_queue(
            id, ids=ids, request_options=request_options
        )
        return _response.data
