# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.attachment_page import AttachmentPage
from ..types.complete_multipart_upload_request_entity_type import CompleteMultipartUploadRequestEntityType
from ..types.multipart_upload_part import MultipartUploadPart
from ..types.start_multipart_upload_response import StartMultipartUploadResponse
from .raw_client import AsyncRawAttachmentsClient, RawAttachmentsClient
from .types.attachment_list_request_entity_type import AttachmentListRequestEntityType
from .types.download_attachment_request_entity_type import DownloadAttachmentRequestEntityType
from .types.start_multipart_upload_request_entity_type import StartMultipartUploadRequestEntityType
from .types.upload_attachment_request_entity_type import UploadAttachmentRequestEntityType

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class AttachmentsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawAttachmentsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawAttachmentsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawAttachmentsClient
        """
        return self._raw_client

    def attachment_list(
        self,
        *,
        project_id: str,
        entity_type: AttachmentListRequestEntityType,
        entity_id: str,
        path: str,
        page: typing.Optional[int] = None,
        size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AttachmentPage:
        """
        Attachments list for entity

        Parameters
        ----------
        project_id : str

        entity_type : AttachmentListRequestEntityType

        entity_id : str

        path : str

        page : typing.Optional[int]

        size : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AttachmentPage
            Attachment Resource

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.attachments.attachment_list(project_id='project_id', entity_type="trace", entity_id='entity_id', path='path', )
        """
        _response = self._raw_client.attachment_list(
            project_id=project_id,
            entity_type=entity_type,
            entity_id=entity_id,
            path=path,
            page=page,
            size=size,
            request_options=request_options,
        )
        return _response.data

    def complete_multi_part_upload(
        self,
        *,
        file_name: str,
        entity_type: CompleteMultipartUploadRequestEntityType,
        entity_id: str,
        file_size: int,
        upload_id: str,
        uploaded_file_parts: typing.Sequence[MultipartUploadPart],
        project_name: typing.Optional[str] = OMIT,
        container_id: typing.Optional[str] = OMIT,
        mime_type: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Complete multipart attachment upload

        Parameters
        ----------
        file_name : str

        entity_type : CompleteMultipartUploadRequestEntityType

        entity_id : str

        file_size : int

        upload_id : str

        uploaded_file_parts : typing.Sequence[MultipartUploadPart]

        project_name : typing.Optional[str]
            If null, the default project is used

        container_id : typing.Optional[str]

        mime_type : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import OpikApi
        from Opik import MultipartUploadPart
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.attachments.complete_multi_part_upload(file_name='file_name', entity_type="trace", entity_id='entity_id', file_size=1000000, upload_id='upload_id', uploaded_file_parts=[MultipartUploadPart(e_tag='e_tag', part_number=1, )], )
        """
        _response = self._raw_client.complete_multi_part_upload(
            file_name=file_name,
            entity_type=entity_type,
            entity_id=entity_id,
            file_size=file_size,
            upload_id=upload_id,
            uploaded_file_parts=uploaded_file_parts,
            project_name=project_name,
            container_id=container_id,
            mime_type=mime_type,
            request_options=request_options,
        )
        return _response.data

    def delete_attachments(
        self,
        *,
        file_name: str,
        entity_type: CompleteMultipartUploadRequestEntityType,
        entity_id: str,
        file_size: int,
        upload_id: str,
        uploaded_file_parts: typing.Sequence[MultipartUploadPart],
        project_name: typing.Optional[str] = OMIT,
        container_id: typing.Optional[str] = OMIT,
        mime_type: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Delete attachments

        Parameters
        ----------
        file_name : str

        entity_type : CompleteMultipartUploadRequestEntityType

        entity_id : str

        file_size : int

        upload_id : str

        uploaded_file_parts : typing.Sequence[MultipartUploadPart]

        project_name : typing.Optional[str]
            If null, the default project is used

        container_id : typing.Optional[str]

        mime_type : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import OpikApi
        from Opik import MultipartUploadPart
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.attachments.delete_attachments(file_name='file_name', entity_type="trace", entity_id='entity_id', file_size=1000000, upload_id='upload_id', uploaded_file_parts=[MultipartUploadPart(e_tag='e_tag', part_number=1, )], )
        """
        _response = self._raw_client.delete_attachments(
            file_name=file_name,
            entity_type=entity_type,
            entity_id=entity_id,
            file_size=file_size,
            upload_id=upload_id,
            uploaded_file_parts=uploaded_file_parts,
            project_name=project_name,
            container_id=container_id,
            mime_type=mime_type,
            request_options=request_options,
        )
        return _response.data

    def download_attachment(
        self,
        *,
        container_id: str,
        entity_type: DownloadAttachmentRequestEntityType,
        entity_id: str,
        file_name: str,
        mime_type: str,
        workspace_name: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Iterator[bytes]:
        """
        Download attachment from MinIO

        Parameters
        ----------
        container_id : str

        entity_type : DownloadAttachmentRequestEntityType

        entity_id : str

        file_name : str

        mime_type : str

        workspace_name : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.Iterator[bytes]
            Attachment Resource
        """
        with self._raw_client.download_attachment(
            container_id=container_id,
            entity_type=entity_type,
            entity_id=entity_id,
            file_name=file_name,
            mime_type=mime_type,
            workspace_name=workspace_name,
            request_options=request_options,
        ) as r:
            yield from r.data

    def start_multi_part_upload(
        self,
        *,
        file_name: str,
        num_of_file_parts: int,
        entity_type: StartMultipartUploadRequestEntityType,
        entity_id: str,
        path: str,
        mime_type: typing.Optional[str] = OMIT,
        project_name: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> StartMultipartUploadResponse:
        """
        Start multipart attachment upload

        Parameters
        ----------
        file_name : str

        num_of_file_parts : int

        entity_type : StartMultipartUploadRequestEntityType

        entity_id : str

        path : str

        mime_type : typing.Optional[str]

        project_name : typing.Optional[str]
            If null, the default project is used

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        StartMultipartUploadResponse
            MultipartUploadResponse

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.attachments.start_multi_part_upload(file_name='file_name', num_of_file_parts=1, entity_type="trace", entity_id='entity_id', path='path', )
        """
        _response = self._raw_client.start_multi_part_upload(
            file_name=file_name,
            num_of_file_parts=num_of_file_parts,
            entity_type=entity_type,
            entity_id=entity_id,
            path=path,
            mime_type=mime_type,
            project_name=project_name,
            request_options=request_options,
        )
        return _response.data

    def upload_attachment(
        self,
        *,
        file_name: str,
        entity_type: UploadAttachmentRequestEntityType,
        entity_id: str,
        request: typing.Dict[str, typing.Optional[typing.Any]],
        project_name: typing.Optional[str] = None,
        mime_type: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Upload attachment to MinIO

        Parameters
        ----------
        file_name : str

        entity_type : UploadAttachmentRequestEntityType

        entity_id : str

        request : typing.Dict[str, typing.Optional[typing.Any]]

        project_name : typing.Optional[str]

        mime_type : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.attachments.upload_attachment(file_name='file_name', entity_type="trace", entity_id='entity_id', request={'key': 'value'
        }, )
        """
        _response = self._raw_client.upload_attachment(
            file_name=file_name,
            entity_type=entity_type,
            entity_id=entity_id,
            request=request,
            project_name=project_name,
            mime_type=mime_type,
            request_options=request_options,
        )
        return _response.data


class AsyncAttachmentsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawAttachmentsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawAttachmentsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawAttachmentsClient
        """
        return self._raw_client

    async def attachment_list(
        self,
        *,
        project_id: str,
        entity_type: AttachmentListRequestEntityType,
        entity_id: str,
        path: str,
        page: typing.Optional[int] = None,
        size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AttachmentPage:
        """
        Attachments list for entity

        Parameters
        ----------
        project_id : str

        entity_type : AttachmentListRequestEntityType

        entity_id : str

        path : str

        page : typing.Optional[int]

        size : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AttachmentPage
            Attachment Resource

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.attachments.attachment_list(project_id='project_id', entity_type="trace", entity_id='entity_id', path='path', )
        asyncio.run(main())
        """
        _response = await self._raw_client.attachment_list(
            project_id=project_id,
            entity_type=entity_type,
            entity_id=entity_id,
            path=path,
            page=page,
            size=size,
            request_options=request_options,
        )
        return _response.data

    async def complete_multi_part_upload(
        self,
        *,
        file_name: str,
        entity_type: CompleteMultipartUploadRequestEntityType,
        entity_id: str,
        file_size: int,
        upload_id: str,
        uploaded_file_parts: typing.Sequence[MultipartUploadPart],
        project_name: typing.Optional[str] = OMIT,
        container_id: typing.Optional[str] = OMIT,
        mime_type: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Complete multipart attachment upload

        Parameters
        ----------
        file_name : str

        entity_type : CompleteMultipartUploadRequestEntityType

        entity_id : str

        file_size : int

        upload_id : str

        uploaded_file_parts : typing.Sequence[MultipartUploadPart]

        project_name : typing.Optional[str]
            If null, the default project is used

        container_id : typing.Optional[str]

        mime_type : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import AsyncOpikApi
        from Opik import MultipartUploadPart
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.attachments.complete_multi_part_upload(file_name='file_name', entity_type="trace", entity_id='entity_id', file_size=1000000, upload_id='upload_id', uploaded_file_parts=[MultipartUploadPart(e_tag='e_tag', part_number=1, )], )
        asyncio.run(main())
        """
        _response = await self._raw_client.complete_multi_part_upload(
            file_name=file_name,
            entity_type=entity_type,
            entity_id=entity_id,
            file_size=file_size,
            upload_id=upload_id,
            uploaded_file_parts=uploaded_file_parts,
            project_name=project_name,
            container_id=container_id,
            mime_type=mime_type,
            request_options=request_options,
        )
        return _response.data

    async def delete_attachments(
        self,
        *,
        file_name: str,
        entity_type: CompleteMultipartUploadRequestEntityType,
        entity_id: str,
        file_size: int,
        upload_id: str,
        uploaded_file_parts: typing.Sequence[MultipartUploadPart],
        project_name: typing.Optional[str] = OMIT,
        container_id: typing.Optional[str] = OMIT,
        mime_type: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Delete attachments

        Parameters
        ----------
        file_name : str

        entity_type : CompleteMultipartUploadRequestEntityType

        entity_id : str

        file_size : int

        upload_id : str

        uploaded_file_parts : typing.Sequence[MultipartUploadPart]

        project_name : typing.Optional[str]
            If null, the default project is used

        container_id : typing.Optional[str]

        mime_type : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import AsyncOpikApi
        from Opik import MultipartUploadPart
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.attachments.delete_attachments(file_name='file_name', entity_type="trace", entity_id='entity_id', file_size=1000000, upload_id='upload_id', uploaded_file_parts=[MultipartUploadPart(e_tag='e_tag', part_number=1, )], )
        asyncio.run(main())
        """
        _response = await self._raw_client.delete_attachments(
            file_name=file_name,
            entity_type=entity_type,
            entity_id=entity_id,
            file_size=file_size,
            upload_id=upload_id,
            uploaded_file_parts=uploaded_file_parts,
            project_name=project_name,
            container_id=container_id,
            mime_type=mime_type,
            request_options=request_options,
        )
        return _response.data

    async def download_attachment(
        self,
        *,
        container_id: str,
        entity_type: DownloadAttachmentRequestEntityType,
        entity_id: str,
        file_name: str,
        mime_type: str,
        workspace_name: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.AsyncIterator[bytes]:
        """
        Download attachment from MinIO

        Parameters
        ----------
        container_id : str

        entity_type : DownloadAttachmentRequestEntityType

        entity_id : str

        file_name : str

        mime_type : str

        workspace_name : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.AsyncIterator[bytes]
            Attachment Resource
        """
        async with self._raw_client.download_attachment(
            container_id=container_id,
            entity_type=entity_type,
            entity_id=entity_id,
            file_name=file_name,
            mime_type=mime_type,
            workspace_name=workspace_name,
            request_options=request_options,
        ) as r:
            async for data in r.data:
                yield data

    async def start_multi_part_upload(
        self,
        *,
        file_name: str,
        num_of_file_parts: int,
        entity_type: StartMultipartUploadRequestEntityType,
        entity_id: str,
        path: str,
        mime_type: typing.Optional[str] = OMIT,
        project_name: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> StartMultipartUploadResponse:
        """
        Start multipart attachment upload

        Parameters
        ----------
        file_name : str

        num_of_file_parts : int

        entity_type : StartMultipartUploadRequestEntityType

        entity_id : str

        path : str

        mime_type : typing.Optional[str]

        project_name : typing.Optional[str]
            If null, the default project is used

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        StartMultipartUploadResponse
            MultipartUploadResponse

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.attachments.start_multi_part_upload(file_name='file_name', num_of_file_parts=1, entity_type="trace", entity_id='entity_id', path='path', )
        asyncio.run(main())
        """
        _response = await self._raw_client.start_multi_part_upload(
            file_name=file_name,
            num_of_file_parts=num_of_file_parts,
            entity_type=entity_type,
            entity_id=entity_id,
            path=path,
            mime_type=mime_type,
            project_name=project_name,
            request_options=request_options,
        )
        return _response.data

    async def upload_attachment(
        self,
        *,
        file_name: str,
        entity_type: UploadAttachmentRequestEntityType,
        entity_id: str,
        request: typing.Dict[str, typing.Optional[typing.Any]],
        project_name: typing.Optional[str] = None,
        mime_type: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Upload attachment to MinIO

        Parameters
        ----------
        file_name : str

        entity_type : UploadAttachmentRequestEntityType

        entity_id : str

        request : typing.Dict[str, typing.Optional[typing.Any]]

        project_name : typing.Optional[str]

        mime_type : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.attachments.upload_attachment(file_name='file_name', entity_type="trace", entity_id='entity_id', request={'key': 'value'
            }, )
        asyncio.run(main())
        """
        _response = await self._raw_client.upload_attachment(
            file_name=file_name,
            entity_type=entity_type,
            entity_id=entity_id,
            request=request,
            project_name=project_name,
            mime_type=mime_type,
            request_options=request_options,
        )
        return _response.data
