# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.feedback_create import FeedbackCreate
from ..types.feedback_definition_page_public import FeedbackDefinitionPagePublic
from ..types.feedback_public import FeedbackPublic
from ..types.feedback_update import FeedbackUpdate
from .raw_client import AsyncRawFeedbackDefinitionsClient, RawFeedbackDefinitionsClient
from .types.find_feedback_definitions_request_type import FindFeedbackDefinitionsRequestType

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class FeedbackDefinitionsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawFeedbackDefinitionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawFeedbackDefinitionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawFeedbackDefinitionsClient
        """
        return self._raw_client

    def find_feedback_definitions(
        self,
        *,
        page: typing.Optional[int] = None,
        size: typing.Optional[int] = None,
        name: typing.Optional[str] = None,
        type: typing.Optional[FindFeedbackDefinitionsRequestType] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FeedbackDefinitionPagePublic:
        """
        Find Feedback definitions

        Parameters
        ----------
        page : typing.Optional[int]

        size : typing.Optional[int]

        name : typing.Optional[str]

        type : typing.Optional[FindFeedbackDefinitionsRequestType]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FeedbackDefinitionPagePublic
            Feedback definitions resource

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.feedback_definitions.find_feedback_definitions()
        """
        _response = self._raw_client.find_feedback_definitions(
            page=page, size=size, name=name, type=type, request_options=request_options
        )
        return _response.data

    def create_feedback_definition(
        self, *, request: FeedbackCreate, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Get feedback definition

        Parameters
        ----------
        request : FeedbackCreate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import OpikApi
        from Opik import FeedbackCreate_Numerical
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.feedback_definitions.create_feedback_definition(request=FeedbackCreate_Numerical(), )
        """
        _response = self._raw_client.create_feedback_definition(request=request, request_options=request_options)
        return _response.data

    def get_feedback_definition_by_id(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> FeedbackPublic:
        """
        Get feedback definition by id

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FeedbackPublic
            Feedback definition resource

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.feedback_definitions.get_feedback_definition_by_id(id='id', )
        """
        _response = self._raw_client.get_feedback_definition_by_id(id, request_options=request_options)
        return _response.data

    def update_feedback_definition(
        self, id: str, *, request: FeedbackUpdate, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Update feedback definition by id

        Parameters
        ----------
        id : str

        request : FeedbackUpdate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import OpikApi
        from Opik import FeedbackUpdate_Numerical
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.feedback_definitions.update_feedback_definition(id='id', request=FeedbackUpdate_Numerical(), )
        """
        _response = self._raw_client.update_feedback_definition(id, request=request, request_options=request_options)
        return _response.data

    def delete_feedback_definition_by_id(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Delete feedback definition by id

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.feedback_definitions.delete_feedback_definition_by_id(id='id', )
        """
        _response = self._raw_client.delete_feedback_definition_by_id(id, request_options=request_options)
        return _response.data

    def delete_feedback_definitions_batch(
        self, *, ids: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Delete feedback definitions batch

        Parameters
        ----------
        ids : typing.Sequence[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.feedback_definitions.delete_feedback_definitions_batch(ids=['ids'], )
        """
        _response = self._raw_client.delete_feedback_definitions_batch(ids=ids, request_options=request_options)
        return _response.data


class AsyncFeedbackDefinitionsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawFeedbackDefinitionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawFeedbackDefinitionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawFeedbackDefinitionsClient
        """
        return self._raw_client

    async def find_feedback_definitions(
        self,
        *,
        page: typing.Optional[int] = None,
        size: typing.Optional[int] = None,
        name: typing.Optional[str] = None,
        type: typing.Optional[FindFeedbackDefinitionsRequestType] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FeedbackDefinitionPagePublic:
        """
        Find Feedback definitions

        Parameters
        ----------
        page : typing.Optional[int]

        size : typing.Optional[int]

        name : typing.Optional[str]

        type : typing.Optional[FindFeedbackDefinitionsRequestType]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FeedbackDefinitionPagePublic
            Feedback definitions resource

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.feedback_definitions.find_feedback_definitions()
        asyncio.run(main())
        """
        _response = await self._raw_client.find_feedback_definitions(
            page=page, size=size, name=name, type=type, request_options=request_options
        )
        return _response.data

    async def create_feedback_definition(
        self, *, request: FeedbackCreate, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Get feedback definition

        Parameters
        ----------
        request : FeedbackCreate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import AsyncOpikApi
        from Opik import FeedbackCreate_Numerical
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.feedback_definitions.create_feedback_definition(request=FeedbackCreate_Numerical(), )
        asyncio.run(main())
        """
        _response = await self._raw_client.create_feedback_definition(request=request, request_options=request_options)
        return _response.data

    async def get_feedback_definition_by_id(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> FeedbackPublic:
        """
        Get feedback definition by id

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FeedbackPublic
            Feedback definition resource

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.feedback_definitions.get_feedback_definition_by_id(id='id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_feedback_definition_by_id(id, request_options=request_options)
        return _response.data

    async def update_feedback_definition(
        self, id: str, *, request: FeedbackUpdate, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Update feedback definition by id

        Parameters
        ----------
        id : str

        request : FeedbackUpdate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import AsyncOpikApi
        from Opik import FeedbackUpdate_Numerical
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.feedback_definitions.update_feedback_definition(id='id', request=FeedbackUpdate_Numerical(), )
        asyncio.run(main())
        """
        _response = await self._raw_client.update_feedback_definition(
            id, request=request, request_options=request_options
        )
        return _response.data

    async def delete_feedback_definition_by_id(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Delete feedback definition by id

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.feedback_definitions.delete_feedback_definition_by_id(id='id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.delete_feedback_definition_by_id(id, request_options=request_options)
        return _response.data

    async def delete_feedback_definitions_batch(
        self, *, ids: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Delete feedback definitions batch

        Parameters
        ----------
        ids : typing.Sequence[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.feedback_definitions.delete_feedback_definitions_batch(ids=['ids'], )
        asyncio.run(main())
        """
        _response = await self._raw_client.delete_feedback_definitions_batch(ids=ids, request_options=request_options)
        return _response.data
