# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .dataset_item import DatasetItem


class DatasetExpansionResponse(UniversalBaseModel):
    generated_samples: typing.Optional[typing.List[DatasetItem]] = pydantic.Field(default=None)
    """
    List of generated synthetic dataset items
    """

    model: typing.Optional[str] = pydantic.Field(default=None)
    """
    Model used for generation
    """

    total_generated: typing.Optional[int] = pydantic.Field(default=None)
    """
    Total number of samples generated
    """

    generation_time: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    Generation timestamp
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
