# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .categorical_feedback_detail_update import CategoricalFeedbackDetailUpdate
from .numerical_feedback_detail_update import NumericalFeedbackDetailUpdate


class Base(UniversalBaseModel):
    id: typing.Optional[str] = None
    name: str
    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Optional description for the feedback definition
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class FeedbackUpdate_Numerical(Base):
    type: typing.Literal["numerical"] = "numerical"
    details: typing.Optional[NumericalFeedbackDetailUpdate] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class FeedbackUpdate_Categorical(Base):
    type: typing.Literal["categorical"] = "categorical"
    details: typing.Optional[CategoricalFeedbackDetailUpdate] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


FeedbackUpdate = typing.Union[FeedbackUpdate_Numerical, FeedbackUpdate_Categorical]
