from collections import defaultdict

import casregnum

from . import elements as elements

class ChemFormulaString:
    def __init__(self, formula: str, charge: int = 0) -> None: ...
    @property
    def formula(self) -> str: ...
    @formula.setter
    def formula(self, input_formula: str) -> None: ...
    @property
    def charge(self) -> int: ...
    @charge.setter
    def charge(self, charge: int) -> None: ...
    @property
    def charged(self) -> bool: ...
    @property
    def text_charge(self) -> str: ...
    @property
    def text_formula(self) -> str: ...
    def format_formula(self, formula_prefix: str = '', element_prefix: str = '', element_suffix: str = '', freq_prefix: str = '', freq_suffix: str = '', formula_suffix: str = '', bracket_prefix: str = '', bracket_suffix: str = '', multiply_symbol: str = '', charge_prefix: str = '', charge_suffix: str = '', charge_positive: str = '+', charge_negative: str = '-') -> str: ...
    @property
    def latex(self) -> str: ...
    @property
    def html(self) -> str: ...
    @property
    def unicode(self) -> str: ...

class ChemFormulaDict(defaultdict):
    def __init__(self, *args, **kwargs) -> None: ...
    def __setitem__(self, key_element: str, value_frequency: int | float) -> None: ...

class ChemFormula(ChemFormulaString):
    def __init__(self, formula: str, charge: int = 0, name: str | None = None, cas: str | int | None = None) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    @property
    def element(self) -> ChemFormulaDict: ...
    @property
    def sum_formula(self) -> ChemFormulaString: ...
    @property
    def hill_formula(self) -> ChemFormulaString: ...
    @property
    def formula_weight(self) -> float: ...
    @property
    def mass_fraction(self) -> ChemFormulaDict: ...
    @property
    def is_radioactive(self) -> bool: ...
    @property
    def radioactive(self) -> bool: ...
    @property
    def contains_isotopes(self) -> bool: ...
    @property
    def name(self) -> str | None: ...
    @name.setter
    def name(self, name: str | None) -> None: ...
    @property
    def cas(self) -> casregnum.CAS | None: ...
    @cas.setter
    def cas(self, cas_rn: int | str | None) -> None: ...
