from __future__ import annotations

from enum import IntEnum
from typing import TYPE_CHECKING

from vapoursynth import FLOAT, GRAY, INTEGER, RGB, YUV
from vapoursynth import PresetFormat as VSPresetFormat

__all__ = [
    'PresetFormat',
    'GRAY8', 'GRAY9', 'GRAY10', 'GRAY11', 'GRAY12', 'GRAY13', 'GRAY14', 'GRAY15', 'GRAY16', 'GRAY17', 'GRAY18',
    'GRAY19', 'GRAY20', 'GRAY21', 'GRAY22', 'GRAY23', 'GRAY24', 'GRAY25', 'GRAY26', 'GRAY27', 'GRAY28', 'GRAY29',
    'GRAY30', 'GRAY31', 'GRAY32', 'GRAYH', 'GRAYS',
    'YUV420P8', 'YUV420P9', 'YUV420P10', 'YUV420P11', 'YUV420P12',
    'YUV420P13', 'YUV420P15', 'YUV420P16', 'YUV420P17', 'YUV420P18', 'YUV420P19', 'YUV420P20', 'YUV420P21', 'YUV420P22',
    'YUV420P23', 'YUV420P24', 'YUV420P25', 'YUV420P26', 'YUV420P27', 'YUV420P28', 'YUV420P29', 'YUV420P30', 'YUV420P31',
    'YUV420P32', 'YUV420PH', 'YUV420PS',
    'YUV444P8', 'YUV444P9', 'YUV444P10', 'YUV444P11', 'YUV444P12', 'YUV444P13',
    'YUV444P14', 'YUV444P15', 'YUV444P16', 'YUV444P17', 'YUV444P18', 'YUV444P19', 'YUV444P20', 'YUV444P21', 'YUV444P22',
    'YUV444P23', 'YUV444P24', 'YUV444P25', 'YUV444P26', 'YUV444P27', 'YUV444P28', 'YUV444P29', 'YUV444P30', 'YUV444P31',
    'YUV444P32', 'YUV444PH', 'YUV444PS',
    'YUV422P8', 'YUV422P9', 'YUV422P10', 'YUV422P11', 'YUV422P12', 'YUV422P13',
    'YUV422P14', 'YUV422P15', 'YUV422P16', 'YUV422P17', 'YUV422P18', 'YUV422P19', 'YUV422P20', 'YUV422P21', 'YUV422P22',
    'YUV422P23', 'YUV422P24', 'YUV422P25', 'YUV422P26', 'YUV422P27', 'YUV422P28', 'YUV422P29', 'YUV422P30', 'YUV422P31',
    'YUV422P32', 'YUV422PH', 'YUV422PS',
    'YUV411P8', 'YUV411P9', 'YUV411P10', 'YUV411P11', 'YUV411P12', 'YUV411P13',
    'YUV411P14', 'YUV411P15', 'YUV411P16', 'YUV411P17', 'YUV411P18', 'YUV411P19', 'YUV411P20', 'YUV411P21', 'YUV411P22',
    'YUV411P23', 'YUV411P24', 'YUV411P25', 'YUV411P26', 'YUV411P27', 'YUV411P28', 'YUV411P29', 'YUV411P30', 'YUV411P31',
    'YUV411P32', 'YUV411PH', 'YUV411PS',
    'YUV440P8', 'YUV440P9', 'YUV440P10', 'YUV440P11', 'YUV440P12', 'YUV440P13',
    'YUV440P14', 'YUV440P15', 'YUV440P16', 'YUV440P17', 'YUV440P18', 'YUV440P19', 'YUV440P20', 'YUV440P21', 'YUV440P22',
    'YUV440P23', 'YUV440P24', 'YUV440P25', 'YUV440P26', 'YUV440P27', 'YUV440P28', 'YUV440P29', 'YUV440P30', 'YUV440P31',
    'YUV440P32', 'YUV440PH', 'YUV440PS',
    'YUV410P8', 'YUV410P9', 'YUV410P10', 'YUV410P11', 'YUV410P12', 'YUV410P13',
    'YUV410P14', 'YUV410P15', 'YUV410P16', 'YUV410P17', 'YUV410P18', 'YUV410P19', 'YUV410P20', 'YUV410P21', 'YUV410P22',
    'YUV410P23', 'YUV410P24', 'YUV410P25', 'YUV410P26', 'YUV410P27', 'YUV410P28', 'YUV410P29', 'YUV410P30', 'YUV410P31',
    'YUV410P32', 'YUV410PH', 'YUV410PS',
    'RGB24', 'RGB27', 'RGB30', 'RGB33', 'RGB36', 'RGB39', 'RGB42', 'RGB45',
    'RGB48', 'RGB51', 'RGB54', 'RGB57', 'RGB60', 'RGB63', 'RGB66', 'RGB69', 'RGB72', 'RGB75', 'RGB78', 'RGB81',
    'RGB84', 'RGB87', 'RGB90', 'RGB93', 'RGB96', 'RGBH', 'RGBS'
]


def MAKE_VIDEO_ID(colorFamily: int, sampleType: int, bitsPerSample: int, subSamplingW: int, subSamplingH: int) -> int:
    return colorFamily << 28 | sampleType << 24 | bitsPerSample << 16 | subSamplingW << 8 | subSamplingH << 0


if TYPE_CHECKING:
    PresetFormatBase = VSPresetFormat
else:
    PresetFormatBase = IntEnum


################################################

class PresetFormat(PresetFormatBase):
    GRAY8 = MAKE_VIDEO_ID(GRAY, INTEGER, 8, 0, 0)  # type: ignore[misc,assignment]
    GRAY9 = MAKE_VIDEO_ID(GRAY, INTEGER, 9, 0, 0)  # type: ignore[misc,assignment]
    GRAY10 = MAKE_VIDEO_ID(GRAY, INTEGER, 10, 0, 0)  # type: ignore[misc,assignment]
    GRAY11 = MAKE_VIDEO_ID(GRAY, INTEGER, 11, 0, 0)
    GRAY12 = MAKE_VIDEO_ID(GRAY, INTEGER, 12, 0, 0)  # type: ignore[misc,assignment]
    GRAY13 = MAKE_VIDEO_ID(GRAY, INTEGER, 13, 0, 0)
    GRAY14 = MAKE_VIDEO_ID(GRAY, INTEGER, 14, 0, 0)  # type: ignore[misc,assignment]
    GRAY15 = MAKE_VIDEO_ID(GRAY, INTEGER, 15, 0, 0)
    GRAY16 = MAKE_VIDEO_ID(GRAY, INTEGER, 16, 0, 0)  # type: ignore[misc,assignment]
    GRAY17 = MAKE_VIDEO_ID(GRAY, INTEGER, 17, 0, 0)
    GRAY18 = MAKE_VIDEO_ID(GRAY, INTEGER, 18, 0, 0)
    GRAY19 = MAKE_VIDEO_ID(GRAY, INTEGER, 19, 0, 0)
    GRAY20 = MAKE_VIDEO_ID(GRAY, INTEGER, 20, 0, 0)
    GRAY21 = MAKE_VIDEO_ID(GRAY, INTEGER, 21, 0, 0)
    GRAY22 = MAKE_VIDEO_ID(GRAY, INTEGER, 22, 0, 0)
    GRAY23 = MAKE_VIDEO_ID(GRAY, INTEGER, 23, 0, 0)
    GRAY24 = MAKE_VIDEO_ID(GRAY, INTEGER, 24, 0, 0)
    GRAY25 = MAKE_VIDEO_ID(GRAY, INTEGER, 25, 0, 0)
    GRAY26 = MAKE_VIDEO_ID(GRAY, INTEGER, 26, 0, 0)
    GRAY27 = MAKE_VIDEO_ID(GRAY, INTEGER, 27, 0, 0)
    GRAY28 = MAKE_VIDEO_ID(GRAY, INTEGER, 28, 0, 0)
    GRAY29 = MAKE_VIDEO_ID(GRAY, INTEGER, 29, 0, 0)
    GRAY30 = MAKE_VIDEO_ID(GRAY, INTEGER, 30, 0, 0)
    GRAY31 = MAKE_VIDEO_ID(GRAY, INTEGER, 31, 0, 0)
    GRAY32 = MAKE_VIDEO_ID(GRAY, INTEGER, 32, 0, 0)  # type: ignore[misc,assignment]

    GRAYH = MAKE_VIDEO_ID(GRAY, FLOAT, 16, 0, 0)  # type: ignore[misc,assignment]
    GRAYS = MAKE_VIDEO_ID(GRAY, FLOAT, 32, 0, 0)  # type: ignore[misc,assignment]

    ################################################

    YUV420P8 = MAKE_VIDEO_ID(YUV, INTEGER, 8, 1, 1)  # type: ignore[misc,assignment]
    YUV420P9 = MAKE_VIDEO_ID(YUV, INTEGER, 9, 1, 1)  # type: ignore[misc,assignment]
    YUV420P10 = MAKE_VIDEO_ID(YUV, INTEGER, 10, 1, 1)  # type: ignore[misc,assignment]
    YUV420P11 = MAKE_VIDEO_ID(YUV, INTEGER, 11, 1, 1)
    YUV420P12 = MAKE_VIDEO_ID(YUV, INTEGER, 12, 1, 1)  # type: ignore[misc,assignment]
    YUV420P13 = MAKE_VIDEO_ID(YUV, INTEGER, 13, 1, 1)
    YUV420P15 = MAKE_VIDEO_ID(YUV, INTEGER, 15, 1, 1)
    YUV420P16 = MAKE_VIDEO_ID(YUV, INTEGER, 16, 1, 1)  # type: ignore[misc,assignment]
    YUV420P17 = MAKE_VIDEO_ID(YUV, INTEGER, 17, 1, 1)
    YUV420P18 = MAKE_VIDEO_ID(YUV, INTEGER, 18, 1, 1)
    YUV420P19 = MAKE_VIDEO_ID(YUV, INTEGER, 19, 1, 1)
    YUV420P20 = MAKE_VIDEO_ID(YUV, INTEGER, 20, 1, 1)
    YUV420P21 = MAKE_VIDEO_ID(YUV, INTEGER, 21, 1, 1)
    YUV420P22 = MAKE_VIDEO_ID(YUV, INTEGER, 22, 1, 1)
    YUV420P23 = MAKE_VIDEO_ID(YUV, INTEGER, 23, 1, 1)
    YUV420P24 = MAKE_VIDEO_ID(YUV, INTEGER, 24, 1, 1)
    YUV420P25 = MAKE_VIDEO_ID(YUV, INTEGER, 25, 1, 1)
    YUV420P26 = MAKE_VIDEO_ID(YUV, INTEGER, 26, 1, 1)
    YUV420P27 = MAKE_VIDEO_ID(YUV, INTEGER, 27, 1, 1)
    YUV420P28 = MAKE_VIDEO_ID(YUV, INTEGER, 28, 1, 1)
    YUV420P29 = MAKE_VIDEO_ID(YUV, INTEGER, 29, 1, 1)
    YUV420P30 = MAKE_VIDEO_ID(YUV, INTEGER, 30, 1, 1)
    YUV420P31 = MAKE_VIDEO_ID(YUV, INTEGER, 31, 1, 1)
    YUV420P32 = MAKE_VIDEO_ID(YUV, INTEGER, 32, 1, 1)

    YUV420PH = MAKE_VIDEO_ID(YUV, FLOAT, 16, 1, 1)
    YUV420PS = MAKE_VIDEO_ID(YUV, FLOAT, 32, 1, 1)

    ################################################

    YUV444P8 = MAKE_VIDEO_ID(YUV, INTEGER, 8, 0, 0)  # type: ignore[misc,assignment]
    YUV444P9 = MAKE_VIDEO_ID(YUV, INTEGER, 9, 0, 0)  # type: ignore[misc,assignment]
    YUV444P10 = MAKE_VIDEO_ID(YUV, INTEGER, 10, 0, 0)  # type: ignore[misc,assignment]
    YUV444P11 = MAKE_VIDEO_ID(YUV, INTEGER, 11, 0, 0)
    YUV444P12 = MAKE_VIDEO_ID(YUV, INTEGER, 12, 0, 0)  # type: ignore[misc,assignment]
    YUV444P13 = MAKE_VIDEO_ID(YUV, INTEGER, 13, 0, 0)
    YUV444P14 = MAKE_VIDEO_ID(YUV, INTEGER, 14, 0, 0)  # type: ignore[misc,assignment]
    YUV444P15 = MAKE_VIDEO_ID(YUV, INTEGER, 15, 0, 0)
    YUV444P16 = MAKE_VIDEO_ID(YUV, INTEGER, 16, 0, 0)  # type: ignore[misc,assignment]
    YUV444P17 = MAKE_VIDEO_ID(YUV, INTEGER, 17, 0, 0)
    YUV444P18 = MAKE_VIDEO_ID(YUV, INTEGER, 18, 0, 0)
    YUV444P19 = MAKE_VIDEO_ID(YUV, INTEGER, 19, 0, 0)
    YUV444P20 = MAKE_VIDEO_ID(YUV, INTEGER, 20, 0, 0)
    YUV444P21 = MAKE_VIDEO_ID(YUV, INTEGER, 21, 0, 0)
    YUV444P22 = MAKE_VIDEO_ID(YUV, INTEGER, 22, 0, 0)
    YUV444P23 = MAKE_VIDEO_ID(YUV, INTEGER, 23, 0, 0)
    YUV444P24 = MAKE_VIDEO_ID(YUV, INTEGER, 24, 0, 0)
    YUV444P25 = MAKE_VIDEO_ID(YUV, INTEGER, 25, 0, 0)
    YUV444P26 = MAKE_VIDEO_ID(YUV, INTEGER, 26, 0, 0)
    YUV444P27 = MAKE_VIDEO_ID(YUV, INTEGER, 27, 0, 0)
    YUV444P28 = MAKE_VIDEO_ID(YUV, INTEGER, 28, 0, 0)
    YUV444P29 = MAKE_VIDEO_ID(YUV, INTEGER, 29, 0, 0)
    YUV444P30 = MAKE_VIDEO_ID(YUV, INTEGER, 30, 0, 0)
    YUV444P31 = MAKE_VIDEO_ID(YUV, INTEGER, 31, 0, 0)
    YUV444P32 = MAKE_VIDEO_ID(YUV, INTEGER, 32, 0, 0)

    YUV444PH = MAKE_VIDEO_ID(YUV, FLOAT, 16, 0, 0)  # type: ignore[misc,assignment]
    YUV444PS = MAKE_VIDEO_ID(YUV, FLOAT, 32, 0, 0)  # type: ignore[misc,assignment]

    ################################################

    YUV422P8 = MAKE_VIDEO_ID(YUV, INTEGER, 8, 1, 0)  # type: ignore[misc,assignment]
    YUV422P9 = MAKE_VIDEO_ID(YUV, INTEGER, 9, 1, 0)  # type: ignore[misc,assignment]
    YUV422P10 = MAKE_VIDEO_ID(YUV, INTEGER, 10, 1, 0)  # type: ignore[misc,assignment]
    YUV422P11 = MAKE_VIDEO_ID(YUV, INTEGER, 11, 1, 0)
    YUV422P12 = MAKE_VIDEO_ID(YUV, INTEGER, 12, 1, 0)  # type: ignore[misc,assignment]
    YUV422P13 = MAKE_VIDEO_ID(YUV, INTEGER, 13, 1, 0)
    YUV422P14 = MAKE_VIDEO_ID(YUV, INTEGER, 14, 1, 0)  # type: ignore[misc,assignment]
    YUV422P15 = MAKE_VIDEO_ID(YUV, INTEGER, 15, 1, 0)
    YUV422P16 = MAKE_VIDEO_ID(YUV, INTEGER, 16, 1, 0)  # type: ignore[misc,assignment]
    YUV422P17 = MAKE_VIDEO_ID(YUV, INTEGER, 17, 1, 0)
    YUV422P18 = MAKE_VIDEO_ID(YUV, INTEGER, 18, 1, 0)
    YUV422P19 = MAKE_VIDEO_ID(YUV, INTEGER, 19, 1, 0)
    YUV422P20 = MAKE_VIDEO_ID(YUV, INTEGER, 20, 1, 0)
    YUV422P21 = MAKE_VIDEO_ID(YUV, INTEGER, 21, 1, 0)
    YUV422P22 = MAKE_VIDEO_ID(YUV, INTEGER, 22, 1, 0)
    YUV422P23 = MAKE_VIDEO_ID(YUV, INTEGER, 23, 1, 0)
    YUV422P24 = MAKE_VIDEO_ID(YUV, INTEGER, 24, 1, 0)
    YUV422P25 = MAKE_VIDEO_ID(YUV, INTEGER, 25, 1, 0)
    YUV422P26 = MAKE_VIDEO_ID(YUV, INTEGER, 26, 1, 0)
    YUV422P27 = MAKE_VIDEO_ID(YUV, INTEGER, 27, 1, 0)
    YUV422P28 = MAKE_VIDEO_ID(YUV, INTEGER, 28, 1, 0)
    YUV422P29 = MAKE_VIDEO_ID(YUV, INTEGER, 29, 1, 0)
    YUV422P30 = MAKE_VIDEO_ID(YUV, INTEGER, 30, 1, 0)
    YUV422P31 = MAKE_VIDEO_ID(YUV, INTEGER, 31, 1, 0)
    YUV422P32 = MAKE_VIDEO_ID(YUV, INTEGER, 32, 1, 0)

    YUV422PH = MAKE_VIDEO_ID(YUV, FLOAT, 16, 1, 0)
    YUV422PS = MAKE_VIDEO_ID(YUV, FLOAT, 32, 1, 0)

    ################################################

    YUV411P8 = MAKE_VIDEO_ID(YUV, INTEGER, 8, 2, 0)  # type: ignore[misc,assignment]
    YUV411P9 = MAKE_VIDEO_ID(YUV, INTEGER, 9, 2, 0)
    YUV411P10 = MAKE_VIDEO_ID(YUV, INTEGER, 10, 2, 0)
    YUV411P11 = MAKE_VIDEO_ID(YUV, INTEGER, 11, 2, 0)
    YUV411P12 = MAKE_VIDEO_ID(YUV, INTEGER, 12, 2, 0)
    YUV411P13 = MAKE_VIDEO_ID(YUV, INTEGER, 13, 2, 0)
    YUV411P14 = MAKE_VIDEO_ID(YUV, INTEGER, 14, 2, 0)
    YUV411P15 = MAKE_VIDEO_ID(YUV, INTEGER, 15, 2, 0)
    YUV411P16 = MAKE_VIDEO_ID(YUV, INTEGER, 16, 2, 0)
    YUV411P17 = MAKE_VIDEO_ID(YUV, INTEGER, 17, 2, 0)
    YUV411P18 = MAKE_VIDEO_ID(YUV, INTEGER, 18, 2, 0)
    YUV411P19 = MAKE_VIDEO_ID(YUV, INTEGER, 19, 2, 0)
    YUV411P20 = MAKE_VIDEO_ID(YUV, INTEGER, 20, 2, 0)
    YUV411P21 = MAKE_VIDEO_ID(YUV, INTEGER, 21, 2, 0)
    YUV411P22 = MAKE_VIDEO_ID(YUV, INTEGER, 22, 2, 0)
    YUV411P23 = MAKE_VIDEO_ID(YUV, INTEGER, 23, 2, 0)
    YUV411P24 = MAKE_VIDEO_ID(YUV, INTEGER, 24, 2, 0)
    YUV411P25 = MAKE_VIDEO_ID(YUV, INTEGER, 25, 2, 0)
    YUV411P26 = MAKE_VIDEO_ID(YUV, INTEGER, 26, 2, 0)
    YUV411P27 = MAKE_VIDEO_ID(YUV, INTEGER, 27, 2, 0)
    YUV411P28 = MAKE_VIDEO_ID(YUV, INTEGER, 28, 2, 0)
    YUV411P29 = MAKE_VIDEO_ID(YUV, INTEGER, 29, 2, 0)
    YUV411P30 = MAKE_VIDEO_ID(YUV, INTEGER, 30, 2, 0)
    YUV411P31 = MAKE_VIDEO_ID(YUV, INTEGER, 31, 2, 0)
    YUV411P32 = MAKE_VIDEO_ID(YUV, INTEGER, 32, 2, 0)

    YUV411PH = MAKE_VIDEO_ID(YUV, FLOAT, 16, 2, 0)
    YUV411PS = MAKE_VIDEO_ID(YUV, FLOAT, 32, 2, 0)

    ################################################

    YUV440P8 = MAKE_VIDEO_ID(YUV, INTEGER, 8, 0, 1)  # type: ignore[misc,assignment]
    YUV440P9 = MAKE_VIDEO_ID(YUV, INTEGER, 9, 0, 1)
    YUV440P10 = MAKE_VIDEO_ID(YUV, INTEGER, 10, 0, 1)
    YUV440P11 = MAKE_VIDEO_ID(YUV, INTEGER, 11, 0, 1)
    YUV440P12 = MAKE_VIDEO_ID(YUV, INTEGER, 12, 0, 1)
    YUV440P13 = MAKE_VIDEO_ID(YUV, INTEGER, 13, 0, 1)
    YUV440P14 = MAKE_VIDEO_ID(YUV, INTEGER, 14, 0, 1)
    YUV440P15 = MAKE_VIDEO_ID(YUV, INTEGER, 15, 0, 1)
    YUV440P16 = MAKE_VIDEO_ID(YUV, INTEGER, 16, 0, 1)
    YUV440P17 = MAKE_VIDEO_ID(YUV, INTEGER, 17, 0, 1)
    YUV440P18 = MAKE_VIDEO_ID(YUV, INTEGER, 18, 0, 1)
    YUV440P19 = MAKE_VIDEO_ID(YUV, INTEGER, 19, 0, 1)
    YUV440P20 = MAKE_VIDEO_ID(YUV, INTEGER, 20, 0, 1)
    YUV440P21 = MAKE_VIDEO_ID(YUV, INTEGER, 21, 0, 1)
    YUV440P22 = MAKE_VIDEO_ID(YUV, INTEGER, 22, 0, 1)
    YUV440P23 = MAKE_VIDEO_ID(YUV, INTEGER, 23, 0, 1)
    YUV440P24 = MAKE_VIDEO_ID(YUV, INTEGER, 24, 0, 1)
    YUV440P25 = MAKE_VIDEO_ID(YUV, INTEGER, 25, 0, 1)
    YUV440P26 = MAKE_VIDEO_ID(YUV, INTEGER, 26, 0, 1)
    YUV440P27 = MAKE_VIDEO_ID(YUV, INTEGER, 27, 0, 1)
    YUV440P28 = MAKE_VIDEO_ID(YUV, INTEGER, 28, 0, 1)
    YUV440P29 = MAKE_VIDEO_ID(YUV, INTEGER, 29, 0, 1)
    YUV440P30 = MAKE_VIDEO_ID(YUV, INTEGER, 30, 0, 1)
    YUV440P31 = MAKE_VIDEO_ID(YUV, INTEGER, 31, 0, 1)
    YUV440P32 = MAKE_VIDEO_ID(YUV, INTEGER, 32, 0, 1)

    YUV440PH = MAKE_VIDEO_ID(YUV, FLOAT, 16, 0, 1)
    YUV440PS = MAKE_VIDEO_ID(YUV, FLOAT, 32, 0, 1)

    ################################################

    YUV410P8 = MAKE_VIDEO_ID(YUV, INTEGER, 8, 2, 2)  # type: ignore[misc,assignment]
    YUV410P9 = MAKE_VIDEO_ID(YUV, INTEGER, 9, 2, 2)
    YUV410P10 = MAKE_VIDEO_ID(YUV, INTEGER, 10, 2, 2)
    YUV410P11 = MAKE_VIDEO_ID(YUV, INTEGER, 11, 2, 2)
    YUV410P12 = MAKE_VIDEO_ID(YUV, INTEGER, 12, 2, 2)
    YUV410P13 = MAKE_VIDEO_ID(YUV, INTEGER, 13, 2, 2)
    YUV410P14 = MAKE_VIDEO_ID(YUV, INTEGER, 14, 2, 2)
    YUV410P15 = MAKE_VIDEO_ID(YUV, INTEGER, 15, 2, 2)
    YUV410P16 = MAKE_VIDEO_ID(YUV, INTEGER, 16, 2, 2)
    YUV410P17 = MAKE_VIDEO_ID(YUV, INTEGER, 17, 2, 2)
    YUV410P18 = MAKE_VIDEO_ID(YUV, INTEGER, 18, 2, 2)
    YUV410P19 = MAKE_VIDEO_ID(YUV, INTEGER, 19, 2, 2)
    YUV410P20 = MAKE_VIDEO_ID(YUV, INTEGER, 20, 2, 2)
    YUV410P21 = MAKE_VIDEO_ID(YUV, INTEGER, 21, 2, 2)
    YUV410P22 = MAKE_VIDEO_ID(YUV, INTEGER, 22, 2, 2)
    YUV410P23 = MAKE_VIDEO_ID(YUV, INTEGER, 23, 2, 2)
    YUV410P24 = MAKE_VIDEO_ID(YUV, INTEGER, 24, 2, 2)
    YUV410P25 = MAKE_VIDEO_ID(YUV, INTEGER, 25, 2, 2)
    YUV410P26 = MAKE_VIDEO_ID(YUV, INTEGER, 26, 2, 2)
    YUV410P27 = MAKE_VIDEO_ID(YUV, INTEGER, 27, 2, 2)
    YUV410P28 = MAKE_VIDEO_ID(YUV, INTEGER, 28, 2, 2)
    YUV410P29 = MAKE_VIDEO_ID(YUV, INTEGER, 29, 2, 2)
    YUV410P30 = MAKE_VIDEO_ID(YUV, INTEGER, 30, 2, 2)
    YUV410P31 = MAKE_VIDEO_ID(YUV, INTEGER, 31, 2, 2)
    YUV410P32 = MAKE_VIDEO_ID(YUV, INTEGER, 32, 2, 2)

    YUV410PH = MAKE_VIDEO_ID(YUV, FLOAT, 16, 2, 2)
    YUV410PS = MAKE_VIDEO_ID(YUV, FLOAT, 32, 2, 2)

    ################################################

    RGB24 = MAKE_VIDEO_ID(RGB, INTEGER, 24, 0, 0)  # type: ignore[misc,assignment]
    RGB27 = MAKE_VIDEO_ID(RGB, INTEGER, 27, 0, 0)  # type: ignore[misc,assignment]
    RGB30 = MAKE_VIDEO_ID(RGB, INTEGER, 30, 0, 0)  # type: ignore[misc,assignment]
    RGB33 = MAKE_VIDEO_ID(RGB, INTEGER, 33, 0, 0)
    RGB36 = MAKE_VIDEO_ID(RGB, INTEGER, 36, 0, 0)  # type: ignore[misc,assignment]
    RGB39 = MAKE_VIDEO_ID(RGB, INTEGER, 39, 0, 0)
    RGB42 = MAKE_VIDEO_ID(RGB, INTEGER, 42, 0, 0)  # type: ignore[misc,assignment]
    RGB45 = MAKE_VIDEO_ID(RGB, INTEGER, 45, 0, 0)
    RGB48 = MAKE_VIDEO_ID(RGB, INTEGER, 48, 0, 0)  # type: ignore[misc,assignment]
    RGB51 = MAKE_VIDEO_ID(RGB, INTEGER, 51, 0, 0)
    RGB54 = MAKE_VIDEO_ID(RGB, INTEGER, 54, 0, 0)
    RGB57 = MAKE_VIDEO_ID(RGB, INTEGER, 57, 0, 0)
    RGB60 = MAKE_VIDEO_ID(RGB, INTEGER, 60, 0, 0)
    RGB63 = MAKE_VIDEO_ID(RGB, INTEGER, 63, 0, 0)
    RGB66 = MAKE_VIDEO_ID(RGB, INTEGER, 66, 0, 0)
    RGB69 = MAKE_VIDEO_ID(RGB, INTEGER, 69, 0, 0)
    RGB72 = MAKE_VIDEO_ID(RGB, INTEGER, 72, 0, 0)
    RGB75 = MAKE_VIDEO_ID(RGB, INTEGER, 75, 0, 0)
    RGB78 = MAKE_VIDEO_ID(RGB, INTEGER, 78, 0, 0)
    RGB81 = MAKE_VIDEO_ID(RGB, INTEGER, 81, 0, 0)
    RGB84 = MAKE_VIDEO_ID(RGB, INTEGER, 84, 0, 0)
    RGB87 = MAKE_VIDEO_ID(RGB, INTEGER, 87, 0, 0)
    RGB90 = MAKE_VIDEO_ID(RGB, INTEGER, 90, 0, 0)
    RGB93 = MAKE_VIDEO_ID(RGB, INTEGER, 93, 0, 0)
    RGB96 = MAKE_VIDEO_ID(RGB, INTEGER, 96, 0, 0)

    RGBH = MAKE_VIDEO_ID(RGB, FLOAT, 16, 0, 0)  # type: ignore[misc,assignment]
    RGBS = MAKE_VIDEO_ID(RGB, FLOAT, 32, 0, 0)  # type: ignore[misc,assignment]


GRAY8 = PresetFormat.GRAY8
GRAY9 = PresetFormat.GRAY9
GRAY10 = PresetFormat.GRAY10
GRAY11 = PresetFormat.GRAY11
GRAY12 = PresetFormat.GRAY12
GRAY13 = PresetFormat.GRAY13
GRAY14 = PresetFormat.GRAY14
GRAY15 = PresetFormat.GRAY15
GRAY16 = PresetFormat.GRAY16
GRAY17 = PresetFormat.GRAY17
GRAY18 = PresetFormat.GRAY18
GRAY19 = PresetFormat.GRAY19
GRAY20 = PresetFormat.GRAY20
GRAY21 = PresetFormat.GRAY21
GRAY22 = PresetFormat.GRAY22
GRAY23 = PresetFormat.GRAY23
GRAY24 = PresetFormat.GRAY24
GRAY25 = PresetFormat.GRAY25
GRAY26 = PresetFormat.GRAY26
GRAY27 = PresetFormat.GRAY27
GRAY28 = PresetFormat.GRAY28
GRAY29 = PresetFormat.GRAY29
GRAY30 = PresetFormat.GRAY30
GRAY31 = PresetFormat.GRAY31
GRAY32 = PresetFormat.GRAY32
GRAYH = PresetFormat.GRAYH
GRAYS = PresetFormat.GRAYS
YUV420P8 = PresetFormat.YUV420P8
YUV420P9 = PresetFormat.YUV420P9
YUV420P10 = PresetFormat.YUV420P10
YUV420P11 = PresetFormat.YUV420P11
YUV420P12 = PresetFormat.YUV420P12
YUV420P13 = PresetFormat.YUV420P13
YUV420P15 = PresetFormat.YUV420P15
YUV420P16 = PresetFormat.YUV420P16
YUV420P17 = PresetFormat.YUV420P17
YUV420P18 = PresetFormat.YUV420P18
YUV420P19 = PresetFormat.YUV420P19
YUV420P20 = PresetFormat.YUV420P20
YUV420P21 = PresetFormat.YUV420P21
YUV420P22 = PresetFormat.YUV420P22
YUV420P23 = PresetFormat.YUV420P23
YUV420P24 = PresetFormat.YUV420P24
YUV420P25 = PresetFormat.YUV420P25
YUV420P26 = PresetFormat.YUV420P26
YUV420P27 = PresetFormat.YUV420P27
YUV420P28 = PresetFormat.YUV420P28
YUV420P29 = PresetFormat.YUV420P29
YUV420P30 = PresetFormat.YUV420P30
YUV420P31 = PresetFormat.YUV420P31
YUV420P32 = PresetFormat.YUV420P32
YUV420PH = PresetFormat.YUV420PH
YUV420PS = PresetFormat.YUV420PS
YUV444P8 = PresetFormat.YUV444P8
YUV444P9 = PresetFormat.YUV444P9
YUV444P10 = PresetFormat.YUV444P10
YUV444P11 = PresetFormat.YUV444P11
YUV444P12 = PresetFormat.YUV444P12
YUV444P13 = PresetFormat.YUV444P13
YUV444P14 = PresetFormat.YUV444P14
YUV444P15 = PresetFormat.YUV444P15
YUV444P16 = PresetFormat.YUV444P16
YUV444P17 = PresetFormat.YUV444P17
YUV444P18 = PresetFormat.YUV444P18
YUV444P19 = PresetFormat.YUV444P19
YUV444P20 = PresetFormat.YUV444P20
YUV444P21 = PresetFormat.YUV444P21
YUV444P22 = PresetFormat.YUV444P22
YUV444P23 = PresetFormat.YUV444P23
YUV444P24 = PresetFormat.YUV444P24
YUV444P25 = PresetFormat.YUV444P25
YUV444P26 = PresetFormat.YUV444P26
YUV444P27 = PresetFormat.YUV444P27
YUV444P28 = PresetFormat.YUV444P28
YUV444P29 = PresetFormat.YUV444P29
YUV444P30 = PresetFormat.YUV444P30
YUV444P31 = PresetFormat.YUV444P31
YUV444P32 = PresetFormat.YUV444P32
YUV444PH = PresetFormat.YUV444PH
YUV444PS = PresetFormat.YUV444PS
YUV422P8 = PresetFormat.YUV422P8
YUV422P9 = PresetFormat.YUV422P9
YUV422P10 = PresetFormat.YUV422P10
YUV422P11 = PresetFormat.YUV422P11
YUV422P12 = PresetFormat.YUV422P12
YUV422P13 = PresetFormat.YUV422P13
YUV422P14 = PresetFormat.YUV422P14
YUV422P15 = PresetFormat.YUV422P15
YUV422P16 = PresetFormat.YUV422P16
YUV422P17 = PresetFormat.YUV422P17
YUV422P18 = PresetFormat.YUV422P18
YUV422P19 = PresetFormat.YUV422P19
YUV422P20 = PresetFormat.YUV422P20
YUV422P21 = PresetFormat.YUV422P21
YUV422P22 = PresetFormat.YUV422P22
YUV422P23 = PresetFormat.YUV422P23
YUV422P24 = PresetFormat.YUV422P24
YUV422P25 = PresetFormat.YUV422P25
YUV422P26 = PresetFormat.YUV422P26
YUV422P27 = PresetFormat.YUV422P27
YUV422P28 = PresetFormat.YUV422P28
YUV422P29 = PresetFormat.YUV422P29
YUV422P30 = PresetFormat.YUV422P30
YUV422P31 = PresetFormat.YUV422P31
YUV422P32 = PresetFormat.YUV422P32
YUV422PH = PresetFormat.YUV422PH
YUV422PS = PresetFormat.YUV422PS
YUV411P8 = PresetFormat.YUV411P8
YUV411P9 = PresetFormat.YUV411P9
YUV411P10 = PresetFormat.YUV411P10
YUV411P11 = PresetFormat.YUV411P11
YUV411P12 = PresetFormat.YUV411P12
YUV411P13 = PresetFormat.YUV411P13
YUV411P14 = PresetFormat.YUV411P14
YUV411P15 = PresetFormat.YUV411P15
YUV411P16 = PresetFormat.YUV411P16
YUV411P17 = PresetFormat.YUV411P17
YUV411P18 = PresetFormat.YUV411P18
YUV411P19 = PresetFormat.YUV411P19
YUV411P20 = PresetFormat.YUV411P20
YUV411P21 = PresetFormat.YUV411P21
YUV411P22 = PresetFormat.YUV411P22
YUV411P23 = PresetFormat.YUV411P23
YUV411P24 = PresetFormat.YUV411P24
YUV411P25 = PresetFormat.YUV411P25
YUV411P26 = PresetFormat.YUV411P26
YUV411P27 = PresetFormat.YUV411P27
YUV411P28 = PresetFormat.YUV411P28
YUV411P29 = PresetFormat.YUV411P29
YUV411P30 = PresetFormat.YUV411P30
YUV411P31 = PresetFormat.YUV411P31
YUV411P32 = PresetFormat.YUV411P32
YUV411PH = PresetFormat.YUV411PH
YUV411PS = PresetFormat.YUV411PS
YUV440P8 = PresetFormat.YUV440P8
YUV440P9 = PresetFormat.YUV440P9
YUV440P10 = PresetFormat.YUV440P10
YUV440P11 = PresetFormat.YUV440P11
YUV440P12 = PresetFormat.YUV440P12
YUV440P13 = PresetFormat.YUV440P13
YUV440P14 = PresetFormat.YUV440P14
YUV440P15 = PresetFormat.YUV440P15
YUV440P16 = PresetFormat.YUV440P16
YUV440P17 = PresetFormat.YUV440P17
YUV440P18 = PresetFormat.YUV440P18
YUV440P19 = PresetFormat.YUV440P19
YUV440P20 = PresetFormat.YUV440P20
YUV440P21 = PresetFormat.YUV440P21
YUV440P22 = PresetFormat.YUV440P22
YUV440P23 = PresetFormat.YUV440P23
YUV440P24 = PresetFormat.YUV440P24
YUV440P25 = PresetFormat.YUV440P25
YUV440P26 = PresetFormat.YUV440P26
YUV440P27 = PresetFormat.YUV440P27
YUV440P28 = PresetFormat.YUV440P28
YUV440P29 = PresetFormat.YUV440P29
YUV440P30 = PresetFormat.YUV440P30
YUV440P31 = PresetFormat.YUV440P31
YUV440P32 = PresetFormat.YUV440P32
YUV440PH = PresetFormat.YUV440PH
YUV440PS = PresetFormat.YUV440PS
YUV410P8 = PresetFormat.YUV410P8
YUV410P9 = PresetFormat.YUV410P9
YUV410P10 = PresetFormat.YUV410P10
YUV410P11 = PresetFormat.YUV410P11
YUV410P12 = PresetFormat.YUV410P12
YUV410P13 = PresetFormat.YUV410P13
YUV410P14 = PresetFormat.YUV410P14
YUV410P15 = PresetFormat.YUV410P15
YUV410P16 = PresetFormat.YUV410P16
YUV410P17 = PresetFormat.YUV410P17
YUV410P18 = PresetFormat.YUV410P18
YUV410P19 = PresetFormat.YUV410P19
YUV410P20 = PresetFormat.YUV410P20
YUV410P21 = PresetFormat.YUV410P21
YUV410P22 = PresetFormat.YUV410P22
YUV410P23 = PresetFormat.YUV410P23
YUV410P24 = PresetFormat.YUV410P24
YUV410P25 = PresetFormat.YUV410P25
YUV410P26 = PresetFormat.YUV410P26
YUV410P27 = PresetFormat.YUV410P27
YUV410P28 = PresetFormat.YUV410P28
YUV410P29 = PresetFormat.YUV410P29
YUV410P30 = PresetFormat.YUV410P30
YUV410P31 = PresetFormat.YUV410P31
YUV410P32 = PresetFormat.YUV410P32
YUV410PH = PresetFormat.YUV410PH
YUV410PS = PresetFormat.YUV410PS
RGB24 = PresetFormat.RGB24
RGB27 = PresetFormat.RGB27
RGB30 = PresetFormat.RGB30
RGB33 = PresetFormat.RGB33
RGB36 = PresetFormat.RGB36
RGB39 = PresetFormat.RGB39
RGB42 = PresetFormat.RGB42
RGB45 = PresetFormat.RGB45
RGB48 = PresetFormat.RGB48
RGB51 = PresetFormat.RGB51
RGB54 = PresetFormat.RGB54
RGB57 = PresetFormat.RGB57
RGB60 = PresetFormat.RGB60
RGB63 = PresetFormat.RGB63
RGB66 = PresetFormat.RGB66
RGB69 = PresetFormat.RGB69
RGB72 = PresetFormat.RGB72
RGB75 = PresetFormat.RGB75
RGB78 = PresetFormat.RGB78
RGB81 = PresetFormat.RGB81
RGB84 = PresetFormat.RGB84
RGB87 = PresetFormat.RGB87
RGB90 = PresetFormat.RGB90
RGB93 = PresetFormat.RGB93
RGB96 = PresetFormat.RGB96
RGBH = PresetFormat.RGBH
RGBS = PresetFormat.RGBS
