import os
from typing import Literal

from exceptions import MissingEnvVariable


EnvName = Literal["dev", "staging", "prod"]

def get_env_name() -> EnvName:
    env = os.getenv("ENV")
    
    if env is None:
        raise MissingEnvVariable("Could not get 'ENV' env variable, therefore can't deduce logging_level.")
    elif env in ["dev","staging", "prod"]:
        return env
    else:
        raise ValueError(
            f"'ENV' is set to: {env}. This is not a supported env! Please choose between: [dev, staging, prod]"
        )