#ifndef GUARD_b8239bf849ec7c1903f627833e6dac5a
#define GUARD_b8239bf849ec7c1903f627833e6dac5a

#define USING_DUNE_PYTHON 1
#include <config.h>
#include <dune/alugrid/dgf.hh>
#include <dune/alugrid/grid.hh>
#include <dune/fem/gridpart/adaptiveleafgridpart.hh>
#include <dune/fem/gridpart/filter/simple.hh>
#include <dune/fem/gridpart/filteredgridpart.hh>
#include <dune/fempy/py/gridview.hh>
#include <dune/python/grid/gridview.hh>
#include <dune/python/grid/hierarchical.hh>
#include <dune/fem/function/localfunction/bindable.hh>
#include <dune/fem/common/intersectionside.hh>
#include <dune/python/pybind11/pybind11.h>
#include <dune/python/pybind11/extensions.h>
#include <dune/fempy/py/grid/gridpart.hh>
#include <dune/common/exceptions.hh>
#include <dune/fempy/py/ufllocalfunction.hh>

namespace UFLLocalFunctions_b8239bf849ec7c1903f627833e6dac5a
{

  // UFLLocalFunction
// ----------------

template< class GridPart >
struct UFLLocalFunction
  : public Dune::Fem::BindableGridFunctionWithSpace<GridPart,Dune::Dim<2>>
{
  typedef GridPart GridPartType;
  typedef typename GridPartType::GridViewType GridView;
  typedef typename GridView::ctype ctype;
  typedef Dune::Fem::BindableGridFunctionWithSpace<GridPart,Dune::Dim<2>> BaseType;
  typedef Dune::Fem::GridFunctionSpace<GridPartType,Dune::Dim<2>> FunctionSpaceType;
  typedef typename GridPartType::template Codim< 0 >::EntityType EntityType;
  typedef typename GridPartType::IntersectionType IntersectionType;
  typedef typename EntityType::Geometry Geometry;
  typedef typename Geometry::GlobalCoordinate GlobalCoordinateType;
  typedef Dune::Fem::IntersectionSide Side;
  typedef std::tuple<> ConstantTupleType;
  typedef std::tuple<> CoefficientTupleType;
  static constexpr bool gridPartValid = true;
  template< std::size_t i >
  using CoefficientType = std::tuple_element_t< i, CoefficientTupleType >;
  template< std::size_t i >
  using ConstantType = typename std::tuple_element_t< i, ConstantTupleType >::element_type;
  using BaseType::entity;
  using BaseType::geometry;

  UFLLocalFunction ( const GridPartType &gridPart, const std::string &name, int order, const Dune::Fem::ParameterReader &parameter = Dune::Fem::Parameter::container() )
    : BaseType(gridPart,name,order)
  {}

  void bind ( const IntersectionType &intersection, Side side )
  {
    BaseType::bind(intersection, side);
  }

  void bind ( const EntityType &entity )
  {
    BaseType::bind(entity);
  }

  void unbind ()
  {
    BaseType::unbind();
  }

  template< class Point >
  void evaluate ( const Point &x, typename FunctionSpaceType::RangeType &result ) const
  {
    using std::max;
    using std::min;
    using std::sqrt;
    GlobalCoordinateType tmp0 = geometry().global( Dune::Fem::coordinate( x ) );
    const auto tmp1 = tmp0[ 1 ] * tmp0[ 1 ];
    const auto tmp2 = tmp0[ 0 ] * tmp0[ 0 ];
    const auto tmp3 = tmp2 + tmp1;
    const auto tmp4 = 1e-10 + tmp3;
    const auto tmp5 = std::sqrt( tmp4 );
    const auto tmp6 = -1.4 + tmp5;
    const auto tmp7 = 1 + tmp0[ 0 ];
    const auto tmp8 = tmp7 * tmp7;
    const auto tmp9 = tmp1 + tmp8;
    const auto tmp10 = 1e-10 + tmp9;
    const auto tmp11 = std::sqrt( tmp10 );
    const auto tmp12 = -0.5 + tmp11;
    const auto tmp13 = -1 + tmp0[ 0 ];
    const auto tmp14 = tmp13 * tmp13;
    const auto tmp15 = tmp1 + tmp14;
    const auto tmp16 = 1e-10 + tmp15;
    const auto tmp17 = std::sqrt( tmp16 );
    const auto tmp18 = -0.5 + tmp17;
    const auto tmp19 = 0.8 + tmp0[ 1 ];
    const auto tmp20 = tmp19 * tmp19;
    const auto tmp21 = tmp2 + tmp20;
    const auto tmp22 = 1e-10 + tmp21;
    const auto tmp23 = std::sqrt( tmp22 );
    const auto tmp24 = -0.5 + tmp23;
    const auto tmp25 = -1 * tmp24;
    const auto tmp26 = -0.8 + tmp0[ 1 ];
    const auto tmp27 = tmp26 * tmp26;
    const auto tmp28 = tmp2 + tmp27;
    const auto tmp29 = 1e-10 + tmp28;
    const auto tmp30 = std::sqrt( tmp29 );
    const auto tmp31 = -0.5 + tmp30;
    const auto tmp32 = -1 * tmp31;
    const auto tmp33 = -1 + tmp5;
    const auto tmp34 = std::max( tmp33, tmp32 );
    const auto tmp35 = std::max( tmp34, tmp25 );
    const auto tmp36 = std::min( tmp35, tmp18 );
    const auto tmp37 = std::min( tmp36, tmp12 );
    const auto tmp38 = std::max( tmp37, tmp6 );
    const auto tmp39 = 2 * tmp5;
    const auto tmp40 = tmp0[ 0 ] + tmp0[ 0 ];
    const auto tmp41 = tmp40 / tmp39;
    const auto tmp42 = tmp41 * (tmp33 > tmp32 ? 1 : 0.0);
    const auto tmp43 = 2 * tmp30;
    const auto tmp44 = tmp40 / tmp43;
    const auto tmp45 = -1 * tmp44;
    const auto tmp46 = -1 * (tmp33 > tmp32 ? 1 : 0.0);
    const auto tmp47 = 1.0 + tmp46;
    const auto tmp48 = tmp47 * tmp45;
    const auto tmp49 = tmp48 + tmp42;
    const auto tmp50 = tmp49 * (tmp34 > tmp25 ? 1 : 0.0);
    const auto tmp51 = 2 * tmp23;
    const auto tmp52 = tmp40 / tmp51;
    const auto tmp53 = -1 * tmp52;
    const auto tmp54 = -1 * (tmp34 > tmp25 ? 1 : 0.0);
    const auto tmp55 = 1.0 + tmp54;
    const auto tmp56 = tmp55 * tmp53;
    const auto tmp57 = tmp56 + tmp50;
    const auto tmp58 = tmp57 * (tmp35 < tmp18 ? 1 : 0.0);
    const auto tmp59 = 2 * tmp17;
    const auto tmp60 = tmp13 + tmp13;
    const auto tmp61 = tmp60 / tmp59;
    const auto tmp62 = -1 * (tmp35 < tmp18 ? 1 : 0.0);
    const auto tmp63 = 1.0 + tmp62;
    const auto tmp64 = tmp63 * tmp61;
    const auto tmp65 = tmp64 + tmp58;
    const auto tmp66 = tmp65 * (tmp36 < tmp12 ? 1 : 0.0);
    const auto tmp67 = 2 * tmp11;
    const auto tmp68 = tmp7 + tmp7;
    const auto tmp69 = tmp68 / tmp67;
    const auto tmp70 = -1 * (tmp36 < tmp12 ? 1 : 0.0);
    const auto tmp71 = 1.0 + tmp70;
    const auto tmp72 = tmp71 * tmp69;
    const auto tmp73 = tmp72 + tmp66;
    const auto tmp74 = tmp73 * (tmp37 > tmp6 ? 1 : 0.0);
    const auto tmp75 = -1 * (tmp37 > tmp6 ? 1 : 0.0);
    const auto tmp76 = 1.0 + tmp75;
    const auto tmp77 = tmp76 * tmp41;
    const auto tmp78 = tmp77 + tmp74;
    const auto tmp79 = -1 * tmp78;
    const auto tmp80 = tmp79 * tmp38;
    const auto tmp81 = tmp0[ 0 ] + tmp80;
    const auto tmp82 = tmp0[ 1 ] + tmp0[ 1 ];
    const auto tmp83 = tmp82 / tmp39;
    const auto tmp84 = tmp83 * (tmp33 > tmp32 ? 1 : 0.0);
    const auto tmp85 = tmp26 + tmp26;
    const auto tmp86 = tmp85 / tmp43;
    const auto tmp87 = -1 * tmp86;
    const auto tmp88 = tmp47 * tmp87;
    const auto tmp89 = tmp88 + tmp84;
    const auto tmp90 = tmp89 * (tmp34 > tmp25 ? 1 : 0.0);
    const auto tmp91 = tmp19 + tmp19;
    const auto tmp92 = tmp91 / tmp51;
    const auto tmp93 = -1 * tmp92;
    const auto tmp94 = tmp55 * tmp93;
    const auto tmp95 = tmp94 + tmp90;
    const auto tmp96 = tmp95 * (tmp35 < tmp18 ? 1 : 0.0);
    const auto tmp97 = tmp82 / tmp59;
    const auto tmp98 = tmp63 * tmp97;
    const auto tmp99 = tmp98 + tmp96;
    const auto tmp100 = tmp99 * (tmp36 < tmp12 ? 1 : 0.0);
    const auto tmp101 = tmp82 / tmp67;
    const auto tmp102 = tmp71 * tmp101;
    const auto tmp103 = tmp102 + tmp100;
    const auto tmp104 = tmp103 * (tmp37 > tmp6 ? 1 : 0.0);
    const auto tmp105 = tmp76 * tmp83;
    const auto tmp106 = tmp105 + tmp104;
    const auto tmp107 = -1 * tmp106;
    const auto tmp108 = tmp107 * tmp38;
    const auto tmp109 = tmp0[ 1 ] + tmp108;
    result[ 0 ] = tmp81;
    result[ 1 ] = tmp109;
  }

  template< class Point >
  void jacobian ( const Point &x, typename FunctionSpaceType::JacobianRangeType &result ) const
  {
    using std::max;
    using std::min;
    using std::sqrt;
    GlobalCoordinateType tmp0 = geometry().global( Dune::Fem::coordinate( x ) );
    const auto tmp1 = tmp0[ 1 ] * tmp0[ 1 ];
    const auto tmp2 = tmp0[ 0 ] * tmp0[ 0 ];
    const auto tmp3 = tmp2 + tmp1;
    const auto tmp4 = 1e-10 + tmp3;
    const auto tmp5 = std::sqrt( tmp4 );
    const auto tmp6 = -1.4 + tmp5;
    const auto tmp7 = 1 + tmp0[ 0 ];
    const auto tmp8 = tmp7 * tmp7;
    const auto tmp9 = tmp1 + tmp8;
    const auto tmp10 = 1e-10 + tmp9;
    const auto tmp11 = std::sqrt( tmp10 );
    const auto tmp12 = -0.5 + tmp11;
    const auto tmp13 = -1 + tmp0[ 0 ];
    const auto tmp14 = tmp13 * tmp13;
    const auto tmp15 = tmp1 + tmp14;
    const auto tmp16 = 1e-10 + tmp15;
    const auto tmp17 = std::sqrt( tmp16 );
    const auto tmp18 = -0.5 + tmp17;
    const auto tmp19 = 0.8 + tmp0[ 1 ];
    const auto tmp20 = tmp19 * tmp19;
    const auto tmp21 = tmp2 + tmp20;
    const auto tmp22 = 1e-10 + tmp21;
    const auto tmp23 = std::sqrt( tmp22 );
    const auto tmp24 = -0.5 + tmp23;
    const auto tmp25 = -1 * tmp24;
    const auto tmp26 = -0.8 + tmp0[ 1 ];
    const auto tmp27 = tmp26 * tmp26;
    const auto tmp28 = tmp2 + tmp27;
    const auto tmp29 = 1e-10 + tmp28;
    const auto tmp30 = std::sqrt( tmp29 );
    const auto tmp31 = -0.5 + tmp30;
    const auto tmp32 = -1 * tmp31;
    const auto tmp33 = -1 + tmp5;
    const auto tmp34 = std::max( tmp33, tmp32 );
    const auto tmp35 = std::max( tmp34, tmp25 );
    const auto tmp36 = std::min( tmp35, tmp18 );
    const auto tmp37 = std::min( tmp36, tmp12 );
    const auto tmp38 = std::max( tmp37, tmp6 );
    const auto tmp39 = 2 * tmp5;
    const auto tmp40 = tmp0[ 0 ] + tmp0[ 0 ];
    const auto tmp41 = tmp40 / tmp39;
    const auto tmp42 = 2 * tmp41;
    const auto tmp43 = tmp42 * tmp41;
    const auto tmp44 = -1 * tmp43;
    const auto tmp45 = 2 + tmp44;
    const auto tmp46 = tmp45 / tmp39;
    const auto tmp47 = tmp46 * (tmp33 > tmp32 ? 1 : 0.0);
    const auto tmp48 = 2 * tmp30;
    const auto tmp49 = tmp40 / tmp48;
    const auto tmp50 = 2 * tmp49;
    const auto tmp51 = tmp50 * tmp49;
    const auto tmp52 = -1 * tmp51;
    const auto tmp53 = 2 + tmp52;
    const auto tmp54 = tmp53 / tmp48;
    const auto tmp55 = -1 * tmp54;
    const auto tmp56 = -1 * (tmp33 > tmp32 ? 1 : 0.0);
    const auto tmp57 = 1.0 + tmp56;
    const auto tmp58 = tmp57 * tmp55;
    const auto tmp59 = tmp58 + tmp47;
    const auto tmp60 = tmp59 * (tmp34 > tmp25 ? 1 : 0.0);
    const auto tmp61 = 2 * tmp23;
    const auto tmp62 = tmp40 / tmp61;
    const auto tmp63 = 2 * tmp62;
    const auto tmp64 = tmp63 * tmp62;
    const auto tmp65 = -1 * tmp64;
    const auto tmp66 = 2 + tmp65;
    const auto tmp67 = tmp66 / tmp61;
    const auto tmp68 = -1 * tmp67;
    const auto tmp69 = -1 * (tmp34 > tmp25 ? 1 : 0.0);
    const auto tmp70 = 1.0 + tmp69;
    const auto tmp71 = tmp70 * tmp68;
    const auto tmp72 = tmp71 + tmp60;
    const auto tmp73 = tmp72 * (tmp35 < tmp18 ? 1 : 0.0);
    const auto tmp74 = 2 * tmp17;
    const auto tmp75 = tmp13 + tmp13;
    const auto tmp76 = tmp75 / tmp74;
    const auto tmp77 = 2 * tmp76;
    const auto tmp78 = tmp77 * tmp76;
    const auto tmp79 = -1 * tmp78;
    const auto tmp80 = 2 + tmp79;
    const auto tmp81 = tmp80 / tmp74;
    const auto tmp82 = -1 * (tmp35 < tmp18 ? 1 : 0.0);
    const auto tmp83 = 1.0 + tmp82;
    const auto tmp84 = tmp83 * tmp81;
    const auto tmp85 = tmp84 + tmp73;
    const auto tmp86 = tmp85 * (tmp36 < tmp12 ? 1 : 0.0);
    const auto tmp87 = 2 * tmp11;
    const auto tmp88 = tmp7 + tmp7;
    const auto tmp89 = tmp88 / tmp87;
    const auto tmp90 = 2 * tmp89;
    const auto tmp91 = tmp90 * tmp89;
    const auto tmp92 = -1 * tmp91;
    const auto tmp93 = 2 + tmp92;
    const auto tmp94 = tmp93 / tmp87;
    const auto tmp95 = -1 * (tmp36 < tmp12 ? 1 : 0.0);
    const auto tmp96 = 1.0 + tmp95;
    const auto tmp97 = tmp96 * tmp94;
    const auto tmp98 = tmp97 + tmp86;
    const auto tmp99 = tmp98 * (tmp37 > tmp6 ? 1 : 0.0);
    const auto tmp100 = -1 * (tmp37 > tmp6 ? 1 : 0.0);
    const auto tmp101 = 1.0 + tmp100;
    const auto tmp102 = tmp101 * tmp46;
    const auto tmp103 = tmp102 + tmp99;
    const auto tmp104 = -1 * tmp103;
    const auto tmp105 = tmp104 * tmp38;
    const auto tmp106 = tmp41 * (tmp33 > tmp32 ? 1 : 0.0);
    const auto tmp107 = -1 * tmp49;
    const auto tmp108 = tmp57 * tmp107;
    const auto tmp109 = tmp108 + tmp106;
    const auto tmp110 = tmp109 * (tmp34 > tmp25 ? 1 : 0.0);
    const auto tmp111 = -1 * tmp62;
    const auto tmp112 = tmp70 * tmp111;
    const auto tmp113 = tmp112 + tmp110;
    const auto tmp114 = tmp113 * (tmp35 < tmp18 ? 1 : 0.0);
    const auto tmp115 = tmp83 * tmp76;
    const auto tmp116 = tmp115 + tmp114;
    const auto tmp117 = tmp116 * (tmp36 < tmp12 ? 1 : 0.0);
    const auto tmp118 = tmp96 * tmp89;
    const auto tmp119 = tmp118 + tmp117;
    const auto tmp120 = tmp119 * (tmp37 > tmp6 ? 1 : 0.0);
    const auto tmp121 = tmp101 * tmp41;
    const auto tmp122 = tmp121 + tmp120;
    const auto tmp123 = -1 * tmp122;
    const auto tmp124 = tmp122 * tmp123;
    const auto tmp125 = tmp124 + tmp105;
    const auto tmp126 = 1 + tmp125;
    const auto tmp127 = tmp0[ 1 ] + tmp0[ 1 ];
    const auto tmp128 = tmp127 / tmp39;
    const auto tmp129 = 2 * tmp128;
    const auto tmp130 = tmp129 * tmp41;
    const auto tmp131 = -1 * tmp130;
    const auto tmp132 = tmp131 / tmp39;
    const auto tmp133 = tmp132 * (tmp33 > tmp32 ? 1 : 0.0);
    const auto tmp134 = tmp26 + tmp26;
    const auto tmp135 = tmp134 / tmp48;
    const auto tmp136 = 2 * tmp135;
    const auto tmp137 = tmp136 * tmp49;
    const auto tmp138 = -1 * tmp137;
    const auto tmp139 = tmp138 / tmp48;
    const auto tmp140 = -1 * tmp139;
    const auto tmp141 = tmp57 * tmp140;
    const auto tmp142 = tmp141 + tmp133;
    const auto tmp143 = tmp142 * (tmp34 > tmp25 ? 1 : 0.0);
    const auto tmp144 = tmp19 + tmp19;
    const auto tmp145 = tmp144 / tmp61;
    const auto tmp146 = 2 * tmp145;
    const auto tmp147 = tmp146 * tmp62;
    const auto tmp148 = -1 * tmp147;
    const auto tmp149 = tmp148 / tmp61;
    const auto tmp150 = -1 * tmp149;
    const auto tmp151 = tmp70 * tmp150;
    const auto tmp152 = tmp151 + tmp143;
    const auto tmp153 = tmp152 * (tmp35 < tmp18 ? 1 : 0.0);
    const auto tmp154 = tmp127 / tmp74;
    const auto tmp155 = 2 * tmp154;
    const auto tmp156 = tmp155 * tmp76;
    const auto tmp157 = -1 * tmp156;
    const auto tmp158 = tmp157 / tmp74;
    const auto tmp159 = tmp83 * tmp158;
    const auto tmp160 = tmp159 + tmp153;
    const auto tmp161 = tmp160 * (tmp36 < tmp12 ? 1 : 0.0);
    const auto tmp162 = tmp127 / tmp87;
    const auto tmp163 = 2 * tmp162;
    const auto tmp164 = tmp163 * tmp89;
    const auto tmp165 = -1 * tmp164;
    const auto tmp166 = tmp165 / tmp87;
    const auto tmp167 = tmp96 * tmp166;
    const auto tmp168 = tmp167 + tmp161;
    const auto tmp169 = tmp168 * (tmp37 > tmp6 ? 1 : 0.0);
    const auto tmp170 = tmp101 * tmp132;
    const auto tmp171 = tmp170 + tmp169;
    const auto tmp172 = -1 * tmp171;
    const auto tmp173 = tmp172 * tmp38;
    const auto tmp174 = tmp128 * (tmp33 > tmp32 ? 1 : 0.0);
    const auto tmp175 = -1 * tmp135;
    const auto tmp176 = tmp57 * tmp175;
    const auto tmp177 = tmp176 + tmp174;
    const auto tmp178 = tmp177 * (tmp34 > tmp25 ? 1 : 0.0);
    const auto tmp179 = -1 * tmp145;
    const auto tmp180 = tmp70 * tmp179;
    const auto tmp181 = tmp180 + tmp178;
    const auto tmp182 = tmp181 * (tmp35 < tmp18 ? 1 : 0.0);
    const auto tmp183 = tmp83 * tmp154;
    const auto tmp184 = tmp183 + tmp182;
    const auto tmp185 = tmp184 * (tmp36 < tmp12 ? 1 : 0.0);
    const auto tmp186 = tmp96 * tmp162;
    const auto tmp187 = tmp186 + tmp185;
    const auto tmp188 = tmp187 * (tmp37 > tmp6 ? 1 : 0.0);
    const auto tmp189 = tmp101 * tmp128;
    const auto tmp190 = tmp189 + tmp188;
    const auto tmp191 = tmp190 * tmp123;
    const auto tmp192 = tmp191 + tmp173;
    const auto tmp193 = tmp42 * tmp128;
    const auto tmp194 = -1 * tmp193;
    const auto tmp195 = tmp194 / tmp39;
    const auto tmp196 = tmp195 * (tmp33 > tmp32 ? 1 : 0.0);
    const auto tmp197 = tmp50 * tmp135;
    const auto tmp198 = -1 * tmp197;
    const auto tmp199 = tmp198 / tmp48;
    const auto tmp200 = -1 * tmp199;
    const auto tmp201 = tmp57 * tmp200;
    const auto tmp202 = tmp201 + tmp196;
    const auto tmp203 = tmp202 * (tmp34 > tmp25 ? 1 : 0.0);
    const auto tmp204 = tmp63 * tmp145;
    const auto tmp205 = -1 * tmp204;
    const auto tmp206 = tmp205 / tmp61;
    const auto tmp207 = -1 * tmp206;
    const auto tmp208 = tmp70 * tmp207;
    const auto tmp209 = tmp208 + tmp203;
    const auto tmp210 = tmp209 * (tmp35 < tmp18 ? 1 : 0.0);
    const auto tmp211 = tmp77 * tmp154;
    const auto tmp212 = -1 * tmp211;
    const auto tmp213 = tmp212 / tmp74;
    const auto tmp214 = tmp83 * tmp213;
    const auto tmp215 = tmp214 + tmp210;
    const auto tmp216 = tmp215 * (tmp36 < tmp12 ? 1 : 0.0);
    const auto tmp217 = tmp90 * tmp162;
    const auto tmp218 = -1 * tmp217;
    const auto tmp219 = tmp218 / tmp87;
    const auto tmp220 = tmp96 * tmp219;
    const auto tmp221 = tmp220 + tmp216;
    const auto tmp222 = tmp221 * (tmp37 > tmp6 ? 1 : 0.0);
    const auto tmp223 = tmp101 * tmp195;
    const auto tmp224 = tmp223 + tmp222;
    const auto tmp225 = -1 * tmp224;
    const auto tmp226 = tmp225 * tmp38;
    const auto tmp227 = -1 * tmp190;
    const auto tmp228 = tmp122 * tmp227;
    const auto tmp229 = tmp228 + tmp226;
    const auto tmp230 = tmp129 * tmp128;
    const auto tmp231 = -1 * tmp230;
    const auto tmp232 = 2 + tmp231;
    const auto tmp233 = tmp232 / tmp39;
    const auto tmp234 = tmp233 * (tmp33 > tmp32 ? 1 : 0.0);
    const auto tmp235 = tmp136 * tmp135;
    const auto tmp236 = -1 * tmp235;
    const auto tmp237 = 2 + tmp236;
    const auto tmp238 = tmp237 / tmp48;
    const auto tmp239 = -1 * tmp238;
    const auto tmp240 = tmp57 * tmp239;
    const auto tmp241 = tmp240 + tmp234;
    const auto tmp242 = tmp241 * (tmp34 > tmp25 ? 1 : 0.0);
    const auto tmp243 = tmp146 * tmp145;
    const auto tmp244 = -1 * tmp243;
    const auto tmp245 = 2 + tmp244;
    const auto tmp246 = tmp245 / tmp61;
    const auto tmp247 = -1 * tmp246;
    const auto tmp248 = tmp70 * tmp247;
    const auto tmp249 = tmp248 + tmp242;
    const auto tmp250 = tmp249 * (tmp35 < tmp18 ? 1 : 0.0);
    const auto tmp251 = tmp155 * tmp154;
    const auto tmp252 = -1 * tmp251;
    const auto tmp253 = 2 + tmp252;
    const auto tmp254 = tmp253 / tmp74;
    const auto tmp255 = tmp83 * tmp254;
    const auto tmp256 = tmp255 + tmp250;
    const auto tmp257 = tmp256 * (tmp36 < tmp12 ? 1 : 0.0);
    const auto tmp258 = tmp163 * tmp162;
    const auto tmp259 = -1 * tmp258;
    const auto tmp260 = 2 + tmp259;
    const auto tmp261 = tmp260 / tmp87;
    const auto tmp262 = tmp96 * tmp261;
    const auto tmp263 = tmp262 + tmp257;
    const auto tmp264 = tmp263 * (tmp37 > tmp6 ? 1 : 0.0);
    const auto tmp265 = tmp101 * tmp233;
    const auto tmp266 = tmp265 + tmp264;
    const auto tmp267 = -1 * tmp266;
    const auto tmp268 = tmp267 * tmp38;
    const auto tmp269 = tmp190 * tmp227;
    const auto tmp270 = tmp269 + tmp268;
    const auto tmp271 = 1 + tmp270;
    (result[ 0 ])[ 0 ] = tmp126;
    (result[ 0 ])[ 1 ] = tmp192;
    (result[ 1 ])[ 0 ] = tmp229;
    (result[ 1 ])[ 1 ] = tmp271;
  }

  template< class Point >
  void hessian ( const Point &x, typename FunctionSpaceType::HessianRangeType &result ) const
  {
    using std::max;
    using std::min;
    using std::sqrt;
    GlobalCoordinateType tmp0 = geometry().global( Dune::Fem::coordinate( x ) );
    const auto tmp1 = tmp0[ 1 ] * tmp0[ 1 ];
    const auto tmp2 = tmp0[ 0 ] * tmp0[ 0 ];
    const auto tmp3 = tmp2 + tmp1;
    const auto tmp4 = 1e-10 + tmp3;
    const auto tmp5 = std::sqrt( tmp4 );
    const auto tmp6 = -1.4 + tmp5;
    const auto tmp7 = 1 + tmp0[ 0 ];
    const auto tmp8 = tmp7 * tmp7;
    const auto tmp9 = tmp1 + tmp8;
    const auto tmp10 = 1e-10 + tmp9;
    const auto tmp11 = std::sqrt( tmp10 );
    const auto tmp12 = -0.5 + tmp11;
    const auto tmp13 = -1 + tmp0[ 0 ];
    const auto tmp14 = tmp13 * tmp13;
    const auto tmp15 = tmp1 + tmp14;
    const auto tmp16 = 1e-10 + tmp15;
    const auto tmp17 = std::sqrt( tmp16 );
    const auto tmp18 = -0.5 + tmp17;
    const auto tmp19 = 0.8 + tmp0[ 1 ];
    const auto tmp20 = tmp19 * tmp19;
    const auto tmp21 = tmp2 + tmp20;
    const auto tmp22 = 1e-10 + tmp21;
    const auto tmp23 = std::sqrt( tmp22 );
    const auto tmp24 = -0.5 + tmp23;
    const auto tmp25 = -1 * tmp24;
    const auto tmp26 = -0.8 + tmp0[ 1 ];
    const auto tmp27 = tmp26 * tmp26;
    const auto tmp28 = tmp2 + tmp27;
    const auto tmp29 = 1e-10 + tmp28;
    const auto tmp30 = std::sqrt( tmp29 );
    const auto tmp31 = -0.5 + tmp30;
    const auto tmp32 = -1 * tmp31;
    const auto tmp33 = -1 + tmp5;
    const auto tmp34 = std::max( tmp33, tmp32 );
    const auto tmp35 = std::max( tmp34, tmp25 );
    const auto tmp36 = std::min( tmp35, tmp18 );
    const auto tmp37 = std::min( tmp36, tmp12 );
    const auto tmp38 = std::max( tmp37, tmp6 );
    const auto tmp39 = 2 * tmp5;
    const auto tmp40 = tmp0[ 0 ] + tmp0[ 0 ];
    const auto tmp41 = tmp40 / tmp39;
    const auto tmp42 = 2 * tmp41;
    const auto tmp43 = tmp42 * tmp41;
    const auto tmp44 = -1 * tmp43;
    const auto tmp45 = 2 + tmp44;
    const auto tmp46 = tmp45 / tmp39;
    const auto tmp47 = tmp42 * tmp46;
    const auto tmp48 = -1 * tmp47;
    const auto tmp49 = 2 * tmp46;
    const auto tmp50 = tmp49 * tmp41;
    const auto tmp51 = tmp50 + tmp47;
    const auto tmp52 = -1 * tmp51;
    const auto tmp53 = tmp52 + tmp48;
    const auto tmp54 = tmp53 / tmp39;
    const auto tmp55 = tmp54 * (tmp33 > tmp32 ? 1 : 0.0);
    const auto tmp56 = 2 * tmp30;
    const auto tmp57 = tmp40 / tmp56;
    const auto tmp58 = 2 * tmp57;
    const auto tmp59 = tmp58 * tmp57;
    const auto tmp60 = -1 * tmp59;
    const auto tmp61 = 2 + tmp60;
    const auto tmp62 = tmp61 / tmp56;
    const auto tmp63 = tmp58 * tmp62;
    const auto tmp64 = -1 * tmp63;
    const auto tmp65 = 2 * tmp62;
    const auto tmp66 = tmp65 * tmp57;
    const auto tmp67 = tmp66 + tmp63;
    const auto tmp68 = -1 * tmp67;
    const auto tmp69 = tmp68 + tmp64;
    const auto tmp70 = tmp69 / tmp56;
    const auto tmp71 = -1 * tmp70;
    const auto tmp72 = -1 * (tmp33 > tmp32 ? 1 : 0.0);
    const auto tmp73 = 1.0 + tmp72;
    const auto tmp74 = tmp73 * tmp71;
    const auto tmp75 = tmp74 + tmp55;
    const auto tmp76 = tmp75 * (tmp34 > tmp25 ? 1 : 0.0);
    const auto tmp77 = 2 * tmp23;
    const auto tmp78 = tmp40 / tmp77;
    const auto tmp79 = 2 * tmp78;
    const auto tmp80 = tmp79 * tmp78;
    const auto tmp81 = -1 * tmp80;
    const auto tmp82 = 2 + tmp81;
    const auto tmp83 = tmp82 / tmp77;
    const auto tmp84 = tmp79 * tmp83;
    const auto tmp85 = -1 * tmp84;
    const auto tmp86 = 2 * tmp83;
    const auto tmp87 = tmp86 * tmp78;
    const auto tmp88 = tmp87 + tmp84;
    const auto tmp89 = -1 * tmp88;
    const auto tmp90 = tmp89 + tmp85;
    const auto tmp91 = tmp90 / tmp77;
    const auto tmp92 = -1 * tmp91;
    const auto tmp93 = -1 * (tmp34 > tmp25 ? 1 : 0.0);
    const auto tmp94 = 1.0 + tmp93;
    const auto tmp95 = tmp94 * tmp92;
    const auto tmp96 = tmp95 + tmp76;
    const auto tmp97 = tmp96 * (tmp35 < tmp18 ? 1 : 0.0);
    const auto tmp98 = 2 * tmp17;
    const auto tmp99 = tmp13 + tmp13;
    const auto tmp100 = tmp99 / tmp98;
    const auto tmp101 = 2 * tmp100;
    const auto tmp102 = tmp101 * tmp100;
    const auto tmp103 = -1 * tmp102;
    const auto tmp104 = 2 + tmp103;
    const auto tmp105 = tmp104 / tmp98;
    const auto tmp106 = tmp101 * tmp105;
    const auto tmp107 = -1 * tmp106;
    const auto tmp108 = 2 * tmp105;
    const auto tmp109 = tmp108 * tmp100;
    const auto tmp110 = tmp109 + tmp106;
    const auto tmp111 = -1 * tmp110;
    const auto tmp112 = tmp111 + tmp107;
    const auto tmp113 = tmp112 / tmp98;
    const auto tmp114 = -1 * (tmp35 < tmp18 ? 1 : 0.0);
    const auto tmp115 = 1.0 + tmp114;
    const auto tmp116 = tmp115 * tmp113;
    const auto tmp117 = tmp116 + tmp97;
    const auto tmp118 = tmp117 * (tmp36 < tmp12 ? 1 : 0.0);
    const auto tmp119 = 2 * tmp11;
    const auto tmp120 = tmp7 + tmp7;
    const auto tmp121 = tmp120 / tmp119;
    const auto tmp122 = 2 * tmp121;
    const auto tmp123 = tmp122 * tmp121;
    const auto tmp124 = -1 * tmp123;
    const auto tmp125 = 2 + tmp124;
    const auto tmp126 = tmp125 / tmp119;
    const auto tmp127 = tmp122 * tmp126;
    const auto tmp128 = -1 * tmp127;
    const auto tmp129 = 2 * tmp126;
    const auto tmp130 = tmp129 * tmp121;
    const auto tmp131 = tmp130 + tmp127;
    const auto tmp132 = -1 * tmp131;
    const auto tmp133 = tmp132 + tmp128;
    const auto tmp134 = tmp133 / tmp119;
    const auto tmp135 = -1 * (tmp36 < tmp12 ? 1 : 0.0);
    const auto tmp136 = 1.0 + tmp135;
    const auto tmp137 = tmp136 * tmp134;
    const auto tmp138 = tmp137 + tmp118;
    const auto tmp139 = tmp138 * (tmp37 > tmp6 ? 1 : 0.0);
    const auto tmp140 = -1 * (tmp37 > tmp6 ? 1 : 0.0);
    const auto tmp141 = 1.0 + tmp140;
    const auto tmp142 = tmp141 * tmp54;
    const auto tmp143 = tmp142 + tmp139;
    const auto tmp144 = -1 * tmp143;
    const auto tmp145 = tmp144 * tmp38;
    const auto tmp146 = tmp46 * (tmp33 > tmp32 ? 1 : 0.0);
    const auto tmp147 = -1 * tmp62;
    const auto tmp148 = tmp73 * tmp147;
    const auto tmp149 = tmp148 + tmp146;
    const auto tmp150 = tmp149 * (tmp34 > tmp25 ? 1 : 0.0);
    const auto tmp151 = -1 * tmp83;
    const auto tmp152 = tmp94 * tmp151;
    const auto tmp153 = tmp152 + tmp150;
    const auto tmp154 = tmp153 * (tmp35 < tmp18 ? 1 : 0.0);
    const auto tmp155 = tmp115 * tmp105;
    const auto tmp156 = tmp155 + tmp154;
    const auto tmp157 = tmp156 * (tmp36 < tmp12 ? 1 : 0.0);
    const auto tmp158 = tmp136 * tmp126;
    const auto tmp159 = tmp158 + tmp157;
    const auto tmp160 = tmp159 * (tmp37 > tmp6 ? 1 : 0.0);
    const auto tmp161 = tmp141 * tmp46;
    const auto tmp162 = tmp161 + tmp160;
    const auto tmp163 = -1 * tmp162;
    const auto tmp164 = tmp41 * (tmp33 > tmp32 ? 1 : 0.0);
    const auto tmp165 = -1 * tmp57;
    const auto tmp166 = tmp73 * tmp165;
    const auto tmp167 = tmp166 + tmp164;
    const auto tmp168 = tmp167 * (tmp34 > tmp25 ? 1 : 0.0);
    const auto tmp169 = -1 * tmp78;
    const auto tmp170 = tmp94 * tmp169;
    const auto tmp171 = tmp170 + tmp168;
    const auto tmp172 = tmp171 * (tmp35 < tmp18 ? 1 : 0.0);
    const auto tmp173 = tmp115 * tmp100;
    const auto tmp174 = tmp173 + tmp172;
    const auto tmp175 = tmp174 * (tmp36 < tmp12 ? 1 : 0.0);
    const auto tmp176 = tmp136 * tmp121;
    const auto tmp177 = tmp176 + tmp175;
    const auto tmp178 = tmp177 * (tmp37 > tmp6 ? 1 : 0.0);
    const auto tmp179 = tmp141 * tmp41;
    const auto tmp180 = tmp179 + tmp178;
    const auto tmp181 = tmp180 * tmp163;
    const auto tmp182 = tmp181 + tmp145;
    const auto tmp183 = -1 * tmp180;
    const auto tmp184 = tmp162 * tmp183;
    const auto tmp185 = tmp184 + tmp181;
    const auto tmp186 = tmp185 + tmp182;
    const auto tmp187 = tmp0[ 1 ] + tmp0[ 1 ];
    const auto tmp188 = tmp187 / tmp39;
    const auto tmp189 = 2 * tmp188;
    const auto tmp190 = tmp189 * tmp46;
    const auto tmp191 = -1 * tmp190;
    const auto tmp192 = tmp189 * tmp41;
    const auto tmp193 = -1 * tmp192;
    const auto tmp194 = tmp193 / tmp39;
    const auto tmp195 = tmp42 * tmp194;
    const auto tmp196 = 2 * tmp194;
    const auto tmp197 = tmp196 * tmp41;
    const auto tmp198 = tmp197 + tmp195;
    const auto tmp199 = -1 * tmp198;
    const auto tmp200 = tmp199 + tmp191;
    const auto tmp201 = tmp200 / tmp39;
    const auto tmp202 = tmp201 * (tmp33 > tmp32 ? 1 : 0.0);
    const auto tmp203 = tmp26 + tmp26;
    const auto tmp204 = tmp203 / tmp56;
    const auto tmp205 = 2 * tmp204;
    const auto tmp206 = tmp205 * tmp62;
    const auto tmp207 = -1 * tmp206;
    const auto tmp208 = tmp205 * tmp57;
    const auto tmp209 = -1 * tmp208;
    const auto tmp210 = tmp209 / tmp56;
    const auto tmp211 = tmp58 * tmp210;
    const auto tmp212 = 2 * tmp210;
    const auto tmp213 = tmp212 * tmp57;
    const auto tmp214 = tmp213 + tmp211;
    const auto tmp215 = -1 * tmp214;
    const auto tmp216 = tmp215 + tmp207;
    const auto tmp217 = tmp216 / tmp56;
    const auto tmp218 = -1 * tmp217;
    const auto tmp219 = tmp73 * tmp218;
    const auto tmp220 = tmp219 + tmp202;
    const auto tmp221 = tmp220 * (tmp34 > tmp25 ? 1 : 0.0);
    const auto tmp222 = tmp19 + tmp19;
    const auto tmp223 = tmp222 / tmp77;
    const auto tmp224 = 2 * tmp223;
    const auto tmp225 = tmp224 * tmp83;
    const auto tmp226 = -1 * tmp225;
    const auto tmp227 = tmp224 * tmp78;
    const auto tmp228 = -1 * tmp227;
    const auto tmp229 = tmp228 / tmp77;
    const auto tmp230 = tmp79 * tmp229;
    const auto tmp231 = 2 * tmp229;
    const auto tmp232 = tmp231 * tmp78;
    const auto tmp233 = tmp232 + tmp230;
    const auto tmp234 = -1 * tmp233;
    const auto tmp235 = tmp234 + tmp226;
    const auto tmp236 = tmp235 / tmp77;
    const auto tmp237 = -1 * tmp236;
    const auto tmp238 = tmp94 * tmp237;
    const auto tmp239 = tmp238 + tmp221;
    const auto tmp240 = tmp239 * (tmp35 < tmp18 ? 1 : 0.0);
    const auto tmp241 = tmp187 / tmp98;
    const auto tmp242 = 2 * tmp241;
    const auto tmp243 = tmp242 * tmp105;
    const auto tmp244 = -1 * tmp243;
    const auto tmp245 = tmp242 * tmp100;
    const auto tmp246 = -1 * tmp245;
    const auto tmp247 = tmp246 / tmp98;
    const auto tmp248 = tmp101 * tmp247;
    const auto tmp249 = 2 * tmp247;
    const auto tmp250 = tmp249 * tmp100;
    const auto tmp251 = tmp250 + tmp248;
    const auto tmp252 = -1 * tmp251;
    const auto tmp253 = tmp252 + tmp244;
    const auto tmp254 = tmp253 / tmp98;
    const auto tmp255 = tmp115 * tmp254;
    const auto tmp256 = tmp255 + tmp240;
    const auto tmp257 = tmp256 * (tmp36 < tmp12 ? 1 : 0.0);
    const auto tmp258 = tmp187 / tmp119;
    const auto tmp259 = 2 * tmp258;
    const auto tmp260 = tmp259 * tmp126;
    const auto tmp261 = -1 * tmp260;
    const auto tmp262 = tmp259 * tmp121;
    const auto tmp263 = -1 * tmp262;
    const auto tmp264 = tmp263 / tmp119;
    const auto tmp265 = tmp122 * tmp264;
    const auto tmp266 = 2 * tmp264;
    const auto tmp267 = tmp266 * tmp121;
    const auto tmp268 = tmp267 + tmp265;
    const auto tmp269 = -1 * tmp268;
    const auto tmp270 = tmp269 + tmp261;
    const auto tmp271 = tmp270 / tmp119;
    const auto tmp272 = tmp136 * tmp271;
    const auto tmp273 = tmp272 + tmp257;
    const auto tmp274 = tmp273 * (tmp37 > tmp6 ? 1 : 0.0);
    const auto tmp275 = tmp141 * tmp201;
    const auto tmp276 = tmp275 + tmp274;
    const auto tmp277 = -1 * tmp276;
    const auto tmp278 = tmp277 * tmp38;
    const auto tmp279 = tmp188 * (tmp33 > tmp32 ? 1 : 0.0);
    const auto tmp280 = -1 * tmp204;
    const auto tmp281 = tmp73 * tmp280;
    const auto tmp282 = tmp281 + tmp279;
    const auto tmp283 = tmp282 * (tmp34 > tmp25 ? 1 : 0.0);
    const auto tmp284 = -1 * tmp223;
    const auto tmp285 = tmp94 * tmp284;
    const auto tmp286 = tmp285 + tmp283;
    const auto tmp287 = tmp286 * (tmp35 < tmp18 ? 1 : 0.0);
    const auto tmp288 = tmp115 * tmp241;
    const auto tmp289 = tmp288 + tmp287;
    const auto tmp290 = tmp289 * (tmp36 < tmp12 ? 1 : 0.0);
    const auto tmp291 = tmp136 * tmp258;
    const auto tmp292 = tmp291 + tmp290;
    const auto tmp293 = tmp292 * (tmp37 > tmp6 ? 1 : 0.0);
    const auto tmp294 = tmp141 * tmp188;
    const auto tmp295 = tmp294 + tmp293;
    const auto tmp296 = tmp295 * tmp163;
    const auto tmp297 = tmp296 + tmp278;
    const auto tmp298 = tmp194 * (tmp33 > tmp32 ? 1 : 0.0);
    const auto tmp299 = -1 * tmp210;
    const auto tmp300 = tmp73 * tmp299;
    const auto tmp301 = tmp300 + tmp298;
    const auto tmp302 = tmp301 * (tmp34 > tmp25 ? 1 : 0.0);
    const auto tmp303 = -1 * tmp229;
    const auto tmp304 = tmp94 * tmp303;
    const auto tmp305 = tmp304 + tmp302;
    const auto tmp306 = tmp305 * (tmp35 < tmp18 ? 1 : 0.0);
    const auto tmp307 = tmp115 * tmp247;
    const auto tmp308 = tmp307 + tmp306;
    const auto tmp309 = tmp308 * (tmp36 < tmp12 ? 1 : 0.0);
    const auto tmp310 = tmp136 * tmp264;
    const auto tmp311 = tmp310 + tmp309;
    const auto tmp312 = tmp311 * (tmp37 > tmp6 ? 1 : 0.0);
    const auto tmp313 = tmp141 * tmp194;
    const auto tmp314 = tmp313 + tmp312;
    const auto tmp315 = -1 * tmp314;
    const auto tmp316 = tmp180 * tmp315;
    const auto tmp317 = tmp314 * tmp183;
    const auto tmp318 = tmp317 + tmp316;
    const auto tmp319 = tmp318 + tmp297;
    const auto tmp320 = -1 * tmp195;
    const auto tmp321 = tmp42 * tmp188;
    const auto tmp322 = -1 * tmp321;
    const auto tmp323 = tmp322 / tmp39;
    const auto tmp324 = 2 * tmp323;
    const auto tmp325 = tmp324 * tmp41;
    const auto tmp326 = tmp325 + tmp190;
    const auto tmp327 = -1 * tmp326;
    const auto tmp328 = tmp327 + tmp320;
    const auto tmp329 = tmp328 / tmp39;
    const auto tmp330 = tmp329 * (tmp33 > tmp32 ? 1 : 0.0);
    const auto tmp331 = -1 * tmp211;
    const auto tmp332 = tmp58 * tmp204;
    const auto tmp333 = -1 * tmp332;
    const auto tmp334 = tmp333 / tmp56;
    const auto tmp335 = 2 * tmp334;
    const auto tmp336 = tmp335 * tmp57;
    const auto tmp337 = tmp336 + tmp206;
    const auto tmp338 = -1 * tmp337;
    const auto tmp339 = tmp338 + tmp331;
    const auto tmp340 = tmp339 / tmp56;
    const auto tmp341 = -1 * tmp340;
    const auto tmp342 = tmp73 * tmp341;
    const auto tmp343 = tmp342 + tmp330;
    const auto tmp344 = tmp343 * (tmp34 > tmp25 ? 1 : 0.0);
    const auto tmp345 = -1 * tmp230;
    const auto tmp346 = tmp79 * tmp223;
    const auto tmp347 = -1 * tmp346;
    const auto tmp348 = tmp347 / tmp77;
    const auto tmp349 = 2 * tmp348;
    const auto tmp350 = tmp349 * tmp78;
    const auto tmp351 = tmp350 + tmp225;
    const auto tmp352 = -1 * tmp351;
    const auto tmp353 = tmp352 + tmp345;
    const auto tmp354 = tmp353 / tmp77;
    const auto tmp355 = -1 * tmp354;
    const auto tmp356 = tmp94 * tmp355;
    const auto tmp357 = tmp356 + tmp344;
    const auto tmp358 = tmp357 * (tmp35 < tmp18 ? 1 : 0.0);
    const auto tmp359 = -1 * tmp248;
    const auto tmp360 = tmp101 * tmp241;
    const auto tmp361 = -1 * tmp360;
    const auto tmp362 = tmp361 / tmp98;
    const auto tmp363 = 2 * tmp362;
    const auto tmp364 = tmp363 * tmp100;
    const auto tmp365 = tmp364 + tmp243;
    const auto tmp366 = -1 * tmp365;
    const auto tmp367 = tmp366 + tmp359;
    const auto tmp368 = tmp367 / tmp98;
    const auto tmp369 = tmp115 * tmp368;
    const auto tmp370 = tmp369 + tmp358;
    const auto tmp371 = tmp370 * (tmp36 < tmp12 ? 1 : 0.0);
    const auto tmp372 = -1 * tmp265;
    const auto tmp373 = tmp122 * tmp258;
    const auto tmp374 = -1 * tmp373;
    const auto tmp375 = tmp374 / tmp119;
    const auto tmp376 = 2 * tmp375;
    const auto tmp377 = tmp376 * tmp121;
    const auto tmp378 = tmp377 + tmp260;
    const auto tmp379 = -1 * tmp378;
    const auto tmp380 = tmp379 + tmp372;
    const auto tmp381 = tmp380 / tmp119;
    const auto tmp382 = tmp136 * tmp381;
    const auto tmp383 = tmp382 + tmp371;
    const auto tmp384 = tmp383 * (tmp37 > tmp6 ? 1 : 0.0);
    const auto tmp385 = tmp141 * tmp329;
    const auto tmp386 = tmp385 + tmp384;
    const auto tmp387 = -1 * tmp386;
    const auto tmp388 = tmp387 * tmp38;
    const auto tmp389 = tmp316 + tmp388;
    const auto tmp390 = tmp323 * (tmp33 > tmp32 ? 1 : 0.0);
    const auto tmp391 = -1 * tmp334;
    const auto tmp392 = tmp73 * tmp391;
    const auto tmp393 = tmp392 + tmp390;
    const auto tmp394 = tmp393 * (tmp34 > tmp25 ? 1 : 0.0);
    const auto tmp395 = -1 * tmp348;
    const auto tmp396 = tmp94 * tmp395;
    const auto tmp397 = tmp396 + tmp394;
    const auto tmp398 = tmp397 * (tmp35 < tmp18 ? 1 : 0.0);
    const auto tmp399 = tmp115 * tmp362;
    const auto tmp400 = tmp399 + tmp398;
    const auto tmp401 = tmp400 * (tmp36 < tmp12 ? 1 : 0.0);
    const auto tmp402 = tmp136 * tmp375;
    const auto tmp403 = tmp402 + tmp401;
    const auto tmp404 = tmp403 * (tmp37 > tmp6 ? 1 : 0.0);
    const auto tmp405 = tmp141 * tmp323;
    const auto tmp406 = tmp405 + tmp404;
    const auto tmp407 = tmp406 * tmp183;
    const auto tmp408 = tmp407 + tmp296;
    const auto tmp409 = tmp408 + tmp389;
    const auto tmp410 = tmp189 * tmp194;
    const auto tmp411 = -1 * tmp410;
    const auto tmp412 = tmp189 * tmp188;
    const auto tmp413 = -1 * tmp412;
    const auto tmp414 = 2 + tmp413;
    const auto tmp415 = tmp414 / tmp39;
    const auto tmp416 = 2 * tmp415;
    const auto tmp417 = tmp416 * tmp41;
    const auto tmp418 = tmp417 + tmp410;
    const auto tmp419 = -1 * tmp418;
    const auto tmp420 = tmp419 + tmp411;
    const auto tmp421 = tmp420 / tmp39;
    const auto tmp422 = tmp421 * (tmp33 > tmp32 ? 1 : 0.0);
    const auto tmp423 = tmp205 * tmp210;
    const auto tmp424 = -1 * tmp423;
    const auto tmp425 = tmp205 * tmp204;
    const auto tmp426 = -1 * tmp425;
    const auto tmp427 = 2 + tmp426;
    const auto tmp428 = tmp427 / tmp56;
    const auto tmp429 = 2 * tmp428;
    const auto tmp430 = tmp429 * tmp57;
    const auto tmp431 = tmp430 + tmp423;
    const auto tmp432 = -1 * tmp431;
    const auto tmp433 = tmp432 + tmp424;
    const auto tmp434 = tmp433 / tmp56;
    const auto tmp435 = -1 * tmp434;
    const auto tmp436 = tmp73 * tmp435;
    const auto tmp437 = tmp436 + tmp422;
    const auto tmp438 = tmp437 * (tmp34 > tmp25 ? 1 : 0.0);
    const auto tmp439 = tmp224 * tmp229;
    const auto tmp440 = -1 * tmp439;
    const auto tmp441 = tmp224 * tmp223;
    const auto tmp442 = -1 * tmp441;
    const auto tmp443 = 2 + tmp442;
    const auto tmp444 = tmp443 / tmp77;
    const auto tmp445 = 2 * tmp444;
    const auto tmp446 = tmp445 * tmp78;
    const auto tmp447 = tmp446 + tmp439;
    const auto tmp448 = -1 * tmp447;
    const auto tmp449 = tmp448 + tmp440;
    const auto tmp450 = tmp449 / tmp77;
    const auto tmp451 = -1 * tmp450;
    const auto tmp452 = tmp94 * tmp451;
    const auto tmp453 = tmp452 + tmp438;
    const auto tmp454 = tmp453 * (tmp35 < tmp18 ? 1 : 0.0);
    const auto tmp455 = tmp242 * tmp247;
    const auto tmp456 = -1 * tmp455;
    const auto tmp457 = tmp242 * tmp241;
    const auto tmp458 = -1 * tmp457;
    const auto tmp459 = 2 + tmp458;
    const auto tmp460 = tmp459 / tmp98;
    const auto tmp461 = 2 * tmp460;
    const auto tmp462 = tmp461 * tmp100;
    const auto tmp463 = tmp462 + tmp455;
    const auto tmp464 = -1 * tmp463;
    const auto tmp465 = tmp464 + tmp456;
    const auto tmp466 = tmp465 / tmp98;
    const auto tmp467 = tmp115 * tmp466;
    const auto tmp468 = tmp467 + tmp454;
    const auto tmp469 = tmp468 * (tmp36 < tmp12 ? 1 : 0.0);
    const auto tmp470 = tmp259 * tmp264;
    const auto tmp471 = -1 * tmp470;
    const auto tmp472 = tmp259 * tmp258;
    const auto tmp473 = -1 * tmp472;
    const auto tmp474 = 2 + tmp473;
    const auto tmp475 = tmp474 / tmp119;
    const auto tmp476 = 2 * tmp475;
    const auto tmp477 = tmp476 * tmp121;
    const auto tmp478 = tmp477 + tmp470;
    const auto tmp479 = -1 * tmp478;
    const auto tmp480 = tmp479 + tmp471;
    const auto tmp481 = tmp480 / tmp119;
    const auto tmp482 = tmp136 * tmp481;
    const auto tmp483 = tmp482 + tmp469;
    const auto tmp484 = tmp483 * (tmp37 > tmp6 ? 1 : 0.0);
    const auto tmp485 = tmp141 * tmp421;
    const auto tmp486 = tmp485 + tmp484;
    const auto tmp487 = -1 * tmp486;
    const auto tmp488 = tmp487 * tmp38;
    const auto tmp489 = tmp295 * tmp315;
    const auto tmp490 = tmp489 + tmp488;
    const auto tmp491 = tmp415 * (tmp33 > tmp32 ? 1 : 0.0);
    const auto tmp492 = -1 * tmp428;
    const auto tmp493 = tmp73 * tmp492;
    const auto tmp494 = tmp493 + tmp491;
    const auto tmp495 = tmp494 * (tmp34 > tmp25 ? 1 : 0.0);
    const auto tmp496 = -1 * tmp444;
    const auto tmp497 = tmp94 * tmp496;
    const auto tmp498 = tmp497 + tmp495;
    const auto tmp499 = tmp498 * (tmp35 < tmp18 ? 1 : 0.0);
    const auto tmp500 = tmp115 * tmp460;
    const auto tmp501 = tmp500 + tmp499;
    const auto tmp502 = tmp501 * (tmp36 < tmp12 ? 1 : 0.0);
    const auto tmp503 = tmp136 * tmp475;
    const auto tmp504 = tmp503 + tmp502;
    const auto tmp505 = tmp504 * (tmp37 > tmp6 ? 1 : 0.0);
    const auto tmp506 = tmp141 * tmp415;
    const auto tmp507 = tmp506 + tmp505;
    const auto tmp508 = tmp507 * tmp183;
    const auto tmp509 = tmp508 + tmp489;
    const auto tmp510 = tmp509 + tmp490;
    const auto tmp511 = tmp42 * tmp323;
    const auto tmp512 = -1 * tmp511;
    const auto tmp513 = tmp49 * tmp188;
    const auto tmp514 = tmp513 + tmp511;
    const auto tmp515 = -1 * tmp514;
    const auto tmp516 = tmp515 + tmp512;
    const auto tmp517 = tmp516 / tmp39;
    const auto tmp518 = tmp517 * (tmp33 > tmp32 ? 1 : 0.0);
    const auto tmp519 = tmp58 * tmp334;
    const auto tmp520 = -1 * tmp519;
    const auto tmp521 = tmp65 * tmp204;
    const auto tmp522 = tmp521 + tmp519;
    const auto tmp523 = -1 * tmp522;
    const auto tmp524 = tmp523 + tmp520;
    const auto tmp525 = tmp524 / tmp56;
    const auto tmp526 = -1 * tmp525;
    const auto tmp527 = tmp73 * tmp526;
    const auto tmp528 = tmp527 + tmp518;
    const auto tmp529 = tmp528 * (tmp34 > tmp25 ? 1 : 0.0);
    const auto tmp530 = tmp79 * tmp348;
    const auto tmp531 = -1 * tmp530;
    const auto tmp532 = tmp86 * tmp223;
    const auto tmp533 = tmp532 + tmp530;
    const auto tmp534 = -1 * tmp533;
    const auto tmp535 = tmp534 + tmp531;
    const auto tmp536 = tmp535 / tmp77;
    const auto tmp537 = -1 * tmp536;
    const auto tmp538 = tmp94 * tmp537;
    const auto tmp539 = tmp538 + tmp529;
    const auto tmp540 = tmp539 * (tmp35 < tmp18 ? 1 : 0.0);
    const auto tmp541 = tmp101 * tmp362;
    const auto tmp542 = -1 * tmp541;
    const auto tmp543 = tmp108 * tmp241;
    const auto tmp544 = tmp543 + tmp541;
    const auto tmp545 = -1 * tmp544;
    const auto tmp546 = tmp545 + tmp542;
    const auto tmp547 = tmp546 / tmp98;
    const auto tmp548 = tmp115 * tmp547;
    const auto tmp549 = tmp548 + tmp540;
    const auto tmp550 = tmp549 * (tmp36 < tmp12 ? 1 : 0.0);
    const auto tmp551 = tmp122 * tmp375;
    const auto tmp552 = -1 * tmp551;
    const auto tmp553 = tmp129 * tmp258;
    const auto tmp554 = tmp553 + tmp551;
    const auto tmp555 = -1 * tmp554;
    const auto tmp556 = tmp555 + tmp552;
    const auto tmp557 = tmp556 / tmp119;
    const auto tmp558 = tmp136 * tmp557;
    const auto tmp559 = tmp558 + tmp550;
    const auto tmp560 = tmp559 * (tmp37 > tmp6 ? 1 : 0.0);
    const auto tmp561 = tmp141 * tmp517;
    const auto tmp562 = tmp561 + tmp560;
    const auto tmp563 = -1 * tmp562;
    const auto tmp564 = tmp563 * tmp38;
    const auto tmp565 = -1 * tmp406;
    const auto tmp566 = tmp180 * tmp565;
    const auto tmp567 = tmp566 + tmp564;
    const auto tmp568 = -1 * tmp295;
    const auto tmp569 = tmp162 * tmp568;
    const auto tmp570 = tmp569 + tmp566;
    const auto tmp571 = tmp570 + tmp567;
    const auto tmp572 = tmp189 * tmp323;
    const auto tmp573 = -1 * tmp572;
    const auto tmp574 = tmp42 * tmp415;
    const auto tmp575 = tmp196 * tmp188;
    const auto tmp576 = tmp575 + tmp574;
    const auto tmp577 = -1 * tmp576;
    const auto tmp578 = tmp577 + tmp573;
    const auto tmp579 = tmp578 / tmp39;
    const auto tmp580 = tmp579 * (tmp33 > tmp32 ? 1 : 0.0);
    const auto tmp581 = tmp205 * tmp334;
    const auto tmp582 = -1 * tmp581;
    const auto tmp583 = tmp58 * tmp428;
    const auto tmp584 = tmp212 * tmp204;
    const auto tmp585 = tmp584 + tmp583;
    const auto tmp586 = -1 * tmp585;
    const auto tmp587 = tmp586 + tmp582;
    const auto tmp588 = tmp587 / tmp56;
    const auto tmp589 = -1 * tmp588;
    const auto tmp590 = tmp73 * tmp589;
    const auto tmp591 = tmp590 + tmp580;
    const auto tmp592 = tmp591 * (tmp34 > tmp25 ? 1 : 0.0);
    const auto tmp593 = tmp224 * tmp348;
    const auto tmp594 = -1 * tmp593;
    const auto tmp595 = tmp79 * tmp444;
    const auto tmp596 = tmp231 * tmp223;
    const auto tmp597 = tmp596 + tmp595;
    const auto tmp598 = -1 * tmp597;
    const auto tmp599 = tmp598 + tmp594;
    const auto tmp600 = tmp599 / tmp77;
    const auto tmp601 = -1 * tmp600;
    const auto tmp602 = tmp94 * tmp601;
    const auto tmp603 = tmp602 + tmp592;
    const auto tmp604 = tmp603 * (tmp35 < tmp18 ? 1 : 0.0);
    const auto tmp605 = tmp242 * tmp362;
    const auto tmp606 = -1 * tmp605;
    const auto tmp607 = tmp101 * tmp460;
    const auto tmp608 = tmp249 * tmp241;
    const auto tmp609 = tmp608 + tmp607;
    const auto tmp610 = -1 * tmp609;
    const auto tmp611 = tmp610 + tmp606;
    const auto tmp612 = tmp611 / tmp98;
    const auto tmp613 = tmp115 * tmp612;
    const auto tmp614 = tmp613 + tmp604;
    const auto tmp615 = tmp614 * (tmp36 < tmp12 ? 1 : 0.0);
    const auto tmp616 = tmp259 * tmp375;
    const auto tmp617 = -1 * tmp616;
    const auto tmp618 = tmp122 * tmp475;
    const auto tmp619 = tmp266 * tmp258;
    const auto tmp620 = tmp619 + tmp618;
    const auto tmp621 = -1 * tmp620;
    const auto tmp622 = tmp621 + tmp617;
    const auto tmp623 = tmp622 / tmp119;
    const auto tmp624 = tmp136 * tmp623;
    const auto tmp625 = tmp624 + tmp615;
    const auto tmp626 = tmp625 * (tmp37 > tmp6 ? 1 : 0.0);
    const auto tmp627 = tmp141 * tmp579;
    const auto tmp628 = tmp627 + tmp626;
    const auto tmp629 = -1 * tmp628;
    const auto tmp630 = tmp629 * tmp38;
    const auto tmp631 = tmp295 * tmp565;
    const auto tmp632 = tmp631 + tmp630;
    const auto tmp633 = -1 * tmp507;
    const auto tmp634 = tmp180 * tmp633;
    const auto tmp635 = tmp314 * tmp568;
    const auto tmp636 = tmp635 + tmp634;
    const auto tmp637 = tmp636 + tmp632;
    const auto tmp638 = -1 * tmp574;
    const auto tmp639 = tmp324 * tmp188;
    const auto tmp640 = tmp639 + tmp572;
    const auto tmp641 = -1 * tmp640;
    const auto tmp642 = tmp641 + tmp638;
    const auto tmp643 = tmp642 / tmp39;
    const auto tmp644 = tmp643 * (tmp33 > tmp32 ? 1 : 0.0);
    const auto tmp645 = -1 * tmp583;
    const auto tmp646 = tmp335 * tmp204;
    const auto tmp647 = tmp646 + tmp581;
    const auto tmp648 = -1 * tmp647;
    const auto tmp649 = tmp648 + tmp645;
    const auto tmp650 = tmp649 / tmp56;
    const auto tmp651 = -1 * tmp650;
    const auto tmp652 = tmp73 * tmp651;
    const auto tmp653 = tmp652 + tmp644;
    const auto tmp654 = tmp653 * (tmp34 > tmp25 ? 1 : 0.0);
    const auto tmp655 = -1 * tmp595;
    const auto tmp656 = tmp349 * tmp223;
    const auto tmp657 = tmp656 + tmp593;
    const auto tmp658 = -1 * tmp657;
    const auto tmp659 = tmp658 + tmp655;
    const auto tmp660 = tmp659 / tmp77;
    const auto tmp661 = -1 * tmp660;
    const auto tmp662 = tmp94 * tmp661;
    const auto tmp663 = tmp662 + tmp654;
    const auto tmp664 = tmp663 * (tmp35 < tmp18 ? 1 : 0.0);
    const auto tmp665 = -1 * tmp607;
    const auto tmp666 = tmp363 * tmp241;
    const auto tmp667 = tmp666 + tmp605;
    const auto tmp668 = -1 * tmp667;
    const auto tmp669 = tmp668 + tmp665;
    const auto tmp670 = tmp669 / tmp98;
    const auto tmp671 = tmp115 * tmp670;
    const auto tmp672 = tmp671 + tmp664;
    const auto tmp673 = tmp672 * (tmp36 < tmp12 ? 1 : 0.0);
    const auto tmp674 = -1 * tmp618;
    const auto tmp675 = tmp376 * tmp258;
    const auto tmp676 = tmp675 + tmp616;
    const auto tmp677 = -1 * tmp676;
    const auto tmp678 = tmp677 + tmp674;
    const auto tmp679 = tmp678 / tmp119;
    const auto tmp680 = tmp136 * tmp679;
    const auto tmp681 = tmp680 + tmp673;
    const auto tmp682 = tmp681 * (tmp37 > tmp6 ? 1 : 0.0);
    const auto tmp683 = tmp141 * tmp643;
    const auto tmp684 = tmp683 + tmp682;
    const auto tmp685 = -1 * tmp684;
    const auto tmp686 = tmp685 * tmp38;
    const auto tmp687 = tmp634 + tmp686;
    const auto tmp688 = tmp406 * tmp568;
    const auto tmp689 = tmp688 + tmp631;
    const auto tmp690 = tmp689 + tmp687;
    const auto tmp691 = tmp189 * tmp415;
    const auto tmp692 = -1 * tmp691;
    const auto tmp693 = tmp416 * tmp188;
    const auto tmp694 = tmp693 + tmp691;
    const auto tmp695 = -1 * tmp694;
    const auto tmp696 = tmp695 + tmp692;
    const auto tmp697 = tmp696 / tmp39;
    const auto tmp698 = tmp697 * (tmp33 > tmp32 ? 1 : 0.0);
    const auto tmp699 = tmp205 * tmp428;
    const auto tmp700 = -1 * tmp699;
    const auto tmp701 = tmp429 * tmp204;
    const auto tmp702 = tmp701 + tmp699;
    const auto tmp703 = -1 * tmp702;
    const auto tmp704 = tmp703 + tmp700;
    const auto tmp705 = tmp704 / tmp56;
    const auto tmp706 = -1 * tmp705;
    const auto tmp707 = tmp73 * tmp706;
    const auto tmp708 = tmp707 + tmp698;
    const auto tmp709 = tmp708 * (tmp34 > tmp25 ? 1 : 0.0);
    const auto tmp710 = tmp224 * tmp444;
    const auto tmp711 = -1 * tmp710;
    const auto tmp712 = tmp445 * tmp223;
    const auto tmp713 = tmp712 + tmp710;
    const auto tmp714 = -1 * tmp713;
    const auto tmp715 = tmp714 + tmp711;
    const auto tmp716 = tmp715 / tmp77;
    const auto tmp717 = -1 * tmp716;
    const auto tmp718 = tmp94 * tmp717;
    const auto tmp719 = tmp718 + tmp709;
    const auto tmp720 = tmp719 * (tmp35 < tmp18 ? 1 : 0.0);
    const auto tmp721 = tmp242 * tmp460;
    const auto tmp722 = -1 * tmp721;
    const auto tmp723 = tmp461 * tmp241;
    const auto tmp724 = tmp723 + tmp721;
    const auto tmp725 = -1 * tmp724;
    const auto tmp726 = tmp725 + tmp722;
    const auto tmp727 = tmp726 / tmp98;
    const auto tmp728 = tmp115 * tmp727;
    const auto tmp729 = tmp728 + tmp720;
    const auto tmp730 = tmp729 * (tmp36 < tmp12 ? 1 : 0.0);
    const auto tmp731 = tmp259 * tmp475;
    const auto tmp732 = -1 * tmp731;
    const auto tmp733 = tmp476 * tmp258;
    const auto tmp734 = tmp733 + tmp731;
    const auto tmp735 = -1 * tmp734;
    const auto tmp736 = tmp735 + tmp732;
    const auto tmp737 = tmp736 / tmp119;
    const auto tmp738 = tmp136 * tmp737;
    const auto tmp739 = tmp738 + tmp730;
    const auto tmp740 = tmp739 * (tmp37 > tmp6 ? 1 : 0.0);
    const auto tmp741 = tmp141 * tmp697;
    const auto tmp742 = tmp741 + tmp740;
    const auto tmp743 = -1 * tmp742;
    const auto tmp744 = tmp743 * tmp38;
    const auto tmp745 = tmp295 * tmp633;
    const auto tmp746 = tmp745 + tmp744;
    const auto tmp747 = tmp507 * tmp568;
    const auto tmp748 = tmp747 + tmp745;
    const auto tmp749 = tmp748 + tmp746;
    ((result[ 0 ])[ 0 ])[ 0 ] = tmp186;
    ((result[ 0 ])[ 0 ])[ 1 ] = tmp319;
    ((result[ 0 ])[ 1 ])[ 0 ] = tmp409;
    ((result[ 0 ])[ 1 ])[ 1 ] = tmp510;
    ((result[ 1 ])[ 0 ])[ 0 ] = tmp571;
    ((result[ 1 ])[ 0 ])[ 1 ] = tmp637;
    ((result[ 1 ])[ 1 ])[ 0 ] = tmp690;
    ((result[ 1 ])[ 1 ])[ 1 ] = tmp749;
  }

  template< std::size_t i >
  const ConstantType< i > &constant () const
  {
    return *std::get< i >( constants_ );
  }

  template< std::size_t i >
  ConstantType< i > &constant ()
  {
    return *std::get< i >( constants_ );
  }
  ConstantTupleType constants_;
  std::tuple<  > coefficients_;
};

} // namespace UFLLocalFunctions_b8239bf849ec7c1903f627833e6dac5a

PYBIND11_MODULE( localfunction_b8239bf849ec7c1903f627833e6dac5a_a524c1196983e65de1c06d7d6afdeb44, module )
{
  typedef UFLLocalFunctions_b8239bf849ec7c1903f627833e6dac5a::UFLLocalFunction< typename Dune::FemPy::GridPart< Dune::Fem::FilteredGridPart< Dune::FemPy::GridPart< Dune::Fem::AdaptiveLeafGridPart< Dune::ALUGrid< 2, 2, Dune::simplex > > >, Dune::Fem::SimpleFilter< Dune::FemPy::GridPart< Dune::Fem::AdaptiveLeafGridPart< Dune::ALUGrid< 2, 2, Dune::simplex > > > >, true > > > LocalFunctionType;
  if constexpr( LocalFunctionType::gridPartValid )
  {
      auto cls = Dune::Python::insertClass<LocalFunctionType>(module,"UFLLocalFunction",Dune::Python::GenerateTypeName("UFLLocalFunctions_b8239bf849ec7c1903f627833e6dac5a::UFLLocalFunction< typename Dune::FemPy::GridPart< Dune::Fem::FilteredGridPart< Dune::FemPy::GridPart< Dune::Fem::AdaptiveLeafGridPart< Dune::ALUGrid< 2, 2, Dune::simplex > > >, Dune::Fem::SimpleFilter< Dune::FemPy::GridPart< Dune::Fem::AdaptiveLeafGridPart< Dune::ALUGrid< 2, 2, Dune::simplex > > > >, true > > >"), Dune::Python::IncludeFiles({"python/dune/generated/localfunction_b8239bf849ec7c1903f627833e6dac5a_a524c1196983e65de1c06d7d6afdeb44.cc"})).first;
      Dune::FemPy::registerUFLLocalFunction( module, cls );
      cls.def( pybind11::init( [] ( pybind11::object gridView, const std::string &name, int order ) {return new LocalFunctionType( Dune::FemPy::gridPart<Dune::Fem::FilteredGridPart< Dune::FemPy::GridPart< Dune::Fem::AdaptiveLeafGridPart< Dune::ALUGrid< 2, 2, Dune::simplex > > >, Dune::Fem::SimpleFilter< Dune::FemPy::GridPart< Dune::Fem::AdaptiveLeafGridPart< Dune::ALUGrid< 2, 2, Dune::simplex > > > >, true >>(gridView),name,order); } ), pybind11::keep_alive< 1, 2 >() );
      cls.def_property_readonly( "virtualized", [] ( LocalFunctionType& ) -> bool { return true;});
  }
}

#endif
