# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['UserAttributeProfileArgs', 'UserAttributeProfile']

@pulumi.input_type
class UserAttributeProfileArgs:
    def __init__(__self__, *,
                 user_attributes: pulumi.Input[Sequence[pulumi.Input['UserAttributeProfileUserAttributeArgs']]],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 user_id: Optional[pulumi.Input['UserAttributeProfileUserIdArgs']] = None):
        """
        The set of arguments for constructing a UserAttributeProfile resource.
        :param pulumi.Input[Sequence[pulumi.Input['UserAttributeProfileUserAttributeArgs']]] user_attributes: List of user attribute configurations.
        :param pulumi.Input[_builtins.str] name: The name of the User Attribute Profile.
        :param pulumi.Input['UserAttributeProfileUserIdArgs'] user_id: Configuration for mapping the user ID from identity providers.
        """
        pulumi.set(__self__, "user_attributes", user_attributes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @_builtins.property
    @pulumi.getter(name="userAttributes")
    def user_attributes(self) -> pulumi.Input[Sequence[pulumi.Input['UserAttributeProfileUserAttributeArgs']]]:
        """
        List of user attribute configurations.
        """
        return pulumi.get(self, "user_attributes")

    @user_attributes.setter
    def user_attributes(self, value: pulumi.Input[Sequence[pulumi.Input['UserAttributeProfileUserAttributeArgs']]]):
        pulumi.set(self, "user_attributes", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the User Attribute Profile.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input['UserAttributeProfileUserIdArgs']]:
        """
        Configuration for mapping the user ID from identity providers.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input['UserAttributeProfileUserIdArgs']]):
        pulumi.set(self, "user_id", value)


@pulumi.input_type
class _UserAttributeProfileState:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 user_attributes: Optional[pulumi.Input[Sequence[pulumi.Input['UserAttributeProfileUserAttributeArgs']]]] = None,
                 user_id: Optional[pulumi.Input['UserAttributeProfileUserIdArgs']] = None):
        """
        Input properties used for looking up and filtering UserAttributeProfile resources.
        :param pulumi.Input[_builtins.str] name: The name of the User Attribute Profile.
        :param pulumi.Input[Sequence[pulumi.Input['UserAttributeProfileUserAttributeArgs']]] user_attributes: List of user attribute configurations.
        :param pulumi.Input['UserAttributeProfileUserIdArgs'] user_id: Configuration for mapping the user ID from identity providers.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if user_attributes is not None:
            pulumi.set(__self__, "user_attributes", user_attributes)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the User Attribute Profile.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="userAttributes")
    def user_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserAttributeProfileUserAttributeArgs']]]]:
        """
        List of user attribute configurations.
        """
        return pulumi.get(self, "user_attributes")

    @user_attributes.setter
    def user_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserAttributeProfileUserAttributeArgs']]]]):
        pulumi.set(self, "user_attributes", value)

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input['UserAttributeProfileUserIdArgs']]:
        """
        Configuration for mapping the user ID from identity providers.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input['UserAttributeProfileUserIdArgs']]):
        pulumi.set(self, "user_id", value)


@pulumi.type_token("auth0:index/userAttributeProfile:UserAttributeProfile")
class UserAttributeProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 user_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserAttributeProfileUserAttributeArgs', 'UserAttributeProfileUserAttributeArgsDict']]]]] = None,
                 user_id: Optional[pulumi.Input[Union['UserAttributeProfileUserIdArgs', 'UserAttributeProfileUserIdArgsDict']]] = None,
                 __props__=None):
        """
        With this resource, you can manage User Attribute Profiles within Auth0. User Attribute Profiles allow you to define how user attributes are mapped between different identity providers and Auth0.

        > This resource is only available for [EA](https://auth0.com/docs/troubleshoot/product-lifecycle/product-release-stages#early-access) users.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: The name of the User Attribute Profile.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UserAttributeProfileUserAttributeArgs', 'UserAttributeProfileUserAttributeArgsDict']]]] user_attributes: List of user attribute configurations.
        :param pulumi.Input[Union['UserAttributeProfileUserIdArgs', 'UserAttributeProfileUserIdArgsDict']] user_id: Configuration for mapping the user ID from identity providers.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserAttributeProfileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        With this resource, you can manage User Attribute Profiles within Auth0. User Attribute Profiles allow you to define how user attributes are mapped between different identity providers and Auth0.

        > This resource is only available for [EA](https://auth0.com/docs/troubleshoot/product-lifecycle/product-release-stages#early-access) users.

        :param str resource_name: The name of the resource.
        :param UserAttributeProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserAttributeProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 user_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserAttributeProfileUserAttributeArgs', 'UserAttributeProfileUserAttributeArgsDict']]]]] = None,
                 user_id: Optional[pulumi.Input[Union['UserAttributeProfileUserIdArgs', 'UserAttributeProfileUserIdArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserAttributeProfileArgs.__new__(UserAttributeProfileArgs)

            __props__.__dict__["name"] = name
            if user_attributes is None and not opts.urn:
                raise TypeError("Missing required property 'user_attributes'")
            __props__.__dict__["user_attributes"] = user_attributes
            __props__.__dict__["user_id"] = user_id
        super(UserAttributeProfile, __self__).__init__(
            'auth0:index/userAttributeProfile:UserAttributeProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            user_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserAttributeProfileUserAttributeArgs', 'UserAttributeProfileUserAttributeArgsDict']]]]] = None,
            user_id: Optional[pulumi.Input[Union['UserAttributeProfileUserIdArgs', 'UserAttributeProfileUserIdArgsDict']]] = None) -> 'UserAttributeProfile':
        """
        Get an existing UserAttributeProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: The name of the User Attribute Profile.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UserAttributeProfileUserAttributeArgs', 'UserAttributeProfileUserAttributeArgsDict']]]] user_attributes: List of user attribute configurations.
        :param pulumi.Input[Union['UserAttributeProfileUserIdArgs', 'UserAttributeProfileUserIdArgsDict']] user_id: Configuration for mapping the user ID from identity providers.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserAttributeProfileState.__new__(_UserAttributeProfileState)

        __props__.__dict__["name"] = name
        __props__.__dict__["user_attributes"] = user_attributes
        __props__.__dict__["user_id"] = user_id
        return UserAttributeProfile(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the User Attribute Profile.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="userAttributes")
    def user_attributes(self) -> pulumi.Output[Sequence['outputs.UserAttributeProfileUserAttribute']]:
        """
        List of user attribute configurations.
        """
        return pulumi.get(self, "user_attributes")

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output['outputs.UserAttributeProfileUserId']:
        """
        Configuration for mapping the user ID from identity providers.
        """
        return pulumi.get(self, "user_id")

