"""
This file is generated by `Build_TFP_light.py` and requires some modifications, which can be done using Ctrl+H:

    1. Replace "args=args, kwargs=kwargs" with "*args, **kwargs"
    2. Replace "k_k_j" with "lkj"
    3. Replace "<class 'jax.numpy.int32'>" with "jax.numpy.int32"
    4. Replace "<class 'jax.numpy.float32'>" with "jax.numpy.float32"
    5. Replace "*args, **kwargs, shape=(), sample=False, seed=0, obs=None, warp=True"
       with "shape=(), sample=False, seed=0, obs=None, warp=True, *args, **kwargs"

All required changes can be tracked using the VSCode Problems list.

Note: Not all of the functions have been tested. Some may not work as expected—particularly those that wrap distributions (e.g., `auto_composite_tensor_distribution`, `autoregressive`).

"""


import jax
import jax.numpy as jnp
from tensorflow_probability.substrates import jax as tfp
import tensorflow_probability.substrates.jax.distributions as tfd

tfb = tfp.bijectors
root = tfd.JointDistributionCoroutine.Root

class UnifiedDist:
    """A class that wraps TFP distributions for a unified sampling interface."""

    @staticmethod
    def auto_composite_tensor_distribution(dtype, reparameterization_type, validate_args, allow_nan_stats, parameters=None, graph_parents=None, name=None, shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.AutoCompositeTensorDistribution distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                dtype: Default = <class 'inspect._empty'>
                reparameterization_type: Default = <class 'inspect._empty'>
                validate_args: Default = <class 'inspect._empty'>
                allow_nan_stats: Default = <class 'inspect._empty'>
                parameters: Default = None
                graph_parents: Default = None
                name: Default = None
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.AutoCompositeTensorDistribution(dtype=dtype, reparameterization_type=reparameterization_type, validate_args=validate_args, allow_nan_stats=allow_nan_stats, parameters=parameters, graph_parents=graph_parents, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def autoregressive(distribution_fn, sample0=None, num_steps=None, validate_args=False, allow_nan_stats=True, name='Autoregressive', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.Autoregressive distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                distribution_fn: Default = <class 'inspect._empty'>
                sample0: Default = None
                num_steps: Default = None
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = Autoregressive
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.Autoregressive(distribution_fn=distribution_fn, sample0=sample0, num_steps=num_steps, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def batch_broadcast(shape=(), sample=False, seed=0, obs=None, wrap=True, *args, **kwargs):
        """
        Wrapper for the tfd.BatchBroadcast distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                args: Default = <class 'inspect._empty'>
                kwargs: Default = <class 'inspect._empty'>
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.BatchBroadcast(*args, **kwargs)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def batch_concat(shape=(), sample=False, seed=0, obs=None, wrap=True, *args, **kwargs):
        """
        Wrapper for the tfd.BatchConcat distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                args: Default = <class 'inspect._empty'>
                kwargs: Default = <class 'inspect._empty'>
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.BatchConcat(*args, **kwargs)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def batch_reshape(shape=(), sample=False, seed=0, obs=None, wrap=True, *args, **kwargs):
        """
        Wrapper for the tfd.BatchReshape distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                args: Default = <class 'inspect._empty'>
                kwargs: Default = <class 'inspect._empty'>
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.BatchReshape(*args, **kwargs)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def bates(total_count, low=0.0, high=1.0, validate_args=False, allow_nan_stats=True, name='Bates', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.Bates distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                total_count: Default = <class 'inspect._empty'>
                low: Default = 0.0
                high: Default = 1.0
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = Bates
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.Bates(total_count=total_count, low=low, high=high, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def bernoulli(logits=None, probs=None, dtype=jax.numpy.int32, validate_args=False, allow_nan_stats=True, name='Bernoulli', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.Bernoulli distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                logits: Default = None
                probs: Default = None
                dtype: Default = jax.numpy.int32
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = Bernoulli
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.Bernoulli(logits=logits, probs=probs, dtype=dtype, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def beta(concentration1, concentration0, validate_args=False, allow_nan_stats=True, force_probs_to_zero_outside_support=False, name='Beta', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.Beta distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                concentration1: Default = <class 'inspect._empty'>
                concentration0: Default = <class 'inspect._empty'>
                validate_args: Default = False
                allow_nan_stats: Default = True
                force_probs_to_zero_outside_support: Default = False
                name: Default = Beta
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.Beta(concentration1=concentration1, concentration0=concentration0, validate_args=validate_args, allow_nan_stats=allow_nan_stats, force_probs_to_zero_outside_support=force_probs_to_zero_outside_support, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def beta_binomial(total_count, concentration1, concentration0, validate_args=False, allow_nan_stats=True, name='BetaBinomial', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.BetaBinomial distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                total_count: Default = <class 'inspect._empty'>
                concentration1: Default = <class 'inspect._empty'>
                concentration0: Default = <class 'inspect._empty'>
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = BetaBinomial
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.BetaBinomial(total_count=total_count, concentration1=concentration1, concentration0=concentration0, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def beta_quotient(concentration1_numerator, concentration0_numerator, concentration1_denominator, concentration0_denominator, validate_args=False, allow_nan_stats=True, name='BetaQuotient', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.BetaQuotient distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                concentration1_numerator: Default = <class 'inspect._empty'>
                concentration0_numerator: Default = <class 'inspect._empty'>
                concentration1_denominator: Default = <class 'inspect._empty'>
                concentration0_denominator: Default = <class 'inspect._empty'>
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = BetaQuotient
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.BetaQuotient(concentration1_numerator=concentration1_numerator, concentration0_numerator=concentration0_numerator, concentration1_denominator=concentration1_denominator, concentration0_denominator=concentration0_denominator, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def binomial(total_count, logits=None, probs=None, validate_args=False, allow_nan_stats=True, name=None, shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.Binomial distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                total_count: Default = <class 'inspect._empty'>
                logits: Default = None
                probs: Default = None
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = None
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.Binomial(total_count=total_count, logits=logits, probs=probs, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def blockwise(shape=(), sample=False, seed=0, obs=None, wrap=True, *args, **kwargs):
        """
        Wrapper for the tfd.Blockwise distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                args: Default = <class 'inspect._empty'>
                kwargs: Default = <class 'inspect._empty'>
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.Blockwise(*args, **kwargs)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def categorical(logits=None, probs=None, dtype=jax.numpy.int32, force_probs_to_zero_outside_support=False, validate_args=False, allow_nan_stats=True, name='Categorical', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.Categorical distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                logits: Default = None
                probs: Default = None
                dtype: Default = jax.numpy.int32
                force_probs_to_zero_outside_support: Default = False
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = Categorical
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.Categorical(logits=logits, probs=probs, dtype=dtype, force_probs_to_zero_outside_support=force_probs_to_zero_outside_support, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def cauchy(loc, scale, validate_args=False, allow_nan_stats=True, name='Cauchy', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.Cauchy distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                loc: Default = <class 'inspect._empty'>
                scale: Default = <class 'inspect._empty'>
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = Cauchy
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.Cauchy(loc=loc, scale=scale, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def chi(df, validate_args=False, allow_nan_stats=True, name='Chi', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.Chi distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                df: Default = <class 'inspect._empty'>
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = Chi
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.Chi(df=df, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def chi2(df, validate_args=False, allow_nan_stats=True, name='Chi2', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.Chi2 distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                df: Default = <class 'inspect._empty'>
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = Chi2
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.Chi2(df=df, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def cholesky_l_k_j(dimension, concentration, validate_args=False, allow_nan_stats=True, name='CholeskyLKJ', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.CholeskyLKJ distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                dimension: Default = <class 'inspect._empty'>
                concentration: Default = <class 'inspect._empty'>
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = CholeskyLKJ
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.CholeskyLKJ(dimension=dimension, concentration=concentration, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def continuous_bernoulli(logits=None, probs=None, dtype=jax.numpy.float32, validate_args=False, allow_nan_stats=True, name='ContinuousBernoulli', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.ContinuousBernoulli distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                logits: Default = None
                probs: Default = None
                dtype: Default = jax.numpy.float32
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = ContinuousBernoulli
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.ContinuousBernoulli(logits=logits, probs=probs, dtype=dtype, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def determinantal_point_process(eigenvalues, eigenvectors, validate_args=False, allow_nan_stats=False, name='DeterminantalPointProcess', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.DeterminantalPointProcess distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                eigenvalues: Default = <class 'inspect._empty'>
                eigenvectors: Default = <class 'inspect._empty'>
                validate_args: Default = False
                allow_nan_stats: Default = False
                name: Default = DeterminantalPointProcess
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.DeterminantalPointProcess(eigenvalues=eigenvalues, eigenvectors=eigenvectors, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def deterministic(loc, atol=None, rtol=None, validate_args=False, allow_nan_stats=True, name='Deterministic', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.Deterministic distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                loc: Default = <class 'inspect._empty'>
                atol: Default = None
                rtol: Default = None
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = Deterministic
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.Deterministic(loc=loc, atol=atol, rtol=rtol, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def dirichlet(concentration, validate_args=False, allow_nan_stats=True, force_probs_to_zero_outside_support=False, name='Dirichlet', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.Dirichlet distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                concentration: Default = <class 'inspect._empty'>
                validate_args: Default = False
                allow_nan_stats: Default = True
                force_probs_to_zero_outside_support: Default = False
                name: Default = Dirichlet
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.Dirichlet(concentration=concentration, validate_args=validate_args, allow_nan_stats=allow_nan_stats, force_probs_to_zero_outside_support=force_probs_to_zero_outside_support, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def dirichlet_multinomial(total_count, concentration, validate_args=False, allow_nan_stats=True, name='DirichletMultinomial', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.DirichletMultinomial distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                total_count: Default = <class 'inspect._empty'>
                concentration: Default = <class 'inspect._empty'>
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = DirichletMultinomial
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.DirichletMultinomial(total_count=total_count, concentration=concentration, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def distribution(dtype, reparameterization_type, validate_args, allow_nan_stats, parameters=None, graph_parents=None, name=None, shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.Distribution distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                dtype: Default = <class 'inspect._empty'>
                reparameterization_type: Default = <class 'inspect._empty'>
                validate_args: Default = <class 'inspect._empty'>
                allow_nan_stats: Default = <class 'inspect._empty'>
                parameters: Default = None
                graph_parents: Default = None
                name: Default = None
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.Distribution(dtype=dtype, reparameterization_type=reparameterization_type, validate_args=validate_args, allow_nan_stats=allow_nan_stats, parameters=parameters, graph_parents=graph_parents, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def doublesided_maxwell(loc, scale, validate_args=False, allow_nan_stats=True, name='doublesided_maxwell', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.DoublesidedMaxwell distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                loc: Default = <class 'inspect._empty'>
                scale: Default = <class 'inspect._empty'>
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = doublesided_maxwell
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.DoublesidedMaxwell(loc=loc, scale=scale, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def empirical(samples, event_ndims=0, validate_args=False, allow_nan_stats=True, name='Empirical', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.Empirical distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                samples: Default = <class 'inspect._empty'>
                event_ndims: Default = 0
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = Empirical
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.Empirical(samples=samples, event_ndims=event_ndims, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def exp_gamma(concentration, rate=None, log_rate=None, validate_args=False, allow_nan_stats=True, name='ExpGamma', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.ExpGamma distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                concentration: Default = <class 'inspect._empty'>
                rate: Default = None
                log_rate: Default = None
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = ExpGamma
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.ExpGamma(concentration=concentration, rate=rate, log_rate=log_rate, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def exp_inverse_gamma(concentration, scale=None, log_scale=None, validate_args=False, allow_nan_stats=True, name='ExpInverseGamma', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.ExpInverseGamma distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                concentration: Default = <class 'inspect._empty'>
                scale: Default = None
                log_scale: Default = None
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = ExpInverseGamma
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.ExpInverseGamma(concentration=concentration, scale=scale, log_scale=log_scale, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def exp_relaxed_one_hot_categorical(temperature, logits=None, probs=None, validate_args=False, allow_nan_stats=True, name='ExpRelaxedOneHotCategorical', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.ExpRelaxedOneHotCategorical distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                temperature: Default = <class 'inspect._empty'>
                logits: Default = None
                probs: Default = None
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = ExpRelaxedOneHotCategorical
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.ExpRelaxedOneHotCategorical(temperature=temperature, logits=logits, probs=probs, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def exponential(rate, force_probs_to_zero_outside_support=False, validate_args=False, allow_nan_stats=True, name='Exponential', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.Exponential distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                rate: Default = <class 'inspect._empty'>
                force_probs_to_zero_outside_support: Default = False
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = Exponential
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.Exponential(rate=rate, force_probs_to_zero_outside_support=force_probs_to_zero_outside_support, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def exponentially_modified_gaussian(loc, scale, rate, validate_args=False, allow_nan_stats=True, name='ExponentiallyModifiedGaussian', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.ExponentiallyModifiedGaussian distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                loc: Default = <class 'inspect._empty'>
                scale: Default = <class 'inspect._empty'>
                rate: Default = <class 'inspect._empty'>
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = ExponentiallyModifiedGaussian
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.ExponentiallyModifiedGaussian(loc=loc, scale=scale, rate=rate, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def finite_discrete(outcomes, logits=None, probs=None, rtol=None, atol=None, validate_args=False, allow_nan_stats=True, name='FiniteDiscrete', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.FiniteDiscrete distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                outcomes: Default = <class 'inspect._empty'>
                logits: Default = None
                probs: Default = None
                rtol: Default = None
                atol: Default = None
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = FiniteDiscrete
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.FiniteDiscrete(outcomes=outcomes, logits=logits, probs=probs, rtol=rtol, atol=atol, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def flat_dirichlet(concentration_shape, dtype=jax.numpy.float32, validate_args=False, allow_nan_stats=True, force_probs_to_zero_outside_support=False, name='FlatDirichlet', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.FlatDirichlet distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                concentration_shape: Default = <class 'inspect._empty'>
                dtype: Default = jax.numpy.float32
                validate_args: Default = False
                allow_nan_stats: Default = True
                force_probs_to_zero_outside_support: Default = False
                name: Default = FlatDirichlet
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.FlatDirichlet(concentration_shape=concentration_shape, dtype=dtype, validate_args=validate_args, allow_nan_stats=allow_nan_stats, force_probs_to_zero_outside_support=force_probs_to_zero_outside_support, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def gamma(concentration, rate=None, log_rate=None, validate_args=False, allow_nan_stats=True, force_probs_to_zero_outside_support=False, name='Gamma', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.Gamma distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                concentration: Default = <class 'inspect._empty'>
                rate: Default = None
                log_rate: Default = None
                validate_args: Default = False
                allow_nan_stats: Default = True
                force_probs_to_zero_outside_support: Default = False
                name: Default = Gamma
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.Gamma(concentration=concentration, rate=rate, log_rate=log_rate, validate_args=validate_args, allow_nan_stats=allow_nan_stats, force_probs_to_zero_outside_support=force_probs_to_zero_outside_support, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def gamma_gamma(concentration, mixing_concentration, mixing_rate, validate_args=False, allow_nan_stats=True, name='GammaGamma', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.GammaGamma distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                concentration: Default = <class 'inspect._empty'>
                mixing_concentration: Default = <class 'inspect._empty'>
                mixing_rate: Default = <class 'inspect._empty'>
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = GammaGamma
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.GammaGamma(concentration=concentration, mixing_concentration=mixing_concentration, mixing_rate=mixing_rate, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def gaussian_process(kernel, index_points=None, mean_fn=None, observation_noise_variance=0.0, marginal_fn=None, cholesky_fn=None, jitter=1e-06, validate_args=False, allow_nan_stats=False, parameters=None, name='GaussianProcess', _check_marginal_cholesky_fn=True, shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.GaussianProcess distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                kernel: Default = <class 'inspect._empty'>
                index_points: Default = None
                mean_fn: Default = None
                observation_noise_variance: Default = 0.0
                marginal_fn: Default = None
                cholesky_fn: Default = None
                jitter: Default = 1e-06
                validate_args: Default = False
                allow_nan_stats: Default = False
                parameters: Default = None
                name: Default = GaussianProcess
                _check_marginal_cholesky_fn: Default = True
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.GaussianProcess(kernel=kernel, index_points=index_points, mean_fn=mean_fn, observation_noise_variance=observation_noise_variance, marginal_fn=marginal_fn, cholesky_fn=cholesky_fn, jitter=jitter, validate_args=validate_args, allow_nan_stats=allow_nan_stats, parameters=parameters, name=name, _check_marginal_cholesky_fn=_check_marginal_cholesky_fn)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def gaussian_process_regression_model(kernel, index_points=None, observation_index_points=None, observations=None, observation_noise_variance=0.0, predictive_noise_variance=None, mean_fn=None, cholesky_fn=None, jitter=1e-06, validate_args=False, allow_nan_stats=False, name='GaussianProcessRegressionModel', _conditional_kernel=None, _conditional_mean_fn=None, shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.GaussianProcessRegressionModel distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                kernel: Default = <class 'inspect._empty'>
                index_points: Default = None
                observation_index_points: Default = None
                observations: Default = None
                observation_noise_variance: Default = 0.0
                predictive_noise_variance: Default = None
                mean_fn: Default = None
                cholesky_fn: Default = None
                jitter: Default = 1e-06
                validate_args: Default = False
                allow_nan_stats: Default = False
                name: Default = GaussianProcessRegressionModel
                _conditional_kernel: Default = None
                _conditional_mean_fn: Default = None
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.GaussianProcessRegressionModel(kernel=kernel, index_points=index_points, observation_index_points=observation_index_points, observations=observations, observation_noise_variance=observation_noise_variance, predictive_noise_variance=predictive_noise_variance, mean_fn=mean_fn, cholesky_fn=cholesky_fn, jitter=jitter, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name, _conditional_kernel=_conditional_kernel, _conditional_mean_fn=_conditional_mean_fn)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def generalized_extreme_value(loc, scale, concentration, validate_args=False, allow_nan_stats=True, name='GeneralizedExtremeValue', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.GeneralizedExtremeValue distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                loc: Default = <class 'inspect._empty'>
                scale: Default = <class 'inspect._empty'>
                concentration: Default = <class 'inspect._empty'>
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = GeneralizedExtremeValue
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.GeneralizedExtremeValue(loc=loc, scale=scale, concentration=concentration, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def generalized_normal(loc, scale, power, validate_args=False, allow_nan_stats=True, name='GeneralizedNormal', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.GeneralizedNormal distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                loc: Default = <class 'inspect._empty'>
                scale: Default = <class 'inspect._empty'>
                power: Default = <class 'inspect._empty'>
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = GeneralizedNormal
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.GeneralizedNormal(loc=loc, scale=scale, power=power, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def generalized_pareto(loc, scale, concentration, validate_args=False, allow_nan_stats=True, name=None, shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.GeneralizedPareto distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                loc: Default = <class 'inspect._empty'>
                scale: Default = <class 'inspect._empty'>
                concentration: Default = <class 'inspect._empty'>
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = None
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.GeneralizedPareto(loc=loc, scale=scale, concentration=concentration, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def geometric(logits=None, probs=None, force_probs_to_zero_outside_support=False, validate_args=False, allow_nan_stats=True, name='Geometric', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.Geometric distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                logits: Default = None
                probs: Default = None
                force_probs_to_zero_outside_support: Default = False
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = Geometric
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.Geometric(logits=logits, probs=probs, force_probs_to_zero_outside_support=force_probs_to_zero_outside_support, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def gumbel(loc, scale, validate_args=False, allow_nan_stats=True, name='Gumbel', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.Gumbel distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                loc: Default = <class 'inspect._empty'>
                scale: Default = <class 'inspect._empty'>
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = Gumbel
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.Gumbel(loc=loc, scale=scale, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def half_cauchy(loc, scale, validate_args=False, allow_nan_stats=True, name='HalfCauchy', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.HalfCauchy distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                loc: Default = <class 'inspect._empty'>
                scale: Default = <class 'inspect._empty'>
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = HalfCauchy
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.HalfCauchy(loc=loc, scale=scale, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def half_normal(scale, validate_args=False, allow_nan_stats=True, name='HalfNormal', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.HalfNormal distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                scale: Default = <class 'inspect._empty'>
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = HalfNormal
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.HalfNormal(scale=scale, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def half_student_t(df, loc, scale, validate_args=False, allow_nan_stats=True, name='HalfStudentT', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.HalfStudentT distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                df: Default = <class 'inspect._empty'>
                loc: Default = <class 'inspect._empty'>
                scale: Default = <class 'inspect._empty'>
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = HalfStudentT
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.HalfStudentT(df=df, loc=loc, scale=scale, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def hidden_markov_model(initial_distribution, transition_distribution, observation_distribution, num_steps, validate_args=False, allow_nan_stats=True, time_varying_transition_distribution=False, time_varying_observation_distribution=False, mask=None, name='HiddenMarkovModel', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.HiddenMarkovModel distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                initial_distribution: Default = <class 'inspect._empty'>
                transition_distribution: Default = <class 'inspect._empty'>
                observation_distribution: Default = <class 'inspect._empty'>
                num_steps: Default = <class 'inspect._empty'>
                validate_args: Default = False
                allow_nan_stats: Default = True
                time_varying_transition_distribution: Default = False
                time_varying_observation_distribution: Default = False
                mask: Default = None
                name: Default = HiddenMarkovModel
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.HiddenMarkovModel(initial_distribution=initial_distribution, transition_distribution=transition_distribution, observation_distribution=observation_distribution, num_steps=num_steps, validate_args=validate_args, allow_nan_stats=allow_nan_stats, time_varying_transition_distribution=time_varying_transition_distribution, time_varying_observation_distribution=time_varying_observation_distribution, mask=mask, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def horseshoe(scale, validate_args=False, allow_nan_stats=True, name='Horseshoe', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.Horseshoe distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                scale: Default = <class 'inspect._empty'>
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = Horseshoe
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.Horseshoe(scale=scale, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def independent(shape=(), sample=False, seed=0, obs=None, wrap=True, *args, **kwargs):
        """
        Wrapper for the tfd.Independent distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                args: Default = <class 'inspect._empty'>
                kwargs: Default = <class 'inspect._empty'>
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.Independent(*args, **kwargs)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def inflated(shape=(), sample=False, seed=0, obs=None, wrap=True, *args, **kwargs):
        """
        Wrapper for the tfd.Inflated distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                args: Default = <class 'inspect._empty'>
                kwargs: Default = <class 'inspect._empty'>
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.Inflated(*args, **kwargs)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def inverse_gamma(concentration, scale=None, validate_args=False, allow_nan_stats=True, name='InverseGamma', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.InverseGamma distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                concentration: Default = <class 'inspect._empty'>
                scale: Default = None
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = InverseGamma
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.InverseGamma(concentration=concentration, scale=scale, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def inverse_gaussian(loc, concentration, validate_args=False, allow_nan_stats=True, name='InverseGaussian', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.InverseGaussian distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                loc: Default = <class 'inspect._empty'>
                concentration: Default = <class 'inspect._empty'>
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = InverseGaussian
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.InverseGaussian(loc=loc, concentration=concentration, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def johnson_s_u(skewness, tailweight, loc, scale, validate_args=False, allow_nan_stats=True, name=None, shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.JohnsonSU distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                skewness: Default = <class 'inspect._empty'>
                tailweight: Default = <class 'inspect._empty'>
                loc: Default = <class 'inspect._empty'>
                scale: Default = <class 'inspect._empty'>
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = None
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.JohnsonSU(skewness=skewness, tailweight=tailweight, loc=loc, scale=scale, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def joint_distribution(dtype, validate_args, parameters, name, use_vectorized_map=False, batch_ndims=None, experimental_use_kahan_sum=False, shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.JointDistribution distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                dtype: Default = <class 'inspect._empty'>
                validate_args: Default = <class 'inspect._empty'>
                parameters: Default = <class 'inspect._empty'>
                name: Default = <class 'inspect._empty'>
                use_vectorized_map: Default = False
                batch_ndims: Default = None
                experimental_use_kahan_sum: Default = False
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.JointDistribution(dtype=dtype, validate_args=validate_args, parameters=parameters, name=name, use_vectorized_map=use_vectorized_map, batch_ndims=batch_ndims, experimental_use_kahan_sum=experimental_use_kahan_sum)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def joint_distribution_coroutine(model, sample_dtype=None, batch_ndims=None, use_vectorized_map=False, validate_args=False, experimental_use_kahan_sum=False, name=None, shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.JointDistributionCoroutine distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                model: Default = <class 'inspect._empty'>
                sample_dtype: Default = None
                batch_ndims: Default = None
                use_vectorized_map: Default = False
                validate_args: Default = False
                experimental_use_kahan_sum: Default = False
                name: Default = None
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.JointDistributionCoroutine(model=model, sample_dtype=sample_dtype, batch_ndims=batch_ndims, use_vectorized_map=use_vectorized_map, validate_args=validate_args, experimental_use_kahan_sum=experimental_use_kahan_sum, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def joint_distribution_coroutine_auto_batched(model, sample_dtype=None, batch_ndims=0, use_vectorized_map=True, validate_args=False, experimental_use_kahan_sum=False, name=None, shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.JointDistributionCoroutineAutoBatched distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                model: Default = <class 'inspect._empty'>
                sample_dtype: Default = None
                batch_ndims: Default = 0
                use_vectorized_map: Default = True
                validate_args: Default = False
                experimental_use_kahan_sum: Default = False
                name: Default = None
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.JointDistributionCoroutineAutoBatched(model=model, sample_dtype=sample_dtype, batch_ndims=batch_ndims, use_vectorized_map=use_vectorized_map, validate_args=validate_args, experimental_use_kahan_sum=experimental_use_kahan_sum, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def joint_distribution_named(shape=(), sample=False, seed=0, obs=None, wrap=True, *args, **kwargs):
        """
        Wrapper for the tfd.JointDistributionNamed distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                args: Default = <class 'inspect._empty'>
                kwargs: Default = <class 'inspect._empty'>
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.JointDistributionNamed(*args, **kwargs)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def joint_distribution_named_auto_batched(shape=(), sample=False, seed=0, obs=None, wrap=True, *args, **kwargs):
        """
        Wrapper for the tfd.JointDistributionNamedAutoBatched distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                args: Default = <class 'inspect._empty'>
                kwargs: Default = <class 'inspect._empty'>
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.JointDistributionNamedAutoBatched(*args, **kwargs)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def joint_distribution_sequential(shape=(), sample=False, seed=0, obs=None, wrap=True, *args, **kwargs):
        """
        Wrapper for the tfd.JointDistributionSequential distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                args: Default = <class 'inspect._empty'>
                kwargs: Default = <class 'inspect._empty'>
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.JointDistributionSequential(*args, **kwargs)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def joint_distribution_sequential_auto_batched(shape=(), sample=False, seed=0, obs=None, wrap=True, *args, **kwargs):
        """
        Wrapper for the tfd.JointDistributionSequentialAutoBatched distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                args: Default = <class 'inspect._empty'>
                kwargs: Default = <class 'inspect._empty'>
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.JointDistributionSequentialAutoBatched(*args, **kwargs)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def kumaraswamy(concentration1=1.0, concentration0=1.0, validate_args=False, allow_nan_stats=True, name='Kumaraswamy', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.Kumaraswamy distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                concentration1: Default = 1.0
                concentration0: Default = 1.0
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = Kumaraswamy
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.Kumaraswamy(concentration1=concentration1, concentration0=concentration0, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def lkj(dimension, concentration, input_output_cholesky=False, validate_args=False, allow_nan_stats=True, name='LKJ', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.LKJ distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                dimension: Default = <class 'inspect._empty'>
                concentration: Default = <class 'inspect._empty'>
                input_output_cholesky: Default = False
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = LKJ
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.LKJ(dimension=dimension, concentration=concentration, input_output_cholesky=input_output_cholesky, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def lambert_w_distribution(distribution, shift, scale, tailweight=None, validate_args=False, allow_nan_stats=True, name='LambertWDistribution', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.LambertWDistribution distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                distribution: Default = <class 'inspect._empty'>
                shift: Default = <class 'inspect._empty'>
                scale: Default = <class 'inspect._empty'>
                tailweight: Default = None
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = LambertWDistribution
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.LambertWDistribution(distribution=distribution, shift=shift, scale=scale, tailweight=tailweight, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def lambert_w_normal(loc, scale, tailweight=None, validate_args=False, allow_nan_stats=True, name='LambertWNormal', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.LambertWNormal distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                loc: Default = <class 'inspect._empty'>
                scale: Default = <class 'inspect._empty'>
                tailweight: Default = None
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = LambertWNormal
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.LambertWNormal(loc=loc, scale=scale, tailweight=tailweight, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def laplace(loc, scale, validate_args=False, allow_nan_stats=True, name='Laplace', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.Laplace distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                loc: Default = <class 'inspect._empty'>
                scale: Default = <class 'inspect._empty'>
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = Laplace
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.Laplace(loc=loc, scale=scale, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def linear_gaussian_state_space_model(num_timesteps, transition_matrix, transition_noise, observation_matrix, observation_noise, initial_state_prior, initial_step=0, mask=None, experimental_parallelize=False, validate_args=False, allow_nan_stats=True, name='LinearGaussianStateSpaceModel', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.LinearGaussianStateSpaceModel distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                num_timesteps: Default = <class 'inspect._empty'>
                transition_matrix: Default = <class 'inspect._empty'>
                transition_noise: Default = <class 'inspect._empty'>
                observation_matrix: Default = <class 'inspect._empty'>
                observation_noise: Default = <class 'inspect._empty'>
                initial_state_prior: Default = <class 'inspect._empty'>
                initial_step: Default = 0
                mask: Default = None
                experimental_parallelize: Default = False
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = LinearGaussianStateSpaceModel
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.LinearGaussianStateSpaceModel(num_timesteps=num_timesteps, transition_matrix=transition_matrix, transition_noise=transition_noise, observation_matrix=observation_matrix, observation_noise=observation_noise, initial_state_prior=initial_state_prior, initial_step=initial_step, mask=mask, experimental_parallelize=experimental_parallelize, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def log_logistic(loc, scale, validate_args=False, allow_nan_stats=True, name='LogLogistic', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.LogLogistic distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                loc: Default = <class 'inspect._empty'>
                scale: Default = <class 'inspect._empty'>
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = LogLogistic
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.LogLogistic(loc=loc, scale=scale, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def log_normal(loc, scale, validate_args=False, allow_nan_stats=True, name='LogNormal', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.LogNormal distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                loc: Default = <class 'inspect._empty'>
                scale: Default = <class 'inspect._empty'>
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = LogNormal
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.LogNormal(loc=loc, scale=scale, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def logistic(loc, scale, validate_args=False, allow_nan_stats=True, name='Logistic', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.Logistic distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                loc: Default = <class 'inspect._empty'>
                scale: Default = <class 'inspect._empty'>
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = Logistic
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.Logistic(loc=loc, scale=scale, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def logit_normal(loc, scale, num_probit_terms_approx=2, gauss_hermite_scale_limit=None, gauss_hermite_degree=20, validate_args=False, allow_nan_stats=True, name='LogitNormal', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.LogitNormal distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                loc: Default = <class 'inspect._empty'>
                scale: Default = <class 'inspect._empty'>
                num_probit_terms_approx: Default = 2
                gauss_hermite_scale_limit: Default = None
                gauss_hermite_degree: Default = 20
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = LogitNormal
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.LogitNormal(loc=loc, scale=scale, num_probit_terms_approx=num_probit_terms_approx, gauss_hermite_scale_limit=gauss_hermite_scale_limit, gauss_hermite_degree=gauss_hermite_degree, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def markov_chain(initial_state_prior, transition_fn, num_steps, experimental_use_kahan_sum=False, validate_args=False, name='MarkovChain', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.MarkovChain distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                initial_state_prior: Default = <class 'inspect._empty'>
                transition_fn: Default = <class 'inspect._empty'>
                num_steps: Default = <class 'inspect._empty'>
                experimental_use_kahan_sum: Default = False
                validate_args: Default = False
                name: Default = MarkovChain
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.MarkovChain(initial_state_prior=initial_state_prior, transition_fn=transition_fn, num_steps=num_steps, experimental_use_kahan_sum=experimental_use_kahan_sum, validate_args=validate_args, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def masked(shape=(), sample=False, seed=0, obs=None, wrap=True, *args, **kwargs):
        """
        Wrapper for the tfd.Masked distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                args: Default = <class 'inspect._empty'>
                kwargs: Default = <class 'inspect._empty'>
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.Masked(*args, **kwargs)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def matrix_normal_linear_operator(loc, scale_row, scale_column, validate_args=False, allow_nan_stats=True, name='MatrixNormalLinearOperator', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.MatrixNormalLinearOperator distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                loc: Default = <class 'inspect._empty'>
                scale_row: Default = <class 'inspect._empty'>
                scale_column: Default = <class 'inspect._empty'>
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = MatrixNormalLinearOperator
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.MatrixNormalLinearOperator(loc=loc, scale_row=scale_row, scale_column=scale_column, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def matrix_t_linear_operator(df, loc, scale_row, scale_column, validate_args=False, allow_nan_stats=True, name='MatrixTLinearOperator', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.MatrixTLinearOperator distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                df: Default = <class 'inspect._empty'>
                loc: Default = <class 'inspect._empty'>
                scale_row: Default = <class 'inspect._empty'>
                scale_column: Default = <class 'inspect._empty'>
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = MatrixTLinearOperator
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.MatrixTLinearOperator(df=df, loc=loc, scale_row=scale_row, scale_column=scale_column, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def mixture(shape=(), sample=False, seed=0, obs=None, wrap=True, *args, **kwargs):
        """
        Wrapper for the tfd.Mixture distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                args: Default = <class 'inspect._empty'>
                kwargs: Default = <class 'inspect._empty'>
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.Mixture(*args, **kwargs)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def mixture_same_family(shape=(), sample=False, seed=0, obs=None, wrap=True, *args, **kwargs):
        """
        Wrapper for the tfd.MixtureSameFamily distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                args: Default = <class 'inspect._empty'>
                kwargs: Default = <class 'inspect._empty'>
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.MixtureSameFamily(*args, **kwargs)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def moyal(loc, scale, validate_args=False, allow_nan_stats=True, name='Moyal', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.Moyal distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                loc: Default = <class 'inspect._empty'>
                scale: Default = <class 'inspect._empty'>
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = Moyal
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.Moyal(loc=loc, scale=scale, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def multinomial(total_count, logits=None, probs=None, validate_args=False, allow_nan_stats=True, name='Multinomial', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.Multinomial distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                total_count: Default = <class 'inspect._empty'>
                logits: Default = None
                probs: Default = None
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = Multinomial
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.Multinomial(total_count=total_count, logits=logits, probs=probs, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def multivariate_normal_diag(loc=None, scale_diag=None, validate_args=False, allow_nan_stats=True, experimental_use_kahan_sum=False, name='MultivariateNormalDiag', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.MultivariateNormalDiag distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                loc: Default = None
                scale_diag: Default = None
                validate_args: Default = False
                allow_nan_stats: Default = True
                experimental_use_kahan_sum: Default = False
                name: Default = MultivariateNormalDiag
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.MultivariateNormalDiag(loc=loc, scale_diag=scale_diag, validate_args=validate_args, allow_nan_stats=allow_nan_stats, experimental_use_kahan_sum=experimental_use_kahan_sum, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def multivariate_normal_diag_plus_low_rank(loc=None, scale_diag=None, scale_perturb_factor=None, scale_perturb_diag=None, validate_args=False, allow_nan_stats=True, name='MultivariateNormalDiagPlusLowRank', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.MultivariateNormalDiagPlusLowRank distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                loc: Default = None
                scale_diag: Default = None
                scale_perturb_factor: Default = None
                scale_perturb_diag: Default = None
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = MultivariateNormalDiagPlusLowRank
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.MultivariateNormalDiagPlusLowRank(loc=loc, scale_diag=scale_diag, scale_perturb_factor=scale_perturb_factor, scale_perturb_diag=scale_perturb_diag, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def multivariate_normal_diag_plus_low_rank_covariance(loc=None, cov_diag_factor=None, cov_perturb_factor=None, validate_args=False, allow_nan_stats=True, name='MultivariateNormalDiagPlusLowRankCovariance', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.MultivariateNormalDiagPlusLowRankCovariance distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                loc: Default = None
                cov_diag_factor: Default = None
                cov_perturb_factor: Default = None
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = MultivariateNormalDiagPlusLowRankCovariance
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.MultivariateNormalDiagPlusLowRankCovariance(loc=loc, cov_diag_factor=cov_diag_factor, cov_perturb_factor=cov_perturb_factor, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def multivariate_normal_full_covariance(loc=None, covariance_matrix=None, validate_args=False, allow_nan_stats=True, name='MultivariateNormalFullCovariance', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.MultivariateNormalFullCovariance distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                loc: Default = None
                covariance_matrix: Default = None
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = MultivariateNormalFullCovariance
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.MultivariateNormalFullCovariance(loc=loc, covariance_matrix=covariance_matrix, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def multivariate_normal_linear_operator(loc=None, scale=None, validate_args=False, allow_nan_stats=True, experimental_use_kahan_sum=False, name='MultivariateNormalLinearOperator', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.MultivariateNormalLinearOperator distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                loc: Default = None
                scale: Default = None
                validate_args: Default = False
                allow_nan_stats: Default = True
                experimental_use_kahan_sum: Default = False
                name: Default = MultivariateNormalLinearOperator
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.MultivariateNormalLinearOperator(loc=loc, scale=scale, validate_args=validate_args, allow_nan_stats=allow_nan_stats, experimental_use_kahan_sum=experimental_use_kahan_sum, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def multivariate_normal_tri_l(loc=None, scale_tril=None, validate_args=False, allow_nan_stats=True, experimental_use_kahan_sum=False, name='MultivariateNormalTriL', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.MultivariateNormalTriL distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                loc: Default = None
                scale_tril: Default = None
                validate_args: Default = False
                allow_nan_stats: Default = True
                experimental_use_kahan_sum: Default = False
                name: Default = MultivariateNormalTriL
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.MultivariateNormalTriL(loc=loc, scale_tril=scale_tril, validate_args=validate_args, allow_nan_stats=allow_nan_stats, experimental_use_kahan_sum=experimental_use_kahan_sum, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def multivariate_student_t_linear_operator(df, loc, scale, validate_args=False, allow_nan_stats=True, name='MultivariateStudentTLinearOperator', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.MultivariateStudentTLinearOperator distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                df: Default = <class 'inspect._empty'>
                loc: Default = <class 'inspect._empty'>
                scale: Default = <class 'inspect._empty'>
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = MultivariateStudentTLinearOperator
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.MultivariateStudentTLinearOperator(df=df, loc=loc, scale=scale, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def negative_binomial(total_count, logits=None, probs=None, validate_args=False, allow_nan_stats=True, require_integer_total_count=True, name='NegativeBinomial', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.NegativeBinomial distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                total_count: Default = <class 'inspect._empty'>
                logits: Default = None
                probs: Default = None
                validate_args: Default = False
                allow_nan_stats: Default = True
                require_integer_total_count: Default = True
                name: Default = NegativeBinomial
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.NegativeBinomial(total_count=total_count, logits=logits, probs=probs, validate_args=validate_args, allow_nan_stats=allow_nan_stats, require_integer_total_count=require_integer_total_count, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def noncentral_chi2(df, noncentrality, validate_args=False, allow_nan_stats=True, name='NoncentralChi2', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.NoncentralChi2 distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                df: Default = <class 'inspect._empty'>
                noncentrality: Default = <class 'inspect._empty'>
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = NoncentralChi2
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.NoncentralChi2(df=df, noncentrality=noncentrality, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def normal(loc, scale, validate_args=False, allow_nan_stats=True, name='Normal', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.Normal distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                loc: Default = <class 'inspect._empty'>
                scale: Default = <class 'inspect._empty'>
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = Normal
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.Normal(loc=loc, scale=scale, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def normal_inverse_gaussian(loc, scale, tailweight, skewness, validate_args=False, allow_nan_stats=True, name='NormalInverseGaussian', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.NormalInverseGaussian distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                loc: Default = <class 'inspect._empty'>
                scale: Default = <class 'inspect._empty'>
                tailweight: Default = <class 'inspect._empty'>
                skewness: Default = <class 'inspect._empty'>
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = NormalInverseGaussian
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.NormalInverseGaussian(loc=loc, scale=scale, tailweight=tailweight, skewness=skewness, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def one_hot_categorical(logits=None, probs=None, dtype=jax.numpy.int32, validate_args=False, allow_nan_stats=True, name='OneHotCategorical', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.OneHotCategorical distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                logits: Default = None
                probs: Default = None
                dtype: Default = jax.numpy.int32
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = OneHotCategorical
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.OneHotCategorical(logits=logits, probs=probs, dtype=dtype, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def ordered_logistic(cutpoints, loc, dtype=jax.numpy.int32, validate_args=False, allow_nan_stats=True, name='OrderedLogistic', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.OrderedLogistic distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                cutpoints: Default = <class 'inspect._empty'>
                loc: Default = <class 'inspect._empty'>
                dtype: Default = jax.numpy.int32
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = OrderedLogistic
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.OrderedLogistic(cutpoints=cutpoints, loc=loc, dtype=dtype, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def p_e_r_t(low, peak, high, temperature=4.0, validate_args=False, allow_nan_stats=False, name='PERT', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.PERT distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                low: Default = <class 'inspect._empty'>
                peak: Default = <class 'inspect._empty'>
                high: Default = <class 'inspect._empty'>
                temperature: Default = 4.0
                validate_args: Default = False
                allow_nan_stats: Default = False
                name: Default = PERT
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.PERT(low=low, peak=peak, high=high, temperature=temperature, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def pareto(concentration, scale=1.0, validate_args=False, allow_nan_stats=True, name='Pareto', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.Pareto distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                concentration: Default = <class 'inspect._empty'>
                scale: Default = 1.0
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = Pareto
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.Pareto(concentration=concentration, scale=scale, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def plackett_luce(scores, dtype=jax.numpy.int32, validate_args=False, allow_nan_stats=True, name='PlackettLuce', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.PlackettLuce distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                scores: Default = <class 'inspect._empty'>
                dtype: Default = jax.numpy.int32
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = PlackettLuce
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.PlackettLuce(scores=scores, dtype=dtype, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def poisson(rate=None, log_rate=None, force_probs_to_zero_outside_support=False, validate_args=False, allow_nan_stats=True, name='Poisson', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.Poisson distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                rate: Default = None
                log_rate: Default = None
                force_probs_to_zero_outside_support: Default = False
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = Poisson
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.Poisson(rate=rate, log_rate=log_rate, force_probs_to_zero_outside_support=force_probs_to_zero_outside_support, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def poisson_log_normal_quadrature_compound(loc, scale, quadrature_size=8, quadrature_fn=tfd.quadrature_scheme_lognormal_quantiles, validate_args=False, allow_nan_stats=True, name='PoissonLogNormalQuadratureCompound', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.PoissonLogNormalQuadratureCompound distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                loc: Default = <class 'inspect._empty'>
                scale: Default = <class 'inspect._empty'>
                quadrature_size: Default = 8
                quadrature_fn: Default = <function quadrature_scheme_lognormal_quantiles at 0x7160e2ca5a80>
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = PoissonLogNormalQuadratureCompound
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.PoissonLogNormalQuadratureCompound(loc=loc, scale=scale, quadrature_size=quadrature_size, quadrature_fn=quadrature_fn, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def power_spherical(mean_direction, concentration, validate_args=False, allow_nan_stats=True, name='PowerSpherical', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.PowerSpherical distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                mean_direction: Default = <class 'inspect._empty'>
                concentration: Default = <class 'inspect._empty'>
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = PowerSpherical
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.PowerSpherical(mean_direction=mean_direction, concentration=concentration, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def probit_bernoulli(probits=None, probs=None, dtype=jax.numpy.int32, validate_args=False, allow_nan_stats=True, name='ProbitBernoulli', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.ProbitBernoulli distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                probits: Default = None
                probs: Default = None
                dtype: Default = jax.numpy.int32
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = ProbitBernoulli
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.ProbitBernoulli(probits=probits, probs=probs, dtype=dtype, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def quantized_distribution(shape=(), sample=False, seed=0, obs=None, wrap=True, *args, **kwargs):
        """
        Wrapper for the tfd.QuantizedDistribution distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                args: Default = <class 'inspect._empty'>
                kwargs: Default = <class 'inspect._empty'>
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.QuantizedDistribution(*args, **kwargs)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def register_k_l(dist_cls_a, dist_cls_b, shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.RegisterKL distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                dist_cls_a: Default = <class 'inspect._empty'>
                dist_cls_b: Default = <class 'inspect._empty'>
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.RegisterKL(dist_cls_a=dist_cls_a, dist_cls_b=dist_cls_b)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def relaxed_bernoulli(temperature, logits=None, probs=None, validate_args=False, allow_nan_stats=True, name='RelaxedBernoulli', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.RelaxedBernoulli distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                temperature: Default = <class 'inspect._empty'>
                logits: Default = None
                probs: Default = None
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = RelaxedBernoulli
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.RelaxedBernoulli(temperature=temperature, logits=logits, probs=probs, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def relaxed_one_hot_categorical(temperature, logits=None, probs=None, validate_args=False, allow_nan_stats=True, name='RelaxedOneHotCategorical', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.RelaxedOneHotCategorical distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                temperature: Default = <class 'inspect._empty'>
                logits: Default = None
                probs: Default = None
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = RelaxedOneHotCategorical
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.RelaxedOneHotCategorical(temperature=temperature, logits=logits, probs=probs, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def reparameterization_type(rep_type, shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.ReparameterizationType distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                rep_type: Default = <class 'inspect._empty'>
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.ReparameterizationType(rep_type=rep_type)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def sample(shape=(), sample=False, seed=0, obs=None, wrap=True, *args, **kwargs):
        """
        Wrapper for the tfd.Sample distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                args: Default = <class 'inspect._empty'>
                kwargs: Default = <class 'inspect._empty'>
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.Sample(*args, **kwargs)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def sigmoid_beta(concentration1, concentration0, validate_args=False, allow_nan_stats=True, name='SigmoidBeta', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.SigmoidBeta distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                concentration1: Default = <class 'inspect._empty'>
                concentration0: Default = <class 'inspect._empty'>
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = SigmoidBeta
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.SigmoidBeta(concentration1=concentration1, concentration0=concentration0, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def sinh_arcsinh(loc, scale, skewness=None, tailweight=None, distribution=None, validate_args=False, allow_nan_stats=True, name='SinhArcsinh', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.SinhArcsinh distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                loc: Default = <class 'inspect._empty'>
                scale: Default = <class 'inspect._empty'>
                skewness: Default = None
                tailweight: Default = None
                distribution: Default = None
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = SinhArcsinh
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.SinhArcsinh(loc=loc, scale=scale, skewness=skewness, tailweight=tailweight, distribution=distribution, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def skellam(rate1=None, rate2=None, log_rate1=None, log_rate2=None, force_probs_to_zero_outside_support=False, validate_args=False, allow_nan_stats=True, name='Skellam', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.Skellam distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                rate1: Default = None
                rate2: Default = None
                log_rate1: Default = None
                log_rate2: Default = None
                force_probs_to_zero_outside_support: Default = False
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = Skellam
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.Skellam(rate1=rate1, rate2=rate2, log_rate1=log_rate1, log_rate2=log_rate2, force_probs_to_zero_outside_support=force_probs_to_zero_outside_support, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def spherical_uniform(dimension, batch_shape=(), dtype=jax.numpy.float32, validate_args=False, allow_nan_stats=True, name='SphericalUniform', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.SphericalUniform distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                dimension: Default = <class 'inspect._empty'>
                batch_shape: Default = ()
                dtype: Default = jax.numpy.float32
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = SphericalUniform
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.SphericalUniform(dimension=dimension, batch_shape=batch_shape, dtype=dtype, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def stopping_ratio_logistic(cutpoints, loc, dtype=jax.numpy.int32, validate_args=False, allow_nan_stats=True, name='StoppingRatioLogistic', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.StoppingRatioLogistic distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                cutpoints: Default = <class 'inspect._empty'>
                loc: Default = <class 'inspect._empty'>
                dtype: Default = jax.numpy.int32
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = StoppingRatioLogistic
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.StoppingRatioLogistic(cutpoints=cutpoints, loc=loc, dtype=dtype, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def student_t(df, loc, scale, validate_args=False, allow_nan_stats=True, name='StudentT', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.StudentT distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                df: Default = <class 'inspect._empty'>
                loc: Default = <class 'inspect._empty'>
                scale: Default = <class 'inspect._empty'>
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = StudentT
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.StudentT(df=df, loc=loc, scale=scale, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def student_t_process(df, kernel, index_points=None, mean_fn=None, observation_noise_variance=0.0, marginal_fn=None, cholesky_fn=None, jitter=1e-06, always_yield_multivariate_student_t=None, validate_args=False, allow_nan_stats=False, name='StudentTProcess', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.StudentTProcess distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                df: Default = <class 'inspect._empty'>
                kernel: Default = <class 'inspect._empty'>
                index_points: Default = None
                mean_fn: Default = None
                observation_noise_variance: Default = 0.0
                marginal_fn: Default = None
                cholesky_fn: Default = None
                jitter: Default = 1e-06
                always_yield_multivariate_student_t: Default = None
                validate_args: Default = False
                allow_nan_stats: Default = False
                name: Default = StudentTProcess
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.StudentTProcess(df=df, kernel=kernel, index_points=index_points, mean_fn=mean_fn, observation_noise_variance=observation_noise_variance, marginal_fn=marginal_fn, cholesky_fn=cholesky_fn, jitter=jitter, always_yield_multivariate_student_t=always_yield_multivariate_student_t, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def student_t_process_regression_model(df, kernel, index_points=None, observation_index_points=None, observations=None, observation_noise_variance=0.0, predictive_noise_variance=None, mean_fn=None, cholesky_fn=None, marginal_fn=None, always_yield_multivariate_student_t=None, validate_args=False, allow_nan_stats=False, name='StudentTProcessRegressionModel', _conditional_kernel=None, _conditional_mean_fn=None, shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.StudentTProcessRegressionModel distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                df: Default = <class 'inspect._empty'>
                kernel: Default = <class 'inspect._empty'>
                index_points: Default = None
                observation_index_points: Default = None
                observations: Default = None
                observation_noise_variance: Default = 0.0
                predictive_noise_variance: Default = None
                mean_fn: Default = None
                cholesky_fn: Default = None
                marginal_fn: Default = None
                always_yield_multivariate_student_t: Default = None
                validate_args: Default = False
                allow_nan_stats: Default = False
                name: Default = StudentTProcessRegressionModel
                _conditional_kernel: Default = None
                _conditional_mean_fn: Default = None
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.StudentTProcessRegressionModel(df=df, kernel=kernel, index_points=index_points, observation_index_points=observation_index_points, observations=observations, observation_noise_variance=observation_noise_variance, predictive_noise_variance=predictive_noise_variance, mean_fn=mean_fn, cholesky_fn=cholesky_fn, marginal_fn=marginal_fn, always_yield_multivariate_student_t=always_yield_multivariate_student_t, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name, _conditional_kernel=_conditional_kernel, _conditional_mean_fn=_conditional_mean_fn)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def transformed_distribution(shape=(), sample=False, seed=0, obs=None, wrap=True, *args, **kwargs):
        """
        Wrapper for the tfd.TransformedDistribution distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                args: Default = <class 'inspect._empty'>
                kwargs: Default = <class 'inspect._empty'>
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.TransformedDistribution(*args, **kwargs)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def triangular(low=0.0, high=1.0, peak=0.5, validate_args=False, allow_nan_stats=True, name='Triangular', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.Triangular distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                low: Default = 0.0
                high: Default = 1.0
                peak: Default = 0.5
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = Triangular
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.Triangular(low=low, high=high, peak=peak, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def truncated_cauchy(loc, scale, low, high, validate_args=False, allow_nan_stats=True, name='TruncatedCauchy', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.TruncatedCauchy distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                loc: Default = <class 'inspect._empty'>
                scale: Default = <class 'inspect._empty'>
                low: Default = <class 'inspect._empty'>
                high: Default = <class 'inspect._empty'>
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = TruncatedCauchy
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.TruncatedCauchy(loc=loc, scale=scale, low=low, high=high, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def truncated_normal(loc, scale, low, high, validate_args=False, allow_nan_stats=True, name='TruncatedNormal', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.TruncatedNormal distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                loc: Default = <class 'inspect._empty'>
                scale: Default = <class 'inspect._empty'>
                low: Default = <class 'inspect._empty'>
                high: Default = <class 'inspect._empty'>
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = TruncatedNormal
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.TruncatedNormal(loc=loc, scale=scale, low=low, high=high, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def two_piece_normal(loc, scale, skewness, validate_args=False, allow_nan_stats=True, name='TwoPieceNormal', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.TwoPieceNormal distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                loc: Default = <class 'inspect._empty'>
                scale: Default = <class 'inspect._empty'>
                skewness: Default = <class 'inspect._empty'>
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = TwoPieceNormal
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.TwoPieceNormal(loc=loc, scale=scale, skewness=skewness, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def two_piece_student_t(df, loc, scale, skewness, validate_args=False, allow_nan_stats=True, name='TwoPieceStudentT', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.TwoPieceStudentT distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                df: Default = <class 'inspect._empty'>
                loc: Default = <class 'inspect._empty'>
                scale: Default = <class 'inspect._empty'>
                skewness: Default = <class 'inspect._empty'>
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = TwoPieceStudentT
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.TwoPieceStudentT(df=df, loc=loc, scale=scale, skewness=skewness, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def uniform(low=0.0, high=1.0, validate_args=False, allow_nan_stats=True, name='Uniform', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.Uniform distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                low: Default = 0.0
                high: Default = 1.0
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = Uniform
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.Uniform(low=low, high=high, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def variational_gaussian_process(kernel, index_points, inducing_index_points, variational_inducing_observations_loc, variational_inducing_observations_scale, mean_fn=None, observation_noise_variance=None, predictive_noise_variance=None, cholesky_fn=None, use_whitening_transform=False, jitter=1e-06, validate_args=False, allow_nan_stats=False, name='VariationalGaussianProcess', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.VariationalGaussianProcess distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                kernel: Default = <class 'inspect._empty'>
                index_points: Default = <class 'inspect._empty'>
                inducing_index_points: Default = <class 'inspect._empty'>
                variational_inducing_observations_loc: Default = <class 'inspect._empty'>
                variational_inducing_observations_scale: Default = <class 'inspect._empty'>
                mean_fn: Default = None
                observation_noise_variance: Default = None
                predictive_noise_variance: Default = None
                cholesky_fn: Default = None
                use_whitening_transform: Default = False
                jitter: Default = 1e-06
                validate_args: Default = False
                allow_nan_stats: Default = False
                name: Default = VariationalGaussianProcess
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.VariationalGaussianProcess(kernel=kernel, index_points=index_points, inducing_index_points=inducing_index_points, variational_inducing_observations_loc=variational_inducing_observations_loc, variational_inducing_observations_scale=variational_inducing_observations_scale, mean_fn=mean_fn, observation_noise_variance=observation_noise_variance, predictive_noise_variance=predictive_noise_variance, cholesky_fn=cholesky_fn, use_whitening_transform=use_whitening_transform, jitter=jitter, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def vector_deterministic(loc, atol=None, rtol=None, validate_args=False, allow_nan_stats=True, name='VectorDeterministic', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.VectorDeterministic distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                loc: Default = <class 'inspect._empty'>
                atol: Default = None
                rtol: Default = None
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = VectorDeterministic
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.VectorDeterministic(loc=loc, atol=atol, rtol=rtol, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def von_mises(loc, concentration, validate_args=False, allow_nan_stats=True, name='VonMises', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.VonMises distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                loc: Default = <class 'inspect._empty'>
                concentration: Default = <class 'inspect._empty'>
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = VonMises
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.VonMises(loc=loc, concentration=concentration, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def von_mises_fisher(mean_direction, concentration, validate_args=False, allow_nan_stats=True, name='VonMisesFisher', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.VonMisesFisher distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                mean_direction: Default = <class 'inspect._empty'>
                concentration: Default = <class 'inspect._empty'>
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = VonMisesFisher
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.VonMisesFisher(mean_direction=mean_direction, concentration=concentration, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def weibull(concentration, scale, validate_args=False, allow_nan_stats=True, name='Weibull', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.Weibull distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                concentration: Default = <class 'inspect._empty'>
                scale: Default = <class 'inspect._empty'>
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = Weibull
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.Weibull(concentration=concentration, scale=scale, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def wishart_linear_operator(df, scale, input_output_cholesky=False, validate_args=False, allow_nan_stats=True, name='WishartLinearOperator', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.WishartLinearOperator distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                df: Default = <class 'inspect._empty'>
                scale: Default = <class 'inspect._empty'>
                input_output_cholesky: Default = False
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = WishartLinearOperator
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.WishartLinearOperator(df=df, scale=scale, input_output_cholesky=input_output_cholesky, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def wishart_tri_l(df, scale_tril=None, input_output_cholesky=False, validate_args=False, allow_nan_stats=True, name='WishartTriL', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.WishartTriL distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                df: Default = <class 'inspect._empty'>
                scale_tril: Default = None
                input_output_cholesky: Default = False
                validate_args: Default = False
                allow_nan_stats: Default = True
                name: Default = WishartTriL
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.WishartTriL(df=df, scale_tril=scale_tril, input_output_cholesky=input_output_cholesky, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def zero_inflated_negative_binomial(inflated_loc_logits=None, inflated_loc_probs=None, name='ZeroInflatedNegativeBinomial', shape=(), sample=False, seed=0, obs=None, wrap=True, **kwargs):
        """
        Wrapper for the tfd.ZeroInflatedNegativeBinomial distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                inflated_loc_logits: Default = None
                inflated_loc_probs: Default = None
                name: Default = ZeroInflatedNegativeBinomial
                kwargs: Default = <class 'inspect._empty'>
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.ZeroInflatedNegativeBinomial(inflated_loc_logits=inflated_loc_logits, inflated_loc_probs=inflated_loc_probs, name=name, kwargs=kwargs)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


    @staticmethod
    def zipf(power, dtype=jax.numpy.int32, force_probs_to_zero_outside_support=False, sample_maximum_iterations=100, validate_args=False, allow_nan_stats=False, name='Zipf', shape=(), sample=False, seed=0, obs=None, wrap=True):
        """
        Wrapper for the tfd.Zipf distribution.
        
            This method can either return a distribution object for use in a
            probabilistic model or directly return samples.
        
            Original TFP Arguments:
                power: Default = <class 'inspect._empty'>
                dtype: Default = jax.numpy.int32
                force_probs_to_zero_outside_support: Default = False
                sample_maximum_iterations: Default = 100
                validate_args: Default = False
                allow_nan_stats: Default = False
                name: Default = Zipf
        
            Wrapper Arguments:
                shape (tuple): The shape of the sample. Defaults to ().
                sample (bool): If True, draw samples from the distribution. 
                               If False, return a Root distribution object. Defaults to False.
                seed (int): The PRNG seed for sampling. Defaults to 0.
        """
        dist = tfd.Zipf(power=power, dtype=dtype, force_probs_to_zero_outside_support=force_probs_to_zero_outside_support, sample_maximum_iterations=sample_maximum_iterations, validate_args=validate_args, allow_nan_stats=allow_nan_stats, name=name)
        if sample:
            prng_key = jax.random.PRNGKey(seed)
            return dist.sample(sample_shape=shape, seed=prng_key)
        if obs is not None:
             final_dist = tfd.Independent(dist, reinterpreted_batch_ndims=shape)
        else:
             final_dist = tfd.Sample(dist, sample_shape=shape) if shape else dist
        if wrap:
            return root(final_dist)
        else:
            return final_dist


