"use strict";
var _a, _b, _c, _d, _e;
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("aws-cdk-lib");
const r53 = require("aws-cdk-lib/aws-route53");
const s3 = require("aws-cdk-lib/aws-s3");
const _1 = require(".");
const devEnv = {
    account: process.env.CDK_DEFAULT_ACCOUNT,
    region: process.env.CDK_DEFAULT_REGION,
};
const app = new cdk.App();
const stack = new cdk.Stack(app, 'lambda-certbot-dev', { env: devEnv });
new _1.CertbotDnsRoute53Job(stack, 'Demo', {
    certbotOptions: {
        domainName: (_a = stack.node.tryGetContext('DOMAIN')) !== null && _a !== void 0 ? _a : '*.example.com',
        email: (_b = stack.node.tryGetContext('EMAIL')) !== null && _b !== void 0 ? _b : 'user@example.com',
        customPrefixDirectory: '/',
    },
    zone: r53.HostedZone.fromHostedZoneAttributes(stack, 'myZone', {
        zoneName: (_c = stack.node.tryGetContext('ZONENAME')) !== null && _c !== void 0 ? _c : 'example.com',
        hostedZoneId: (_d = stack.node.tryGetContext('HOSTZONEID')) !== null && _d !== void 0 ? _d : 'mockId',
    }),
    destinationBucket: s3.Bucket.fromBucketName(stack, 'myBucket', (_e = stack.node.tryGetContext('BUCKETNAME')) !== null && _e !== void 0 ? _e : 'mybucket'),
});
app.synth();
//# sourceMappingURL=data:application/json;base64,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