import * as events from 'aws-cdk-lib/aws-events';
import * as r53 from 'aws-cdk-lib/aws-route53';
import * as s3 from 'aws-cdk-lib/aws-s3';
import { Construct } from 'constructs';
/**
 * @stability stable
 */
export interface CertbotOptions {
    /**
     * the domain must host on route53 like example.com.
     *
     * @stability stable
     * @example
     *
     * - `*.example.com` or `a.example.com` .
     */
    readonly domainName: string;
    /**
     * Email address for important account notifications.
     *
     * @stability stable
     */
    readonly email: string;
    /**
     * Custom prefix directory on s3 bucket object path.
     *
     * @default - `s3://YOUR_BUCKET_NAME/2021-01-01/your.domain.name/`
     * @stability stable
     * @example
     *
     * - customPrefixDirectory: 'abc' -> `s3://YOUR_BUCKET_NAME/abc/your.domain.name/`
     */
    readonly customPrefixDirectory?: string;
}
/**
 * @stability stable
 */
export interface CertbotDnsRoute53JobProps {
    /**
     * run the Job with defined schedule.
     *
     * @default - no shedule
     * @stability stable
     */
    readonly schedule?: events.Schedule;
    /**
     * The S3 bucket to store certificate.
     *
     * @stability stable
     */
    readonly destinationBucket: s3.IBucket;
    /**
     * The HostZone on route53 to dns-01 challenge.
     *
     * @stability stable
     */
    readonly zone: r53.IHostedZone;
    /**
     * certbot cmd options.
     *
     * @stability stable
     */
    readonly certbotOptions: CertbotOptions;
}
/**
 * @stability stable
 */
export declare class CertbotDnsRoute53Job extends Construct {
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: CertbotDnsRoute53JobProps);
}
