"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CertbotDnsRoute53Job = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const cdk = require("aws-cdk-lib");
const events = require("aws-cdk-lib/aws-events");
const target = require("aws-cdk-lib/aws-events-targets");
const iam = require("aws-cdk-lib/aws-iam");
const constructs_1 = require("constructs");
const lambda_bash_1 = require("./lambda-bash");
/**
 * @stability stable
 */
class CertbotDnsRoute53Job extends constructs_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id);
        const certOptions = {
            BUCKET_NAME: props.destinationBucket.bucketName,
            EMAIL: props.certbotOptions.email,
            DOMAIN_NAME: props.certbotOptions.domainName,
            CUSTOM_PREFIX_DIRECTORY: props.certbotOptions.customPrefixDirectory,
        };
        const lambdaFun = new lambda_bash_1.BashExecFunction(this, 'certbotDnsRoute53JobLambda', {
            script: path.join(__dirname, '../docker.d/entrypoint.sh'),
            timeout: cdk.Duration.minutes(5),
            environment: {
                ...certOptions,
            },
        });
        props.destinationBucket.grantReadWrite(lambdaFun.handler.role);
        const route53PolicyJsonList = [{
                Effect: 'Allow',
                Action: [
                    'route53:ListHostedZones',
                    'route53:GetChange',
                ],
                Resource: [
                    '*',
                ],
            },
            {
                Effect: 'Allow',
                Action: [
                    'route53:ChangeResourceRecordSets',
                ],
                Resource: [
                    `arn:aws:route53:::hostedzone/${props.zone.hostedZoneId}`,
                ],
            }];
        route53PolicyJsonList.forEach(e => {
            lambdaFun.handler.role.addToPrincipalPolicy(iam.PolicyStatement.fromJson(e));
        });
        if (props.schedule) {
            new events.Rule(this, 'ScheduleRule', {
                schedule: props.schedule,
                targets: [
                    new target.LambdaFunction(lambdaFun.handler),
                ],
            });
        }
    }
}
exports.CertbotDnsRoute53Job = CertbotDnsRoute53Job;
_a = JSII_RTTI_SYMBOL_1;
CertbotDnsRoute53Job[_a] = { fqn: "cdk-certbot-dns-route53.CertbotDnsRoute53Job", version: "2.0.6" };
//# sourceMappingURL=data:application/json;base64,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