"""Experimental `dialoghelper` capabilities."""

# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/01_experimental.ipynb.

# %% auto 0
__all__ = ['iife', 'start_share', 'capture_screen']

# %% ../nbs/01_experimental.ipynb
from .core import *
from fastcore.all import *
from fasthtml.common import Div,Script
from httpx import post as xpost
from importlib import resources
from lisette.core import *

import base64,json,uuid,time

# %% ../nbs/01_experimental.ipynb
def iife(code: str) -> str:
    "Wrap javascript code string in an IIFE and execute it via `add_html`"
    trigger_script = f'''
(async () => {{
{code}
}})();
'''
    add_html(Div(Script(trigger_script), hx_swap_oob=f'beforeend:#js-script'))

# %% ../nbs/01_experimental.ipynb
def start_share():
    iife((resources.files('dialoghelper')/'screenshot.js').read_text())
    iife('await setupVideoStream();')

# %% ../nbs/01_experimental.ipynb
def capture_screen():
    'Capture screenshot, automatically starting screen share if needed.'
    idx = uuid.uuid4()
    iife(f"pushData('{idx}', {{img_data: await getScreenshot()}});")
    time.sleep(0.5)
    d = dict2obj(xpost('http://localhost:5001/pop_data_blocking_', data={'data_id': idx}).json())
    if 'img_data' in d: return ToolResponse([{'type': 'image_url', 'image_url': d.img_data}])
    else: return f'Capture failed: {d.error}'
