# Default Template Documentation

## Template Overview
- **Template Name**: default
- **Analysis Date**: 2025-06-30 08:47:20
- **Total Layouts**: 19
- **Template Location**: `/Users/bruce/GitHub/teknologika/Deckbuilder/templates/default`

## Layout Summary

| Layout Name | Index | Placeholders | Structured Support | JSON Mapping |
|-------------|-------|--------------|-------------------|--------------|
| Title Slide | 0 | 5 | ⏳ | ✅ |
| Title and Content | 1 | 5 | ⏳ | ✅ |
| Section Header | 2 | 5 | ⏳ | ✅ |
| Two Content | 3 | 6 | ⏳ | ✅ |
| Comparison | 4 | 8 | ⏳ | ✅ |
| Title Only | 5 | 4 | ⏳ | ✅ |
| Blank | 6 | 3 | ⏳ | ✅ |
| Content with Caption | 7 | 6 | ⏳ | ✅ |
| Picture with Caption | 8 | 6 | ⏳ | ✅ |
| Title and Vertical Text | 9 | 5 | ⏳ | ✅ |
| Vertical Title and Text | 10 | 5 | ⏳ | ✅ |
| Three Columns With Titles | 11 | 10 | ⏳ | ✅ |
| Three Columns | 12 | 7 | ⏳ | ✅ |
| Four Columns With Titles | 13 | 12 | ⏳ | ✅ |
| Four Columns | 14 | 8 | ⏳ | ✅ |
| Agenda, 6 Textboxes | 15 | 16 | ⏳ | ✅ |
| Title and 6-item Lists | 16 | 22 | ⏳ | ✅ |
| Big Number | 17 | 5 | ⏳ | ✅ |
| SWOT Analysis | 18 | 7 | ⏳ | ✅ |

## Detailed Layout Specifications

### Title Slide (Index: 0)\n\n**PowerPoint Placeholders**:\n- `idx=0`: "title_top_1"\n- `idx=1`: "subtitle_1"\n- `idx=10`: "date_footer_1"\n- `idx=11`: "footer_footer_1"\n- `idx=12`: "slide_number_footer_1"\n\n**JSON Mapping**: ✅ Configured\n**Structured Frontmatter**: ⏳ To be implemented\n
### Title and Content (Index: 1)\n\n**PowerPoint Placeholders**:\n- `idx=0`: "title_top_1"\n- `idx=1`: "content_1"\n- `idx=10`: "date_footer_1"\n- `idx=11`: "footer_footer_1"\n- `idx=12`: "slide_number_footer_1"\n\n**JSON Mapping**: ✅ Configured\n**Structured Frontmatter**: ⏳ To be implemented\n
### Section Header (Index: 2)\n\n**PowerPoint Placeholders**:\n- `idx=0`: "title_top_1"\n- `idx=1`: "text_1"\n- `idx=10`: "date_footer_1"\n- `idx=11`: "footer_footer_1"\n- `idx=12`: "slide_number_footer_1"\n\n**JSON Mapping**: ✅ Configured\n**Structured Frontmatter**: ⏳ To be implemented\n
### Two Content (Index: 3)\n\n**PowerPoint Placeholders**:\n- `idx=0`: "title_top_1"\n- `idx=1`: "content_left_1"\n- `idx=2`: "content_right_1"\n- `idx=10`: "date_footer_1"\n- `idx=11`: "footer_footer_1"\n- `idx=12`: "slide_number_footer_1"\n\n**JSON Mapping**: ✅ Configured\n**Structured Frontmatter**: ⏳ To be implemented\n
### Comparison (Index: 4)\n\n**PowerPoint Placeholders**:\n- `idx=0`: "title_top_1"\n- `idx=1`: "title_left_1"\n- `idx=2`: "content_left_1"\n- `idx=3`: "title_right_1"\n- `idx=4`: "content_right_1"\n- `idx=10`: "date_footer_1"\n- `idx=11`: "footer_footer_1"\n- `idx=12`: "slide_number_footer_1"\n\n**JSON Mapping**: ✅ Configured\n**Structured Frontmatter**: ⏳ To be implemented\n
### Title Only (Index: 5)\n\n**PowerPoint Placeholders**:\n- `idx=0`: "title_top_1"\n- `idx=10`: "date_footer_1"\n- `idx=11`: "footer_footer_1"\n- `idx=12`: "slide_number_footer_1"\n\n**JSON Mapping**: ✅ Configured\n**Structured Frontmatter**: ⏳ To be implemented\n
### Blank (Index: 6)\n\n**PowerPoint Placeholders**:\n- `idx=10`: "date_footer_1"\n- `idx=11`: "footer_footer_1"\n- `idx=12`: "slide_number_footer_1"\n\n**JSON Mapping**: ✅ Configured\n**Structured Frontmatter**: ⏳ To be implemented\n
### Content with Caption (Index: 7)\n\n**PowerPoint Placeholders**:\n- `idx=0`: "title_top_1"\n- `idx=1`: "content_1"\n- `idx=2`: "text_caption_1"\n- `idx=10`: "date_footer_1"\n- `idx=11`: "footer_footer_1"\n- `idx=12`: "slide_number_footer_1"\n\n**JSON Mapping**: ✅ Configured\n**Structured Frontmatter**: ⏳ To be implemented\n
### Picture with Caption (Index: 8)\n\n**PowerPoint Placeholders**:\n- `idx=0`: "title_top_1"\n- `idx=1`: "image_1"\n- `idx=2`: "text_caption_1"\n- `idx=10`: "date_footer_1"\n- `idx=11`: "footer_footer_1"\n- `idx=12`: "slide_number_footer_1"\n\n**JSON Mapping**: ✅ Configured\n**Structured Frontmatter**: ⏳ To be implemented\n
### Title and Vertical Text (Index: 9)\n\n**PowerPoint Placeholders**:\n- `idx=0`: "title_top_1"\n- `idx=1`: "content_1"\n- `idx=10`: "date_footer_1"\n- `idx=11`: "footer_footer_1"\n- `idx=12`: "slide_number_footer_1"\n\n**JSON Mapping**: ✅ Configured\n**Structured Frontmatter**: ⏳ To be implemented\n
### Vertical Title and Text (Index: 10)\n\n**PowerPoint Placeholders**:\n- `idx=0`: "title_top_1"\n- `idx=1`: "content_1"\n- `idx=10`: "date_footer_1"\n- `idx=11`: "footer_footer_1"\n- `idx=12`: "slide_number_footer_1"\n\n**JSON Mapping**: ✅ Configured\n**Structured Frontmatter**: ⏳ To be implemented\n
### Three Columns With Titles (Index: 11)\n\n**PowerPoint Placeholders**:\n- `idx=0`: "title_top_1"\n- `idx=13`: "title_col1_1"\n- `idx=14`: "content_col1_1"\n- `idx=15`: "title_col2_1"\n- `idx=16`: "content_col2_1"\n- `idx=17`: "title_col3_1"\n- `idx=18`: "content_col3_1"\n- `idx=10`: "date_footer_1"\n- `idx=11`: "footer_footer_1"\n- `idx=12`: "slide_number_footer_1"\n\n**JSON Mapping**: ✅ Configured\n**Structured Frontmatter**: ⏳ To be implemented\n
### Three Columns (Index: 12)\n\n**PowerPoint Placeholders**:\n- `idx=0`: "title_top_1"\n- `idx=14`: "content_col1_1"\n- `idx=16`: "content_col2_1"\n- `idx=18`: "content_col3_1"\n- `idx=10`: "date_footer_1"\n- `idx=11`: "footer_footer_1"\n- `idx=12`: "slide_number_footer_1"\n\n**JSON Mapping**: ✅ Configured\n**Structured Frontmatter**: ⏳ To be implemented\n
### Four Columns With Titles (Index: 13)\n\n**PowerPoint Placeholders**:\n- `idx=0`: "title_top_1"\n- `idx=13`: "title_col1_1"\n- `idx=14`: "content_col1_1"\n- `idx=15`: "title_col2_1"\n- `idx=16`: "content_col2_1"\n- `idx=17`: "title_col3_1"\n- `idx=18`: "content_col3_1"\n- `idx=19`: "title_col4_1"\n- `idx=20`: "content_col4_1"\n- `idx=10`: "date_footer_1"\n- `idx=11`: "footer_footer_1"\n- `idx=12`: "slide_number_footer_1"\n\n**JSON Mapping**: ✅ Configured\n**Structured Frontmatter**: ⏳ To be implemented\n
### Four Columns (Index: 14)\n\n**PowerPoint Placeholders**:\n- `idx=0`: "title_top_1"\n- `idx=14`: "content_col1_1"\n- `idx=16`: "content_col2_1"\n- `idx=18`: "content_col3_1"\n- `idx=20`: "content_col4_1"\n- `idx=10`: "date_footer_1"\n- `idx=11`: "footer_footer_1"\n- `idx=12`: "slide_number_footer_1"\n\n**JSON Mapping**: ✅ Configured\n**Structured Frontmatter**: ⏳ To be implemented\n
### Agenda, 6 Textboxes (Index: 15)\n\n**PowerPoint Placeholders**:\n- `idx=0`: "title_top_1"\n- `idx=28`: "number_item1_1"\n- `idx=18`: "content_item1_1"\n- `idx=29`: "number_item2_1"\n- `idx=20`: "content_item2_1"\n- `idx=30`: "number_item3_1"\n- `idx=22`: "content_item3_1"\n- `idx=31`: "number_item4_1"\n- `idx=19`: "content_item4_1"\n- `idx=32`: "number_item5_1"\n- `idx=21`: "content_item5_1"\n- `idx=33`: "number_item6_1"\n- `idx=34`: "content_item6_1"\n- `idx=10`: "date_footer_1"\n- `idx=11`: "footer_footer_1"\n- `idx=12`: "slide_number_footer_1"\n\n**JSON Mapping**: ✅ Configured\n**Structured Frontmatter**: ⏳ To be implemented\n
### Title and 6-item Lists (Index: 16)\n\n**PowerPoint Placeholders**:\n- `idx=0`: "title_top_1"\n- `idx=25`: "content_25"\n- `idx=13`: "content_13"\n- `idx=14`: "content_14"\n- `idx=26`: "content_26"\n- `idx=18`: "content_item1_1"\n- `idx=17`: "content_17"\n- `idx=27`: "content_27"\n- `idx=22`: "content_item3_1"\n- `idx=21`: "content_item5_1"\n- `idx=30`: "number_item3_1"\n- `idx=24`: "content_24"\n- `idx=23`: "content_23"\n- `idx=29`: "number_item2_1"\n- `idx=20`: "content_item2_1"\n- `idx=19`: "content_item4_1"\n- `idx=28`: "number_item1_1"\n- `idx=16`: "content_16"\n- `idx=15`: "content_15"\n- `idx=10`: "date_footer_1"\n- `idx=11`: "footer_footer_1"\n- `idx=12`: "slide_number_footer_1"\n\n**JSON Mapping**: ✅ Configured\n**Structured Frontmatter**: ⏳ To be implemented\n
### Big Number (Index: 17)\n\n**PowerPoint Placeholders**:\n- `idx=0`: "title_top_1"\n- `idx=1`: "content_1"\n- `idx=10`: "date_footer_1"\n- `idx=11`: "footer_footer_1"\n- `idx=12`: "slide_number_footer_1"\n\n**JSON Mapping**: ✅ Configured\n**Structured Frontmatter**: ⏳ To be implemented\n
### SWOT Analysis (Index: 18)\n\n**PowerPoint Placeholders**:\n- `idx=10`: "date_footer_1"\n- `idx=11`: "footer_footer_1"\n- `idx=12`: "slide_number_footer_1"\n- `idx=16`: "content_16"\n- `idx=17`: "content_17"\n- `idx=18`: "content_18"\n- `idx=19`: "content_19"\n\n**JSON Mapping**: ✅ Configured\n**Structured Frontmatter**: ⏳ To be implemented\n

## Template Management

### Adding JSON Mapping
1. **Analyze template**: Run `python -m deckbuilder.cli_tools analyze default`
2. **Edit generated file**: Customize `default.g.json` with semantic names
3. **Activate mapping**: Rename to `default.json` in templates folder

### Example JSON Mapping Structure
```json
{
  "template_info": {
    "name": "Default",
    "version": "1.0"
  },
  "layouts": {
    "Title Slide": {
      "index": 0,
      "placeholders": {
        "0": "Title 1",
        "1": "Subtitle 2"
      }
    }
  },
  "aliases": {
    "title": "Title Slide",
    "content": "Title and Content"
  }
}
```

### Usage Examples

**JSON Format**:
```json
{
  "presentation": {
    "slides": [
      {
        "type": "Title Slide",
        "layout": "Title Slide",
        "title": "My Presentation",
        "subtitle": "Subtitle text"
      }
    ]
  }
}
```

**Markdown with Frontmatter**:
```yaml
---
layout: Title Slide
---
# My Presentation
## Subtitle text
```

---
*Generated automatically by Deckbuilder Template Manager on 2025-06-30 08:47:20*
