"""Initial schema

Revision ID: 9783bd3941f1
Revises: 
Create Date: 2025-08-05 11:59:01.670421

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '9783bd3941f1'
down_revision = None
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('file_share_paths',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('name', sa.String(), nullable=True),
    sa.Column('zone', sa.String(), nullable=True),
    sa.Column('group', sa.String(), nullable=True),
    sa.Column('storage', sa.String(), nullable=True),
    sa.Column('mount_path', sa.String(), nullable=True),
    sa.Column('mac_path', sa.String(), nullable=True),
    sa.Column('windows_path', sa.String(), nullable=True),
    sa.Column('linux_path', sa.String(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_file_share_paths_name'), 'file_share_paths', ['name'], unique=True)
    op.create_table('last_refresh',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('source_last_updated', sa.DateTime(), nullable=False),
    sa.Column('db_last_updated', sa.DateTime(), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('proxied_paths',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('username', sa.String(), nullable=False),
    sa.Column('sharing_key', sa.String(), nullable=False),
    sa.Column('sharing_name', sa.String(), nullable=False),
    sa.Column('fsp_name', sa.String(), nullable=False),
    sa.Column('path', sa.String(), nullable=False),
    sa.Column('created_at', sa.DateTime(), nullable=False),
    sa.Column('updated_at', sa.DateTime(), nullable=False),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('sharing_key'),
    sa.UniqueConstraint('username', 'fsp_name', 'path', name='uq_proxied_path')
    )
    op.create_table('tickets',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('username', sa.String(), nullable=False),
    sa.Column('fsp_name', sa.String(), nullable=False),
    sa.Column('path', sa.String(), nullable=False),
    sa.Column('ticket_key', sa.String(), nullable=False),
    sa.Column('created_at', sa.DateTime(), nullable=False),
    sa.Column('updated_at', sa.DateTime(), nullable=False),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('ticket_key')
    )
    op.create_table('user_preferences',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('username', sa.String(), nullable=False),
    sa.Column('key', sa.String(), nullable=False),
    sa.Column('value', sa.JSON(), nullable=False),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('username', 'key', name='uq_user_pref')
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('user_preferences')
    op.drop_table('tickets')
    op.drop_table('proxied_paths')
    op.drop_table('last_refresh')
    op.drop_index(op.f('ix_file_share_paths_name'), table_name='file_share_paths')
    op.drop_table('file_share_paths')
    # ### end Alembic commands ###