# API Reference <a name="API Reference" id="api-reference"></a>

## Constructs <a name="Constructs" id="constructs"></a>

### AdminRoleCustom <a name="@cdktf/provider-okta.AdminRoleCustom" id="cdktfprovideroktaadminrolecustom"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/r/admin_role_custom okta_admin_role_custom}.

#### Initializers <a name="@cdktf/provider-okta.AdminRoleCustom.Initializer" id="cdktfprovideroktaadminrolecustominitializer"></a>

```typescript
import { AdminRoleCustom } from '@cdktf/provider-okta'

new AdminRoleCustom(scope: Construct, id: string, config: AdminRoleCustomConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktaadminrolecustomparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktaadminrolecustomparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktaadminrolecustomparameterconfig)<span title="Required">*</span> | [`@cdktf/provider-okta.AdminRoleCustomConfig`](#@cdktf/provider-okta.AdminRoleCustomConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.AdminRoleCustom.parameter.scope" id="cdktfprovideroktaadminrolecustomparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AdminRoleCustom.parameter.id" id="cdktfprovideroktaadminrolecustomparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="@cdktf/provider-okta.AdminRoleCustom.parameter.config" id="cdktfprovideroktaadminrolecustomparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.AdminRoleCustomConfig`](#@cdktf/provider-okta.AdminRoleCustomConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`resetId`](#cdktfprovideroktaadminrolecustomresetid) | *No description.* |
| [`resetPermissions`](#cdktfprovideroktaadminrolecustomresetpermissions) | *No description.* |

---

##### `resetId` <a name="@cdktf/provider-okta.AdminRoleCustom.resetId" id="cdktfprovideroktaadminrolecustomresetid"></a>

```typescript
public resetId()
```

##### `resetPermissions` <a name="@cdktf/provider-okta.AdminRoleCustom.resetPermissions" id="cdktfprovideroktaadminrolecustomresetpermissions"></a>

```typescript
public resetPermissions()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`descriptionInput`](#cdktfprovideroktaadminrolecustompropertydescriptioninput) | `string` | *No description.* |
| [`idInput`](#cdktfprovideroktaadminrolecustompropertyidinput) | `string` | *No description.* |
| [`labelInput`](#cdktfprovideroktaadminrolecustompropertylabelinput) | `string` | *No description.* |
| [`permissionsInput`](#cdktfprovideroktaadminrolecustompropertypermissionsinput) | `string`[] | *No description.* |
| [`description`](#cdktfprovideroktaadminrolecustompropertydescription)<span title="Required">*</span> | `string` | *No description.* |
| [`id`](#cdktfprovideroktaadminrolecustompropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`label`](#cdktfprovideroktaadminrolecustompropertylabel)<span title="Required">*</span> | `string` | *No description.* |
| [`permissions`](#cdktfprovideroktaadminrolecustompropertypermissions)<span title="Required">*</span> | `string`[] | *No description.* |

---

##### `descriptionInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AdminRoleCustom.property.descriptionInput" id="cdktfprovideroktaadminrolecustompropertydescriptioninput"></a>

```typescript
public readonly descriptionInput: string;
```

- *Type:* `string`

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AdminRoleCustom.property.idInput" id="cdktfprovideroktaadminrolecustompropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `labelInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AdminRoleCustom.property.labelInput" id="cdktfprovideroktaadminrolecustompropertylabelinput"></a>

```typescript
public readonly labelInput: string;
```

- *Type:* `string`

---

##### `permissionsInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AdminRoleCustom.property.permissionsInput" id="cdktfprovideroktaadminrolecustompropertypermissionsinput"></a>

```typescript
public readonly permissionsInput: string[];
```

- *Type:* `string`[]

---

##### `description`<sup>Required</sup> <a name="@cdktf/provider-okta.AdminRoleCustom.property.description" id="cdktfprovideroktaadminrolecustompropertydescription"></a>

```typescript
public readonly description: string;
```

- *Type:* `string`

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AdminRoleCustom.property.id" id="cdktfprovideroktaadminrolecustompropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `label`<sup>Required</sup> <a name="@cdktf/provider-okta.AdminRoleCustom.property.label" id="cdktfprovideroktaadminrolecustompropertylabel"></a>

```typescript
public readonly label: string;
```

- *Type:* `string`

---

##### `permissions`<sup>Required</sup> <a name="@cdktf/provider-okta.AdminRoleCustom.property.permissions" id="cdktfprovideroktaadminrolecustompropertypermissions"></a>

```typescript
public readonly permissions: string[];
```

- *Type:* `string`[]

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktaadminrolecustompropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.AdminRoleCustom.property.tfResourceType" id="cdktfprovideroktaadminrolecustompropertytfresourcetype"></a>

- *Type:* `string`

---

### AdminRoleCustomAssignments <a name="@cdktf/provider-okta.AdminRoleCustomAssignments" id="cdktfprovideroktaadminrolecustomassignments"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/r/admin_role_custom_assignments okta_admin_role_custom_assignments}.

#### Initializers <a name="@cdktf/provider-okta.AdminRoleCustomAssignments.Initializer" id="cdktfprovideroktaadminrolecustomassignmentsinitializer"></a>

```typescript
import { AdminRoleCustomAssignments } from '@cdktf/provider-okta'

new AdminRoleCustomAssignments(scope: Construct, id: string, config: AdminRoleCustomAssignmentsConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktaadminrolecustomassignmentsparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktaadminrolecustomassignmentsparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktaadminrolecustomassignmentsparameterconfig)<span title="Required">*</span> | [`@cdktf/provider-okta.AdminRoleCustomAssignmentsConfig`](#@cdktf/provider-okta.AdminRoleCustomAssignmentsConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.AdminRoleCustomAssignments.parameter.scope" id="cdktfprovideroktaadminrolecustomassignmentsparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AdminRoleCustomAssignments.parameter.id" id="cdktfprovideroktaadminrolecustomassignmentsparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="@cdktf/provider-okta.AdminRoleCustomAssignments.parameter.config" id="cdktfprovideroktaadminrolecustomassignmentsparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.AdminRoleCustomAssignmentsConfig`](#@cdktf/provider-okta.AdminRoleCustomAssignmentsConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`resetId`](#cdktfprovideroktaadminrolecustomassignmentsresetid) | *No description.* |
| [`resetMembers`](#cdktfprovideroktaadminrolecustomassignmentsresetmembers) | *No description.* |

---

##### `resetId` <a name="@cdktf/provider-okta.AdminRoleCustomAssignments.resetId" id="cdktfprovideroktaadminrolecustomassignmentsresetid"></a>

```typescript
public resetId()
```

##### `resetMembers` <a name="@cdktf/provider-okta.AdminRoleCustomAssignments.resetMembers" id="cdktfprovideroktaadminrolecustomassignmentsresetmembers"></a>

```typescript
public resetMembers()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`customRoleIdInput`](#cdktfprovideroktaadminrolecustomassignmentspropertycustomroleidinput) | `string` | *No description.* |
| [`idInput`](#cdktfprovideroktaadminrolecustomassignmentspropertyidinput) | `string` | *No description.* |
| [`membersInput`](#cdktfprovideroktaadminrolecustomassignmentspropertymembersinput) | `string`[] | *No description.* |
| [`resourceSetIdInput`](#cdktfprovideroktaadminrolecustomassignmentspropertyresourcesetidinput) | `string` | *No description.* |
| [`customRoleId`](#cdktfprovideroktaadminrolecustomassignmentspropertycustomroleid)<span title="Required">*</span> | `string` | *No description.* |
| [`id`](#cdktfprovideroktaadminrolecustomassignmentspropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`members`](#cdktfprovideroktaadminrolecustomassignmentspropertymembers)<span title="Required">*</span> | `string`[] | *No description.* |
| [`resourceSetId`](#cdktfprovideroktaadminrolecustomassignmentspropertyresourcesetid)<span title="Required">*</span> | `string` | *No description.* |

---

##### `customRoleIdInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AdminRoleCustomAssignments.property.customRoleIdInput" id="cdktfprovideroktaadminrolecustomassignmentspropertycustomroleidinput"></a>

```typescript
public readonly customRoleIdInput: string;
```

- *Type:* `string`

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AdminRoleCustomAssignments.property.idInput" id="cdktfprovideroktaadminrolecustomassignmentspropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `membersInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AdminRoleCustomAssignments.property.membersInput" id="cdktfprovideroktaadminrolecustomassignmentspropertymembersinput"></a>

```typescript
public readonly membersInput: string[];
```

- *Type:* `string`[]

---

##### `resourceSetIdInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AdminRoleCustomAssignments.property.resourceSetIdInput" id="cdktfprovideroktaadminrolecustomassignmentspropertyresourcesetidinput"></a>

```typescript
public readonly resourceSetIdInput: string;
```

- *Type:* `string`

---

##### `customRoleId`<sup>Required</sup> <a name="@cdktf/provider-okta.AdminRoleCustomAssignments.property.customRoleId" id="cdktfprovideroktaadminrolecustomassignmentspropertycustomroleid"></a>

```typescript
public readonly customRoleId: string;
```

- *Type:* `string`

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AdminRoleCustomAssignments.property.id" id="cdktfprovideroktaadminrolecustomassignmentspropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `members`<sup>Required</sup> <a name="@cdktf/provider-okta.AdminRoleCustomAssignments.property.members" id="cdktfprovideroktaadminrolecustomassignmentspropertymembers"></a>

```typescript
public readonly members: string[];
```

- *Type:* `string`[]

---

##### `resourceSetId`<sup>Required</sup> <a name="@cdktf/provider-okta.AdminRoleCustomAssignments.property.resourceSetId" id="cdktfprovideroktaadminrolecustomassignmentspropertyresourcesetid"></a>

```typescript
public readonly resourceSetId: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktaadminrolecustomassignmentspropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.AdminRoleCustomAssignments.property.tfResourceType" id="cdktfprovideroktaadminrolecustomassignmentspropertytfresourcetype"></a>

- *Type:* `string`

---

### AdminRoleTargets <a name="@cdktf/provider-okta.AdminRoleTargets" id="cdktfprovideroktaadminroletargets"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/r/admin_role_targets okta_admin_role_targets}.

#### Initializers <a name="@cdktf/provider-okta.AdminRoleTargets.Initializer" id="cdktfprovideroktaadminroletargetsinitializer"></a>

```typescript
import { AdminRoleTargets } from '@cdktf/provider-okta'

new AdminRoleTargets(scope: Construct, id: string, config: AdminRoleTargetsConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktaadminroletargetsparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktaadminroletargetsparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktaadminroletargetsparameterconfig)<span title="Required">*</span> | [`@cdktf/provider-okta.AdminRoleTargetsConfig`](#@cdktf/provider-okta.AdminRoleTargetsConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.AdminRoleTargets.parameter.scope" id="cdktfprovideroktaadminroletargetsparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AdminRoleTargets.parameter.id" id="cdktfprovideroktaadminroletargetsparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="@cdktf/provider-okta.AdminRoleTargets.parameter.config" id="cdktfprovideroktaadminroletargetsparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.AdminRoleTargetsConfig`](#@cdktf/provider-okta.AdminRoleTargetsConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`resetApps`](#cdktfprovideroktaadminroletargetsresetapps) | *No description.* |
| [`resetGroups`](#cdktfprovideroktaadminroletargetsresetgroups) | *No description.* |
| [`resetId`](#cdktfprovideroktaadminroletargetsresetid) | *No description.* |

---

##### `resetApps` <a name="@cdktf/provider-okta.AdminRoleTargets.resetApps" id="cdktfprovideroktaadminroletargetsresetapps"></a>

```typescript
public resetApps()
```

##### `resetGroups` <a name="@cdktf/provider-okta.AdminRoleTargets.resetGroups" id="cdktfprovideroktaadminroletargetsresetgroups"></a>

```typescript
public resetGroups()
```

##### `resetId` <a name="@cdktf/provider-okta.AdminRoleTargets.resetId" id="cdktfprovideroktaadminroletargetsresetid"></a>

```typescript
public resetId()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`roleId`](#cdktfprovideroktaadminroletargetspropertyroleid)<span title="Required">*</span> | `string` | *No description.* |
| [`appsInput`](#cdktfprovideroktaadminroletargetspropertyappsinput) | `string`[] | *No description.* |
| [`groupsInput`](#cdktfprovideroktaadminroletargetspropertygroupsinput) | `string`[] | *No description.* |
| [`idInput`](#cdktfprovideroktaadminroletargetspropertyidinput) | `string` | *No description.* |
| [`roleTypeInput`](#cdktfprovideroktaadminroletargetspropertyroletypeinput) | `string` | *No description.* |
| [`userIdInput`](#cdktfprovideroktaadminroletargetspropertyuseridinput) | `string` | *No description.* |
| [`apps`](#cdktfprovideroktaadminroletargetspropertyapps)<span title="Required">*</span> | `string`[] | *No description.* |
| [`groups`](#cdktfprovideroktaadminroletargetspropertygroups)<span title="Required">*</span> | `string`[] | *No description.* |
| [`id`](#cdktfprovideroktaadminroletargetspropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`roleType`](#cdktfprovideroktaadminroletargetspropertyroletype)<span title="Required">*</span> | `string` | *No description.* |
| [`userId`](#cdktfprovideroktaadminroletargetspropertyuserid)<span title="Required">*</span> | `string` | *No description.* |

---

##### `roleId`<sup>Required</sup> <a name="@cdktf/provider-okta.AdminRoleTargets.property.roleId" id="cdktfprovideroktaadminroletargetspropertyroleid"></a>

```typescript
public readonly roleId: string;
```

- *Type:* `string`

---

##### `appsInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AdminRoleTargets.property.appsInput" id="cdktfprovideroktaadminroletargetspropertyappsinput"></a>

```typescript
public readonly appsInput: string[];
```

- *Type:* `string`[]

---

##### `groupsInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AdminRoleTargets.property.groupsInput" id="cdktfprovideroktaadminroletargetspropertygroupsinput"></a>

```typescript
public readonly groupsInput: string[];
```

- *Type:* `string`[]

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AdminRoleTargets.property.idInput" id="cdktfprovideroktaadminroletargetspropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `roleTypeInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AdminRoleTargets.property.roleTypeInput" id="cdktfprovideroktaadminroletargetspropertyroletypeinput"></a>

```typescript
public readonly roleTypeInput: string;
```

- *Type:* `string`

---

##### `userIdInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AdminRoleTargets.property.userIdInput" id="cdktfprovideroktaadminroletargetspropertyuseridinput"></a>

```typescript
public readonly userIdInput: string;
```

- *Type:* `string`

---

##### `apps`<sup>Required</sup> <a name="@cdktf/provider-okta.AdminRoleTargets.property.apps" id="cdktfprovideroktaadminroletargetspropertyapps"></a>

```typescript
public readonly apps: string[];
```

- *Type:* `string`[]

---

##### `groups`<sup>Required</sup> <a name="@cdktf/provider-okta.AdminRoleTargets.property.groups" id="cdktfprovideroktaadminroletargetspropertygroups"></a>

```typescript
public readonly groups: string[];
```

- *Type:* `string`[]

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AdminRoleTargets.property.id" id="cdktfprovideroktaadminroletargetspropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `roleType`<sup>Required</sup> <a name="@cdktf/provider-okta.AdminRoleTargets.property.roleType" id="cdktfprovideroktaadminroletargetspropertyroletype"></a>

```typescript
public readonly roleType: string;
```

- *Type:* `string`

---

##### `userId`<sup>Required</sup> <a name="@cdktf/provider-okta.AdminRoleTargets.property.userId" id="cdktfprovideroktaadminroletargetspropertyuserid"></a>

```typescript
public readonly userId: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktaadminroletargetspropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.AdminRoleTargets.property.tfResourceType" id="cdktfprovideroktaadminroletargetspropertytfresourcetype"></a>

- *Type:* `string`

---

### AppAutoLogin <a name="@cdktf/provider-okta.AppAutoLogin" id="cdktfprovideroktaappautologin"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/r/app_auto_login okta_app_auto_login}.

#### Initializers <a name="@cdktf/provider-okta.AppAutoLogin.Initializer" id="cdktfprovideroktaappautologininitializer"></a>

```typescript
import { AppAutoLogin } from '@cdktf/provider-okta'

new AppAutoLogin(scope: Construct, id: string, config: AppAutoLoginConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktaappautologinparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktaappautologinparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktaappautologinparameterconfig)<span title="Required">*</span> | [`@cdktf/provider-okta.AppAutoLoginConfig`](#@cdktf/provider-okta.AppAutoLoginConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.AppAutoLogin.parameter.scope" id="cdktfprovideroktaappautologinparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AppAutoLogin.parameter.id" id="cdktfprovideroktaappautologinparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="@cdktf/provider-okta.AppAutoLogin.parameter.config" id="cdktfprovideroktaappautologinparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.AppAutoLoginConfig`](#@cdktf/provider-okta.AppAutoLoginConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`putTimeouts`](#cdktfprovideroktaappautologinputtimeouts) | *No description.* |
| [`putUsers`](#cdktfprovideroktaappautologinputusers) | *No description.* |
| [`resetAccessibilityErrorRedirectUrl`](#cdktfprovideroktaappautologinresetaccessibilityerrorredirecturl) | *No description.* |
| [`resetAccessibilityLoginRedirectUrl`](#cdktfprovideroktaappautologinresetaccessibilityloginredirecturl) | *No description.* |
| [`resetAccessibilitySelfService`](#cdktfprovideroktaappautologinresetaccessibilityselfservice) | *No description.* |
| [`resetAdminNote`](#cdktfprovideroktaappautologinresetadminnote) | *No description.* |
| [`resetAppLinksJson`](#cdktfprovideroktaappautologinresetapplinksjson) | *No description.* |
| [`resetAppSettingsJson`](#cdktfprovideroktaappautologinresetappsettingsjson) | *No description.* |
| [`resetAutoSubmitToolbar`](#cdktfprovideroktaappautologinresetautosubmittoolbar) | *No description.* |
| [`resetCredentialsScheme`](#cdktfprovideroktaappautologinresetcredentialsscheme) | *No description.* |
| [`resetEnduserNote`](#cdktfprovideroktaappautologinresetendusernote) | *No description.* |
| [`resetGroups`](#cdktfprovideroktaappautologinresetgroups) | *No description.* |
| [`resetHideIos`](#cdktfprovideroktaappautologinresethideios) | *No description.* |
| [`resetHideWeb`](#cdktfprovideroktaappautologinresethideweb) | *No description.* |
| [`resetId`](#cdktfprovideroktaappautologinresetid) | *No description.* |
| [`resetLogo`](#cdktfprovideroktaappautologinresetlogo) | *No description.* |
| [`resetPreconfiguredApp`](#cdktfprovideroktaappautologinresetpreconfiguredapp) | *No description.* |
| [`resetRevealPassword`](#cdktfprovideroktaappautologinresetrevealpassword) | *No description.* |
| [`resetSharedPassword`](#cdktfprovideroktaappautologinresetsharedpassword) | *No description.* |
| [`resetSharedUsername`](#cdktfprovideroktaappautologinresetsharedusername) | *No description.* |
| [`resetSignOnRedirectUrl`](#cdktfprovideroktaappautologinresetsignonredirecturl) | *No description.* |
| [`resetSignOnUrl`](#cdktfprovideroktaappautologinresetsignonurl) | *No description.* |
| [`resetSkipGroups`](#cdktfprovideroktaappautologinresetskipgroups) | *No description.* |
| [`resetSkipUsers`](#cdktfprovideroktaappautologinresetskipusers) | *No description.* |
| [`resetStatus`](#cdktfprovideroktaappautologinresetstatus) | *No description.* |
| [`resetTimeouts`](#cdktfprovideroktaappautologinresettimeouts) | *No description.* |
| [`resetUserNameTemplate`](#cdktfprovideroktaappautologinresetusernametemplate) | *No description.* |
| [`resetUserNameTemplatePushStatus`](#cdktfprovideroktaappautologinresetusernametemplatepushstatus) | *No description.* |
| [`resetUserNameTemplateSuffix`](#cdktfprovideroktaappautologinresetusernametemplatesuffix) | *No description.* |
| [`resetUserNameTemplateType`](#cdktfprovideroktaappautologinresetusernametemplatetype) | *No description.* |
| [`resetUsers`](#cdktfprovideroktaappautologinresetusers) | *No description.* |

---

##### `putTimeouts` <a name="@cdktf/provider-okta.AppAutoLogin.putTimeouts" id="cdktfprovideroktaappautologinputtimeouts"></a>

```typescript
public putTimeouts(value: AppAutoLoginTimeouts)
```

###### `value`<sup>Required</sup> <a name="@cdktf/provider-okta.AppAutoLogin.parameter.value" id="cdktfprovideroktaappautologinparametervalue"></a>

- *Type:* [`@cdktf/provider-okta.AppAutoLoginTimeouts`](#@cdktf/provider-okta.AppAutoLoginTimeouts)

---

##### `putUsers` <a name="@cdktf/provider-okta.AppAutoLogin.putUsers" id="cdktfprovideroktaappautologinputusers"></a>

```typescript
public putUsers(value: IResolvable | AppAutoLoginUsers[])
```

###### `value`<sup>Required</sup> <a name="@cdktf/provider-okta.AppAutoLogin.parameter.value" id="cdktfprovideroktaappautologinparametervalue"></a>

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable) | [`@cdktf/provider-okta.AppAutoLoginUsers`](#@cdktf/provider-okta.AppAutoLoginUsers)[]

---

##### `resetAccessibilityErrorRedirectUrl` <a name="@cdktf/provider-okta.AppAutoLogin.resetAccessibilityErrorRedirectUrl" id="cdktfprovideroktaappautologinresetaccessibilityerrorredirecturl"></a>

```typescript
public resetAccessibilityErrorRedirectUrl()
```

##### `resetAccessibilityLoginRedirectUrl` <a name="@cdktf/provider-okta.AppAutoLogin.resetAccessibilityLoginRedirectUrl" id="cdktfprovideroktaappautologinresetaccessibilityloginredirecturl"></a>

```typescript
public resetAccessibilityLoginRedirectUrl()
```

##### `resetAccessibilitySelfService` <a name="@cdktf/provider-okta.AppAutoLogin.resetAccessibilitySelfService" id="cdktfprovideroktaappautologinresetaccessibilityselfservice"></a>

```typescript
public resetAccessibilitySelfService()
```

##### `resetAdminNote` <a name="@cdktf/provider-okta.AppAutoLogin.resetAdminNote" id="cdktfprovideroktaappautologinresetadminnote"></a>

```typescript
public resetAdminNote()
```

##### `resetAppLinksJson` <a name="@cdktf/provider-okta.AppAutoLogin.resetAppLinksJson" id="cdktfprovideroktaappautologinresetapplinksjson"></a>

```typescript
public resetAppLinksJson()
```

##### `resetAppSettingsJson` <a name="@cdktf/provider-okta.AppAutoLogin.resetAppSettingsJson" id="cdktfprovideroktaappautologinresetappsettingsjson"></a>

```typescript
public resetAppSettingsJson()
```

##### `resetAutoSubmitToolbar` <a name="@cdktf/provider-okta.AppAutoLogin.resetAutoSubmitToolbar" id="cdktfprovideroktaappautologinresetautosubmittoolbar"></a>

```typescript
public resetAutoSubmitToolbar()
```

##### `resetCredentialsScheme` <a name="@cdktf/provider-okta.AppAutoLogin.resetCredentialsScheme" id="cdktfprovideroktaappautologinresetcredentialsscheme"></a>

```typescript
public resetCredentialsScheme()
```

##### `resetEnduserNote` <a name="@cdktf/provider-okta.AppAutoLogin.resetEnduserNote" id="cdktfprovideroktaappautologinresetendusernote"></a>

```typescript
public resetEnduserNote()
```

##### `resetGroups` <a name="@cdktf/provider-okta.AppAutoLogin.resetGroups" id="cdktfprovideroktaappautologinresetgroups"></a>

```typescript
public resetGroups()
```

##### `resetHideIos` <a name="@cdktf/provider-okta.AppAutoLogin.resetHideIos" id="cdktfprovideroktaappautologinresethideios"></a>

```typescript
public resetHideIos()
```

##### `resetHideWeb` <a name="@cdktf/provider-okta.AppAutoLogin.resetHideWeb" id="cdktfprovideroktaappautologinresethideweb"></a>

```typescript
public resetHideWeb()
```

##### `resetId` <a name="@cdktf/provider-okta.AppAutoLogin.resetId" id="cdktfprovideroktaappautologinresetid"></a>

```typescript
public resetId()
```

##### `resetLogo` <a name="@cdktf/provider-okta.AppAutoLogin.resetLogo" id="cdktfprovideroktaappautologinresetlogo"></a>

```typescript
public resetLogo()
```

##### `resetPreconfiguredApp` <a name="@cdktf/provider-okta.AppAutoLogin.resetPreconfiguredApp" id="cdktfprovideroktaappautologinresetpreconfiguredapp"></a>

```typescript
public resetPreconfiguredApp()
```

##### `resetRevealPassword` <a name="@cdktf/provider-okta.AppAutoLogin.resetRevealPassword" id="cdktfprovideroktaappautologinresetrevealpassword"></a>

```typescript
public resetRevealPassword()
```

##### `resetSharedPassword` <a name="@cdktf/provider-okta.AppAutoLogin.resetSharedPassword" id="cdktfprovideroktaappautologinresetsharedpassword"></a>

```typescript
public resetSharedPassword()
```

##### `resetSharedUsername` <a name="@cdktf/provider-okta.AppAutoLogin.resetSharedUsername" id="cdktfprovideroktaappautologinresetsharedusername"></a>

```typescript
public resetSharedUsername()
```

##### `resetSignOnRedirectUrl` <a name="@cdktf/provider-okta.AppAutoLogin.resetSignOnRedirectUrl" id="cdktfprovideroktaappautologinresetsignonredirecturl"></a>

```typescript
public resetSignOnRedirectUrl()
```

##### `resetSignOnUrl` <a name="@cdktf/provider-okta.AppAutoLogin.resetSignOnUrl" id="cdktfprovideroktaappautologinresetsignonurl"></a>

```typescript
public resetSignOnUrl()
```

##### `resetSkipGroups` <a name="@cdktf/provider-okta.AppAutoLogin.resetSkipGroups" id="cdktfprovideroktaappautologinresetskipgroups"></a>

```typescript
public resetSkipGroups()
```

##### `resetSkipUsers` <a name="@cdktf/provider-okta.AppAutoLogin.resetSkipUsers" id="cdktfprovideroktaappautologinresetskipusers"></a>

```typescript
public resetSkipUsers()
```

##### `resetStatus` <a name="@cdktf/provider-okta.AppAutoLogin.resetStatus" id="cdktfprovideroktaappautologinresetstatus"></a>

```typescript
public resetStatus()
```

##### `resetTimeouts` <a name="@cdktf/provider-okta.AppAutoLogin.resetTimeouts" id="cdktfprovideroktaappautologinresettimeouts"></a>

```typescript
public resetTimeouts()
```

##### `resetUserNameTemplate` <a name="@cdktf/provider-okta.AppAutoLogin.resetUserNameTemplate" id="cdktfprovideroktaappautologinresetusernametemplate"></a>

```typescript
public resetUserNameTemplate()
```

##### `resetUserNameTemplatePushStatus` <a name="@cdktf/provider-okta.AppAutoLogin.resetUserNameTemplatePushStatus" id="cdktfprovideroktaappautologinresetusernametemplatepushstatus"></a>

```typescript
public resetUserNameTemplatePushStatus()
```

##### `resetUserNameTemplateSuffix` <a name="@cdktf/provider-okta.AppAutoLogin.resetUserNameTemplateSuffix" id="cdktfprovideroktaappautologinresetusernametemplatesuffix"></a>

```typescript
public resetUserNameTemplateSuffix()
```

##### `resetUserNameTemplateType` <a name="@cdktf/provider-okta.AppAutoLogin.resetUserNameTemplateType" id="cdktfprovideroktaappautologinresetusernametemplatetype"></a>

```typescript
public resetUserNameTemplateType()
```

##### `resetUsers` <a name="@cdktf/provider-okta.AppAutoLogin.resetUsers" id="cdktfprovideroktaappautologinresetusers"></a>

```typescript
public resetUsers()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`logoUrl`](#cdktfprovideroktaappautologinpropertylogourl)<span title="Required">*</span> | `string` | *No description.* |
| [`name`](#cdktfprovideroktaappautologinpropertyname)<span title="Required">*</span> | `string` | *No description.* |
| [`signOnMode`](#cdktfprovideroktaappautologinpropertysignonmode)<span title="Required">*</span> | `string` | *No description.* |
| [`timeouts`](#cdktfprovideroktaappautologinpropertytimeouts)<span title="Required">*</span> | [`@cdktf/provider-okta.AppAutoLoginTimeoutsOutputReference`](#@cdktf/provider-okta.AppAutoLoginTimeoutsOutputReference) | *No description.* |
| [`users`](#cdktfprovideroktaappautologinpropertyusers)<span title="Required">*</span> | [`@cdktf/provider-okta.AppAutoLoginUsersList`](#@cdktf/provider-okta.AppAutoLoginUsersList) | *No description.* |
| [`accessibilityErrorRedirectUrlInput`](#cdktfprovideroktaappautologinpropertyaccessibilityerrorredirecturlinput) | `string` | *No description.* |
| [`accessibilityLoginRedirectUrlInput`](#cdktfprovideroktaappautologinpropertyaccessibilityloginredirecturlinput) | `string` | *No description.* |
| [`accessibilitySelfServiceInput`](#cdktfprovideroktaappautologinpropertyaccessibilityselfserviceinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`adminNoteInput`](#cdktfprovideroktaappautologinpropertyadminnoteinput) | `string` | *No description.* |
| [`appLinksJsonInput`](#cdktfprovideroktaappautologinpropertyapplinksjsoninput) | `string` | *No description.* |
| [`appSettingsJsonInput`](#cdktfprovideroktaappautologinpropertyappsettingsjsoninput) | `string` | *No description.* |
| [`autoSubmitToolbarInput`](#cdktfprovideroktaappautologinpropertyautosubmittoolbarinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`credentialsSchemeInput`](#cdktfprovideroktaappautologinpropertycredentialsschemeinput) | `string` | *No description.* |
| [`enduserNoteInput`](#cdktfprovideroktaappautologinpropertyendusernoteinput) | `string` | *No description.* |
| [`groupsInput`](#cdktfprovideroktaappautologinpropertygroupsinput) | `string`[] | *No description.* |
| [`hideIosInput`](#cdktfprovideroktaappautologinpropertyhideiosinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`hideWebInput`](#cdktfprovideroktaappautologinpropertyhidewebinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`idInput`](#cdktfprovideroktaappautologinpropertyidinput) | `string` | *No description.* |
| [`labelInput`](#cdktfprovideroktaappautologinpropertylabelinput) | `string` | *No description.* |
| [`logoInput`](#cdktfprovideroktaappautologinpropertylogoinput) | `string` | *No description.* |
| [`preconfiguredAppInput`](#cdktfprovideroktaappautologinpropertypreconfiguredappinput) | `string` | *No description.* |
| [`revealPasswordInput`](#cdktfprovideroktaappautologinpropertyrevealpasswordinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`sharedPasswordInput`](#cdktfprovideroktaappautologinpropertysharedpasswordinput) | `string` | *No description.* |
| [`sharedUsernameInput`](#cdktfprovideroktaappautologinpropertysharedusernameinput) | `string` | *No description.* |
| [`signOnRedirectUrlInput`](#cdktfprovideroktaappautologinpropertysignonredirecturlinput) | `string` | *No description.* |
| [`signOnUrlInput`](#cdktfprovideroktaappautologinpropertysignonurlinput) | `string` | *No description.* |
| [`skipGroupsInput`](#cdktfprovideroktaappautologinpropertyskipgroupsinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`skipUsersInput`](#cdktfprovideroktaappautologinpropertyskipusersinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`statusInput`](#cdktfprovideroktaappautologinpropertystatusinput) | `string` | *No description.* |
| [`timeoutsInput`](#cdktfprovideroktaappautologinpropertytimeoutsinput) | [`cdktf.IResolvable`](#cdktf.IResolvable) \| [`@cdktf/provider-okta.AppAutoLoginTimeouts`](#@cdktf/provider-okta.AppAutoLoginTimeouts) | *No description.* |
| [`userNameTemplateInput`](#cdktfprovideroktaappautologinpropertyusernametemplateinput) | `string` | *No description.* |
| [`userNameTemplatePushStatusInput`](#cdktfprovideroktaappautologinpropertyusernametemplatepushstatusinput) | `string` | *No description.* |
| [`userNameTemplateSuffixInput`](#cdktfprovideroktaappautologinpropertyusernametemplatesuffixinput) | `string` | *No description.* |
| [`userNameTemplateTypeInput`](#cdktfprovideroktaappautologinpropertyusernametemplatetypeinput) | `string` | *No description.* |
| [`usersInput`](#cdktfprovideroktaappautologinpropertyusersinput) | [`cdktf.IResolvable`](#cdktf.IResolvable) \| [`@cdktf/provider-okta.AppAutoLoginUsers`](#@cdktf/provider-okta.AppAutoLoginUsers)[] | *No description.* |
| [`accessibilityErrorRedirectUrl`](#cdktfprovideroktaappautologinpropertyaccessibilityerrorredirecturl)<span title="Required">*</span> | `string` | *No description.* |
| [`accessibilityLoginRedirectUrl`](#cdktfprovideroktaappautologinpropertyaccessibilityloginredirecturl)<span title="Required">*</span> | `string` | *No description.* |
| [`accessibilitySelfService`](#cdktfprovideroktaappautologinpropertyaccessibilityselfservice)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`adminNote`](#cdktfprovideroktaappautologinpropertyadminnote)<span title="Required">*</span> | `string` | *No description.* |
| [`appLinksJson`](#cdktfprovideroktaappautologinpropertyapplinksjson)<span title="Required">*</span> | `string` | *No description.* |
| [`appSettingsJson`](#cdktfprovideroktaappautologinpropertyappsettingsjson)<span title="Required">*</span> | `string` | *No description.* |
| [`autoSubmitToolbar`](#cdktfprovideroktaappautologinpropertyautosubmittoolbar)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`credentialsScheme`](#cdktfprovideroktaappautologinpropertycredentialsscheme)<span title="Required">*</span> | `string` | *No description.* |
| [`enduserNote`](#cdktfprovideroktaappautologinpropertyendusernote)<span title="Required">*</span> | `string` | *No description.* |
| [`groups`](#cdktfprovideroktaappautologinpropertygroups)<span title="Required">*</span> | `string`[] | *No description.* |
| [`hideIos`](#cdktfprovideroktaappautologinpropertyhideios)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`hideWeb`](#cdktfprovideroktaappautologinpropertyhideweb)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`id`](#cdktfprovideroktaappautologinpropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`label`](#cdktfprovideroktaappautologinpropertylabel)<span title="Required">*</span> | `string` | *No description.* |
| [`logo`](#cdktfprovideroktaappautologinpropertylogo)<span title="Required">*</span> | `string` | *No description.* |
| [`preconfiguredApp`](#cdktfprovideroktaappautologinpropertypreconfiguredapp)<span title="Required">*</span> | `string` | *No description.* |
| [`revealPassword`](#cdktfprovideroktaappautologinpropertyrevealpassword)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`sharedPassword`](#cdktfprovideroktaappautologinpropertysharedpassword)<span title="Required">*</span> | `string` | *No description.* |
| [`sharedUsername`](#cdktfprovideroktaappautologinpropertysharedusername)<span title="Required">*</span> | `string` | *No description.* |
| [`signOnRedirectUrl`](#cdktfprovideroktaappautologinpropertysignonredirecturl)<span title="Required">*</span> | `string` | *No description.* |
| [`signOnUrl`](#cdktfprovideroktaappautologinpropertysignonurl)<span title="Required">*</span> | `string` | *No description.* |
| [`skipGroups`](#cdktfprovideroktaappautologinpropertyskipgroups)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`skipUsers`](#cdktfprovideroktaappautologinpropertyskipusers)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`status`](#cdktfprovideroktaappautologinpropertystatus)<span title="Required">*</span> | `string` | *No description.* |
| [`userNameTemplate`](#cdktfprovideroktaappautologinpropertyusernametemplate)<span title="Required">*</span> | `string` | *No description.* |
| [`userNameTemplatePushStatus`](#cdktfprovideroktaappautologinpropertyusernametemplatepushstatus)<span title="Required">*</span> | `string` | *No description.* |
| [`userNameTemplateSuffix`](#cdktfprovideroktaappautologinpropertyusernametemplatesuffix)<span title="Required">*</span> | `string` | *No description.* |
| [`userNameTemplateType`](#cdktfprovideroktaappautologinpropertyusernametemplatetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `logoUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.logoUrl" id="cdktfprovideroktaappautologinpropertylogourl"></a>

```typescript
public readonly logoUrl: string;
```

- *Type:* `string`

---

##### `name`<sup>Required</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.name" id="cdktfprovideroktaappautologinpropertyname"></a>

```typescript
public readonly name: string;
```

- *Type:* `string`

---

##### `signOnMode`<sup>Required</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.signOnMode" id="cdktfprovideroktaappautologinpropertysignonmode"></a>

```typescript
public readonly signOnMode: string;
```

- *Type:* `string`

---

##### `timeouts`<sup>Required</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.timeouts" id="cdktfprovideroktaappautologinpropertytimeouts"></a>

```typescript
public readonly timeouts: AppAutoLoginTimeoutsOutputReference;
```

- *Type:* [`@cdktf/provider-okta.AppAutoLoginTimeoutsOutputReference`](#@cdktf/provider-okta.AppAutoLoginTimeoutsOutputReference)

---

##### `users`<sup>Required</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.users" id="cdktfprovideroktaappautologinpropertyusers"></a>

```typescript
public readonly users: AppAutoLoginUsersList;
```

- *Type:* [`@cdktf/provider-okta.AppAutoLoginUsersList`](#@cdktf/provider-okta.AppAutoLoginUsersList)

---

##### `accessibilityErrorRedirectUrlInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.accessibilityErrorRedirectUrlInput" id="cdktfprovideroktaappautologinpropertyaccessibilityerrorredirecturlinput"></a>

```typescript
public readonly accessibilityErrorRedirectUrlInput: string;
```

- *Type:* `string`

---

##### `accessibilityLoginRedirectUrlInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.accessibilityLoginRedirectUrlInput" id="cdktfprovideroktaappautologinpropertyaccessibilityloginredirecturlinput"></a>

```typescript
public readonly accessibilityLoginRedirectUrlInput: string;
```

- *Type:* `string`

---

##### `accessibilitySelfServiceInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.accessibilitySelfServiceInput" id="cdktfprovideroktaappautologinpropertyaccessibilityselfserviceinput"></a>

```typescript
public readonly accessibilitySelfServiceInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `adminNoteInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.adminNoteInput" id="cdktfprovideroktaappautologinpropertyadminnoteinput"></a>

```typescript
public readonly adminNoteInput: string;
```

- *Type:* `string`

---

##### `appLinksJsonInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.appLinksJsonInput" id="cdktfprovideroktaappautologinpropertyapplinksjsoninput"></a>

```typescript
public readonly appLinksJsonInput: string;
```

- *Type:* `string`

---

##### `appSettingsJsonInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.appSettingsJsonInput" id="cdktfprovideroktaappautologinpropertyappsettingsjsoninput"></a>

```typescript
public readonly appSettingsJsonInput: string;
```

- *Type:* `string`

---

##### `autoSubmitToolbarInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.autoSubmitToolbarInput" id="cdktfprovideroktaappautologinpropertyautosubmittoolbarinput"></a>

```typescript
public readonly autoSubmitToolbarInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `credentialsSchemeInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.credentialsSchemeInput" id="cdktfprovideroktaappautologinpropertycredentialsschemeinput"></a>

```typescript
public readonly credentialsSchemeInput: string;
```

- *Type:* `string`

---

##### `enduserNoteInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.enduserNoteInput" id="cdktfprovideroktaappautologinpropertyendusernoteinput"></a>

```typescript
public readonly enduserNoteInput: string;
```

- *Type:* `string`

---

##### `groupsInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.groupsInput" id="cdktfprovideroktaappautologinpropertygroupsinput"></a>

```typescript
public readonly groupsInput: string[];
```

- *Type:* `string`[]

---

##### `hideIosInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.hideIosInput" id="cdktfprovideroktaappautologinpropertyhideiosinput"></a>

```typescript
public readonly hideIosInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `hideWebInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.hideWebInput" id="cdktfprovideroktaappautologinpropertyhidewebinput"></a>

```typescript
public readonly hideWebInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.idInput" id="cdktfprovideroktaappautologinpropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `labelInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.labelInput" id="cdktfprovideroktaappautologinpropertylabelinput"></a>

```typescript
public readonly labelInput: string;
```

- *Type:* `string`

---

##### `logoInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.logoInput" id="cdktfprovideroktaappautologinpropertylogoinput"></a>

```typescript
public readonly logoInput: string;
```

- *Type:* `string`

---

##### `preconfiguredAppInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.preconfiguredAppInput" id="cdktfprovideroktaappautologinpropertypreconfiguredappinput"></a>

```typescript
public readonly preconfiguredAppInput: string;
```

- *Type:* `string`

---

##### `revealPasswordInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.revealPasswordInput" id="cdktfprovideroktaappautologinpropertyrevealpasswordinput"></a>

```typescript
public readonly revealPasswordInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `sharedPasswordInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.sharedPasswordInput" id="cdktfprovideroktaappautologinpropertysharedpasswordinput"></a>

```typescript
public readonly sharedPasswordInput: string;
```

- *Type:* `string`

---

##### `sharedUsernameInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.sharedUsernameInput" id="cdktfprovideroktaappautologinpropertysharedusernameinput"></a>

```typescript
public readonly sharedUsernameInput: string;
```

- *Type:* `string`

---

##### `signOnRedirectUrlInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.signOnRedirectUrlInput" id="cdktfprovideroktaappautologinpropertysignonredirecturlinput"></a>

```typescript
public readonly signOnRedirectUrlInput: string;
```

- *Type:* `string`

---

##### `signOnUrlInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.signOnUrlInput" id="cdktfprovideroktaappautologinpropertysignonurlinput"></a>

```typescript
public readonly signOnUrlInput: string;
```

- *Type:* `string`

---

##### `skipGroupsInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.skipGroupsInput" id="cdktfprovideroktaappautologinpropertyskipgroupsinput"></a>

```typescript
public readonly skipGroupsInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `skipUsersInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.skipUsersInput" id="cdktfprovideroktaappautologinpropertyskipusersinput"></a>

```typescript
public readonly skipUsersInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `statusInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.statusInput" id="cdktfprovideroktaappautologinpropertystatusinput"></a>

```typescript
public readonly statusInput: string;
```

- *Type:* `string`

---

##### `timeoutsInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.timeoutsInput" id="cdktfprovideroktaappautologinpropertytimeoutsinput"></a>

```typescript
public readonly timeoutsInput: IResolvable | AppAutoLoginTimeouts;
```

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable) | [`@cdktf/provider-okta.AppAutoLoginTimeouts`](#@cdktf/provider-okta.AppAutoLoginTimeouts)

---

##### `userNameTemplateInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.userNameTemplateInput" id="cdktfprovideroktaappautologinpropertyusernametemplateinput"></a>

```typescript
public readonly userNameTemplateInput: string;
```

- *Type:* `string`

---

##### `userNameTemplatePushStatusInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.userNameTemplatePushStatusInput" id="cdktfprovideroktaappautologinpropertyusernametemplatepushstatusinput"></a>

```typescript
public readonly userNameTemplatePushStatusInput: string;
```

- *Type:* `string`

---

##### `userNameTemplateSuffixInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.userNameTemplateSuffixInput" id="cdktfprovideroktaappautologinpropertyusernametemplatesuffixinput"></a>

```typescript
public readonly userNameTemplateSuffixInput: string;
```

- *Type:* `string`

---

##### `userNameTemplateTypeInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.userNameTemplateTypeInput" id="cdktfprovideroktaappautologinpropertyusernametemplatetypeinput"></a>

```typescript
public readonly userNameTemplateTypeInput: string;
```

- *Type:* `string`

---

##### `usersInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.usersInput" id="cdktfprovideroktaappautologinpropertyusersinput"></a>

```typescript
public readonly usersInput: IResolvable | AppAutoLoginUsers[];
```

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable) | [`@cdktf/provider-okta.AppAutoLoginUsers`](#@cdktf/provider-okta.AppAutoLoginUsers)[]

---

##### `accessibilityErrorRedirectUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.accessibilityErrorRedirectUrl" id="cdktfprovideroktaappautologinpropertyaccessibilityerrorredirecturl"></a>

```typescript
public readonly accessibilityErrorRedirectUrl: string;
```

- *Type:* `string`

---

##### `accessibilityLoginRedirectUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.accessibilityLoginRedirectUrl" id="cdktfprovideroktaappautologinpropertyaccessibilityloginredirecturl"></a>

```typescript
public readonly accessibilityLoginRedirectUrl: string;
```

- *Type:* `string`

---

##### `accessibilitySelfService`<sup>Required</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.accessibilitySelfService" id="cdktfprovideroktaappautologinpropertyaccessibilityselfservice"></a>

```typescript
public readonly accessibilitySelfService: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `adminNote`<sup>Required</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.adminNote" id="cdktfprovideroktaappautologinpropertyadminnote"></a>

```typescript
public readonly adminNote: string;
```

- *Type:* `string`

---

##### `appLinksJson`<sup>Required</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.appLinksJson" id="cdktfprovideroktaappautologinpropertyapplinksjson"></a>

```typescript
public readonly appLinksJson: string;
```

- *Type:* `string`

---

##### `appSettingsJson`<sup>Required</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.appSettingsJson" id="cdktfprovideroktaappautologinpropertyappsettingsjson"></a>

```typescript
public readonly appSettingsJson: string;
```

- *Type:* `string`

---

##### `autoSubmitToolbar`<sup>Required</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.autoSubmitToolbar" id="cdktfprovideroktaappautologinpropertyautosubmittoolbar"></a>

```typescript
public readonly autoSubmitToolbar: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `credentialsScheme`<sup>Required</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.credentialsScheme" id="cdktfprovideroktaappautologinpropertycredentialsscheme"></a>

```typescript
public readonly credentialsScheme: string;
```

- *Type:* `string`

---

##### `enduserNote`<sup>Required</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.enduserNote" id="cdktfprovideroktaappautologinpropertyendusernote"></a>

```typescript
public readonly enduserNote: string;
```

- *Type:* `string`

---

##### `groups`<sup>Required</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.groups" id="cdktfprovideroktaappautologinpropertygroups"></a>

```typescript
public readonly groups: string[];
```

- *Type:* `string`[]

---

##### `hideIos`<sup>Required</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.hideIos" id="cdktfprovideroktaappautologinpropertyhideios"></a>

```typescript
public readonly hideIos: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `hideWeb`<sup>Required</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.hideWeb" id="cdktfprovideroktaappautologinpropertyhideweb"></a>

```typescript
public readonly hideWeb: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.id" id="cdktfprovideroktaappautologinpropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `label`<sup>Required</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.label" id="cdktfprovideroktaappautologinpropertylabel"></a>

```typescript
public readonly label: string;
```

- *Type:* `string`

---

##### `logo`<sup>Required</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.logo" id="cdktfprovideroktaappautologinpropertylogo"></a>

```typescript
public readonly logo: string;
```

- *Type:* `string`

---

##### `preconfiguredApp`<sup>Required</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.preconfiguredApp" id="cdktfprovideroktaappautologinpropertypreconfiguredapp"></a>

```typescript
public readonly preconfiguredApp: string;
```

- *Type:* `string`

---

##### `revealPassword`<sup>Required</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.revealPassword" id="cdktfprovideroktaappautologinpropertyrevealpassword"></a>

```typescript
public readonly revealPassword: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `sharedPassword`<sup>Required</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.sharedPassword" id="cdktfprovideroktaappautologinpropertysharedpassword"></a>

```typescript
public readonly sharedPassword: string;
```

- *Type:* `string`

---

##### `sharedUsername`<sup>Required</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.sharedUsername" id="cdktfprovideroktaappautologinpropertysharedusername"></a>

```typescript
public readonly sharedUsername: string;
```

- *Type:* `string`

---

##### `signOnRedirectUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.signOnRedirectUrl" id="cdktfprovideroktaappautologinpropertysignonredirecturl"></a>

```typescript
public readonly signOnRedirectUrl: string;
```

- *Type:* `string`

---

##### `signOnUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.signOnUrl" id="cdktfprovideroktaappautologinpropertysignonurl"></a>

```typescript
public readonly signOnUrl: string;
```

- *Type:* `string`

---

##### `skipGroups`<sup>Required</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.skipGroups" id="cdktfprovideroktaappautologinpropertyskipgroups"></a>

```typescript
public readonly skipGroups: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `skipUsers`<sup>Required</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.skipUsers" id="cdktfprovideroktaappautologinpropertyskipusers"></a>

```typescript
public readonly skipUsers: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `status`<sup>Required</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.status" id="cdktfprovideroktaappautologinpropertystatus"></a>

```typescript
public readonly status: string;
```

- *Type:* `string`

---

##### `userNameTemplate`<sup>Required</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.userNameTemplate" id="cdktfprovideroktaappautologinpropertyusernametemplate"></a>

```typescript
public readonly userNameTemplate: string;
```

- *Type:* `string`

---

##### `userNameTemplatePushStatus`<sup>Required</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.userNameTemplatePushStatus" id="cdktfprovideroktaappautologinpropertyusernametemplatepushstatus"></a>

```typescript
public readonly userNameTemplatePushStatus: string;
```

- *Type:* `string`

---

##### `userNameTemplateSuffix`<sup>Required</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.userNameTemplateSuffix" id="cdktfprovideroktaappautologinpropertyusernametemplatesuffix"></a>

```typescript
public readonly userNameTemplateSuffix: string;
```

- *Type:* `string`

---

##### `userNameTemplateType`<sup>Required</sup> <a name="@cdktf/provider-okta.AppAutoLogin.property.userNameTemplateType" id="cdktfprovideroktaappautologinpropertyusernametemplatetype"></a>

```typescript
public readonly userNameTemplateType: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktaappautologinpropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.AppAutoLogin.property.tfResourceType" id="cdktfprovideroktaappautologinpropertytfresourcetype"></a>

- *Type:* `string`

---

### AppBasicAuth <a name="@cdktf/provider-okta.AppBasicAuth" id="cdktfprovideroktaappbasicauth"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/r/app_basic_auth okta_app_basic_auth}.

#### Initializers <a name="@cdktf/provider-okta.AppBasicAuth.Initializer" id="cdktfprovideroktaappbasicauthinitializer"></a>

```typescript
import { AppBasicAuth } from '@cdktf/provider-okta'

new AppBasicAuth(scope: Construct, id: string, config: AppBasicAuthConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktaappbasicauthparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktaappbasicauthparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktaappbasicauthparameterconfig)<span title="Required">*</span> | [`@cdktf/provider-okta.AppBasicAuthConfig`](#@cdktf/provider-okta.AppBasicAuthConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.AppBasicAuth.parameter.scope" id="cdktfprovideroktaappbasicauthparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AppBasicAuth.parameter.id" id="cdktfprovideroktaappbasicauthparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="@cdktf/provider-okta.AppBasicAuth.parameter.config" id="cdktfprovideroktaappbasicauthparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.AppBasicAuthConfig`](#@cdktf/provider-okta.AppBasicAuthConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`putTimeouts`](#cdktfprovideroktaappbasicauthputtimeouts) | *No description.* |
| [`putUsers`](#cdktfprovideroktaappbasicauthputusers) | *No description.* |
| [`resetAccessibilityErrorRedirectUrl`](#cdktfprovideroktaappbasicauthresetaccessibilityerrorredirecturl) | *No description.* |
| [`resetAccessibilityLoginRedirectUrl`](#cdktfprovideroktaappbasicauthresetaccessibilityloginredirecturl) | *No description.* |
| [`resetAccessibilitySelfService`](#cdktfprovideroktaappbasicauthresetaccessibilityselfservice) | *No description.* |
| [`resetAdminNote`](#cdktfprovideroktaappbasicauthresetadminnote) | *No description.* |
| [`resetAppLinksJson`](#cdktfprovideroktaappbasicauthresetapplinksjson) | *No description.* |
| [`resetAutoSubmitToolbar`](#cdktfprovideroktaappbasicauthresetautosubmittoolbar) | *No description.* |
| [`resetEnduserNote`](#cdktfprovideroktaappbasicauthresetendusernote) | *No description.* |
| [`resetGroups`](#cdktfprovideroktaappbasicauthresetgroups) | *No description.* |
| [`resetHideIos`](#cdktfprovideroktaappbasicauthresethideios) | *No description.* |
| [`resetHideWeb`](#cdktfprovideroktaappbasicauthresethideweb) | *No description.* |
| [`resetId`](#cdktfprovideroktaappbasicauthresetid) | *No description.* |
| [`resetLogo`](#cdktfprovideroktaappbasicauthresetlogo) | *No description.* |
| [`resetSkipGroups`](#cdktfprovideroktaappbasicauthresetskipgroups) | *No description.* |
| [`resetSkipUsers`](#cdktfprovideroktaappbasicauthresetskipusers) | *No description.* |
| [`resetStatus`](#cdktfprovideroktaappbasicauthresetstatus) | *No description.* |
| [`resetTimeouts`](#cdktfprovideroktaappbasicauthresettimeouts) | *No description.* |
| [`resetUsers`](#cdktfprovideroktaappbasicauthresetusers) | *No description.* |

---

##### `putTimeouts` <a name="@cdktf/provider-okta.AppBasicAuth.putTimeouts" id="cdktfprovideroktaappbasicauthputtimeouts"></a>

```typescript
public putTimeouts(value: AppBasicAuthTimeouts)
```

###### `value`<sup>Required</sup> <a name="@cdktf/provider-okta.AppBasicAuth.parameter.value" id="cdktfprovideroktaappbasicauthparametervalue"></a>

- *Type:* [`@cdktf/provider-okta.AppBasicAuthTimeouts`](#@cdktf/provider-okta.AppBasicAuthTimeouts)

---

##### `putUsers` <a name="@cdktf/provider-okta.AppBasicAuth.putUsers" id="cdktfprovideroktaappbasicauthputusers"></a>

```typescript
public putUsers(value: IResolvable | AppBasicAuthUsers[])
```

###### `value`<sup>Required</sup> <a name="@cdktf/provider-okta.AppBasicAuth.parameter.value" id="cdktfprovideroktaappbasicauthparametervalue"></a>

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable) | [`@cdktf/provider-okta.AppBasicAuthUsers`](#@cdktf/provider-okta.AppBasicAuthUsers)[]

---

##### `resetAccessibilityErrorRedirectUrl` <a name="@cdktf/provider-okta.AppBasicAuth.resetAccessibilityErrorRedirectUrl" id="cdktfprovideroktaappbasicauthresetaccessibilityerrorredirecturl"></a>

```typescript
public resetAccessibilityErrorRedirectUrl()
```

##### `resetAccessibilityLoginRedirectUrl` <a name="@cdktf/provider-okta.AppBasicAuth.resetAccessibilityLoginRedirectUrl" id="cdktfprovideroktaappbasicauthresetaccessibilityloginredirecturl"></a>

```typescript
public resetAccessibilityLoginRedirectUrl()
```

##### `resetAccessibilitySelfService` <a name="@cdktf/provider-okta.AppBasicAuth.resetAccessibilitySelfService" id="cdktfprovideroktaappbasicauthresetaccessibilityselfservice"></a>

```typescript
public resetAccessibilitySelfService()
```

##### `resetAdminNote` <a name="@cdktf/provider-okta.AppBasicAuth.resetAdminNote" id="cdktfprovideroktaappbasicauthresetadminnote"></a>

```typescript
public resetAdminNote()
```

##### `resetAppLinksJson` <a name="@cdktf/provider-okta.AppBasicAuth.resetAppLinksJson" id="cdktfprovideroktaappbasicauthresetapplinksjson"></a>

```typescript
public resetAppLinksJson()
```

##### `resetAutoSubmitToolbar` <a name="@cdktf/provider-okta.AppBasicAuth.resetAutoSubmitToolbar" id="cdktfprovideroktaappbasicauthresetautosubmittoolbar"></a>

```typescript
public resetAutoSubmitToolbar()
```

##### `resetEnduserNote` <a name="@cdktf/provider-okta.AppBasicAuth.resetEnduserNote" id="cdktfprovideroktaappbasicauthresetendusernote"></a>

```typescript
public resetEnduserNote()
```

##### `resetGroups` <a name="@cdktf/provider-okta.AppBasicAuth.resetGroups" id="cdktfprovideroktaappbasicauthresetgroups"></a>

```typescript
public resetGroups()
```

##### `resetHideIos` <a name="@cdktf/provider-okta.AppBasicAuth.resetHideIos" id="cdktfprovideroktaappbasicauthresethideios"></a>

```typescript
public resetHideIos()
```

##### `resetHideWeb` <a name="@cdktf/provider-okta.AppBasicAuth.resetHideWeb" id="cdktfprovideroktaappbasicauthresethideweb"></a>

```typescript
public resetHideWeb()
```

##### `resetId` <a name="@cdktf/provider-okta.AppBasicAuth.resetId" id="cdktfprovideroktaappbasicauthresetid"></a>

```typescript
public resetId()
```

##### `resetLogo` <a name="@cdktf/provider-okta.AppBasicAuth.resetLogo" id="cdktfprovideroktaappbasicauthresetlogo"></a>

```typescript
public resetLogo()
```

##### `resetSkipGroups` <a name="@cdktf/provider-okta.AppBasicAuth.resetSkipGroups" id="cdktfprovideroktaappbasicauthresetskipgroups"></a>

```typescript
public resetSkipGroups()
```

##### `resetSkipUsers` <a name="@cdktf/provider-okta.AppBasicAuth.resetSkipUsers" id="cdktfprovideroktaappbasicauthresetskipusers"></a>

```typescript
public resetSkipUsers()
```

##### `resetStatus` <a name="@cdktf/provider-okta.AppBasicAuth.resetStatus" id="cdktfprovideroktaappbasicauthresetstatus"></a>

```typescript
public resetStatus()
```

##### `resetTimeouts` <a name="@cdktf/provider-okta.AppBasicAuth.resetTimeouts" id="cdktfprovideroktaappbasicauthresettimeouts"></a>

```typescript
public resetTimeouts()
```

##### `resetUsers` <a name="@cdktf/provider-okta.AppBasicAuth.resetUsers" id="cdktfprovideroktaappbasicauthresetusers"></a>

```typescript
public resetUsers()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`logoUrl`](#cdktfprovideroktaappbasicauthpropertylogourl)<span title="Required">*</span> | `string` | *No description.* |
| [`name`](#cdktfprovideroktaappbasicauthpropertyname)<span title="Required">*</span> | `string` | *No description.* |
| [`signOnMode`](#cdktfprovideroktaappbasicauthpropertysignonmode)<span title="Required">*</span> | `string` | *No description.* |
| [`timeouts`](#cdktfprovideroktaappbasicauthpropertytimeouts)<span title="Required">*</span> | [`@cdktf/provider-okta.AppBasicAuthTimeoutsOutputReference`](#@cdktf/provider-okta.AppBasicAuthTimeoutsOutputReference) | *No description.* |
| [`users`](#cdktfprovideroktaappbasicauthpropertyusers)<span title="Required">*</span> | [`@cdktf/provider-okta.AppBasicAuthUsersList`](#@cdktf/provider-okta.AppBasicAuthUsersList) | *No description.* |
| [`accessibilityErrorRedirectUrlInput`](#cdktfprovideroktaappbasicauthpropertyaccessibilityerrorredirecturlinput) | `string` | *No description.* |
| [`accessibilityLoginRedirectUrlInput`](#cdktfprovideroktaappbasicauthpropertyaccessibilityloginredirecturlinput) | `string` | *No description.* |
| [`accessibilitySelfServiceInput`](#cdktfprovideroktaappbasicauthpropertyaccessibilityselfserviceinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`adminNoteInput`](#cdktfprovideroktaappbasicauthpropertyadminnoteinput) | `string` | *No description.* |
| [`appLinksJsonInput`](#cdktfprovideroktaappbasicauthpropertyapplinksjsoninput) | `string` | *No description.* |
| [`authUrlInput`](#cdktfprovideroktaappbasicauthpropertyauthurlinput) | `string` | *No description.* |
| [`autoSubmitToolbarInput`](#cdktfprovideroktaappbasicauthpropertyautosubmittoolbarinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`enduserNoteInput`](#cdktfprovideroktaappbasicauthpropertyendusernoteinput) | `string` | *No description.* |
| [`groupsInput`](#cdktfprovideroktaappbasicauthpropertygroupsinput) | `string`[] | *No description.* |
| [`hideIosInput`](#cdktfprovideroktaappbasicauthpropertyhideiosinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`hideWebInput`](#cdktfprovideroktaappbasicauthpropertyhidewebinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`idInput`](#cdktfprovideroktaappbasicauthpropertyidinput) | `string` | *No description.* |
| [`labelInput`](#cdktfprovideroktaappbasicauthpropertylabelinput) | `string` | *No description.* |
| [`logoInput`](#cdktfprovideroktaappbasicauthpropertylogoinput) | `string` | *No description.* |
| [`skipGroupsInput`](#cdktfprovideroktaappbasicauthpropertyskipgroupsinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`skipUsersInput`](#cdktfprovideroktaappbasicauthpropertyskipusersinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`statusInput`](#cdktfprovideroktaappbasicauthpropertystatusinput) | `string` | *No description.* |
| [`timeoutsInput`](#cdktfprovideroktaappbasicauthpropertytimeoutsinput) | [`cdktf.IResolvable`](#cdktf.IResolvable) \| [`@cdktf/provider-okta.AppBasicAuthTimeouts`](#@cdktf/provider-okta.AppBasicAuthTimeouts) | *No description.* |
| [`urlInput`](#cdktfprovideroktaappbasicauthpropertyurlinput) | `string` | *No description.* |
| [`usersInput`](#cdktfprovideroktaappbasicauthpropertyusersinput) | [`cdktf.IResolvable`](#cdktf.IResolvable) \| [`@cdktf/provider-okta.AppBasicAuthUsers`](#@cdktf/provider-okta.AppBasicAuthUsers)[] | *No description.* |
| [`accessibilityErrorRedirectUrl`](#cdktfprovideroktaappbasicauthpropertyaccessibilityerrorredirecturl)<span title="Required">*</span> | `string` | *No description.* |
| [`accessibilityLoginRedirectUrl`](#cdktfprovideroktaappbasicauthpropertyaccessibilityloginredirecturl)<span title="Required">*</span> | `string` | *No description.* |
| [`accessibilitySelfService`](#cdktfprovideroktaappbasicauthpropertyaccessibilityselfservice)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`adminNote`](#cdktfprovideroktaappbasicauthpropertyadminnote)<span title="Required">*</span> | `string` | *No description.* |
| [`appLinksJson`](#cdktfprovideroktaappbasicauthpropertyapplinksjson)<span title="Required">*</span> | `string` | *No description.* |
| [`authUrl`](#cdktfprovideroktaappbasicauthpropertyauthurl)<span title="Required">*</span> | `string` | *No description.* |
| [`autoSubmitToolbar`](#cdktfprovideroktaappbasicauthpropertyautosubmittoolbar)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`enduserNote`](#cdktfprovideroktaappbasicauthpropertyendusernote)<span title="Required">*</span> | `string` | *No description.* |
| [`groups`](#cdktfprovideroktaappbasicauthpropertygroups)<span title="Required">*</span> | `string`[] | *No description.* |
| [`hideIos`](#cdktfprovideroktaappbasicauthpropertyhideios)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`hideWeb`](#cdktfprovideroktaappbasicauthpropertyhideweb)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`id`](#cdktfprovideroktaappbasicauthpropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`label`](#cdktfprovideroktaappbasicauthpropertylabel)<span title="Required">*</span> | `string` | *No description.* |
| [`logo`](#cdktfprovideroktaappbasicauthpropertylogo)<span title="Required">*</span> | `string` | *No description.* |
| [`skipGroups`](#cdktfprovideroktaappbasicauthpropertyskipgroups)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`skipUsers`](#cdktfprovideroktaappbasicauthpropertyskipusers)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`status`](#cdktfprovideroktaappbasicauthpropertystatus)<span title="Required">*</span> | `string` | *No description.* |
| [`url`](#cdktfprovideroktaappbasicauthpropertyurl)<span title="Required">*</span> | `string` | *No description.* |

---

##### `logoUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.AppBasicAuth.property.logoUrl" id="cdktfprovideroktaappbasicauthpropertylogourl"></a>

```typescript
public readonly logoUrl: string;
```

- *Type:* `string`

---

##### `name`<sup>Required</sup> <a name="@cdktf/provider-okta.AppBasicAuth.property.name" id="cdktfprovideroktaappbasicauthpropertyname"></a>

```typescript
public readonly name: string;
```

- *Type:* `string`

---

##### `signOnMode`<sup>Required</sup> <a name="@cdktf/provider-okta.AppBasicAuth.property.signOnMode" id="cdktfprovideroktaappbasicauthpropertysignonmode"></a>

```typescript
public readonly signOnMode: string;
```

- *Type:* `string`

---

##### `timeouts`<sup>Required</sup> <a name="@cdktf/provider-okta.AppBasicAuth.property.timeouts" id="cdktfprovideroktaappbasicauthpropertytimeouts"></a>

```typescript
public readonly timeouts: AppBasicAuthTimeoutsOutputReference;
```

- *Type:* [`@cdktf/provider-okta.AppBasicAuthTimeoutsOutputReference`](#@cdktf/provider-okta.AppBasicAuthTimeoutsOutputReference)

---

##### `users`<sup>Required</sup> <a name="@cdktf/provider-okta.AppBasicAuth.property.users" id="cdktfprovideroktaappbasicauthpropertyusers"></a>

```typescript
public readonly users: AppBasicAuthUsersList;
```

- *Type:* [`@cdktf/provider-okta.AppBasicAuthUsersList`](#@cdktf/provider-okta.AppBasicAuthUsersList)

---

##### `accessibilityErrorRedirectUrlInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppBasicAuth.property.accessibilityErrorRedirectUrlInput" id="cdktfprovideroktaappbasicauthpropertyaccessibilityerrorredirecturlinput"></a>

```typescript
public readonly accessibilityErrorRedirectUrlInput: string;
```

- *Type:* `string`

---

##### `accessibilityLoginRedirectUrlInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppBasicAuth.property.accessibilityLoginRedirectUrlInput" id="cdktfprovideroktaappbasicauthpropertyaccessibilityloginredirecturlinput"></a>

```typescript
public readonly accessibilityLoginRedirectUrlInput: string;
```

- *Type:* `string`

---

##### `accessibilitySelfServiceInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppBasicAuth.property.accessibilitySelfServiceInput" id="cdktfprovideroktaappbasicauthpropertyaccessibilityselfserviceinput"></a>

```typescript
public readonly accessibilitySelfServiceInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `adminNoteInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppBasicAuth.property.adminNoteInput" id="cdktfprovideroktaappbasicauthpropertyadminnoteinput"></a>

```typescript
public readonly adminNoteInput: string;
```

- *Type:* `string`

---

##### `appLinksJsonInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppBasicAuth.property.appLinksJsonInput" id="cdktfprovideroktaappbasicauthpropertyapplinksjsoninput"></a>

```typescript
public readonly appLinksJsonInput: string;
```

- *Type:* `string`

---

##### `authUrlInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppBasicAuth.property.authUrlInput" id="cdktfprovideroktaappbasicauthpropertyauthurlinput"></a>

```typescript
public readonly authUrlInput: string;
```

- *Type:* `string`

---

##### `autoSubmitToolbarInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppBasicAuth.property.autoSubmitToolbarInput" id="cdktfprovideroktaappbasicauthpropertyautosubmittoolbarinput"></a>

```typescript
public readonly autoSubmitToolbarInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `enduserNoteInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppBasicAuth.property.enduserNoteInput" id="cdktfprovideroktaappbasicauthpropertyendusernoteinput"></a>

```typescript
public readonly enduserNoteInput: string;
```

- *Type:* `string`

---

##### `groupsInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppBasicAuth.property.groupsInput" id="cdktfprovideroktaappbasicauthpropertygroupsinput"></a>

```typescript
public readonly groupsInput: string[];
```

- *Type:* `string`[]

---

##### `hideIosInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppBasicAuth.property.hideIosInput" id="cdktfprovideroktaappbasicauthpropertyhideiosinput"></a>

```typescript
public readonly hideIosInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `hideWebInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppBasicAuth.property.hideWebInput" id="cdktfprovideroktaappbasicauthpropertyhidewebinput"></a>

```typescript
public readonly hideWebInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppBasicAuth.property.idInput" id="cdktfprovideroktaappbasicauthpropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `labelInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppBasicAuth.property.labelInput" id="cdktfprovideroktaappbasicauthpropertylabelinput"></a>

```typescript
public readonly labelInput: string;
```

- *Type:* `string`

---

##### `logoInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppBasicAuth.property.logoInput" id="cdktfprovideroktaappbasicauthpropertylogoinput"></a>

```typescript
public readonly logoInput: string;
```

- *Type:* `string`

---

##### `skipGroupsInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppBasicAuth.property.skipGroupsInput" id="cdktfprovideroktaappbasicauthpropertyskipgroupsinput"></a>

```typescript
public readonly skipGroupsInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `skipUsersInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppBasicAuth.property.skipUsersInput" id="cdktfprovideroktaappbasicauthpropertyskipusersinput"></a>

```typescript
public readonly skipUsersInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `statusInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppBasicAuth.property.statusInput" id="cdktfprovideroktaappbasicauthpropertystatusinput"></a>

```typescript
public readonly statusInput: string;
```

- *Type:* `string`

---

##### `timeoutsInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppBasicAuth.property.timeoutsInput" id="cdktfprovideroktaappbasicauthpropertytimeoutsinput"></a>

```typescript
public readonly timeoutsInput: IResolvable | AppBasicAuthTimeouts;
```

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable) | [`@cdktf/provider-okta.AppBasicAuthTimeouts`](#@cdktf/provider-okta.AppBasicAuthTimeouts)

---

##### `urlInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppBasicAuth.property.urlInput" id="cdktfprovideroktaappbasicauthpropertyurlinput"></a>

```typescript
public readonly urlInput: string;
```

- *Type:* `string`

---

##### `usersInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppBasicAuth.property.usersInput" id="cdktfprovideroktaappbasicauthpropertyusersinput"></a>

```typescript
public readonly usersInput: IResolvable | AppBasicAuthUsers[];
```

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable) | [`@cdktf/provider-okta.AppBasicAuthUsers`](#@cdktf/provider-okta.AppBasicAuthUsers)[]

---

##### `accessibilityErrorRedirectUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.AppBasicAuth.property.accessibilityErrorRedirectUrl" id="cdktfprovideroktaappbasicauthpropertyaccessibilityerrorredirecturl"></a>

```typescript
public readonly accessibilityErrorRedirectUrl: string;
```

- *Type:* `string`

---

##### `accessibilityLoginRedirectUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.AppBasicAuth.property.accessibilityLoginRedirectUrl" id="cdktfprovideroktaappbasicauthpropertyaccessibilityloginredirecturl"></a>

```typescript
public readonly accessibilityLoginRedirectUrl: string;
```

- *Type:* `string`

---

##### `accessibilitySelfService`<sup>Required</sup> <a name="@cdktf/provider-okta.AppBasicAuth.property.accessibilitySelfService" id="cdktfprovideroktaappbasicauthpropertyaccessibilityselfservice"></a>

```typescript
public readonly accessibilitySelfService: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `adminNote`<sup>Required</sup> <a name="@cdktf/provider-okta.AppBasicAuth.property.adminNote" id="cdktfprovideroktaappbasicauthpropertyadminnote"></a>

```typescript
public readonly adminNote: string;
```

- *Type:* `string`

---

##### `appLinksJson`<sup>Required</sup> <a name="@cdktf/provider-okta.AppBasicAuth.property.appLinksJson" id="cdktfprovideroktaappbasicauthpropertyapplinksjson"></a>

```typescript
public readonly appLinksJson: string;
```

- *Type:* `string`

---

##### `authUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.AppBasicAuth.property.authUrl" id="cdktfprovideroktaappbasicauthpropertyauthurl"></a>

```typescript
public readonly authUrl: string;
```

- *Type:* `string`

---

##### `autoSubmitToolbar`<sup>Required</sup> <a name="@cdktf/provider-okta.AppBasicAuth.property.autoSubmitToolbar" id="cdktfprovideroktaappbasicauthpropertyautosubmittoolbar"></a>

```typescript
public readonly autoSubmitToolbar: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `enduserNote`<sup>Required</sup> <a name="@cdktf/provider-okta.AppBasicAuth.property.enduserNote" id="cdktfprovideroktaappbasicauthpropertyendusernote"></a>

```typescript
public readonly enduserNote: string;
```

- *Type:* `string`

---

##### `groups`<sup>Required</sup> <a name="@cdktf/provider-okta.AppBasicAuth.property.groups" id="cdktfprovideroktaappbasicauthpropertygroups"></a>

```typescript
public readonly groups: string[];
```

- *Type:* `string`[]

---

##### `hideIos`<sup>Required</sup> <a name="@cdktf/provider-okta.AppBasicAuth.property.hideIos" id="cdktfprovideroktaappbasicauthpropertyhideios"></a>

```typescript
public readonly hideIos: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `hideWeb`<sup>Required</sup> <a name="@cdktf/provider-okta.AppBasicAuth.property.hideWeb" id="cdktfprovideroktaappbasicauthpropertyhideweb"></a>

```typescript
public readonly hideWeb: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AppBasicAuth.property.id" id="cdktfprovideroktaappbasicauthpropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `label`<sup>Required</sup> <a name="@cdktf/provider-okta.AppBasicAuth.property.label" id="cdktfprovideroktaappbasicauthpropertylabel"></a>

```typescript
public readonly label: string;
```

- *Type:* `string`

---

##### `logo`<sup>Required</sup> <a name="@cdktf/provider-okta.AppBasicAuth.property.logo" id="cdktfprovideroktaappbasicauthpropertylogo"></a>

```typescript
public readonly logo: string;
```

- *Type:* `string`

---

##### `skipGroups`<sup>Required</sup> <a name="@cdktf/provider-okta.AppBasicAuth.property.skipGroups" id="cdktfprovideroktaappbasicauthpropertyskipgroups"></a>

```typescript
public readonly skipGroups: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `skipUsers`<sup>Required</sup> <a name="@cdktf/provider-okta.AppBasicAuth.property.skipUsers" id="cdktfprovideroktaappbasicauthpropertyskipusers"></a>

```typescript
public readonly skipUsers: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `status`<sup>Required</sup> <a name="@cdktf/provider-okta.AppBasicAuth.property.status" id="cdktfprovideroktaappbasicauthpropertystatus"></a>

```typescript
public readonly status: string;
```

- *Type:* `string`

---

##### `url`<sup>Required</sup> <a name="@cdktf/provider-okta.AppBasicAuth.property.url" id="cdktfprovideroktaappbasicauthpropertyurl"></a>

```typescript
public readonly url: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktaappbasicauthpropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.AppBasicAuth.property.tfResourceType" id="cdktfprovideroktaappbasicauthpropertytfresourcetype"></a>

- *Type:* `string`

---

### AppBookmark <a name="@cdktf/provider-okta.AppBookmark" id="cdktfprovideroktaappbookmark"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/r/app_bookmark okta_app_bookmark}.

#### Initializers <a name="@cdktf/provider-okta.AppBookmark.Initializer" id="cdktfprovideroktaappbookmarkinitializer"></a>

```typescript
import { AppBookmark } from '@cdktf/provider-okta'

new AppBookmark(scope: Construct, id: string, config: AppBookmarkConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktaappbookmarkparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktaappbookmarkparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktaappbookmarkparameterconfig)<span title="Required">*</span> | [`@cdktf/provider-okta.AppBookmarkConfig`](#@cdktf/provider-okta.AppBookmarkConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.AppBookmark.parameter.scope" id="cdktfprovideroktaappbookmarkparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AppBookmark.parameter.id" id="cdktfprovideroktaappbookmarkparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="@cdktf/provider-okta.AppBookmark.parameter.config" id="cdktfprovideroktaappbookmarkparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.AppBookmarkConfig`](#@cdktf/provider-okta.AppBookmarkConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`putTimeouts`](#cdktfprovideroktaappbookmarkputtimeouts) | *No description.* |
| [`putUsers`](#cdktfprovideroktaappbookmarkputusers) | *No description.* |
| [`resetAccessibilityErrorRedirectUrl`](#cdktfprovideroktaappbookmarkresetaccessibilityerrorredirecturl) | *No description.* |
| [`resetAccessibilityLoginRedirectUrl`](#cdktfprovideroktaappbookmarkresetaccessibilityloginredirecturl) | *No description.* |
| [`resetAccessibilitySelfService`](#cdktfprovideroktaappbookmarkresetaccessibilityselfservice) | *No description.* |
| [`resetAdminNote`](#cdktfprovideroktaappbookmarkresetadminnote) | *No description.* |
| [`resetAppLinksJson`](#cdktfprovideroktaappbookmarkresetapplinksjson) | *No description.* |
| [`resetAutoSubmitToolbar`](#cdktfprovideroktaappbookmarkresetautosubmittoolbar) | *No description.* |
| [`resetEnduserNote`](#cdktfprovideroktaappbookmarkresetendusernote) | *No description.* |
| [`resetGroups`](#cdktfprovideroktaappbookmarkresetgroups) | *No description.* |
| [`resetHideIos`](#cdktfprovideroktaappbookmarkresethideios) | *No description.* |
| [`resetHideWeb`](#cdktfprovideroktaappbookmarkresethideweb) | *No description.* |
| [`resetId`](#cdktfprovideroktaappbookmarkresetid) | *No description.* |
| [`resetLogo`](#cdktfprovideroktaappbookmarkresetlogo) | *No description.* |
| [`resetRequestIntegration`](#cdktfprovideroktaappbookmarkresetrequestintegration) | *No description.* |
| [`resetSkipGroups`](#cdktfprovideroktaappbookmarkresetskipgroups) | *No description.* |
| [`resetSkipUsers`](#cdktfprovideroktaappbookmarkresetskipusers) | *No description.* |
| [`resetStatus`](#cdktfprovideroktaappbookmarkresetstatus) | *No description.* |
| [`resetTimeouts`](#cdktfprovideroktaappbookmarkresettimeouts) | *No description.* |
| [`resetUsers`](#cdktfprovideroktaappbookmarkresetusers) | *No description.* |

---

##### `putTimeouts` <a name="@cdktf/provider-okta.AppBookmark.putTimeouts" id="cdktfprovideroktaappbookmarkputtimeouts"></a>

```typescript
public putTimeouts(value: AppBookmarkTimeouts)
```

###### `value`<sup>Required</sup> <a name="@cdktf/provider-okta.AppBookmark.parameter.value" id="cdktfprovideroktaappbookmarkparametervalue"></a>

- *Type:* [`@cdktf/provider-okta.AppBookmarkTimeouts`](#@cdktf/provider-okta.AppBookmarkTimeouts)

---

##### `putUsers` <a name="@cdktf/provider-okta.AppBookmark.putUsers" id="cdktfprovideroktaappbookmarkputusers"></a>

```typescript
public putUsers(value: IResolvable | AppBookmarkUsers[])
```

###### `value`<sup>Required</sup> <a name="@cdktf/provider-okta.AppBookmark.parameter.value" id="cdktfprovideroktaappbookmarkparametervalue"></a>

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable) | [`@cdktf/provider-okta.AppBookmarkUsers`](#@cdktf/provider-okta.AppBookmarkUsers)[]

---

##### `resetAccessibilityErrorRedirectUrl` <a name="@cdktf/provider-okta.AppBookmark.resetAccessibilityErrorRedirectUrl" id="cdktfprovideroktaappbookmarkresetaccessibilityerrorredirecturl"></a>

```typescript
public resetAccessibilityErrorRedirectUrl()
```

##### `resetAccessibilityLoginRedirectUrl` <a name="@cdktf/provider-okta.AppBookmark.resetAccessibilityLoginRedirectUrl" id="cdktfprovideroktaappbookmarkresetaccessibilityloginredirecturl"></a>

```typescript
public resetAccessibilityLoginRedirectUrl()
```

##### `resetAccessibilitySelfService` <a name="@cdktf/provider-okta.AppBookmark.resetAccessibilitySelfService" id="cdktfprovideroktaappbookmarkresetaccessibilityselfservice"></a>

```typescript
public resetAccessibilitySelfService()
```

##### `resetAdminNote` <a name="@cdktf/provider-okta.AppBookmark.resetAdminNote" id="cdktfprovideroktaappbookmarkresetadminnote"></a>

```typescript
public resetAdminNote()
```

##### `resetAppLinksJson` <a name="@cdktf/provider-okta.AppBookmark.resetAppLinksJson" id="cdktfprovideroktaappbookmarkresetapplinksjson"></a>

```typescript
public resetAppLinksJson()
```

##### `resetAutoSubmitToolbar` <a name="@cdktf/provider-okta.AppBookmark.resetAutoSubmitToolbar" id="cdktfprovideroktaappbookmarkresetautosubmittoolbar"></a>

```typescript
public resetAutoSubmitToolbar()
```

##### `resetEnduserNote` <a name="@cdktf/provider-okta.AppBookmark.resetEnduserNote" id="cdktfprovideroktaappbookmarkresetendusernote"></a>

```typescript
public resetEnduserNote()
```

##### `resetGroups` <a name="@cdktf/provider-okta.AppBookmark.resetGroups" id="cdktfprovideroktaappbookmarkresetgroups"></a>

```typescript
public resetGroups()
```

##### `resetHideIos` <a name="@cdktf/provider-okta.AppBookmark.resetHideIos" id="cdktfprovideroktaappbookmarkresethideios"></a>

```typescript
public resetHideIos()
```

##### `resetHideWeb` <a name="@cdktf/provider-okta.AppBookmark.resetHideWeb" id="cdktfprovideroktaappbookmarkresethideweb"></a>

```typescript
public resetHideWeb()
```

##### `resetId` <a name="@cdktf/provider-okta.AppBookmark.resetId" id="cdktfprovideroktaappbookmarkresetid"></a>

```typescript
public resetId()
```

##### `resetLogo` <a name="@cdktf/provider-okta.AppBookmark.resetLogo" id="cdktfprovideroktaappbookmarkresetlogo"></a>

```typescript
public resetLogo()
```

##### `resetRequestIntegration` <a name="@cdktf/provider-okta.AppBookmark.resetRequestIntegration" id="cdktfprovideroktaappbookmarkresetrequestintegration"></a>

```typescript
public resetRequestIntegration()
```

##### `resetSkipGroups` <a name="@cdktf/provider-okta.AppBookmark.resetSkipGroups" id="cdktfprovideroktaappbookmarkresetskipgroups"></a>

```typescript
public resetSkipGroups()
```

##### `resetSkipUsers` <a name="@cdktf/provider-okta.AppBookmark.resetSkipUsers" id="cdktfprovideroktaappbookmarkresetskipusers"></a>

```typescript
public resetSkipUsers()
```

##### `resetStatus` <a name="@cdktf/provider-okta.AppBookmark.resetStatus" id="cdktfprovideroktaappbookmarkresetstatus"></a>

```typescript
public resetStatus()
```

##### `resetTimeouts` <a name="@cdktf/provider-okta.AppBookmark.resetTimeouts" id="cdktfprovideroktaappbookmarkresettimeouts"></a>

```typescript
public resetTimeouts()
```

##### `resetUsers` <a name="@cdktf/provider-okta.AppBookmark.resetUsers" id="cdktfprovideroktaappbookmarkresetusers"></a>

```typescript
public resetUsers()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`logoUrl`](#cdktfprovideroktaappbookmarkpropertylogourl)<span title="Required">*</span> | `string` | *No description.* |
| [`name`](#cdktfprovideroktaappbookmarkpropertyname)<span title="Required">*</span> | `string` | *No description.* |
| [`signOnMode`](#cdktfprovideroktaappbookmarkpropertysignonmode)<span title="Required">*</span> | `string` | *No description.* |
| [`timeouts`](#cdktfprovideroktaappbookmarkpropertytimeouts)<span title="Required">*</span> | [`@cdktf/provider-okta.AppBookmarkTimeoutsOutputReference`](#@cdktf/provider-okta.AppBookmarkTimeoutsOutputReference) | *No description.* |
| [`users`](#cdktfprovideroktaappbookmarkpropertyusers)<span title="Required">*</span> | [`@cdktf/provider-okta.AppBookmarkUsersList`](#@cdktf/provider-okta.AppBookmarkUsersList) | *No description.* |
| [`accessibilityErrorRedirectUrlInput`](#cdktfprovideroktaappbookmarkpropertyaccessibilityerrorredirecturlinput) | `string` | *No description.* |
| [`accessibilityLoginRedirectUrlInput`](#cdktfprovideroktaappbookmarkpropertyaccessibilityloginredirecturlinput) | `string` | *No description.* |
| [`accessibilitySelfServiceInput`](#cdktfprovideroktaappbookmarkpropertyaccessibilityselfserviceinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`adminNoteInput`](#cdktfprovideroktaappbookmarkpropertyadminnoteinput) | `string` | *No description.* |
| [`appLinksJsonInput`](#cdktfprovideroktaappbookmarkpropertyapplinksjsoninput) | `string` | *No description.* |
| [`autoSubmitToolbarInput`](#cdktfprovideroktaappbookmarkpropertyautosubmittoolbarinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`enduserNoteInput`](#cdktfprovideroktaappbookmarkpropertyendusernoteinput) | `string` | *No description.* |
| [`groupsInput`](#cdktfprovideroktaappbookmarkpropertygroupsinput) | `string`[] | *No description.* |
| [`hideIosInput`](#cdktfprovideroktaappbookmarkpropertyhideiosinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`hideWebInput`](#cdktfprovideroktaappbookmarkpropertyhidewebinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`idInput`](#cdktfprovideroktaappbookmarkpropertyidinput) | `string` | *No description.* |
| [`labelInput`](#cdktfprovideroktaappbookmarkpropertylabelinput) | `string` | *No description.* |
| [`logoInput`](#cdktfprovideroktaappbookmarkpropertylogoinput) | `string` | *No description.* |
| [`requestIntegrationInput`](#cdktfprovideroktaappbookmarkpropertyrequestintegrationinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`skipGroupsInput`](#cdktfprovideroktaappbookmarkpropertyskipgroupsinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`skipUsersInput`](#cdktfprovideroktaappbookmarkpropertyskipusersinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`statusInput`](#cdktfprovideroktaappbookmarkpropertystatusinput) | `string` | *No description.* |
| [`timeoutsInput`](#cdktfprovideroktaappbookmarkpropertytimeoutsinput) | [`cdktf.IResolvable`](#cdktf.IResolvable) \| [`@cdktf/provider-okta.AppBookmarkTimeouts`](#@cdktf/provider-okta.AppBookmarkTimeouts) | *No description.* |
| [`urlInput`](#cdktfprovideroktaappbookmarkpropertyurlinput) | `string` | *No description.* |
| [`usersInput`](#cdktfprovideroktaappbookmarkpropertyusersinput) | [`cdktf.IResolvable`](#cdktf.IResolvable) \| [`@cdktf/provider-okta.AppBookmarkUsers`](#@cdktf/provider-okta.AppBookmarkUsers)[] | *No description.* |
| [`accessibilityErrorRedirectUrl`](#cdktfprovideroktaappbookmarkpropertyaccessibilityerrorredirecturl)<span title="Required">*</span> | `string` | *No description.* |
| [`accessibilityLoginRedirectUrl`](#cdktfprovideroktaappbookmarkpropertyaccessibilityloginredirecturl)<span title="Required">*</span> | `string` | *No description.* |
| [`accessibilitySelfService`](#cdktfprovideroktaappbookmarkpropertyaccessibilityselfservice)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`adminNote`](#cdktfprovideroktaappbookmarkpropertyadminnote)<span title="Required">*</span> | `string` | *No description.* |
| [`appLinksJson`](#cdktfprovideroktaappbookmarkpropertyapplinksjson)<span title="Required">*</span> | `string` | *No description.* |
| [`autoSubmitToolbar`](#cdktfprovideroktaappbookmarkpropertyautosubmittoolbar)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`enduserNote`](#cdktfprovideroktaappbookmarkpropertyendusernote)<span title="Required">*</span> | `string` | *No description.* |
| [`groups`](#cdktfprovideroktaappbookmarkpropertygroups)<span title="Required">*</span> | `string`[] | *No description.* |
| [`hideIos`](#cdktfprovideroktaappbookmarkpropertyhideios)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`hideWeb`](#cdktfprovideroktaappbookmarkpropertyhideweb)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`id`](#cdktfprovideroktaappbookmarkpropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`label`](#cdktfprovideroktaappbookmarkpropertylabel)<span title="Required">*</span> | `string` | *No description.* |
| [`logo`](#cdktfprovideroktaappbookmarkpropertylogo)<span title="Required">*</span> | `string` | *No description.* |
| [`requestIntegration`](#cdktfprovideroktaappbookmarkpropertyrequestintegration)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`skipGroups`](#cdktfprovideroktaappbookmarkpropertyskipgroups)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`skipUsers`](#cdktfprovideroktaappbookmarkpropertyskipusers)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`status`](#cdktfprovideroktaappbookmarkpropertystatus)<span title="Required">*</span> | `string` | *No description.* |
| [`url`](#cdktfprovideroktaappbookmarkpropertyurl)<span title="Required">*</span> | `string` | *No description.* |

---

##### `logoUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.AppBookmark.property.logoUrl" id="cdktfprovideroktaappbookmarkpropertylogourl"></a>

```typescript
public readonly logoUrl: string;
```

- *Type:* `string`

---

##### `name`<sup>Required</sup> <a name="@cdktf/provider-okta.AppBookmark.property.name" id="cdktfprovideroktaappbookmarkpropertyname"></a>

```typescript
public readonly name: string;
```

- *Type:* `string`

---

##### `signOnMode`<sup>Required</sup> <a name="@cdktf/provider-okta.AppBookmark.property.signOnMode" id="cdktfprovideroktaappbookmarkpropertysignonmode"></a>

```typescript
public readonly signOnMode: string;
```

- *Type:* `string`

---

##### `timeouts`<sup>Required</sup> <a name="@cdktf/provider-okta.AppBookmark.property.timeouts" id="cdktfprovideroktaappbookmarkpropertytimeouts"></a>

```typescript
public readonly timeouts: AppBookmarkTimeoutsOutputReference;
```

- *Type:* [`@cdktf/provider-okta.AppBookmarkTimeoutsOutputReference`](#@cdktf/provider-okta.AppBookmarkTimeoutsOutputReference)

---

##### `users`<sup>Required</sup> <a name="@cdktf/provider-okta.AppBookmark.property.users" id="cdktfprovideroktaappbookmarkpropertyusers"></a>

```typescript
public readonly users: AppBookmarkUsersList;
```

- *Type:* [`@cdktf/provider-okta.AppBookmarkUsersList`](#@cdktf/provider-okta.AppBookmarkUsersList)

---

##### `accessibilityErrorRedirectUrlInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppBookmark.property.accessibilityErrorRedirectUrlInput" id="cdktfprovideroktaappbookmarkpropertyaccessibilityerrorredirecturlinput"></a>

```typescript
public readonly accessibilityErrorRedirectUrlInput: string;
```

- *Type:* `string`

---

##### `accessibilityLoginRedirectUrlInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppBookmark.property.accessibilityLoginRedirectUrlInput" id="cdktfprovideroktaappbookmarkpropertyaccessibilityloginredirecturlinput"></a>

```typescript
public readonly accessibilityLoginRedirectUrlInput: string;
```

- *Type:* `string`

---

##### `accessibilitySelfServiceInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppBookmark.property.accessibilitySelfServiceInput" id="cdktfprovideroktaappbookmarkpropertyaccessibilityselfserviceinput"></a>

```typescript
public readonly accessibilitySelfServiceInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `adminNoteInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppBookmark.property.adminNoteInput" id="cdktfprovideroktaappbookmarkpropertyadminnoteinput"></a>

```typescript
public readonly adminNoteInput: string;
```

- *Type:* `string`

---

##### `appLinksJsonInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppBookmark.property.appLinksJsonInput" id="cdktfprovideroktaappbookmarkpropertyapplinksjsoninput"></a>

```typescript
public readonly appLinksJsonInput: string;
```

- *Type:* `string`

---

##### `autoSubmitToolbarInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppBookmark.property.autoSubmitToolbarInput" id="cdktfprovideroktaappbookmarkpropertyautosubmittoolbarinput"></a>

```typescript
public readonly autoSubmitToolbarInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `enduserNoteInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppBookmark.property.enduserNoteInput" id="cdktfprovideroktaappbookmarkpropertyendusernoteinput"></a>

```typescript
public readonly enduserNoteInput: string;
```

- *Type:* `string`

---

##### `groupsInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppBookmark.property.groupsInput" id="cdktfprovideroktaappbookmarkpropertygroupsinput"></a>

```typescript
public readonly groupsInput: string[];
```

- *Type:* `string`[]

---

##### `hideIosInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppBookmark.property.hideIosInput" id="cdktfprovideroktaappbookmarkpropertyhideiosinput"></a>

```typescript
public readonly hideIosInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `hideWebInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppBookmark.property.hideWebInput" id="cdktfprovideroktaappbookmarkpropertyhidewebinput"></a>

```typescript
public readonly hideWebInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppBookmark.property.idInput" id="cdktfprovideroktaappbookmarkpropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `labelInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppBookmark.property.labelInput" id="cdktfprovideroktaappbookmarkpropertylabelinput"></a>

```typescript
public readonly labelInput: string;
```

- *Type:* `string`

---

##### `logoInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppBookmark.property.logoInput" id="cdktfprovideroktaappbookmarkpropertylogoinput"></a>

```typescript
public readonly logoInput: string;
```

- *Type:* `string`

---

##### `requestIntegrationInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppBookmark.property.requestIntegrationInput" id="cdktfprovideroktaappbookmarkpropertyrequestintegrationinput"></a>

```typescript
public readonly requestIntegrationInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `skipGroupsInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppBookmark.property.skipGroupsInput" id="cdktfprovideroktaappbookmarkpropertyskipgroupsinput"></a>

```typescript
public readonly skipGroupsInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `skipUsersInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppBookmark.property.skipUsersInput" id="cdktfprovideroktaappbookmarkpropertyskipusersinput"></a>

```typescript
public readonly skipUsersInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `statusInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppBookmark.property.statusInput" id="cdktfprovideroktaappbookmarkpropertystatusinput"></a>

```typescript
public readonly statusInput: string;
```

- *Type:* `string`

---

##### `timeoutsInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppBookmark.property.timeoutsInput" id="cdktfprovideroktaappbookmarkpropertytimeoutsinput"></a>

```typescript
public readonly timeoutsInput: IResolvable | AppBookmarkTimeouts;
```

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable) | [`@cdktf/provider-okta.AppBookmarkTimeouts`](#@cdktf/provider-okta.AppBookmarkTimeouts)

---

##### `urlInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppBookmark.property.urlInput" id="cdktfprovideroktaappbookmarkpropertyurlinput"></a>

```typescript
public readonly urlInput: string;
```

- *Type:* `string`

---

##### `usersInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppBookmark.property.usersInput" id="cdktfprovideroktaappbookmarkpropertyusersinput"></a>

```typescript
public readonly usersInput: IResolvable | AppBookmarkUsers[];
```

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable) | [`@cdktf/provider-okta.AppBookmarkUsers`](#@cdktf/provider-okta.AppBookmarkUsers)[]

---

##### `accessibilityErrorRedirectUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.AppBookmark.property.accessibilityErrorRedirectUrl" id="cdktfprovideroktaappbookmarkpropertyaccessibilityerrorredirecturl"></a>

```typescript
public readonly accessibilityErrorRedirectUrl: string;
```

- *Type:* `string`

---

##### `accessibilityLoginRedirectUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.AppBookmark.property.accessibilityLoginRedirectUrl" id="cdktfprovideroktaappbookmarkpropertyaccessibilityloginredirecturl"></a>

```typescript
public readonly accessibilityLoginRedirectUrl: string;
```

- *Type:* `string`

---

##### `accessibilitySelfService`<sup>Required</sup> <a name="@cdktf/provider-okta.AppBookmark.property.accessibilitySelfService" id="cdktfprovideroktaappbookmarkpropertyaccessibilityselfservice"></a>

```typescript
public readonly accessibilitySelfService: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `adminNote`<sup>Required</sup> <a name="@cdktf/provider-okta.AppBookmark.property.adminNote" id="cdktfprovideroktaappbookmarkpropertyadminnote"></a>

```typescript
public readonly adminNote: string;
```

- *Type:* `string`

---

##### `appLinksJson`<sup>Required</sup> <a name="@cdktf/provider-okta.AppBookmark.property.appLinksJson" id="cdktfprovideroktaappbookmarkpropertyapplinksjson"></a>

```typescript
public readonly appLinksJson: string;
```

- *Type:* `string`

---

##### `autoSubmitToolbar`<sup>Required</sup> <a name="@cdktf/provider-okta.AppBookmark.property.autoSubmitToolbar" id="cdktfprovideroktaappbookmarkpropertyautosubmittoolbar"></a>

```typescript
public readonly autoSubmitToolbar: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `enduserNote`<sup>Required</sup> <a name="@cdktf/provider-okta.AppBookmark.property.enduserNote" id="cdktfprovideroktaappbookmarkpropertyendusernote"></a>

```typescript
public readonly enduserNote: string;
```

- *Type:* `string`

---

##### `groups`<sup>Required</sup> <a name="@cdktf/provider-okta.AppBookmark.property.groups" id="cdktfprovideroktaappbookmarkpropertygroups"></a>

```typescript
public readonly groups: string[];
```

- *Type:* `string`[]

---

##### `hideIos`<sup>Required</sup> <a name="@cdktf/provider-okta.AppBookmark.property.hideIos" id="cdktfprovideroktaappbookmarkpropertyhideios"></a>

```typescript
public readonly hideIos: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `hideWeb`<sup>Required</sup> <a name="@cdktf/provider-okta.AppBookmark.property.hideWeb" id="cdktfprovideroktaappbookmarkpropertyhideweb"></a>

```typescript
public readonly hideWeb: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AppBookmark.property.id" id="cdktfprovideroktaappbookmarkpropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `label`<sup>Required</sup> <a name="@cdktf/provider-okta.AppBookmark.property.label" id="cdktfprovideroktaappbookmarkpropertylabel"></a>

```typescript
public readonly label: string;
```

- *Type:* `string`

---

##### `logo`<sup>Required</sup> <a name="@cdktf/provider-okta.AppBookmark.property.logo" id="cdktfprovideroktaappbookmarkpropertylogo"></a>

```typescript
public readonly logo: string;
```

- *Type:* `string`

---

##### `requestIntegration`<sup>Required</sup> <a name="@cdktf/provider-okta.AppBookmark.property.requestIntegration" id="cdktfprovideroktaappbookmarkpropertyrequestintegration"></a>

```typescript
public readonly requestIntegration: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `skipGroups`<sup>Required</sup> <a name="@cdktf/provider-okta.AppBookmark.property.skipGroups" id="cdktfprovideroktaappbookmarkpropertyskipgroups"></a>

```typescript
public readonly skipGroups: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `skipUsers`<sup>Required</sup> <a name="@cdktf/provider-okta.AppBookmark.property.skipUsers" id="cdktfprovideroktaappbookmarkpropertyskipusers"></a>

```typescript
public readonly skipUsers: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `status`<sup>Required</sup> <a name="@cdktf/provider-okta.AppBookmark.property.status" id="cdktfprovideroktaappbookmarkpropertystatus"></a>

```typescript
public readonly status: string;
```

- *Type:* `string`

---

##### `url`<sup>Required</sup> <a name="@cdktf/provider-okta.AppBookmark.property.url" id="cdktfprovideroktaappbookmarkpropertyurl"></a>

```typescript
public readonly url: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktaappbookmarkpropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.AppBookmark.property.tfResourceType" id="cdktfprovideroktaappbookmarkpropertytfresourcetype"></a>

- *Type:* `string`

---

### AppGroupAssignment <a name="@cdktf/provider-okta.AppGroupAssignment" id="cdktfprovideroktaappgroupassignment"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/r/app_group_assignment okta_app_group_assignment}.

#### Initializers <a name="@cdktf/provider-okta.AppGroupAssignment.Initializer" id="cdktfprovideroktaappgroupassignmentinitializer"></a>

```typescript
import { AppGroupAssignment } from '@cdktf/provider-okta'

new AppGroupAssignment(scope: Construct, id: string, config: AppGroupAssignmentConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktaappgroupassignmentparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktaappgroupassignmentparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktaappgroupassignmentparameterconfig)<span title="Required">*</span> | [`@cdktf/provider-okta.AppGroupAssignmentConfig`](#@cdktf/provider-okta.AppGroupAssignmentConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.AppGroupAssignment.parameter.scope" id="cdktfprovideroktaappgroupassignmentparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AppGroupAssignment.parameter.id" id="cdktfprovideroktaappgroupassignmentparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="@cdktf/provider-okta.AppGroupAssignment.parameter.config" id="cdktfprovideroktaappgroupassignmentparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.AppGroupAssignmentConfig`](#@cdktf/provider-okta.AppGroupAssignmentConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`putTimeouts`](#cdktfprovideroktaappgroupassignmentputtimeouts) | *No description.* |
| [`resetId`](#cdktfprovideroktaappgroupassignmentresetid) | *No description.* |
| [`resetPriority`](#cdktfprovideroktaappgroupassignmentresetpriority) | *No description.* |
| [`resetProfile`](#cdktfprovideroktaappgroupassignmentresetprofile) | *No description.* |
| [`resetRetainAssignment`](#cdktfprovideroktaappgroupassignmentresetretainassignment) | *No description.* |
| [`resetTimeouts`](#cdktfprovideroktaappgroupassignmentresettimeouts) | *No description.* |

---

##### `putTimeouts` <a name="@cdktf/provider-okta.AppGroupAssignment.putTimeouts" id="cdktfprovideroktaappgroupassignmentputtimeouts"></a>

```typescript
public putTimeouts(value: AppGroupAssignmentTimeouts)
```

###### `value`<sup>Required</sup> <a name="@cdktf/provider-okta.AppGroupAssignment.parameter.value" id="cdktfprovideroktaappgroupassignmentparametervalue"></a>

- *Type:* [`@cdktf/provider-okta.AppGroupAssignmentTimeouts`](#@cdktf/provider-okta.AppGroupAssignmentTimeouts)

---

##### `resetId` <a name="@cdktf/provider-okta.AppGroupAssignment.resetId" id="cdktfprovideroktaappgroupassignmentresetid"></a>

```typescript
public resetId()
```

##### `resetPriority` <a name="@cdktf/provider-okta.AppGroupAssignment.resetPriority" id="cdktfprovideroktaappgroupassignmentresetpriority"></a>

```typescript
public resetPriority()
```

##### `resetProfile` <a name="@cdktf/provider-okta.AppGroupAssignment.resetProfile" id="cdktfprovideroktaappgroupassignmentresetprofile"></a>

```typescript
public resetProfile()
```

##### `resetRetainAssignment` <a name="@cdktf/provider-okta.AppGroupAssignment.resetRetainAssignment" id="cdktfprovideroktaappgroupassignmentresetretainassignment"></a>

```typescript
public resetRetainAssignment()
```

##### `resetTimeouts` <a name="@cdktf/provider-okta.AppGroupAssignment.resetTimeouts" id="cdktfprovideroktaappgroupassignmentresettimeouts"></a>

```typescript
public resetTimeouts()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`timeouts`](#cdktfprovideroktaappgroupassignmentpropertytimeouts)<span title="Required">*</span> | [`@cdktf/provider-okta.AppGroupAssignmentTimeoutsOutputReference`](#@cdktf/provider-okta.AppGroupAssignmentTimeoutsOutputReference) | *No description.* |
| [`appIdInput`](#cdktfprovideroktaappgroupassignmentpropertyappidinput) | `string` | *No description.* |
| [`groupIdInput`](#cdktfprovideroktaappgroupassignmentpropertygroupidinput) | `string` | *No description.* |
| [`idInput`](#cdktfprovideroktaappgroupassignmentpropertyidinput) | `string` | *No description.* |
| [`priorityInput`](#cdktfprovideroktaappgroupassignmentpropertypriorityinput) | `number` | *No description.* |
| [`profileInput`](#cdktfprovideroktaappgroupassignmentpropertyprofileinput) | `string` | *No description.* |
| [`retainAssignmentInput`](#cdktfprovideroktaappgroupassignmentpropertyretainassignmentinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`timeoutsInput`](#cdktfprovideroktaappgroupassignmentpropertytimeoutsinput) | [`cdktf.IResolvable`](#cdktf.IResolvable) \| [`@cdktf/provider-okta.AppGroupAssignmentTimeouts`](#@cdktf/provider-okta.AppGroupAssignmentTimeouts) | *No description.* |
| [`appId`](#cdktfprovideroktaappgroupassignmentpropertyappid)<span title="Required">*</span> | `string` | *No description.* |
| [`groupId`](#cdktfprovideroktaappgroupassignmentpropertygroupid)<span title="Required">*</span> | `string` | *No description.* |
| [`id`](#cdktfprovideroktaappgroupassignmentpropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`priority`](#cdktfprovideroktaappgroupassignmentpropertypriority)<span title="Required">*</span> | `number` | *No description.* |
| [`profile`](#cdktfprovideroktaappgroupassignmentpropertyprofile)<span title="Required">*</span> | `string` | *No description.* |
| [`retainAssignment`](#cdktfprovideroktaappgroupassignmentpropertyretainassignment)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |

---

##### `timeouts`<sup>Required</sup> <a name="@cdktf/provider-okta.AppGroupAssignment.property.timeouts" id="cdktfprovideroktaappgroupassignmentpropertytimeouts"></a>

```typescript
public readonly timeouts: AppGroupAssignmentTimeoutsOutputReference;
```

- *Type:* [`@cdktf/provider-okta.AppGroupAssignmentTimeoutsOutputReference`](#@cdktf/provider-okta.AppGroupAssignmentTimeoutsOutputReference)

---

##### `appIdInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppGroupAssignment.property.appIdInput" id="cdktfprovideroktaappgroupassignmentpropertyappidinput"></a>

```typescript
public readonly appIdInput: string;
```

- *Type:* `string`

---

##### `groupIdInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppGroupAssignment.property.groupIdInput" id="cdktfprovideroktaappgroupassignmentpropertygroupidinput"></a>

```typescript
public readonly groupIdInput: string;
```

- *Type:* `string`

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppGroupAssignment.property.idInput" id="cdktfprovideroktaappgroupassignmentpropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `priorityInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppGroupAssignment.property.priorityInput" id="cdktfprovideroktaappgroupassignmentpropertypriorityinput"></a>

```typescript
public readonly priorityInput: number;
```

- *Type:* `number`

---

##### `profileInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppGroupAssignment.property.profileInput" id="cdktfprovideroktaappgroupassignmentpropertyprofileinput"></a>

```typescript
public readonly profileInput: string;
```

- *Type:* `string`

---

##### `retainAssignmentInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppGroupAssignment.property.retainAssignmentInput" id="cdktfprovideroktaappgroupassignmentpropertyretainassignmentinput"></a>

```typescript
public readonly retainAssignmentInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `timeoutsInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppGroupAssignment.property.timeoutsInput" id="cdktfprovideroktaappgroupassignmentpropertytimeoutsinput"></a>

```typescript
public readonly timeoutsInput: IResolvable | AppGroupAssignmentTimeouts;
```

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable) | [`@cdktf/provider-okta.AppGroupAssignmentTimeouts`](#@cdktf/provider-okta.AppGroupAssignmentTimeouts)

---

##### `appId`<sup>Required</sup> <a name="@cdktf/provider-okta.AppGroupAssignment.property.appId" id="cdktfprovideroktaappgroupassignmentpropertyappid"></a>

```typescript
public readonly appId: string;
```

- *Type:* `string`

---

##### `groupId`<sup>Required</sup> <a name="@cdktf/provider-okta.AppGroupAssignment.property.groupId" id="cdktfprovideroktaappgroupassignmentpropertygroupid"></a>

```typescript
public readonly groupId: string;
```

- *Type:* `string`

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AppGroupAssignment.property.id" id="cdktfprovideroktaappgroupassignmentpropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `priority`<sup>Required</sup> <a name="@cdktf/provider-okta.AppGroupAssignment.property.priority" id="cdktfprovideroktaappgroupassignmentpropertypriority"></a>

```typescript
public readonly priority: number;
```

- *Type:* `number`

---

##### `profile`<sup>Required</sup> <a name="@cdktf/provider-okta.AppGroupAssignment.property.profile" id="cdktfprovideroktaappgroupassignmentpropertyprofile"></a>

```typescript
public readonly profile: string;
```

- *Type:* `string`

---

##### `retainAssignment`<sup>Required</sup> <a name="@cdktf/provider-okta.AppGroupAssignment.property.retainAssignment" id="cdktfprovideroktaappgroupassignmentpropertyretainassignment"></a>

```typescript
public readonly retainAssignment: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktaappgroupassignmentpropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.AppGroupAssignment.property.tfResourceType" id="cdktfprovideroktaappgroupassignmentpropertytfresourcetype"></a>

- *Type:* `string`

---

### AppGroupAssignments <a name="@cdktf/provider-okta.AppGroupAssignments" id="cdktfprovideroktaappgroupassignments"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/r/app_group_assignments okta_app_group_assignments}.

#### Initializers <a name="@cdktf/provider-okta.AppGroupAssignments.Initializer" id="cdktfprovideroktaappgroupassignmentsinitializer"></a>

```typescript
import { AppGroupAssignments } from '@cdktf/provider-okta'

new AppGroupAssignments(scope: Construct, id: string, config: AppGroupAssignmentsConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktaappgroupassignmentsparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktaappgroupassignmentsparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktaappgroupassignmentsparameterconfig)<span title="Required">*</span> | [`@cdktf/provider-okta.AppGroupAssignmentsConfig`](#@cdktf/provider-okta.AppGroupAssignmentsConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.AppGroupAssignments.parameter.scope" id="cdktfprovideroktaappgroupassignmentsparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AppGroupAssignments.parameter.id" id="cdktfprovideroktaappgroupassignmentsparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="@cdktf/provider-okta.AppGroupAssignments.parameter.config" id="cdktfprovideroktaappgroupassignmentsparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.AppGroupAssignmentsConfig`](#@cdktf/provider-okta.AppGroupAssignmentsConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`putGroup`](#cdktfprovideroktaappgroupassignmentsputgroup) | *No description.* |
| [`resetId`](#cdktfprovideroktaappgroupassignmentsresetid) | *No description.* |

---

##### `putGroup` <a name="@cdktf/provider-okta.AppGroupAssignments.putGroup" id="cdktfprovideroktaappgroupassignmentsputgroup"></a>

```typescript
public putGroup(value: IResolvable | AppGroupAssignmentsGroup[])
```

###### `value`<sup>Required</sup> <a name="@cdktf/provider-okta.AppGroupAssignments.parameter.value" id="cdktfprovideroktaappgroupassignmentsparametervalue"></a>

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable) | [`@cdktf/provider-okta.AppGroupAssignmentsGroup`](#@cdktf/provider-okta.AppGroupAssignmentsGroup)[]

---

##### `resetId` <a name="@cdktf/provider-okta.AppGroupAssignments.resetId" id="cdktfprovideroktaappgroupassignmentsresetid"></a>

```typescript
public resetId()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`group`](#cdktfprovideroktaappgroupassignmentspropertygroup)<span title="Required">*</span> | [`@cdktf/provider-okta.AppGroupAssignmentsGroupList`](#@cdktf/provider-okta.AppGroupAssignmentsGroupList) | *No description.* |
| [`appIdInput`](#cdktfprovideroktaappgroupassignmentspropertyappidinput) | `string` | *No description.* |
| [`groupInput`](#cdktfprovideroktaappgroupassignmentspropertygroupinput) | [`cdktf.IResolvable`](#cdktf.IResolvable) \| [`@cdktf/provider-okta.AppGroupAssignmentsGroup`](#@cdktf/provider-okta.AppGroupAssignmentsGroup)[] | *No description.* |
| [`idInput`](#cdktfprovideroktaappgroupassignmentspropertyidinput) | `string` | *No description.* |
| [`appId`](#cdktfprovideroktaappgroupassignmentspropertyappid)<span title="Required">*</span> | `string` | *No description.* |
| [`id`](#cdktfprovideroktaappgroupassignmentspropertyid)<span title="Required">*</span> | `string` | *No description.* |

---

##### `group`<sup>Required</sup> <a name="@cdktf/provider-okta.AppGroupAssignments.property.group" id="cdktfprovideroktaappgroupassignmentspropertygroup"></a>

```typescript
public readonly group: AppGroupAssignmentsGroupList;
```

- *Type:* [`@cdktf/provider-okta.AppGroupAssignmentsGroupList`](#@cdktf/provider-okta.AppGroupAssignmentsGroupList)

---

##### `appIdInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppGroupAssignments.property.appIdInput" id="cdktfprovideroktaappgroupassignmentspropertyappidinput"></a>

```typescript
public readonly appIdInput: string;
```

- *Type:* `string`

---

##### `groupInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppGroupAssignments.property.groupInput" id="cdktfprovideroktaappgroupassignmentspropertygroupinput"></a>

```typescript
public readonly groupInput: IResolvable | AppGroupAssignmentsGroup[];
```

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable) | [`@cdktf/provider-okta.AppGroupAssignmentsGroup`](#@cdktf/provider-okta.AppGroupAssignmentsGroup)[]

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppGroupAssignments.property.idInput" id="cdktfprovideroktaappgroupassignmentspropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `appId`<sup>Required</sup> <a name="@cdktf/provider-okta.AppGroupAssignments.property.appId" id="cdktfprovideroktaappgroupassignmentspropertyappid"></a>

```typescript
public readonly appId: string;
```

- *Type:* `string`

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AppGroupAssignments.property.id" id="cdktfprovideroktaappgroupassignmentspropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktaappgroupassignmentspropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.AppGroupAssignments.property.tfResourceType" id="cdktfprovideroktaappgroupassignmentspropertytfresourcetype"></a>

- *Type:* `string`

---

### AppOauth <a name="@cdktf/provider-okta.AppOauth" id="cdktfprovideroktaappoauth"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/r/app_oauth okta_app_oauth}.

#### Initializers <a name="@cdktf/provider-okta.AppOauth.Initializer" id="cdktfprovideroktaappoauthinitializer"></a>

```typescript
import { AppOauth } from '@cdktf/provider-okta'

new AppOauth(scope: Construct, id: string, config: AppOauthConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktaappoauthparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktaappoauthparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktaappoauthparameterconfig)<span title="Required">*</span> | [`@cdktf/provider-okta.AppOauthConfig`](#@cdktf/provider-okta.AppOauthConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.parameter.scope" id="cdktfprovideroktaappoauthparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.parameter.id" id="cdktfprovideroktaappoauthparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.parameter.config" id="cdktfprovideroktaappoauthparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.AppOauthConfig`](#@cdktf/provider-okta.AppOauthConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`putGroupsClaim`](#cdktfprovideroktaappoauthputgroupsclaim) | *No description.* |
| [`putJwks`](#cdktfprovideroktaappoauthputjwks) | *No description.* |
| [`putTimeouts`](#cdktfprovideroktaappoauthputtimeouts) | *No description.* |
| [`putUsers`](#cdktfprovideroktaappoauthputusers) | *No description.* |
| [`resetAccessibilityErrorRedirectUrl`](#cdktfprovideroktaappoauthresetaccessibilityerrorredirecturl) | *No description.* |
| [`resetAccessibilityLoginRedirectUrl`](#cdktfprovideroktaappoauthresetaccessibilityloginredirecturl) | *No description.* |
| [`resetAccessibilitySelfService`](#cdktfprovideroktaappoauthresetaccessibilityselfservice) | *No description.* |
| [`resetAdminNote`](#cdktfprovideroktaappoauthresetadminnote) | *No description.* |
| [`resetAppLinksJson`](#cdktfprovideroktaappoauthresetapplinksjson) | *No description.* |
| [`resetAppSettingsJson`](#cdktfprovideroktaappoauthresetappsettingsjson) | *No description.* |
| [`resetAuthenticationPolicy`](#cdktfprovideroktaappoauthresetauthenticationpolicy) | *No description.* |
| [`resetAutoKeyRotation`](#cdktfprovideroktaappoauthresetautokeyrotation) | *No description.* |
| [`resetAutoSubmitToolbar`](#cdktfprovideroktaappoauthresetautosubmittoolbar) | *No description.* |
| [`resetClientBasicSecret`](#cdktfprovideroktaappoauthresetclientbasicsecret) | *No description.* |
| [`resetClientId`](#cdktfprovideroktaappoauthresetclientid) | *No description.* |
| [`resetClientUri`](#cdktfprovideroktaappoauthresetclienturi) | *No description.* |
| [`resetConsentMethod`](#cdktfprovideroktaappoauthresetconsentmethod) | *No description.* |
| [`resetCustomClientId`](#cdktfprovideroktaappoauthresetcustomclientid) | *No description.* |
| [`resetEnduserNote`](#cdktfprovideroktaappoauthresetendusernote) | *No description.* |
| [`resetGrantTypes`](#cdktfprovideroktaappoauthresetgranttypes) | *No description.* |
| [`resetGroups`](#cdktfprovideroktaappoauthresetgroups) | *No description.* |
| [`resetGroupsClaim`](#cdktfprovideroktaappoauthresetgroupsclaim) | *No description.* |
| [`resetHideIos`](#cdktfprovideroktaappoauthresethideios) | *No description.* |
| [`resetHideWeb`](#cdktfprovideroktaappoauthresethideweb) | *No description.* |
| [`resetId`](#cdktfprovideroktaappoauthresetid) | *No description.* |
| [`resetImplicitAssignment`](#cdktfprovideroktaappoauthresetimplicitassignment) | *No description.* |
| [`resetIssuerMode`](#cdktfprovideroktaappoauthresetissuermode) | *No description.* |
| [`resetJwks`](#cdktfprovideroktaappoauthresetjwks) | *No description.* |
| [`resetLoginMode`](#cdktfprovideroktaappoauthresetloginmode) | *No description.* |
| [`resetLoginScopes`](#cdktfprovideroktaappoauthresetloginscopes) | *No description.* |
| [`resetLoginUri`](#cdktfprovideroktaappoauthresetloginuri) | *No description.* |
| [`resetLogo`](#cdktfprovideroktaappoauthresetlogo) | *No description.* |
| [`resetLogoUri`](#cdktfprovideroktaappoauthresetlogouri) | *No description.* |
| [`resetOmitSecret`](#cdktfprovideroktaappoauthresetomitsecret) | *No description.* |
| [`resetPolicyUri`](#cdktfprovideroktaappoauthresetpolicyuri) | *No description.* |
| [`resetPostLogoutRedirectUris`](#cdktfprovideroktaappoauthresetpostlogoutredirecturis) | *No description.* |
| [`resetProfile`](#cdktfprovideroktaappoauthresetprofile) | *No description.* |
| [`resetRedirectUris`](#cdktfprovideroktaappoauthresetredirecturis) | *No description.* |
| [`resetRefreshTokenLeeway`](#cdktfprovideroktaappoauthresetrefreshtokenleeway) | *No description.* |
| [`resetRefreshTokenRotation`](#cdktfprovideroktaappoauthresetrefreshtokenrotation) | *No description.* |
| [`resetResponseTypes`](#cdktfprovideroktaappoauthresetresponsetypes) | *No description.* |
| [`resetSkipGroups`](#cdktfprovideroktaappoauthresetskipgroups) | *No description.* |
| [`resetSkipUsers`](#cdktfprovideroktaappoauthresetskipusers) | *No description.* |
| [`resetStatus`](#cdktfprovideroktaappoauthresetstatus) | *No description.* |
| [`resetTimeouts`](#cdktfprovideroktaappoauthresettimeouts) | *No description.* |
| [`resetTokenEndpointAuthMethod`](#cdktfprovideroktaappoauthresettokenendpointauthmethod) | *No description.* |
| [`resetTosUri`](#cdktfprovideroktaappoauthresettosuri) | *No description.* |
| [`resetUserNameTemplate`](#cdktfprovideroktaappoauthresetusernametemplate) | *No description.* |
| [`resetUserNameTemplatePushStatus`](#cdktfprovideroktaappoauthresetusernametemplatepushstatus) | *No description.* |
| [`resetUserNameTemplateSuffix`](#cdktfprovideroktaappoauthresetusernametemplatesuffix) | *No description.* |
| [`resetUserNameTemplateType`](#cdktfprovideroktaappoauthresetusernametemplatetype) | *No description.* |
| [`resetUsers`](#cdktfprovideroktaappoauthresetusers) | *No description.* |
| [`resetWildcardRedirect`](#cdktfprovideroktaappoauthresetwildcardredirect) | *No description.* |

---

##### `putGroupsClaim` <a name="@cdktf/provider-okta.AppOauth.putGroupsClaim" id="cdktfprovideroktaappoauthputgroupsclaim"></a>

```typescript
public putGroupsClaim(value: AppOauthGroupsClaim)
```

###### `value`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.parameter.value" id="cdktfprovideroktaappoauthparametervalue"></a>

- *Type:* [`@cdktf/provider-okta.AppOauthGroupsClaim`](#@cdktf/provider-okta.AppOauthGroupsClaim)

---

##### `putJwks` <a name="@cdktf/provider-okta.AppOauth.putJwks" id="cdktfprovideroktaappoauthputjwks"></a>

```typescript
public putJwks(value: IResolvable | AppOauthJwks[])
```

###### `value`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.parameter.value" id="cdktfprovideroktaappoauthparametervalue"></a>

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable) | [`@cdktf/provider-okta.AppOauthJwks`](#@cdktf/provider-okta.AppOauthJwks)[]

---

##### `putTimeouts` <a name="@cdktf/provider-okta.AppOauth.putTimeouts" id="cdktfprovideroktaappoauthputtimeouts"></a>

```typescript
public putTimeouts(value: AppOauthTimeouts)
```

###### `value`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.parameter.value" id="cdktfprovideroktaappoauthparametervalue"></a>

- *Type:* [`@cdktf/provider-okta.AppOauthTimeouts`](#@cdktf/provider-okta.AppOauthTimeouts)

---

##### `putUsers` <a name="@cdktf/provider-okta.AppOauth.putUsers" id="cdktfprovideroktaappoauthputusers"></a>

```typescript
public putUsers(value: IResolvable | AppOauthUsers[])
```

###### `value`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.parameter.value" id="cdktfprovideroktaappoauthparametervalue"></a>

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable) | [`@cdktf/provider-okta.AppOauthUsers`](#@cdktf/provider-okta.AppOauthUsers)[]

---

##### `resetAccessibilityErrorRedirectUrl` <a name="@cdktf/provider-okta.AppOauth.resetAccessibilityErrorRedirectUrl" id="cdktfprovideroktaappoauthresetaccessibilityerrorredirecturl"></a>

```typescript
public resetAccessibilityErrorRedirectUrl()
```

##### `resetAccessibilityLoginRedirectUrl` <a name="@cdktf/provider-okta.AppOauth.resetAccessibilityLoginRedirectUrl" id="cdktfprovideroktaappoauthresetaccessibilityloginredirecturl"></a>

```typescript
public resetAccessibilityLoginRedirectUrl()
```

##### `resetAccessibilitySelfService` <a name="@cdktf/provider-okta.AppOauth.resetAccessibilitySelfService" id="cdktfprovideroktaappoauthresetaccessibilityselfservice"></a>

```typescript
public resetAccessibilitySelfService()
```

##### `resetAdminNote` <a name="@cdktf/provider-okta.AppOauth.resetAdminNote" id="cdktfprovideroktaappoauthresetadminnote"></a>

```typescript
public resetAdminNote()
```

##### `resetAppLinksJson` <a name="@cdktf/provider-okta.AppOauth.resetAppLinksJson" id="cdktfprovideroktaappoauthresetapplinksjson"></a>

```typescript
public resetAppLinksJson()
```

##### `resetAppSettingsJson` <a name="@cdktf/provider-okta.AppOauth.resetAppSettingsJson" id="cdktfprovideroktaappoauthresetappsettingsjson"></a>

```typescript
public resetAppSettingsJson()
```

##### `resetAuthenticationPolicy` <a name="@cdktf/provider-okta.AppOauth.resetAuthenticationPolicy" id="cdktfprovideroktaappoauthresetauthenticationpolicy"></a>

```typescript
public resetAuthenticationPolicy()
```

##### `resetAutoKeyRotation` <a name="@cdktf/provider-okta.AppOauth.resetAutoKeyRotation" id="cdktfprovideroktaappoauthresetautokeyrotation"></a>

```typescript
public resetAutoKeyRotation()
```

##### `resetAutoSubmitToolbar` <a name="@cdktf/provider-okta.AppOauth.resetAutoSubmitToolbar" id="cdktfprovideroktaappoauthresetautosubmittoolbar"></a>

```typescript
public resetAutoSubmitToolbar()
```

##### `resetClientBasicSecret` <a name="@cdktf/provider-okta.AppOauth.resetClientBasicSecret" id="cdktfprovideroktaappoauthresetclientbasicsecret"></a>

```typescript
public resetClientBasicSecret()
```

##### `resetClientId` <a name="@cdktf/provider-okta.AppOauth.resetClientId" id="cdktfprovideroktaappoauthresetclientid"></a>

```typescript
public resetClientId()
```

##### `resetClientUri` <a name="@cdktf/provider-okta.AppOauth.resetClientUri" id="cdktfprovideroktaappoauthresetclienturi"></a>

```typescript
public resetClientUri()
```

##### `resetConsentMethod` <a name="@cdktf/provider-okta.AppOauth.resetConsentMethod" id="cdktfprovideroktaappoauthresetconsentmethod"></a>

```typescript
public resetConsentMethod()
```

##### `resetCustomClientId` <a name="@cdktf/provider-okta.AppOauth.resetCustomClientId" id="cdktfprovideroktaappoauthresetcustomclientid"></a>

```typescript
public resetCustomClientId()
```

##### `resetEnduserNote` <a name="@cdktf/provider-okta.AppOauth.resetEnduserNote" id="cdktfprovideroktaappoauthresetendusernote"></a>

```typescript
public resetEnduserNote()
```

##### `resetGrantTypes` <a name="@cdktf/provider-okta.AppOauth.resetGrantTypes" id="cdktfprovideroktaappoauthresetgranttypes"></a>

```typescript
public resetGrantTypes()
```

##### `resetGroups` <a name="@cdktf/provider-okta.AppOauth.resetGroups" id="cdktfprovideroktaappoauthresetgroups"></a>

```typescript
public resetGroups()
```

##### `resetGroupsClaim` <a name="@cdktf/provider-okta.AppOauth.resetGroupsClaim" id="cdktfprovideroktaappoauthresetgroupsclaim"></a>

```typescript
public resetGroupsClaim()
```

##### `resetHideIos` <a name="@cdktf/provider-okta.AppOauth.resetHideIos" id="cdktfprovideroktaappoauthresethideios"></a>

```typescript
public resetHideIos()
```

##### `resetHideWeb` <a name="@cdktf/provider-okta.AppOauth.resetHideWeb" id="cdktfprovideroktaappoauthresethideweb"></a>

```typescript
public resetHideWeb()
```

##### `resetId` <a name="@cdktf/provider-okta.AppOauth.resetId" id="cdktfprovideroktaappoauthresetid"></a>

```typescript
public resetId()
```

##### `resetImplicitAssignment` <a name="@cdktf/provider-okta.AppOauth.resetImplicitAssignment" id="cdktfprovideroktaappoauthresetimplicitassignment"></a>

```typescript
public resetImplicitAssignment()
```

##### `resetIssuerMode` <a name="@cdktf/provider-okta.AppOauth.resetIssuerMode" id="cdktfprovideroktaappoauthresetissuermode"></a>

```typescript
public resetIssuerMode()
```

##### `resetJwks` <a name="@cdktf/provider-okta.AppOauth.resetJwks" id="cdktfprovideroktaappoauthresetjwks"></a>

```typescript
public resetJwks()
```

##### `resetLoginMode` <a name="@cdktf/provider-okta.AppOauth.resetLoginMode" id="cdktfprovideroktaappoauthresetloginmode"></a>

```typescript
public resetLoginMode()
```

##### `resetLoginScopes` <a name="@cdktf/provider-okta.AppOauth.resetLoginScopes" id="cdktfprovideroktaappoauthresetloginscopes"></a>

```typescript
public resetLoginScopes()
```

##### `resetLoginUri` <a name="@cdktf/provider-okta.AppOauth.resetLoginUri" id="cdktfprovideroktaappoauthresetloginuri"></a>

```typescript
public resetLoginUri()
```

##### `resetLogo` <a name="@cdktf/provider-okta.AppOauth.resetLogo" id="cdktfprovideroktaappoauthresetlogo"></a>

```typescript
public resetLogo()
```

##### `resetLogoUri` <a name="@cdktf/provider-okta.AppOauth.resetLogoUri" id="cdktfprovideroktaappoauthresetlogouri"></a>

```typescript
public resetLogoUri()
```

##### `resetOmitSecret` <a name="@cdktf/provider-okta.AppOauth.resetOmitSecret" id="cdktfprovideroktaappoauthresetomitsecret"></a>

```typescript
public resetOmitSecret()
```

##### `resetPolicyUri` <a name="@cdktf/provider-okta.AppOauth.resetPolicyUri" id="cdktfprovideroktaappoauthresetpolicyuri"></a>

```typescript
public resetPolicyUri()
```

##### `resetPostLogoutRedirectUris` <a name="@cdktf/provider-okta.AppOauth.resetPostLogoutRedirectUris" id="cdktfprovideroktaappoauthresetpostlogoutredirecturis"></a>

```typescript
public resetPostLogoutRedirectUris()
```

##### `resetProfile` <a name="@cdktf/provider-okta.AppOauth.resetProfile" id="cdktfprovideroktaappoauthresetprofile"></a>

```typescript
public resetProfile()
```

##### `resetRedirectUris` <a name="@cdktf/provider-okta.AppOauth.resetRedirectUris" id="cdktfprovideroktaappoauthresetredirecturis"></a>

```typescript
public resetRedirectUris()
```

##### `resetRefreshTokenLeeway` <a name="@cdktf/provider-okta.AppOauth.resetRefreshTokenLeeway" id="cdktfprovideroktaappoauthresetrefreshtokenleeway"></a>

```typescript
public resetRefreshTokenLeeway()
```

##### `resetRefreshTokenRotation` <a name="@cdktf/provider-okta.AppOauth.resetRefreshTokenRotation" id="cdktfprovideroktaappoauthresetrefreshtokenrotation"></a>

```typescript
public resetRefreshTokenRotation()
```

##### `resetResponseTypes` <a name="@cdktf/provider-okta.AppOauth.resetResponseTypes" id="cdktfprovideroktaappoauthresetresponsetypes"></a>

```typescript
public resetResponseTypes()
```

##### `resetSkipGroups` <a name="@cdktf/provider-okta.AppOauth.resetSkipGroups" id="cdktfprovideroktaappoauthresetskipgroups"></a>

```typescript
public resetSkipGroups()
```

##### `resetSkipUsers` <a name="@cdktf/provider-okta.AppOauth.resetSkipUsers" id="cdktfprovideroktaappoauthresetskipusers"></a>

```typescript
public resetSkipUsers()
```

##### `resetStatus` <a name="@cdktf/provider-okta.AppOauth.resetStatus" id="cdktfprovideroktaappoauthresetstatus"></a>

```typescript
public resetStatus()
```

##### `resetTimeouts` <a name="@cdktf/provider-okta.AppOauth.resetTimeouts" id="cdktfprovideroktaappoauthresettimeouts"></a>

```typescript
public resetTimeouts()
```

##### `resetTokenEndpointAuthMethod` <a name="@cdktf/provider-okta.AppOauth.resetTokenEndpointAuthMethod" id="cdktfprovideroktaappoauthresettokenendpointauthmethod"></a>

```typescript
public resetTokenEndpointAuthMethod()
```

##### `resetTosUri` <a name="@cdktf/provider-okta.AppOauth.resetTosUri" id="cdktfprovideroktaappoauthresettosuri"></a>

```typescript
public resetTosUri()
```

##### `resetUserNameTemplate` <a name="@cdktf/provider-okta.AppOauth.resetUserNameTemplate" id="cdktfprovideroktaappoauthresetusernametemplate"></a>

```typescript
public resetUserNameTemplate()
```

##### `resetUserNameTemplatePushStatus` <a name="@cdktf/provider-okta.AppOauth.resetUserNameTemplatePushStatus" id="cdktfprovideroktaappoauthresetusernametemplatepushstatus"></a>

```typescript
public resetUserNameTemplatePushStatus()
```

##### `resetUserNameTemplateSuffix` <a name="@cdktf/provider-okta.AppOauth.resetUserNameTemplateSuffix" id="cdktfprovideroktaappoauthresetusernametemplatesuffix"></a>

```typescript
public resetUserNameTemplateSuffix()
```

##### `resetUserNameTemplateType` <a name="@cdktf/provider-okta.AppOauth.resetUserNameTemplateType" id="cdktfprovideroktaappoauthresetusernametemplatetype"></a>

```typescript
public resetUserNameTemplateType()
```

##### `resetUsers` <a name="@cdktf/provider-okta.AppOauth.resetUsers" id="cdktfprovideroktaappoauthresetusers"></a>

```typescript
public resetUsers()
```

##### `resetWildcardRedirect` <a name="@cdktf/provider-okta.AppOauth.resetWildcardRedirect" id="cdktfprovideroktaappoauthresetwildcardredirect"></a>

```typescript
public resetWildcardRedirect()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`clientSecret`](#cdktfprovideroktaappoauthpropertyclientsecret)<span title="Required">*</span> | `string` | *No description.* |
| [`groupsClaim`](#cdktfprovideroktaappoauthpropertygroupsclaim)<span title="Required">*</span> | [`@cdktf/provider-okta.AppOauthGroupsClaimOutputReference`](#@cdktf/provider-okta.AppOauthGroupsClaimOutputReference) | *No description.* |
| [`jwks`](#cdktfprovideroktaappoauthpropertyjwks)<span title="Required">*</span> | [`@cdktf/provider-okta.AppOauthJwksList`](#@cdktf/provider-okta.AppOauthJwksList) | *No description.* |
| [`logoUrl`](#cdktfprovideroktaappoauthpropertylogourl)<span title="Required">*</span> | `string` | *No description.* |
| [`name`](#cdktfprovideroktaappoauthpropertyname)<span title="Required">*</span> | `string` | *No description.* |
| [`signOnMode`](#cdktfprovideroktaappoauthpropertysignonmode)<span title="Required">*</span> | `string` | *No description.* |
| [`timeouts`](#cdktfprovideroktaappoauthpropertytimeouts)<span title="Required">*</span> | [`@cdktf/provider-okta.AppOauthTimeoutsOutputReference`](#@cdktf/provider-okta.AppOauthTimeoutsOutputReference) | *No description.* |
| [`users`](#cdktfprovideroktaappoauthpropertyusers)<span title="Required">*</span> | [`@cdktf/provider-okta.AppOauthUsersList`](#@cdktf/provider-okta.AppOauthUsersList) | *No description.* |
| [`accessibilityErrorRedirectUrlInput`](#cdktfprovideroktaappoauthpropertyaccessibilityerrorredirecturlinput) | `string` | *No description.* |
| [`accessibilityLoginRedirectUrlInput`](#cdktfprovideroktaappoauthpropertyaccessibilityloginredirecturlinput) | `string` | *No description.* |
| [`accessibilitySelfServiceInput`](#cdktfprovideroktaappoauthpropertyaccessibilityselfserviceinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`adminNoteInput`](#cdktfprovideroktaappoauthpropertyadminnoteinput) | `string` | *No description.* |
| [`appLinksJsonInput`](#cdktfprovideroktaappoauthpropertyapplinksjsoninput) | `string` | *No description.* |
| [`appSettingsJsonInput`](#cdktfprovideroktaappoauthpropertyappsettingsjsoninput) | `string` | *No description.* |
| [`authenticationPolicyInput`](#cdktfprovideroktaappoauthpropertyauthenticationpolicyinput) | `string` | *No description.* |
| [`autoKeyRotationInput`](#cdktfprovideroktaappoauthpropertyautokeyrotationinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`autoSubmitToolbarInput`](#cdktfprovideroktaappoauthpropertyautosubmittoolbarinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`clientBasicSecretInput`](#cdktfprovideroktaappoauthpropertyclientbasicsecretinput) | `string` | *No description.* |
| [`clientIdInput`](#cdktfprovideroktaappoauthpropertyclientidinput) | `string` | *No description.* |
| [`clientUriInput`](#cdktfprovideroktaappoauthpropertyclienturiinput) | `string` | *No description.* |
| [`consentMethodInput`](#cdktfprovideroktaappoauthpropertyconsentmethodinput) | `string` | *No description.* |
| [`customClientIdInput`](#cdktfprovideroktaappoauthpropertycustomclientidinput) | `string` | *No description.* |
| [`enduserNoteInput`](#cdktfprovideroktaappoauthpropertyendusernoteinput) | `string` | *No description.* |
| [`grantTypesInput`](#cdktfprovideroktaappoauthpropertygranttypesinput) | `string`[] | *No description.* |
| [`groupsClaimInput`](#cdktfprovideroktaappoauthpropertygroupsclaiminput) | [`@cdktf/provider-okta.AppOauthGroupsClaim`](#@cdktf/provider-okta.AppOauthGroupsClaim) | *No description.* |
| [`groupsInput`](#cdktfprovideroktaappoauthpropertygroupsinput) | `string`[] | *No description.* |
| [`hideIosInput`](#cdktfprovideroktaappoauthpropertyhideiosinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`hideWebInput`](#cdktfprovideroktaappoauthpropertyhidewebinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`idInput`](#cdktfprovideroktaappoauthpropertyidinput) | `string` | *No description.* |
| [`implicitAssignmentInput`](#cdktfprovideroktaappoauthpropertyimplicitassignmentinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`issuerModeInput`](#cdktfprovideroktaappoauthpropertyissuermodeinput) | `string` | *No description.* |
| [`jwksInput`](#cdktfprovideroktaappoauthpropertyjwksinput) | [`cdktf.IResolvable`](#cdktf.IResolvable) \| [`@cdktf/provider-okta.AppOauthJwks`](#@cdktf/provider-okta.AppOauthJwks)[] | *No description.* |
| [`labelInput`](#cdktfprovideroktaappoauthpropertylabelinput) | `string` | *No description.* |
| [`loginModeInput`](#cdktfprovideroktaappoauthpropertyloginmodeinput) | `string` | *No description.* |
| [`loginScopesInput`](#cdktfprovideroktaappoauthpropertyloginscopesinput) | `string`[] | *No description.* |
| [`loginUriInput`](#cdktfprovideroktaappoauthpropertyloginuriinput) | `string` | *No description.* |
| [`logoInput`](#cdktfprovideroktaappoauthpropertylogoinput) | `string` | *No description.* |
| [`logoUriInput`](#cdktfprovideroktaappoauthpropertylogouriinput) | `string` | *No description.* |
| [`omitSecretInput`](#cdktfprovideroktaappoauthpropertyomitsecretinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`policyUriInput`](#cdktfprovideroktaappoauthpropertypolicyuriinput) | `string` | *No description.* |
| [`postLogoutRedirectUrisInput`](#cdktfprovideroktaappoauthpropertypostlogoutredirecturisinput) | `string`[] | *No description.* |
| [`profileInput`](#cdktfprovideroktaappoauthpropertyprofileinput) | `string` | *No description.* |
| [`redirectUrisInput`](#cdktfprovideroktaappoauthpropertyredirecturisinput) | `string`[] | *No description.* |
| [`refreshTokenLeewayInput`](#cdktfprovideroktaappoauthpropertyrefreshtokenleewayinput) | `number` | *No description.* |
| [`refreshTokenRotationInput`](#cdktfprovideroktaappoauthpropertyrefreshtokenrotationinput) | `string` | *No description.* |
| [`responseTypesInput`](#cdktfprovideroktaappoauthpropertyresponsetypesinput) | `string`[] | *No description.* |
| [`skipGroupsInput`](#cdktfprovideroktaappoauthpropertyskipgroupsinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`skipUsersInput`](#cdktfprovideroktaappoauthpropertyskipusersinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`statusInput`](#cdktfprovideroktaappoauthpropertystatusinput) | `string` | *No description.* |
| [`timeoutsInput`](#cdktfprovideroktaappoauthpropertytimeoutsinput) | [`cdktf.IResolvable`](#cdktf.IResolvable) \| [`@cdktf/provider-okta.AppOauthTimeouts`](#@cdktf/provider-okta.AppOauthTimeouts) | *No description.* |
| [`tokenEndpointAuthMethodInput`](#cdktfprovideroktaappoauthpropertytokenendpointauthmethodinput) | `string` | *No description.* |
| [`tosUriInput`](#cdktfprovideroktaappoauthpropertytosuriinput) | `string` | *No description.* |
| [`typeInput`](#cdktfprovideroktaappoauthpropertytypeinput) | `string` | *No description.* |
| [`userNameTemplateInput`](#cdktfprovideroktaappoauthpropertyusernametemplateinput) | `string` | *No description.* |
| [`userNameTemplatePushStatusInput`](#cdktfprovideroktaappoauthpropertyusernametemplatepushstatusinput) | `string` | *No description.* |
| [`userNameTemplateSuffixInput`](#cdktfprovideroktaappoauthpropertyusernametemplatesuffixinput) | `string` | *No description.* |
| [`userNameTemplateTypeInput`](#cdktfprovideroktaappoauthpropertyusernametemplatetypeinput) | `string` | *No description.* |
| [`usersInput`](#cdktfprovideroktaappoauthpropertyusersinput) | [`cdktf.IResolvable`](#cdktf.IResolvable) \| [`@cdktf/provider-okta.AppOauthUsers`](#@cdktf/provider-okta.AppOauthUsers)[] | *No description.* |
| [`wildcardRedirectInput`](#cdktfprovideroktaappoauthpropertywildcardredirectinput) | `string` | *No description.* |
| [`accessibilityErrorRedirectUrl`](#cdktfprovideroktaappoauthpropertyaccessibilityerrorredirecturl)<span title="Required">*</span> | `string` | *No description.* |
| [`accessibilityLoginRedirectUrl`](#cdktfprovideroktaappoauthpropertyaccessibilityloginredirecturl)<span title="Required">*</span> | `string` | *No description.* |
| [`accessibilitySelfService`](#cdktfprovideroktaappoauthpropertyaccessibilityselfservice)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`adminNote`](#cdktfprovideroktaappoauthpropertyadminnote)<span title="Required">*</span> | `string` | *No description.* |
| [`appLinksJson`](#cdktfprovideroktaappoauthpropertyapplinksjson)<span title="Required">*</span> | `string` | *No description.* |
| [`appSettingsJson`](#cdktfprovideroktaappoauthpropertyappsettingsjson)<span title="Required">*</span> | `string` | *No description.* |
| [`authenticationPolicy`](#cdktfprovideroktaappoauthpropertyauthenticationpolicy)<span title="Required">*</span> | `string` | *No description.* |
| [`autoKeyRotation`](#cdktfprovideroktaappoauthpropertyautokeyrotation)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`autoSubmitToolbar`](#cdktfprovideroktaappoauthpropertyautosubmittoolbar)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`clientBasicSecret`](#cdktfprovideroktaappoauthpropertyclientbasicsecret)<span title="Required">*</span> | `string` | *No description.* |
| [`clientId`](#cdktfprovideroktaappoauthpropertyclientid)<span title="Required">*</span> | `string` | *No description.* |
| [`clientUri`](#cdktfprovideroktaappoauthpropertyclienturi)<span title="Required">*</span> | `string` | *No description.* |
| [`consentMethod`](#cdktfprovideroktaappoauthpropertyconsentmethod)<span title="Required">*</span> | `string` | *No description.* |
| [`customClientId`](#cdktfprovideroktaappoauthpropertycustomclientid)<span title="Required">*</span> | `string` | *No description.* |
| [`enduserNote`](#cdktfprovideroktaappoauthpropertyendusernote)<span title="Required">*</span> | `string` | *No description.* |
| [`grantTypes`](#cdktfprovideroktaappoauthpropertygranttypes)<span title="Required">*</span> | `string`[] | *No description.* |
| [`groups`](#cdktfprovideroktaappoauthpropertygroups)<span title="Required">*</span> | `string`[] | *No description.* |
| [`hideIos`](#cdktfprovideroktaappoauthpropertyhideios)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`hideWeb`](#cdktfprovideroktaappoauthpropertyhideweb)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`id`](#cdktfprovideroktaappoauthpropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`implicitAssignment`](#cdktfprovideroktaappoauthpropertyimplicitassignment)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`issuerMode`](#cdktfprovideroktaappoauthpropertyissuermode)<span title="Required">*</span> | `string` | *No description.* |
| [`label`](#cdktfprovideroktaappoauthpropertylabel)<span title="Required">*</span> | `string` | *No description.* |
| [`loginMode`](#cdktfprovideroktaappoauthpropertyloginmode)<span title="Required">*</span> | `string` | *No description.* |
| [`loginScopes`](#cdktfprovideroktaappoauthpropertyloginscopes)<span title="Required">*</span> | `string`[] | *No description.* |
| [`loginUri`](#cdktfprovideroktaappoauthpropertyloginuri)<span title="Required">*</span> | `string` | *No description.* |
| [`logo`](#cdktfprovideroktaappoauthpropertylogo)<span title="Required">*</span> | `string` | *No description.* |
| [`logoUri`](#cdktfprovideroktaappoauthpropertylogouri)<span title="Required">*</span> | `string` | *No description.* |
| [`omitSecret`](#cdktfprovideroktaappoauthpropertyomitsecret)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`policyUri`](#cdktfprovideroktaappoauthpropertypolicyuri)<span title="Required">*</span> | `string` | *No description.* |
| [`postLogoutRedirectUris`](#cdktfprovideroktaappoauthpropertypostlogoutredirecturis)<span title="Required">*</span> | `string`[] | *No description.* |
| [`profile`](#cdktfprovideroktaappoauthpropertyprofile)<span title="Required">*</span> | `string` | *No description.* |
| [`redirectUris`](#cdktfprovideroktaappoauthpropertyredirecturis)<span title="Required">*</span> | `string`[] | *No description.* |
| [`refreshTokenLeeway`](#cdktfprovideroktaappoauthpropertyrefreshtokenleeway)<span title="Required">*</span> | `number` | *No description.* |
| [`refreshTokenRotation`](#cdktfprovideroktaappoauthpropertyrefreshtokenrotation)<span title="Required">*</span> | `string` | *No description.* |
| [`responseTypes`](#cdktfprovideroktaappoauthpropertyresponsetypes)<span title="Required">*</span> | `string`[] | *No description.* |
| [`skipGroups`](#cdktfprovideroktaappoauthpropertyskipgroups)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`skipUsers`](#cdktfprovideroktaappoauthpropertyskipusers)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`status`](#cdktfprovideroktaappoauthpropertystatus)<span title="Required">*</span> | `string` | *No description.* |
| [`tokenEndpointAuthMethod`](#cdktfprovideroktaappoauthpropertytokenendpointauthmethod)<span title="Required">*</span> | `string` | *No description.* |
| [`tosUri`](#cdktfprovideroktaappoauthpropertytosuri)<span title="Required">*</span> | `string` | *No description.* |
| [`type`](#cdktfprovideroktaappoauthpropertytype)<span title="Required">*</span> | `string` | *No description.* |
| [`userNameTemplate`](#cdktfprovideroktaappoauthpropertyusernametemplate)<span title="Required">*</span> | `string` | *No description.* |
| [`userNameTemplatePushStatus`](#cdktfprovideroktaappoauthpropertyusernametemplatepushstatus)<span title="Required">*</span> | `string` | *No description.* |
| [`userNameTemplateSuffix`](#cdktfprovideroktaappoauthpropertyusernametemplatesuffix)<span title="Required">*</span> | `string` | *No description.* |
| [`userNameTemplateType`](#cdktfprovideroktaappoauthpropertyusernametemplatetype)<span title="Required">*</span> | `string` | *No description.* |
| [`wildcardRedirect`](#cdktfprovideroktaappoauthpropertywildcardredirect)<span title="Required">*</span> | `string` | *No description.* |

---

##### `clientSecret`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.property.clientSecret" id="cdktfprovideroktaappoauthpropertyclientsecret"></a>

```typescript
public readonly clientSecret: string;
```

- *Type:* `string`

---

##### `groupsClaim`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.property.groupsClaim" id="cdktfprovideroktaappoauthpropertygroupsclaim"></a>

```typescript
public readonly groupsClaim: AppOauthGroupsClaimOutputReference;
```

- *Type:* [`@cdktf/provider-okta.AppOauthGroupsClaimOutputReference`](#@cdktf/provider-okta.AppOauthGroupsClaimOutputReference)

---

##### `jwks`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.property.jwks" id="cdktfprovideroktaappoauthpropertyjwks"></a>

```typescript
public readonly jwks: AppOauthJwksList;
```

- *Type:* [`@cdktf/provider-okta.AppOauthJwksList`](#@cdktf/provider-okta.AppOauthJwksList)

---

##### `logoUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.property.logoUrl" id="cdktfprovideroktaappoauthpropertylogourl"></a>

```typescript
public readonly logoUrl: string;
```

- *Type:* `string`

---

##### `name`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.property.name" id="cdktfprovideroktaappoauthpropertyname"></a>

```typescript
public readonly name: string;
```

- *Type:* `string`

---

##### `signOnMode`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.property.signOnMode" id="cdktfprovideroktaappoauthpropertysignonmode"></a>

```typescript
public readonly signOnMode: string;
```

- *Type:* `string`

---

##### `timeouts`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.property.timeouts" id="cdktfprovideroktaappoauthpropertytimeouts"></a>

```typescript
public readonly timeouts: AppOauthTimeoutsOutputReference;
```

- *Type:* [`@cdktf/provider-okta.AppOauthTimeoutsOutputReference`](#@cdktf/provider-okta.AppOauthTimeoutsOutputReference)

---

##### `users`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.property.users" id="cdktfprovideroktaappoauthpropertyusers"></a>

```typescript
public readonly users: AppOauthUsersList;
```

- *Type:* [`@cdktf/provider-okta.AppOauthUsersList`](#@cdktf/provider-okta.AppOauthUsersList)

---

##### `accessibilityErrorRedirectUrlInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauth.property.accessibilityErrorRedirectUrlInput" id="cdktfprovideroktaappoauthpropertyaccessibilityerrorredirecturlinput"></a>

```typescript
public readonly accessibilityErrorRedirectUrlInput: string;
```

- *Type:* `string`

---

##### `accessibilityLoginRedirectUrlInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauth.property.accessibilityLoginRedirectUrlInput" id="cdktfprovideroktaappoauthpropertyaccessibilityloginredirecturlinput"></a>

```typescript
public readonly accessibilityLoginRedirectUrlInput: string;
```

- *Type:* `string`

---

##### `accessibilitySelfServiceInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauth.property.accessibilitySelfServiceInput" id="cdktfprovideroktaappoauthpropertyaccessibilityselfserviceinput"></a>

```typescript
public readonly accessibilitySelfServiceInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `adminNoteInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauth.property.adminNoteInput" id="cdktfprovideroktaappoauthpropertyadminnoteinput"></a>

```typescript
public readonly adminNoteInput: string;
```

- *Type:* `string`

---

##### `appLinksJsonInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauth.property.appLinksJsonInput" id="cdktfprovideroktaappoauthpropertyapplinksjsoninput"></a>

```typescript
public readonly appLinksJsonInput: string;
```

- *Type:* `string`

---

##### `appSettingsJsonInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauth.property.appSettingsJsonInput" id="cdktfprovideroktaappoauthpropertyappsettingsjsoninput"></a>

```typescript
public readonly appSettingsJsonInput: string;
```

- *Type:* `string`

---

##### `authenticationPolicyInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauth.property.authenticationPolicyInput" id="cdktfprovideroktaappoauthpropertyauthenticationpolicyinput"></a>

```typescript
public readonly authenticationPolicyInput: string;
```

- *Type:* `string`

---

##### `autoKeyRotationInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauth.property.autoKeyRotationInput" id="cdktfprovideroktaappoauthpropertyautokeyrotationinput"></a>

```typescript
public readonly autoKeyRotationInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `autoSubmitToolbarInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauth.property.autoSubmitToolbarInput" id="cdktfprovideroktaappoauthpropertyautosubmittoolbarinput"></a>

```typescript
public readonly autoSubmitToolbarInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `clientBasicSecretInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauth.property.clientBasicSecretInput" id="cdktfprovideroktaappoauthpropertyclientbasicsecretinput"></a>

```typescript
public readonly clientBasicSecretInput: string;
```

- *Type:* `string`

---

##### `clientIdInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauth.property.clientIdInput" id="cdktfprovideroktaappoauthpropertyclientidinput"></a>

```typescript
public readonly clientIdInput: string;
```

- *Type:* `string`

---

##### `clientUriInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauth.property.clientUriInput" id="cdktfprovideroktaappoauthpropertyclienturiinput"></a>

```typescript
public readonly clientUriInput: string;
```

- *Type:* `string`

---

##### `consentMethodInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauth.property.consentMethodInput" id="cdktfprovideroktaappoauthpropertyconsentmethodinput"></a>

```typescript
public readonly consentMethodInput: string;
```

- *Type:* `string`

---

##### `customClientIdInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauth.property.customClientIdInput" id="cdktfprovideroktaappoauthpropertycustomclientidinput"></a>

```typescript
public readonly customClientIdInput: string;
```

- *Type:* `string`

---

##### `enduserNoteInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauth.property.enduserNoteInput" id="cdktfprovideroktaappoauthpropertyendusernoteinput"></a>

```typescript
public readonly enduserNoteInput: string;
```

- *Type:* `string`

---

##### `grantTypesInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauth.property.grantTypesInput" id="cdktfprovideroktaappoauthpropertygranttypesinput"></a>

```typescript
public readonly grantTypesInput: string[];
```

- *Type:* `string`[]

---

##### `groupsClaimInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauth.property.groupsClaimInput" id="cdktfprovideroktaappoauthpropertygroupsclaiminput"></a>

```typescript
public readonly groupsClaimInput: AppOauthGroupsClaim;
```

- *Type:* [`@cdktf/provider-okta.AppOauthGroupsClaim`](#@cdktf/provider-okta.AppOauthGroupsClaim)

---

##### `groupsInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauth.property.groupsInput" id="cdktfprovideroktaappoauthpropertygroupsinput"></a>

```typescript
public readonly groupsInput: string[];
```

- *Type:* `string`[]

---

##### `hideIosInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauth.property.hideIosInput" id="cdktfprovideroktaappoauthpropertyhideiosinput"></a>

```typescript
public readonly hideIosInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `hideWebInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauth.property.hideWebInput" id="cdktfprovideroktaappoauthpropertyhidewebinput"></a>

```typescript
public readonly hideWebInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauth.property.idInput" id="cdktfprovideroktaappoauthpropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `implicitAssignmentInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauth.property.implicitAssignmentInput" id="cdktfprovideroktaappoauthpropertyimplicitassignmentinput"></a>

```typescript
public readonly implicitAssignmentInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `issuerModeInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauth.property.issuerModeInput" id="cdktfprovideroktaappoauthpropertyissuermodeinput"></a>

```typescript
public readonly issuerModeInput: string;
```

- *Type:* `string`

---

##### `jwksInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauth.property.jwksInput" id="cdktfprovideroktaappoauthpropertyjwksinput"></a>

```typescript
public readonly jwksInput: IResolvable | AppOauthJwks[];
```

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable) | [`@cdktf/provider-okta.AppOauthJwks`](#@cdktf/provider-okta.AppOauthJwks)[]

---

##### `labelInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauth.property.labelInput" id="cdktfprovideroktaappoauthpropertylabelinput"></a>

```typescript
public readonly labelInput: string;
```

- *Type:* `string`

---

##### `loginModeInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauth.property.loginModeInput" id="cdktfprovideroktaappoauthpropertyloginmodeinput"></a>

```typescript
public readonly loginModeInput: string;
```

- *Type:* `string`

---

##### `loginScopesInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauth.property.loginScopesInput" id="cdktfprovideroktaappoauthpropertyloginscopesinput"></a>

```typescript
public readonly loginScopesInput: string[];
```

- *Type:* `string`[]

---

##### `loginUriInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauth.property.loginUriInput" id="cdktfprovideroktaappoauthpropertyloginuriinput"></a>

```typescript
public readonly loginUriInput: string;
```

- *Type:* `string`

---

##### `logoInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauth.property.logoInput" id="cdktfprovideroktaappoauthpropertylogoinput"></a>

```typescript
public readonly logoInput: string;
```

- *Type:* `string`

---

##### `logoUriInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauth.property.logoUriInput" id="cdktfprovideroktaappoauthpropertylogouriinput"></a>

```typescript
public readonly logoUriInput: string;
```

- *Type:* `string`

---

##### `omitSecretInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauth.property.omitSecretInput" id="cdktfprovideroktaappoauthpropertyomitsecretinput"></a>

```typescript
public readonly omitSecretInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `policyUriInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauth.property.policyUriInput" id="cdktfprovideroktaappoauthpropertypolicyuriinput"></a>

```typescript
public readonly policyUriInput: string;
```

- *Type:* `string`

---

##### `postLogoutRedirectUrisInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauth.property.postLogoutRedirectUrisInput" id="cdktfprovideroktaappoauthpropertypostlogoutredirecturisinput"></a>

```typescript
public readonly postLogoutRedirectUrisInput: string[];
```

- *Type:* `string`[]

---

##### `profileInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauth.property.profileInput" id="cdktfprovideroktaappoauthpropertyprofileinput"></a>

```typescript
public readonly profileInput: string;
```

- *Type:* `string`

---

##### `redirectUrisInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauth.property.redirectUrisInput" id="cdktfprovideroktaappoauthpropertyredirecturisinput"></a>

```typescript
public readonly redirectUrisInput: string[];
```

- *Type:* `string`[]

---

##### `refreshTokenLeewayInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauth.property.refreshTokenLeewayInput" id="cdktfprovideroktaappoauthpropertyrefreshtokenleewayinput"></a>

```typescript
public readonly refreshTokenLeewayInput: number;
```

- *Type:* `number`

---

##### `refreshTokenRotationInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauth.property.refreshTokenRotationInput" id="cdktfprovideroktaappoauthpropertyrefreshtokenrotationinput"></a>

```typescript
public readonly refreshTokenRotationInput: string;
```

- *Type:* `string`

---

##### `responseTypesInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauth.property.responseTypesInput" id="cdktfprovideroktaappoauthpropertyresponsetypesinput"></a>

```typescript
public readonly responseTypesInput: string[];
```

- *Type:* `string`[]

---

##### `skipGroupsInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauth.property.skipGroupsInput" id="cdktfprovideroktaappoauthpropertyskipgroupsinput"></a>

```typescript
public readonly skipGroupsInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `skipUsersInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauth.property.skipUsersInput" id="cdktfprovideroktaappoauthpropertyskipusersinput"></a>

```typescript
public readonly skipUsersInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `statusInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauth.property.statusInput" id="cdktfprovideroktaappoauthpropertystatusinput"></a>

```typescript
public readonly statusInput: string;
```

- *Type:* `string`

---

##### `timeoutsInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauth.property.timeoutsInput" id="cdktfprovideroktaappoauthpropertytimeoutsinput"></a>

```typescript
public readonly timeoutsInput: IResolvable | AppOauthTimeouts;
```

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable) | [`@cdktf/provider-okta.AppOauthTimeouts`](#@cdktf/provider-okta.AppOauthTimeouts)

---

##### `tokenEndpointAuthMethodInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauth.property.tokenEndpointAuthMethodInput" id="cdktfprovideroktaappoauthpropertytokenendpointauthmethodinput"></a>

```typescript
public readonly tokenEndpointAuthMethodInput: string;
```

- *Type:* `string`

---

##### `tosUriInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauth.property.tosUriInput" id="cdktfprovideroktaappoauthpropertytosuriinput"></a>

```typescript
public readonly tosUriInput: string;
```

- *Type:* `string`

---

##### `typeInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauth.property.typeInput" id="cdktfprovideroktaappoauthpropertytypeinput"></a>

```typescript
public readonly typeInput: string;
```

- *Type:* `string`

---

##### `userNameTemplateInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauth.property.userNameTemplateInput" id="cdktfprovideroktaappoauthpropertyusernametemplateinput"></a>

```typescript
public readonly userNameTemplateInput: string;
```

- *Type:* `string`

---

##### `userNameTemplatePushStatusInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauth.property.userNameTemplatePushStatusInput" id="cdktfprovideroktaappoauthpropertyusernametemplatepushstatusinput"></a>

```typescript
public readonly userNameTemplatePushStatusInput: string;
```

- *Type:* `string`

---

##### `userNameTemplateSuffixInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauth.property.userNameTemplateSuffixInput" id="cdktfprovideroktaappoauthpropertyusernametemplatesuffixinput"></a>

```typescript
public readonly userNameTemplateSuffixInput: string;
```

- *Type:* `string`

---

##### `userNameTemplateTypeInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauth.property.userNameTemplateTypeInput" id="cdktfprovideroktaappoauthpropertyusernametemplatetypeinput"></a>

```typescript
public readonly userNameTemplateTypeInput: string;
```

- *Type:* `string`

---

##### `usersInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauth.property.usersInput" id="cdktfprovideroktaappoauthpropertyusersinput"></a>

```typescript
public readonly usersInput: IResolvable | AppOauthUsers[];
```

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable) | [`@cdktf/provider-okta.AppOauthUsers`](#@cdktf/provider-okta.AppOauthUsers)[]

---

##### `wildcardRedirectInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauth.property.wildcardRedirectInput" id="cdktfprovideroktaappoauthpropertywildcardredirectinput"></a>

```typescript
public readonly wildcardRedirectInput: string;
```

- *Type:* `string`

---

##### `accessibilityErrorRedirectUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.property.accessibilityErrorRedirectUrl" id="cdktfprovideroktaappoauthpropertyaccessibilityerrorredirecturl"></a>

```typescript
public readonly accessibilityErrorRedirectUrl: string;
```

- *Type:* `string`

---

##### `accessibilityLoginRedirectUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.property.accessibilityLoginRedirectUrl" id="cdktfprovideroktaappoauthpropertyaccessibilityloginredirecturl"></a>

```typescript
public readonly accessibilityLoginRedirectUrl: string;
```

- *Type:* `string`

---

##### `accessibilitySelfService`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.property.accessibilitySelfService" id="cdktfprovideroktaappoauthpropertyaccessibilityselfservice"></a>

```typescript
public readonly accessibilitySelfService: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `adminNote`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.property.adminNote" id="cdktfprovideroktaappoauthpropertyadminnote"></a>

```typescript
public readonly adminNote: string;
```

- *Type:* `string`

---

##### `appLinksJson`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.property.appLinksJson" id="cdktfprovideroktaappoauthpropertyapplinksjson"></a>

```typescript
public readonly appLinksJson: string;
```

- *Type:* `string`

---

##### `appSettingsJson`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.property.appSettingsJson" id="cdktfprovideroktaappoauthpropertyappsettingsjson"></a>

```typescript
public readonly appSettingsJson: string;
```

- *Type:* `string`

---

##### `authenticationPolicy`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.property.authenticationPolicy" id="cdktfprovideroktaappoauthpropertyauthenticationpolicy"></a>

```typescript
public readonly authenticationPolicy: string;
```

- *Type:* `string`

---

##### `autoKeyRotation`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.property.autoKeyRotation" id="cdktfprovideroktaappoauthpropertyautokeyrotation"></a>

```typescript
public readonly autoKeyRotation: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `autoSubmitToolbar`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.property.autoSubmitToolbar" id="cdktfprovideroktaappoauthpropertyautosubmittoolbar"></a>

```typescript
public readonly autoSubmitToolbar: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `clientBasicSecret`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.property.clientBasicSecret" id="cdktfprovideroktaappoauthpropertyclientbasicsecret"></a>

```typescript
public readonly clientBasicSecret: string;
```

- *Type:* `string`

---

##### `clientId`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.property.clientId" id="cdktfprovideroktaappoauthpropertyclientid"></a>

```typescript
public readonly clientId: string;
```

- *Type:* `string`

---

##### `clientUri`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.property.clientUri" id="cdktfprovideroktaappoauthpropertyclienturi"></a>

```typescript
public readonly clientUri: string;
```

- *Type:* `string`

---

##### `consentMethod`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.property.consentMethod" id="cdktfprovideroktaappoauthpropertyconsentmethod"></a>

```typescript
public readonly consentMethod: string;
```

- *Type:* `string`

---

##### `customClientId`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.property.customClientId" id="cdktfprovideroktaappoauthpropertycustomclientid"></a>

```typescript
public readonly customClientId: string;
```

- *Type:* `string`

---

##### `enduserNote`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.property.enduserNote" id="cdktfprovideroktaappoauthpropertyendusernote"></a>

```typescript
public readonly enduserNote: string;
```

- *Type:* `string`

---

##### `grantTypes`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.property.grantTypes" id="cdktfprovideroktaappoauthpropertygranttypes"></a>

```typescript
public readonly grantTypes: string[];
```

- *Type:* `string`[]

---

##### `groups`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.property.groups" id="cdktfprovideroktaappoauthpropertygroups"></a>

```typescript
public readonly groups: string[];
```

- *Type:* `string`[]

---

##### `hideIos`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.property.hideIos" id="cdktfprovideroktaappoauthpropertyhideios"></a>

```typescript
public readonly hideIos: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `hideWeb`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.property.hideWeb" id="cdktfprovideroktaappoauthpropertyhideweb"></a>

```typescript
public readonly hideWeb: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.property.id" id="cdktfprovideroktaappoauthpropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `implicitAssignment`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.property.implicitAssignment" id="cdktfprovideroktaappoauthpropertyimplicitassignment"></a>

```typescript
public readonly implicitAssignment: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `issuerMode`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.property.issuerMode" id="cdktfprovideroktaappoauthpropertyissuermode"></a>

```typescript
public readonly issuerMode: string;
```

- *Type:* `string`

---

##### `label`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.property.label" id="cdktfprovideroktaappoauthpropertylabel"></a>

```typescript
public readonly label: string;
```

- *Type:* `string`

---

##### `loginMode`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.property.loginMode" id="cdktfprovideroktaappoauthpropertyloginmode"></a>

```typescript
public readonly loginMode: string;
```

- *Type:* `string`

---

##### `loginScopes`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.property.loginScopes" id="cdktfprovideroktaappoauthpropertyloginscopes"></a>

```typescript
public readonly loginScopes: string[];
```

- *Type:* `string`[]

---

##### `loginUri`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.property.loginUri" id="cdktfprovideroktaappoauthpropertyloginuri"></a>

```typescript
public readonly loginUri: string;
```

- *Type:* `string`

---

##### `logo`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.property.logo" id="cdktfprovideroktaappoauthpropertylogo"></a>

```typescript
public readonly logo: string;
```

- *Type:* `string`

---

##### `logoUri`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.property.logoUri" id="cdktfprovideroktaappoauthpropertylogouri"></a>

```typescript
public readonly logoUri: string;
```

- *Type:* `string`

---

##### `omitSecret`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.property.omitSecret" id="cdktfprovideroktaappoauthpropertyomitsecret"></a>

```typescript
public readonly omitSecret: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `policyUri`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.property.policyUri" id="cdktfprovideroktaappoauthpropertypolicyuri"></a>

```typescript
public readonly policyUri: string;
```

- *Type:* `string`

---

##### `postLogoutRedirectUris`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.property.postLogoutRedirectUris" id="cdktfprovideroktaappoauthpropertypostlogoutredirecturis"></a>

```typescript
public readonly postLogoutRedirectUris: string[];
```

- *Type:* `string`[]

---

##### `profile`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.property.profile" id="cdktfprovideroktaappoauthpropertyprofile"></a>

```typescript
public readonly profile: string;
```

- *Type:* `string`

---

##### `redirectUris`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.property.redirectUris" id="cdktfprovideroktaappoauthpropertyredirecturis"></a>

```typescript
public readonly redirectUris: string[];
```

- *Type:* `string`[]

---

##### `refreshTokenLeeway`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.property.refreshTokenLeeway" id="cdktfprovideroktaappoauthpropertyrefreshtokenleeway"></a>

```typescript
public readonly refreshTokenLeeway: number;
```

- *Type:* `number`

---

##### `refreshTokenRotation`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.property.refreshTokenRotation" id="cdktfprovideroktaappoauthpropertyrefreshtokenrotation"></a>

```typescript
public readonly refreshTokenRotation: string;
```

- *Type:* `string`

---

##### `responseTypes`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.property.responseTypes" id="cdktfprovideroktaappoauthpropertyresponsetypes"></a>

```typescript
public readonly responseTypes: string[];
```

- *Type:* `string`[]

---

##### `skipGroups`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.property.skipGroups" id="cdktfprovideroktaappoauthpropertyskipgroups"></a>

```typescript
public readonly skipGroups: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `skipUsers`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.property.skipUsers" id="cdktfprovideroktaappoauthpropertyskipusers"></a>

```typescript
public readonly skipUsers: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `status`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.property.status" id="cdktfprovideroktaappoauthpropertystatus"></a>

```typescript
public readonly status: string;
```

- *Type:* `string`

---

##### `tokenEndpointAuthMethod`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.property.tokenEndpointAuthMethod" id="cdktfprovideroktaappoauthpropertytokenendpointauthmethod"></a>

```typescript
public readonly tokenEndpointAuthMethod: string;
```

- *Type:* `string`

---

##### `tosUri`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.property.tosUri" id="cdktfprovideroktaappoauthpropertytosuri"></a>

```typescript
public readonly tosUri: string;
```

- *Type:* `string`

---

##### `type`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.property.type" id="cdktfprovideroktaappoauthpropertytype"></a>

```typescript
public readonly type: string;
```

- *Type:* `string`

---

##### `userNameTemplate`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.property.userNameTemplate" id="cdktfprovideroktaappoauthpropertyusernametemplate"></a>

```typescript
public readonly userNameTemplate: string;
```

- *Type:* `string`

---

##### `userNameTemplatePushStatus`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.property.userNameTemplatePushStatus" id="cdktfprovideroktaappoauthpropertyusernametemplatepushstatus"></a>

```typescript
public readonly userNameTemplatePushStatus: string;
```

- *Type:* `string`

---

##### `userNameTemplateSuffix`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.property.userNameTemplateSuffix" id="cdktfprovideroktaappoauthpropertyusernametemplatesuffix"></a>

```typescript
public readonly userNameTemplateSuffix: string;
```

- *Type:* `string`

---

##### `userNameTemplateType`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.property.userNameTemplateType" id="cdktfprovideroktaappoauthpropertyusernametemplatetype"></a>

```typescript
public readonly userNameTemplateType: string;
```

- *Type:* `string`

---

##### `wildcardRedirect`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauth.property.wildcardRedirect" id="cdktfprovideroktaappoauthpropertywildcardredirect"></a>

```typescript
public readonly wildcardRedirect: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktaappoauthpropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.AppOauth.property.tfResourceType" id="cdktfprovideroktaappoauthpropertytfresourcetype"></a>

- *Type:* `string`

---

### AppOauthApiScope <a name="@cdktf/provider-okta.AppOauthApiScope" id="cdktfprovideroktaappoauthapiscope"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/r/app_oauth_api_scope okta_app_oauth_api_scope}.

#### Initializers <a name="@cdktf/provider-okta.AppOauthApiScope.Initializer" id="cdktfprovideroktaappoauthapiscopeinitializer"></a>

```typescript
import { AppOauthApiScope } from '@cdktf/provider-okta'

new AppOauthApiScope(scope: Construct, id: string, config: AppOauthApiScopeConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktaappoauthapiscopeparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktaappoauthapiscopeparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktaappoauthapiscopeparameterconfig)<span title="Required">*</span> | [`@cdktf/provider-okta.AppOauthApiScopeConfig`](#@cdktf/provider-okta.AppOauthApiScopeConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauthApiScope.parameter.scope" id="cdktfprovideroktaappoauthapiscopeparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauthApiScope.parameter.id" id="cdktfprovideroktaappoauthapiscopeparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauthApiScope.parameter.config" id="cdktfprovideroktaappoauthapiscopeparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.AppOauthApiScopeConfig`](#@cdktf/provider-okta.AppOauthApiScopeConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`resetId`](#cdktfprovideroktaappoauthapiscoperesetid) | *No description.* |

---

##### `resetId` <a name="@cdktf/provider-okta.AppOauthApiScope.resetId" id="cdktfprovideroktaappoauthapiscoperesetid"></a>

```typescript
public resetId()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`appIdInput`](#cdktfprovideroktaappoauthapiscopepropertyappidinput) | `string` | *No description.* |
| [`idInput`](#cdktfprovideroktaappoauthapiscopepropertyidinput) | `string` | *No description.* |
| [`issuerInput`](#cdktfprovideroktaappoauthapiscopepropertyissuerinput) | `string` | *No description.* |
| [`scopesInput`](#cdktfprovideroktaappoauthapiscopepropertyscopesinput) | `string`[] | *No description.* |
| [`appId`](#cdktfprovideroktaappoauthapiscopepropertyappid)<span title="Required">*</span> | `string` | *No description.* |
| [`id`](#cdktfprovideroktaappoauthapiscopepropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`issuer`](#cdktfprovideroktaappoauthapiscopepropertyissuer)<span title="Required">*</span> | `string` | *No description.* |
| [`scopes`](#cdktfprovideroktaappoauthapiscopepropertyscopes)<span title="Required">*</span> | `string`[] | *No description.* |

---

##### `appIdInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauthApiScope.property.appIdInput" id="cdktfprovideroktaappoauthapiscopepropertyappidinput"></a>

```typescript
public readonly appIdInput: string;
```

- *Type:* `string`

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauthApiScope.property.idInput" id="cdktfprovideroktaappoauthapiscopepropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `issuerInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauthApiScope.property.issuerInput" id="cdktfprovideroktaappoauthapiscopepropertyissuerinput"></a>

```typescript
public readonly issuerInput: string;
```

- *Type:* `string`

---

##### `scopesInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauthApiScope.property.scopesInput" id="cdktfprovideroktaappoauthapiscopepropertyscopesinput"></a>

```typescript
public readonly scopesInput: string[];
```

- *Type:* `string`[]

---

##### `appId`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauthApiScope.property.appId" id="cdktfprovideroktaappoauthapiscopepropertyappid"></a>

```typescript
public readonly appId: string;
```

- *Type:* `string`

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauthApiScope.property.id" id="cdktfprovideroktaappoauthapiscopepropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `issuer`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauthApiScope.property.issuer" id="cdktfprovideroktaappoauthapiscopepropertyissuer"></a>

```typescript
public readonly issuer: string;
```

- *Type:* `string`

---

##### `scopes`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauthApiScope.property.scopes" id="cdktfprovideroktaappoauthapiscopepropertyscopes"></a>

```typescript
public readonly scopes: string[];
```

- *Type:* `string`[]

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktaappoauthapiscopepropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.AppOauthApiScope.property.tfResourceType" id="cdktfprovideroktaappoauthapiscopepropertytfresourcetype"></a>

- *Type:* `string`

---

### AppOauthPostLogoutRedirectUri <a name="@cdktf/provider-okta.AppOauthPostLogoutRedirectUri" id="cdktfprovideroktaappoauthpostlogoutredirecturi"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/r/app_oauth_post_logout_redirect_uri okta_app_oauth_post_logout_redirect_uri}.

#### Initializers <a name="@cdktf/provider-okta.AppOauthPostLogoutRedirectUri.Initializer" id="cdktfprovideroktaappoauthpostlogoutredirecturiinitializer"></a>

```typescript
import { AppOauthPostLogoutRedirectUri } from '@cdktf/provider-okta'

new AppOauthPostLogoutRedirectUri(scope: Construct, id: string, config: AppOauthPostLogoutRedirectUriConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktaappoauthpostlogoutredirecturiparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktaappoauthpostlogoutredirecturiparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktaappoauthpostlogoutredirecturiparameterconfig)<span title="Required">*</span> | [`@cdktf/provider-okta.AppOauthPostLogoutRedirectUriConfig`](#@cdktf/provider-okta.AppOauthPostLogoutRedirectUriConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauthPostLogoutRedirectUri.parameter.scope" id="cdktfprovideroktaappoauthpostlogoutredirecturiparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauthPostLogoutRedirectUri.parameter.id" id="cdktfprovideroktaappoauthpostlogoutredirecturiparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauthPostLogoutRedirectUri.parameter.config" id="cdktfprovideroktaappoauthpostlogoutredirecturiparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.AppOauthPostLogoutRedirectUriConfig`](#@cdktf/provider-okta.AppOauthPostLogoutRedirectUriConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`resetId`](#cdktfprovideroktaappoauthpostlogoutredirecturiresetid) | *No description.* |

---

##### `resetId` <a name="@cdktf/provider-okta.AppOauthPostLogoutRedirectUri.resetId" id="cdktfprovideroktaappoauthpostlogoutredirecturiresetid"></a>

```typescript
public resetId()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`appIdInput`](#cdktfprovideroktaappoauthpostlogoutredirecturipropertyappidinput) | `string` | *No description.* |
| [`idInput`](#cdktfprovideroktaappoauthpostlogoutredirecturipropertyidinput) | `string` | *No description.* |
| [`uriInput`](#cdktfprovideroktaappoauthpostlogoutredirecturipropertyuriinput) | `string` | *No description.* |
| [`appId`](#cdktfprovideroktaappoauthpostlogoutredirecturipropertyappid)<span title="Required">*</span> | `string` | *No description.* |
| [`id`](#cdktfprovideroktaappoauthpostlogoutredirecturipropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`uri`](#cdktfprovideroktaappoauthpostlogoutredirecturipropertyuri)<span title="Required">*</span> | `string` | *No description.* |

---

##### `appIdInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauthPostLogoutRedirectUri.property.appIdInput" id="cdktfprovideroktaappoauthpostlogoutredirecturipropertyappidinput"></a>

```typescript
public readonly appIdInput: string;
```

- *Type:* `string`

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauthPostLogoutRedirectUri.property.idInput" id="cdktfprovideroktaappoauthpostlogoutredirecturipropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `uriInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauthPostLogoutRedirectUri.property.uriInput" id="cdktfprovideroktaappoauthpostlogoutredirecturipropertyuriinput"></a>

```typescript
public readonly uriInput: string;
```

- *Type:* `string`

---

##### `appId`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauthPostLogoutRedirectUri.property.appId" id="cdktfprovideroktaappoauthpostlogoutredirecturipropertyappid"></a>

```typescript
public readonly appId: string;
```

- *Type:* `string`

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauthPostLogoutRedirectUri.property.id" id="cdktfprovideroktaappoauthpostlogoutredirecturipropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `uri`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauthPostLogoutRedirectUri.property.uri" id="cdktfprovideroktaappoauthpostlogoutredirecturipropertyuri"></a>

```typescript
public readonly uri: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktaappoauthpostlogoutredirecturipropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.AppOauthPostLogoutRedirectUri.property.tfResourceType" id="cdktfprovideroktaappoauthpostlogoutredirecturipropertytfresourcetype"></a>

- *Type:* `string`

---

### AppOauthRedirectUri <a name="@cdktf/provider-okta.AppOauthRedirectUri" id="cdktfprovideroktaappoauthredirecturi"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/r/app_oauth_redirect_uri okta_app_oauth_redirect_uri}.

#### Initializers <a name="@cdktf/provider-okta.AppOauthRedirectUri.Initializer" id="cdktfprovideroktaappoauthredirecturiinitializer"></a>

```typescript
import { AppOauthRedirectUri } from '@cdktf/provider-okta'

new AppOauthRedirectUri(scope: Construct, id: string, config: AppOauthRedirectUriConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktaappoauthredirecturiparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktaappoauthredirecturiparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktaappoauthredirecturiparameterconfig)<span title="Required">*</span> | [`@cdktf/provider-okta.AppOauthRedirectUriConfig`](#@cdktf/provider-okta.AppOauthRedirectUriConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauthRedirectUri.parameter.scope" id="cdktfprovideroktaappoauthredirecturiparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauthRedirectUri.parameter.id" id="cdktfprovideroktaappoauthredirecturiparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauthRedirectUri.parameter.config" id="cdktfprovideroktaappoauthredirecturiparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.AppOauthRedirectUriConfig`](#@cdktf/provider-okta.AppOauthRedirectUriConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`resetId`](#cdktfprovideroktaappoauthredirecturiresetid) | *No description.* |

---

##### `resetId` <a name="@cdktf/provider-okta.AppOauthRedirectUri.resetId" id="cdktfprovideroktaappoauthredirecturiresetid"></a>

```typescript
public resetId()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`appIdInput`](#cdktfprovideroktaappoauthredirecturipropertyappidinput) | `string` | *No description.* |
| [`idInput`](#cdktfprovideroktaappoauthredirecturipropertyidinput) | `string` | *No description.* |
| [`uriInput`](#cdktfprovideroktaappoauthredirecturipropertyuriinput) | `string` | *No description.* |
| [`appId`](#cdktfprovideroktaappoauthredirecturipropertyappid)<span title="Required">*</span> | `string` | *No description.* |
| [`id`](#cdktfprovideroktaappoauthredirecturipropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`uri`](#cdktfprovideroktaappoauthredirecturipropertyuri)<span title="Required">*</span> | `string` | *No description.* |

---

##### `appIdInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauthRedirectUri.property.appIdInput" id="cdktfprovideroktaappoauthredirecturipropertyappidinput"></a>

```typescript
public readonly appIdInput: string;
```

- *Type:* `string`

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauthRedirectUri.property.idInput" id="cdktfprovideroktaappoauthredirecturipropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `uriInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppOauthRedirectUri.property.uriInput" id="cdktfprovideroktaappoauthredirecturipropertyuriinput"></a>

```typescript
public readonly uriInput: string;
```

- *Type:* `string`

---

##### `appId`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauthRedirectUri.property.appId" id="cdktfprovideroktaappoauthredirecturipropertyappid"></a>

```typescript
public readonly appId: string;
```

- *Type:* `string`

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauthRedirectUri.property.id" id="cdktfprovideroktaappoauthredirecturipropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `uri`<sup>Required</sup> <a name="@cdktf/provider-okta.AppOauthRedirectUri.property.uri" id="cdktfprovideroktaappoauthredirecturipropertyuri"></a>

```typescript
public readonly uri: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktaappoauthredirecturipropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.AppOauthRedirectUri.property.tfResourceType" id="cdktfprovideroktaappoauthredirecturipropertytfresourcetype"></a>

- *Type:* `string`

---

### AppSaml <a name="@cdktf/provider-okta.AppSaml" id="cdktfprovideroktaappsaml"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/r/app_saml okta_app_saml}.

#### Initializers <a name="@cdktf/provider-okta.AppSaml.Initializer" id="cdktfprovideroktaappsamlinitializer"></a>

```typescript
import { AppSaml } from '@cdktf/provider-okta'

new AppSaml(scope: Construct, id: string, config: AppSamlConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktaappsamlparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktaappsamlparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktaappsamlparameterconfig)<span title="Required">*</span> | [`@cdktf/provider-okta.AppSamlConfig`](#@cdktf/provider-okta.AppSamlConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.parameter.scope" id="cdktfprovideroktaappsamlparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.parameter.id" id="cdktfprovideroktaappsamlparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.parameter.config" id="cdktfprovideroktaappsamlparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.AppSamlConfig`](#@cdktf/provider-okta.AppSamlConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`putAttributeStatements`](#cdktfprovideroktaappsamlputattributestatements) | *No description.* |
| [`putTimeouts`](#cdktfprovideroktaappsamlputtimeouts) | *No description.* |
| [`putUsers`](#cdktfprovideroktaappsamlputusers) | *No description.* |
| [`resetAccessibilityErrorRedirectUrl`](#cdktfprovideroktaappsamlresetaccessibilityerrorredirecturl) | *No description.* |
| [`resetAccessibilityLoginRedirectUrl`](#cdktfprovideroktaappsamlresetaccessibilityloginredirecturl) | *No description.* |
| [`resetAccessibilitySelfService`](#cdktfprovideroktaappsamlresetaccessibilityselfservice) | *No description.* |
| [`resetAcsEndpoints`](#cdktfprovideroktaappsamlresetacsendpoints) | *No description.* |
| [`resetAdminNote`](#cdktfprovideroktaappsamlresetadminnote) | *No description.* |
| [`resetAppLinksJson`](#cdktfprovideroktaappsamlresetapplinksjson) | *No description.* |
| [`resetAppSettingsJson`](#cdktfprovideroktaappsamlresetappsettingsjson) | *No description.* |
| [`resetAssertionSigned`](#cdktfprovideroktaappsamlresetassertionsigned) | *No description.* |
| [`resetAttributeStatements`](#cdktfprovideroktaappsamlresetattributestatements) | *No description.* |
| [`resetAudience`](#cdktfprovideroktaappsamlresetaudience) | *No description.* |
| [`resetAuthenticationPolicy`](#cdktfprovideroktaappsamlresetauthenticationpolicy) | *No description.* |
| [`resetAuthnContextClassRef`](#cdktfprovideroktaappsamlresetauthncontextclassref) | *No description.* |
| [`resetAutoSubmitToolbar`](#cdktfprovideroktaappsamlresetautosubmittoolbar) | *No description.* |
| [`resetDefaultRelayState`](#cdktfprovideroktaappsamlresetdefaultrelaystate) | *No description.* |
| [`resetDestination`](#cdktfprovideroktaappsamlresetdestination) | *No description.* |
| [`resetDigestAlgorithm`](#cdktfprovideroktaappsamlresetdigestalgorithm) | *No description.* |
| [`resetEnduserNote`](#cdktfprovideroktaappsamlresetendusernote) | *No description.* |
| [`resetFeatures`](#cdktfprovideroktaappsamlresetfeatures) | *No description.* |
| [`resetGroups`](#cdktfprovideroktaappsamlresetgroups) | *No description.* |
| [`resetHideIos`](#cdktfprovideroktaappsamlresethideios) | *No description.* |
| [`resetHideWeb`](#cdktfprovideroktaappsamlresethideweb) | *No description.* |
| [`resetHonorForceAuthn`](#cdktfprovideroktaappsamlresethonorforceauthn) | *No description.* |
| [`resetId`](#cdktfprovideroktaappsamlresetid) | *No description.* |
| [`resetIdpIssuer`](#cdktfprovideroktaappsamlresetidpissuer) | *No description.* |
| [`resetImplicitAssignment`](#cdktfprovideroktaappsamlresetimplicitassignment) | *No description.* |
| [`resetInlineHookId`](#cdktfprovideroktaappsamlresetinlinehookid) | *No description.* |
| [`resetKeyName`](#cdktfprovideroktaappsamlresetkeyname) | *No description.* |
| [`resetKeyYearsValid`](#cdktfprovideroktaappsamlresetkeyyearsvalid) | *No description.* |
| [`resetLogo`](#cdktfprovideroktaappsamlresetlogo) | *No description.* |
| [`resetPreconfiguredApp`](#cdktfprovideroktaappsamlresetpreconfiguredapp) | *No description.* |
| [`resetRecipient`](#cdktfprovideroktaappsamlresetrecipient) | *No description.* |
| [`resetRequestCompressed`](#cdktfprovideroktaappsamlresetrequestcompressed) | *No description.* |
| [`resetResponseSigned`](#cdktfprovideroktaappsamlresetresponsesigned) | *No description.* |
| [`resetSamlVersion`](#cdktfprovideroktaappsamlresetsamlversion) | *No description.* |
| [`resetSignatureAlgorithm`](#cdktfprovideroktaappsamlresetsignaturealgorithm) | *No description.* |
| [`resetSingleLogoutCertificate`](#cdktfprovideroktaappsamlresetsinglelogoutcertificate) | *No description.* |
| [`resetSingleLogoutIssuer`](#cdktfprovideroktaappsamlresetsinglelogoutissuer) | *No description.* |
| [`resetSingleLogoutUrl`](#cdktfprovideroktaappsamlresetsinglelogouturl) | *No description.* |
| [`resetSkipGroups`](#cdktfprovideroktaappsamlresetskipgroups) | *No description.* |
| [`resetSkipUsers`](#cdktfprovideroktaappsamlresetskipusers) | *No description.* |
| [`resetSpIssuer`](#cdktfprovideroktaappsamlresetspissuer) | *No description.* |
| [`resetSsoUrl`](#cdktfprovideroktaappsamlresetssourl) | *No description.* |
| [`resetStatus`](#cdktfprovideroktaappsamlresetstatus) | *No description.* |
| [`resetSubjectNameIdFormat`](#cdktfprovideroktaappsamlresetsubjectnameidformat) | *No description.* |
| [`resetSubjectNameIdTemplate`](#cdktfprovideroktaappsamlresetsubjectnameidtemplate) | *No description.* |
| [`resetTimeouts`](#cdktfprovideroktaappsamlresettimeouts) | *No description.* |
| [`resetUserNameTemplate`](#cdktfprovideroktaappsamlresetusernametemplate) | *No description.* |
| [`resetUserNameTemplatePushStatus`](#cdktfprovideroktaappsamlresetusernametemplatepushstatus) | *No description.* |
| [`resetUserNameTemplateSuffix`](#cdktfprovideroktaappsamlresetusernametemplatesuffix) | *No description.* |
| [`resetUserNameTemplateType`](#cdktfprovideroktaappsamlresetusernametemplatetype) | *No description.* |
| [`resetUsers`](#cdktfprovideroktaappsamlresetusers) | *No description.* |

---

##### `putAttributeStatements` <a name="@cdktf/provider-okta.AppSaml.putAttributeStatements" id="cdktfprovideroktaappsamlputattributestatements"></a>

```typescript
public putAttributeStatements(value: IResolvable | AppSamlAttributeStatements[])
```

###### `value`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.parameter.value" id="cdktfprovideroktaappsamlparametervalue"></a>

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable) | [`@cdktf/provider-okta.AppSamlAttributeStatements`](#@cdktf/provider-okta.AppSamlAttributeStatements)[]

---

##### `putTimeouts` <a name="@cdktf/provider-okta.AppSaml.putTimeouts" id="cdktfprovideroktaappsamlputtimeouts"></a>

```typescript
public putTimeouts(value: AppSamlTimeouts)
```

###### `value`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.parameter.value" id="cdktfprovideroktaappsamlparametervalue"></a>

- *Type:* [`@cdktf/provider-okta.AppSamlTimeouts`](#@cdktf/provider-okta.AppSamlTimeouts)

---

##### `putUsers` <a name="@cdktf/provider-okta.AppSaml.putUsers" id="cdktfprovideroktaappsamlputusers"></a>

```typescript
public putUsers(value: IResolvable | AppSamlUsers[])
```

###### `value`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.parameter.value" id="cdktfprovideroktaappsamlparametervalue"></a>

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable) | [`@cdktf/provider-okta.AppSamlUsers`](#@cdktf/provider-okta.AppSamlUsers)[]

---

##### `resetAccessibilityErrorRedirectUrl` <a name="@cdktf/provider-okta.AppSaml.resetAccessibilityErrorRedirectUrl" id="cdktfprovideroktaappsamlresetaccessibilityerrorredirecturl"></a>

```typescript
public resetAccessibilityErrorRedirectUrl()
```

##### `resetAccessibilityLoginRedirectUrl` <a name="@cdktf/provider-okta.AppSaml.resetAccessibilityLoginRedirectUrl" id="cdktfprovideroktaappsamlresetaccessibilityloginredirecturl"></a>

```typescript
public resetAccessibilityLoginRedirectUrl()
```

##### `resetAccessibilitySelfService` <a name="@cdktf/provider-okta.AppSaml.resetAccessibilitySelfService" id="cdktfprovideroktaappsamlresetaccessibilityselfservice"></a>

```typescript
public resetAccessibilitySelfService()
```

##### `resetAcsEndpoints` <a name="@cdktf/provider-okta.AppSaml.resetAcsEndpoints" id="cdktfprovideroktaappsamlresetacsendpoints"></a>

```typescript
public resetAcsEndpoints()
```

##### `resetAdminNote` <a name="@cdktf/provider-okta.AppSaml.resetAdminNote" id="cdktfprovideroktaappsamlresetadminnote"></a>

```typescript
public resetAdminNote()
```

##### `resetAppLinksJson` <a name="@cdktf/provider-okta.AppSaml.resetAppLinksJson" id="cdktfprovideroktaappsamlresetapplinksjson"></a>

```typescript
public resetAppLinksJson()
```

##### `resetAppSettingsJson` <a name="@cdktf/provider-okta.AppSaml.resetAppSettingsJson" id="cdktfprovideroktaappsamlresetappsettingsjson"></a>

```typescript
public resetAppSettingsJson()
```

##### `resetAssertionSigned` <a name="@cdktf/provider-okta.AppSaml.resetAssertionSigned" id="cdktfprovideroktaappsamlresetassertionsigned"></a>

```typescript
public resetAssertionSigned()
```

##### `resetAttributeStatements` <a name="@cdktf/provider-okta.AppSaml.resetAttributeStatements" id="cdktfprovideroktaappsamlresetattributestatements"></a>

```typescript
public resetAttributeStatements()
```

##### `resetAudience` <a name="@cdktf/provider-okta.AppSaml.resetAudience" id="cdktfprovideroktaappsamlresetaudience"></a>

```typescript
public resetAudience()
```

##### `resetAuthenticationPolicy` <a name="@cdktf/provider-okta.AppSaml.resetAuthenticationPolicy" id="cdktfprovideroktaappsamlresetauthenticationpolicy"></a>

```typescript
public resetAuthenticationPolicy()
```

##### `resetAuthnContextClassRef` <a name="@cdktf/provider-okta.AppSaml.resetAuthnContextClassRef" id="cdktfprovideroktaappsamlresetauthncontextclassref"></a>

```typescript
public resetAuthnContextClassRef()
```

##### `resetAutoSubmitToolbar` <a name="@cdktf/provider-okta.AppSaml.resetAutoSubmitToolbar" id="cdktfprovideroktaappsamlresetautosubmittoolbar"></a>

```typescript
public resetAutoSubmitToolbar()
```

##### `resetDefaultRelayState` <a name="@cdktf/provider-okta.AppSaml.resetDefaultRelayState" id="cdktfprovideroktaappsamlresetdefaultrelaystate"></a>

```typescript
public resetDefaultRelayState()
```

##### `resetDestination` <a name="@cdktf/provider-okta.AppSaml.resetDestination" id="cdktfprovideroktaappsamlresetdestination"></a>

```typescript
public resetDestination()
```

##### `resetDigestAlgorithm` <a name="@cdktf/provider-okta.AppSaml.resetDigestAlgorithm" id="cdktfprovideroktaappsamlresetdigestalgorithm"></a>

```typescript
public resetDigestAlgorithm()
```

##### `resetEnduserNote` <a name="@cdktf/provider-okta.AppSaml.resetEnduserNote" id="cdktfprovideroktaappsamlresetendusernote"></a>

```typescript
public resetEnduserNote()
```

##### `resetFeatures` <a name="@cdktf/provider-okta.AppSaml.resetFeatures" id="cdktfprovideroktaappsamlresetfeatures"></a>

```typescript
public resetFeatures()
```

##### `resetGroups` <a name="@cdktf/provider-okta.AppSaml.resetGroups" id="cdktfprovideroktaappsamlresetgroups"></a>

```typescript
public resetGroups()
```

##### `resetHideIos` <a name="@cdktf/provider-okta.AppSaml.resetHideIos" id="cdktfprovideroktaappsamlresethideios"></a>

```typescript
public resetHideIos()
```

##### `resetHideWeb` <a name="@cdktf/provider-okta.AppSaml.resetHideWeb" id="cdktfprovideroktaappsamlresethideweb"></a>

```typescript
public resetHideWeb()
```

##### `resetHonorForceAuthn` <a name="@cdktf/provider-okta.AppSaml.resetHonorForceAuthn" id="cdktfprovideroktaappsamlresethonorforceauthn"></a>

```typescript
public resetHonorForceAuthn()
```

##### `resetId` <a name="@cdktf/provider-okta.AppSaml.resetId" id="cdktfprovideroktaappsamlresetid"></a>

```typescript
public resetId()
```

##### `resetIdpIssuer` <a name="@cdktf/provider-okta.AppSaml.resetIdpIssuer" id="cdktfprovideroktaappsamlresetidpissuer"></a>

```typescript
public resetIdpIssuer()
```

##### `resetImplicitAssignment` <a name="@cdktf/provider-okta.AppSaml.resetImplicitAssignment" id="cdktfprovideroktaappsamlresetimplicitassignment"></a>

```typescript
public resetImplicitAssignment()
```

##### `resetInlineHookId` <a name="@cdktf/provider-okta.AppSaml.resetInlineHookId" id="cdktfprovideroktaappsamlresetinlinehookid"></a>

```typescript
public resetInlineHookId()
```

##### `resetKeyName` <a name="@cdktf/provider-okta.AppSaml.resetKeyName" id="cdktfprovideroktaappsamlresetkeyname"></a>

```typescript
public resetKeyName()
```

##### `resetKeyYearsValid` <a name="@cdktf/provider-okta.AppSaml.resetKeyYearsValid" id="cdktfprovideroktaappsamlresetkeyyearsvalid"></a>

```typescript
public resetKeyYearsValid()
```

##### `resetLogo` <a name="@cdktf/provider-okta.AppSaml.resetLogo" id="cdktfprovideroktaappsamlresetlogo"></a>

```typescript
public resetLogo()
```

##### `resetPreconfiguredApp` <a name="@cdktf/provider-okta.AppSaml.resetPreconfiguredApp" id="cdktfprovideroktaappsamlresetpreconfiguredapp"></a>

```typescript
public resetPreconfiguredApp()
```

##### `resetRecipient` <a name="@cdktf/provider-okta.AppSaml.resetRecipient" id="cdktfprovideroktaappsamlresetrecipient"></a>

```typescript
public resetRecipient()
```

##### `resetRequestCompressed` <a name="@cdktf/provider-okta.AppSaml.resetRequestCompressed" id="cdktfprovideroktaappsamlresetrequestcompressed"></a>

```typescript
public resetRequestCompressed()
```

##### `resetResponseSigned` <a name="@cdktf/provider-okta.AppSaml.resetResponseSigned" id="cdktfprovideroktaappsamlresetresponsesigned"></a>

```typescript
public resetResponseSigned()
```

##### `resetSamlVersion` <a name="@cdktf/provider-okta.AppSaml.resetSamlVersion" id="cdktfprovideroktaappsamlresetsamlversion"></a>

```typescript
public resetSamlVersion()
```

##### `resetSignatureAlgorithm` <a name="@cdktf/provider-okta.AppSaml.resetSignatureAlgorithm" id="cdktfprovideroktaappsamlresetsignaturealgorithm"></a>

```typescript
public resetSignatureAlgorithm()
```

##### `resetSingleLogoutCertificate` <a name="@cdktf/provider-okta.AppSaml.resetSingleLogoutCertificate" id="cdktfprovideroktaappsamlresetsinglelogoutcertificate"></a>

```typescript
public resetSingleLogoutCertificate()
```

##### `resetSingleLogoutIssuer` <a name="@cdktf/provider-okta.AppSaml.resetSingleLogoutIssuer" id="cdktfprovideroktaappsamlresetsinglelogoutissuer"></a>

```typescript
public resetSingleLogoutIssuer()
```

##### `resetSingleLogoutUrl` <a name="@cdktf/provider-okta.AppSaml.resetSingleLogoutUrl" id="cdktfprovideroktaappsamlresetsinglelogouturl"></a>

```typescript
public resetSingleLogoutUrl()
```

##### `resetSkipGroups` <a name="@cdktf/provider-okta.AppSaml.resetSkipGroups" id="cdktfprovideroktaappsamlresetskipgroups"></a>

```typescript
public resetSkipGroups()
```

##### `resetSkipUsers` <a name="@cdktf/provider-okta.AppSaml.resetSkipUsers" id="cdktfprovideroktaappsamlresetskipusers"></a>

```typescript
public resetSkipUsers()
```

##### `resetSpIssuer` <a name="@cdktf/provider-okta.AppSaml.resetSpIssuer" id="cdktfprovideroktaappsamlresetspissuer"></a>

```typescript
public resetSpIssuer()
```

##### `resetSsoUrl` <a name="@cdktf/provider-okta.AppSaml.resetSsoUrl" id="cdktfprovideroktaappsamlresetssourl"></a>

```typescript
public resetSsoUrl()
```

##### `resetStatus` <a name="@cdktf/provider-okta.AppSaml.resetStatus" id="cdktfprovideroktaappsamlresetstatus"></a>

```typescript
public resetStatus()
```

##### `resetSubjectNameIdFormat` <a name="@cdktf/provider-okta.AppSaml.resetSubjectNameIdFormat" id="cdktfprovideroktaappsamlresetsubjectnameidformat"></a>

```typescript
public resetSubjectNameIdFormat()
```

##### `resetSubjectNameIdTemplate` <a name="@cdktf/provider-okta.AppSaml.resetSubjectNameIdTemplate" id="cdktfprovideroktaappsamlresetsubjectnameidtemplate"></a>

```typescript
public resetSubjectNameIdTemplate()
```

##### `resetTimeouts` <a name="@cdktf/provider-okta.AppSaml.resetTimeouts" id="cdktfprovideroktaappsamlresettimeouts"></a>

```typescript
public resetTimeouts()
```

##### `resetUserNameTemplate` <a name="@cdktf/provider-okta.AppSaml.resetUserNameTemplate" id="cdktfprovideroktaappsamlresetusernametemplate"></a>

```typescript
public resetUserNameTemplate()
```

##### `resetUserNameTemplatePushStatus` <a name="@cdktf/provider-okta.AppSaml.resetUserNameTemplatePushStatus" id="cdktfprovideroktaappsamlresetusernametemplatepushstatus"></a>

```typescript
public resetUserNameTemplatePushStatus()
```

##### `resetUserNameTemplateSuffix` <a name="@cdktf/provider-okta.AppSaml.resetUserNameTemplateSuffix" id="cdktfprovideroktaappsamlresetusernametemplatesuffix"></a>

```typescript
public resetUserNameTemplateSuffix()
```

##### `resetUserNameTemplateType` <a name="@cdktf/provider-okta.AppSaml.resetUserNameTemplateType" id="cdktfprovideroktaappsamlresetusernametemplatetype"></a>

```typescript
public resetUserNameTemplateType()
```

##### `resetUsers` <a name="@cdktf/provider-okta.AppSaml.resetUsers" id="cdktfprovideroktaappsamlresetusers"></a>

```typescript
public resetUsers()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`attributeStatements`](#cdktfprovideroktaappsamlpropertyattributestatements)<span title="Required">*</span> | [`@cdktf/provider-okta.AppSamlAttributeStatementsList`](#@cdktf/provider-okta.AppSamlAttributeStatementsList) | *No description.* |
| [`certificate`](#cdktfprovideroktaappsamlpropertycertificate)<span title="Required">*</span> | `string` | *No description.* |
| [`embedUrl`](#cdktfprovideroktaappsamlpropertyembedurl)<span title="Required">*</span> | `string` | *No description.* |
| [`entityKey`](#cdktfprovideroktaappsamlpropertyentitykey)<span title="Required">*</span> | `string` | *No description.* |
| [`entityUrl`](#cdktfprovideroktaappsamlpropertyentityurl)<span title="Required">*</span> | `string` | *No description.* |
| [`httpPostBinding`](#cdktfprovideroktaappsamlpropertyhttppostbinding)<span title="Required">*</span> | `string` | *No description.* |
| [`httpRedirectBinding`](#cdktfprovideroktaappsamlpropertyhttpredirectbinding)<span title="Required">*</span> | `string` | *No description.* |
| [`keyId`](#cdktfprovideroktaappsamlpropertykeyid)<span title="Required">*</span> | `string` | *No description.* |
| [`keys`](#cdktfprovideroktaappsamlpropertykeys)<span title="Required">*</span> | [`@cdktf/provider-okta.AppSamlKeysList`](#@cdktf/provider-okta.AppSamlKeysList) | *No description.* |
| [`logoUrl`](#cdktfprovideroktaappsamlpropertylogourl)<span title="Required">*</span> | `string` | *No description.* |
| [`metadata`](#cdktfprovideroktaappsamlpropertymetadata)<span title="Required">*</span> | `string` | *No description.* |
| [`metadataUrl`](#cdktfprovideroktaappsamlpropertymetadataurl)<span title="Required">*</span> | `string` | *No description.* |
| [`name`](#cdktfprovideroktaappsamlpropertyname)<span title="Required">*</span> | `string` | *No description.* |
| [`signOnMode`](#cdktfprovideroktaappsamlpropertysignonmode)<span title="Required">*</span> | `string` | *No description.* |
| [`timeouts`](#cdktfprovideroktaappsamlpropertytimeouts)<span title="Required">*</span> | [`@cdktf/provider-okta.AppSamlTimeoutsOutputReference`](#@cdktf/provider-okta.AppSamlTimeoutsOutputReference) | *No description.* |
| [`users`](#cdktfprovideroktaappsamlpropertyusers)<span title="Required">*</span> | [`@cdktf/provider-okta.AppSamlUsersList`](#@cdktf/provider-okta.AppSamlUsersList) | *No description.* |
| [`accessibilityErrorRedirectUrlInput`](#cdktfprovideroktaappsamlpropertyaccessibilityerrorredirecturlinput) | `string` | *No description.* |
| [`accessibilityLoginRedirectUrlInput`](#cdktfprovideroktaappsamlpropertyaccessibilityloginredirecturlinput) | `string` | *No description.* |
| [`accessibilitySelfServiceInput`](#cdktfprovideroktaappsamlpropertyaccessibilityselfserviceinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`acsEndpointsInput`](#cdktfprovideroktaappsamlpropertyacsendpointsinput) | `string`[] | *No description.* |
| [`adminNoteInput`](#cdktfprovideroktaappsamlpropertyadminnoteinput) | `string` | *No description.* |
| [`appLinksJsonInput`](#cdktfprovideroktaappsamlpropertyapplinksjsoninput) | `string` | *No description.* |
| [`appSettingsJsonInput`](#cdktfprovideroktaappsamlpropertyappsettingsjsoninput) | `string` | *No description.* |
| [`assertionSignedInput`](#cdktfprovideroktaappsamlpropertyassertionsignedinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`attributeStatementsInput`](#cdktfprovideroktaappsamlpropertyattributestatementsinput) | [`cdktf.IResolvable`](#cdktf.IResolvable) \| [`@cdktf/provider-okta.AppSamlAttributeStatements`](#@cdktf/provider-okta.AppSamlAttributeStatements)[] | *No description.* |
| [`audienceInput`](#cdktfprovideroktaappsamlpropertyaudienceinput) | `string` | *No description.* |
| [`authenticationPolicyInput`](#cdktfprovideroktaappsamlpropertyauthenticationpolicyinput) | `string` | *No description.* |
| [`authnContextClassRefInput`](#cdktfprovideroktaappsamlpropertyauthncontextclassrefinput) | `string` | *No description.* |
| [`autoSubmitToolbarInput`](#cdktfprovideroktaappsamlpropertyautosubmittoolbarinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`defaultRelayStateInput`](#cdktfprovideroktaappsamlpropertydefaultrelaystateinput) | `string` | *No description.* |
| [`destinationInput`](#cdktfprovideroktaappsamlpropertydestinationinput) | `string` | *No description.* |
| [`digestAlgorithmInput`](#cdktfprovideroktaappsamlpropertydigestalgorithminput) | `string` | *No description.* |
| [`enduserNoteInput`](#cdktfprovideroktaappsamlpropertyendusernoteinput) | `string` | *No description.* |
| [`featuresInput`](#cdktfprovideroktaappsamlpropertyfeaturesinput) | `string`[] | *No description.* |
| [`groupsInput`](#cdktfprovideroktaappsamlpropertygroupsinput) | `string`[] | *No description.* |
| [`hideIosInput`](#cdktfprovideroktaappsamlpropertyhideiosinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`hideWebInput`](#cdktfprovideroktaappsamlpropertyhidewebinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`honorForceAuthnInput`](#cdktfprovideroktaappsamlpropertyhonorforceauthninput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`idInput`](#cdktfprovideroktaappsamlpropertyidinput) | `string` | *No description.* |
| [`idpIssuerInput`](#cdktfprovideroktaappsamlpropertyidpissuerinput) | `string` | *No description.* |
| [`implicitAssignmentInput`](#cdktfprovideroktaappsamlpropertyimplicitassignmentinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`inlineHookIdInput`](#cdktfprovideroktaappsamlpropertyinlinehookidinput) | `string` | *No description.* |
| [`keyNameInput`](#cdktfprovideroktaappsamlpropertykeynameinput) | `string` | *No description.* |
| [`keyYearsValidInput`](#cdktfprovideroktaappsamlpropertykeyyearsvalidinput) | `number` | *No description.* |
| [`labelInput`](#cdktfprovideroktaappsamlpropertylabelinput) | `string` | *No description.* |
| [`logoInput`](#cdktfprovideroktaappsamlpropertylogoinput) | `string` | *No description.* |
| [`preconfiguredAppInput`](#cdktfprovideroktaappsamlpropertypreconfiguredappinput) | `string` | *No description.* |
| [`recipientInput`](#cdktfprovideroktaappsamlpropertyrecipientinput) | `string` | *No description.* |
| [`requestCompressedInput`](#cdktfprovideroktaappsamlpropertyrequestcompressedinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`responseSignedInput`](#cdktfprovideroktaappsamlpropertyresponsesignedinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`samlVersionInput`](#cdktfprovideroktaappsamlpropertysamlversioninput) | `string` | *No description.* |
| [`signatureAlgorithmInput`](#cdktfprovideroktaappsamlpropertysignaturealgorithminput) | `string` | *No description.* |
| [`singleLogoutCertificateInput`](#cdktfprovideroktaappsamlpropertysinglelogoutcertificateinput) | `string` | *No description.* |
| [`singleLogoutIssuerInput`](#cdktfprovideroktaappsamlpropertysinglelogoutissuerinput) | `string` | *No description.* |
| [`singleLogoutUrlInput`](#cdktfprovideroktaappsamlpropertysinglelogouturlinput) | `string` | *No description.* |
| [`skipGroupsInput`](#cdktfprovideroktaappsamlpropertyskipgroupsinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`skipUsersInput`](#cdktfprovideroktaappsamlpropertyskipusersinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`spIssuerInput`](#cdktfprovideroktaappsamlpropertyspissuerinput) | `string` | *No description.* |
| [`ssoUrlInput`](#cdktfprovideroktaappsamlpropertyssourlinput) | `string` | *No description.* |
| [`statusInput`](#cdktfprovideroktaappsamlpropertystatusinput) | `string` | *No description.* |
| [`subjectNameIdFormatInput`](#cdktfprovideroktaappsamlpropertysubjectnameidformatinput) | `string` | *No description.* |
| [`subjectNameIdTemplateInput`](#cdktfprovideroktaappsamlpropertysubjectnameidtemplateinput) | `string` | *No description.* |
| [`timeoutsInput`](#cdktfprovideroktaappsamlpropertytimeoutsinput) | [`cdktf.IResolvable`](#cdktf.IResolvable) \| [`@cdktf/provider-okta.AppSamlTimeouts`](#@cdktf/provider-okta.AppSamlTimeouts) | *No description.* |
| [`userNameTemplateInput`](#cdktfprovideroktaappsamlpropertyusernametemplateinput) | `string` | *No description.* |
| [`userNameTemplatePushStatusInput`](#cdktfprovideroktaappsamlpropertyusernametemplatepushstatusinput) | `string` | *No description.* |
| [`userNameTemplateSuffixInput`](#cdktfprovideroktaappsamlpropertyusernametemplatesuffixinput) | `string` | *No description.* |
| [`userNameTemplateTypeInput`](#cdktfprovideroktaappsamlpropertyusernametemplatetypeinput) | `string` | *No description.* |
| [`usersInput`](#cdktfprovideroktaappsamlpropertyusersinput) | [`cdktf.IResolvable`](#cdktf.IResolvable) \| [`@cdktf/provider-okta.AppSamlUsers`](#@cdktf/provider-okta.AppSamlUsers)[] | *No description.* |
| [`accessibilityErrorRedirectUrl`](#cdktfprovideroktaappsamlpropertyaccessibilityerrorredirecturl)<span title="Required">*</span> | `string` | *No description.* |
| [`accessibilityLoginRedirectUrl`](#cdktfprovideroktaappsamlpropertyaccessibilityloginredirecturl)<span title="Required">*</span> | `string` | *No description.* |
| [`accessibilitySelfService`](#cdktfprovideroktaappsamlpropertyaccessibilityselfservice)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`acsEndpoints`](#cdktfprovideroktaappsamlpropertyacsendpoints)<span title="Required">*</span> | `string`[] | *No description.* |
| [`adminNote`](#cdktfprovideroktaappsamlpropertyadminnote)<span title="Required">*</span> | `string` | *No description.* |
| [`appLinksJson`](#cdktfprovideroktaappsamlpropertyapplinksjson)<span title="Required">*</span> | `string` | *No description.* |
| [`appSettingsJson`](#cdktfprovideroktaappsamlpropertyappsettingsjson)<span title="Required">*</span> | `string` | *No description.* |
| [`assertionSigned`](#cdktfprovideroktaappsamlpropertyassertionsigned)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`audience`](#cdktfprovideroktaappsamlpropertyaudience)<span title="Required">*</span> | `string` | *No description.* |
| [`authenticationPolicy`](#cdktfprovideroktaappsamlpropertyauthenticationpolicy)<span title="Required">*</span> | `string` | *No description.* |
| [`authnContextClassRef`](#cdktfprovideroktaappsamlpropertyauthncontextclassref)<span title="Required">*</span> | `string` | *No description.* |
| [`autoSubmitToolbar`](#cdktfprovideroktaappsamlpropertyautosubmittoolbar)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`defaultRelayState`](#cdktfprovideroktaappsamlpropertydefaultrelaystate)<span title="Required">*</span> | `string` | *No description.* |
| [`destination`](#cdktfprovideroktaappsamlpropertydestination)<span title="Required">*</span> | `string` | *No description.* |
| [`digestAlgorithm`](#cdktfprovideroktaappsamlpropertydigestalgorithm)<span title="Required">*</span> | `string` | *No description.* |
| [`enduserNote`](#cdktfprovideroktaappsamlpropertyendusernote)<span title="Required">*</span> | `string` | *No description.* |
| [`features`](#cdktfprovideroktaappsamlpropertyfeatures)<span title="Required">*</span> | `string`[] | *No description.* |
| [`groups`](#cdktfprovideroktaappsamlpropertygroups)<span title="Required">*</span> | `string`[] | *No description.* |
| [`hideIos`](#cdktfprovideroktaappsamlpropertyhideios)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`hideWeb`](#cdktfprovideroktaappsamlpropertyhideweb)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`honorForceAuthn`](#cdktfprovideroktaappsamlpropertyhonorforceauthn)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`id`](#cdktfprovideroktaappsamlpropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`idpIssuer`](#cdktfprovideroktaappsamlpropertyidpissuer)<span title="Required">*</span> | `string` | *No description.* |
| [`implicitAssignment`](#cdktfprovideroktaappsamlpropertyimplicitassignment)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`inlineHookId`](#cdktfprovideroktaappsamlpropertyinlinehookid)<span title="Required">*</span> | `string` | *No description.* |
| [`keyName`](#cdktfprovideroktaappsamlpropertykeyname)<span title="Required">*</span> | `string` | *No description.* |
| [`keyYearsValid`](#cdktfprovideroktaappsamlpropertykeyyearsvalid)<span title="Required">*</span> | `number` | *No description.* |
| [`label`](#cdktfprovideroktaappsamlpropertylabel)<span title="Required">*</span> | `string` | *No description.* |
| [`logo`](#cdktfprovideroktaappsamlpropertylogo)<span title="Required">*</span> | `string` | *No description.* |
| [`preconfiguredApp`](#cdktfprovideroktaappsamlpropertypreconfiguredapp)<span title="Required">*</span> | `string` | *No description.* |
| [`recipient`](#cdktfprovideroktaappsamlpropertyrecipient)<span title="Required">*</span> | `string` | *No description.* |
| [`requestCompressed`](#cdktfprovideroktaappsamlpropertyrequestcompressed)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`responseSigned`](#cdktfprovideroktaappsamlpropertyresponsesigned)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`samlVersion`](#cdktfprovideroktaappsamlpropertysamlversion)<span title="Required">*</span> | `string` | *No description.* |
| [`signatureAlgorithm`](#cdktfprovideroktaappsamlpropertysignaturealgorithm)<span title="Required">*</span> | `string` | *No description.* |
| [`singleLogoutCertificate`](#cdktfprovideroktaappsamlpropertysinglelogoutcertificate)<span title="Required">*</span> | `string` | *No description.* |
| [`singleLogoutIssuer`](#cdktfprovideroktaappsamlpropertysinglelogoutissuer)<span title="Required">*</span> | `string` | *No description.* |
| [`singleLogoutUrl`](#cdktfprovideroktaappsamlpropertysinglelogouturl)<span title="Required">*</span> | `string` | *No description.* |
| [`skipGroups`](#cdktfprovideroktaappsamlpropertyskipgroups)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`skipUsers`](#cdktfprovideroktaappsamlpropertyskipusers)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`spIssuer`](#cdktfprovideroktaappsamlpropertyspissuer)<span title="Required">*</span> | `string` | *No description.* |
| [`ssoUrl`](#cdktfprovideroktaappsamlpropertyssourl)<span title="Required">*</span> | `string` | *No description.* |
| [`status`](#cdktfprovideroktaappsamlpropertystatus)<span title="Required">*</span> | `string` | *No description.* |
| [`subjectNameIdFormat`](#cdktfprovideroktaappsamlpropertysubjectnameidformat)<span title="Required">*</span> | `string` | *No description.* |
| [`subjectNameIdTemplate`](#cdktfprovideroktaappsamlpropertysubjectnameidtemplate)<span title="Required">*</span> | `string` | *No description.* |
| [`userNameTemplate`](#cdktfprovideroktaappsamlpropertyusernametemplate)<span title="Required">*</span> | `string` | *No description.* |
| [`userNameTemplatePushStatus`](#cdktfprovideroktaappsamlpropertyusernametemplatepushstatus)<span title="Required">*</span> | `string` | *No description.* |
| [`userNameTemplateSuffix`](#cdktfprovideroktaappsamlpropertyusernametemplatesuffix)<span title="Required">*</span> | `string` | *No description.* |
| [`userNameTemplateType`](#cdktfprovideroktaappsamlpropertyusernametemplatetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `attributeStatements`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.attributeStatements" id="cdktfprovideroktaappsamlpropertyattributestatements"></a>

```typescript
public readonly attributeStatements: AppSamlAttributeStatementsList;
```

- *Type:* [`@cdktf/provider-okta.AppSamlAttributeStatementsList`](#@cdktf/provider-okta.AppSamlAttributeStatementsList)

---

##### `certificate`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.certificate" id="cdktfprovideroktaappsamlpropertycertificate"></a>

```typescript
public readonly certificate: string;
```

- *Type:* `string`

---

##### `embedUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.embedUrl" id="cdktfprovideroktaappsamlpropertyembedurl"></a>

```typescript
public readonly embedUrl: string;
```

- *Type:* `string`

---

##### `entityKey`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.entityKey" id="cdktfprovideroktaappsamlpropertyentitykey"></a>

```typescript
public readonly entityKey: string;
```

- *Type:* `string`

---

##### `entityUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.entityUrl" id="cdktfprovideroktaappsamlpropertyentityurl"></a>

```typescript
public readonly entityUrl: string;
```

- *Type:* `string`

---

##### `httpPostBinding`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.httpPostBinding" id="cdktfprovideroktaappsamlpropertyhttppostbinding"></a>

```typescript
public readonly httpPostBinding: string;
```

- *Type:* `string`

---

##### `httpRedirectBinding`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.httpRedirectBinding" id="cdktfprovideroktaappsamlpropertyhttpredirectbinding"></a>

```typescript
public readonly httpRedirectBinding: string;
```

- *Type:* `string`

---

##### `keyId`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.keyId" id="cdktfprovideroktaappsamlpropertykeyid"></a>

```typescript
public readonly keyId: string;
```

- *Type:* `string`

---

##### `keys`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.keys" id="cdktfprovideroktaappsamlpropertykeys"></a>

```typescript
public readonly keys: AppSamlKeysList;
```

- *Type:* [`@cdktf/provider-okta.AppSamlKeysList`](#@cdktf/provider-okta.AppSamlKeysList)

---

##### `logoUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.logoUrl" id="cdktfprovideroktaappsamlpropertylogourl"></a>

```typescript
public readonly logoUrl: string;
```

- *Type:* `string`

---

##### `metadata`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.metadata" id="cdktfprovideroktaappsamlpropertymetadata"></a>

```typescript
public readonly metadata: string;
```

- *Type:* `string`

---

##### `metadataUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.metadataUrl" id="cdktfprovideroktaappsamlpropertymetadataurl"></a>

```typescript
public readonly metadataUrl: string;
```

- *Type:* `string`

---

##### `name`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.name" id="cdktfprovideroktaappsamlpropertyname"></a>

```typescript
public readonly name: string;
```

- *Type:* `string`

---

##### `signOnMode`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.signOnMode" id="cdktfprovideroktaappsamlpropertysignonmode"></a>

```typescript
public readonly signOnMode: string;
```

- *Type:* `string`

---

##### `timeouts`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.timeouts" id="cdktfprovideroktaappsamlpropertytimeouts"></a>

```typescript
public readonly timeouts: AppSamlTimeoutsOutputReference;
```

- *Type:* [`@cdktf/provider-okta.AppSamlTimeoutsOutputReference`](#@cdktf/provider-okta.AppSamlTimeoutsOutputReference)

---

##### `users`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.users" id="cdktfprovideroktaappsamlpropertyusers"></a>

```typescript
public readonly users: AppSamlUsersList;
```

- *Type:* [`@cdktf/provider-okta.AppSamlUsersList`](#@cdktf/provider-okta.AppSamlUsersList)

---

##### `accessibilityErrorRedirectUrlInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSaml.property.accessibilityErrorRedirectUrlInput" id="cdktfprovideroktaappsamlpropertyaccessibilityerrorredirecturlinput"></a>

```typescript
public readonly accessibilityErrorRedirectUrlInput: string;
```

- *Type:* `string`

---

##### `accessibilityLoginRedirectUrlInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSaml.property.accessibilityLoginRedirectUrlInput" id="cdktfprovideroktaappsamlpropertyaccessibilityloginredirecturlinput"></a>

```typescript
public readonly accessibilityLoginRedirectUrlInput: string;
```

- *Type:* `string`

---

##### `accessibilitySelfServiceInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSaml.property.accessibilitySelfServiceInput" id="cdktfprovideroktaappsamlpropertyaccessibilityselfserviceinput"></a>

```typescript
public readonly accessibilitySelfServiceInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `acsEndpointsInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSaml.property.acsEndpointsInput" id="cdktfprovideroktaappsamlpropertyacsendpointsinput"></a>

```typescript
public readonly acsEndpointsInput: string[];
```

- *Type:* `string`[]

---

##### `adminNoteInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSaml.property.adminNoteInput" id="cdktfprovideroktaappsamlpropertyadminnoteinput"></a>

```typescript
public readonly adminNoteInput: string;
```

- *Type:* `string`

---

##### `appLinksJsonInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSaml.property.appLinksJsonInput" id="cdktfprovideroktaappsamlpropertyapplinksjsoninput"></a>

```typescript
public readonly appLinksJsonInput: string;
```

- *Type:* `string`

---

##### `appSettingsJsonInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSaml.property.appSettingsJsonInput" id="cdktfprovideroktaappsamlpropertyappsettingsjsoninput"></a>

```typescript
public readonly appSettingsJsonInput: string;
```

- *Type:* `string`

---

##### `assertionSignedInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSaml.property.assertionSignedInput" id="cdktfprovideroktaappsamlpropertyassertionsignedinput"></a>

```typescript
public readonly assertionSignedInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `attributeStatementsInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSaml.property.attributeStatementsInput" id="cdktfprovideroktaappsamlpropertyattributestatementsinput"></a>

```typescript
public readonly attributeStatementsInput: IResolvable | AppSamlAttributeStatements[];
```

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable) | [`@cdktf/provider-okta.AppSamlAttributeStatements`](#@cdktf/provider-okta.AppSamlAttributeStatements)[]

---

##### `audienceInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSaml.property.audienceInput" id="cdktfprovideroktaappsamlpropertyaudienceinput"></a>

```typescript
public readonly audienceInput: string;
```

- *Type:* `string`

---

##### `authenticationPolicyInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSaml.property.authenticationPolicyInput" id="cdktfprovideroktaappsamlpropertyauthenticationpolicyinput"></a>

```typescript
public readonly authenticationPolicyInput: string;
```

- *Type:* `string`

---

##### `authnContextClassRefInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSaml.property.authnContextClassRefInput" id="cdktfprovideroktaappsamlpropertyauthncontextclassrefinput"></a>

```typescript
public readonly authnContextClassRefInput: string;
```

- *Type:* `string`

---

##### `autoSubmitToolbarInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSaml.property.autoSubmitToolbarInput" id="cdktfprovideroktaappsamlpropertyautosubmittoolbarinput"></a>

```typescript
public readonly autoSubmitToolbarInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `defaultRelayStateInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSaml.property.defaultRelayStateInput" id="cdktfprovideroktaappsamlpropertydefaultrelaystateinput"></a>

```typescript
public readonly defaultRelayStateInput: string;
```

- *Type:* `string`

---

##### `destinationInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSaml.property.destinationInput" id="cdktfprovideroktaappsamlpropertydestinationinput"></a>

```typescript
public readonly destinationInput: string;
```

- *Type:* `string`

---

##### `digestAlgorithmInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSaml.property.digestAlgorithmInput" id="cdktfprovideroktaappsamlpropertydigestalgorithminput"></a>

```typescript
public readonly digestAlgorithmInput: string;
```

- *Type:* `string`

---

##### `enduserNoteInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSaml.property.enduserNoteInput" id="cdktfprovideroktaappsamlpropertyendusernoteinput"></a>

```typescript
public readonly enduserNoteInput: string;
```

- *Type:* `string`

---

##### `featuresInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSaml.property.featuresInput" id="cdktfprovideroktaappsamlpropertyfeaturesinput"></a>

```typescript
public readonly featuresInput: string[];
```

- *Type:* `string`[]

---

##### `groupsInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSaml.property.groupsInput" id="cdktfprovideroktaappsamlpropertygroupsinput"></a>

```typescript
public readonly groupsInput: string[];
```

- *Type:* `string`[]

---

##### `hideIosInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSaml.property.hideIosInput" id="cdktfprovideroktaappsamlpropertyhideiosinput"></a>

```typescript
public readonly hideIosInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `hideWebInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSaml.property.hideWebInput" id="cdktfprovideroktaappsamlpropertyhidewebinput"></a>

```typescript
public readonly hideWebInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `honorForceAuthnInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSaml.property.honorForceAuthnInput" id="cdktfprovideroktaappsamlpropertyhonorforceauthninput"></a>

```typescript
public readonly honorForceAuthnInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSaml.property.idInput" id="cdktfprovideroktaappsamlpropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `idpIssuerInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSaml.property.idpIssuerInput" id="cdktfprovideroktaappsamlpropertyidpissuerinput"></a>

```typescript
public readonly idpIssuerInput: string;
```

- *Type:* `string`

---

##### `implicitAssignmentInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSaml.property.implicitAssignmentInput" id="cdktfprovideroktaappsamlpropertyimplicitassignmentinput"></a>

```typescript
public readonly implicitAssignmentInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `inlineHookIdInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSaml.property.inlineHookIdInput" id="cdktfprovideroktaappsamlpropertyinlinehookidinput"></a>

```typescript
public readonly inlineHookIdInput: string;
```

- *Type:* `string`

---

##### `keyNameInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSaml.property.keyNameInput" id="cdktfprovideroktaappsamlpropertykeynameinput"></a>

```typescript
public readonly keyNameInput: string;
```

- *Type:* `string`

---

##### `keyYearsValidInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSaml.property.keyYearsValidInput" id="cdktfprovideroktaappsamlpropertykeyyearsvalidinput"></a>

```typescript
public readonly keyYearsValidInput: number;
```

- *Type:* `number`

---

##### `labelInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSaml.property.labelInput" id="cdktfprovideroktaappsamlpropertylabelinput"></a>

```typescript
public readonly labelInput: string;
```

- *Type:* `string`

---

##### `logoInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSaml.property.logoInput" id="cdktfprovideroktaappsamlpropertylogoinput"></a>

```typescript
public readonly logoInput: string;
```

- *Type:* `string`

---

##### `preconfiguredAppInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSaml.property.preconfiguredAppInput" id="cdktfprovideroktaappsamlpropertypreconfiguredappinput"></a>

```typescript
public readonly preconfiguredAppInput: string;
```

- *Type:* `string`

---

##### `recipientInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSaml.property.recipientInput" id="cdktfprovideroktaappsamlpropertyrecipientinput"></a>

```typescript
public readonly recipientInput: string;
```

- *Type:* `string`

---

##### `requestCompressedInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSaml.property.requestCompressedInput" id="cdktfprovideroktaappsamlpropertyrequestcompressedinput"></a>

```typescript
public readonly requestCompressedInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `responseSignedInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSaml.property.responseSignedInput" id="cdktfprovideroktaappsamlpropertyresponsesignedinput"></a>

```typescript
public readonly responseSignedInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `samlVersionInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSaml.property.samlVersionInput" id="cdktfprovideroktaappsamlpropertysamlversioninput"></a>

```typescript
public readonly samlVersionInput: string;
```

- *Type:* `string`

---

##### `signatureAlgorithmInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSaml.property.signatureAlgorithmInput" id="cdktfprovideroktaappsamlpropertysignaturealgorithminput"></a>

```typescript
public readonly signatureAlgorithmInput: string;
```

- *Type:* `string`

---

##### `singleLogoutCertificateInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSaml.property.singleLogoutCertificateInput" id="cdktfprovideroktaappsamlpropertysinglelogoutcertificateinput"></a>

```typescript
public readonly singleLogoutCertificateInput: string;
```

- *Type:* `string`

---

##### `singleLogoutIssuerInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSaml.property.singleLogoutIssuerInput" id="cdktfprovideroktaappsamlpropertysinglelogoutissuerinput"></a>

```typescript
public readonly singleLogoutIssuerInput: string;
```

- *Type:* `string`

---

##### `singleLogoutUrlInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSaml.property.singleLogoutUrlInput" id="cdktfprovideroktaappsamlpropertysinglelogouturlinput"></a>

```typescript
public readonly singleLogoutUrlInput: string;
```

- *Type:* `string`

---

##### `skipGroupsInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSaml.property.skipGroupsInput" id="cdktfprovideroktaappsamlpropertyskipgroupsinput"></a>

```typescript
public readonly skipGroupsInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `skipUsersInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSaml.property.skipUsersInput" id="cdktfprovideroktaappsamlpropertyskipusersinput"></a>

```typescript
public readonly skipUsersInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `spIssuerInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSaml.property.spIssuerInput" id="cdktfprovideroktaappsamlpropertyspissuerinput"></a>

```typescript
public readonly spIssuerInput: string;
```

- *Type:* `string`

---

##### `ssoUrlInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSaml.property.ssoUrlInput" id="cdktfprovideroktaappsamlpropertyssourlinput"></a>

```typescript
public readonly ssoUrlInput: string;
```

- *Type:* `string`

---

##### `statusInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSaml.property.statusInput" id="cdktfprovideroktaappsamlpropertystatusinput"></a>

```typescript
public readonly statusInput: string;
```

- *Type:* `string`

---

##### `subjectNameIdFormatInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSaml.property.subjectNameIdFormatInput" id="cdktfprovideroktaappsamlpropertysubjectnameidformatinput"></a>

```typescript
public readonly subjectNameIdFormatInput: string;
```

- *Type:* `string`

---

##### `subjectNameIdTemplateInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSaml.property.subjectNameIdTemplateInput" id="cdktfprovideroktaappsamlpropertysubjectnameidtemplateinput"></a>

```typescript
public readonly subjectNameIdTemplateInput: string;
```

- *Type:* `string`

---

##### `timeoutsInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSaml.property.timeoutsInput" id="cdktfprovideroktaappsamlpropertytimeoutsinput"></a>

```typescript
public readonly timeoutsInput: IResolvable | AppSamlTimeouts;
```

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable) | [`@cdktf/provider-okta.AppSamlTimeouts`](#@cdktf/provider-okta.AppSamlTimeouts)

---

##### `userNameTemplateInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSaml.property.userNameTemplateInput" id="cdktfprovideroktaappsamlpropertyusernametemplateinput"></a>

```typescript
public readonly userNameTemplateInput: string;
```

- *Type:* `string`

---

##### `userNameTemplatePushStatusInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSaml.property.userNameTemplatePushStatusInput" id="cdktfprovideroktaappsamlpropertyusernametemplatepushstatusinput"></a>

```typescript
public readonly userNameTemplatePushStatusInput: string;
```

- *Type:* `string`

---

##### `userNameTemplateSuffixInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSaml.property.userNameTemplateSuffixInput" id="cdktfprovideroktaappsamlpropertyusernametemplatesuffixinput"></a>

```typescript
public readonly userNameTemplateSuffixInput: string;
```

- *Type:* `string`

---

##### `userNameTemplateTypeInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSaml.property.userNameTemplateTypeInput" id="cdktfprovideroktaappsamlpropertyusernametemplatetypeinput"></a>

```typescript
public readonly userNameTemplateTypeInput: string;
```

- *Type:* `string`

---

##### `usersInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSaml.property.usersInput" id="cdktfprovideroktaappsamlpropertyusersinput"></a>

```typescript
public readonly usersInput: IResolvable | AppSamlUsers[];
```

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable) | [`@cdktf/provider-okta.AppSamlUsers`](#@cdktf/provider-okta.AppSamlUsers)[]

---

##### `accessibilityErrorRedirectUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.accessibilityErrorRedirectUrl" id="cdktfprovideroktaappsamlpropertyaccessibilityerrorredirecturl"></a>

```typescript
public readonly accessibilityErrorRedirectUrl: string;
```

- *Type:* `string`

---

##### `accessibilityLoginRedirectUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.accessibilityLoginRedirectUrl" id="cdktfprovideroktaappsamlpropertyaccessibilityloginredirecturl"></a>

```typescript
public readonly accessibilityLoginRedirectUrl: string;
```

- *Type:* `string`

---

##### `accessibilitySelfService`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.accessibilitySelfService" id="cdktfprovideroktaappsamlpropertyaccessibilityselfservice"></a>

```typescript
public readonly accessibilitySelfService: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `acsEndpoints`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.acsEndpoints" id="cdktfprovideroktaappsamlpropertyacsendpoints"></a>

```typescript
public readonly acsEndpoints: string[];
```

- *Type:* `string`[]

---

##### `adminNote`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.adminNote" id="cdktfprovideroktaappsamlpropertyadminnote"></a>

```typescript
public readonly adminNote: string;
```

- *Type:* `string`

---

##### `appLinksJson`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.appLinksJson" id="cdktfprovideroktaappsamlpropertyapplinksjson"></a>

```typescript
public readonly appLinksJson: string;
```

- *Type:* `string`

---

##### `appSettingsJson`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.appSettingsJson" id="cdktfprovideroktaappsamlpropertyappsettingsjson"></a>

```typescript
public readonly appSettingsJson: string;
```

- *Type:* `string`

---

##### `assertionSigned`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.assertionSigned" id="cdktfprovideroktaappsamlpropertyassertionsigned"></a>

```typescript
public readonly assertionSigned: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `audience`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.audience" id="cdktfprovideroktaappsamlpropertyaudience"></a>

```typescript
public readonly audience: string;
```

- *Type:* `string`

---

##### `authenticationPolicy`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.authenticationPolicy" id="cdktfprovideroktaappsamlpropertyauthenticationpolicy"></a>

```typescript
public readonly authenticationPolicy: string;
```

- *Type:* `string`

---

##### `authnContextClassRef`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.authnContextClassRef" id="cdktfprovideroktaappsamlpropertyauthncontextclassref"></a>

```typescript
public readonly authnContextClassRef: string;
```

- *Type:* `string`

---

##### `autoSubmitToolbar`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.autoSubmitToolbar" id="cdktfprovideroktaappsamlpropertyautosubmittoolbar"></a>

```typescript
public readonly autoSubmitToolbar: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `defaultRelayState`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.defaultRelayState" id="cdktfprovideroktaappsamlpropertydefaultrelaystate"></a>

```typescript
public readonly defaultRelayState: string;
```

- *Type:* `string`

---

##### `destination`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.destination" id="cdktfprovideroktaappsamlpropertydestination"></a>

```typescript
public readonly destination: string;
```

- *Type:* `string`

---

##### `digestAlgorithm`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.digestAlgorithm" id="cdktfprovideroktaappsamlpropertydigestalgorithm"></a>

```typescript
public readonly digestAlgorithm: string;
```

- *Type:* `string`

---

##### `enduserNote`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.enduserNote" id="cdktfprovideroktaappsamlpropertyendusernote"></a>

```typescript
public readonly enduserNote: string;
```

- *Type:* `string`

---

##### `features`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.features" id="cdktfprovideroktaappsamlpropertyfeatures"></a>

```typescript
public readonly features: string[];
```

- *Type:* `string`[]

---

##### `groups`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.groups" id="cdktfprovideroktaappsamlpropertygroups"></a>

```typescript
public readonly groups: string[];
```

- *Type:* `string`[]

---

##### `hideIos`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.hideIos" id="cdktfprovideroktaappsamlpropertyhideios"></a>

```typescript
public readonly hideIos: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `hideWeb`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.hideWeb" id="cdktfprovideroktaappsamlpropertyhideweb"></a>

```typescript
public readonly hideWeb: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `honorForceAuthn`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.honorForceAuthn" id="cdktfprovideroktaappsamlpropertyhonorforceauthn"></a>

```typescript
public readonly honorForceAuthn: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.id" id="cdktfprovideroktaappsamlpropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `idpIssuer`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.idpIssuer" id="cdktfprovideroktaappsamlpropertyidpissuer"></a>

```typescript
public readonly idpIssuer: string;
```

- *Type:* `string`

---

##### `implicitAssignment`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.implicitAssignment" id="cdktfprovideroktaappsamlpropertyimplicitassignment"></a>

```typescript
public readonly implicitAssignment: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `inlineHookId`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.inlineHookId" id="cdktfprovideroktaappsamlpropertyinlinehookid"></a>

```typescript
public readonly inlineHookId: string;
```

- *Type:* `string`

---

##### `keyName`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.keyName" id="cdktfprovideroktaappsamlpropertykeyname"></a>

```typescript
public readonly keyName: string;
```

- *Type:* `string`

---

##### `keyYearsValid`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.keyYearsValid" id="cdktfprovideroktaappsamlpropertykeyyearsvalid"></a>

```typescript
public readonly keyYearsValid: number;
```

- *Type:* `number`

---

##### `label`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.label" id="cdktfprovideroktaappsamlpropertylabel"></a>

```typescript
public readonly label: string;
```

- *Type:* `string`

---

##### `logo`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.logo" id="cdktfprovideroktaappsamlpropertylogo"></a>

```typescript
public readonly logo: string;
```

- *Type:* `string`

---

##### `preconfiguredApp`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.preconfiguredApp" id="cdktfprovideroktaappsamlpropertypreconfiguredapp"></a>

```typescript
public readonly preconfiguredApp: string;
```

- *Type:* `string`

---

##### `recipient`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.recipient" id="cdktfprovideroktaappsamlpropertyrecipient"></a>

```typescript
public readonly recipient: string;
```

- *Type:* `string`

---

##### `requestCompressed`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.requestCompressed" id="cdktfprovideroktaappsamlpropertyrequestcompressed"></a>

```typescript
public readonly requestCompressed: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `responseSigned`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.responseSigned" id="cdktfprovideroktaappsamlpropertyresponsesigned"></a>

```typescript
public readonly responseSigned: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `samlVersion`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.samlVersion" id="cdktfprovideroktaappsamlpropertysamlversion"></a>

```typescript
public readonly samlVersion: string;
```

- *Type:* `string`

---

##### `signatureAlgorithm`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.signatureAlgorithm" id="cdktfprovideroktaappsamlpropertysignaturealgorithm"></a>

```typescript
public readonly signatureAlgorithm: string;
```

- *Type:* `string`

---

##### `singleLogoutCertificate`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.singleLogoutCertificate" id="cdktfprovideroktaappsamlpropertysinglelogoutcertificate"></a>

```typescript
public readonly singleLogoutCertificate: string;
```

- *Type:* `string`

---

##### `singleLogoutIssuer`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.singleLogoutIssuer" id="cdktfprovideroktaappsamlpropertysinglelogoutissuer"></a>

```typescript
public readonly singleLogoutIssuer: string;
```

- *Type:* `string`

---

##### `singleLogoutUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.singleLogoutUrl" id="cdktfprovideroktaappsamlpropertysinglelogouturl"></a>

```typescript
public readonly singleLogoutUrl: string;
```

- *Type:* `string`

---

##### `skipGroups`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.skipGroups" id="cdktfprovideroktaappsamlpropertyskipgroups"></a>

```typescript
public readonly skipGroups: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `skipUsers`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.skipUsers" id="cdktfprovideroktaappsamlpropertyskipusers"></a>

```typescript
public readonly skipUsers: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `spIssuer`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.spIssuer" id="cdktfprovideroktaappsamlpropertyspissuer"></a>

```typescript
public readonly spIssuer: string;
```

- *Type:* `string`

---

##### `ssoUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.ssoUrl" id="cdktfprovideroktaappsamlpropertyssourl"></a>

```typescript
public readonly ssoUrl: string;
```

- *Type:* `string`

---

##### `status`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.status" id="cdktfprovideroktaappsamlpropertystatus"></a>

```typescript
public readonly status: string;
```

- *Type:* `string`

---

##### `subjectNameIdFormat`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.subjectNameIdFormat" id="cdktfprovideroktaappsamlpropertysubjectnameidformat"></a>

```typescript
public readonly subjectNameIdFormat: string;
```

- *Type:* `string`

---

##### `subjectNameIdTemplate`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.subjectNameIdTemplate" id="cdktfprovideroktaappsamlpropertysubjectnameidtemplate"></a>

```typescript
public readonly subjectNameIdTemplate: string;
```

- *Type:* `string`

---

##### `userNameTemplate`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.userNameTemplate" id="cdktfprovideroktaappsamlpropertyusernametemplate"></a>

```typescript
public readonly userNameTemplate: string;
```

- *Type:* `string`

---

##### `userNameTemplatePushStatus`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.userNameTemplatePushStatus" id="cdktfprovideroktaappsamlpropertyusernametemplatepushstatus"></a>

```typescript
public readonly userNameTemplatePushStatus: string;
```

- *Type:* `string`

---

##### `userNameTemplateSuffix`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.userNameTemplateSuffix" id="cdktfprovideroktaappsamlpropertyusernametemplatesuffix"></a>

```typescript
public readonly userNameTemplateSuffix: string;
```

- *Type:* `string`

---

##### `userNameTemplateType`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSaml.property.userNameTemplateType" id="cdktfprovideroktaappsamlpropertyusernametemplatetype"></a>

```typescript
public readonly userNameTemplateType: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktaappsamlpropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.AppSaml.property.tfResourceType" id="cdktfprovideroktaappsamlpropertytfresourcetype"></a>

- *Type:* `string`

---

### AppSamlAppSettings <a name="@cdktf/provider-okta.AppSamlAppSettings" id="cdktfprovideroktaappsamlappsettings"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/r/app_saml_app_settings okta_app_saml_app_settings}.

#### Initializers <a name="@cdktf/provider-okta.AppSamlAppSettings.Initializer" id="cdktfprovideroktaappsamlappsettingsinitializer"></a>

```typescript
import { AppSamlAppSettings } from '@cdktf/provider-okta'

new AppSamlAppSettings(scope: Construct, id: string, config: AppSamlAppSettingsConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktaappsamlappsettingsparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktaappsamlappsettingsparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktaappsamlappsettingsparameterconfig)<span title="Required">*</span> | [`@cdktf/provider-okta.AppSamlAppSettingsConfig`](#@cdktf/provider-okta.AppSamlAppSettingsConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSamlAppSettings.parameter.scope" id="cdktfprovideroktaappsamlappsettingsparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSamlAppSettings.parameter.id" id="cdktfprovideroktaappsamlappsettingsparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSamlAppSettings.parameter.config" id="cdktfprovideroktaappsamlappsettingsparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.AppSamlAppSettingsConfig`](#@cdktf/provider-okta.AppSamlAppSettingsConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`resetId`](#cdktfprovideroktaappsamlappsettingsresetid) | *No description.* |

---

##### `resetId` <a name="@cdktf/provider-okta.AppSamlAppSettings.resetId" id="cdktfprovideroktaappsamlappsettingsresetid"></a>

```typescript
public resetId()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`appIdInput`](#cdktfprovideroktaappsamlappsettingspropertyappidinput) | `string` | *No description.* |
| [`idInput`](#cdktfprovideroktaappsamlappsettingspropertyidinput) | `string` | *No description.* |
| [`settingsInput`](#cdktfprovideroktaappsamlappsettingspropertysettingsinput) | `string` | *No description.* |
| [`appId`](#cdktfprovideroktaappsamlappsettingspropertyappid)<span title="Required">*</span> | `string` | *No description.* |
| [`id`](#cdktfprovideroktaappsamlappsettingspropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`settings`](#cdktfprovideroktaappsamlappsettingspropertysettings)<span title="Required">*</span> | `string` | *No description.* |

---

##### `appIdInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSamlAppSettings.property.appIdInput" id="cdktfprovideroktaappsamlappsettingspropertyappidinput"></a>

```typescript
public readonly appIdInput: string;
```

- *Type:* `string`

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSamlAppSettings.property.idInput" id="cdktfprovideroktaappsamlappsettingspropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `settingsInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSamlAppSettings.property.settingsInput" id="cdktfprovideroktaappsamlappsettingspropertysettingsinput"></a>

```typescript
public readonly settingsInput: string;
```

- *Type:* `string`

---

##### `appId`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSamlAppSettings.property.appId" id="cdktfprovideroktaappsamlappsettingspropertyappid"></a>

```typescript
public readonly appId: string;
```

- *Type:* `string`

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSamlAppSettings.property.id" id="cdktfprovideroktaappsamlappsettingspropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `settings`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSamlAppSettings.property.settings" id="cdktfprovideroktaappsamlappsettingspropertysettings"></a>

```typescript
public readonly settings: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktaappsamlappsettingspropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.AppSamlAppSettings.property.tfResourceType" id="cdktfprovideroktaappsamlappsettingspropertytfresourcetype"></a>

- *Type:* `string`

---

### AppSecurePasswordStore <a name="@cdktf/provider-okta.AppSecurePasswordStore" id="cdktfprovideroktaappsecurepasswordstore"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/r/app_secure_password_store okta_app_secure_password_store}.

#### Initializers <a name="@cdktf/provider-okta.AppSecurePasswordStore.Initializer" id="cdktfprovideroktaappsecurepasswordstoreinitializer"></a>

```typescript
import { AppSecurePasswordStore } from '@cdktf/provider-okta'

new AppSecurePasswordStore(scope: Construct, id: string, config: AppSecurePasswordStoreConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktaappsecurepasswordstoreparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktaappsecurepasswordstoreparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktaappsecurepasswordstoreparameterconfig)<span title="Required">*</span> | [`@cdktf/provider-okta.AppSecurePasswordStoreConfig`](#@cdktf/provider-okta.AppSecurePasswordStoreConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.parameter.scope" id="cdktfprovideroktaappsecurepasswordstoreparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.parameter.id" id="cdktfprovideroktaappsecurepasswordstoreparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.parameter.config" id="cdktfprovideroktaappsecurepasswordstoreparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.AppSecurePasswordStoreConfig`](#@cdktf/provider-okta.AppSecurePasswordStoreConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`putTimeouts`](#cdktfprovideroktaappsecurepasswordstoreputtimeouts) | *No description.* |
| [`putUsers`](#cdktfprovideroktaappsecurepasswordstoreputusers) | *No description.* |
| [`resetAccessibilityErrorRedirectUrl`](#cdktfprovideroktaappsecurepasswordstoreresetaccessibilityerrorredirecturl) | *No description.* |
| [`resetAccessibilityLoginRedirectUrl`](#cdktfprovideroktaappsecurepasswordstoreresetaccessibilityloginredirecturl) | *No description.* |
| [`resetAccessibilitySelfService`](#cdktfprovideroktaappsecurepasswordstoreresetaccessibilityselfservice) | *No description.* |
| [`resetAdminNote`](#cdktfprovideroktaappsecurepasswordstoreresetadminnote) | *No description.* |
| [`resetAppLinksJson`](#cdktfprovideroktaappsecurepasswordstoreresetapplinksjson) | *No description.* |
| [`resetAutoSubmitToolbar`](#cdktfprovideroktaappsecurepasswordstoreresetautosubmittoolbar) | *No description.* |
| [`resetCredentialsScheme`](#cdktfprovideroktaappsecurepasswordstoreresetcredentialsscheme) | *No description.* |
| [`resetEnduserNote`](#cdktfprovideroktaappsecurepasswordstoreresetendusernote) | *No description.* |
| [`resetGroups`](#cdktfprovideroktaappsecurepasswordstoreresetgroups) | *No description.* |
| [`resetHideIos`](#cdktfprovideroktaappsecurepasswordstoreresethideios) | *No description.* |
| [`resetHideWeb`](#cdktfprovideroktaappsecurepasswordstoreresethideweb) | *No description.* |
| [`resetId`](#cdktfprovideroktaappsecurepasswordstoreresetid) | *No description.* |
| [`resetLogo`](#cdktfprovideroktaappsecurepasswordstoreresetlogo) | *No description.* |
| [`resetOptionalField1`](#cdktfprovideroktaappsecurepasswordstoreresetoptionalfield1) | *No description.* |
| [`resetOptionalField1Value`](#cdktfprovideroktaappsecurepasswordstoreresetoptionalfield1value) | *No description.* |
| [`resetOptionalField2`](#cdktfprovideroktaappsecurepasswordstoreresetoptionalfield2) | *No description.* |
| [`resetOptionalField2Value`](#cdktfprovideroktaappsecurepasswordstoreresetoptionalfield2value) | *No description.* |
| [`resetOptionalField3`](#cdktfprovideroktaappsecurepasswordstoreresetoptionalfield3) | *No description.* |
| [`resetOptionalField3Value`](#cdktfprovideroktaappsecurepasswordstoreresetoptionalfield3value) | *No description.* |
| [`resetRevealPassword`](#cdktfprovideroktaappsecurepasswordstoreresetrevealpassword) | *No description.* |
| [`resetSharedPassword`](#cdktfprovideroktaappsecurepasswordstoreresetsharedpassword) | *No description.* |
| [`resetSharedUsername`](#cdktfprovideroktaappsecurepasswordstoreresetsharedusername) | *No description.* |
| [`resetSkipGroups`](#cdktfprovideroktaappsecurepasswordstoreresetskipgroups) | *No description.* |
| [`resetSkipUsers`](#cdktfprovideroktaappsecurepasswordstoreresetskipusers) | *No description.* |
| [`resetStatus`](#cdktfprovideroktaappsecurepasswordstoreresetstatus) | *No description.* |
| [`resetTimeouts`](#cdktfprovideroktaappsecurepasswordstoreresettimeouts) | *No description.* |
| [`resetUserNameTemplate`](#cdktfprovideroktaappsecurepasswordstoreresetusernametemplate) | *No description.* |
| [`resetUserNameTemplatePushStatus`](#cdktfprovideroktaappsecurepasswordstoreresetusernametemplatepushstatus) | *No description.* |
| [`resetUserNameTemplateSuffix`](#cdktfprovideroktaappsecurepasswordstoreresetusernametemplatesuffix) | *No description.* |
| [`resetUserNameTemplateType`](#cdktfprovideroktaappsecurepasswordstoreresetusernametemplatetype) | *No description.* |
| [`resetUsers`](#cdktfprovideroktaappsecurepasswordstoreresetusers) | *No description.* |

---

##### `putTimeouts` <a name="@cdktf/provider-okta.AppSecurePasswordStore.putTimeouts" id="cdktfprovideroktaappsecurepasswordstoreputtimeouts"></a>

```typescript
public putTimeouts(value: AppSecurePasswordStoreTimeouts)
```

###### `value`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.parameter.value" id="cdktfprovideroktaappsecurepasswordstoreparametervalue"></a>

- *Type:* [`@cdktf/provider-okta.AppSecurePasswordStoreTimeouts`](#@cdktf/provider-okta.AppSecurePasswordStoreTimeouts)

---

##### `putUsers` <a name="@cdktf/provider-okta.AppSecurePasswordStore.putUsers" id="cdktfprovideroktaappsecurepasswordstoreputusers"></a>

```typescript
public putUsers(value: IResolvable | AppSecurePasswordStoreUsers[])
```

###### `value`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.parameter.value" id="cdktfprovideroktaappsecurepasswordstoreparametervalue"></a>

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable) | [`@cdktf/provider-okta.AppSecurePasswordStoreUsers`](#@cdktf/provider-okta.AppSecurePasswordStoreUsers)[]

---

##### `resetAccessibilityErrorRedirectUrl` <a name="@cdktf/provider-okta.AppSecurePasswordStore.resetAccessibilityErrorRedirectUrl" id="cdktfprovideroktaappsecurepasswordstoreresetaccessibilityerrorredirecturl"></a>

```typescript
public resetAccessibilityErrorRedirectUrl()
```

##### `resetAccessibilityLoginRedirectUrl` <a name="@cdktf/provider-okta.AppSecurePasswordStore.resetAccessibilityLoginRedirectUrl" id="cdktfprovideroktaappsecurepasswordstoreresetaccessibilityloginredirecturl"></a>

```typescript
public resetAccessibilityLoginRedirectUrl()
```

##### `resetAccessibilitySelfService` <a name="@cdktf/provider-okta.AppSecurePasswordStore.resetAccessibilitySelfService" id="cdktfprovideroktaappsecurepasswordstoreresetaccessibilityselfservice"></a>

```typescript
public resetAccessibilitySelfService()
```

##### `resetAdminNote` <a name="@cdktf/provider-okta.AppSecurePasswordStore.resetAdminNote" id="cdktfprovideroktaappsecurepasswordstoreresetadminnote"></a>

```typescript
public resetAdminNote()
```

##### `resetAppLinksJson` <a name="@cdktf/provider-okta.AppSecurePasswordStore.resetAppLinksJson" id="cdktfprovideroktaappsecurepasswordstoreresetapplinksjson"></a>

```typescript
public resetAppLinksJson()
```

##### `resetAutoSubmitToolbar` <a name="@cdktf/provider-okta.AppSecurePasswordStore.resetAutoSubmitToolbar" id="cdktfprovideroktaappsecurepasswordstoreresetautosubmittoolbar"></a>

```typescript
public resetAutoSubmitToolbar()
```

##### `resetCredentialsScheme` <a name="@cdktf/provider-okta.AppSecurePasswordStore.resetCredentialsScheme" id="cdktfprovideroktaappsecurepasswordstoreresetcredentialsscheme"></a>

```typescript
public resetCredentialsScheme()
```

##### `resetEnduserNote` <a name="@cdktf/provider-okta.AppSecurePasswordStore.resetEnduserNote" id="cdktfprovideroktaappsecurepasswordstoreresetendusernote"></a>

```typescript
public resetEnduserNote()
```

##### `resetGroups` <a name="@cdktf/provider-okta.AppSecurePasswordStore.resetGroups" id="cdktfprovideroktaappsecurepasswordstoreresetgroups"></a>

```typescript
public resetGroups()
```

##### `resetHideIos` <a name="@cdktf/provider-okta.AppSecurePasswordStore.resetHideIos" id="cdktfprovideroktaappsecurepasswordstoreresethideios"></a>

```typescript
public resetHideIos()
```

##### `resetHideWeb` <a name="@cdktf/provider-okta.AppSecurePasswordStore.resetHideWeb" id="cdktfprovideroktaappsecurepasswordstoreresethideweb"></a>

```typescript
public resetHideWeb()
```

##### `resetId` <a name="@cdktf/provider-okta.AppSecurePasswordStore.resetId" id="cdktfprovideroktaappsecurepasswordstoreresetid"></a>

```typescript
public resetId()
```

##### `resetLogo` <a name="@cdktf/provider-okta.AppSecurePasswordStore.resetLogo" id="cdktfprovideroktaappsecurepasswordstoreresetlogo"></a>

```typescript
public resetLogo()
```

##### `resetOptionalField1` <a name="@cdktf/provider-okta.AppSecurePasswordStore.resetOptionalField1" id="cdktfprovideroktaappsecurepasswordstoreresetoptionalfield1"></a>

```typescript
public resetOptionalField1()
```

##### `resetOptionalField1Value` <a name="@cdktf/provider-okta.AppSecurePasswordStore.resetOptionalField1Value" id="cdktfprovideroktaappsecurepasswordstoreresetoptionalfield1value"></a>

```typescript
public resetOptionalField1Value()
```

##### `resetOptionalField2` <a name="@cdktf/provider-okta.AppSecurePasswordStore.resetOptionalField2" id="cdktfprovideroktaappsecurepasswordstoreresetoptionalfield2"></a>

```typescript
public resetOptionalField2()
```

##### `resetOptionalField2Value` <a name="@cdktf/provider-okta.AppSecurePasswordStore.resetOptionalField2Value" id="cdktfprovideroktaappsecurepasswordstoreresetoptionalfield2value"></a>

```typescript
public resetOptionalField2Value()
```

##### `resetOptionalField3` <a name="@cdktf/provider-okta.AppSecurePasswordStore.resetOptionalField3" id="cdktfprovideroktaappsecurepasswordstoreresetoptionalfield3"></a>

```typescript
public resetOptionalField3()
```

##### `resetOptionalField3Value` <a name="@cdktf/provider-okta.AppSecurePasswordStore.resetOptionalField3Value" id="cdktfprovideroktaappsecurepasswordstoreresetoptionalfield3value"></a>

```typescript
public resetOptionalField3Value()
```

##### `resetRevealPassword` <a name="@cdktf/provider-okta.AppSecurePasswordStore.resetRevealPassword" id="cdktfprovideroktaappsecurepasswordstoreresetrevealpassword"></a>

```typescript
public resetRevealPassword()
```

##### `resetSharedPassword` <a name="@cdktf/provider-okta.AppSecurePasswordStore.resetSharedPassword" id="cdktfprovideroktaappsecurepasswordstoreresetsharedpassword"></a>

```typescript
public resetSharedPassword()
```

##### `resetSharedUsername` <a name="@cdktf/provider-okta.AppSecurePasswordStore.resetSharedUsername" id="cdktfprovideroktaappsecurepasswordstoreresetsharedusername"></a>

```typescript
public resetSharedUsername()
```

##### `resetSkipGroups` <a name="@cdktf/provider-okta.AppSecurePasswordStore.resetSkipGroups" id="cdktfprovideroktaappsecurepasswordstoreresetskipgroups"></a>

```typescript
public resetSkipGroups()
```

##### `resetSkipUsers` <a name="@cdktf/provider-okta.AppSecurePasswordStore.resetSkipUsers" id="cdktfprovideroktaappsecurepasswordstoreresetskipusers"></a>

```typescript
public resetSkipUsers()
```

##### `resetStatus` <a name="@cdktf/provider-okta.AppSecurePasswordStore.resetStatus" id="cdktfprovideroktaappsecurepasswordstoreresetstatus"></a>

```typescript
public resetStatus()
```

##### `resetTimeouts` <a name="@cdktf/provider-okta.AppSecurePasswordStore.resetTimeouts" id="cdktfprovideroktaappsecurepasswordstoreresettimeouts"></a>

```typescript
public resetTimeouts()
```

##### `resetUserNameTemplate` <a name="@cdktf/provider-okta.AppSecurePasswordStore.resetUserNameTemplate" id="cdktfprovideroktaappsecurepasswordstoreresetusernametemplate"></a>

```typescript
public resetUserNameTemplate()
```

##### `resetUserNameTemplatePushStatus` <a name="@cdktf/provider-okta.AppSecurePasswordStore.resetUserNameTemplatePushStatus" id="cdktfprovideroktaappsecurepasswordstoreresetusernametemplatepushstatus"></a>

```typescript
public resetUserNameTemplatePushStatus()
```

##### `resetUserNameTemplateSuffix` <a name="@cdktf/provider-okta.AppSecurePasswordStore.resetUserNameTemplateSuffix" id="cdktfprovideroktaappsecurepasswordstoreresetusernametemplatesuffix"></a>

```typescript
public resetUserNameTemplateSuffix()
```

##### `resetUserNameTemplateType` <a name="@cdktf/provider-okta.AppSecurePasswordStore.resetUserNameTemplateType" id="cdktfprovideroktaappsecurepasswordstoreresetusernametemplatetype"></a>

```typescript
public resetUserNameTemplateType()
```

##### `resetUsers` <a name="@cdktf/provider-okta.AppSecurePasswordStore.resetUsers" id="cdktfprovideroktaappsecurepasswordstoreresetusers"></a>

```typescript
public resetUsers()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`logoUrl`](#cdktfprovideroktaappsecurepasswordstorepropertylogourl)<span title="Required">*</span> | `string` | *No description.* |
| [`name`](#cdktfprovideroktaappsecurepasswordstorepropertyname)<span title="Required">*</span> | `string` | *No description.* |
| [`signOnMode`](#cdktfprovideroktaappsecurepasswordstorepropertysignonmode)<span title="Required">*</span> | `string` | *No description.* |
| [`timeouts`](#cdktfprovideroktaappsecurepasswordstorepropertytimeouts)<span title="Required">*</span> | [`@cdktf/provider-okta.AppSecurePasswordStoreTimeoutsOutputReference`](#@cdktf/provider-okta.AppSecurePasswordStoreTimeoutsOutputReference) | *No description.* |
| [`users`](#cdktfprovideroktaappsecurepasswordstorepropertyusers)<span title="Required">*</span> | [`@cdktf/provider-okta.AppSecurePasswordStoreUsersList`](#@cdktf/provider-okta.AppSecurePasswordStoreUsersList) | *No description.* |
| [`accessibilityErrorRedirectUrlInput`](#cdktfprovideroktaappsecurepasswordstorepropertyaccessibilityerrorredirecturlinput) | `string` | *No description.* |
| [`accessibilityLoginRedirectUrlInput`](#cdktfprovideroktaappsecurepasswordstorepropertyaccessibilityloginredirecturlinput) | `string` | *No description.* |
| [`accessibilitySelfServiceInput`](#cdktfprovideroktaappsecurepasswordstorepropertyaccessibilityselfserviceinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`adminNoteInput`](#cdktfprovideroktaappsecurepasswordstorepropertyadminnoteinput) | `string` | *No description.* |
| [`appLinksJsonInput`](#cdktfprovideroktaappsecurepasswordstorepropertyapplinksjsoninput) | `string` | *No description.* |
| [`autoSubmitToolbarInput`](#cdktfprovideroktaappsecurepasswordstorepropertyautosubmittoolbarinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`credentialsSchemeInput`](#cdktfprovideroktaappsecurepasswordstorepropertycredentialsschemeinput) | `string` | *No description.* |
| [`enduserNoteInput`](#cdktfprovideroktaappsecurepasswordstorepropertyendusernoteinput) | `string` | *No description.* |
| [`groupsInput`](#cdktfprovideroktaappsecurepasswordstorepropertygroupsinput) | `string`[] | *No description.* |
| [`hideIosInput`](#cdktfprovideroktaappsecurepasswordstorepropertyhideiosinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`hideWebInput`](#cdktfprovideroktaappsecurepasswordstorepropertyhidewebinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`idInput`](#cdktfprovideroktaappsecurepasswordstorepropertyidinput) | `string` | *No description.* |
| [`labelInput`](#cdktfprovideroktaappsecurepasswordstorepropertylabelinput) | `string` | *No description.* |
| [`logoInput`](#cdktfprovideroktaappsecurepasswordstorepropertylogoinput) | `string` | *No description.* |
| [`optionalField1Input`](#cdktfprovideroktaappsecurepasswordstorepropertyoptionalfield1input) | `string` | *No description.* |
| [`optionalField1ValueInput`](#cdktfprovideroktaappsecurepasswordstorepropertyoptionalfield1valueinput) | `string` | *No description.* |
| [`optionalField2Input`](#cdktfprovideroktaappsecurepasswordstorepropertyoptionalfield2input) | `string` | *No description.* |
| [`optionalField2ValueInput`](#cdktfprovideroktaappsecurepasswordstorepropertyoptionalfield2valueinput) | `string` | *No description.* |
| [`optionalField3Input`](#cdktfprovideroktaappsecurepasswordstorepropertyoptionalfield3input) | `string` | *No description.* |
| [`optionalField3ValueInput`](#cdktfprovideroktaappsecurepasswordstorepropertyoptionalfield3valueinput) | `string` | *No description.* |
| [`passwordFieldInput`](#cdktfprovideroktaappsecurepasswordstorepropertypasswordfieldinput) | `string` | *No description.* |
| [`revealPasswordInput`](#cdktfprovideroktaappsecurepasswordstorepropertyrevealpasswordinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`sharedPasswordInput`](#cdktfprovideroktaappsecurepasswordstorepropertysharedpasswordinput) | `string` | *No description.* |
| [`sharedUsernameInput`](#cdktfprovideroktaappsecurepasswordstorepropertysharedusernameinput) | `string` | *No description.* |
| [`skipGroupsInput`](#cdktfprovideroktaappsecurepasswordstorepropertyskipgroupsinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`skipUsersInput`](#cdktfprovideroktaappsecurepasswordstorepropertyskipusersinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`statusInput`](#cdktfprovideroktaappsecurepasswordstorepropertystatusinput) | `string` | *No description.* |
| [`timeoutsInput`](#cdktfprovideroktaappsecurepasswordstorepropertytimeoutsinput) | [`cdktf.IResolvable`](#cdktf.IResolvable) \| [`@cdktf/provider-okta.AppSecurePasswordStoreTimeouts`](#@cdktf/provider-okta.AppSecurePasswordStoreTimeouts) | *No description.* |
| [`urlInput`](#cdktfprovideroktaappsecurepasswordstorepropertyurlinput) | `string` | *No description.* |
| [`usernameFieldInput`](#cdktfprovideroktaappsecurepasswordstorepropertyusernamefieldinput) | `string` | *No description.* |
| [`userNameTemplateInput`](#cdktfprovideroktaappsecurepasswordstorepropertyusernametemplateinput) | `string` | *No description.* |
| [`userNameTemplatePushStatusInput`](#cdktfprovideroktaappsecurepasswordstorepropertyusernametemplatepushstatusinput) | `string` | *No description.* |
| [`userNameTemplateSuffixInput`](#cdktfprovideroktaappsecurepasswordstorepropertyusernametemplatesuffixinput) | `string` | *No description.* |
| [`userNameTemplateTypeInput`](#cdktfprovideroktaappsecurepasswordstorepropertyusernametemplatetypeinput) | `string` | *No description.* |
| [`usersInput`](#cdktfprovideroktaappsecurepasswordstorepropertyusersinput) | [`cdktf.IResolvable`](#cdktf.IResolvable) \| [`@cdktf/provider-okta.AppSecurePasswordStoreUsers`](#@cdktf/provider-okta.AppSecurePasswordStoreUsers)[] | *No description.* |
| [`accessibilityErrorRedirectUrl`](#cdktfprovideroktaappsecurepasswordstorepropertyaccessibilityerrorredirecturl)<span title="Required">*</span> | `string` | *No description.* |
| [`accessibilityLoginRedirectUrl`](#cdktfprovideroktaappsecurepasswordstorepropertyaccessibilityloginredirecturl)<span title="Required">*</span> | `string` | *No description.* |
| [`accessibilitySelfService`](#cdktfprovideroktaappsecurepasswordstorepropertyaccessibilityselfservice)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`adminNote`](#cdktfprovideroktaappsecurepasswordstorepropertyadminnote)<span title="Required">*</span> | `string` | *No description.* |
| [`appLinksJson`](#cdktfprovideroktaappsecurepasswordstorepropertyapplinksjson)<span title="Required">*</span> | `string` | *No description.* |
| [`autoSubmitToolbar`](#cdktfprovideroktaappsecurepasswordstorepropertyautosubmittoolbar)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`credentialsScheme`](#cdktfprovideroktaappsecurepasswordstorepropertycredentialsscheme)<span title="Required">*</span> | `string` | *No description.* |
| [`enduserNote`](#cdktfprovideroktaappsecurepasswordstorepropertyendusernote)<span title="Required">*</span> | `string` | *No description.* |
| [`groups`](#cdktfprovideroktaappsecurepasswordstorepropertygroups)<span title="Required">*</span> | `string`[] | *No description.* |
| [`hideIos`](#cdktfprovideroktaappsecurepasswordstorepropertyhideios)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`hideWeb`](#cdktfprovideroktaappsecurepasswordstorepropertyhideweb)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`id`](#cdktfprovideroktaappsecurepasswordstorepropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`label`](#cdktfprovideroktaappsecurepasswordstorepropertylabel)<span title="Required">*</span> | `string` | *No description.* |
| [`logo`](#cdktfprovideroktaappsecurepasswordstorepropertylogo)<span title="Required">*</span> | `string` | *No description.* |
| [`optionalField1`](#cdktfprovideroktaappsecurepasswordstorepropertyoptionalfield1)<span title="Required">*</span> | `string` | *No description.* |
| [`optionalField1Value`](#cdktfprovideroktaappsecurepasswordstorepropertyoptionalfield1value)<span title="Required">*</span> | `string` | *No description.* |
| [`optionalField2`](#cdktfprovideroktaappsecurepasswordstorepropertyoptionalfield2)<span title="Required">*</span> | `string` | *No description.* |
| [`optionalField2Value`](#cdktfprovideroktaappsecurepasswordstorepropertyoptionalfield2value)<span title="Required">*</span> | `string` | *No description.* |
| [`optionalField3`](#cdktfprovideroktaappsecurepasswordstorepropertyoptionalfield3)<span title="Required">*</span> | `string` | *No description.* |
| [`optionalField3Value`](#cdktfprovideroktaappsecurepasswordstorepropertyoptionalfield3value)<span title="Required">*</span> | `string` | *No description.* |
| [`passwordField`](#cdktfprovideroktaappsecurepasswordstorepropertypasswordfield)<span title="Required">*</span> | `string` | *No description.* |
| [`revealPassword`](#cdktfprovideroktaappsecurepasswordstorepropertyrevealpassword)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`sharedPassword`](#cdktfprovideroktaappsecurepasswordstorepropertysharedpassword)<span title="Required">*</span> | `string` | *No description.* |
| [`sharedUsername`](#cdktfprovideroktaappsecurepasswordstorepropertysharedusername)<span title="Required">*</span> | `string` | *No description.* |
| [`skipGroups`](#cdktfprovideroktaappsecurepasswordstorepropertyskipgroups)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`skipUsers`](#cdktfprovideroktaappsecurepasswordstorepropertyskipusers)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`status`](#cdktfprovideroktaappsecurepasswordstorepropertystatus)<span title="Required">*</span> | `string` | *No description.* |
| [`url`](#cdktfprovideroktaappsecurepasswordstorepropertyurl)<span title="Required">*</span> | `string` | *No description.* |
| [`usernameField`](#cdktfprovideroktaappsecurepasswordstorepropertyusernamefield)<span title="Required">*</span> | `string` | *No description.* |
| [`userNameTemplate`](#cdktfprovideroktaappsecurepasswordstorepropertyusernametemplate)<span title="Required">*</span> | `string` | *No description.* |
| [`userNameTemplatePushStatus`](#cdktfprovideroktaappsecurepasswordstorepropertyusernametemplatepushstatus)<span title="Required">*</span> | `string` | *No description.* |
| [`userNameTemplateSuffix`](#cdktfprovideroktaappsecurepasswordstorepropertyusernametemplatesuffix)<span title="Required">*</span> | `string` | *No description.* |
| [`userNameTemplateType`](#cdktfprovideroktaappsecurepasswordstorepropertyusernametemplatetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `logoUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.logoUrl" id="cdktfprovideroktaappsecurepasswordstorepropertylogourl"></a>

```typescript
public readonly logoUrl: string;
```

- *Type:* `string`

---

##### `name`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.name" id="cdktfprovideroktaappsecurepasswordstorepropertyname"></a>

```typescript
public readonly name: string;
```

- *Type:* `string`

---

##### `signOnMode`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.signOnMode" id="cdktfprovideroktaappsecurepasswordstorepropertysignonmode"></a>

```typescript
public readonly signOnMode: string;
```

- *Type:* `string`

---

##### `timeouts`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.timeouts" id="cdktfprovideroktaappsecurepasswordstorepropertytimeouts"></a>

```typescript
public readonly timeouts: AppSecurePasswordStoreTimeoutsOutputReference;
```

- *Type:* [`@cdktf/provider-okta.AppSecurePasswordStoreTimeoutsOutputReference`](#@cdktf/provider-okta.AppSecurePasswordStoreTimeoutsOutputReference)

---

##### `users`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.users" id="cdktfprovideroktaappsecurepasswordstorepropertyusers"></a>

```typescript
public readonly users: AppSecurePasswordStoreUsersList;
```

- *Type:* [`@cdktf/provider-okta.AppSecurePasswordStoreUsersList`](#@cdktf/provider-okta.AppSecurePasswordStoreUsersList)

---

##### `accessibilityErrorRedirectUrlInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.accessibilityErrorRedirectUrlInput" id="cdktfprovideroktaappsecurepasswordstorepropertyaccessibilityerrorredirecturlinput"></a>

```typescript
public readonly accessibilityErrorRedirectUrlInput: string;
```

- *Type:* `string`

---

##### `accessibilityLoginRedirectUrlInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.accessibilityLoginRedirectUrlInput" id="cdktfprovideroktaappsecurepasswordstorepropertyaccessibilityloginredirecturlinput"></a>

```typescript
public readonly accessibilityLoginRedirectUrlInput: string;
```

- *Type:* `string`

---

##### `accessibilitySelfServiceInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.accessibilitySelfServiceInput" id="cdktfprovideroktaappsecurepasswordstorepropertyaccessibilityselfserviceinput"></a>

```typescript
public readonly accessibilitySelfServiceInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `adminNoteInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.adminNoteInput" id="cdktfprovideroktaappsecurepasswordstorepropertyadminnoteinput"></a>

```typescript
public readonly adminNoteInput: string;
```

- *Type:* `string`

---

##### `appLinksJsonInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.appLinksJsonInput" id="cdktfprovideroktaappsecurepasswordstorepropertyapplinksjsoninput"></a>

```typescript
public readonly appLinksJsonInput: string;
```

- *Type:* `string`

---

##### `autoSubmitToolbarInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.autoSubmitToolbarInput" id="cdktfprovideroktaappsecurepasswordstorepropertyautosubmittoolbarinput"></a>

```typescript
public readonly autoSubmitToolbarInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `credentialsSchemeInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.credentialsSchemeInput" id="cdktfprovideroktaappsecurepasswordstorepropertycredentialsschemeinput"></a>

```typescript
public readonly credentialsSchemeInput: string;
```

- *Type:* `string`

---

##### `enduserNoteInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.enduserNoteInput" id="cdktfprovideroktaappsecurepasswordstorepropertyendusernoteinput"></a>

```typescript
public readonly enduserNoteInput: string;
```

- *Type:* `string`

---

##### `groupsInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.groupsInput" id="cdktfprovideroktaappsecurepasswordstorepropertygroupsinput"></a>

```typescript
public readonly groupsInput: string[];
```

- *Type:* `string`[]

---

##### `hideIosInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.hideIosInput" id="cdktfprovideroktaappsecurepasswordstorepropertyhideiosinput"></a>

```typescript
public readonly hideIosInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `hideWebInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.hideWebInput" id="cdktfprovideroktaappsecurepasswordstorepropertyhidewebinput"></a>

```typescript
public readonly hideWebInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.idInput" id="cdktfprovideroktaappsecurepasswordstorepropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `labelInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.labelInput" id="cdktfprovideroktaappsecurepasswordstorepropertylabelinput"></a>

```typescript
public readonly labelInput: string;
```

- *Type:* `string`

---

##### `logoInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.logoInput" id="cdktfprovideroktaappsecurepasswordstorepropertylogoinput"></a>

```typescript
public readonly logoInput: string;
```

- *Type:* `string`

---

##### `optionalField1Input`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.optionalField1Input" id="cdktfprovideroktaappsecurepasswordstorepropertyoptionalfield1input"></a>

```typescript
public readonly optionalField1Input: string;
```

- *Type:* `string`

---

##### `optionalField1ValueInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.optionalField1ValueInput" id="cdktfprovideroktaappsecurepasswordstorepropertyoptionalfield1valueinput"></a>

```typescript
public readonly optionalField1ValueInput: string;
```

- *Type:* `string`

---

##### `optionalField2Input`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.optionalField2Input" id="cdktfprovideroktaappsecurepasswordstorepropertyoptionalfield2input"></a>

```typescript
public readonly optionalField2Input: string;
```

- *Type:* `string`

---

##### `optionalField2ValueInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.optionalField2ValueInput" id="cdktfprovideroktaappsecurepasswordstorepropertyoptionalfield2valueinput"></a>

```typescript
public readonly optionalField2ValueInput: string;
```

- *Type:* `string`

---

##### `optionalField3Input`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.optionalField3Input" id="cdktfprovideroktaappsecurepasswordstorepropertyoptionalfield3input"></a>

```typescript
public readonly optionalField3Input: string;
```

- *Type:* `string`

---

##### `optionalField3ValueInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.optionalField3ValueInput" id="cdktfprovideroktaappsecurepasswordstorepropertyoptionalfield3valueinput"></a>

```typescript
public readonly optionalField3ValueInput: string;
```

- *Type:* `string`

---

##### `passwordFieldInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.passwordFieldInput" id="cdktfprovideroktaappsecurepasswordstorepropertypasswordfieldinput"></a>

```typescript
public readonly passwordFieldInput: string;
```

- *Type:* `string`

---

##### `revealPasswordInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.revealPasswordInput" id="cdktfprovideroktaappsecurepasswordstorepropertyrevealpasswordinput"></a>

```typescript
public readonly revealPasswordInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `sharedPasswordInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.sharedPasswordInput" id="cdktfprovideroktaappsecurepasswordstorepropertysharedpasswordinput"></a>

```typescript
public readonly sharedPasswordInput: string;
```

- *Type:* `string`

---

##### `sharedUsernameInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.sharedUsernameInput" id="cdktfprovideroktaappsecurepasswordstorepropertysharedusernameinput"></a>

```typescript
public readonly sharedUsernameInput: string;
```

- *Type:* `string`

---

##### `skipGroupsInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.skipGroupsInput" id="cdktfprovideroktaappsecurepasswordstorepropertyskipgroupsinput"></a>

```typescript
public readonly skipGroupsInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `skipUsersInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.skipUsersInput" id="cdktfprovideroktaappsecurepasswordstorepropertyskipusersinput"></a>

```typescript
public readonly skipUsersInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `statusInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.statusInput" id="cdktfprovideroktaappsecurepasswordstorepropertystatusinput"></a>

```typescript
public readonly statusInput: string;
```

- *Type:* `string`

---

##### `timeoutsInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.timeoutsInput" id="cdktfprovideroktaappsecurepasswordstorepropertytimeoutsinput"></a>

```typescript
public readonly timeoutsInput: IResolvable | AppSecurePasswordStoreTimeouts;
```

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable) | [`@cdktf/provider-okta.AppSecurePasswordStoreTimeouts`](#@cdktf/provider-okta.AppSecurePasswordStoreTimeouts)

---

##### `urlInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.urlInput" id="cdktfprovideroktaappsecurepasswordstorepropertyurlinput"></a>

```typescript
public readonly urlInput: string;
```

- *Type:* `string`

---

##### `usernameFieldInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.usernameFieldInput" id="cdktfprovideroktaappsecurepasswordstorepropertyusernamefieldinput"></a>

```typescript
public readonly usernameFieldInput: string;
```

- *Type:* `string`

---

##### `userNameTemplateInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.userNameTemplateInput" id="cdktfprovideroktaappsecurepasswordstorepropertyusernametemplateinput"></a>

```typescript
public readonly userNameTemplateInput: string;
```

- *Type:* `string`

---

##### `userNameTemplatePushStatusInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.userNameTemplatePushStatusInput" id="cdktfprovideroktaappsecurepasswordstorepropertyusernametemplatepushstatusinput"></a>

```typescript
public readonly userNameTemplatePushStatusInput: string;
```

- *Type:* `string`

---

##### `userNameTemplateSuffixInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.userNameTemplateSuffixInput" id="cdktfprovideroktaappsecurepasswordstorepropertyusernametemplatesuffixinput"></a>

```typescript
public readonly userNameTemplateSuffixInput: string;
```

- *Type:* `string`

---

##### `userNameTemplateTypeInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.userNameTemplateTypeInput" id="cdktfprovideroktaappsecurepasswordstorepropertyusernametemplatetypeinput"></a>

```typescript
public readonly userNameTemplateTypeInput: string;
```

- *Type:* `string`

---

##### `usersInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.usersInput" id="cdktfprovideroktaappsecurepasswordstorepropertyusersinput"></a>

```typescript
public readonly usersInput: IResolvable | AppSecurePasswordStoreUsers[];
```

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable) | [`@cdktf/provider-okta.AppSecurePasswordStoreUsers`](#@cdktf/provider-okta.AppSecurePasswordStoreUsers)[]

---

##### `accessibilityErrorRedirectUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.accessibilityErrorRedirectUrl" id="cdktfprovideroktaappsecurepasswordstorepropertyaccessibilityerrorredirecturl"></a>

```typescript
public readonly accessibilityErrorRedirectUrl: string;
```

- *Type:* `string`

---

##### `accessibilityLoginRedirectUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.accessibilityLoginRedirectUrl" id="cdktfprovideroktaappsecurepasswordstorepropertyaccessibilityloginredirecturl"></a>

```typescript
public readonly accessibilityLoginRedirectUrl: string;
```

- *Type:* `string`

---

##### `accessibilitySelfService`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.accessibilitySelfService" id="cdktfprovideroktaappsecurepasswordstorepropertyaccessibilityselfservice"></a>

```typescript
public readonly accessibilitySelfService: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `adminNote`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.adminNote" id="cdktfprovideroktaappsecurepasswordstorepropertyadminnote"></a>

```typescript
public readonly adminNote: string;
```

- *Type:* `string`

---

##### `appLinksJson`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.appLinksJson" id="cdktfprovideroktaappsecurepasswordstorepropertyapplinksjson"></a>

```typescript
public readonly appLinksJson: string;
```

- *Type:* `string`

---

##### `autoSubmitToolbar`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.autoSubmitToolbar" id="cdktfprovideroktaappsecurepasswordstorepropertyautosubmittoolbar"></a>

```typescript
public readonly autoSubmitToolbar: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `credentialsScheme`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.credentialsScheme" id="cdktfprovideroktaappsecurepasswordstorepropertycredentialsscheme"></a>

```typescript
public readonly credentialsScheme: string;
```

- *Type:* `string`

---

##### `enduserNote`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.enduserNote" id="cdktfprovideroktaappsecurepasswordstorepropertyendusernote"></a>

```typescript
public readonly enduserNote: string;
```

- *Type:* `string`

---

##### `groups`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.groups" id="cdktfprovideroktaappsecurepasswordstorepropertygroups"></a>

```typescript
public readonly groups: string[];
```

- *Type:* `string`[]

---

##### `hideIos`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.hideIos" id="cdktfprovideroktaappsecurepasswordstorepropertyhideios"></a>

```typescript
public readonly hideIos: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `hideWeb`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.hideWeb" id="cdktfprovideroktaappsecurepasswordstorepropertyhideweb"></a>

```typescript
public readonly hideWeb: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.id" id="cdktfprovideroktaappsecurepasswordstorepropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `label`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.label" id="cdktfprovideroktaappsecurepasswordstorepropertylabel"></a>

```typescript
public readonly label: string;
```

- *Type:* `string`

---

##### `logo`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.logo" id="cdktfprovideroktaappsecurepasswordstorepropertylogo"></a>

```typescript
public readonly logo: string;
```

- *Type:* `string`

---

##### `optionalField1`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.optionalField1" id="cdktfprovideroktaappsecurepasswordstorepropertyoptionalfield1"></a>

```typescript
public readonly optionalField1: string;
```

- *Type:* `string`

---

##### `optionalField1Value`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.optionalField1Value" id="cdktfprovideroktaappsecurepasswordstorepropertyoptionalfield1value"></a>

```typescript
public readonly optionalField1Value: string;
```

- *Type:* `string`

---

##### `optionalField2`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.optionalField2" id="cdktfprovideroktaappsecurepasswordstorepropertyoptionalfield2"></a>

```typescript
public readonly optionalField2: string;
```

- *Type:* `string`

---

##### `optionalField2Value`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.optionalField2Value" id="cdktfprovideroktaappsecurepasswordstorepropertyoptionalfield2value"></a>

```typescript
public readonly optionalField2Value: string;
```

- *Type:* `string`

---

##### `optionalField3`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.optionalField3" id="cdktfprovideroktaappsecurepasswordstorepropertyoptionalfield3"></a>

```typescript
public readonly optionalField3: string;
```

- *Type:* `string`

---

##### `optionalField3Value`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.optionalField3Value" id="cdktfprovideroktaappsecurepasswordstorepropertyoptionalfield3value"></a>

```typescript
public readonly optionalField3Value: string;
```

- *Type:* `string`

---

##### `passwordField`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.passwordField" id="cdktfprovideroktaappsecurepasswordstorepropertypasswordfield"></a>

```typescript
public readonly passwordField: string;
```

- *Type:* `string`

---

##### `revealPassword`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.revealPassword" id="cdktfprovideroktaappsecurepasswordstorepropertyrevealpassword"></a>

```typescript
public readonly revealPassword: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `sharedPassword`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.sharedPassword" id="cdktfprovideroktaappsecurepasswordstorepropertysharedpassword"></a>

```typescript
public readonly sharedPassword: string;
```

- *Type:* `string`

---

##### `sharedUsername`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.sharedUsername" id="cdktfprovideroktaappsecurepasswordstorepropertysharedusername"></a>

```typescript
public readonly sharedUsername: string;
```

- *Type:* `string`

---

##### `skipGroups`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.skipGroups" id="cdktfprovideroktaappsecurepasswordstorepropertyskipgroups"></a>

```typescript
public readonly skipGroups: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `skipUsers`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.skipUsers" id="cdktfprovideroktaappsecurepasswordstorepropertyskipusers"></a>

```typescript
public readonly skipUsers: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `status`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.status" id="cdktfprovideroktaappsecurepasswordstorepropertystatus"></a>

```typescript
public readonly status: string;
```

- *Type:* `string`

---

##### `url`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.url" id="cdktfprovideroktaappsecurepasswordstorepropertyurl"></a>

```typescript
public readonly url: string;
```

- *Type:* `string`

---

##### `usernameField`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.usernameField" id="cdktfprovideroktaappsecurepasswordstorepropertyusernamefield"></a>

```typescript
public readonly usernameField: string;
```

- *Type:* `string`

---

##### `userNameTemplate`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.userNameTemplate" id="cdktfprovideroktaappsecurepasswordstorepropertyusernametemplate"></a>

```typescript
public readonly userNameTemplate: string;
```

- *Type:* `string`

---

##### `userNameTemplatePushStatus`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.userNameTemplatePushStatus" id="cdktfprovideroktaappsecurepasswordstorepropertyusernametemplatepushstatus"></a>

```typescript
public readonly userNameTemplatePushStatus: string;
```

- *Type:* `string`

---

##### `userNameTemplateSuffix`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.userNameTemplateSuffix" id="cdktfprovideroktaappsecurepasswordstorepropertyusernametemplatesuffix"></a>

```typescript
public readonly userNameTemplateSuffix: string;
```

- *Type:* `string`

---

##### `userNameTemplateType`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.userNameTemplateType" id="cdktfprovideroktaappsecurepasswordstorepropertyusernametemplatetype"></a>

```typescript
public readonly userNameTemplateType: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktaappsecurepasswordstorepropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.AppSecurePasswordStore.property.tfResourceType" id="cdktfprovideroktaappsecurepasswordstorepropertytfresourcetype"></a>

- *Type:* `string`

---

### AppSharedCredentials <a name="@cdktf/provider-okta.AppSharedCredentials" id="cdktfprovideroktaappsharedcredentials"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials okta_app_shared_credentials}.

#### Initializers <a name="@cdktf/provider-okta.AppSharedCredentials.Initializer" id="cdktfprovideroktaappsharedcredentialsinitializer"></a>

```typescript
import { AppSharedCredentials } from '@cdktf/provider-okta'

new AppSharedCredentials(scope: Construct, id: string, config: AppSharedCredentialsConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktaappsharedcredentialsparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktaappsharedcredentialsparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktaappsharedcredentialsparameterconfig)<span title="Required">*</span> | [`@cdktf/provider-okta.AppSharedCredentialsConfig`](#@cdktf/provider-okta.AppSharedCredentialsConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.parameter.scope" id="cdktfprovideroktaappsharedcredentialsparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.parameter.id" id="cdktfprovideroktaappsharedcredentialsparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.parameter.config" id="cdktfprovideroktaappsharedcredentialsparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.AppSharedCredentialsConfig`](#@cdktf/provider-okta.AppSharedCredentialsConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`putTimeouts`](#cdktfprovideroktaappsharedcredentialsputtimeouts) | *No description.* |
| [`putUsers`](#cdktfprovideroktaappsharedcredentialsputusers) | *No description.* |
| [`resetAccessibilityErrorRedirectUrl`](#cdktfprovideroktaappsharedcredentialsresetaccessibilityerrorredirecturl) | *No description.* |
| [`resetAccessibilityLoginRedirectUrl`](#cdktfprovideroktaappsharedcredentialsresetaccessibilityloginredirecturl) | *No description.* |
| [`resetAccessibilitySelfService`](#cdktfprovideroktaappsharedcredentialsresetaccessibilityselfservice) | *No description.* |
| [`resetAdminNote`](#cdktfprovideroktaappsharedcredentialsresetadminnote) | *No description.* |
| [`resetAppLinksJson`](#cdktfprovideroktaappsharedcredentialsresetapplinksjson) | *No description.* |
| [`resetAutoSubmitToolbar`](#cdktfprovideroktaappsharedcredentialsresetautosubmittoolbar) | *No description.* |
| [`resetButtonField`](#cdktfprovideroktaappsharedcredentialsresetbuttonfield) | *No description.* |
| [`resetCheckbox`](#cdktfprovideroktaappsharedcredentialsresetcheckbox) | *No description.* |
| [`resetEnduserNote`](#cdktfprovideroktaappsharedcredentialsresetendusernote) | *No description.* |
| [`resetGroups`](#cdktfprovideroktaappsharedcredentialsresetgroups) | *No description.* |
| [`resetHideIos`](#cdktfprovideroktaappsharedcredentialsresethideios) | *No description.* |
| [`resetHideWeb`](#cdktfprovideroktaappsharedcredentialsresethideweb) | *No description.* |
| [`resetId`](#cdktfprovideroktaappsharedcredentialsresetid) | *No description.* |
| [`resetLogo`](#cdktfprovideroktaappsharedcredentialsresetlogo) | *No description.* |
| [`resetPasswordField`](#cdktfprovideroktaappsharedcredentialsresetpasswordfield) | *No description.* |
| [`resetPreconfiguredApp`](#cdktfprovideroktaappsharedcredentialsresetpreconfiguredapp) | *No description.* |
| [`resetRedirectUrl`](#cdktfprovideroktaappsharedcredentialsresetredirecturl) | *No description.* |
| [`resetSharedPassword`](#cdktfprovideroktaappsharedcredentialsresetsharedpassword) | *No description.* |
| [`resetSharedUsername`](#cdktfprovideroktaappsharedcredentialsresetsharedusername) | *No description.* |
| [`resetSkipGroups`](#cdktfprovideroktaappsharedcredentialsresetskipgroups) | *No description.* |
| [`resetSkipUsers`](#cdktfprovideroktaappsharedcredentialsresetskipusers) | *No description.* |
| [`resetStatus`](#cdktfprovideroktaappsharedcredentialsresetstatus) | *No description.* |
| [`resetTimeouts`](#cdktfprovideroktaappsharedcredentialsresettimeouts) | *No description.* |
| [`resetUrl`](#cdktfprovideroktaappsharedcredentialsreseturl) | *No description.* |
| [`resetUrlRegex`](#cdktfprovideroktaappsharedcredentialsreseturlregex) | *No description.* |
| [`resetUsernameField`](#cdktfprovideroktaappsharedcredentialsresetusernamefield) | *No description.* |
| [`resetUserNameTemplate`](#cdktfprovideroktaappsharedcredentialsresetusernametemplate) | *No description.* |
| [`resetUserNameTemplatePushStatus`](#cdktfprovideroktaappsharedcredentialsresetusernametemplatepushstatus) | *No description.* |
| [`resetUserNameTemplateSuffix`](#cdktfprovideroktaappsharedcredentialsresetusernametemplatesuffix) | *No description.* |
| [`resetUserNameTemplateType`](#cdktfprovideroktaappsharedcredentialsresetusernametemplatetype) | *No description.* |
| [`resetUsers`](#cdktfprovideroktaappsharedcredentialsresetusers) | *No description.* |

---

##### `putTimeouts` <a name="@cdktf/provider-okta.AppSharedCredentials.putTimeouts" id="cdktfprovideroktaappsharedcredentialsputtimeouts"></a>

```typescript
public putTimeouts(value: AppSharedCredentialsTimeouts)
```

###### `value`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.parameter.value" id="cdktfprovideroktaappsharedcredentialsparametervalue"></a>

- *Type:* [`@cdktf/provider-okta.AppSharedCredentialsTimeouts`](#@cdktf/provider-okta.AppSharedCredentialsTimeouts)

---

##### `putUsers` <a name="@cdktf/provider-okta.AppSharedCredentials.putUsers" id="cdktfprovideroktaappsharedcredentialsputusers"></a>

```typescript
public putUsers(value: IResolvable | AppSharedCredentialsUsers[])
```

###### `value`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.parameter.value" id="cdktfprovideroktaappsharedcredentialsparametervalue"></a>

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable) | [`@cdktf/provider-okta.AppSharedCredentialsUsers`](#@cdktf/provider-okta.AppSharedCredentialsUsers)[]

---

##### `resetAccessibilityErrorRedirectUrl` <a name="@cdktf/provider-okta.AppSharedCredentials.resetAccessibilityErrorRedirectUrl" id="cdktfprovideroktaappsharedcredentialsresetaccessibilityerrorredirecturl"></a>

```typescript
public resetAccessibilityErrorRedirectUrl()
```

##### `resetAccessibilityLoginRedirectUrl` <a name="@cdktf/provider-okta.AppSharedCredentials.resetAccessibilityLoginRedirectUrl" id="cdktfprovideroktaappsharedcredentialsresetaccessibilityloginredirecturl"></a>

```typescript
public resetAccessibilityLoginRedirectUrl()
```

##### `resetAccessibilitySelfService` <a name="@cdktf/provider-okta.AppSharedCredentials.resetAccessibilitySelfService" id="cdktfprovideroktaappsharedcredentialsresetaccessibilityselfservice"></a>

```typescript
public resetAccessibilitySelfService()
```

##### `resetAdminNote` <a name="@cdktf/provider-okta.AppSharedCredentials.resetAdminNote" id="cdktfprovideroktaappsharedcredentialsresetadminnote"></a>

```typescript
public resetAdminNote()
```

##### `resetAppLinksJson` <a name="@cdktf/provider-okta.AppSharedCredentials.resetAppLinksJson" id="cdktfprovideroktaappsharedcredentialsresetapplinksjson"></a>

```typescript
public resetAppLinksJson()
```

##### `resetAutoSubmitToolbar` <a name="@cdktf/provider-okta.AppSharedCredentials.resetAutoSubmitToolbar" id="cdktfprovideroktaappsharedcredentialsresetautosubmittoolbar"></a>

```typescript
public resetAutoSubmitToolbar()
```

##### `resetButtonField` <a name="@cdktf/provider-okta.AppSharedCredentials.resetButtonField" id="cdktfprovideroktaappsharedcredentialsresetbuttonfield"></a>

```typescript
public resetButtonField()
```

##### `resetCheckbox` <a name="@cdktf/provider-okta.AppSharedCredentials.resetCheckbox" id="cdktfprovideroktaappsharedcredentialsresetcheckbox"></a>

```typescript
public resetCheckbox()
```

##### `resetEnduserNote` <a name="@cdktf/provider-okta.AppSharedCredentials.resetEnduserNote" id="cdktfprovideroktaappsharedcredentialsresetendusernote"></a>

```typescript
public resetEnduserNote()
```

##### `resetGroups` <a name="@cdktf/provider-okta.AppSharedCredentials.resetGroups" id="cdktfprovideroktaappsharedcredentialsresetgroups"></a>

```typescript
public resetGroups()
```

##### `resetHideIos` <a name="@cdktf/provider-okta.AppSharedCredentials.resetHideIos" id="cdktfprovideroktaappsharedcredentialsresethideios"></a>

```typescript
public resetHideIos()
```

##### `resetHideWeb` <a name="@cdktf/provider-okta.AppSharedCredentials.resetHideWeb" id="cdktfprovideroktaappsharedcredentialsresethideweb"></a>

```typescript
public resetHideWeb()
```

##### `resetId` <a name="@cdktf/provider-okta.AppSharedCredentials.resetId" id="cdktfprovideroktaappsharedcredentialsresetid"></a>

```typescript
public resetId()
```

##### `resetLogo` <a name="@cdktf/provider-okta.AppSharedCredentials.resetLogo" id="cdktfprovideroktaappsharedcredentialsresetlogo"></a>

```typescript
public resetLogo()
```

##### `resetPasswordField` <a name="@cdktf/provider-okta.AppSharedCredentials.resetPasswordField" id="cdktfprovideroktaappsharedcredentialsresetpasswordfield"></a>

```typescript
public resetPasswordField()
```

##### `resetPreconfiguredApp` <a name="@cdktf/provider-okta.AppSharedCredentials.resetPreconfiguredApp" id="cdktfprovideroktaappsharedcredentialsresetpreconfiguredapp"></a>

```typescript
public resetPreconfiguredApp()
```

##### `resetRedirectUrl` <a name="@cdktf/provider-okta.AppSharedCredentials.resetRedirectUrl" id="cdktfprovideroktaappsharedcredentialsresetredirecturl"></a>

```typescript
public resetRedirectUrl()
```

##### `resetSharedPassword` <a name="@cdktf/provider-okta.AppSharedCredentials.resetSharedPassword" id="cdktfprovideroktaappsharedcredentialsresetsharedpassword"></a>

```typescript
public resetSharedPassword()
```

##### `resetSharedUsername` <a name="@cdktf/provider-okta.AppSharedCredentials.resetSharedUsername" id="cdktfprovideroktaappsharedcredentialsresetsharedusername"></a>

```typescript
public resetSharedUsername()
```

##### `resetSkipGroups` <a name="@cdktf/provider-okta.AppSharedCredentials.resetSkipGroups" id="cdktfprovideroktaappsharedcredentialsresetskipgroups"></a>

```typescript
public resetSkipGroups()
```

##### `resetSkipUsers` <a name="@cdktf/provider-okta.AppSharedCredentials.resetSkipUsers" id="cdktfprovideroktaappsharedcredentialsresetskipusers"></a>

```typescript
public resetSkipUsers()
```

##### `resetStatus` <a name="@cdktf/provider-okta.AppSharedCredentials.resetStatus" id="cdktfprovideroktaappsharedcredentialsresetstatus"></a>

```typescript
public resetStatus()
```

##### `resetTimeouts` <a name="@cdktf/provider-okta.AppSharedCredentials.resetTimeouts" id="cdktfprovideroktaappsharedcredentialsresettimeouts"></a>

```typescript
public resetTimeouts()
```

##### `resetUrl` <a name="@cdktf/provider-okta.AppSharedCredentials.resetUrl" id="cdktfprovideroktaappsharedcredentialsreseturl"></a>

```typescript
public resetUrl()
```

##### `resetUrlRegex` <a name="@cdktf/provider-okta.AppSharedCredentials.resetUrlRegex" id="cdktfprovideroktaappsharedcredentialsreseturlregex"></a>

```typescript
public resetUrlRegex()
```

##### `resetUsernameField` <a name="@cdktf/provider-okta.AppSharedCredentials.resetUsernameField" id="cdktfprovideroktaappsharedcredentialsresetusernamefield"></a>

```typescript
public resetUsernameField()
```

##### `resetUserNameTemplate` <a name="@cdktf/provider-okta.AppSharedCredentials.resetUserNameTemplate" id="cdktfprovideroktaappsharedcredentialsresetusernametemplate"></a>

```typescript
public resetUserNameTemplate()
```

##### `resetUserNameTemplatePushStatus` <a name="@cdktf/provider-okta.AppSharedCredentials.resetUserNameTemplatePushStatus" id="cdktfprovideroktaappsharedcredentialsresetusernametemplatepushstatus"></a>

```typescript
public resetUserNameTemplatePushStatus()
```

##### `resetUserNameTemplateSuffix` <a name="@cdktf/provider-okta.AppSharedCredentials.resetUserNameTemplateSuffix" id="cdktfprovideroktaappsharedcredentialsresetusernametemplatesuffix"></a>

```typescript
public resetUserNameTemplateSuffix()
```

##### `resetUserNameTemplateType` <a name="@cdktf/provider-okta.AppSharedCredentials.resetUserNameTemplateType" id="cdktfprovideroktaappsharedcredentialsresetusernametemplatetype"></a>

```typescript
public resetUserNameTemplateType()
```

##### `resetUsers` <a name="@cdktf/provider-okta.AppSharedCredentials.resetUsers" id="cdktfprovideroktaappsharedcredentialsresetusers"></a>

```typescript
public resetUsers()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`logoUrl`](#cdktfprovideroktaappsharedcredentialspropertylogourl)<span title="Required">*</span> | `string` | *No description.* |
| [`name`](#cdktfprovideroktaappsharedcredentialspropertyname)<span title="Required">*</span> | `string` | *No description.* |
| [`signOnMode`](#cdktfprovideroktaappsharedcredentialspropertysignonmode)<span title="Required">*</span> | `string` | *No description.* |
| [`timeouts`](#cdktfprovideroktaappsharedcredentialspropertytimeouts)<span title="Required">*</span> | [`@cdktf/provider-okta.AppSharedCredentialsTimeoutsOutputReference`](#@cdktf/provider-okta.AppSharedCredentialsTimeoutsOutputReference) | *No description.* |
| [`users`](#cdktfprovideroktaappsharedcredentialspropertyusers)<span title="Required">*</span> | [`@cdktf/provider-okta.AppSharedCredentialsUsersList`](#@cdktf/provider-okta.AppSharedCredentialsUsersList) | *No description.* |
| [`accessibilityErrorRedirectUrlInput`](#cdktfprovideroktaappsharedcredentialspropertyaccessibilityerrorredirecturlinput) | `string` | *No description.* |
| [`accessibilityLoginRedirectUrlInput`](#cdktfprovideroktaappsharedcredentialspropertyaccessibilityloginredirecturlinput) | `string` | *No description.* |
| [`accessibilitySelfServiceInput`](#cdktfprovideroktaappsharedcredentialspropertyaccessibilityselfserviceinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`adminNoteInput`](#cdktfprovideroktaappsharedcredentialspropertyadminnoteinput) | `string` | *No description.* |
| [`appLinksJsonInput`](#cdktfprovideroktaappsharedcredentialspropertyapplinksjsoninput) | `string` | *No description.* |
| [`autoSubmitToolbarInput`](#cdktfprovideroktaappsharedcredentialspropertyautosubmittoolbarinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`buttonFieldInput`](#cdktfprovideroktaappsharedcredentialspropertybuttonfieldinput) | `string` | *No description.* |
| [`checkboxInput`](#cdktfprovideroktaappsharedcredentialspropertycheckboxinput) | `string` | *No description.* |
| [`enduserNoteInput`](#cdktfprovideroktaappsharedcredentialspropertyendusernoteinput) | `string` | *No description.* |
| [`groupsInput`](#cdktfprovideroktaappsharedcredentialspropertygroupsinput) | `string`[] | *No description.* |
| [`hideIosInput`](#cdktfprovideroktaappsharedcredentialspropertyhideiosinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`hideWebInput`](#cdktfprovideroktaappsharedcredentialspropertyhidewebinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`idInput`](#cdktfprovideroktaappsharedcredentialspropertyidinput) | `string` | *No description.* |
| [`labelInput`](#cdktfprovideroktaappsharedcredentialspropertylabelinput) | `string` | *No description.* |
| [`logoInput`](#cdktfprovideroktaappsharedcredentialspropertylogoinput) | `string` | *No description.* |
| [`passwordFieldInput`](#cdktfprovideroktaappsharedcredentialspropertypasswordfieldinput) | `string` | *No description.* |
| [`preconfiguredAppInput`](#cdktfprovideroktaappsharedcredentialspropertypreconfiguredappinput) | `string` | *No description.* |
| [`redirectUrlInput`](#cdktfprovideroktaappsharedcredentialspropertyredirecturlinput) | `string` | *No description.* |
| [`sharedPasswordInput`](#cdktfprovideroktaappsharedcredentialspropertysharedpasswordinput) | `string` | *No description.* |
| [`sharedUsernameInput`](#cdktfprovideroktaappsharedcredentialspropertysharedusernameinput) | `string` | *No description.* |
| [`skipGroupsInput`](#cdktfprovideroktaappsharedcredentialspropertyskipgroupsinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`skipUsersInput`](#cdktfprovideroktaappsharedcredentialspropertyskipusersinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`statusInput`](#cdktfprovideroktaappsharedcredentialspropertystatusinput) | `string` | *No description.* |
| [`timeoutsInput`](#cdktfprovideroktaappsharedcredentialspropertytimeoutsinput) | [`cdktf.IResolvable`](#cdktf.IResolvable) \| [`@cdktf/provider-okta.AppSharedCredentialsTimeouts`](#@cdktf/provider-okta.AppSharedCredentialsTimeouts) | *No description.* |
| [`urlInput`](#cdktfprovideroktaappsharedcredentialspropertyurlinput) | `string` | *No description.* |
| [`urlRegexInput`](#cdktfprovideroktaappsharedcredentialspropertyurlregexinput) | `string` | *No description.* |
| [`usernameFieldInput`](#cdktfprovideroktaappsharedcredentialspropertyusernamefieldinput) | `string` | *No description.* |
| [`userNameTemplateInput`](#cdktfprovideroktaappsharedcredentialspropertyusernametemplateinput) | `string` | *No description.* |
| [`userNameTemplatePushStatusInput`](#cdktfprovideroktaappsharedcredentialspropertyusernametemplatepushstatusinput) | `string` | *No description.* |
| [`userNameTemplateSuffixInput`](#cdktfprovideroktaappsharedcredentialspropertyusernametemplatesuffixinput) | `string` | *No description.* |
| [`userNameTemplateTypeInput`](#cdktfprovideroktaappsharedcredentialspropertyusernametemplatetypeinput) | `string` | *No description.* |
| [`usersInput`](#cdktfprovideroktaappsharedcredentialspropertyusersinput) | [`cdktf.IResolvable`](#cdktf.IResolvable) \| [`@cdktf/provider-okta.AppSharedCredentialsUsers`](#@cdktf/provider-okta.AppSharedCredentialsUsers)[] | *No description.* |
| [`accessibilityErrorRedirectUrl`](#cdktfprovideroktaappsharedcredentialspropertyaccessibilityerrorredirecturl)<span title="Required">*</span> | `string` | *No description.* |
| [`accessibilityLoginRedirectUrl`](#cdktfprovideroktaappsharedcredentialspropertyaccessibilityloginredirecturl)<span title="Required">*</span> | `string` | *No description.* |
| [`accessibilitySelfService`](#cdktfprovideroktaappsharedcredentialspropertyaccessibilityselfservice)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`adminNote`](#cdktfprovideroktaappsharedcredentialspropertyadminnote)<span title="Required">*</span> | `string` | *No description.* |
| [`appLinksJson`](#cdktfprovideroktaappsharedcredentialspropertyapplinksjson)<span title="Required">*</span> | `string` | *No description.* |
| [`autoSubmitToolbar`](#cdktfprovideroktaappsharedcredentialspropertyautosubmittoolbar)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`buttonField`](#cdktfprovideroktaappsharedcredentialspropertybuttonfield)<span title="Required">*</span> | `string` | *No description.* |
| [`checkbox`](#cdktfprovideroktaappsharedcredentialspropertycheckbox)<span title="Required">*</span> | `string` | *No description.* |
| [`enduserNote`](#cdktfprovideroktaappsharedcredentialspropertyendusernote)<span title="Required">*</span> | `string` | *No description.* |
| [`groups`](#cdktfprovideroktaappsharedcredentialspropertygroups)<span title="Required">*</span> | `string`[] | *No description.* |
| [`hideIos`](#cdktfprovideroktaappsharedcredentialspropertyhideios)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`hideWeb`](#cdktfprovideroktaappsharedcredentialspropertyhideweb)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`id`](#cdktfprovideroktaappsharedcredentialspropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`label`](#cdktfprovideroktaappsharedcredentialspropertylabel)<span title="Required">*</span> | `string` | *No description.* |
| [`logo`](#cdktfprovideroktaappsharedcredentialspropertylogo)<span title="Required">*</span> | `string` | *No description.* |
| [`passwordField`](#cdktfprovideroktaappsharedcredentialspropertypasswordfield)<span title="Required">*</span> | `string` | *No description.* |
| [`preconfiguredApp`](#cdktfprovideroktaappsharedcredentialspropertypreconfiguredapp)<span title="Required">*</span> | `string` | *No description.* |
| [`redirectUrl`](#cdktfprovideroktaappsharedcredentialspropertyredirecturl)<span title="Required">*</span> | `string` | *No description.* |
| [`sharedPassword`](#cdktfprovideroktaappsharedcredentialspropertysharedpassword)<span title="Required">*</span> | `string` | *No description.* |
| [`sharedUsername`](#cdktfprovideroktaappsharedcredentialspropertysharedusername)<span title="Required">*</span> | `string` | *No description.* |
| [`skipGroups`](#cdktfprovideroktaappsharedcredentialspropertyskipgroups)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`skipUsers`](#cdktfprovideroktaappsharedcredentialspropertyskipusers)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`status`](#cdktfprovideroktaappsharedcredentialspropertystatus)<span title="Required">*</span> | `string` | *No description.* |
| [`url`](#cdktfprovideroktaappsharedcredentialspropertyurl)<span title="Required">*</span> | `string` | *No description.* |
| [`urlRegex`](#cdktfprovideroktaappsharedcredentialspropertyurlregex)<span title="Required">*</span> | `string` | *No description.* |
| [`usernameField`](#cdktfprovideroktaappsharedcredentialspropertyusernamefield)<span title="Required">*</span> | `string` | *No description.* |
| [`userNameTemplate`](#cdktfprovideroktaappsharedcredentialspropertyusernametemplate)<span title="Required">*</span> | `string` | *No description.* |
| [`userNameTemplatePushStatus`](#cdktfprovideroktaappsharedcredentialspropertyusernametemplatepushstatus)<span title="Required">*</span> | `string` | *No description.* |
| [`userNameTemplateSuffix`](#cdktfprovideroktaappsharedcredentialspropertyusernametemplatesuffix)<span title="Required">*</span> | `string` | *No description.* |
| [`userNameTemplateType`](#cdktfprovideroktaappsharedcredentialspropertyusernametemplatetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `logoUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.logoUrl" id="cdktfprovideroktaappsharedcredentialspropertylogourl"></a>

```typescript
public readonly logoUrl: string;
```

- *Type:* `string`

---

##### `name`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.name" id="cdktfprovideroktaappsharedcredentialspropertyname"></a>

```typescript
public readonly name: string;
```

- *Type:* `string`

---

##### `signOnMode`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.signOnMode" id="cdktfprovideroktaappsharedcredentialspropertysignonmode"></a>

```typescript
public readonly signOnMode: string;
```

- *Type:* `string`

---

##### `timeouts`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.timeouts" id="cdktfprovideroktaappsharedcredentialspropertytimeouts"></a>

```typescript
public readonly timeouts: AppSharedCredentialsTimeoutsOutputReference;
```

- *Type:* [`@cdktf/provider-okta.AppSharedCredentialsTimeoutsOutputReference`](#@cdktf/provider-okta.AppSharedCredentialsTimeoutsOutputReference)

---

##### `users`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.users" id="cdktfprovideroktaappsharedcredentialspropertyusers"></a>

```typescript
public readonly users: AppSharedCredentialsUsersList;
```

- *Type:* [`@cdktf/provider-okta.AppSharedCredentialsUsersList`](#@cdktf/provider-okta.AppSharedCredentialsUsersList)

---

##### `accessibilityErrorRedirectUrlInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.accessibilityErrorRedirectUrlInput" id="cdktfprovideroktaappsharedcredentialspropertyaccessibilityerrorredirecturlinput"></a>

```typescript
public readonly accessibilityErrorRedirectUrlInput: string;
```

- *Type:* `string`

---

##### `accessibilityLoginRedirectUrlInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.accessibilityLoginRedirectUrlInput" id="cdktfprovideroktaappsharedcredentialspropertyaccessibilityloginredirecturlinput"></a>

```typescript
public readonly accessibilityLoginRedirectUrlInput: string;
```

- *Type:* `string`

---

##### `accessibilitySelfServiceInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.accessibilitySelfServiceInput" id="cdktfprovideroktaappsharedcredentialspropertyaccessibilityselfserviceinput"></a>

```typescript
public readonly accessibilitySelfServiceInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `adminNoteInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.adminNoteInput" id="cdktfprovideroktaappsharedcredentialspropertyadminnoteinput"></a>

```typescript
public readonly adminNoteInput: string;
```

- *Type:* `string`

---

##### `appLinksJsonInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.appLinksJsonInput" id="cdktfprovideroktaappsharedcredentialspropertyapplinksjsoninput"></a>

```typescript
public readonly appLinksJsonInput: string;
```

- *Type:* `string`

---

##### `autoSubmitToolbarInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.autoSubmitToolbarInput" id="cdktfprovideroktaappsharedcredentialspropertyautosubmittoolbarinput"></a>

```typescript
public readonly autoSubmitToolbarInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `buttonFieldInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.buttonFieldInput" id="cdktfprovideroktaappsharedcredentialspropertybuttonfieldinput"></a>

```typescript
public readonly buttonFieldInput: string;
```

- *Type:* `string`

---

##### `checkboxInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.checkboxInput" id="cdktfprovideroktaappsharedcredentialspropertycheckboxinput"></a>

```typescript
public readonly checkboxInput: string;
```

- *Type:* `string`

---

##### `enduserNoteInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.enduserNoteInput" id="cdktfprovideroktaappsharedcredentialspropertyendusernoteinput"></a>

```typescript
public readonly enduserNoteInput: string;
```

- *Type:* `string`

---

##### `groupsInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.groupsInput" id="cdktfprovideroktaappsharedcredentialspropertygroupsinput"></a>

```typescript
public readonly groupsInput: string[];
```

- *Type:* `string`[]

---

##### `hideIosInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.hideIosInput" id="cdktfprovideroktaappsharedcredentialspropertyhideiosinput"></a>

```typescript
public readonly hideIosInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `hideWebInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.hideWebInput" id="cdktfprovideroktaappsharedcredentialspropertyhidewebinput"></a>

```typescript
public readonly hideWebInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.idInput" id="cdktfprovideroktaappsharedcredentialspropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `labelInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.labelInput" id="cdktfprovideroktaappsharedcredentialspropertylabelinput"></a>

```typescript
public readonly labelInput: string;
```

- *Type:* `string`

---

##### `logoInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.logoInput" id="cdktfprovideroktaappsharedcredentialspropertylogoinput"></a>

```typescript
public readonly logoInput: string;
```

- *Type:* `string`

---

##### `passwordFieldInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.passwordFieldInput" id="cdktfprovideroktaappsharedcredentialspropertypasswordfieldinput"></a>

```typescript
public readonly passwordFieldInput: string;
```

- *Type:* `string`

---

##### `preconfiguredAppInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.preconfiguredAppInput" id="cdktfprovideroktaappsharedcredentialspropertypreconfiguredappinput"></a>

```typescript
public readonly preconfiguredAppInput: string;
```

- *Type:* `string`

---

##### `redirectUrlInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.redirectUrlInput" id="cdktfprovideroktaappsharedcredentialspropertyredirecturlinput"></a>

```typescript
public readonly redirectUrlInput: string;
```

- *Type:* `string`

---

##### `sharedPasswordInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.sharedPasswordInput" id="cdktfprovideroktaappsharedcredentialspropertysharedpasswordinput"></a>

```typescript
public readonly sharedPasswordInput: string;
```

- *Type:* `string`

---

##### `sharedUsernameInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.sharedUsernameInput" id="cdktfprovideroktaappsharedcredentialspropertysharedusernameinput"></a>

```typescript
public readonly sharedUsernameInput: string;
```

- *Type:* `string`

---

##### `skipGroupsInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.skipGroupsInput" id="cdktfprovideroktaappsharedcredentialspropertyskipgroupsinput"></a>

```typescript
public readonly skipGroupsInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `skipUsersInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.skipUsersInput" id="cdktfprovideroktaappsharedcredentialspropertyskipusersinput"></a>

```typescript
public readonly skipUsersInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `statusInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.statusInput" id="cdktfprovideroktaappsharedcredentialspropertystatusinput"></a>

```typescript
public readonly statusInput: string;
```

- *Type:* `string`

---

##### `timeoutsInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.timeoutsInput" id="cdktfprovideroktaappsharedcredentialspropertytimeoutsinput"></a>

```typescript
public readonly timeoutsInput: IResolvable | AppSharedCredentialsTimeouts;
```

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable) | [`@cdktf/provider-okta.AppSharedCredentialsTimeouts`](#@cdktf/provider-okta.AppSharedCredentialsTimeouts)

---

##### `urlInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.urlInput" id="cdktfprovideroktaappsharedcredentialspropertyurlinput"></a>

```typescript
public readonly urlInput: string;
```

- *Type:* `string`

---

##### `urlRegexInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.urlRegexInput" id="cdktfprovideroktaappsharedcredentialspropertyurlregexinput"></a>

```typescript
public readonly urlRegexInput: string;
```

- *Type:* `string`

---

##### `usernameFieldInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.usernameFieldInput" id="cdktfprovideroktaappsharedcredentialspropertyusernamefieldinput"></a>

```typescript
public readonly usernameFieldInput: string;
```

- *Type:* `string`

---

##### `userNameTemplateInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.userNameTemplateInput" id="cdktfprovideroktaappsharedcredentialspropertyusernametemplateinput"></a>

```typescript
public readonly userNameTemplateInput: string;
```

- *Type:* `string`

---

##### `userNameTemplatePushStatusInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.userNameTemplatePushStatusInput" id="cdktfprovideroktaappsharedcredentialspropertyusernametemplatepushstatusinput"></a>

```typescript
public readonly userNameTemplatePushStatusInput: string;
```

- *Type:* `string`

---

##### `userNameTemplateSuffixInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.userNameTemplateSuffixInput" id="cdktfprovideroktaappsharedcredentialspropertyusernametemplatesuffixinput"></a>

```typescript
public readonly userNameTemplateSuffixInput: string;
```

- *Type:* `string`

---

##### `userNameTemplateTypeInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.userNameTemplateTypeInput" id="cdktfprovideroktaappsharedcredentialspropertyusernametemplatetypeinput"></a>

```typescript
public readonly userNameTemplateTypeInput: string;
```

- *Type:* `string`

---

##### `usersInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.usersInput" id="cdktfprovideroktaappsharedcredentialspropertyusersinput"></a>

```typescript
public readonly usersInput: IResolvable | AppSharedCredentialsUsers[];
```

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable) | [`@cdktf/provider-okta.AppSharedCredentialsUsers`](#@cdktf/provider-okta.AppSharedCredentialsUsers)[]

---

##### `accessibilityErrorRedirectUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.accessibilityErrorRedirectUrl" id="cdktfprovideroktaappsharedcredentialspropertyaccessibilityerrorredirecturl"></a>

```typescript
public readonly accessibilityErrorRedirectUrl: string;
```

- *Type:* `string`

---

##### `accessibilityLoginRedirectUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.accessibilityLoginRedirectUrl" id="cdktfprovideroktaappsharedcredentialspropertyaccessibilityloginredirecturl"></a>

```typescript
public readonly accessibilityLoginRedirectUrl: string;
```

- *Type:* `string`

---

##### `accessibilitySelfService`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.accessibilitySelfService" id="cdktfprovideroktaappsharedcredentialspropertyaccessibilityselfservice"></a>

```typescript
public readonly accessibilitySelfService: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `adminNote`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.adminNote" id="cdktfprovideroktaappsharedcredentialspropertyadminnote"></a>

```typescript
public readonly adminNote: string;
```

- *Type:* `string`

---

##### `appLinksJson`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.appLinksJson" id="cdktfprovideroktaappsharedcredentialspropertyapplinksjson"></a>

```typescript
public readonly appLinksJson: string;
```

- *Type:* `string`

---

##### `autoSubmitToolbar`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.autoSubmitToolbar" id="cdktfprovideroktaappsharedcredentialspropertyautosubmittoolbar"></a>

```typescript
public readonly autoSubmitToolbar: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `buttonField`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.buttonField" id="cdktfprovideroktaappsharedcredentialspropertybuttonfield"></a>

```typescript
public readonly buttonField: string;
```

- *Type:* `string`

---

##### `checkbox`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.checkbox" id="cdktfprovideroktaappsharedcredentialspropertycheckbox"></a>

```typescript
public readonly checkbox: string;
```

- *Type:* `string`

---

##### `enduserNote`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.enduserNote" id="cdktfprovideroktaappsharedcredentialspropertyendusernote"></a>

```typescript
public readonly enduserNote: string;
```

- *Type:* `string`

---

##### `groups`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.groups" id="cdktfprovideroktaappsharedcredentialspropertygroups"></a>

```typescript
public readonly groups: string[];
```

- *Type:* `string`[]

---

##### `hideIos`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.hideIos" id="cdktfprovideroktaappsharedcredentialspropertyhideios"></a>

```typescript
public readonly hideIos: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `hideWeb`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.hideWeb" id="cdktfprovideroktaappsharedcredentialspropertyhideweb"></a>

```typescript
public readonly hideWeb: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.id" id="cdktfprovideroktaappsharedcredentialspropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `label`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.label" id="cdktfprovideroktaappsharedcredentialspropertylabel"></a>

```typescript
public readonly label: string;
```

- *Type:* `string`

---

##### `logo`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.logo" id="cdktfprovideroktaappsharedcredentialspropertylogo"></a>

```typescript
public readonly logo: string;
```

- *Type:* `string`

---

##### `passwordField`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.passwordField" id="cdktfprovideroktaappsharedcredentialspropertypasswordfield"></a>

```typescript
public readonly passwordField: string;
```

- *Type:* `string`

---

##### `preconfiguredApp`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.preconfiguredApp" id="cdktfprovideroktaappsharedcredentialspropertypreconfiguredapp"></a>

```typescript
public readonly preconfiguredApp: string;
```

- *Type:* `string`

---

##### `redirectUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.redirectUrl" id="cdktfprovideroktaappsharedcredentialspropertyredirecturl"></a>

```typescript
public readonly redirectUrl: string;
```

- *Type:* `string`

---

##### `sharedPassword`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.sharedPassword" id="cdktfprovideroktaappsharedcredentialspropertysharedpassword"></a>

```typescript
public readonly sharedPassword: string;
```

- *Type:* `string`

---

##### `sharedUsername`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.sharedUsername" id="cdktfprovideroktaappsharedcredentialspropertysharedusername"></a>

```typescript
public readonly sharedUsername: string;
```

- *Type:* `string`

---

##### `skipGroups`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.skipGroups" id="cdktfprovideroktaappsharedcredentialspropertyskipgroups"></a>

```typescript
public readonly skipGroups: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `skipUsers`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.skipUsers" id="cdktfprovideroktaappsharedcredentialspropertyskipusers"></a>

```typescript
public readonly skipUsers: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `status`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.status" id="cdktfprovideroktaappsharedcredentialspropertystatus"></a>

```typescript
public readonly status: string;
```

- *Type:* `string`

---

##### `url`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.url" id="cdktfprovideroktaappsharedcredentialspropertyurl"></a>

```typescript
public readonly url: string;
```

- *Type:* `string`

---

##### `urlRegex`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.urlRegex" id="cdktfprovideroktaappsharedcredentialspropertyurlregex"></a>

```typescript
public readonly urlRegex: string;
```

- *Type:* `string`

---

##### `usernameField`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.usernameField" id="cdktfprovideroktaappsharedcredentialspropertyusernamefield"></a>

```typescript
public readonly usernameField: string;
```

- *Type:* `string`

---

##### `userNameTemplate`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.userNameTemplate" id="cdktfprovideroktaappsharedcredentialspropertyusernametemplate"></a>

```typescript
public readonly userNameTemplate: string;
```

- *Type:* `string`

---

##### `userNameTemplatePushStatus`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.userNameTemplatePushStatus" id="cdktfprovideroktaappsharedcredentialspropertyusernametemplatepushstatus"></a>

```typescript
public readonly userNameTemplatePushStatus: string;
```

- *Type:* `string`

---

##### `userNameTemplateSuffix`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.userNameTemplateSuffix" id="cdktfprovideroktaappsharedcredentialspropertyusernametemplatesuffix"></a>

```typescript
public readonly userNameTemplateSuffix: string;
```

- *Type:* `string`

---

##### `userNameTemplateType`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSharedCredentials.property.userNameTemplateType" id="cdktfprovideroktaappsharedcredentialspropertyusernametemplatetype"></a>

```typescript
public readonly userNameTemplateType: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktaappsharedcredentialspropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.AppSharedCredentials.property.tfResourceType" id="cdktfprovideroktaappsharedcredentialspropertytfresourcetype"></a>

- *Type:* `string`

---

### AppSignonPolicy <a name="@cdktf/provider-okta.AppSignonPolicy" id="cdktfprovideroktaappsignonpolicy"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy okta_app_signon_policy}.

#### Initializers <a name="@cdktf/provider-okta.AppSignonPolicy.Initializer" id="cdktfprovideroktaappsignonpolicyinitializer"></a>

```typescript
import { AppSignonPolicy } from '@cdktf/provider-okta'

new AppSignonPolicy(scope: Construct, id: string, config: AppSignonPolicyConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktaappsignonpolicyparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktaappsignonpolicyparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktaappsignonpolicyparameterconfig)<span title="Required">*</span> | [`@cdktf/provider-okta.AppSignonPolicyConfig`](#@cdktf/provider-okta.AppSignonPolicyConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSignonPolicy.parameter.scope" id="cdktfprovideroktaappsignonpolicyparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSignonPolicy.parameter.id" id="cdktfprovideroktaappsignonpolicyparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSignonPolicy.parameter.config" id="cdktfprovideroktaappsignonpolicyparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.AppSignonPolicyConfig`](#@cdktf/provider-okta.AppSignonPolicyConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`resetId`](#cdktfprovideroktaappsignonpolicyresetid) | *No description.* |

---

##### `resetId` <a name="@cdktf/provider-okta.AppSignonPolicy.resetId" id="cdktfprovideroktaappsignonpolicyresetid"></a>

```typescript
public resetId()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`descriptionInput`](#cdktfprovideroktaappsignonpolicypropertydescriptioninput) | `string` | *No description.* |
| [`idInput`](#cdktfprovideroktaappsignonpolicypropertyidinput) | `string` | *No description.* |
| [`nameInput`](#cdktfprovideroktaappsignonpolicypropertynameinput) | `string` | *No description.* |
| [`description`](#cdktfprovideroktaappsignonpolicypropertydescription)<span title="Required">*</span> | `string` | *No description.* |
| [`id`](#cdktfprovideroktaappsignonpolicypropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`name`](#cdktfprovideroktaappsignonpolicypropertyname)<span title="Required">*</span> | `string` | *No description.* |

---

##### `descriptionInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSignonPolicy.property.descriptionInput" id="cdktfprovideroktaappsignonpolicypropertydescriptioninput"></a>

```typescript
public readonly descriptionInput: string;
```

- *Type:* `string`

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSignonPolicy.property.idInput" id="cdktfprovideroktaappsignonpolicypropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `nameInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSignonPolicy.property.nameInput" id="cdktfprovideroktaappsignonpolicypropertynameinput"></a>

```typescript
public readonly nameInput: string;
```

- *Type:* `string`

---

##### `description`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSignonPolicy.property.description" id="cdktfprovideroktaappsignonpolicypropertydescription"></a>

```typescript
public readonly description: string;
```

- *Type:* `string`

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSignonPolicy.property.id" id="cdktfprovideroktaappsignonpolicypropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `name`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSignonPolicy.property.name" id="cdktfprovideroktaappsignonpolicypropertyname"></a>

```typescript
public readonly name: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktaappsignonpolicypropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.AppSignonPolicy.property.tfResourceType" id="cdktfprovideroktaappsignonpolicypropertytfresourcetype"></a>

- *Type:* `string`

---

### AppSignonPolicyRule <a name="@cdktf/provider-okta.AppSignonPolicyRule" id="cdktfprovideroktaappsignonpolicyrule"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy_rule okta_app_signon_policy_rule}.

#### Initializers <a name="@cdktf/provider-okta.AppSignonPolicyRule.Initializer" id="cdktfprovideroktaappsignonpolicyruleinitializer"></a>

```typescript
import { AppSignonPolicyRule } from '@cdktf/provider-okta'

new AppSignonPolicyRule(scope: Construct, id: string, config: AppSignonPolicyRuleConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktaappsignonpolicyruleparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktaappsignonpolicyruleparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktaappsignonpolicyruleparameterconfig)<span title="Required">*</span> | [`@cdktf/provider-okta.AppSignonPolicyRuleConfig`](#@cdktf/provider-okta.AppSignonPolicyRuleConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSignonPolicyRule.parameter.scope" id="cdktfprovideroktaappsignonpolicyruleparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSignonPolicyRule.parameter.id" id="cdktfprovideroktaappsignonpolicyruleparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSignonPolicyRule.parameter.config" id="cdktfprovideroktaappsignonpolicyruleparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.AppSignonPolicyRuleConfig`](#@cdktf/provider-okta.AppSignonPolicyRuleConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`putPlatformInclude`](#cdktfprovideroktaappsignonpolicyruleputplatforminclude) | *No description.* |
| [`resetAccess`](#cdktfprovideroktaappsignonpolicyruleresetaccess) | *No description.* |
| [`resetConstraints`](#cdktfprovideroktaappsignonpolicyruleresetconstraints) | *No description.* |
| [`resetCustomExpression`](#cdktfprovideroktaappsignonpolicyruleresetcustomexpression) | *No description.* |
| [`resetDeviceIsManaged`](#cdktfprovideroktaappsignonpolicyruleresetdeviceismanaged) | *No description.* |
| [`resetDeviceIsRegistered`](#cdktfprovideroktaappsignonpolicyruleresetdeviceisregistered) | *No description.* |
| [`resetFactorMode`](#cdktfprovideroktaappsignonpolicyruleresetfactormode) | *No description.* |
| [`resetGroupsExcluded`](#cdktfprovideroktaappsignonpolicyruleresetgroupsexcluded) | *No description.* |
| [`resetGroupsIncluded`](#cdktfprovideroktaappsignonpolicyruleresetgroupsincluded) | *No description.* |
| [`resetId`](#cdktfprovideroktaappsignonpolicyruleresetid) | *No description.* |
| [`resetInactivityPeriod`](#cdktfprovideroktaappsignonpolicyruleresetinactivityperiod) | *No description.* |
| [`resetNetworkConnection`](#cdktfprovideroktaappsignonpolicyruleresetnetworkconnection) | *No description.* |
| [`resetNetworkExcludes`](#cdktfprovideroktaappsignonpolicyruleresetnetworkexcludes) | *No description.* |
| [`resetNetworkIncludes`](#cdktfprovideroktaappsignonpolicyruleresetnetworkincludes) | *No description.* |
| [`resetPlatformInclude`](#cdktfprovideroktaappsignonpolicyruleresetplatforminclude) | *No description.* |
| [`resetPriority`](#cdktfprovideroktaappsignonpolicyruleresetpriority) | *No description.* |
| [`resetReAuthenticationFrequency`](#cdktfprovideroktaappsignonpolicyruleresetreauthenticationfrequency) | *No description.* |
| [`resetStatus`](#cdktfprovideroktaappsignonpolicyruleresetstatus) | *No description.* |
| [`resetType`](#cdktfprovideroktaappsignonpolicyruleresettype) | *No description.* |
| [`resetUsersExcluded`](#cdktfprovideroktaappsignonpolicyruleresetusersexcluded) | *No description.* |
| [`resetUsersIncluded`](#cdktfprovideroktaappsignonpolicyruleresetusersincluded) | *No description.* |
| [`resetUserTypesExcluded`](#cdktfprovideroktaappsignonpolicyruleresetusertypesexcluded) | *No description.* |
| [`resetUserTypesIncluded`](#cdktfprovideroktaappsignonpolicyruleresetusertypesincluded) | *No description.* |

---

##### `putPlatformInclude` <a name="@cdktf/provider-okta.AppSignonPolicyRule.putPlatformInclude" id="cdktfprovideroktaappsignonpolicyruleputplatforminclude"></a>

```typescript
public putPlatformInclude(value: IResolvable | AppSignonPolicyRulePlatformInclude[])
```

###### `value`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSignonPolicyRule.parameter.value" id="cdktfprovideroktaappsignonpolicyruleparametervalue"></a>

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable) | [`@cdktf/provider-okta.AppSignonPolicyRulePlatformInclude`](#@cdktf/provider-okta.AppSignonPolicyRulePlatformInclude)[]

---

##### `resetAccess` <a name="@cdktf/provider-okta.AppSignonPolicyRule.resetAccess" id="cdktfprovideroktaappsignonpolicyruleresetaccess"></a>

```typescript
public resetAccess()
```

##### `resetConstraints` <a name="@cdktf/provider-okta.AppSignonPolicyRule.resetConstraints" id="cdktfprovideroktaappsignonpolicyruleresetconstraints"></a>

```typescript
public resetConstraints()
```

##### `resetCustomExpression` <a name="@cdktf/provider-okta.AppSignonPolicyRule.resetCustomExpression" id="cdktfprovideroktaappsignonpolicyruleresetcustomexpression"></a>

```typescript
public resetCustomExpression()
```

##### `resetDeviceIsManaged` <a name="@cdktf/provider-okta.AppSignonPolicyRule.resetDeviceIsManaged" id="cdktfprovideroktaappsignonpolicyruleresetdeviceismanaged"></a>

```typescript
public resetDeviceIsManaged()
```

##### `resetDeviceIsRegistered` <a name="@cdktf/provider-okta.AppSignonPolicyRule.resetDeviceIsRegistered" id="cdktfprovideroktaappsignonpolicyruleresetdeviceisregistered"></a>

```typescript
public resetDeviceIsRegistered()
```

##### `resetFactorMode` <a name="@cdktf/provider-okta.AppSignonPolicyRule.resetFactorMode" id="cdktfprovideroktaappsignonpolicyruleresetfactormode"></a>

```typescript
public resetFactorMode()
```

##### `resetGroupsExcluded` <a name="@cdktf/provider-okta.AppSignonPolicyRule.resetGroupsExcluded" id="cdktfprovideroktaappsignonpolicyruleresetgroupsexcluded"></a>

```typescript
public resetGroupsExcluded()
```

##### `resetGroupsIncluded` <a name="@cdktf/provider-okta.AppSignonPolicyRule.resetGroupsIncluded" id="cdktfprovideroktaappsignonpolicyruleresetgroupsincluded"></a>

```typescript
public resetGroupsIncluded()
```

##### `resetId` <a name="@cdktf/provider-okta.AppSignonPolicyRule.resetId" id="cdktfprovideroktaappsignonpolicyruleresetid"></a>

```typescript
public resetId()
```

##### `resetInactivityPeriod` <a name="@cdktf/provider-okta.AppSignonPolicyRule.resetInactivityPeriod" id="cdktfprovideroktaappsignonpolicyruleresetinactivityperiod"></a>

```typescript
public resetInactivityPeriod()
```

##### `resetNetworkConnection` <a name="@cdktf/provider-okta.AppSignonPolicyRule.resetNetworkConnection" id="cdktfprovideroktaappsignonpolicyruleresetnetworkconnection"></a>

```typescript
public resetNetworkConnection()
```

##### `resetNetworkExcludes` <a name="@cdktf/provider-okta.AppSignonPolicyRule.resetNetworkExcludes" id="cdktfprovideroktaappsignonpolicyruleresetnetworkexcludes"></a>

```typescript
public resetNetworkExcludes()
```

##### `resetNetworkIncludes` <a name="@cdktf/provider-okta.AppSignonPolicyRule.resetNetworkIncludes" id="cdktfprovideroktaappsignonpolicyruleresetnetworkincludes"></a>

```typescript
public resetNetworkIncludes()
```

##### `resetPlatformInclude` <a name="@cdktf/provider-okta.AppSignonPolicyRule.resetPlatformInclude" id="cdktfprovideroktaappsignonpolicyruleresetplatforminclude"></a>

```typescript
public resetPlatformInclude()
```

##### `resetPriority` <a name="@cdktf/provider-okta.AppSignonPolicyRule.resetPriority" id="cdktfprovideroktaappsignonpolicyruleresetpriority"></a>

```typescript
public resetPriority()
```

##### `resetReAuthenticationFrequency` <a name="@cdktf/provider-okta.AppSignonPolicyRule.resetReAuthenticationFrequency" id="cdktfprovideroktaappsignonpolicyruleresetreauthenticationfrequency"></a>

```typescript
public resetReAuthenticationFrequency()
```

##### `resetStatus` <a name="@cdktf/provider-okta.AppSignonPolicyRule.resetStatus" id="cdktfprovideroktaappsignonpolicyruleresetstatus"></a>

```typescript
public resetStatus()
```

##### `resetType` <a name="@cdktf/provider-okta.AppSignonPolicyRule.resetType" id="cdktfprovideroktaappsignonpolicyruleresettype"></a>

```typescript
public resetType()
```

##### `resetUsersExcluded` <a name="@cdktf/provider-okta.AppSignonPolicyRule.resetUsersExcluded" id="cdktfprovideroktaappsignonpolicyruleresetusersexcluded"></a>

```typescript
public resetUsersExcluded()
```

##### `resetUsersIncluded` <a name="@cdktf/provider-okta.AppSignonPolicyRule.resetUsersIncluded" id="cdktfprovideroktaappsignonpolicyruleresetusersincluded"></a>

```typescript
public resetUsersIncluded()
```

##### `resetUserTypesExcluded` <a name="@cdktf/provider-okta.AppSignonPolicyRule.resetUserTypesExcluded" id="cdktfprovideroktaappsignonpolicyruleresetusertypesexcluded"></a>

```typescript
public resetUserTypesExcluded()
```

##### `resetUserTypesIncluded` <a name="@cdktf/provider-okta.AppSignonPolicyRule.resetUserTypesIncluded" id="cdktfprovideroktaappsignonpolicyruleresetusertypesincluded"></a>

```typescript
public resetUserTypesIncluded()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`platformInclude`](#cdktfprovideroktaappsignonpolicyrulepropertyplatforminclude)<span title="Required">*</span> | [`@cdktf/provider-okta.AppSignonPolicyRulePlatformIncludeList`](#@cdktf/provider-okta.AppSignonPolicyRulePlatformIncludeList) | *No description.* |
| [`accessInput`](#cdktfprovideroktaappsignonpolicyrulepropertyaccessinput) | `string` | *No description.* |
| [`constraintsInput`](#cdktfprovideroktaappsignonpolicyrulepropertyconstraintsinput) | `string`[] | *No description.* |
| [`customExpressionInput`](#cdktfprovideroktaappsignonpolicyrulepropertycustomexpressioninput) | `string` | *No description.* |
| [`deviceIsManagedInput`](#cdktfprovideroktaappsignonpolicyrulepropertydeviceismanagedinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`deviceIsRegisteredInput`](#cdktfprovideroktaappsignonpolicyrulepropertydeviceisregisteredinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`factorModeInput`](#cdktfprovideroktaappsignonpolicyrulepropertyfactormodeinput) | `string` | *No description.* |
| [`groupsExcludedInput`](#cdktfprovideroktaappsignonpolicyrulepropertygroupsexcludedinput) | `string`[] | *No description.* |
| [`groupsIncludedInput`](#cdktfprovideroktaappsignonpolicyrulepropertygroupsincludedinput) | `string`[] | *No description.* |
| [`idInput`](#cdktfprovideroktaappsignonpolicyrulepropertyidinput) | `string` | *No description.* |
| [`inactivityPeriodInput`](#cdktfprovideroktaappsignonpolicyrulepropertyinactivityperiodinput) | `string` | *No description.* |
| [`nameInput`](#cdktfprovideroktaappsignonpolicyrulepropertynameinput) | `string` | *No description.* |
| [`networkConnectionInput`](#cdktfprovideroktaappsignonpolicyrulepropertynetworkconnectioninput) | `string` | *No description.* |
| [`networkExcludesInput`](#cdktfprovideroktaappsignonpolicyrulepropertynetworkexcludesinput) | `string`[] | *No description.* |
| [`networkIncludesInput`](#cdktfprovideroktaappsignonpolicyrulepropertynetworkincludesinput) | `string`[] | *No description.* |
| [`platformIncludeInput`](#cdktfprovideroktaappsignonpolicyrulepropertyplatformincludeinput) | [`cdktf.IResolvable`](#cdktf.IResolvable) \| [`@cdktf/provider-okta.AppSignonPolicyRulePlatformInclude`](#@cdktf/provider-okta.AppSignonPolicyRulePlatformInclude)[] | *No description.* |
| [`policyIdInput`](#cdktfprovideroktaappsignonpolicyrulepropertypolicyidinput) | `string` | *No description.* |
| [`priorityInput`](#cdktfprovideroktaappsignonpolicyrulepropertypriorityinput) | `number` | *No description.* |
| [`reAuthenticationFrequencyInput`](#cdktfprovideroktaappsignonpolicyrulepropertyreauthenticationfrequencyinput) | `string` | *No description.* |
| [`statusInput`](#cdktfprovideroktaappsignonpolicyrulepropertystatusinput) | `string` | *No description.* |
| [`typeInput`](#cdktfprovideroktaappsignonpolicyrulepropertytypeinput) | `string` | *No description.* |
| [`usersExcludedInput`](#cdktfprovideroktaappsignonpolicyrulepropertyusersexcludedinput) | `string`[] | *No description.* |
| [`usersIncludedInput`](#cdktfprovideroktaappsignonpolicyrulepropertyusersincludedinput) | `string`[] | *No description.* |
| [`userTypesExcludedInput`](#cdktfprovideroktaappsignonpolicyrulepropertyusertypesexcludedinput) | `string`[] | *No description.* |
| [`userTypesIncludedInput`](#cdktfprovideroktaappsignonpolicyrulepropertyusertypesincludedinput) | `string`[] | *No description.* |
| [`access`](#cdktfprovideroktaappsignonpolicyrulepropertyaccess)<span title="Required">*</span> | `string` | *No description.* |
| [`constraints`](#cdktfprovideroktaappsignonpolicyrulepropertyconstraints)<span title="Required">*</span> | `string`[] | *No description.* |
| [`customExpression`](#cdktfprovideroktaappsignonpolicyrulepropertycustomexpression)<span title="Required">*</span> | `string` | *No description.* |
| [`deviceIsManaged`](#cdktfprovideroktaappsignonpolicyrulepropertydeviceismanaged)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`deviceIsRegistered`](#cdktfprovideroktaappsignonpolicyrulepropertydeviceisregistered)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`factorMode`](#cdktfprovideroktaappsignonpolicyrulepropertyfactormode)<span title="Required">*</span> | `string` | *No description.* |
| [`groupsExcluded`](#cdktfprovideroktaappsignonpolicyrulepropertygroupsexcluded)<span title="Required">*</span> | `string`[] | *No description.* |
| [`groupsIncluded`](#cdktfprovideroktaappsignonpolicyrulepropertygroupsincluded)<span title="Required">*</span> | `string`[] | *No description.* |
| [`id`](#cdktfprovideroktaappsignonpolicyrulepropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`inactivityPeriod`](#cdktfprovideroktaappsignonpolicyrulepropertyinactivityperiod)<span title="Required">*</span> | `string` | *No description.* |
| [`name`](#cdktfprovideroktaappsignonpolicyrulepropertyname)<span title="Required">*</span> | `string` | *No description.* |
| [`networkConnection`](#cdktfprovideroktaappsignonpolicyrulepropertynetworkconnection)<span title="Required">*</span> | `string` | *No description.* |
| [`networkExcludes`](#cdktfprovideroktaappsignonpolicyrulepropertynetworkexcludes)<span title="Required">*</span> | `string`[] | *No description.* |
| [`networkIncludes`](#cdktfprovideroktaappsignonpolicyrulepropertynetworkincludes)<span title="Required">*</span> | `string`[] | *No description.* |
| [`policyId`](#cdktfprovideroktaappsignonpolicyrulepropertypolicyid)<span title="Required">*</span> | `string` | *No description.* |
| [`priority`](#cdktfprovideroktaappsignonpolicyrulepropertypriority)<span title="Required">*</span> | `number` | *No description.* |
| [`reAuthenticationFrequency`](#cdktfprovideroktaappsignonpolicyrulepropertyreauthenticationfrequency)<span title="Required">*</span> | `string` | *No description.* |
| [`status`](#cdktfprovideroktaappsignonpolicyrulepropertystatus)<span title="Required">*</span> | `string` | *No description.* |
| [`type`](#cdktfprovideroktaappsignonpolicyrulepropertytype)<span title="Required">*</span> | `string` | *No description.* |
| [`usersExcluded`](#cdktfprovideroktaappsignonpolicyrulepropertyusersexcluded)<span title="Required">*</span> | `string`[] | *No description.* |
| [`usersIncluded`](#cdktfprovideroktaappsignonpolicyrulepropertyusersincluded)<span title="Required">*</span> | `string`[] | *No description.* |
| [`userTypesExcluded`](#cdktfprovideroktaappsignonpolicyrulepropertyusertypesexcluded)<span title="Required">*</span> | `string`[] | *No description.* |
| [`userTypesIncluded`](#cdktfprovideroktaappsignonpolicyrulepropertyusertypesincluded)<span title="Required">*</span> | `string`[] | *No description.* |

---

##### `platformInclude`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSignonPolicyRule.property.platformInclude" id="cdktfprovideroktaappsignonpolicyrulepropertyplatforminclude"></a>

```typescript
public readonly platformInclude: AppSignonPolicyRulePlatformIncludeList;
```

- *Type:* [`@cdktf/provider-okta.AppSignonPolicyRulePlatformIncludeList`](#@cdktf/provider-okta.AppSignonPolicyRulePlatformIncludeList)

---

##### `accessInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSignonPolicyRule.property.accessInput" id="cdktfprovideroktaappsignonpolicyrulepropertyaccessinput"></a>

```typescript
public readonly accessInput: string;
```

- *Type:* `string`

---

##### `constraintsInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSignonPolicyRule.property.constraintsInput" id="cdktfprovideroktaappsignonpolicyrulepropertyconstraintsinput"></a>

```typescript
public readonly constraintsInput: string[];
```

- *Type:* `string`[]

---

##### `customExpressionInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSignonPolicyRule.property.customExpressionInput" id="cdktfprovideroktaappsignonpolicyrulepropertycustomexpressioninput"></a>

```typescript
public readonly customExpressionInput: string;
```

- *Type:* `string`

---

##### `deviceIsManagedInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSignonPolicyRule.property.deviceIsManagedInput" id="cdktfprovideroktaappsignonpolicyrulepropertydeviceismanagedinput"></a>

```typescript
public readonly deviceIsManagedInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `deviceIsRegisteredInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSignonPolicyRule.property.deviceIsRegisteredInput" id="cdktfprovideroktaappsignonpolicyrulepropertydeviceisregisteredinput"></a>

```typescript
public readonly deviceIsRegisteredInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `factorModeInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSignonPolicyRule.property.factorModeInput" id="cdktfprovideroktaappsignonpolicyrulepropertyfactormodeinput"></a>

```typescript
public readonly factorModeInput: string;
```

- *Type:* `string`

---

##### `groupsExcludedInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSignonPolicyRule.property.groupsExcludedInput" id="cdktfprovideroktaappsignonpolicyrulepropertygroupsexcludedinput"></a>

```typescript
public readonly groupsExcludedInput: string[];
```

- *Type:* `string`[]

---

##### `groupsIncludedInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSignonPolicyRule.property.groupsIncludedInput" id="cdktfprovideroktaappsignonpolicyrulepropertygroupsincludedinput"></a>

```typescript
public readonly groupsIncludedInput: string[];
```

- *Type:* `string`[]

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSignonPolicyRule.property.idInput" id="cdktfprovideroktaappsignonpolicyrulepropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `inactivityPeriodInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSignonPolicyRule.property.inactivityPeriodInput" id="cdktfprovideroktaappsignonpolicyrulepropertyinactivityperiodinput"></a>

```typescript
public readonly inactivityPeriodInput: string;
```

- *Type:* `string`

---

##### `nameInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSignonPolicyRule.property.nameInput" id="cdktfprovideroktaappsignonpolicyrulepropertynameinput"></a>

```typescript
public readonly nameInput: string;
```

- *Type:* `string`

---

##### `networkConnectionInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSignonPolicyRule.property.networkConnectionInput" id="cdktfprovideroktaappsignonpolicyrulepropertynetworkconnectioninput"></a>

```typescript
public readonly networkConnectionInput: string;
```

- *Type:* `string`

---

##### `networkExcludesInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSignonPolicyRule.property.networkExcludesInput" id="cdktfprovideroktaappsignonpolicyrulepropertynetworkexcludesinput"></a>

```typescript
public readonly networkExcludesInput: string[];
```

- *Type:* `string`[]

---

##### `networkIncludesInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSignonPolicyRule.property.networkIncludesInput" id="cdktfprovideroktaappsignonpolicyrulepropertynetworkincludesinput"></a>

```typescript
public readonly networkIncludesInput: string[];
```

- *Type:* `string`[]

---

##### `platformIncludeInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSignonPolicyRule.property.platformIncludeInput" id="cdktfprovideroktaappsignonpolicyrulepropertyplatformincludeinput"></a>

```typescript
public readonly platformIncludeInput: IResolvable | AppSignonPolicyRulePlatformInclude[];
```

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable) | [`@cdktf/provider-okta.AppSignonPolicyRulePlatformInclude`](#@cdktf/provider-okta.AppSignonPolicyRulePlatformInclude)[]

---

##### `policyIdInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSignonPolicyRule.property.policyIdInput" id="cdktfprovideroktaappsignonpolicyrulepropertypolicyidinput"></a>

```typescript
public readonly policyIdInput: string;
```

- *Type:* `string`

---

##### `priorityInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSignonPolicyRule.property.priorityInput" id="cdktfprovideroktaappsignonpolicyrulepropertypriorityinput"></a>

```typescript
public readonly priorityInput: number;
```

- *Type:* `number`

---

##### `reAuthenticationFrequencyInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSignonPolicyRule.property.reAuthenticationFrequencyInput" id="cdktfprovideroktaappsignonpolicyrulepropertyreauthenticationfrequencyinput"></a>

```typescript
public readonly reAuthenticationFrequencyInput: string;
```

- *Type:* `string`

---

##### `statusInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSignonPolicyRule.property.statusInput" id="cdktfprovideroktaappsignonpolicyrulepropertystatusinput"></a>

```typescript
public readonly statusInput: string;
```

- *Type:* `string`

---

##### `typeInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSignonPolicyRule.property.typeInput" id="cdktfprovideroktaappsignonpolicyrulepropertytypeinput"></a>

```typescript
public readonly typeInput: string;
```

- *Type:* `string`

---

##### `usersExcludedInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSignonPolicyRule.property.usersExcludedInput" id="cdktfprovideroktaappsignonpolicyrulepropertyusersexcludedinput"></a>

```typescript
public readonly usersExcludedInput: string[];
```

- *Type:* `string`[]

---

##### `usersIncludedInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSignonPolicyRule.property.usersIncludedInput" id="cdktfprovideroktaappsignonpolicyrulepropertyusersincludedinput"></a>

```typescript
public readonly usersIncludedInput: string[];
```

- *Type:* `string`[]

---

##### `userTypesExcludedInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSignonPolicyRule.property.userTypesExcludedInput" id="cdktfprovideroktaappsignonpolicyrulepropertyusertypesexcludedinput"></a>

```typescript
public readonly userTypesExcludedInput: string[];
```

- *Type:* `string`[]

---

##### `userTypesIncludedInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSignonPolicyRule.property.userTypesIncludedInput" id="cdktfprovideroktaappsignonpolicyrulepropertyusertypesincludedinput"></a>

```typescript
public readonly userTypesIncludedInput: string[];
```

- *Type:* `string`[]

---

##### `access`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSignonPolicyRule.property.access" id="cdktfprovideroktaappsignonpolicyrulepropertyaccess"></a>

```typescript
public readonly access: string;
```

- *Type:* `string`

---

##### `constraints`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSignonPolicyRule.property.constraints" id="cdktfprovideroktaappsignonpolicyrulepropertyconstraints"></a>

```typescript
public readonly constraints: string[];
```

- *Type:* `string`[]

---

##### `customExpression`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSignonPolicyRule.property.customExpression" id="cdktfprovideroktaappsignonpolicyrulepropertycustomexpression"></a>

```typescript
public readonly customExpression: string;
```

- *Type:* `string`

---

##### `deviceIsManaged`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSignonPolicyRule.property.deviceIsManaged" id="cdktfprovideroktaappsignonpolicyrulepropertydeviceismanaged"></a>

```typescript
public readonly deviceIsManaged: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `deviceIsRegistered`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSignonPolicyRule.property.deviceIsRegistered" id="cdktfprovideroktaappsignonpolicyrulepropertydeviceisregistered"></a>

```typescript
public readonly deviceIsRegistered: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `factorMode`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSignonPolicyRule.property.factorMode" id="cdktfprovideroktaappsignonpolicyrulepropertyfactormode"></a>

```typescript
public readonly factorMode: string;
```

- *Type:* `string`

---

##### `groupsExcluded`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSignonPolicyRule.property.groupsExcluded" id="cdktfprovideroktaappsignonpolicyrulepropertygroupsexcluded"></a>

```typescript
public readonly groupsExcluded: string[];
```

- *Type:* `string`[]

---

##### `groupsIncluded`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSignonPolicyRule.property.groupsIncluded" id="cdktfprovideroktaappsignonpolicyrulepropertygroupsincluded"></a>

```typescript
public readonly groupsIncluded: string[];
```

- *Type:* `string`[]

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSignonPolicyRule.property.id" id="cdktfprovideroktaappsignonpolicyrulepropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `inactivityPeriod`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSignonPolicyRule.property.inactivityPeriod" id="cdktfprovideroktaappsignonpolicyrulepropertyinactivityperiod"></a>

```typescript
public readonly inactivityPeriod: string;
```

- *Type:* `string`

---

##### `name`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSignonPolicyRule.property.name" id="cdktfprovideroktaappsignonpolicyrulepropertyname"></a>

```typescript
public readonly name: string;
```

- *Type:* `string`

---

##### `networkConnection`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSignonPolicyRule.property.networkConnection" id="cdktfprovideroktaappsignonpolicyrulepropertynetworkconnection"></a>

```typescript
public readonly networkConnection: string;
```

- *Type:* `string`

---

##### `networkExcludes`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSignonPolicyRule.property.networkExcludes" id="cdktfprovideroktaappsignonpolicyrulepropertynetworkexcludes"></a>

```typescript
public readonly networkExcludes: string[];
```

- *Type:* `string`[]

---

##### `networkIncludes`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSignonPolicyRule.property.networkIncludes" id="cdktfprovideroktaappsignonpolicyrulepropertynetworkincludes"></a>

```typescript
public readonly networkIncludes: string[];
```

- *Type:* `string`[]

---

##### `policyId`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSignonPolicyRule.property.policyId" id="cdktfprovideroktaappsignonpolicyrulepropertypolicyid"></a>

```typescript
public readonly policyId: string;
```

- *Type:* `string`

---

##### `priority`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSignonPolicyRule.property.priority" id="cdktfprovideroktaappsignonpolicyrulepropertypriority"></a>

```typescript
public readonly priority: number;
```

- *Type:* `number`

---

##### `reAuthenticationFrequency`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSignonPolicyRule.property.reAuthenticationFrequency" id="cdktfprovideroktaappsignonpolicyrulepropertyreauthenticationfrequency"></a>

```typescript
public readonly reAuthenticationFrequency: string;
```

- *Type:* `string`

---

##### `status`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSignonPolicyRule.property.status" id="cdktfprovideroktaappsignonpolicyrulepropertystatus"></a>

```typescript
public readonly status: string;
```

- *Type:* `string`

---

##### `type`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSignonPolicyRule.property.type" id="cdktfprovideroktaappsignonpolicyrulepropertytype"></a>

```typescript
public readonly type: string;
```

- *Type:* `string`

---

##### `usersExcluded`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSignonPolicyRule.property.usersExcluded" id="cdktfprovideroktaappsignonpolicyrulepropertyusersexcluded"></a>

```typescript
public readonly usersExcluded: string[];
```

- *Type:* `string`[]

---

##### `usersIncluded`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSignonPolicyRule.property.usersIncluded" id="cdktfprovideroktaappsignonpolicyrulepropertyusersincluded"></a>

```typescript
public readonly usersIncluded: string[];
```

- *Type:* `string`[]

---

##### `userTypesExcluded`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSignonPolicyRule.property.userTypesExcluded" id="cdktfprovideroktaappsignonpolicyrulepropertyusertypesexcluded"></a>

```typescript
public readonly userTypesExcluded: string[];
```

- *Type:* `string`[]

---

##### `userTypesIncluded`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSignonPolicyRule.property.userTypesIncluded" id="cdktfprovideroktaappsignonpolicyrulepropertyusertypesincluded"></a>

```typescript
public readonly userTypesIncluded: string[];
```

- *Type:* `string`[]

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktaappsignonpolicyrulepropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.AppSignonPolicyRule.property.tfResourceType" id="cdktfprovideroktaappsignonpolicyrulepropertytfresourcetype"></a>

- *Type:* `string`

---

### AppSwa <a name="@cdktf/provider-okta.AppSwa" id="cdktfprovideroktaappswa"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/r/app_swa okta_app_swa}.

#### Initializers <a name="@cdktf/provider-okta.AppSwa.Initializer" id="cdktfprovideroktaappswainitializer"></a>

```typescript
import { AppSwa } from '@cdktf/provider-okta'

new AppSwa(scope: Construct, id: string, config: AppSwaConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktaappswaparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktaappswaparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktaappswaparameterconfig)<span title="Required">*</span> | [`@cdktf/provider-okta.AppSwaConfig`](#@cdktf/provider-okta.AppSwaConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSwa.parameter.scope" id="cdktfprovideroktaappswaparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSwa.parameter.id" id="cdktfprovideroktaappswaparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSwa.parameter.config" id="cdktfprovideroktaappswaparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.AppSwaConfig`](#@cdktf/provider-okta.AppSwaConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`putTimeouts`](#cdktfprovideroktaappswaputtimeouts) | *No description.* |
| [`putUsers`](#cdktfprovideroktaappswaputusers) | *No description.* |
| [`resetAccessibilityErrorRedirectUrl`](#cdktfprovideroktaappswaresetaccessibilityerrorredirecturl) | *No description.* |
| [`resetAccessibilityLoginRedirectUrl`](#cdktfprovideroktaappswaresetaccessibilityloginredirecturl) | *No description.* |
| [`resetAccessibilitySelfService`](#cdktfprovideroktaappswaresetaccessibilityselfservice) | *No description.* |
| [`resetAdminNote`](#cdktfprovideroktaappswaresetadminnote) | *No description.* |
| [`resetAppLinksJson`](#cdktfprovideroktaappswaresetapplinksjson) | *No description.* |
| [`resetAutoSubmitToolbar`](#cdktfprovideroktaappswaresetautosubmittoolbar) | *No description.* |
| [`resetButtonField`](#cdktfprovideroktaappswaresetbuttonfield) | *No description.* |
| [`resetCheckbox`](#cdktfprovideroktaappswaresetcheckbox) | *No description.* |
| [`resetEnduserNote`](#cdktfprovideroktaappswaresetendusernote) | *No description.* |
| [`resetGroups`](#cdktfprovideroktaappswaresetgroups) | *No description.* |
| [`resetHideIos`](#cdktfprovideroktaappswaresethideios) | *No description.* |
| [`resetHideWeb`](#cdktfprovideroktaappswaresethideweb) | *No description.* |
| [`resetId`](#cdktfprovideroktaappswaresetid) | *No description.* |
| [`resetLogo`](#cdktfprovideroktaappswaresetlogo) | *No description.* |
| [`resetPasswordField`](#cdktfprovideroktaappswaresetpasswordfield) | *No description.* |
| [`resetPreconfiguredApp`](#cdktfprovideroktaappswaresetpreconfiguredapp) | *No description.* |
| [`resetRedirectUrl`](#cdktfprovideroktaappswaresetredirecturl) | *No description.* |
| [`resetSkipGroups`](#cdktfprovideroktaappswaresetskipgroups) | *No description.* |
| [`resetSkipUsers`](#cdktfprovideroktaappswaresetskipusers) | *No description.* |
| [`resetStatus`](#cdktfprovideroktaappswaresetstatus) | *No description.* |
| [`resetTimeouts`](#cdktfprovideroktaappswaresettimeouts) | *No description.* |
| [`resetUrl`](#cdktfprovideroktaappswareseturl) | *No description.* |
| [`resetUrlRegex`](#cdktfprovideroktaappswareseturlregex) | *No description.* |
| [`resetUsernameField`](#cdktfprovideroktaappswaresetusernamefield) | *No description.* |
| [`resetUserNameTemplate`](#cdktfprovideroktaappswaresetusernametemplate) | *No description.* |
| [`resetUserNameTemplatePushStatus`](#cdktfprovideroktaappswaresetusernametemplatepushstatus) | *No description.* |
| [`resetUserNameTemplateSuffix`](#cdktfprovideroktaappswaresetusernametemplatesuffix) | *No description.* |
| [`resetUserNameTemplateType`](#cdktfprovideroktaappswaresetusernametemplatetype) | *No description.* |
| [`resetUsers`](#cdktfprovideroktaappswaresetusers) | *No description.* |

---

##### `putTimeouts` <a name="@cdktf/provider-okta.AppSwa.putTimeouts" id="cdktfprovideroktaappswaputtimeouts"></a>

```typescript
public putTimeouts(value: AppSwaTimeouts)
```

###### `value`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSwa.parameter.value" id="cdktfprovideroktaappswaparametervalue"></a>

- *Type:* [`@cdktf/provider-okta.AppSwaTimeouts`](#@cdktf/provider-okta.AppSwaTimeouts)

---

##### `putUsers` <a name="@cdktf/provider-okta.AppSwa.putUsers" id="cdktfprovideroktaappswaputusers"></a>

```typescript
public putUsers(value: IResolvable | AppSwaUsers[])
```

###### `value`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSwa.parameter.value" id="cdktfprovideroktaappswaparametervalue"></a>

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable) | [`@cdktf/provider-okta.AppSwaUsers`](#@cdktf/provider-okta.AppSwaUsers)[]

---

##### `resetAccessibilityErrorRedirectUrl` <a name="@cdktf/provider-okta.AppSwa.resetAccessibilityErrorRedirectUrl" id="cdktfprovideroktaappswaresetaccessibilityerrorredirecturl"></a>

```typescript
public resetAccessibilityErrorRedirectUrl()
```

##### `resetAccessibilityLoginRedirectUrl` <a name="@cdktf/provider-okta.AppSwa.resetAccessibilityLoginRedirectUrl" id="cdktfprovideroktaappswaresetaccessibilityloginredirecturl"></a>

```typescript
public resetAccessibilityLoginRedirectUrl()
```

##### `resetAccessibilitySelfService` <a name="@cdktf/provider-okta.AppSwa.resetAccessibilitySelfService" id="cdktfprovideroktaappswaresetaccessibilityselfservice"></a>

```typescript
public resetAccessibilitySelfService()
```

##### `resetAdminNote` <a name="@cdktf/provider-okta.AppSwa.resetAdminNote" id="cdktfprovideroktaappswaresetadminnote"></a>

```typescript
public resetAdminNote()
```

##### `resetAppLinksJson` <a name="@cdktf/provider-okta.AppSwa.resetAppLinksJson" id="cdktfprovideroktaappswaresetapplinksjson"></a>

```typescript
public resetAppLinksJson()
```

##### `resetAutoSubmitToolbar` <a name="@cdktf/provider-okta.AppSwa.resetAutoSubmitToolbar" id="cdktfprovideroktaappswaresetautosubmittoolbar"></a>

```typescript
public resetAutoSubmitToolbar()
```

##### `resetButtonField` <a name="@cdktf/provider-okta.AppSwa.resetButtonField" id="cdktfprovideroktaappswaresetbuttonfield"></a>

```typescript
public resetButtonField()
```

##### `resetCheckbox` <a name="@cdktf/provider-okta.AppSwa.resetCheckbox" id="cdktfprovideroktaappswaresetcheckbox"></a>

```typescript
public resetCheckbox()
```

##### `resetEnduserNote` <a name="@cdktf/provider-okta.AppSwa.resetEnduserNote" id="cdktfprovideroktaappswaresetendusernote"></a>

```typescript
public resetEnduserNote()
```

##### `resetGroups` <a name="@cdktf/provider-okta.AppSwa.resetGroups" id="cdktfprovideroktaappswaresetgroups"></a>

```typescript
public resetGroups()
```

##### `resetHideIos` <a name="@cdktf/provider-okta.AppSwa.resetHideIos" id="cdktfprovideroktaappswaresethideios"></a>

```typescript
public resetHideIos()
```

##### `resetHideWeb` <a name="@cdktf/provider-okta.AppSwa.resetHideWeb" id="cdktfprovideroktaappswaresethideweb"></a>

```typescript
public resetHideWeb()
```

##### `resetId` <a name="@cdktf/provider-okta.AppSwa.resetId" id="cdktfprovideroktaappswaresetid"></a>

```typescript
public resetId()
```

##### `resetLogo` <a name="@cdktf/provider-okta.AppSwa.resetLogo" id="cdktfprovideroktaappswaresetlogo"></a>

```typescript
public resetLogo()
```

##### `resetPasswordField` <a name="@cdktf/provider-okta.AppSwa.resetPasswordField" id="cdktfprovideroktaappswaresetpasswordfield"></a>

```typescript
public resetPasswordField()
```

##### `resetPreconfiguredApp` <a name="@cdktf/provider-okta.AppSwa.resetPreconfiguredApp" id="cdktfprovideroktaappswaresetpreconfiguredapp"></a>

```typescript
public resetPreconfiguredApp()
```

##### `resetRedirectUrl` <a name="@cdktf/provider-okta.AppSwa.resetRedirectUrl" id="cdktfprovideroktaappswaresetredirecturl"></a>

```typescript
public resetRedirectUrl()
```

##### `resetSkipGroups` <a name="@cdktf/provider-okta.AppSwa.resetSkipGroups" id="cdktfprovideroktaappswaresetskipgroups"></a>

```typescript
public resetSkipGroups()
```

##### `resetSkipUsers` <a name="@cdktf/provider-okta.AppSwa.resetSkipUsers" id="cdktfprovideroktaappswaresetskipusers"></a>

```typescript
public resetSkipUsers()
```

##### `resetStatus` <a name="@cdktf/provider-okta.AppSwa.resetStatus" id="cdktfprovideroktaappswaresetstatus"></a>

```typescript
public resetStatus()
```

##### `resetTimeouts` <a name="@cdktf/provider-okta.AppSwa.resetTimeouts" id="cdktfprovideroktaappswaresettimeouts"></a>

```typescript
public resetTimeouts()
```

##### `resetUrl` <a name="@cdktf/provider-okta.AppSwa.resetUrl" id="cdktfprovideroktaappswareseturl"></a>

```typescript
public resetUrl()
```

##### `resetUrlRegex` <a name="@cdktf/provider-okta.AppSwa.resetUrlRegex" id="cdktfprovideroktaappswareseturlregex"></a>

```typescript
public resetUrlRegex()
```

##### `resetUsernameField` <a name="@cdktf/provider-okta.AppSwa.resetUsernameField" id="cdktfprovideroktaappswaresetusernamefield"></a>

```typescript
public resetUsernameField()
```

##### `resetUserNameTemplate` <a name="@cdktf/provider-okta.AppSwa.resetUserNameTemplate" id="cdktfprovideroktaappswaresetusernametemplate"></a>

```typescript
public resetUserNameTemplate()
```

##### `resetUserNameTemplatePushStatus` <a name="@cdktf/provider-okta.AppSwa.resetUserNameTemplatePushStatus" id="cdktfprovideroktaappswaresetusernametemplatepushstatus"></a>

```typescript
public resetUserNameTemplatePushStatus()
```

##### `resetUserNameTemplateSuffix` <a name="@cdktf/provider-okta.AppSwa.resetUserNameTemplateSuffix" id="cdktfprovideroktaappswaresetusernametemplatesuffix"></a>

```typescript
public resetUserNameTemplateSuffix()
```

##### `resetUserNameTemplateType` <a name="@cdktf/provider-okta.AppSwa.resetUserNameTemplateType" id="cdktfprovideroktaappswaresetusernametemplatetype"></a>

```typescript
public resetUserNameTemplateType()
```

##### `resetUsers` <a name="@cdktf/provider-okta.AppSwa.resetUsers" id="cdktfprovideroktaappswaresetusers"></a>

```typescript
public resetUsers()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`logoUrl`](#cdktfprovideroktaappswapropertylogourl)<span title="Required">*</span> | `string` | *No description.* |
| [`name`](#cdktfprovideroktaappswapropertyname)<span title="Required">*</span> | `string` | *No description.* |
| [`signOnMode`](#cdktfprovideroktaappswapropertysignonmode)<span title="Required">*</span> | `string` | *No description.* |
| [`timeouts`](#cdktfprovideroktaappswapropertytimeouts)<span title="Required">*</span> | [`@cdktf/provider-okta.AppSwaTimeoutsOutputReference`](#@cdktf/provider-okta.AppSwaTimeoutsOutputReference) | *No description.* |
| [`users`](#cdktfprovideroktaappswapropertyusers)<span title="Required">*</span> | [`@cdktf/provider-okta.AppSwaUsersList`](#@cdktf/provider-okta.AppSwaUsersList) | *No description.* |
| [`accessibilityErrorRedirectUrlInput`](#cdktfprovideroktaappswapropertyaccessibilityerrorredirecturlinput) | `string` | *No description.* |
| [`accessibilityLoginRedirectUrlInput`](#cdktfprovideroktaappswapropertyaccessibilityloginredirecturlinput) | `string` | *No description.* |
| [`accessibilitySelfServiceInput`](#cdktfprovideroktaappswapropertyaccessibilityselfserviceinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`adminNoteInput`](#cdktfprovideroktaappswapropertyadminnoteinput) | `string` | *No description.* |
| [`appLinksJsonInput`](#cdktfprovideroktaappswapropertyapplinksjsoninput) | `string` | *No description.* |
| [`autoSubmitToolbarInput`](#cdktfprovideroktaappswapropertyautosubmittoolbarinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`buttonFieldInput`](#cdktfprovideroktaappswapropertybuttonfieldinput) | `string` | *No description.* |
| [`checkboxInput`](#cdktfprovideroktaappswapropertycheckboxinput) | `string` | *No description.* |
| [`enduserNoteInput`](#cdktfprovideroktaappswapropertyendusernoteinput) | `string` | *No description.* |
| [`groupsInput`](#cdktfprovideroktaappswapropertygroupsinput) | `string`[] | *No description.* |
| [`hideIosInput`](#cdktfprovideroktaappswapropertyhideiosinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`hideWebInput`](#cdktfprovideroktaappswapropertyhidewebinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`idInput`](#cdktfprovideroktaappswapropertyidinput) | `string` | *No description.* |
| [`labelInput`](#cdktfprovideroktaappswapropertylabelinput) | `string` | *No description.* |
| [`logoInput`](#cdktfprovideroktaappswapropertylogoinput) | `string` | *No description.* |
| [`passwordFieldInput`](#cdktfprovideroktaappswapropertypasswordfieldinput) | `string` | *No description.* |
| [`preconfiguredAppInput`](#cdktfprovideroktaappswapropertypreconfiguredappinput) | `string` | *No description.* |
| [`redirectUrlInput`](#cdktfprovideroktaappswapropertyredirecturlinput) | `string` | *No description.* |
| [`skipGroupsInput`](#cdktfprovideroktaappswapropertyskipgroupsinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`skipUsersInput`](#cdktfprovideroktaappswapropertyskipusersinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`statusInput`](#cdktfprovideroktaappswapropertystatusinput) | `string` | *No description.* |
| [`timeoutsInput`](#cdktfprovideroktaappswapropertytimeoutsinput) | [`cdktf.IResolvable`](#cdktf.IResolvable) \| [`@cdktf/provider-okta.AppSwaTimeouts`](#@cdktf/provider-okta.AppSwaTimeouts) | *No description.* |
| [`urlInput`](#cdktfprovideroktaappswapropertyurlinput) | `string` | *No description.* |
| [`urlRegexInput`](#cdktfprovideroktaappswapropertyurlregexinput) | `string` | *No description.* |
| [`usernameFieldInput`](#cdktfprovideroktaappswapropertyusernamefieldinput) | `string` | *No description.* |
| [`userNameTemplateInput`](#cdktfprovideroktaappswapropertyusernametemplateinput) | `string` | *No description.* |
| [`userNameTemplatePushStatusInput`](#cdktfprovideroktaappswapropertyusernametemplatepushstatusinput) | `string` | *No description.* |
| [`userNameTemplateSuffixInput`](#cdktfprovideroktaappswapropertyusernametemplatesuffixinput) | `string` | *No description.* |
| [`userNameTemplateTypeInput`](#cdktfprovideroktaappswapropertyusernametemplatetypeinput) | `string` | *No description.* |
| [`usersInput`](#cdktfprovideroktaappswapropertyusersinput) | [`cdktf.IResolvable`](#cdktf.IResolvable) \| [`@cdktf/provider-okta.AppSwaUsers`](#@cdktf/provider-okta.AppSwaUsers)[] | *No description.* |
| [`accessibilityErrorRedirectUrl`](#cdktfprovideroktaappswapropertyaccessibilityerrorredirecturl)<span title="Required">*</span> | `string` | *No description.* |
| [`accessibilityLoginRedirectUrl`](#cdktfprovideroktaappswapropertyaccessibilityloginredirecturl)<span title="Required">*</span> | `string` | *No description.* |
| [`accessibilitySelfService`](#cdktfprovideroktaappswapropertyaccessibilityselfservice)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`adminNote`](#cdktfprovideroktaappswapropertyadminnote)<span title="Required">*</span> | `string` | *No description.* |
| [`appLinksJson`](#cdktfprovideroktaappswapropertyapplinksjson)<span title="Required">*</span> | `string` | *No description.* |
| [`autoSubmitToolbar`](#cdktfprovideroktaappswapropertyautosubmittoolbar)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`buttonField`](#cdktfprovideroktaappswapropertybuttonfield)<span title="Required">*</span> | `string` | *No description.* |
| [`checkbox`](#cdktfprovideroktaappswapropertycheckbox)<span title="Required">*</span> | `string` | *No description.* |
| [`enduserNote`](#cdktfprovideroktaappswapropertyendusernote)<span title="Required">*</span> | `string` | *No description.* |
| [`groups`](#cdktfprovideroktaappswapropertygroups)<span title="Required">*</span> | `string`[] | *No description.* |
| [`hideIos`](#cdktfprovideroktaappswapropertyhideios)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`hideWeb`](#cdktfprovideroktaappswapropertyhideweb)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`id`](#cdktfprovideroktaappswapropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`label`](#cdktfprovideroktaappswapropertylabel)<span title="Required">*</span> | `string` | *No description.* |
| [`logo`](#cdktfprovideroktaappswapropertylogo)<span title="Required">*</span> | `string` | *No description.* |
| [`passwordField`](#cdktfprovideroktaappswapropertypasswordfield)<span title="Required">*</span> | `string` | *No description.* |
| [`preconfiguredApp`](#cdktfprovideroktaappswapropertypreconfiguredapp)<span title="Required">*</span> | `string` | *No description.* |
| [`redirectUrl`](#cdktfprovideroktaappswapropertyredirecturl)<span title="Required">*</span> | `string` | *No description.* |
| [`skipGroups`](#cdktfprovideroktaappswapropertyskipgroups)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`skipUsers`](#cdktfprovideroktaappswapropertyskipusers)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`status`](#cdktfprovideroktaappswapropertystatus)<span title="Required">*</span> | `string` | *No description.* |
| [`url`](#cdktfprovideroktaappswapropertyurl)<span title="Required">*</span> | `string` | *No description.* |
| [`urlRegex`](#cdktfprovideroktaappswapropertyurlregex)<span title="Required">*</span> | `string` | *No description.* |
| [`usernameField`](#cdktfprovideroktaappswapropertyusernamefield)<span title="Required">*</span> | `string` | *No description.* |
| [`userNameTemplate`](#cdktfprovideroktaappswapropertyusernametemplate)<span title="Required">*</span> | `string` | *No description.* |
| [`userNameTemplatePushStatus`](#cdktfprovideroktaappswapropertyusernametemplatepushstatus)<span title="Required">*</span> | `string` | *No description.* |
| [`userNameTemplateSuffix`](#cdktfprovideroktaappswapropertyusernametemplatesuffix)<span title="Required">*</span> | `string` | *No description.* |
| [`userNameTemplateType`](#cdktfprovideroktaappswapropertyusernametemplatetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `logoUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSwa.property.logoUrl" id="cdktfprovideroktaappswapropertylogourl"></a>

```typescript
public readonly logoUrl: string;
```

- *Type:* `string`

---

##### `name`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSwa.property.name" id="cdktfprovideroktaappswapropertyname"></a>

```typescript
public readonly name: string;
```

- *Type:* `string`

---

##### `signOnMode`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSwa.property.signOnMode" id="cdktfprovideroktaappswapropertysignonmode"></a>

```typescript
public readonly signOnMode: string;
```

- *Type:* `string`

---

##### `timeouts`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSwa.property.timeouts" id="cdktfprovideroktaappswapropertytimeouts"></a>

```typescript
public readonly timeouts: AppSwaTimeoutsOutputReference;
```

- *Type:* [`@cdktf/provider-okta.AppSwaTimeoutsOutputReference`](#@cdktf/provider-okta.AppSwaTimeoutsOutputReference)

---

##### `users`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSwa.property.users" id="cdktfprovideroktaappswapropertyusers"></a>

```typescript
public readonly users: AppSwaUsersList;
```

- *Type:* [`@cdktf/provider-okta.AppSwaUsersList`](#@cdktf/provider-okta.AppSwaUsersList)

---

##### `accessibilityErrorRedirectUrlInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSwa.property.accessibilityErrorRedirectUrlInput" id="cdktfprovideroktaappswapropertyaccessibilityerrorredirecturlinput"></a>

```typescript
public readonly accessibilityErrorRedirectUrlInput: string;
```

- *Type:* `string`

---

##### `accessibilityLoginRedirectUrlInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSwa.property.accessibilityLoginRedirectUrlInput" id="cdktfprovideroktaappswapropertyaccessibilityloginredirecturlinput"></a>

```typescript
public readonly accessibilityLoginRedirectUrlInput: string;
```

- *Type:* `string`

---

##### `accessibilitySelfServiceInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSwa.property.accessibilitySelfServiceInput" id="cdktfprovideroktaappswapropertyaccessibilityselfserviceinput"></a>

```typescript
public readonly accessibilitySelfServiceInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `adminNoteInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSwa.property.adminNoteInput" id="cdktfprovideroktaappswapropertyadminnoteinput"></a>

```typescript
public readonly adminNoteInput: string;
```

- *Type:* `string`

---

##### `appLinksJsonInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSwa.property.appLinksJsonInput" id="cdktfprovideroktaappswapropertyapplinksjsoninput"></a>

```typescript
public readonly appLinksJsonInput: string;
```

- *Type:* `string`

---

##### `autoSubmitToolbarInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSwa.property.autoSubmitToolbarInput" id="cdktfprovideroktaappswapropertyautosubmittoolbarinput"></a>

```typescript
public readonly autoSubmitToolbarInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `buttonFieldInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSwa.property.buttonFieldInput" id="cdktfprovideroktaappswapropertybuttonfieldinput"></a>

```typescript
public readonly buttonFieldInput: string;
```

- *Type:* `string`

---

##### `checkboxInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSwa.property.checkboxInput" id="cdktfprovideroktaappswapropertycheckboxinput"></a>

```typescript
public readonly checkboxInput: string;
```

- *Type:* `string`

---

##### `enduserNoteInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSwa.property.enduserNoteInput" id="cdktfprovideroktaappswapropertyendusernoteinput"></a>

```typescript
public readonly enduserNoteInput: string;
```

- *Type:* `string`

---

##### `groupsInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSwa.property.groupsInput" id="cdktfprovideroktaappswapropertygroupsinput"></a>

```typescript
public readonly groupsInput: string[];
```

- *Type:* `string`[]

---

##### `hideIosInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSwa.property.hideIosInput" id="cdktfprovideroktaappswapropertyhideiosinput"></a>

```typescript
public readonly hideIosInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `hideWebInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSwa.property.hideWebInput" id="cdktfprovideroktaappswapropertyhidewebinput"></a>

```typescript
public readonly hideWebInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSwa.property.idInput" id="cdktfprovideroktaappswapropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `labelInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSwa.property.labelInput" id="cdktfprovideroktaappswapropertylabelinput"></a>

```typescript
public readonly labelInput: string;
```

- *Type:* `string`

---

##### `logoInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSwa.property.logoInput" id="cdktfprovideroktaappswapropertylogoinput"></a>

```typescript
public readonly logoInput: string;
```

- *Type:* `string`

---

##### `passwordFieldInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSwa.property.passwordFieldInput" id="cdktfprovideroktaappswapropertypasswordfieldinput"></a>

```typescript
public readonly passwordFieldInput: string;
```

- *Type:* `string`

---

##### `preconfiguredAppInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSwa.property.preconfiguredAppInput" id="cdktfprovideroktaappswapropertypreconfiguredappinput"></a>

```typescript
public readonly preconfiguredAppInput: string;
```

- *Type:* `string`

---

##### `redirectUrlInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSwa.property.redirectUrlInput" id="cdktfprovideroktaappswapropertyredirecturlinput"></a>

```typescript
public readonly redirectUrlInput: string;
```

- *Type:* `string`

---

##### `skipGroupsInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSwa.property.skipGroupsInput" id="cdktfprovideroktaappswapropertyskipgroupsinput"></a>

```typescript
public readonly skipGroupsInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `skipUsersInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSwa.property.skipUsersInput" id="cdktfprovideroktaappswapropertyskipusersinput"></a>

```typescript
public readonly skipUsersInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `statusInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSwa.property.statusInput" id="cdktfprovideroktaappswapropertystatusinput"></a>

```typescript
public readonly statusInput: string;
```

- *Type:* `string`

---

##### `timeoutsInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSwa.property.timeoutsInput" id="cdktfprovideroktaappswapropertytimeoutsinput"></a>

```typescript
public readonly timeoutsInput: IResolvable | AppSwaTimeouts;
```

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable) | [`@cdktf/provider-okta.AppSwaTimeouts`](#@cdktf/provider-okta.AppSwaTimeouts)

---

##### `urlInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSwa.property.urlInput" id="cdktfprovideroktaappswapropertyurlinput"></a>

```typescript
public readonly urlInput: string;
```

- *Type:* `string`

---

##### `urlRegexInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSwa.property.urlRegexInput" id="cdktfprovideroktaappswapropertyurlregexinput"></a>

```typescript
public readonly urlRegexInput: string;
```

- *Type:* `string`

---

##### `usernameFieldInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSwa.property.usernameFieldInput" id="cdktfprovideroktaappswapropertyusernamefieldinput"></a>

```typescript
public readonly usernameFieldInput: string;
```

- *Type:* `string`

---

##### `userNameTemplateInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSwa.property.userNameTemplateInput" id="cdktfprovideroktaappswapropertyusernametemplateinput"></a>

```typescript
public readonly userNameTemplateInput: string;
```

- *Type:* `string`

---

##### `userNameTemplatePushStatusInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSwa.property.userNameTemplatePushStatusInput" id="cdktfprovideroktaappswapropertyusernametemplatepushstatusinput"></a>

```typescript
public readonly userNameTemplatePushStatusInput: string;
```

- *Type:* `string`

---

##### `userNameTemplateSuffixInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSwa.property.userNameTemplateSuffixInput" id="cdktfprovideroktaappswapropertyusernametemplatesuffixinput"></a>

```typescript
public readonly userNameTemplateSuffixInput: string;
```

- *Type:* `string`

---

##### `userNameTemplateTypeInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSwa.property.userNameTemplateTypeInput" id="cdktfprovideroktaappswapropertyusernametemplatetypeinput"></a>

```typescript
public readonly userNameTemplateTypeInput: string;
```

- *Type:* `string`

---

##### `usersInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppSwa.property.usersInput" id="cdktfprovideroktaappswapropertyusersinput"></a>

```typescript
public readonly usersInput: IResolvable | AppSwaUsers[];
```

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable) | [`@cdktf/provider-okta.AppSwaUsers`](#@cdktf/provider-okta.AppSwaUsers)[]

---

##### `accessibilityErrorRedirectUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSwa.property.accessibilityErrorRedirectUrl" id="cdktfprovideroktaappswapropertyaccessibilityerrorredirecturl"></a>

```typescript
public readonly accessibilityErrorRedirectUrl: string;
```

- *Type:* `string`

---

##### `accessibilityLoginRedirectUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSwa.property.accessibilityLoginRedirectUrl" id="cdktfprovideroktaappswapropertyaccessibilityloginredirecturl"></a>

```typescript
public readonly accessibilityLoginRedirectUrl: string;
```

- *Type:* `string`

---

##### `accessibilitySelfService`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSwa.property.accessibilitySelfService" id="cdktfprovideroktaappswapropertyaccessibilityselfservice"></a>

```typescript
public readonly accessibilitySelfService: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `adminNote`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSwa.property.adminNote" id="cdktfprovideroktaappswapropertyadminnote"></a>

```typescript
public readonly adminNote: string;
```

- *Type:* `string`

---

##### `appLinksJson`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSwa.property.appLinksJson" id="cdktfprovideroktaappswapropertyapplinksjson"></a>

```typescript
public readonly appLinksJson: string;
```

- *Type:* `string`

---

##### `autoSubmitToolbar`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSwa.property.autoSubmitToolbar" id="cdktfprovideroktaappswapropertyautosubmittoolbar"></a>

```typescript
public readonly autoSubmitToolbar: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `buttonField`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSwa.property.buttonField" id="cdktfprovideroktaappswapropertybuttonfield"></a>

```typescript
public readonly buttonField: string;
```

- *Type:* `string`

---

##### `checkbox`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSwa.property.checkbox" id="cdktfprovideroktaappswapropertycheckbox"></a>

```typescript
public readonly checkbox: string;
```

- *Type:* `string`

---

##### `enduserNote`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSwa.property.enduserNote" id="cdktfprovideroktaappswapropertyendusernote"></a>

```typescript
public readonly enduserNote: string;
```

- *Type:* `string`

---

##### `groups`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSwa.property.groups" id="cdktfprovideroktaappswapropertygroups"></a>

```typescript
public readonly groups: string[];
```

- *Type:* `string`[]

---

##### `hideIos`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSwa.property.hideIos" id="cdktfprovideroktaappswapropertyhideios"></a>

```typescript
public readonly hideIos: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `hideWeb`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSwa.property.hideWeb" id="cdktfprovideroktaappswapropertyhideweb"></a>

```typescript
public readonly hideWeb: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSwa.property.id" id="cdktfprovideroktaappswapropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `label`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSwa.property.label" id="cdktfprovideroktaappswapropertylabel"></a>

```typescript
public readonly label: string;
```

- *Type:* `string`

---

##### `logo`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSwa.property.logo" id="cdktfprovideroktaappswapropertylogo"></a>

```typescript
public readonly logo: string;
```

- *Type:* `string`

---

##### `passwordField`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSwa.property.passwordField" id="cdktfprovideroktaappswapropertypasswordfield"></a>

```typescript
public readonly passwordField: string;
```

- *Type:* `string`

---

##### `preconfiguredApp`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSwa.property.preconfiguredApp" id="cdktfprovideroktaappswapropertypreconfiguredapp"></a>

```typescript
public readonly preconfiguredApp: string;
```

- *Type:* `string`

---

##### `redirectUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSwa.property.redirectUrl" id="cdktfprovideroktaappswapropertyredirecturl"></a>

```typescript
public readonly redirectUrl: string;
```

- *Type:* `string`

---

##### `skipGroups`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSwa.property.skipGroups" id="cdktfprovideroktaappswapropertyskipgroups"></a>

```typescript
public readonly skipGroups: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `skipUsers`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSwa.property.skipUsers" id="cdktfprovideroktaappswapropertyskipusers"></a>

```typescript
public readonly skipUsers: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `status`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSwa.property.status" id="cdktfprovideroktaappswapropertystatus"></a>

```typescript
public readonly status: string;
```

- *Type:* `string`

---

##### `url`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSwa.property.url" id="cdktfprovideroktaappswapropertyurl"></a>

```typescript
public readonly url: string;
```

- *Type:* `string`

---

##### `urlRegex`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSwa.property.urlRegex" id="cdktfprovideroktaappswapropertyurlregex"></a>

```typescript
public readonly urlRegex: string;
```

- *Type:* `string`

---

##### `usernameField`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSwa.property.usernameField" id="cdktfprovideroktaappswapropertyusernamefield"></a>

```typescript
public readonly usernameField: string;
```

- *Type:* `string`

---

##### `userNameTemplate`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSwa.property.userNameTemplate" id="cdktfprovideroktaappswapropertyusernametemplate"></a>

```typescript
public readonly userNameTemplate: string;
```

- *Type:* `string`

---

##### `userNameTemplatePushStatus`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSwa.property.userNameTemplatePushStatus" id="cdktfprovideroktaappswapropertyusernametemplatepushstatus"></a>

```typescript
public readonly userNameTemplatePushStatus: string;
```

- *Type:* `string`

---

##### `userNameTemplateSuffix`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSwa.property.userNameTemplateSuffix" id="cdktfprovideroktaappswapropertyusernametemplatesuffix"></a>

```typescript
public readonly userNameTemplateSuffix: string;
```

- *Type:* `string`

---

##### `userNameTemplateType`<sup>Required</sup> <a name="@cdktf/provider-okta.AppSwa.property.userNameTemplateType" id="cdktfprovideroktaappswapropertyusernametemplatetype"></a>

```typescript
public readonly userNameTemplateType: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktaappswapropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.AppSwa.property.tfResourceType" id="cdktfprovideroktaappswapropertytfresourcetype"></a>

- *Type:* `string`

---

### AppThreeField <a name="@cdktf/provider-okta.AppThreeField" id="cdktfprovideroktaappthreefield"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/r/app_three_field okta_app_three_field}.

#### Initializers <a name="@cdktf/provider-okta.AppThreeField.Initializer" id="cdktfprovideroktaappthreefieldinitializer"></a>

```typescript
import { AppThreeField } from '@cdktf/provider-okta'

new AppThreeField(scope: Construct, id: string, config: AppThreeFieldConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktaappthreefieldparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktaappthreefieldparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktaappthreefieldparameterconfig)<span title="Required">*</span> | [`@cdktf/provider-okta.AppThreeFieldConfig`](#@cdktf/provider-okta.AppThreeFieldConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.AppThreeField.parameter.scope" id="cdktfprovideroktaappthreefieldparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AppThreeField.parameter.id" id="cdktfprovideroktaappthreefieldparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="@cdktf/provider-okta.AppThreeField.parameter.config" id="cdktfprovideroktaappthreefieldparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.AppThreeFieldConfig`](#@cdktf/provider-okta.AppThreeFieldConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`putTimeouts`](#cdktfprovideroktaappthreefieldputtimeouts) | *No description.* |
| [`putUsers`](#cdktfprovideroktaappthreefieldputusers) | *No description.* |
| [`resetAccessibilityErrorRedirectUrl`](#cdktfprovideroktaappthreefieldresetaccessibilityerrorredirecturl) | *No description.* |
| [`resetAccessibilityLoginRedirectUrl`](#cdktfprovideroktaappthreefieldresetaccessibilityloginredirecturl) | *No description.* |
| [`resetAccessibilitySelfService`](#cdktfprovideroktaappthreefieldresetaccessibilityselfservice) | *No description.* |
| [`resetAdminNote`](#cdktfprovideroktaappthreefieldresetadminnote) | *No description.* |
| [`resetAppLinksJson`](#cdktfprovideroktaappthreefieldresetapplinksjson) | *No description.* |
| [`resetAutoSubmitToolbar`](#cdktfprovideroktaappthreefieldresetautosubmittoolbar) | *No description.* |
| [`resetCredentialsScheme`](#cdktfprovideroktaappthreefieldresetcredentialsscheme) | *No description.* |
| [`resetEnduserNote`](#cdktfprovideroktaappthreefieldresetendusernote) | *No description.* |
| [`resetGroups`](#cdktfprovideroktaappthreefieldresetgroups) | *No description.* |
| [`resetHideIos`](#cdktfprovideroktaappthreefieldresethideios) | *No description.* |
| [`resetHideWeb`](#cdktfprovideroktaappthreefieldresethideweb) | *No description.* |
| [`resetId`](#cdktfprovideroktaappthreefieldresetid) | *No description.* |
| [`resetLogo`](#cdktfprovideroktaappthreefieldresetlogo) | *No description.* |
| [`resetRevealPassword`](#cdktfprovideroktaappthreefieldresetrevealpassword) | *No description.* |
| [`resetSharedPassword`](#cdktfprovideroktaappthreefieldresetsharedpassword) | *No description.* |
| [`resetSharedUsername`](#cdktfprovideroktaappthreefieldresetsharedusername) | *No description.* |
| [`resetSkipGroups`](#cdktfprovideroktaappthreefieldresetskipgroups) | *No description.* |
| [`resetSkipUsers`](#cdktfprovideroktaappthreefieldresetskipusers) | *No description.* |
| [`resetStatus`](#cdktfprovideroktaappthreefieldresetstatus) | *No description.* |
| [`resetTimeouts`](#cdktfprovideroktaappthreefieldresettimeouts) | *No description.* |
| [`resetUrlRegex`](#cdktfprovideroktaappthreefieldreseturlregex) | *No description.* |
| [`resetUserNameTemplate`](#cdktfprovideroktaappthreefieldresetusernametemplate) | *No description.* |
| [`resetUserNameTemplatePushStatus`](#cdktfprovideroktaappthreefieldresetusernametemplatepushstatus) | *No description.* |
| [`resetUserNameTemplateSuffix`](#cdktfprovideroktaappthreefieldresetusernametemplatesuffix) | *No description.* |
| [`resetUserNameTemplateType`](#cdktfprovideroktaappthreefieldresetusernametemplatetype) | *No description.* |
| [`resetUsers`](#cdktfprovideroktaappthreefieldresetusers) | *No description.* |

---

##### `putTimeouts` <a name="@cdktf/provider-okta.AppThreeField.putTimeouts" id="cdktfprovideroktaappthreefieldputtimeouts"></a>

```typescript
public putTimeouts(value: AppThreeFieldTimeouts)
```

###### `value`<sup>Required</sup> <a name="@cdktf/provider-okta.AppThreeField.parameter.value" id="cdktfprovideroktaappthreefieldparametervalue"></a>

- *Type:* [`@cdktf/provider-okta.AppThreeFieldTimeouts`](#@cdktf/provider-okta.AppThreeFieldTimeouts)

---

##### `putUsers` <a name="@cdktf/provider-okta.AppThreeField.putUsers" id="cdktfprovideroktaappthreefieldputusers"></a>

```typescript
public putUsers(value: IResolvable | AppThreeFieldUsers[])
```

###### `value`<sup>Required</sup> <a name="@cdktf/provider-okta.AppThreeField.parameter.value" id="cdktfprovideroktaappthreefieldparametervalue"></a>

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable) | [`@cdktf/provider-okta.AppThreeFieldUsers`](#@cdktf/provider-okta.AppThreeFieldUsers)[]

---

##### `resetAccessibilityErrorRedirectUrl` <a name="@cdktf/provider-okta.AppThreeField.resetAccessibilityErrorRedirectUrl" id="cdktfprovideroktaappthreefieldresetaccessibilityerrorredirecturl"></a>

```typescript
public resetAccessibilityErrorRedirectUrl()
```

##### `resetAccessibilityLoginRedirectUrl` <a name="@cdktf/provider-okta.AppThreeField.resetAccessibilityLoginRedirectUrl" id="cdktfprovideroktaappthreefieldresetaccessibilityloginredirecturl"></a>

```typescript
public resetAccessibilityLoginRedirectUrl()
```

##### `resetAccessibilitySelfService` <a name="@cdktf/provider-okta.AppThreeField.resetAccessibilitySelfService" id="cdktfprovideroktaappthreefieldresetaccessibilityselfservice"></a>

```typescript
public resetAccessibilitySelfService()
```

##### `resetAdminNote` <a name="@cdktf/provider-okta.AppThreeField.resetAdminNote" id="cdktfprovideroktaappthreefieldresetadminnote"></a>

```typescript
public resetAdminNote()
```

##### `resetAppLinksJson` <a name="@cdktf/provider-okta.AppThreeField.resetAppLinksJson" id="cdktfprovideroktaappthreefieldresetapplinksjson"></a>

```typescript
public resetAppLinksJson()
```

##### `resetAutoSubmitToolbar` <a name="@cdktf/provider-okta.AppThreeField.resetAutoSubmitToolbar" id="cdktfprovideroktaappthreefieldresetautosubmittoolbar"></a>

```typescript
public resetAutoSubmitToolbar()
```

##### `resetCredentialsScheme` <a name="@cdktf/provider-okta.AppThreeField.resetCredentialsScheme" id="cdktfprovideroktaappthreefieldresetcredentialsscheme"></a>

```typescript
public resetCredentialsScheme()
```

##### `resetEnduserNote` <a name="@cdktf/provider-okta.AppThreeField.resetEnduserNote" id="cdktfprovideroktaappthreefieldresetendusernote"></a>

```typescript
public resetEnduserNote()
```

##### `resetGroups` <a name="@cdktf/provider-okta.AppThreeField.resetGroups" id="cdktfprovideroktaappthreefieldresetgroups"></a>

```typescript
public resetGroups()
```

##### `resetHideIos` <a name="@cdktf/provider-okta.AppThreeField.resetHideIos" id="cdktfprovideroktaappthreefieldresethideios"></a>

```typescript
public resetHideIos()
```

##### `resetHideWeb` <a name="@cdktf/provider-okta.AppThreeField.resetHideWeb" id="cdktfprovideroktaappthreefieldresethideweb"></a>

```typescript
public resetHideWeb()
```

##### `resetId` <a name="@cdktf/provider-okta.AppThreeField.resetId" id="cdktfprovideroktaappthreefieldresetid"></a>

```typescript
public resetId()
```

##### `resetLogo` <a name="@cdktf/provider-okta.AppThreeField.resetLogo" id="cdktfprovideroktaappthreefieldresetlogo"></a>

```typescript
public resetLogo()
```

##### `resetRevealPassword` <a name="@cdktf/provider-okta.AppThreeField.resetRevealPassword" id="cdktfprovideroktaappthreefieldresetrevealpassword"></a>

```typescript
public resetRevealPassword()
```

##### `resetSharedPassword` <a name="@cdktf/provider-okta.AppThreeField.resetSharedPassword" id="cdktfprovideroktaappthreefieldresetsharedpassword"></a>

```typescript
public resetSharedPassword()
```

##### `resetSharedUsername` <a name="@cdktf/provider-okta.AppThreeField.resetSharedUsername" id="cdktfprovideroktaappthreefieldresetsharedusername"></a>

```typescript
public resetSharedUsername()
```

##### `resetSkipGroups` <a name="@cdktf/provider-okta.AppThreeField.resetSkipGroups" id="cdktfprovideroktaappthreefieldresetskipgroups"></a>

```typescript
public resetSkipGroups()
```

##### `resetSkipUsers` <a name="@cdktf/provider-okta.AppThreeField.resetSkipUsers" id="cdktfprovideroktaappthreefieldresetskipusers"></a>

```typescript
public resetSkipUsers()
```

##### `resetStatus` <a name="@cdktf/provider-okta.AppThreeField.resetStatus" id="cdktfprovideroktaappthreefieldresetstatus"></a>

```typescript
public resetStatus()
```

##### `resetTimeouts` <a name="@cdktf/provider-okta.AppThreeField.resetTimeouts" id="cdktfprovideroktaappthreefieldresettimeouts"></a>

```typescript
public resetTimeouts()
```

##### `resetUrlRegex` <a name="@cdktf/provider-okta.AppThreeField.resetUrlRegex" id="cdktfprovideroktaappthreefieldreseturlregex"></a>

```typescript
public resetUrlRegex()
```

##### `resetUserNameTemplate` <a name="@cdktf/provider-okta.AppThreeField.resetUserNameTemplate" id="cdktfprovideroktaappthreefieldresetusernametemplate"></a>

```typescript
public resetUserNameTemplate()
```

##### `resetUserNameTemplatePushStatus` <a name="@cdktf/provider-okta.AppThreeField.resetUserNameTemplatePushStatus" id="cdktfprovideroktaappthreefieldresetusernametemplatepushstatus"></a>

```typescript
public resetUserNameTemplatePushStatus()
```

##### `resetUserNameTemplateSuffix` <a name="@cdktf/provider-okta.AppThreeField.resetUserNameTemplateSuffix" id="cdktfprovideroktaappthreefieldresetusernametemplatesuffix"></a>

```typescript
public resetUserNameTemplateSuffix()
```

##### `resetUserNameTemplateType` <a name="@cdktf/provider-okta.AppThreeField.resetUserNameTemplateType" id="cdktfprovideroktaappthreefieldresetusernametemplatetype"></a>

```typescript
public resetUserNameTemplateType()
```

##### `resetUsers` <a name="@cdktf/provider-okta.AppThreeField.resetUsers" id="cdktfprovideroktaappthreefieldresetusers"></a>

```typescript
public resetUsers()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`logoUrl`](#cdktfprovideroktaappthreefieldpropertylogourl)<span title="Required">*</span> | `string` | *No description.* |
| [`name`](#cdktfprovideroktaappthreefieldpropertyname)<span title="Required">*</span> | `string` | *No description.* |
| [`signOnMode`](#cdktfprovideroktaappthreefieldpropertysignonmode)<span title="Required">*</span> | `string` | *No description.* |
| [`timeouts`](#cdktfprovideroktaappthreefieldpropertytimeouts)<span title="Required">*</span> | [`@cdktf/provider-okta.AppThreeFieldTimeoutsOutputReference`](#@cdktf/provider-okta.AppThreeFieldTimeoutsOutputReference) | *No description.* |
| [`users`](#cdktfprovideroktaappthreefieldpropertyusers)<span title="Required">*</span> | [`@cdktf/provider-okta.AppThreeFieldUsersList`](#@cdktf/provider-okta.AppThreeFieldUsersList) | *No description.* |
| [`accessibilityErrorRedirectUrlInput`](#cdktfprovideroktaappthreefieldpropertyaccessibilityerrorredirecturlinput) | `string` | *No description.* |
| [`accessibilityLoginRedirectUrlInput`](#cdktfprovideroktaappthreefieldpropertyaccessibilityloginredirecturlinput) | `string` | *No description.* |
| [`accessibilitySelfServiceInput`](#cdktfprovideroktaappthreefieldpropertyaccessibilityselfserviceinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`adminNoteInput`](#cdktfprovideroktaappthreefieldpropertyadminnoteinput) | `string` | *No description.* |
| [`appLinksJsonInput`](#cdktfprovideroktaappthreefieldpropertyapplinksjsoninput) | `string` | *No description.* |
| [`autoSubmitToolbarInput`](#cdktfprovideroktaappthreefieldpropertyautosubmittoolbarinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`buttonSelectorInput`](#cdktfprovideroktaappthreefieldpropertybuttonselectorinput) | `string` | *No description.* |
| [`credentialsSchemeInput`](#cdktfprovideroktaappthreefieldpropertycredentialsschemeinput) | `string` | *No description.* |
| [`enduserNoteInput`](#cdktfprovideroktaappthreefieldpropertyendusernoteinput) | `string` | *No description.* |
| [`extraFieldSelectorInput`](#cdktfprovideroktaappthreefieldpropertyextrafieldselectorinput) | `string` | *No description.* |
| [`extraFieldValueInput`](#cdktfprovideroktaappthreefieldpropertyextrafieldvalueinput) | `string` | *No description.* |
| [`groupsInput`](#cdktfprovideroktaappthreefieldpropertygroupsinput) | `string`[] | *No description.* |
| [`hideIosInput`](#cdktfprovideroktaappthreefieldpropertyhideiosinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`hideWebInput`](#cdktfprovideroktaappthreefieldpropertyhidewebinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`idInput`](#cdktfprovideroktaappthreefieldpropertyidinput) | `string` | *No description.* |
| [`labelInput`](#cdktfprovideroktaappthreefieldpropertylabelinput) | `string` | *No description.* |
| [`logoInput`](#cdktfprovideroktaappthreefieldpropertylogoinput) | `string` | *No description.* |
| [`passwordSelectorInput`](#cdktfprovideroktaappthreefieldpropertypasswordselectorinput) | `string` | *No description.* |
| [`revealPasswordInput`](#cdktfprovideroktaappthreefieldpropertyrevealpasswordinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`sharedPasswordInput`](#cdktfprovideroktaappthreefieldpropertysharedpasswordinput) | `string` | *No description.* |
| [`sharedUsernameInput`](#cdktfprovideroktaappthreefieldpropertysharedusernameinput) | `string` | *No description.* |
| [`skipGroupsInput`](#cdktfprovideroktaappthreefieldpropertyskipgroupsinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`skipUsersInput`](#cdktfprovideroktaappthreefieldpropertyskipusersinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`statusInput`](#cdktfprovideroktaappthreefieldpropertystatusinput) | `string` | *No description.* |
| [`timeoutsInput`](#cdktfprovideroktaappthreefieldpropertytimeoutsinput) | [`cdktf.IResolvable`](#cdktf.IResolvable) \| [`@cdktf/provider-okta.AppThreeFieldTimeouts`](#@cdktf/provider-okta.AppThreeFieldTimeouts) | *No description.* |
| [`urlInput`](#cdktfprovideroktaappthreefieldpropertyurlinput) | `string` | *No description.* |
| [`urlRegexInput`](#cdktfprovideroktaappthreefieldpropertyurlregexinput) | `string` | *No description.* |
| [`usernameSelectorInput`](#cdktfprovideroktaappthreefieldpropertyusernameselectorinput) | `string` | *No description.* |
| [`userNameTemplateInput`](#cdktfprovideroktaappthreefieldpropertyusernametemplateinput) | `string` | *No description.* |
| [`userNameTemplatePushStatusInput`](#cdktfprovideroktaappthreefieldpropertyusernametemplatepushstatusinput) | `string` | *No description.* |
| [`userNameTemplateSuffixInput`](#cdktfprovideroktaappthreefieldpropertyusernametemplatesuffixinput) | `string` | *No description.* |
| [`userNameTemplateTypeInput`](#cdktfprovideroktaappthreefieldpropertyusernametemplatetypeinput) | `string` | *No description.* |
| [`usersInput`](#cdktfprovideroktaappthreefieldpropertyusersinput) | [`cdktf.IResolvable`](#cdktf.IResolvable) \| [`@cdktf/provider-okta.AppThreeFieldUsers`](#@cdktf/provider-okta.AppThreeFieldUsers)[] | *No description.* |
| [`accessibilityErrorRedirectUrl`](#cdktfprovideroktaappthreefieldpropertyaccessibilityerrorredirecturl)<span title="Required">*</span> | `string` | *No description.* |
| [`accessibilityLoginRedirectUrl`](#cdktfprovideroktaappthreefieldpropertyaccessibilityloginredirecturl)<span title="Required">*</span> | `string` | *No description.* |
| [`accessibilitySelfService`](#cdktfprovideroktaappthreefieldpropertyaccessibilityselfservice)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`adminNote`](#cdktfprovideroktaappthreefieldpropertyadminnote)<span title="Required">*</span> | `string` | *No description.* |
| [`appLinksJson`](#cdktfprovideroktaappthreefieldpropertyapplinksjson)<span title="Required">*</span> | `string` | *No description.* |
| [`autoSubmitToolbar`](#cdktfprovideroktaappthreefieldpropertyautosubmittoolbar)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`buttonSelector`](#cdktfprovideroktaappthreefieldpropertybuttonselector)<span title="Required">*</span> | `string` | *No description.* |
| [`credentialsScheme`](#cdktfprovideroktaappthreefieldpropertycredentialsscheme)<span title="Required">*</span> | `string` | *No description.* |
| [`enduserNote`](#cdktfprovideroktaappthreefieldpropertyendusernote)<span title="Required">*</span> | `string` | *No description.* |
| [`extraFieldSelector`](#cdktfprovideroktaappthreefieldpropertyextrafieldselector)<span title="Required">*</span> | `string` | *No description.* |
| [`extraFieldValue`](#cdktfprovideroktaappthreefieldpropertyextrafieldvalue)<span title="Required">*</span> | `string` | *No description.* |
| [`groups`](#cdktfprovideroktaappthreefieldpropertygroups)<span title="Required">*</span> | `string`[] | *No description.* |
| [`hideIos`](#cdktfprovideroktaappthreefieldpropertyhideios)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`hideWeb`](#cdktfprovideroktaappthreefieldpropertyhideweb)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`id`](#cdktfprovideroktaappthreefieldpropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`label`](#cdktfprovideroktaappthreefieldpropertylabel)<span title="Required">*</span> | `string` | *No description.* |
| [`logo`](#cdktfprovideroktaappthreefieldpropertylogo)<span title="Required">*</span> | `string` | *No description.* |
| [`passwordSelector`](#cdktfprovideroktaappthreefieldpropertypasswordselector)<span title="Required">*</span> | `string` | *No description.* |
| [`revealPassword`](#cdktfprovideroktaappthreefieldpropertyrevealpassword)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`sharedPassword`](#cdktfprovideroktaappthreefieldpropertysharedpassword)<span title="Required">*</span> | `string` | *No description.* |
| [`sharedUsername`](#cdktfprovideroktaappthreefieldpropertysharedusername)<span title="Required">*</span> | `string` | *No description.* |
| [`skipGroups`](#cdktfprovideroktaappthreefieldpropertyskipgroups)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`skipUsers`](#cdktfprovideroktaappthreefieldpropertyskipusers)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`status`](#cdktfprovideroktaappthreefieldpropertystatus)<span title="Required">*</span> | `string` | *No description.* |
| [`url`](#cdktfprovideroktaappthreefieldpropertyurl)<span title="Required">*</span> | `string` | *No description.* |
| [`urlRegex`](#cdktfprovideroktaappthreefieldpropertyurlregex)<span title="Required">*</span> | `string` | *No description.* |
| [`usernameSelector`](#cdktfprovideroktaappthreefieldpropertyusernameselector)<span title="Required">*</span> | `string` | *No description.* |
| [`userNameTemplate`](#cdktfprovideroktaappthreefieldpropertyusernametemplate)<span title="Required">*</span> | `string` | *No description.* |
| [`userNameTemplatePushStatus`](#cdktfprovideroktaappthreefieldpropertyusernametemplatepushstatus)<span title="Required">*</span> | `string` | *No description.* |
| [`userNameTemplateSuffix`](#cdktfprovideroktaappthreefieldpropertyusernametemplatesuffix)<span title="Required">*</span> | `string` | *No description.* |
| [`userNameTemplateType`](#cdktfprovideroktaappthreefieldpropertyusernametemplatetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `logoUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.AppThreeField.property.logoUrl" id="cdktfprovideroktaappthreefieldpropertylogourl"></a>

```typescript
public readonly logoUrl: string;
```

- *Type:* `string`

---

##### `name`<sup>Required</sup> <a name="@cdktf/provider-okta.AppThreeField.property.name" id="cdktfprovideroktaappthreefieldpropertyname"></a>

```typescript
public readonly name: string;
```

- *Type:* `string`

---

##### `signOnMode`<sup>Required</sup> <a name="@cdktf/provider-okta.AppThreeField.property.signOnMode" id="cdktfprovideroktaappthreefieldpropertysignonmode"></a>

```typescript
public readonly signOnMode: string;
```

- *Type:* `string`

---

##### `timeouts`<sup>Required</sup> <a name="@cdktf/provider-okta.AppThreeField.property.timeouts" id="cdktfprovideroktaappthreefieldpropertytimeouts"></a>

```typescript
public readonly timeouts: AppThreeFieldTimeoutsOutputReference;
```

- *Type:* [`@cdktf/provider-okta.AppThreeFieldTimeoutsOutputReference`](#@cdktf/provider-okta.AppThreeFieldTimeoutsOutputReference)

---

##### `users`<sup>Required</sup> <a name="@cdktf/provider-okta.AppThreeField.property.users" id="cdktfprovideroktaappthreefieldpropertyusers"></a>

```typescript
public readonly users: AppThreeFieldUsersList;
```

- *Type:* [`@cdktf/provider-okta.AppThreeFieldUsersList`](#@cdktf/provider-okta.AppThreeFieldUsersList)

---

##### `accessibilityErrorRedirectUrlInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppThreeField.property.accessibilityErrorRedirectUrlInput" id="cdktfprovideroktaappthreefieldpropertyaccessibilityerrorredirecturlinput"></a>

```typescript
public readonly accessibilityErrorRedirectUrlInput: string;
```

- *Type:* `string`

---

##### `accessibilityLoginRedirectUrlInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppThreeField.property.accessibilityLoginRedirectUrlInput" id="cdktfprovideroktaappthreefieldpropertyaccessibilityloginredirecturlinput"></a>

```typescript
public readonly accessibilityLoginRedirectUrlInput: string;
```

- *Type:* `string`

---

##### `accessibilitySelfServiceInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppThreeField.property.accessibilitySelfServiceInput" id="cdktfprovideroktaappthreefieldpropertyaccessibilityselfserviceinput"></a>

```typescript
public readonly accessibilitySelfServiceInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `adminNoteInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppThreeField.property.adminNoteInput" id="cdktfprovideroktaappthreefieldpropertyadminnoteinput"></a>

```typescript
public readonly adminNoteInput: string;
```

- *Type:* `string`

---

##### `appLinksJsonInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppThreeField.property.appLinksJsonInput" id="cdktfprovideroktaappthreefieldpropertyapplinksjsoninput"></a>

```typescript
public readonly appLinksJsonInput: string;
```

- *Type:* `string`

---

##### `autoSubmitToolbarInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppThreeField.property.autoSubmitToolbarInput" id="cdktfprovideroktaappthreefieldpropertyautosubmittoolbarinput"></a>

```typescript
public readonly autoSubmitToolbarInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `buttonSelectorInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppThreeField.property.buttonSelectorInput" id="cdktfprovideroktaappthreefieldpropertybuttonselectorinput"></a>

```typescript
public readonly buttonSelectorInput: string;
```

- *Type:* `string`

---

##### `credentialsSchemeInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppThreeField.property.credentialsSchemeInput" id="cdktfprovideroktaappthreefieldpropertycredentialsschemeinput"></a>

```typescript
public readonly credentialsSchemeInput: string;
```

- *Type:* `string`

---

##### `enduserNoteInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppThreeField.property.enduserNoteInput" id="cdktfprovideroktaappthreefieldpropertyendusernoteinput"></a>

```typescript
public readonly enduserNoteInput: string;
```

- *Type:* `string`

---

##### `extraFieldSelectorInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppThreeField.property.extraFieldSelectorInput" id="cdktfprovideroktaappthreefieldpropertyextrafieldselectorinput"></a>

```typescript
public readonly extraFieldSelectorInput: string;
```

- *Type:* `string`

---

##### `extraFieldValueInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppThreeField.property.extraFieldValueInput" id="cdktfprovideroktaappthreefieldpropertyextrafieldvalueinput"></a>

```typescript
public readonly extraFieldValueInput: string;
```

- *Type:* `string`

---

##### `groupsInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppThreeField.property.groupsInput" id="cdktfprovideroktaappthreefieldpropertygroupsinput"></a>

```typescript
public readonly groupsInput: string[];
```

- *Type:* `string`[]

---

##### `hideIosInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppThreeField.property.hideIosInput" id="cdktfprovideroktaappthreefieldpropertyhideiosinput"></a>

```typescript
public readonly hideIosInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `hideWebInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppThreeField.property.hideWebInput" id="cdktfprovideroktaappthreefieldpropertyhidewebinput"></a>

```typescript
public readonly hideWebInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppThreeField.property.idInput" id="cdktfprovideroktaappthreefieldpropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `labelInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppThreeField.property.labelInput" id="cdktfprovideroktaappthreefieldpropertylabelinput"></a>

```typescript
public readonly labelInput: string;
```

- *Type:* `string`

---

##### `logoInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppThreeField.property.logoInput" id="cdktfprovideroktaappthreefieldpropertylogoinput"></a>

```typescript
public readonly logoInput: string;
```

- *Type:* `string`

---

##### `passwordSelectorInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppThreeField.property.passwordSelectorInput" id="cdktfprovideroktaappthreefieldpropertypasswordselectorinput"></a>

```typescript
public readonly passwordSelectorInput: string;
```

- *Type:* `string`

---

##### `revealPasswordInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppThreeField.property.revealPasswordInput" id="cdktfprovideroktaappthreefieldpropertyrevealpasswordinput"></a>

```typescript
public readonly revealPasswordInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `sharedPasswordInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppThreeField.property.sharedPasswordInput" id="cdktfprovideroktaappthreefieldpropertysharedpasswordinput"></a>

```typescript
public readonly sharedPasswordInput: string;
```

- *Type:* `string`

---

##### `sharedUsernameInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppThreeField.property.sharedUsernameInput" id="cdktfprovideroktaappthreefieldpropertysharedusernameinput"></a>

```typescript
public readonly sharedUsernameInput: string;
```

- *Type:* `string`

---

##### `skipGroupsInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppThreeField.property.skipGroupsInput" id="cdktfprovideroktaappthreefieldpropertyskipgroupsinput"></a>

```typescript
public readonly skipGroupsInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `skipUsersInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppThreeField.property.skipUsersInput" id="cdktfprovideroktaappthreefieldpropertyskipusersinput"></a>

```typescript
public readonly skipUsersInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `statusInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppThreeField.property.statusInput" id="cdktfprovideroktaappthreefieldpropertystatusinput"></a>

```typescript
public readonly statusInput: string;
```

- *Type:* `string`

---

##### `timeoutsInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppThreeField.property.timeoutsInput" id="cdktfprovideroktaappthreefieldpropertytimeoutsinput"></a>

```typescript
public readonly timeoutsInput: IResolvable | AppThreeFieldTimeouts;
```

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable) | [`@cdktf/provider-okta.AppThreeFieldTimeouts`](#@cdktf/provider-okta.AppThreeFieldTimeouts)

---

##### `urlInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppThreeField.property.urlInput" id="cdktfprovideroktaappthreefieldpropertyurlinput"></a>

```typescript
public readonly urlInput: string;
```

- *Type:* `string`

---

##### `urlRegexInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppThreeField.property.urlRegexInput" id="cdktfprovideroktaappthreefieldpropertyurlregexinput"></a>

```typescript
public readonly urlRegexInput: string;
```

- *Type:* `string`

---

##### `usernameSelectorInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppThreeField.property.usernameSelectorInput" id="cdktfprovideroktaappthreefieldpropertyusernameselectorinput"></a>

```typescript
public readonly usernameSelectorInput: string;
```

- *Type:* `string`

---

##### `userNameTemplateInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppThreeField.property.userNameTemplateInput" id="cdktfprovideroktaappthreefieldpropertyusernametemplateinput"></a>

```typescript
public readonly userNameTemplateInput: string;
```

- *Type:* `string`

---

##### `userNameTemplatePushStatusInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppThreeField.property.userNameTemplatePushStatusInput" id="cdktfprovideroktaappthreefieldpropertyusernametemplatepushstatusinput"></a>

```typescript
public readonly userNameTemplatePushStatusInput: string;
```

- *Type:* `string`

---

##### `userNameTemplateSuffixInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppThreeField.property.userNameTemplateSuffixInput" id="cdktfprovideroktaappthreefieldpropertyusernametemplatesuffixinput"></a>

```typescript
public readonly userNameTemplateSuffixInput: string;
```

- *Type:* `string`

---

##### `userNameTemplateTypeInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppThreeField.property.userNameTemplateTypeInput" id="cdktfprovideroktaappthreefieldpropertyusernametemplatetypeinput"></a>

```typescript
public readonly userNameTemplateTypeInput: string;
```

- *Type:* `string`

---

##### `usersInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppThreeField.property.usersInput" id="cdktfprovideroktaappthreefieldpropertyusersinput"></a>

```typescript
public readonly usersInput: IResolvable | AppThreeFieldUsers[];
```

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable) | [`@cdktf/provider-okta.AppThreeFieldUsers`](#@cdktf/provider-okta.AppThreeFieldUsers)[]

---

##### `accessibilityErrorRedirectUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.AppThreeField.property.accessibilityErrorRedirectUrl" id="cdktfprovideroktaappthreefieldpropertyaccessibilityerrorredirecturl"></a>

```typescript
public readonly accessibilityErrorRedirectUrl: string;
```

- *Type:* `string`

---

##### `accessibilityLoginRedirectUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.AppThreeField.property.accessibilityLoginRedirectUrl" id="cdktfprovideroktaappthreefieldpropertyaccessibilityloginredirecturl"></a>

```typescript
public readonly accessibilityLoginRedirectUrl: string;
```

- *Type:* `string`

---

##### `accessibilitySelfService`<sup>Required</sup> <a name="@cdktf/provider-okta.AppThreeField.property.accessibilitySelfService" id="cdktfprovideroktaappthreefieldpropertyaccessibilityselfservice"></a>

```typescript
public readonly accessibilitySelfService: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `adminNote`<sup>Required</sup> <a name="@cdktf/provider-okta.AppThreeField.property.adminNote" id="cdktfprovideroktaappthreefieldpropertyadminnote"></a>

```typescript
public readonly adminNote: string;
```

- *Type:* `string`

---

##### `appLinksJson`<sup>Required</sup> <a name="@cdktf/provider-okta.AppThreeField.property.appLinksJson" id="cdktfprovideroktaappthreefieldpropertyapplinksjson"></a>

```typescript
public readonly appLinksJson: string;
```

- *Type:* `string`

---

##### `autoSubmitToolbar`<sup>Required</sup> <a name="@cdktf/provider-okta.AppThreeField.property.autoSubmitToolbar" id="cdktfprovideroktaappthreefieldpropertyautosubmittoolbar"></a>

```typescript
public readonly autoSubmitToolbar: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `buttonSelector`<sup>Required</sup> <a name="@cdktf/provider-okta.AppThreeField.property.buttonSelector" id="cdktfprovideroktaappthreefieldpropertybuttonselector"></a>

```typescript
public readonly buttonSelector: string;
```

- *Type:* `string`

---

##### `credentialsScheme`<sup>Required</sup> <a name="@cdktf/provider-okta.AppThreeField.property.credentialsScheme" id="cdktfprovideroktaappthreefieldpropertycredentialsscheme"></a>

```typescript
public readonly credentialsScheme: string;
```

- *Type:* `string`

---

##### `enduserNote`<sup>Required</sup> <a name="@cdktf/provider-okta.AppThreeField.property.enduserNote" id="cdktfprovideroktaappthreefieldpropertyendusernote"></a>

```typescript
public readonly enduserNote: string;
```

- *Type:* `string`

---

##### `extraFieldSelector`<sup>Required</sup> <a name="@cdktf/provider-okta.AppThreeField.property.extraFieldSelector" id="cdktfprovideroktaappthreefieldpropertyextrafieldselector"></a>

```typescript
public readonly extraFieldSelector: string;
```

- *Type:* `string`

---

##### `extraFieldValue`<sup>Required</sup> <a name="@cdktf/provider-okta.AppThreeField.property.extraFieldValue" id="cdktfprovideroktaappthreefieldpropertyextrafieldvalue"></a>

```typescript
public readonly extraFieldValue: string;
```

- *Type:* `string`

---

##### `groups`<sup>Required</sup> <a name="@cdktf/provider-okta.AppThreeField.property.groups" id="cdktfprovideroktaappthreefieldpropertygroups"></a>

```typescript
public readonly groups: string[];
```

- *Type:* `string`[]

---

##### `hideIos`<sup>Required</sup> <a name="@cdktf/provider-okta.AppThreeField.property.hideIos" id="cdktfprovideroktaappthreefieldpropertyhideios"></a>

```typescript
public readonly hideIos: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `hideWeb`<sup>Required</sup> <a name="@cdktf/provider-okta.AppThreeField.property.hideWeb" id="cdktfprovideroktaappthreefieldpropertyhideweb"></a>

```typescript
public readonly hideWeb: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AppThreeField.property.id" id="cdktfprovideroktaappthreefieldpropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `label`<sup>Required</sup> <a name="@cdktf/provider-okta.AppThreeField.property.label" id="cdktfprovideroktaappthreefieldpropertylabel"></a>

```typescript
public readonly label: string;
```

- *Type:* `string`

---

##### `logo`<sup>Required</sup> <a name="@cdktf/provider-okta.AppThreeField.property.logo" id="cdktfprovideroktaappthreefieldpropertylogo"></a>

```typescript
public readonly logo: string;
```

- *Type:* `string`

---

##### `passwordSelector`<sup>Required</sup> <a name="@cdktf/provider-okta.AppThreeField.property.passwordSelector" id="cdktfprovideroktaappthreefieldpropertypasswordselector"></a>

```typescript
public readonly passwordSelector: string;
```

- *Type:* `string`

---

##### `revealPassword`<sup>Required</sup> <a name="@cdktf/provider-okta.AppThreeField.property.revealPassword" id="cdktfprovideroktaappthreefieldpropertyrevealpassword"></a>

```typescript
public readonly revealPassword: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `sharedPassword`<sup>Required</sup> <a name="@cdktf/provider-okta.AppThreeField.property.sharedPassword" id="cdktfprovideroktaappthreefieldpropertysharedpassword"></a>

```typescript
public readonly sharedPassword: string;
```

- *Type:* `string`

---

##### `sharedUsername`<sup>Required</sup> <a name="@cdktf/provider-okta.AppThreeField.property.sharedUsername" id="cdktfprovideroktaappthreefieldpropertysharedusername"></a>

```typescript
public readonly sharedUsername: string;
```

- *Type:* `string`

---

##### `skipGroups`<sup>Required</sup> <a name="@cdktf/provider-okta.AppThreeField.property.skipGroups" id="cdktfprovideroktaappthreefieldpropertyskipgroups"></a>

```typescript
public readonly skipGroups: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `skipUsers`<sup>Required</sup> <a name="@cdktf/provider-okta.AppThreeField.property.skipUsers" id="cdktfprovideroktaappthreefieldpropertyskipusers"></a>

```typescript
public readonly skipUsers: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `status`<sup>Required</sup> <a name="@cdktf/provider-okta.AppThreeField.property.status" id="cdktfprovideroktaappthreefieldpropertystatus"></a>

```typescript
public readonly status: string;
```

- *Type:* `string`

---

##### `url`<sup>Required</sup> <a name="@cdktf/provider-okta.AppThreeField.property.url" id="cdktfprovideroktaappthreefieldpropertyurl"></a>

```typescript
public readonly url: string;
```

- *Type:* `string`

---

##### `urlRegex`<sup>Required</sup> <a name="@cdktf/provider-okta.AppThreeField.property.urlRegex" id="cdktfprovideroktaappthreefieldpropertyurlregex"></a>

```typescript
public readonly urlRegex: string;
```

- *Type:* `string`

---

##### `usernameSelector`<sup>Required</sup> <a name="@cdktf/provider-okta.AppThreeField.property.usernameSelector" id="cdktfprovideroktaappthreefieldpropertyusernameselector"></a>

```typescript
public readonly usernameSelector: string;
```

- *Type:* `string`

---

##### `userNameTemplate`<sup>Required</sup> <a name="@cdktf/provider-okta.AppThreeField.property.userNameTemplate" id="cdktfprovideroktaappthreefieldpropertyusernametemplate"></a>

```typescript
public readonly userNameTemplate: string;
```

- *Type:* `string`

---

##### `userNameTemplatePushStatus`<sup>Required</sup> <a name="@cdktf/provider-okta.AppThreeField.property.userNameTemplatePushStatus" id="cdktfprovideroktaappthreefieldpropertyusernametemplatepushstatus"></a>

```typescript
public readonly userNameTemplatePushStatus: string;
```

- *Type:* `string`

---

##### `userNameTemplateSuffix`<sup>Required</sup> <a name="@cdktf/provider-okta.AppThreeField.property.userNameTemplateSuffix" id="cdktfprovideroktaappthreefieldpropertyusernametemplatesuffix"></a>

```typescript
public readonly userNameTemplateSuffix: string;
```

- *Type:* `string`

---

##### `userNameTemplateType`<sup>Required</sup> <a name="@cdktf/provider-okta.AppThreeField.property.userNameTemplateType" id="cdktfprovideroktaappthreefieldpropertyusernametemplatetype"></a>

```typescript
public readonly userNameTemplateType: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktaappthreefieldpropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.AppThreeField.property.tfResourceType" id="cdktfprovideroktaappthreefieldpropertytfresourcetype"></a>

- *Type:* `string`

---

### AppUser <a name="@cdktf/provider-okta.AppUser" id="cdktfprovideroktaappuser"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/r/app_user okta_app_user}.

#### Initializers <a name="@cdktf/provider-okta.AppUser.Initializer" id="cdktfprovideroktaappuserinitializer"></a>

```typescript
import { AppUser } from '@cdktf/provider-okta'

new AppUser(scope: Construct, id: string, config: AppUserConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktaappuserparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktaappuserparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktaappuserparameterconfig)<span title="Required">*</span> | [`@cdktf/provider-okta.AppUserConfig`](#@cdktf/provider-okta.AppUserConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUser.parameter.scope" id="cdktfprovideroktaappuserparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUser.parameter.id" id="cdktfprovideroktaappuserparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUser.parameter.config" id="cdktfprovideroktaappuserparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.AppUserConfig`](#@cdktf/provider-okta.AppUserConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`resetId`](#cdktfprovideroktaappuserresetid) | *No description.* |
| [`resetPassword`](#cdktfprovideroktaappuserresetpassword) | *No description.* |
| [`resetProfile`](#cdktfprovideroktaappuserresetprofile) | *No description.* |
| [`resetRetainAssignment`](#cdktfprovideroktaappuserresetretainassignment) | *No description.* |
| [`resetUsername`](#cdktfprovideroktaappuserresetusername) | *No description.* |

---

##### `resetId` <a name="@cdktf/provider-okta.AppUser.resetId" id="cdktfprovideroktaappuserresetid"></a>

```typescript
public resetId()
```

##### `resetPassword` <a name="@cdktf/provider-okta.AppUser.resetPassword" id="cdktfprovideroktaappuserresetpassword"></a>

```typescript
public resetPassword()
```

##### `resetProfile` <a name="@cdktf/provider-okta.AppUser.resetProfile" id="cdktfprovideroktaappuserresetprofile"></a>

```typescript
public resetProfile()
```

##### `resetRetainAssignment` <a name="@cdktf/provider-okta.AppUser.resetRetainAssignment" id="cdktfprovideroktaappuserresetretainassignment"></a>

```typescript
public resetRetainAssignment()
```

##### `resetUsername` <a name="@cdktf/provider-okta.AppUser.resetUsername" id="cdktfprovideroktaappuserresetusername"></a>

```typescript
public resetUsername()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`hasSharedUsername`](#cdktfprovideroktaappuserpropertyhassharedusername)<span title="Required">*</span> | [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`appIdInput`](#cdktfprovideroktaappuserpropertyappidinput) | `string` | *No description.* |
| [`idInput`](#cdktfprovideroktaappuserpropertyidinput) | `string` | *No description.* |
| [`passwordInput`](#cdktfprovideroktaappuserpropertypasswordinput) | `string` | *No description.* |
| [`profileInput`](#cdktfprovideroktaappuserpropertyprofileinput) | `string` | *No description.* |
| [`retainAssignmentInput`](#cdktfprovideroktaappuserpropertyretainassignmentinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`userIdInput`](#cdktfprovideroktaappuserpropertyuseridinput) | `string` | *No description.* |
| [`usernameInput`](#cdktfprovideroktaappuserpropertyusernameinput) | `string` | *No description.* |
| [`appId`](#cdktfprovideroktaappuserpropertyappid)<span title="Required">*</span> | `string` | *No description.* |
| [`id`](#cdktfprovideroktaappuserpropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`password`](#cdktfprovideroktaappuserpropertypassword)<span title="Required">*</span> | `string` | *No description.* |
| [`profile`](#cdktfprovideroktaappuserpropertyprofile)<span title="Required">*</span> | `string` | *No description.* |
| [`retainAssignment`](#cdktfprovideroktaappuserpropertyretainassignment)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`userId`](#cdktfprovideroktaappuserpropertyuserid)<span title="Required">*</span> | `string` | *No description.* |
| [`username`](#cdktfprovideroktaappuserpropertyusername)<span title="Required">*</span> | `string` | *No description.* |

---

##### `hasSharedUsername`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUser.property.hasSharedUsername" id="cdktfprovideroktaappuserpropertyhassharedusername"></a>

```typescript
public readonly hasSharedUsername: IResolvable;
```

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `appIdInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUser.property.appIdInput" id="cdktfprovideroktaappuserpropertyappidinput"></a>

```typescript
public readonly appIdInput: string;
```

- *Type:* `string`

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUser.property.idInput" id="cdktfprovideroktaappuserpropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `passwordInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUser.property.passwordInput" id="cdktfprovideroktaappuserpropertypasswordinput"></a>

```typescript
public readonly passwordInput: string;
```

- *Type:* `string`

---

##### `profileInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUser.property.profileInput" id="cdktfprovideroktaappuserpropertyprofileinput"></a>

```typescript
public readonly profileInput: string;
```

- *Type:* `string`

---

##### `retainAssignmentInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUser.property.retainAssignmentInput" id="cdktfprovideroktaappuserpropertyretainassignmentinput"></a>

```typescript
public readonly retainAssignmentInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `userIdInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUser.property.userIdInput" id="cdktfprovideroktaappuserpropertyuseridinput"></a>

```typescript
public readonly userIdInput: string;
```

- *Type:* `string`

---

##### `usernameInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUser.property.usernameInput" id="cdktfprovideroktaappuserpropertyusernameinput"></a>

```typescript
public readonly usernameInput: string;
```

- *Type:* `string`

---

##### `appId`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUser.property.appId" id="cdktfprovideroktaappuserpropertyappid"></a>

```typescript
public readonly appId: string;
```

- *Type:* `string`

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUser.property.id" id="cdktfprovideroktaappuserpropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `password`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUser.property.password" id="cdktfprovideroktaappuserpropertypassword"></a>

```typescript
public readonly password: string;
```

- *Type:* `string`

---

##### `profile`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUser.property.profile" id="cdktfprovideroktaappuserpropertyprofile"></a>

```typescript
public readonly profile: string;
```

- *Type:* `string`

---

##### `retainAssignment`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUser.property.retainAssignment" id="cdktfprovideroktaappuserpropertyretainassignment"></a>

```typescript
public readonly retainAssignment: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `userId`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUser.property.userId" id="cdktfprovideroktaappuserpropertyuserid"></a>

```typescript
public readonly userId: string;
```

- *Type:* `string`

---

##### `username`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUser.property.username" id="cdktfprovideroktaappuserpropertyusername"></a>

```typescript
public readonly username: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktaappuserpropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.AppUser.property.tfResourceType" id="cdktfprovideroktaappuserpropertytfresourcetype"></a>

- *Type:* `string`

---

### AppUserBaseSchema <a name="@cdktf/provider-okta.AppUserBaseSchema" id="cdktfprovideroktaappuserbaseschema"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/r/app_user_base_schema okta_app_user_base_schema}.

#### Initializers <a name="@cdktf/provider-okta.AppUserBaseSchema.Initializer" id="cdktfprovideroktaappuserbaseschemainitializer"></a>

```typescript
import { AppUserBaseSchema } from '@cdktf/provider-okta'

new AppUserBaseSchema(scope: Construct, id: string, config: AppUserBaseSchemaConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktaappuserbaseschemaparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktaappuserbaseschemaparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktaappuserbaseschemaparameterconfig)<span title="Required">*</span> | [`@cdktf/provider-okta.AppUserBaseSchemaConfig`](#@cdktf/provider-okta.AppUserBaseSchemaConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserBaseSchema.parameter.scope" id="cdktfprovideroktaappuserbaseschemaparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserBaseSchema.parameter.id" id="cdktfprovideroktaappuserbaseschemaparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserBaseSchema.parameter.config" id="cdktfprovideroktaappuserbaseschemaparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.AppUserBaseSchemaConfig`](#@cdktf/provider-okta.AppUserBaseSchemaConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`resetId`](#cdktfprovideroktaappuserbaseschemaresetid) | *No description.* |
| [`resetMaster`](#cdktfprovideroktaappuserbaseschemaresetmaster) | *No description.* |
| [`resetPattern`](#cdktfprovideroktaappuserbaseschemaresetpattern) | *No description.* |
| [`resetPermissions`](#cdktfprovideroktaappuserbaseschemaresetpermissions) | *No description.* |
| [`resetRequired`](#cdktfprovideroktaappuserbaseschemaresetrequired) | *No description.* |
| [`resetUserType`](#cdktfprovideroktaappuserbaseschemaresetusertype) | *No description.* |

---

##### `resetId` <a name="@cdktf/provider-okta.AppUserBaseSchema.resetId" id="cdktfprovideroktaappuserbaseschemaresetid"></a>

```typescript
public resetId()
```

##### `resetMaster` <a name="@cdktf/provider-okta.AppUserBaseSchema.resetMaster" id="cdktfprovideroktaappuserbaseschemaresetmaster"></a>

```typescript
public resetMaster()
```

##### `resetPattern` <a name="@cdktf/provider-okta.AppUserBaseSchema.resetPattern" id="cdktfprovideroktaappuserbaseschemaresetpattern"></a>

```typescript
public resetPattern()
```

##### `resetPermissions` <a name="@cdktf/provider-okta.AppUserBaseSchema.resetPermissions" id="cdktfprovideroktaappuserbaseschemaresetpermissions"></a>

```typescript
public resetPermissions()
```

##### `resetRequired` <a name="@cdktf/provider-okta.AppUserBaseSchema.resetRequired" id="cdktfprovideroktaappuserbaseschemaresetrequired"></a>

```typescript
public resetRequired()
```

##### `resetUserType` <a name="@cdktf/provider-okta.AppUserBaseSchema.resetUserType" id="cdktfprovideroktaappuserbaseschemaresetusertype"></a>

```typescript
public resetUserType()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`appIdInput`](#cdktfprovideroktaappuserbaseschemapropertyappidinput) | `string` | *No description.* |
| [`idInput`](#cdktfprovideroktaappuserbaseschemapropertyidinput) | `string` | *No description.* |
| [`indexInput`](#cdktfprovideroktaappuserbaseschemapropertyindexinput) | `string` | *No description.* |
| [`masterInput`](#cdktfprovideroktaappuserbaseschemapropertymasterinput) | `string` | *No description.* |
| [`patternInput`](#cdktfprovideroktaappuserbaseschemapropertypatterninput) | `string` | *No description.* |
| [`permissionsInput`](#cdktfprovideroktaappuserbaseschemapropertypermissionsinput) | `string` | *No description.* |
| [`requiredInput`](#cdktfprovideroktaappuserbaseschemapropertyrequiredinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`titleInput`](#cdktfprovideroktaappuserbaseschemapropertytitleinput) | `string` | *No description.* |
| [`typeInput`](#cdktfprovideroktaappuserbaseschemapropertytypeinput) | `string` | *No description.* |
| [`userTypeInput`](#cdktfprovideroktaappuserbaseschemapropertyusertypeinput) | `string` | *No description.* |
| [`appId`](#cdktfprovideroktaappuserbaseschemapropertyappid)<span title="Required">*</span> | `string` | *No description.* |
| [`id`](#cdktfprovideroktaappuserbaseschemapropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`index`](#cdktfprovideroktaappuserbaseschemapropertyindex)<span title="Required">*</span> | `string` | *No description.* |
| [`master`](#cdktfprovideroktaappuserbaseschemapropertymaster)<span title="Required">*</span> | `string` | *No description.* |
| [`pattern`](#cdktfprovideroktaappuserbaseschemapropertypattern)<span title="Required">*</span> | `string` | *No description.* |
| [`permissions`](#cdktfprovideroktaappuserbaseschemapropertypermissions)<span title="Required">*</span> | `string` | *No description.* |
| [`required`](#cdktfprovideroktaappuserbaseschemapropertyrequired)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`title`](#cdktfprovideroktaappuserbaseschemapropertytitle)<span title="Required">*</span> | `string` | *No description.* |
| [`type`](#cdktfprovideroktaappuserbaseschemapropertytype)<span title="Required">*</span> | `string` | *No description.* |
| [`userType`](#cdktfprovideroktaappuserbaseschemapropertyusertype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `appIdInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserBaseSchema.property.appIdInput" id="cdktfprovideroktaappuserbaseschemapropertyappidinput"></a>

```typescript
public readonly appIdInput: string;
```

- *Type:* `string`

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserBaseSchema.property.idInput" id="cdktfprovideroktaappuserbaseschemapropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `indexInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserBaseSchema.property.indexInput" id="cdktfprovideroktaappuserbaseschemapropertyindexinput"></a>

```typescript
public readonly indexInput: string;
```

- *Type:* `string`

---

##### `masterInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserBaseSchema.property.masterInput" id="cdktfprovideroktaappuserbaseschemapropertymasterinput"></a>

```typescript
public readonly masterInput: string;
```

- *Type:* `string`

---

##### `patternInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserBaseSchema.property.patternInput" id="cdktfprovideroktaappuserbaseschemapropertypatterninput"></a>

```typescript
public readonly patternInput: string;
```

- *Type:* `string`

---

##### `permissionsInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserBaseSchema.property.permissionsInput" id="cdktfprovideroktaappuserbaseschemapropertypermissionsinput"></a>

```typescript
public readonly permissionsInput: string;
```

- *Type:* `string`

---

##### `requiredInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserBaseSchema.property.requiredInput" id="cdktfprovideroktaappuserbaseschemapropertyrequiredinput"></a>

```typescript
public readonly requiredInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `titleInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserBaseSchema.property.titleInput" id="cdktfprovideroktaappuserbaseschemapropertytitleinput"></a>

```typescript
public readonly titleInput: string;
```

- *Type:* `string`

---

##### `typeInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserBaseSchema.property.typeInput" id="cdktfprovideroktaappuserbaseschemapropertytypeinput"></a>

```typescript
public readonly typeInput: string;
```

- *Type:* `string`

---

##### `userTypeInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserBaseSchema.property.userTypeInput" id="cdktfprovideroktaappuserbaseschemapropertyusertypeinput"></a>

```typescript
public readonly userTypeInput: string;
```

- *Type:* `string`

---

##### `appId`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserBaseSchema.property.appId" id="cdktfprovideroktaappuserbaseschemapropertyappid"></a>

```typescript
public readonly appId: string;
```

- *Type:* `string`

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserBaseSchema.property.id" id="cdktfprovideroktaappuserbaseschemapropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `index`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserBaseSchema.property.index" id="cdktfprovideroktaappuserbaseschemapropertyindex"></a>

```typescript
public readonly index: string;
```

- *Type:* `string`

---

##### `master`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserBaseSchema.property.master" id="cdktfprovideroktaappuserbaseschemapropertymaster"></a>

```typescript
public readonly master: string;
```

- *Type:* `string`

---

##### `pattern`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserBaseSchema.property.pattern" id="cdktfprovideroktaappuserbaseschemapropertypattern"></a>

```typescript
public readonly pattern: string;
```

- *Type:* `string`

---

##### `permissions`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserBaseSchema.property.permissions" id="cdktfprovideroktaappuserbaseschemapropertypermissions"></a>

```typescript
public readonly permissions: string;
```

- *Type:* `string`

---

##### `required`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserBaseSchema.property.required" id="cdktfprovideroktaappuserbaseschemapropertyrequired"></a>

```typescript
public readonly required: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `title`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserBaseSchema.property.title" id="cdktfprovideroktaappuserbaseschemapropertytitle"></a>

```typescript
public readonly title: string;
```

- *Type:* `string`

---

##### `type`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserBaseSchema.property.type" id="cdktfprovideroktaappuserbaseschemapropertytype"></a>

```typescript
public readonly type: string;
```

- *Type:* `string`

---

##### `userType`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserBaseSchema.property.userType" id="cdktfprovideroktaappuserbaseschemapropertyusertype"></a>

```typescript
public readonly userType: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktaappuserbaseschemapropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.AppUserBaseSchema.property.tfResourceType" id="cdktfprovideroktaappuserbaseschemapropertytfresourcetype"></a>

- *Type:* `string`

---

### AppUserBaseSchemaProperty <a name="@cdktf/provider-okta.AppUserBaseSchemaProperty" id="cdktfprovideroktaappuserbaseschemaproperty"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/r/app_user_base_schema_property okta_app_user_base_schema_property}.

#### Initializers <a name="@cdktf/provider-okta.AppUserBaseSchemaProperty.Initializer" id="cdktfprovideroktaappuserbaseschemapropertyinitializer"></a>

```typescript
import { AppUserBaseSchemaProperty } from '@cdktf/provider-okta'

new AppUserBaseSchemaProperty(scope: Construct, id: string, config: AppUserBaseSchemaPropertyConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktaappuserbaseschemapropertyparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktaappuserbaseschemapropertyparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktaappuserbaseschemapropertyparameterconfig)<span title="Required">*</span> | [`@cdktf/provider-okta.AppUserBaseSchemaPropertyConfig`](#@cdktf/provider-okta.AppUserBaseSchemaPropertyConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserBaseSchemaProperty.parameter.scope" id="cdktfprovideroktaappuserbaseschemapropertyparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserBaseSchemaProperty.parameter.id" id="cdktfprovideroktaappuserbaseschemapropertyparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserBaseSchemaProperty.parameter.config" id="cdktfprovideroktaappuserbaseschemapropertyparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.AppUserBaseSchemaPropertyConfig`](#@cdktf/provider-okta.AppUserBaseSchemaPropertyConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`resetId`](#cdktfprovideroktaappuserbaseschemapropertyresetid) | *No description.* |
| [`resetMaster`](#cdktfprovideroktaappuserbaseschemapropertyresetmaster) | *No description.* |
| [`resetPattern`](#cdktfprovideroktaappuserbaseschemapropertyresetpattern) | *No description.* |
| [`resetPermissions`](#cdktfprovideroktaappuserbaseschemapropertyresetpermissions) | *No description.* |
| [`resetRequired`](#cdktfprovideroktaappuserbaseschemapropertyresetrequired) | *No description.* |
| [`resetUserType`](#cdktfprovideroktaappuserbaseschemapropertyresetusertype) | *No description.* |

---

##### `resetId` <a name="@cdktf/provider-okta.AppUserBaseSchemaProperty.resetId" id="cdktfprovideroktaappuserbaseschemapropertyresetid"></a>

```typescript
public resetId()
```

##### `resetMaster` <a name="@cdktf/provider-okta.AppUserBaseSchemaProperty.resetMaster" id="cdktfprovideroktaappuserbaseschemapropertyresetmaster"></a>

```typescript
public resetMaster()
```

##### `resetPattern` <a name="@cdktf/provider-okta.AppUserBaseSchemaProperty.resetPattern" id="cdktfprovideroktaappuserbaseschemapropertyresetpattern"></a>

```typescript
public resetPattern()
```

##### `resetPermissions` <a name="@cdktf/provider-okta.AppUserBaseSchemaProperty.resetPermissions" id="cdktfprovideroktaappuserbaseschemapropertyresetpermissions"></a>

```typescript
public resetPermissions()
```

##### `resetRequired` <a name="@cdktf/provider-okta.AppUserBaseSchemaProperty.resetRequired" id="cdktfprovideroktaappuserbaseschemapropertyresetrequired"></a>

```typescript
public resetRequired()
```

##### `resetUserType` <a name="@cdktf/provider-okta.AppUserBaseSchemaProperty.resetUserType" id="cdktfprovideroktaappuserbaseschemapropertyresetusertype"></a>

```typescript
public resetUserType()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`appIdInput`](#cdktfprovideroktaappuserbaseschemapropertypropertyappidinput) | `string` | *No description.* |
| [`idInput`](#cdktfprovideroktaappuserbaseschemapropertypropertyidinput) | `string` | *No description.* |
| [`indexInput`](#cdktfprovideroktaappuserbaseschemapropertypropertyindexinput) | `string` | *No description.* |
| [`masterInput`](#cdktfprovideroktaappuserbaseschemapropertypropertymasterinput) | `string` | *No description.* |
| [`patternInput`](#cdktfprovideroktaappuserbaseschemapropertypropertypatterninput) | `string` | *No description.* |
| [`permissionsInput`](#cdktfprovideroktaappuserbaseschemapropertypropertypermissionsinput) | `string` | *No description.* |
| [`requiredInput`](#cdktfprovideroktaappuserbaseschemapropertypropertyrequiredinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`titleInput`](#cdktfprovideroktaappuserbaseschemapropertypropertytitleinput) | `string` | *No description.* |
| [`typeInput`](#cdktfprovideroktaappuserbaseschemapropertypropertytypeinput) | `string` | *No description.* |
| [`userTypeInput`](#cdktfprovideroktaappuserbaseschemapropertypropertyusertypeinput) | `string` | *No description.* |
| [`appId`](#cdktfprovideroktaappuserbaseschemapropertypropertyappid)<span title="Required">*</span> | `string` | *No description.* |
| [`id`](#cdktfprovideroktaappuserbaseschemapropertypropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`index`](#cdktfprovideroktaappuserbaseschemapropertypropertyindex)<span title="Required">*</span> | `string` | *No description.* |
| [`master`](#cdktfprovideroktaappuserbaseschemapropertypropertymaster)<span title="Required">*</span> | `string` | *No description.* |
| [`pattern`](#cdktfprovideroktaappuserbaseschemapropertypropertypattern)<span title="Required">*</span> | `string` | *No description.* |
| [`permissions`](#cdktfprovideroktaappuserbaseschemapropertypropertypermissions)<span title="Required">*</span> | `string` | *No description.* |
| [`required`](#cdktfprovideroktaappuserbaseschemapropertypropertyrequired)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`title`](#cdktfprovideroktaappuserbaseschemapropertypropertytitle)<span title="Required">*</span> | `string` | *No description.* |
| [`type`](#cdktfprovideroktaappuserbaseschemapropertypropertytype)<span title="Required">*</span> | `string` | *No description.* |
| [`userType`](#cdktfprovideroktaappuserbaseschemapropertypropertyusertype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `appIdInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserBaseSchemaProperty.property.appIdInput" id="cdktfprovideroktaappuserbaseschemapropertypropertyappidinput"></a>

```typescript
public readonly appIdInput: string;
```

- *Type:* `string`

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserBaseSchemaProperty.property.idInput" id="cdktfprovideroktaappuserbaseschemapropertypropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `indexInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserBaseSchemaProperty.property.indexInput" id="cdktfprovideroktaappuserbaseschemapropertypropertyindexinput"></a>

```typescript
public readonly indexInput: string;
```

- *Type:* `string`

---

##### `masterInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserBaseSchemaProperty.property.masterInput" id="cdktfprovideroktaappuserbaseschemapropertypropertymasterinput"></a>

```typescript
public readonly masterInput: string;
```

- *Type:* `string`

---

##### `patternInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserBaseSchemaProperty.property.patternInput" id="cdktfprovideroktaappuserbaseschemapropertypropertypatterninput"></a>

```typescript
public readonly patternInput: string;
```

- *Type:* `string`

---

##### `permissionsInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserBaseSchemaProperty.property.permissionsInput" id="cdktfprovideroktaappuserbaseschemapropertypropertypermissionsinput"></a>

```typescript
public readonly permissionsInput: string;
```

- *Type:* `string`

---

##### `requiredInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserBaseSchemaProperty.property.requiredInput" id="cdktfprovideroktaappuserbaseschemapropertypropertyrequiredinput"></a>

```typescript
public readonly requiredInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `titleInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserBaseSchemaProperty.property.titleInput" id="cdktfprovideroktaappuserbaseschemapropertypropertytitleinput"></a>

```typescript
public readonly titleInput: string;
```

- *Type:* `string`

---

##### `typeInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserBaseSchemaProperty.property.typeInput" id="cdktfprovideroktaappuserbaseschemapropertypropertytypeinput"></a>

```typescript
public readonly typeInput: string;
```

- *Type:* `string`

---

##### `userTypeInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserBaseSchemaProperty.property.userTypeInput" id="cdktfprovideroktaappuserbaseschemapropertypropertyusertypeinput"></a>

```typescript
public readonly userTypeInput: string;
```

- *Type:* `string`

---

##### `appId`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserBaseSchemaProperty.property.appId" id="cdktfprovideroktaappuserbaseschemapropertypropertyappid"></a>

```typescript
public readonly appId: string;
```

- *Type:* `string`

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserBaseSchemaProperty.property.id" id="cdktfprovideroktaappuserbaseschemapropertypropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `index`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserBaseSchemaProperty.property.index" id="cdktfprovideroktaappuserbaseschemapropertypropertyindex"></a>

```typescript
public readonly index: string;
```

- *Type:* `string`

---

##### `master`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserBaseSchemaProperty.property.master" id="cdktfprovideroktaappuserbaseschemapropertypropertymaster"></a>

```typescript
public readonly master: string;
```

- *Type:* `string`

---

##### `pattern`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserBaseSchemaProperty.property.pattern" id="cdktfprovideroktaappuserbaseschemapropertypropertypattern"></a>

```typescript
public readonly pattern: string;
```

- *Type:* `string`

---

##### `permissions`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserBaseSchemaProperty.property.permissions" id="cdktfprovideroktaappuserbaseschemapropertypropertypermissions"></a>

```typescript
public readonly permissions: string;
```

- *Type:* `string`

---

##### `required`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserBaseSchemaProperty.property.required" id="cdktfprovideroktaappuserbaseschemapropertypropertyrequired"></a>

```typescript
public readonly required: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `title`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserBaseSchemaProperty.property.title" id="cdktfprovideroktaappuserbaseschemapropertypropertytitle"></a>

```typescript
public readonly title: string;
```

- *Type:* `string`

---

##### `type`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserBaseSchemaProperty.property.type" id="cdktfprovideroktaappuserbaseschemapropertypropertytype"></a>

```typescript
public readonly type: string;
```

- *Type:* `string`

---

##### `userType`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserBaseSchemaProperty.property.userType" id="cdktfprovideroktaappuserbaseschemapropertypropertyusertype"></a>

```typescript
public readonly userType: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktaappuserbaseschemapropertypropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.AppUserBaseSchemaProperty.property.tfResourceType" id="cdktfprovideroktaappuserbaseschemapropertypropertytfresourcetype"></a>

- *Type:* `string`

---

### AppUserSchema <a name="@cdktf/provider-okta.AppUserSchema" id="cdktfprovideroktaappuserschema"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema okta_app_user_schema}.

#### Initializers <a name="@cdktf/provider-okta.AppUserSchema.Initializer" id="cdktfprovideroktaappuserschemainitializer"></a>

```typescript
import { AppUserSchema } from '@cdktf/provider-okta'

new AppUserSchema(scope: Construct, id: string, config: AppUserSchemaConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktaappuserschemaparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktaappuserschemaparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktaappuserschemaparameterconfig)<span title="Required">*</span> | [`@cdktf/provider-okta.AppUserSchemaConfig`](#@cdktf/provider-okta.AppUserSchemaConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserSchema.parameter.scope" id="cdktfprovideroktaappuserschemaparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserSchema.parameter.id" id="cdktfprovideroktaappuserschemaparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserSchema.parameter.config" id="cdktfprovideroktaappuserschemaparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.AppUserSchemaConfig`](#@cdktf/provider-okta.AppUserSchemaConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`putArrayOneOf`](#cdktfprovideroktaappuserschemaputarrayoneof) | *No description.* |
| [`putOneOf`](#cdktfprovideroktaappuserschemaputoneof) | *No description.* |
| [`resetArrayEnum`](#cdktfprovideroktaappuserschemaresetarrayenum) | *No description.* |
| [`resetArrayOneOf`](#cdktfprovideroktaappuserschemaresetarrayoneof) | *No description.* |
| [`resetArrayType`](#cdktfprovideroktaappuserschemaresetarraytype) | *No description.* |
| [`resetDescription`](#cdktfprovideroktaappuserschemaresetdescription) | *No description.* |
| [`resetEnum`](#cdktfprovideroktaappuserschemaresetenum) | *No description.* |
| [`resetExternalName`](#cdktfprovideroktaappuserschemaresetexternalname) | *No description.* |
| [`resetExternalNamespace`](#cdktfprovideroktaappuserschemaresetexternalnamespace) | *No description.* |
| [`resetId`](#cdktfprovideroktaappuserschemaresetid) | *No description.* |
| [`resetMaster`](#cdktfprovideroktaappuserschemaresetmaster) | *No description.* |
| [`resetMaxLength`](#cdktfprovideroktaappuserschemaresetmaxlength) | *No description.* |
| [`resetMinLength`](#cdktfprovideroktaappuserschemaresetminlength) | *No description.* |
| [`resetOneOf`](#cdktfprovideroktaappuserschemaresetoneof) | *No description.* |
| [`resetPermissions`](#cdktfprovideroktaappuserschemaresetpermissions) | *No description.* |
| [`resetRequired`](#cdktfprovideroktaappuserschemaresetrequired) | *No description.* |
| [`resetScope`](#cdktfprovideroktaappuserschemaresetscope) | *No description.* |
| [`resetUnion`](#cdktfprovideroktaappuserschemaresetunion) | *No description.* |
| [`resetUnique`](#cdktfprovideroktaappuserschemaresetunique) | *No description.* |
| [`resetUserType`](#cdktfprovideroktaappuserschemaresetusertype) | *No description.* |

---

##### `putArrayOneOf` <a name="@cdktf/provider-okta.AppUserSchema.putArrayOneOf" id="cdktfprovideroktaappuserschemaputarrayoneof"></a>

```typescript
public putArrayOneOf(value: IResolvable | AppUserSchemaArrayOneOf[])
```

###### `value`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserSchema.parameter.value" id="cdktfprovideroktaappuserschemaparametervalue"></a>

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable) | [`@cdktf/provider-okta.AppUserSchemaArrayOneOf`](#@cdktf/provider-okta.AppUserSchemaArrayOneOf)[]

---

##### `putOneOf` <a name="@cdktf/provider-okta.AppUserSchema.putOneOf" id="cdktfprovideroktaappuserschemaputoneof"></a>

```typescript
public putOneOf(value: IResolvable | AppUserSchemaOneOf[])
```

###### `value`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserSchema.parameter.value" id="cdktfprovideroktaappuserschemaparametervalue"></a>

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable) | [`@cdktf/provider-okta.AppUserSchemaOneOf`](#@cdktf/provider-okta.AppUserSchemaOneOf)[]

---

##### `resetArrayEnum` <a name="@cdktf/provider-okta.AppUserSchema.resetArrayEnum" id="cdktfprovideroktaappuserschemaresetarrayenum"></a>

```typescript
public resetArrayEnum()
```

##### `resetArrayOneOf` <a name="@cdktf/provider-okta.AppUserSchema.resetArrayOneOf" id="cdktfprovideroktaappuserschemaresetarrayoneof"></a>

```typescript
public resetArrayOneOf()
```

##### `resetArrayType` <a name="@cdktf/provider-okta.AppUserSchema.resetArrayType" id="cdktfprovideroktaappuserschemaresetarraytype"></a>

```typescript
public resetArrayType()
```

##### `resetDescription` <a name="@cdktf/provider-okta.AppUserSchema.resetDescription" id="cdktfprovideroktaappuserschemaresetdescription"></a>

```typescript
public resetDescription()
```

##### `resetEnum` <a name="@cdktf/provider-okta.AppUserSchema.resetEnum" id="cdktfprovideroktaappuserschemaresetenum"></a>

```typescript
public resetEnum()
```

##### `resetExternalName` <a name="@cdktf/provider-okta.AppUserSchema.resetExternalName" id="cdktfprovideroktaappuserschemaresetexternalname"></a>

```typescript
public resetExternalName()
```

##### `resetExternalNamespace` <a name="@cdktf/provider-okta.AppUserSchema.resetExternalNamespace" id="cdktfprovideroktaappuserschemaresetexternalnamespace"></a>

```typescript
public resetExternalNamespace()
```

##### `resetId` <a name="@cdktf/provider-okta.AppUserSchema.resetId" id="cdktfprovideroktaappuserschemaresetid"></a>

```typescript
public resetId()
```

##### `resetMaster` <a name="@cdktf/provider-okta.AppUserSchema.resetMaster" id="cdktfprovideroktaappuserschemaresetmaster"></a>

```typescript
public resetMaster()
```

##### `resetMaxLength` <a name="@cdktf/provider-okta.AppUserSchema.resetMaxLength" id="cdktfprovideroktaappuserschemaresetmaxlength"></a>

```typescript
public resetMaxLength()
```

##### `resetMinLength` <a name="@cdktf/provider-okta.AppUserSchema.resetMinLength" id="cdktfprovideroktaappuserschemaresetminlength"></a>

```typescript
public resetMinLength()
```

##### `resetOneOf` <a name="@cdktf/provider-okta.AppUserSchema.resetOneOf" id="cdktfprovideroktaappuserschemaresetoneof"></a>

```typescript
public resetOneOf()
```

##### `resetPermissions` <a name="@cdktf/provider-okta.AppUserSchema.resetPermissions" id="cdktfprovideroktaappuserschemaresetpermissions"></a>

```typescript
public resetPermissions()
```

##### `resetRequired` <a name="@cdktf/provider-okta.AppUserSchema.resetRequired" id="cdktfprovideroktaappuserschemaresetrequired"></a>

```typescript
public resetRequired()
```

##### `resetScope` <a name="@cdktf/provider-okta.AppUserSchema.resetScope" id="cdktfprovideroktaappuserschemaresetscope"></a>

```typescript
public resetScope()
```

##### `resetUnion` <a name="@cdktf/provider-okta.AppUserSchema.resetUnion" id="cdktfprovideroktaappuserschemaresetunion"></a>

```typescript
public resetUnion()
```

##### `resetUnique` <a name="@cdktf/provider-okta.AppUserSchema.resetUnique" id="cdktfprovideroktaappuserschemaresetunique"></a>

```typescript
public resetUnique()
```

##### `resetUserType` <a name="@cdktf/provider-okta.AppUserSchema.resetUserType" id="cdktfprovideroktaappuserschemaresetusertype"></a>

```typescript
public resetUserType()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`arrayOneOf`](#cdktfprovideroktaappuserschemapropertyarrayoneof)<span title="Required">*</span> | [`@cdktf/provider-okta.AppUserSchemaArrayOneOfList`](#@cdktf/provider-okta.AppUserSchemaArrayOneOfList) | *No description.* |
| [`oneOf`](#cdktfprovideroktaappuserschemapropertyoneof)<span title="Required">*</span> | [`@cdktf/provider-okta.AppUserSchemaOneOfList`](#@cdktf/provider-okta.AppUserSchemaOneOfList) | *No description.* |
| [`appIdInput`](#cdktfprovideroktaappuserschemapropertyappidinput) | `string` | *No description.* |
| [`arrayEnumInput`](#cdktfprovideroktaappuserschemapropertyarrayenuminput) | `string`[] | *No description.* |
| [`arrayOneOfInput`](#cdktfprovideroktaappuserschemapropertyarrayoneofinput) | [`cdktf.IResolvable`](#cdktf.IResolvable) \| [`@cdktf/provider-okta.AppUserSchemaArrayOneOf`](#@cdktf/provider-okta.AppUserSchemaArrayOneOf)[] | *No description.* |
| [`arrayTypeInput`](#cdktfprovideroktaappuserschemapropertyarraytypeinput) | `string` | *No description.* |
| [`descriptionInput`](#cdktfprovideroktaappuserschemapropertydescriptioninput) | `string` | *No description.* |
| [`enumInput`](#cdktfprovideroktaappuserschemapropertyenuminput) | `string`[] | *No description.* |
| [`externalNameInput`](#cdktfprovideroktaappuserschemapropertyexternalnameinput) | `string` | *No description.* |
| [`externalNamespaceInput`](#cdktfprovideroktaappuserschemapropertyexternalnamespaceinput) | `string` | *No description.* |
| [`idInput`](#cdktfprovideroktaappuserschemapropertyidinput) | `string` | *No description.* |
| [`indexInput`](#cdktfprovideroktaappuserschemapropertyindexinput) | `string` | *No description.* |
| [`masterInput`](#cdktfprovideroktaappuserschemapropertymasterinput) | `string` | *No description.* |
| [`maxLengthInput`](#cdktfprovideroktaappuserschemapropertymaxlengthinput) | `number` | *No description.* |
| [`minLengthInput`](#cdktfprovideroktaappuserschemapropertyminlengthinput) | `number` | *No description.* |
| [`oneOfInput`](#cdktfprovideroktaappuserschemapropertyoneofinput) | [`cdktf.IResolvable`](#cdktf.IResolvable) \| [`@cdktf/provider-okta.AppUserSchemaOneOf`](#@cdktf/provider-okta.AppUserSchemaOneOf)[] | *No description.* |
| [`permissionsInput`](#cdktfprovideroktaappuserschemapropertypermissionsinput) | `string` | *No description.* |
| [`requiredInput`](#cdktfprovideroktaappuserschemapropertyrequiredinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`scopeInput`](#cdktfprovideroktaappuserschemapropertyscopeinput) | `string` | *No description.* |
| [`titleInput`](#cdktfprovideroktaappuserschemapropertytitleinput) | `string` | *No description.* |
| [`typeInput`](#cdktfprovideroktaappuserschemapropertytypeinput) | `string` | *No description.* |
| [`unionInput`](#cdktfprovideroktaappuserschemapropertyunioninput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`uniqueInput`](#cdktfprovideroktaappuserschemapropertyuniqueinput) | `string` | *No description.* |
| [`userTypeInput`](#cdktfprovideroktaappuserschemapropertyusertypeinput) | `string` | *No description.* |
| [`appId`](#cdktfprovideroktaappuserschemapropertyappid)<span title="Required">*</span> | `string` | *No description.* |
| [`arrayEnum`](#cdktfprovideroktaappuserschemapropertyarrayenum)<span title="Required">*</span> | `string`[] | *No description.* |
| [`arrayType`](#cdktfprovideroktaappuserschemapropertyarraytype)<span title="Required">*</span> | `string` | *No description.* |
| [`description`](#cdktfprovideroktaappuserschemapropertydescription)<span title="Required">*</span> | `string` | *No description.* |
| [`enum`](#cdktfprovideroktaappuserschemapropertyenum)<span title="Required">*</span> | `string`[] | *No description.* |
| [`externalName`](#cdktfprovideroktaappuserschemapropertyexternalname)<span title="Required">*</span> | `string` | *No description.* |
| [`externalNamespace`](#cdktfprovideroktaappuserschemapropertyexternalnamespace)<span title="Required">*</span> | `string` | *No description.* |
| [`id`](#cdktfprovideroktaappuserschemapropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`index`](#cdktfprovideroktaappuserschemapropertyindex)<span title="Required">*</span> | `string` | *No description.* |
| [`master`](#cdktfprovideroktaappuserschemapropertymaster)<span title="Required">*</span> | `string` | *No description.* |
| [`maxLength`](#cdktfprovideroktaappuserschemapropertymaxlength)<span title="Required">*</span> | `number` | *No description.* |
| [`minLength`](#cdktfprovideroktaappuserschemapropertyminlength)<span title="Required">*</span> | `number` | *No description.* |
| [`permissions`](#cdktfprovideroktaappuserschemapropertypermissions)<span title="Required">*</span> | `string` | *No description.* |
| [`required`](#cdktfprovideroktaappuserschemapropertyrequired)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`scope`](#cdktfprovideroktaappuserschemapropertyscope)<span title="Required">*</span> | `string` | *No description.* |
| [`title`](#cdktfprovideroktaappuserschemapropertytitle)<span title="Required">*</span> | `string` | *No description.* |
| [`type`](#cdktfprovideroktaappuserschemapropertytype)<span title="Required">*</span> | `string` | *No description.* |
| [`union`](#cdktfprovideroktaappuserschemapropertyunion)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`unique`](#cdktfprovideroktaappuserschemapropertyunique)<span title="Required">*</span> | `string` | *No description.* |
| [`userType`](#cdktfprovideroktaappuserschemapropertyusertype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `arrayOneOf`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserSchema.property.arrayOneOf" id="cdktfprovideroktaappuserschemapropertyarrayoneof"></a>

```typescript
public readonly arrayOneOf: AppUserSchemaArrayOneOfList;
```

- *Type:* [`@cdktf/provider-okta.AppUserSchemaArrayOneOfList`](#@cdktf/provider-okta.AppUserSchemaArrayOneOfList)

---

##### `oneOf`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserSchema.property.oneOf" id="cdktfprovideroktaappuserschemapropertyoneof"></a>

```typescript
public readonly oneOf: AppUserSchemaOneOfList;
```

- *Type:* [`@cdktf/provider-okta.AppUserSchemaOneOfList`](#@cdktf/provider-okta.AppUserSchemaOneOfList)

---

##### `appIdInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserSchema.property.appIdInput" id="cdktfprovideroktaappuserschemapropertyappidinput"></a>

```typescript
public readonly appIdInput: string;
```

- *Type:* `string`

---

##### `arrayEnumInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserSchema.property.arrayEnumInput" id="cdktfprovideroktaappuserschemapropertyarrayenuminput"></a>

```typescript
public readonly arrayEnumInput: string[];
```

- *Type:* `string`[]

---

##### `arrayOneOfInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserSchema.property.arrayOneOfInput" id="cdktfprovideroktaappuserschemapropertyarrayoneofinput"></a>

```typescript
public readonly arrayOneOfInput: IResolvable | AppUserSchemaArrayOneOf[];
```

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable) | [`@cdktf/provider-okta.AppUserSchemaArrayOneOf`](#@cdktf/provider-okta.AppUserSchemaArrayOneOf)[]

---

##### `arrayTypeInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserSchema.property.arrayTypeInput" id="cdktfprovideroktaappuserschemapropertyarraytypeinput"></a>

```typescript
public readonly arrayTypeInput: string;
```

- *Type:* `string`

---

##### `descriptionInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserSchema.property.descriptionInput" id="cdktfprovideroktaappuserschemapropertydescriptioninput"></a>

```typescript
public readonly descriptionInput: string;
```

- *Type:* `string`

---

##### `enumInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserSchema.property.enumInput" id="cdktfprovideroktaappuserschemapropertyenuminput"></a>

```typescript
public readonly enumInput: string[];
```

- *Type:* `string`[]

---

##### `externalNameInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserSchema.property.externalNameInput" id="cdktfprovideroktaappuserschemapropertyexternalnameinput"></a>

```typescript
public readonly externalNameInput: string;
```

- *Type:* `string`

---

##### `externalNamespaceInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserSchema.property.externalNamespaceInput" id="cdktfprovideroktaappuserschemapropertyexternalnamespaceinput"></a>

```typescript
public readonly externalNamespaceInput: string;
```

- *Type:* `string`

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserSchema.property.idInput" id="cdktfprovideroktaappuserschemapropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `indexInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserSchema.property.indexInput" id="cdktfprovideroktaappuserschemapropertyindexinput"></a>

```typescript
public readonly indexInput: string;
```

- *Type:* `string`

---

##### `masterInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserSchema.property.masterInput" id="cdktfprovideroktaappuserschemapropertymasterinput"></a>

```typescript
public readonly masterInput: string;
```

- *Type:* `string`

---

##### `maxLengthInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserSchema.property.maxLengthInput" id="cdktfprovideroktaappuserschemapropertymaxlengthinput"></a>

```typescript
public readonly maxLengthInput: number;
```

- *Type:* `number`

---

##### `minLengthInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserSchema.property.minLengthInput" id="cdktfprovideroktaappuserschemapropertyminlengthinput"></a>

```typescript
public readonly minLengthInput: number;
```

- *Type:* `number`

---

##### `oneOfInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserSchema.property.oneOfInput" id="cdktfprovideroktaappuserschemapropertyoneofinput"></a>

```typescript
public readonly oneOfInput: IResolvable | AppUserSchemaOneOf[];
```

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable) | [`@cdktf/provider-okta.AppUserSchemaOneOf`](#@cdktf/provider-okta.AppUserSchemaOneOf)[]

---

##### `permissionsInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserSchema.property.permissionsInput" id="cdktfprovideroktaappuserschemapropertypermissionsinput"></a>

```typescript
public readonly permissionsInput: string;
```

- *Type:* `string`

---

##### `requiredInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserSchema.property.requiredInput" id="cdktfprovideroktaappuserschemapropertyrequiredinput"></a>

```typescript
public readonly requiredInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `scopeInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserSchema.property.scopeInput" id="cdktfprovideroktaappuserschemapropertyscopeinput"></a>

```typescript
public readonly scopeInput: string;
```

- *Type:* `string`

---

##### `titleInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserSchema.property.titleInput" id="cdktfprovideroktaappuserschemapropertytitleinput"></a>

```typescript
public readonly titleInput: string;
```

- *Type:* `string`

---

##### `typeInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserSchema.property.typeInput" id="cdktfprovideroktaappuserschemapropertytypeinput"></a>

```typescript
public readonly typeInput: string;
```

- *Type:* `string`

---

##### `unionInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserSchema.property.unionInput" id="cdktfprovideroktaappuserschemapropertyunioninput"></a>

```typescript
public readonly unionInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `uniqueInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserSchema.property.uniqueInput" id="cdktfprovideroktaappuserschemapropertyuniqueinput"></a>

```typescript
public readonly uniqueInput: string;
```

- *Type:* `string`

---

##### `userTypeInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserSchema.property.userTypeInput" id="cdktfprovideroktaappuserschemapropertyusertypeinput"></a>

```typescript
public readonly userTypeInput: string;
```

- *Type:* `string`

---

##### `appId`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserSchema.property.appId" id="cdktfprovideroktaappuserschemapropertyappid"></a>

```typescript
public readonly appId: string;
```

- *Type:* `string`

---

##### `arrayEnum`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserSchema.property.arrayEnum" id="cdktfprovideroktaappuserschemapropertyarrayenum"></a>

```typescript
public readonly arrayEnum: string[];
```

- *Type:* `string`[]

---

##### `arrayType`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserSchema.property.arrayType" id="cdktfprovideroktaappuserschemapropertyarraytype"></a>

```typescript
public readonly arrayType: string;
```

- *Type:* `string`

---

##### `description`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserSchema.property.description" id="cdktfprovideroktaappuserschemapropertydescription"></a>

```typescript
public readonly description: string;
```

- *Type:* `string`

---

##### `enum`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserSchema.property.enum" id="cdktfprovideroktaappuserschemapropertyenum"></a>

```typescript
public readonly enum: string[];
```

- *Type:* `string`[]

---

##### `externalName`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserSchema.property.externalName" id="cdktfprovideroktaappuserschemapropertyexternalname"></a>

```typescript
public readonly externalName: string;
```

- *Type:* `string`

---

##### `externalNamespace`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserSchema.property.externalNamespace" id="cdktfprovideroktaappuserschemapropertyexternalnamespace"></a>

```typescript
public readonly externalNamespace: string;
```

- *Type:* `string`

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserSchema.property.id" id="cdktfprovideroktaappuserschemapropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `index`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserSchema.property.index" id="cdktfprovideroktaappuserschemapropertyindex"></a>

```typescript
public readonly index: string;
```

- *Type:* `string`

---

##### `master`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserSchema.property.master" id="cdktfprovideroktaappuserschemapropertymaster"></a>

```typescript
public readonly master: string;
```

- *Type:* `string`

---

##### `maxLength`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserSchema.property.maxLength" id="cdktfprovideroktaappuserschemapropertymaxlength"></a>

```typescript
public readonly maxLength: number;
```

- *Type:* `number`

---

##### `minLength`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserSchema.property.minLength" id="cdktfprovideroktaappuserschemapropertyminlength"></a>

```typescript
public readonly minLength: number;
```

- *Type:* `number`

---

##### `permissions`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserSchema.property.permissions" id="cdktfprovideroktaappuserschemapropertypermissions"></a>

```typescript
public readonly permissions: string;
```

- *Type:* `string`

---

##### `required`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserSchema.property.required" id="cdktfprovideroktaappuserschemapropertyrequired"></a>

```typescript
public readonly required: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserSchema.property.scope" id="cdktfprovideroktaappuserschemapropertyscope"></a>

```typescript
public readonly scope: string;
```

- *Type:* `string`

---

##### `title`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserSchema.property.title" id="cdktfprovideroktaappuserschemapropertytitle"></a>

```typescript
public readonly title: string;
```

- *Type:* `string`

---

##### `type`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserSchema.property.type" id="cdktfprovideroktaappuserschemapropertytype"></a>

```typescript
public readonly type: string;
```

- *Type:* `string`

---

##### `union`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserSchema.property.union" id="cdktfprovideroktaappuserschemapropertyunion"></a>

```typescript
public readonly union: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `unique`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserSchema.property.unique" id="cdktfprovideroktaappuserschemapropertyunique"></a>

```typescript
public readonly unique: string;
```

- *Type:* `string`

---

##### `userType`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserSchema.property.userType" id="cdktfprovideroktaappuserschemapropertyusertype"></a>

```typescript
public readonly userType: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktaappuserschemapropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.AppUserSchema.property.tfResourceType" id="cdktfprovideroktaappuserschemapropertytfresourcetype"></a>

- *Type:* `string`

---

### AppUserSchemaProperty <a name="@cdktf/provider-okta.AppUserSchemaProperty" id="cdktfprovideroktaappuserschemaproperty"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema_property okta_app_user_schema_property}.

#### Initializers <a name="@cdktf/provider-okta.AppUserSchemaProperty.Initializer" id="cdktfprovideroktaappuserschemapropertyinitializer"></a>

```typescript
import { AppUserSchemaProperty } from '@cdktf/provider-okta'

new AppUserSchemaProperty(scope: Construct, id: string, config: AppUserSchemaPropertyConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktaappuserschemapropertyparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktaappuserschemapropertyparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktaappuserschemapropertyparameterconfig)<span title="Required">*</span> | [`@cdktf/provider-okta.AppUserSchemaPropertyConfig`](#@cdktf/provider-okta.AppUserSchemaPropertyConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserSchemaProperty.parameter.scope" id="cdktfprovideroktaappuserschemapropertyparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserSchemaProperty.parameter.id" id="cdktfprovideroktaappuserschemapropertyparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserSchemaProperty.parameter.config" id="cdktfprovideroktaappuserschemapropertyparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.AppUserSchemaPropertyConfig`](#@cdktf/provider-okta.AppUserSchemaPropertyConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`putArrayOneOf`](#cdktfprovideroktaappuserschemapropertyputarrayoneof) | *No description.* |
| [`putOneOf`](#cdktfprovideroktaappuserschemapropertyputoneof) | *No description.* |
| [`resetArrayEnum`](#cdktfprovideroktaappuserschemapropertyresetarrayenum) | *No description.* |
| [`resetArrayOneOf`](#cdktfprovideroktaappuserschemapropertyresetarrayoneof) | *No description.* |
| [`resetArrayType`](#cdktfprovideroktaappuserschemapropertyresetarraytype) | *No description.* |
| [`resetDescription`](#cdktfprovideroktaappuserschemapropertyresetdescription) | *No description.* |
| [`resetEnum`](#cdktfprovideroktaappuserschemapropertyresetenum) | *No description.* |
| [`resetExternalName`](#cdktfprovideroktaappuserschemapropertyresetexternalname) | *No description.* |
| [`resetExternalNamespace`](#cdktfprovideroktaappuserschemapropertyresetexternalnamespace) | *No description.* |
| [`resetId`](#cdktfprovideroktaappuserschemapropertyresetid) | *No description.* |
| [`resetMaster`](#cdktfprovideroktaappuserschemapropertyresetmaster) | *No description.* |
| [`resetMaxLength`](#cdktfprovideroktaappuserschemapropertyresetmaxlength) | *No description.* |
| [`resetMinLength`](#cdktfprovideroktaappuserschemapropertyresetminlength) | *No description.* |
| [`resetOneOf`](#cdktfprovideroktaappuserschemapropertyresetoneof) | *No description.* |
| [`resetPermissions`](#cdktfprovideroktaappuserschemapropertyresetpermissions) | *No description.* |
| [`resetRequired`](#cdktfprovideroktaappuserschemapropertyresetrequired) | *No description.* |
| [`resetScope`](#cdktfprovideroktaappuserschemapropertyresetscope) | *No description.* |
| [`resetUnion`](#cdktfprovideroktaappuserschemapropertyresetunion) | *No description.* |
| [`resetUnique`](#cdktfprovideroktaappuserschemapropertyresetunique) | *No description.* |
| [`resetUserType`](#cdktfprovideroktaappuserschemapropertyresetusertype) | *No description.* |

---

##### `putArrayOneOf` <a name="@cdktf/provider-okta.AppUserSchemaProperty.putArrayOneOf" id="cdktfprovideroktaappuserschemapropertyputarrayoneof"></a>

```typescript
public putArrayOneOf(value: IResolvable | AppUserSchemaPropertyArrayOneOf[])
```

###### `value`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserSchemaProperty.parameter.value" id="cdktfprovideroktaappuserschemapropertyparametervalue"></a>

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable) | [`@cdktf/provider-okta.AppUserSchemaPropertyArrayOneOf`](#@cdktf/provider-okta.AppUserSchemaPropertyArrayOneOf)[]

---

##### `putOneOf` <a name="@cdktf/provider-okta.AppUserSchemaProperty.putOneOf" id="cdktfprovideroktaappuserschemapropertyputoneof"></a>

```typescript
public putOneOf(value: IResolvable | AppUserSchemaPropertyOneOf[])
```

###### `value`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserSchemaProperty.parameter.value" id="cdktfprovideroktaappuserschemapropertyparametervalue"></a>

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable) | [`@cdktf/provider-okta.AppUserSchemaPropertyOneOf`](#@cdktf/provider-okta.AppUserSchemaPropertyOneOf)[]

---

##### `resetArrayEnum` <a name="@cdktf/provider-okta.AppUserSchemaProperty.resetArrayEnum" id="cdktfprovideroktaappuserschemapropertyresetarrayenum"></a>

```typescript
public resetArrayEnum()
```

##### `resetArrayOneOf` <a name="@cdktf/provider-okta.AppUserSchemaProperty.resetArrayOneOf" id="cdktfprovideroktaappuserschemapropertyresetarrayoneof"></a>

```typescript
public resetArrayOneOf()
```

##### `resetArrayType` <a name="@cdktf/provider-okta.AppUserSchemaProperty.resetArrayType" id="cdktfprovideroktaappuserschemapropertyresetarraytype"></a>

```typescript
public resetArrayType()
```

##### `resetDescription` <a name="@cdktf/provider-okta.AppUserSchemaProperty.resetDescription" id="cdktfprovideroktaappuserschemapropertyresetdescription"></a>

```typescript
public resetDescription()
```

##### `resetEnum` <a name="@cdktf/provider-okta.AppUserSchemaProperty.resetEnum" id="cdktfprovideroktaappuserschemapropertyresetenum"></a>

```typescript
public resetEnum()
```

##### `resetExternalName` <a name="@cdktf/provider-okta.AppUserSchemaProperty.resetExternalName" id="cdktfprovideroktaappuserschemapropertyresetexternalname"></a>

```typescript
public resetExternalName()
```

##### `resetExternalNamespace` <a name="@cdktf/provider-okta.AppUserSchemaProperty.resetExternalNamespace" id="cdktfprovideroktaappuserschemapropertyresetexternalnamespace"></a>

```typescript
public resetExternalNamespace()
```

##### `resetId` <a name="@cdktf/provider-okta.AppUserSchemaProperty.resetId" id="cdktfprovideroktaappuserschemapropertyresetid"></a>

```typescript
public resetId()
```

##### `resetMaster` <a name="@cdktf/provider-okta.AppUserSchemaProperty.resetMaster" id="cdktfprovideroktaappuserschemapropertyresetmaster"></a>

```typescript
public resetMaster()
```

##### `resetMaxLength` <a name="@cdktf/provider-okta.AppUserSchemaProperty.resetMaxLength" id="cdktfprovideroktaappuserschemapropertyresetmaxlength"></a>

```typescript
public resetMaxLength()
```

##### `resetMinLength` <a name="@cdktf/provider-okta.AppUserSchemaProperty.resetMinLength" id="cdktfprovideroktaappuserschemapropertyresetminlength"></a>

```typescript
public resetMinLength()
```

##### `resetOneOf` <a name="@cdktf/provider-okta.AppUserSchemaProperty.resetOneOf" id="cdktfprovideroktaappuserschemapropertyresetoneof"></a>

```typescript
public resetOneOf()
```

##### `resetPermissions` <a name="@cdktf/provider-okta.AppUserSchemaProperty.resetPermissions" id="cdktfprovideroktaappuserschemapropertyresetpermissions"></a>

```typescript
public resetPermissions()
```

##### `resetRequired` <a name="@cdktf/provider-okta.AppUserSchemaProperty.resetRequired" id="cdktfprovideroktaappuserschemapropertyresetrequired"></a>

```typescript
public resetRequired()
```

##### `resetScope` <a name="@cdktf/provider-okta.AppUserSchemaProperty.resetScope" id="cdktfprovideroktaappuserschemapropertyresetscope"></a>

```typescript
public resetScope()
```

##### `resetUnion` <a name="@cdktf/provider-okta.AppUserSchemaProperty.resetUnion" id="cdktfprovideroktaappuserschemapropertyresetunion"></a>

```typescript
public resetUnion()
```

##### `resetUnique` <a name="@cdktf/provider-okta.AppUserSchemaProperty.resetUnique" id="cdktfprovideroktaappuserschemapropertyresetunique"></a>

```typescript
public resetUnique()
```

##### `resetUserType` <a name="@cdktf/provider-okta.AppUserSchemaProperty.resetUserType" id="cdktfprovideroktaappuserschemapropertyresetusertype"></a>

```typescript
public resetUserType()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`arrayOneOf`](#cdktfprovideroktaappuserschemapropertypropertyarrayoneof)<span title="Required">*</span> | [`@cdktf/provider-okta.AppUserSchemaPropertyArrayOneOfList`](#@cdktf/provider-okta.AppUserSchemaPropertyArrayOneOfList) | *No description.* |
| [`oneOf`](#cdktfprovideroktaappuserschemapropertypropertyoneof)<span title="Required">*</span> | [`@cdktf/provider-okta.AppUserSchemaPropertyOneOfList`](#@cdktf/provider-okta.AppUserSchemaPropertyOneOfList) | *No description.* |
| [`appIdInput`](#cdktfprovideroktaappuserschemapropertypropertyappidinput) | `string` | *No description.* |
| [`arrayEnumInput`](#cdktfprovideroktaappuserschemapropertypropertyarrayenuminput) | `string`[] | *No description.* |
| [`arrayOneOfInput`](#cdktfprovideroktaappuserschemapropertypropertyarrayoneofinput) | [`cdktf.IResolvable`](#cdktf.IResolvable) \| [`@cdktf/provider-okta.AppUserSchemaPropertyArrayOneOf`](#@cdktf/provider-okta.AppUserSchemaPropertyArrayOneOf)[] | *No description.* |
| [`arrayTypeInput`](#cdktfprovideroktaappuserschemapropertypropertyarraytypeinput) | `string` | *No description.* |
| [`descriptionInput`](#cdktfprovideroktaappuserschemapropertypropertydescriptioninput) | `string` | *No description.* |
| [`enumInput`](#cdktfprovideroktaappuserschemapropertypropertyenuminput) | `string`[] | *No description.* |
| [`externalNameInput`](#cdktfprovideroktaappuserschemapropertypropertyexternalnameinput) | `string` | *No description.* |
| [`externalNamespaceInput`](#cdktfprovideroktaappuserschemapropertypropertyexternalnamespaceinput) | `string` | *No description.* |
| [`idInput`](#cdktfprovideroktaappuserschemapropertypropertyidinput) | `string` | *No description.* |
| [`indexInput`](#cdktfprovideroktaappuserschemapropertypropertyindexinput) | `string` | *No description.* |
| [`masterInput`](#cdktfprovideroktaappuserschemapropertypropertymasterinput) | `string` | *No description.* |
| [`maxLengthInput`](#cdktfprovideroktaappuserschemapropertypropertymaxlengthinput) | `number` | *No description.* |
| [`minLengthInput`](#cdktfprovideroktaappuserschemapropertypropertyminlengthinput) | `number` | *No description.* |
| [`oneOfInput`](#cdktfprovideroktaappuserschemapropertypropertyoneofinput) | [`cdktf.IResolvable`](#cdktf.IResolvable) \| [`@cdktf/provider-okta.AppUserSchemaPropertyOneOf`](#@cdktf/provider-okta.AppUserSchemaPropertyOneOf)[] | *No description.* |
| [`permissionsInput`](#cdktfprovideroktaappuserschemapropertypropertypermissionsinput) | `string` | *No description.* |
| [`requiredInput`](#cdktfprovideroktaappuserschemapropertypropertyrequiredinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`scopeInput`](#cdktfprovideroktaappuserschemapropertypropertyscopeinput) | `string` | *No description.* |
| [`titleInput`](#cdktfprovideroktaappuserschemapropertypropertytitleinput) | `string` | *No description.* |
| [`typeInput`](#cdktfprovideroktaappuserschemapropertypropertytypeinput) | `string` | *No description.* |
| [`unionInput`](#cdktfprovideroktaappuserschemapropertypropertyunioninput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`uniqueInput`](#cdktfprovideroktaappuserschemapropertypropertyuniqueinput) | `string` | *No description.* |
| [`userTypeInput`](#cdktfprovideroktaappuserschemapropertypropertyusertypeinput) | `string` | *No description.* |
| [`appId`](#cdktfprovideroktaappuserschemapropertypropertyappid)<span title="Required">*</span> | `string` | *No description.* |
| [`arrayEnum`](#cdktfprovideroktaappuserschemapropertypropertyarrayenum)<span title="Required">*</span> | `string`[] | *No description.* |
| [`arrayType`](#cdktfprovideroktaappuserschemapropertypropertyarraytype)<span title="Required">*</span> | `string` | *No description.* |
| [`description`](#cdktfprovideroktaappuserschemapropertypropertydescription)<span title="Required">*</span> | `string` | *No description.* |
| [`enum`](#cdktfprovideroktaappuserschemapropertypropertyenum)<span title="Required">*</span> | `string`[] | *No description.* |
| [`externalName`](#cdktfprovideroktaappuserschemapropertypropertyexternalname)<span title="Required">*</span> | `string` | *No description.* |
| [`externalNamespace`](#cdktfprovideroktaappuserschemapropertypropertyexternalnamespace)<span title="Required">*</span> | `string` | *No description.* |
| [`id`](#cdktfprovideroktaappuserschemapropertypropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`index`](#cdktfprovideroktaappuserschemapropertypropertyindex)<span title="Required">*</span> | `string` | *No description.* |
| [`master`](#cdktfprovideroktaappuserschemapropertypropertymaster)<span title="Required">*</span> | `string` | *No description.* |
| [`maxLength`](#cdktfprovideroktaappuserschemapropertypropertymaxlength)<span title="Required">*</span> | `number` | *No description.* |
| [`minLength`](#cdktfprovideroktaappuserschemapropertypropertyminlength)<span title="Required">*</span> | `number` | *No description.* |
| [`permissions`](#cdktfprovideroktaappuserschemapropertypropertypermissions)<span title="Required">*</span> | `string` | *No description.* |
| [`required`](#cdktfprovideroktaappuserschemapropertypropertyrequired)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`scope`](#cdktfprovideroktaappuserschemapropertypropertyscope)<span title="Required">*</span> | `string` | *No description.* |
| [`title`](#cdktfprovideroktaappuserschemapropertypropertytitle)<span title="Required">*</span> | `string` | *No description.* |
| [`type`](#cdktfprovideroktaappuserschemapropertypropertytype)<span title="Required">*</span> | `string` | *No description.* |
| [`union`](#cdktfprovideroktaappuserschemapropertypropertyunion)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`unique`](#cdktfprovideroktaappuserschemapropertypropertyunique)<span title="Required">*</span> | `string` | *No description.* |
| [`userType`](#cdktfprovideroktaappuserschemapropertypropertyusertype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `arrayOneOf`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserSchemaProperty.property.arrayOneOf" id="cdktfprovideroktaappuserschemapropertypropertyarrayoneof"></a>

```typescript
public readonly arrayOneOf: AppUserSchemaPropertyArrayOneOfList;
```

- *Type:* [`@cdktf/provider-okta.AppUserSchemaPropertyArrayOneOfList`](#@cdktf/provider-okta.AppUserSchemaPropertyArrayOneOfList)

---

##### `oneOf`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserSchemaProperty.property.oneOf" id="cdktfprovideroktaappuserschemapropertypropertyoneof"></a>

```typescript
public readonly oneOf: AppUserSchemaPropertyOneOfList;
```

- *Type:* [`@cdktf/provider-okta.AppUserSchemaPropertyOneOfList`](#@cdktf/provider-okta.AppUserSchemaPropertyOneOfList)

---

##### `appIdInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserSchemaProperty.property.appIdInput" id="cdktfprovideroktaappuserschemapropertypropertyappidinput"></a>

```typescript
public readonly appIdInput: string;
```

- *Type:* `string`

---

##### `arrayEnumInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserSchemaProperty.property.arrayEnumInput" id="cdktfprovideroktaappuserschemapropertypropertyarrayenuminput"></a>

```typescript
public readonly arrayEnumInput: string[];
```

- *Type:* `string`[]

---

##### `arrayOneOfInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserSchemaProperty.property.arrayOneOfInput" id="cdktfprovideroktaappuserschemapropertypropertyarrayoneofinput"></a>

```typescript
public readonly arrayOneOfInput: IResolvable | AppUserSchemaPropertyArrayOneOf[];
```

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable) | [`@cdktf/provider-okta.AppUserSchemaPropertyArrayOneOf`](#@cdktf/provider-okta.AppUserSchemaPropertyArrayOneOf)[]

---

##### `arrayTypeInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserSchemaProperty.property.arrayTypeInput" id="cdktfprovideroktaappuserschemapropertypropertyarraytypeinput"></a>

```typescript
public readonly arrayTypeInput: string;
```

- *Type:* `string`

---

##### `descriptionInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserSchemaProperty.property.descriptionInput" id="cdktfprovideroktaappuserschemapropertypropertydescriptioninput"></a>

```typescript
public readonly descriptionInput: string;
```

- *Type:* `string`

---

##### `enumInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserSchemaProperty.property.enumInput" id="cdktfprovideroktaappuserschemapropertypropertyenuminput"></a>

```typescript
public readonly enumInput: string[];
```

- *Type:* `string`[]

---

##### `externalNameInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserSchemaProperty.property.externalNameInput" id="cdktfprovideroktaappuserschemapropertypropertyexternalnameinput"></a>

```typescript
public readonly externalNameInput: string;
```

- *Type:* `string`

---

##### `externalNamespaceInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserSchemaProperty.property.externalNamespaceInput" id="cdktfprovideroktaappuserschemapropertypropertyexternalnamespaceinput"></a>

```typescript
public readonly externalNamespaceInput: string;
```

- *Type:* `string`

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserSchemaProperty.property.idInput" id="cdktfprovideroktaappuserschemapropertypropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `indexInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserSchemaProperty.property.indexInput" id="cdktfprovideroktaappuserschemapropertypropertyindexinput"></a>

```typescript
public readonly indexInput: string;
```

- *Type:* `string`

---

##### `masterInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserSchemaProperty.property.masterInput" id="cdktfprovideroktaappuserschemapropertypropertymasterinput"></a>

```typescript
public readonly masterInput: string;
```

- *Type:* `string`

---

##### `maxLengthInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserSchemaProperty.property.maxLengthInput" id="cdktfprovideroktaappuserschemapropertypropertymaxlengthinput"></a>

```typescript
public readonly maxLengthInput: number;
```

- *Type:* `number`

---

##### `minLengthInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserSchemaProperty.property.minLengthInput" id="cdktfprovideroktaappuserschemapropertypropertyminlengthinput"></a>

```typescript
public readonly minLengthInput: number;
```

- *Type:* `number`

---

##### `oneOfInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserSchemaProperty.property.oneOfInput" id="cdktfprovideroktaappuserschemapropertypropertyoneofinput"></a>

```typescript
public readonly oneOfInput: IResolvable | AppUserSchemaPropertyOneOf[];
```

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable) | [`@cdktf/provider-okta.AppUserSchemaPropertyOneOf`](#@cdktf/provider-okta.AppUserSchemaPropertyOneOf)[]

---

##### `permissionsInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserSchemaProperty.property.permissionsInput" id="cdktfprovideroktaappuserschemapropertypropertypermissionsinput"></a>

```typescript
public readonly permissionsInput: string;
```

- *Type:* `string`

---

##### `requiredInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserSchemaProperty.property.requiredInput" id="cdktfprovideroktaappuserschemapropertypropertyrequiredinput"></a>

```typescript
public readonly requiredInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `scopeInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserSchemaProperty.property.scopeInput" id="cdktfprovideroktaappuserschemapropertypropertyscopeinput"></a>

```typescript
public readonly scopeInput: string;
```

- *Type:* `string`

---

##### `titleInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserSchemaProperty.property.titleInput" id="cdktfprovideroktaappuserschemapropertypropertytitleinput"></a>

```typescript
public readonly titleInput: string;
```

- *Type:* `string`

---

##### `typeInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserSchemaProperty.property.typeInput" id="cdktfprovideroktaappuserschemapropertypropertytypeinput"></a>

```typescript
public readonly typeInput: string;
```

- *Type:* `string`

---

##### `unionInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserSchemaProperty.property.unionInput" id="cdktfprovideroktaappuserschemapropertypropertyunioninput"></a>

```typescript
public readonly unionInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `uniqueInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserSchemaProperty.property.uniqueInput" id="cdktfprovideroktaappuserschemapropertypropertyuniqueinput"></a>

```typescript
public readonly uniqueInput: string;
```

- *Type:* `string`

---

##### `userTypeInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AppUserSchemaProperty.property.userTypeInput" id="cdktfprovideroktaappuserschemapropertypropertyusertypeinput"></a>

```typescript
public readonly userTypeInput: string;
```

- *Type:* `string`

---

##### `appId`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserSchemaProperty.property.appId" id="cdktfprovideroktaappuserschemapropertypropertyappid"></a>

```typescript
public readonly appId: string;
```

- *Type:* `string`

---

##### `arrayEnum`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserSchemaProperty.property.arrayEnum" id="cdktfprovideroktaappuserschemapropertypropertyarrayenum"></a>

```typescript
public readonly arrayEnum: string[];
```

- *Type:* `string`[]

---

##### `arrayType`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserSchemaProperty.property.arrayType" id="cdktfprovideroktaappuserschemapropertypropertyarraytype"></a>

```typescript
public readonly arrayType: string;
```

- *Type:* `string`

---

##### `description`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserSchemaProperty.property.description" id="cdktfprovideroktaappuserschemapropertypropertydescription"></a>

```typescript
public readonly description: string;
```

- *Type:* `string`

---

##### `enum`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserSchemaProperty.property.enum" id="cdktfprovideroktaappuserschemapropertypropertyenum"></a>

```typescript
public readonly enum: string[];
```

- *Type:* `string`[]

---

##### `externalName`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserSchemaProperty.property.externalName" id="cdktfprovideroktaappuserschemapropertypropertyexternalname"></a>

```typescript
public readonly externalName: string;
```

- *Type:* `string`

---

##### `externalNamespace`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserSchemaProperty.property.externalNamespace" id="cdktfprovideroktaappuserschemapropertypropertyexternalnamespace"></a>

```typescript
public readonly externalNamespace: string;
```

- *Type:* `string`

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserSchemaProperty.property.id" id="cdktfprovideroktaappuserschemapropertypropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `index`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserSchemaProperty.property.index" id="cdktfprovideroktaappuserschemapropertypropertyindex"></a>

```typescript
public readonly index: string;
```

- *Type:* `string`

---

##### `master`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserSchemaProperty.property.master" id="cdktfprovideroktaappuserschemapropertypropertymaster"></a>

```typescript
public readonly master: string;
```

- *Type:* `string`

---

##### `maxLength`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserSchemaProperty.property.maxLength" id="cdktfprovideroktaappuserschemapropertypropertymaxlength"></a>

```typescript
public readonly maxLength: number;
```

- *Type:* `number`

---

##### `minLength`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserSchemaProperty.property.minLength" id="cdktfprovideroktaappuserschemapropertypropertyminlength"></a>

```typescript
public readonly minLength: number;
```

- *Type:* `number`

---

##### `permissions`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserSchemaProperty.property.permissions" id="cdktfprovideroktaappuserschemapropertypropertypermissions"></a>

```typescript
public readonly permissions: string;
```

- *Type:* `string`

---

##### `required`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserSchemaProperty.property.required" id="cdktfprovideroktaappuserschemapropertypropertyrequired"></a>

```typescript
public readonly required: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserSchemaProperty.property.scope" id="cdktfprovideroktaappuserschemapropertypropertyscope"></a>

```typescript
public readonly scope: string;
```

- *Type:* `string`

---

##### `title`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserSchemaProperty.property.title" id="cdktfprovideroktaappuserschemapropertypropertytitle"></a>

```typescript
public readonly title: string;
```

- *Type:* `string`

---

##### `type`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserSchemaProperty.property.type" id="cdktfprovideroktaappuserschemapropertypropertytype"></a>

```typescript
public readonly type: string;
```

- *Type:* `string`

---

##### `union`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserSchemaProperty.property.union" id="cdktfprovideroktaappuserschemapropertypropertyunion"></a>

```typescript
public readonly union: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `unique`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserSchemaProperty.property.unique" id="cdktfprovideroktaappuserschemapropertypropertyunique"></a>

```typescript
public readonly unique: string;
```

- *Type:* `string`

---

##### `userType`<sup>Required</sup> <a name="@cdktf/provider-okta.AppUserSchemaProperty.property.userType" id="cdktfprovideroktaappuserschemapropertypropertyusertype"></a>

```typescript
public readonly userType: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktaappuserschemapropertypropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.AppUserSchemaProperty.property.tfResourceType" id="cdktfprovideroktaappuserschemapropertypropertytfresourcetype"></a>

- *Type:* `string`

---

### Authenticator <a name="@cdktf/provider-okta.Authenticator" id="cdktfprovideroktaauthenticator"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/r/authenticator okta_authenticator}.

#### Initializers <a name="@cdktf/provider-okta.Authenticator.Initializer" id="cdktfprovideroktaauthenticatorinitializer"></a>

```typescript
import { Authenticator } from '@cdktf/provider-okta'

new Authenticator(scope: Construct, id: string, config: AuthenticatorConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktaauthenticatorparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktaauthenticatorparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktaauthenticatorparameterconfig)<span title="Required">*</span> | [`@cdktf/provider-okta.AuthenticatorConfig`](#@cdktf/provider-okta.AuthenticatorConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.Authenticator.parameter.scope" id="cdktfprovideroktaauthenticatorparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.Authenticator.parameter.id" id="cdktfprovideroktaauthenticatorparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="@cdktf/provider-okta.Authenticator.parameter.config" id="cdktfprovideroktaauthenticatorparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.AuthenticatorConfig`](#@cdktf/provider-okta.AuthenticatorConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`resetId`](#cdktfprovideroktaauthenticatorresetid) | *No description.* |
| [`resetProviderAuthPort`](#cdktfprovideroktaauthenticatorresetproviderauthport) | *No description.* |
| [`resetProviderHostname`](#cdktfprovideroktaauthenticatorresetproviderhostname) | *No description.* |
| [`resetProviderSharedSecret`](#cdktfprovideroktaauthenticatorresetprovidersharedsecret) | *No description.* |
| [`resetProviderUserNameTemplate`](#cdktfprovideroktaauthenticatorresetproviderusernametemplate) | *No description.* |
| [`resetSettings`](#cdktfprovideroktaauthenticatorresetsettings) | *No description.* |
| [`resetStatus`](#cdktfprovideroktaauthenticatorresetstatus) | *No description.* |

---

##### `resetId` <a name="@cdktf/provider-okta.Authenticator.resetId" id="cdktfprovideroktaauthenticatorresetid"></a>

```typescript
public resetId()
```

##### `resetProviderAuthPort` <a name="@cdktf/provider-okta.Authenticator.resetProviderAuthPort" id="cdktfprovideroktaauthenticatorresetproviderauthport"></a>

```typescript
public resetProviderAuthPort()
```

##### `resetProviderHostname` <a name="@cdktf/provider-okta.Authenticator.resetProviderHostname" id="cdktfprovideroktaauthenticatorresetproviderhostname"></a>

```typescript
public resetProviderHostname()
```

##### `resetProviderSharedSecret` <a name="@cdktf/provider-okta.Authenticator.resetProviderSharedSecret" id="cdktfprovideroktaauthenticatorresetprovidersharedsecret"></a>

```typescript
public resetProviderSharedSecret()
```

##### `resetProviderUserNameTemplate` <a name="@cdktf/provider-okta.Authenticator.resetProviderUserNameTemplate" id="cdktfprovideroktaauthenticatorresetproviderusernametemplate"></a>

```typescript
public resetProviderUserNameTemplate()
```

##### `resetSettings` <a name="@cdktf/provider-okta.Authenticator.resetSettings" id="cdktfprovideroktaauthenticatorresetsettings"></a>

```typescript
public resetSettings()
```

##### `resetStatus` <a name="@cdktf/provider-okta.Authenticator.resetStatus" id="cdktfprovideroktaauthenticatorresetstatus"></a>

```typescript
public resetStatus()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`providerInstanceId`](#cdktfprovideroktaauthenticatorpropertyproviderinstanceid)<span title="Required">*</span> | `string` | *No description.* |
| [`providerType`](#cdktfprovideroktaauthenticatorpropertyprovidertype)<span title="Required">*</span> | `string` | *No description.* |
| [`type`](#cdktfprovideroktaauthenticatorpropertytype)<span title="Required">*</span> | `string` | *No description.* |
| [`idInput`](#cdktfprovideroktaauthenticatorpropertyidinput) | `string` | *No description.* |
| [`keyInput`](#cdktfprovideroktaauthenticatorpropertykeyinput) | `string` | *No description.* |
| [`nameInput`](#cdktfprovideroktaauthenticatorpropertynameinput) | `string` | *No description.* |
| [`providerAuthPortInput`](#cdktfprovideroktaauthenticatorpropertyproviderauthportinput) | `number` | *No description.* |
| [`providerHostnameInput`](#cdktfprovideroktaauthenticatorpropertyproviderhostnameinput) | `string` | *No description.* |
| [`providerSharedSecretInput`](#cdktfprovideroktaauthenticatorpropertyprovidersharedsecretinput) | `string` | *No description.* |
| [`providerUserNameTemplateInput`](#cdktfprovideroktaauthenticatorpropertyproviderusernametemplateinput) | `string` | *No description.* |
| [`settingsInput`](#cdktfprovideroktaauthenticatorpropertysettingsinput) | `string` | *No description.* |
| [`statusInput`](#cdktfprovideroktaauthenticatorpropertystatusinput) | `string` | *No description.* |
| [`id`](#cdktfprovideroktaauthenticatorpropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`key`](#cdktfprovideroktaauthenticatorpropertykey)<span title="Required">*</span> | `string` | *No description.* |
| [`name`](#cdktfprovideroktaauthenticatorpropertyname)<span title="Required">*</span> | `string` | *No description.* |
| [`providerAuthPort`](#cdktfprovideroktaauthenticatorpropertyproviderauthport)<span title="Required">*</span> | `number` | *No description.* |
| [`providerHostname`](#cdktfprovideroktaauthenticatorpropertyproviderhostname)<span title="Required">*</span> | `string` | *No description.* |
| [`providerSharedSecret`](#cdktfprovideroktaauthenticatorpropertyprovidersharedsecret)<span title="Required">*</span> | `string` | *No description.* |
| [`providerUserNameTemplate`](#cdktfprovideroktaauthenticatorpropertyproviderusernametemplate)<span title="Required">*</span> | `string` | *No description.* |
| [`settings`](#cdktfprovideroktaauthenticatorpropertysettings)<span title="Required">*</span> | `string` | *No description.* |
| [`status`](#cdktfprovideroktaauthenticatorpropertystatus)<span title="Required">*</span> | `string` | *No description.* |

---

##### `providerInstanceId`<sup>Required</sup> <a name="@cdktf/provider-okta.Authenticator.property.providerInstanceId" id="cdktfprovideroktaauthenticatorpropertyproviderinstanceid"></a>

```typescript
public readonly providerInstanceId: string;
```

- *Type:* `string`

---

##### `providerType`<sup>Required</sup> <a name="@cdktf/provider-okta.Authenticator.property.providerType" id="cdktfprovideroktaauthenticatorpropertyprovidertype"></a>

```typescript
public readonly providerType: string;
```

- *Type:* `string`

---

##### `type`<sup>Required</sup> <a name="@cdktf/provider-okta.Authenticator.property.type" id="cdktfprovideroktaauthenticatorpropertytype"></a>

```typescript
public readonly type: string;
```

- *Type:* `string`

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.Authenticator.property.idInput" id="cdktfprovideroktaauthenticatorpropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `keyInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.Authenticator.property.keyInput" id="cdktfprovideroktaauthenticatorpropertykeyinput"></a>

```typescript
public readonly keyInput: string;
```

- *Type:* `string`

---

##### `nameInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.Authenticator.property.nameInput" id="cdktfprovideroktaauthenticatorpropertynameinput"></a>

```typescript
public readonly nameInput: string;
```

- *Type:* `string`

---

##### `providerAuthPortInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.Authenticator.property.providerAuthPortInput" id="cdktfprovideroktaauthenticatorpropertyproviderauthportinput"></a>

```typescript
public readonly providerAuthPortInput: number;
```

- *Type:* `number`

---

##### `providerHostnameInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.Authenticator.property.providerHostnameInput" id="cdktfprovideroktaauthenticatorpropertyproviderhostnameinput"></a>

```typescript
public readonly providerHostnameInput: string;
```

- *Type:* `string`

---

##### `providerSharedSecretInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.Authenticator.property.providerSharedSecretInput" id="cdktfprovideroktaauthenticatorpropertyprovidersharedsecretinput"></a>

```typescript
public readonly providerSharedSecretInput: string;
```

- *Type:* `string`

---

##### `providerUserNameTemplateInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.Authenticator.property.providerUserNameTemplateInput" id="cdktfprovideroktaauthenticatorpropertyproviderusernametemplateinput"></a>

```typescript
public readonly providerUserNameTemplateInput: string;
```

- *Type:* `string`

---

##### `settingsInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.Authenticator.property.settingsInput" id="cdktfprovideroktaauthenticatorpropertysettingsinput"></a>

```typescript
public readonly settingsInput: string;
```

- *Type:* `string`

---

##### `statusInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.Authenticator.property.statusInput" id="cdktfprovideroktaauthenticatorpropertystatusinput"></a>

```typescript
public readonly statusInput: string;
```

- *Type:* `string`

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.Authenticator.property.id" id="cdktfprovideroktaauthenticatorpropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `key`<sup>Required</sup> <a name="@cdktf/provider-okta.Authenticator.property.key" id="cdktfprovideroktaauthenticatorpropertykey"></a>

```typescript
public readonly key: string;
```

- *Type:* `string`

---

##### `name`<sup>Required</sup> <a name="@cdktf/provider-okta.Authenticator.property.name" id="cdktfprovideroktaauthenticatorpropertyname"></a>

```typescript
public readonly name: string;
```

- *Type:* `string`

---

##### `providerAuthPort`<sup>Required</sup> <a name="@cdktf/provider-okta.Authenticator.property.providerAuthPort" id="cdktfprovideroktaauthenticatorpropertyproviderauthport"></a>

```typescript
public readonly providerAuthPort: number;
```

- *Type:* `number`

---

##### `providerHostname`<sup>Required</sup> <a name="@cdktf/provider-okta.Authenticator.property.providerHostname" id="cdktfprovideroktaauthenticatorpropertyproviderhostname"></a>

```typescript
public readonly providerHostname: string;
```

- *Type:* `string`

---

##### `providerSharedSecret`<sup>Required</sup> <a name="@cdktf/provider-okta.Authenticator.property.providerSharedSecret" id="cdktfprovideroktaauthenticatorpropertyprovidersharedsecret"></a>

```typescript
public readonly providerSharedSecret: string;
```

- *Type:* `string`

---

##### `providerUserNameTemplate`<sup>Required</sup> <a name="@cdktf/provider-okta.Authenticator.property.providerUserNameTemplate" id="cdktfprovideroktaauthenticatorpropertyproviderusernametemplate"></a>

```typescript
public readonly providerUserNameTemplate: string;
```

- *Type:* `string`

---

##### `settings`<sup>Required</sup> <a name="@cdktf/provider-okta.Authenticator.property.settings" id="cdktfprovideroktaauthenticatorpropertysettings"></a>

```typescript
public readonly settings: string;
```

- *Type:* `string`

---

##### `status`<sup>Required</sup> <a name="@cdktf/provider-okta.Authenticator.property.status" id="cdktfprovideroktaauthenticatorpropertystatus"></a>

```typescript
public readonly status: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktaauthenticatorpropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.Authenticator.property.tfResourceType" id="cdktfprovideroktaauthenticatorpropertytfresourcetype"></a>

- *Type:* `string`

---

### AuthServer <a name="@cdktf/provider-okta.AuthServer" id="cdktfprovideroktaauthserver"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/r/auth_server okta_auth_server}.

#### Initializers <a name="@cdktf/provider-okta.AuthServer.Initializer" id="cdktfprovideroktaauthserverinitializer"></a>

```typescript
import { AuthServer } from '@cdktf/provider-okta'

new AuthServer(scope: Construct, id: string, config: AuthServerConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktaauthserverparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktaauthserverparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktaauthserverparameterconfig)<span title="Required">*</span> | [`@cdktf/provider-okta.AuthServerConfig`](#@cdktf/provider-okta.AuthServerConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServer.parameter.scope" id="cdktfprovideroktaauthserverparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServer.parameter.id" id="cdktfprovideroktaauthserverparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServer.parameter.config" id="cdktfprovideroktaauthserverparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.AuthServerConfig`](#@cdktf/provider-okta.AuthServerConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`resetCredentialsRotationMode`](#cdktfprovideroktaauthserverresetcredentialsrotationmode) | *No description.* |
| [`resetDescription`](#cdktfprovideroktaauthserverresetdescription) | *No description.* |
| [`resetId`](#cdktfprovideroktaauthserverresetid) | *No description.* |
| [`resetIssuerMode`](#cdktfprovideroktaauthserverresetissuermode) | *No description.* |
| [`resetStatus`](#cdktfprovideroktaauthserverresetstatus) | *No description.* |

---

##### `resetCredentialsRotationMode` <a name="@cdktf/provider-okta.AuthServer.resetCredentialsRotationMode" id="cdktfprovideroktaauthserverresetcredentialsrotationmode"></a>

```typescript
public resetCredentialsRotationMode()
```

##### `resetDescription` <a name="@cdktf/provider-okta.AuthServer.resetDescription" id="cdktfprovideroktaauthserverresetdescription"></a>

```typescript
public resetDescription()
```

##### `resetId` <a name="@cdktf/provider-okta.AuthServer.resetId" id="cdktfprovideroktaauthserverresetid"></a>

```typescript
public resetId()
```

##### `resetIssuerMode` <a name="@cdktf/provider-okta.AuthServer.resetIssuerMode" id="cdktfprovideroktaauthserverresetissuermode"></a>

```typescript
public resetIssuerMode()
```

##### `resetStatus` <a name="@cdktf/provider-okta.AuthServer.resetStatus" id="cdktfprovideroktaauthserverresetstatus"></a>

```typescript
public resetStatus()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`credentialsLastRotated`](#cdktfprovideroktaauthserverpropertycredentialslastrotated)<span title="Required">*</span> | `string` | *No description.* |
| [`credentialsNextRotation`](#cdktfprovideroktaauthserverpropertycredentialsnextrotation)<span title="Required">*</span> | `string` | *No description.* |
| [`issuer`](#cdktfprovideroktaauthserverpropertyissuer)<span title="Required">*</span> | `string` | *No description.* |
| [`kid`](#cdktfprovideroktaauthserverpropertykid)<span title="Required">*</span> | `string` | *No description.* |
| [`audiencesInput`](#cdktfprovideroktaauthserverpropertyaudiencesinput) | `string`[] | *No description.* |
| [`credentialsRotationModeInput`](#cdktfprovideroktaauthserverpropertycredentialsrotationmodeinput) | `string` | *No description.* |
| [`descriptionInput`](#cdktfprovideroktaauthserverpropertydescriptioninput) | `string` | *No description.* |
| [`idInput`](#cdktfprovideroktaauthserverpropertyidinput) | `string` | *No description.* |
| [`issuerModeInput`](#cdktfprovideroktaauthserverpropertyissuermodeinput) | `string` | *No description.* |
| [`nameInput`](#cdktfprovideroktaauthserverpropertynameinput) | `string` | *No description.* |
| [`statusInput`](#cdktfprovideroktaauthserverpropertystatusinput) | `string` | *No description.* |
| [`audiences`](#cdktfprovideroktaauthserverpropertyaudiences)<span title="Required">*</span> | `string`[] | *No description.* |
| [`credentialsRotationMode`](#cdktfprovideroktaauthserverpropertycredentialsrotationmode)<span title="Required">*</span> | `string` | *No description.* |
| [`description`](#cdktfprovideroktaauthserverpropertydescription)<span title="Required">*</span> | `string` | *No description.* |
| [`id`](#cdktfprovideroktaauthserverpropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`issuerMode`](#cdktfprovideroktaauthserverpropertyissuermode)<span title="Required">*</span> | `string` | *No description.* |
| [`name`](#cdktfprovideroktaauthserverpropertyname)<span title="Required">*</span> | `string` | *No description.* |
| [`status`](#cdktfprovideroktaauthserverpropertystatus)<span title="Required">*</span> | `string` | *No description.* |

---

##### `credentialsLastRotated`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServer.property.credentialsLastRotated" id="cdktfprovideroktaauthserverpropertycredentialslastrotated"></a>

```typescript
public readonly credentialsLastRotated: string;
```

- *Type:* `string`

---

##### `credentialsNextRotation`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServer.property.credentialsNextRotation" id="cdktfprovideroktaauthserverpropertycredentialsnextrotation"></a>

```typescript
public readonly credentialsNextRotation: string;
```

- *Type:* `string`

---

##### `issuer`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServer.property.issuer" id="cdktfprovideroktaauthserverpropertyissuer"></a>

```typescript
public readonly issuer: string;
```

- *Type:* `string`

---

##### `kid`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServer.property.kid" id="cdktfprovideroktaauthserverpropertykid"></a>

```typescript
public readonly kid: string;
```

- *Type:* `string`

---

##### `audiencesInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServer.property.audiencesInput" id="cdktfprovideroktaauthserverpropertyaudiencesinput"></a>

```typescript
public readonly audiencesInput: string[];
```

- *Type:* `string`[]

---

##### `credentialsRotationModeInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServer.property.credentialsRotationModeInput" id="cdktfprovideroktaauthserverpropertycredentialsrotationmodeinput"></a>

```typescript
public readonly credentialsRotationModeInput: string;
```

- *Type:* `string`

---

##### `descriptionInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServer.property.descriptionInput" id="cdktfprovideroktaauthserverpropertydescriptioninput"></a>

```typescript
public readonly descriptionInput: string;
```

- *Type:* `string`

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServer.property.idInput" id="cdktfprovideroktaauthserverpropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `issuerModeInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServer.property.issuerModeInput" id="cdktfprovideroktaauthserverpropertyissuermodeinput"></a>

```typescript
public readonly issuerModeInput: string;
```

- *Type:* `string`

---

##### `nameInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServer.property.nameInput" id="cdktfprovideroktaauthserverpropertynameinput"></a>

```typescript
public readonly nameInput: string;
```

- *Type:* `string`

---

##### `statusInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServer.property.statusInput" id="cdktfprovideroktaauthserverpropertystatusinput"></a>

```typescript
public readonly statusInput: string;
```

- *Type:* `string`

---

##### `audiences`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServer.property.audiences" id="cdktfprovideroktaauthserverpropertyaudiences"></a>

```typescript
public readonly audiences: string[];
```

- *Type:* `string`[]

---

##### `credentialsRotationMode`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServer.property.credentialsRotationMode" id="cdktfprovideroktaauthserverpropertycredentialsrotationmode"></a>

```typescript
public readonly credentialsRotationMode: string;
```

- *Type:* `string`

---

##### `description`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServer.property.description" id="cdktfprovideroktaauthserverpropertydescription"></a>

```typescript
public readonly description: string;
```

- *Type:* `string`

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServer.property.id" id="cdktfprovideroktaauthserverpropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `issuerMode`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServer.property.issuerMode" id="cdktfprovideroktaauthserverpropertyissuermode"></a>

```typescript
public readonly issuerMode: string;
```

- *Type:* `string`

---

##### `name`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServer.property.name" id="cdktfprovideroktaauthserverpropertyname"></a>

```typescript
public readonly name: string;
```

- *Type:* `string`

---

##### `status`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServer.property.status" id="cdktfprovideroktaauthserverpropertystatus"></a>

```typescript
public readonly status: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktaauthserverpropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.AuthServer.property.tfResourceType" id="cdktfprovideroktaauthserverpropertytfresourcetype"></a>

- *Type:* `string`

---

### AuthServerClaim <a name="@cdktf/provider-okta.AuthServerClaim" id="cdktfprovideroktaauthserverclaim"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/r/auth_server_claim okta_auth_server_claim}.

#### Initializers <a name="@cdktf/provider-okta.AuthServerClaim.Initializer" id="cdktfprovideroktaauthserverclaiminitializer"></a>

```typescript
import { AuthServerClaim } from '@cdktf/provider-okta'

new AuthServerClaim(scope: Construct, id: string, config: AuthServerClaimConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktaauthserverclaimparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktaauthserverclaimparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktaauthserverclaimparameterconfig)<span title="Required">*</span> | [`@cdktf/provider-okta.AuthServerClaimConfig`](#@cdktf/provider-okta.AuthServerClaimConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerClaim.parameter.scope" id="cdktfprovideroktaauthserverclaimparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerClaim.parameter.id" id="cdktfprovideroktaauthserverclaimparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerClaim.parameter.config" id="cdktfprovideroktaauthserverclaimparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.AuthServerClaimConfig`](#@cdktf/provider-okta.AuthServerClaimConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`resetAlwaysIncludeInToken`](#cdktfprovideroktaauthserverclaimresetalwaysincludeintoken) | *No description.* |
| [`resetGroupFilterType`](#cdktfprovideroktaauthserverclaimresetgroupfiltertype) | *No description.* |
| [`resetId`](#cdktfprovideroktaauthserverclaimresetid) | *No description.* |
| [`resetScopes`](#cdktfprovideroktaauthserverclaimresetscopes) | *No description.* |
| [`resetStatus`](#cdktfprovideroktaauthserverclaimresetstatus) | *No description.* |
| [`resetValueType`](#cdktfprovideroktaauthserverclaimresetvaluetype) | *No description.* |

---

##### `resetAlwaysIncludeInToken` <a name="@cdktf/provider-okta.AuthServerClaim.resetAlwaysIncludeInToken" id="cdktfprovideroktaauthserverclaimresetalwaysincludeintoken"></a>

```typescript
public resetAlwaysIncludeInToken()
```

##### `resetGroupFilterType` <a name="@cdktf/provider-okta.AuthServerClaim.resetGroupFilterType" id="cdktfprovideroktaauthserverclaimresetgroupfiltertype"></a>

```typescript
public resetGroupFilterType()
```

##### `resetId` <a name="@cdktf/provider-okta.AuthServerClaim.resetId" id="cdktfprovideroktaauthserverclaimresetid"></a>

```typescript
public resetId()
```

##### `resetScopes` <a name="@cdktf/provider-okta.AuthServerClaim.resetScopes" id="cdktfprovideroktaauthserverclaimresetscopes"></a>

```typescript
public resetScopes()
```

##### `resetStatus` <a name="@cdktf/provider-okta.AuthServerClaim.resetStatus" id="cdktfprovideroktaauthserverclaimresetstatus"></a>

```typescript
public resetStatus()
```

##### `resetValueType` <a name="@cdktf/provider-okta.AuthServerClaim.resetValueType" id="cdktfprovideroktaauthserverclaimresetvaluetype"></a>

```typescript
public resetValueType()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`alwaysIncludeInTokenInput`](#cdktfprovideroktaauthserverclaimpropertyalwaysincludeintokeninput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`authServerIdInput`](#cdktfprovideroktaauthserverclaimpropertyauthserveridinput) | `string` | *No description.* |
| [`claimTypeInput`](#cdktfprovideroktaauthserverclaimpropertyclaimtypeinput) | `string` | *No description.* |
| [`groupFilterTypeInput`](#cdktfprovideroktaauthserverclaimpropertygroupfiltertypeinput) | `string` | *No description.* |
| [`idInput`](#cdktfprovideroktaauthserverclaimpropertyidinput) | `string` | *No description.* |
| [`nameInput`](#cdktfprovideroktaauthserverclaimpropertynameinput) | `string` | *No description.* |
| [`scopesInput`](#cdktfprovideroktaauthserverclaimpropertyscopesinput) | `string`[] | *No description.* |
| [`statusInput`](#cdktfprovideroktaauthserverclaimpropertystatusinput) | `string` | *No description.* |
| [`valueInput`](#cdktfprovideroktaauthserverclaimpropertyvalueinput) | `string` | *No description.* |
| [`valueTypeInput`](#cdktfprovideroktaauthserverclaimpropertyvaluetypeinput) | `string` | *No description.* |
| [`alwaysIncludeInToken`](#cdktfprovideroktaauthserverclaimpropertyalwaysincludeintoken)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`authServerId`](#cdktfprovideroktaauthserverclaimpropertyauthserverid)<span title="Required">*</span> | `string` | *No description.* |
| [`claimType`](#cdktfprovideroktaauthserverclaimpropertyclaimtype)<span title="Required">*</span> | `string` | *No description.* |
| [`groupFilterType`](#cdktfprovideroktaauthserverclaimpropertygroupfiltertype)<span title="Required">*</span> | `string` | *No description.* |
| [`id`](#cdktfprovideroktaauthserverclaimpropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`name`](#cdktfprovideroktaauthserverclaimpropertyname)<span title="Required">*</span> | `string` | *No description.* |
| [`scopes`](#cdktfprovideroktaauthserverclaimpropertyscopes)<span title="Required">*</span> | `string`[] | *No description.* |
| [`status`](#cdktfprovideroktaauthserverclaimpropertystatus)<span title="Required">*</span> | `string` | *No description.* |
| [`value`](#cdktfprovideroktaauthserverclaimpropertyvalue)<span title="Required">*</span> | `string` | *No description.* |
| [`valueType`](#cdktfprovideroktaauthserverclaimpropertyvaluetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `alwaysIncludeInTokenInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServerClaim.property.alwaysIncludeInTokenInput" id="cdktfprovideroktaauthserverclaimpropertyalwaysincludeintokeninput"></a>

```typescript
public readonly alwaysIncludeInTokenInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `authServerIdInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServerClaim.property.authServerIdInput" id="cdktfprovideroktaauthserverclaimpropertyauthserveridinput"></a>

```typescript
public readonly authServerIdInput: string;
```

- *Type:* `string`

---

##### `claimTypeInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServerClaim.property.claimTypeInput" id="cdktfprovideroktaauthserverclaimpropertyclaimtypeinput"></a>

```typescript
public readonly claimTypeInput: string;
```

- *Type:* `string`

---

##### `groupFilterTypeInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServerClaim.property.groupFilterTypeInput" id="cdktfprovideroktaauthserverclaimpropertygroupfiltertypeinput"></a>

```typescript
public readonly groupFilterTypeInput: string;
```

- *Type:* `string`

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServerClaim.property.idInput" id="cdktfprovideroktaauthserverclaimpropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `nameInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServerClaim.property.nameInput" id="cdktfprovideroktaauthserverclaimpropertynameinput"></a>

```typescript
public readonly nameInput: string;
```

- *Type:* `string`

---

##### `scopesInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServerClaim.property.scopesInput" id="cdktfprovideroktaauthserverclaimpropertyscopesinput"></a>

```typescript
public readonly scopesInput: string[];
```

- *Type:* `string`[]

---

##### `statusInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServerClaim.property.statusInput" id="cdktfprovideroktaauthserverclaimpropertystatusinput"></a>

```typescript
public readonly statusInput: string;
```

- *Type:* `string`

---

##### `valueInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServerClaim.property.valueInput" id="cdktfprovideroktaauthserverclaimpropertyvalueinput"></a>

```typescript
public readonly valueInput: string;
```

- *Type:* `string`

---

##### `valueTypeInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServerClaim.property.valueTypeInput" id="cdktfprovideroktaauthserverclaimpropertyvaluetypeinput"></a>

```typescript
public readonly valueTypeInput: string;
```

- *Type:* `string`

---

##### `alwaysIncludeInToken`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerClaim.property.alwaysIncludeInToken" id="cdktfprovideroktaauthserverclaimpropertyalwaysincludeintoken"></a>

```typescript
public readonly alwaysIncludeInToken: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `authServerId`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerClaim.property.authServerId" id="cdktfprovideroktaauthserverclaimpropertyauthserverid"></a>

```typescript
public readonly authServerId: string;
```

- *Type:* `string`

---

##### `claimType`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerClaim.property.claimType" id="cdktfprovideroktaauthserverclaimpropertyclaimtype"></a>

```typescript
public readonly claimType: string;
```

- *Type:* `string`

---

##### `groupFilterType`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerClaim.property.groupFilterType" id="cdktfprovideroktaauthserverclaimpropertygroupfiltertype"></a>

```typescript
public readonly groupFilterType: string;
```

- *Type:* `string`

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerClaim.property.id" id="cdktfprovideroktaauthserverclaimpropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `name`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerClaim.property.name" id="cdktfprovideroktaauthserverclaimpropertyname"></a>

```typescript
public readonly name: string;
```

- *Type:* `string`

---

##### `scopes`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerClaim.property.scopes" id="cdktfprovideroktaauthserverclaimpropertyscopes"></a>

```typescript
public readonly scopes: string[];
```

- *Type:* `string`[]

---

##### `status`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerClaim.property.status" id="cdktfprovideroktaauthserverclaimpropertystatus"></a>

```typescript
public readonly status: string;
```

- *Type:* `string`

---

##### `value`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerClaim.property.value" id="cdktfprovideroktaauthserverclaimpropertyvalue"></a>

```typescript
public readonly value: string;
```

- *Type:* `string`

---

##### `valueType`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerClaim.property.valueType" id="cdktfprovideroktaauthserverclaimpropertyvaluetype"></a>

```typescript
public readonly valueType: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktaauthserverclaimpropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.AuthServerClaim.property.tfResourceType" id="cdktfprovideroktaauthserverclaimpropertytfresourcetype"></a>

- *Type:* `string`

---

### AuthServerClaimDefault <a name="@cdktf/provider-okta.AuthServerClaimDefault" id="cdktfprovideroktaauthserverclaimdefault"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/r/auth_server_claim_default okta_auth_server_claim_default}.

#### Initializers <a name="@cdktf/provider-okta.AuthServerClaimDefault.Initializer" id="cdktfprovideroktaauthserverclaimdefaultinitializer"></a>

```typescript
import { AuthServerClaimDefault } from '@cdktf/provider-okta'

new AuthServerClaimDefault(scope: Construct, id: string, config: AuthServerClaimDefaultConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktaauthserverclaimdefaultparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktaauthserverclaimdefaultparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktaauthserverclaimdefaultparameterconfig)<span title="Required">*</span> | [`@cdktf/provider-okta.AuthServerClaimDefaultConfig`](#@cdktf/provider-okta.AuthServerClaimDefaultConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerClaimDefault.parameter.scope" id="cdktfprovideroktaauthserverclaimdefaultparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerClaimDefault.parameter.id" id="cdktfprovideroktaauthserverclaimdefaultparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerClaimDefault.parameter.config" id="cdktfprovideroktaauthserverclaimdefaultparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.AuthServerClaimDefaultConfig`](#@cdktf/provider-okta.AuthServerClaimDefaultConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`resetAlwaysIncludeInToken`](#cdktfprovideroktaauthserverclaimdefaultresetalwaysincludeintoken) | *No description.* |
| [`resetId`](#cdktfprovideroktaauthserverclaimdefaultresetid) | *No description.* |
| [`resetValue`](#cdktfprovideroktaauthserverclaimdefaultresetvalue) | *No description.* |

---

##### `resetAlwaysIncludeInToken` <a name="@cdktf/provider-okta.AuthServerClaimDefault.resetAlwaysIncludeInToken" id="cdktfprovideroktaauthserverclaimdefaultresetalwaysincludeintoken"></a>

```typescript
public resetAlwaysIncludeInToken()
```

##### `resetId` <a name="@cdktf/provider-okta.AuthServerClaimDefault.resetId" id="cdktfprovideroktaauthserverclaimdefaultresetid"></a>

```typescript
public resetId()
```

##### `resetValue` <a name="@cdktf/provider-okta.AuthServerClaimDefault.resetValue" id="cdktfprovideroktaauthserverclaimdefaultresetvalue"></a>

```typescript
public resetValue()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`claimType`](#cdktfprovideroktaauthserverclaimdefaultpropertyclaimtype)<span title="Required">*</span> | `string` | *No description.* |
| [`scopes`](#cdktfprovideroktaauthserverclaimdefaultpropertyscopes)<span title="Required">*</span> | `string`[] | *No description.* |
| [`status`](#cdktfprovideroktaauthserverclaimdefaultpropertystatus)<span title="Required">*</span> | `string` | *No description.* |
| [`valueType`](#cdktfprovideroktaauthserverclaimdefaultpropertyvaluetype)<span title="Required">*</span> | `string` | *No description.* |
| [`alwaysIncludeInTokenInput`](#cdktfprovideroktaauthserverclaimdefaultpropertyalwaysincludeintokeninput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`authServerIdInput`](#cdktfprovideroktaauthserverclaimdefaultpropertyauthserveridinput) | `string` | *No description.* |
| [`idInput`](#cdktfprovideroktaauthserverclaimdefaultpropertyidinput) | `string` | *No description.* |
| [`nameInput`](#cdktfprovideroktaauthserverclaimdefaultpropertynameinput) | `string` | *No description.* |
| [`valueInput`](#cdktfprovideroktaauthserverclaimdefaultpropertyvalueinput) | `string` | *No description.* |
| [`alwaysIncludeInToken`](#cdktfprovideroktaauthserverclaimdefaultpropertyalwaysincludeintoken)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`authServerId`](#cdktfprovideroktaauthserverclaimdefaultpropertyauthserverid)<span title="Required">*</span> | `string` | *No description.* |
| [`id`](#cdktfprovideroktaauthserverclaimdefaultpropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`name`](#cdktfprovideroktaauthserverclaimdefaultpropertyname)<span title="Required">*</span> | `string` | *No description.* |
| [`value`](#cdktfprovideroktaauthserverclaimdefaultpropertyvalue)<span title="Required">*</span> | `string` | *No description.* |

---

##### `claimType`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerClaimDefault.property.claimType" id="cdktfprovideroktaauthserverclaimdefaultpropertyclaimtype"></a>

```typescript
public readonly claimType: string;
```

- *Type:* `string`

---

##### `scopes`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerClaimDefault.property.scopes" id="cdktfprovideroktaauthserverclaimdefaultpropertyscopes"></a>

```typescript
public readonly scopes: string[];
```

- *Type:* `string`[]

---

##### `status`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerClaimDefault.property.status" id="cdktfprovideroktaauthserverclaimdefaultpropertystatus"></a>

```typescript
public readonly status: string;
```

- *Type:* `string`

---

##### `valueType`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerClaimDefault.property.valueType" id="cdktfprovideroktaauthserverclaimdefaultpropertyvaluetype"></a>

```typescript
public readonly valueType: string;
```

- *Type:* `string`

---

##### `alwaysIncludeInTokenInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServerClaimDefault.property.alwaysIncludeInTokenInput" id="cdktfprovideroktaauthserverclaimdefaultpropertyalwaysincludeintokeninput"></a>

```typescript
public readonly alwaysIncludeInTokenInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `authServerIdInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServerClaimDefault.property.authServerIdInput" id="cdktfprovideroktaauthserverclaimdefaultpropertyauthserveridinput"></a>

```typescript
public readonly authServerIdInput: string;
```

- *Type:* `string`

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServerClaimDefault.property.idInput" id="cdktfprovideroktaauthserverclaimdefaultpropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `nameInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServerClaimDefault.property.nameInput" id="cdktfprovideroktaauthserverclaimdefaultpropertynameinput"></a>

```typescript
public readonly nameInput: string;
```

- *Type:* `string`

---

##### `valueInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServerClaimDefault.property.valueInput" id="cdktfprovideroktaauthserverclaimdefaultpropertyvalueinput"></a>

```typescript
public readonly valueInput: string;
```

- *Type:* `string`

---

##### `alwaysIncludeInToken`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerClaimDefault.property.alwaysIncludeInToken" id="cdktfprovideroktaauthserverclaimdefaultpropertyalwaysincludeintoken"></a>

```typescript
public readonly alwaysIncludeInToken: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `authServerId`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerClaimDefault.property.authServerId" id="cdktfprovideroktaauthserverclaimdefaultpropertyauthserverid"></a>

```typescript
public readonly authServerId: string;
```

- *Type:* `string`

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerClaimDefault.property.id" id="cdktfprovideroktaauthserverclaimdefaultpropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `name`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerClaimDefault.property.name" id="cdktfprovideroktaauthserverclaimdefaultpropertyname"></a>

```typescript
public readonly name: string;
```

- *Type:* `string`

---

##### `value`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerClaimDefault.property.value" id="cdktfprovideroktaauthserverclaimdefaultpropertyvalue"></a>

```typescript
public readonly value: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktaauthserverclaimdefaultpropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.AuthServerClaimDefault.property.tfResourceType" id="cdktfprovideroktaauthserverclaimdefaultpropertytfresourcetype"></a>

- *Type:* `string`

---

### AuthServerDefault <a name="@cdktf/provider-okta.AuthServerDefault" id="cdktfprovideroktaauthserverdefault"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/r/auth_server_default okta_auth_server_default}.

#### Initializers <a name="@cdktf/provider-okta.AuthServerDefault.Initializer" id="cdktfprovideroktaauthserverdefaultinitializer"></a>

```typescript
import { AuthServerDefault } from '@cdktf/provider-okta'

new AuthServerDefault(scope: Construct, id: string, config: AuthServerDefaultConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktaauthserverdefaultparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktaauthserverdefaultparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktaauthserverdefaultparameterconfig)<span title="Required">*</span> | [`@cdktf/provider-okta.AuthServerDefaultConfig`](#@cdktf/provider-okta.AuthServerDefaultConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerDefault.parameter.scope" id="cdktfprovideroktaauthserverdefaultparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerDefault.parameter.id" id="cdktfprovideroktaauthserverdefaultparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerDefault.parameter.config" id="cdktfprovideroktaauthserverdefaultparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.AuthServerDefaultConfig`](#@cdktf/provider-okta.AuthServerDefaultConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`resetAudiences`](#cdktfprovideroktaauthserverdefaultresetaudiences) | *No description.* |
| [`resetCredentialsRotationMode`](#cdktfprovideroktaauthserverdefaultresetcredentialsrotationmode) | *No description.* |
| [`resetDescription`](#cdktfprovideroktaauthserverdefaultresetdescription) | *No description.* |
| [`resetId`](#cdktfprovideroktaauthserverdefaultresetid) | *No description.* |
| [`resetIssuerMode`](#cdktfprovideroktaauthserverdefaultresetissuermode) | *No description.* |
| [`resetStatus`](#cdktfprovideroktaauthserverdefaultresetstatus) | *No description.* |

---

##### `resetAudiences` <a name="@cdktf/provider-okta.AuthServerDefault.resetAudiences" id="cdktfprovideroktaauthserverdefaultresetaudiences"></a>

```typescript
public resetAudiences()
```

##### `resetCredentialsRotationMode` <a name="@cdktf/provider-okta.AuthServerDefault.resetCredentialsRotationMode" id="cdktfprovideroktaauthserverdefaultresetcredentialsrotationmode"></a>

```typescript
public resetCredentialsRotationMode()
```

##### `resetDescription` <a name="@cdktf/provider-okta.AuthServerDefault.resetDescription" id="cdktfprovideroktaauthserverdefaultresetdescription"></a>

```typescript
public resetDescription()
```

##### `resetId` <a name="@cdktf/provider-okta.AuthServerDefault.resetId" id="cdktfprovideroktaauthserverdefaultresetid"></a>

```typescript
public resetId()
```

##### `resetIssuerMode` <a name="@cdktf/provider-okta.AuthServerDefault.resetIssuerMode" id="cdktfprovideroktaauthserverdefaultresetissuermode"></a>

```typescript
public resetIssuerMode()
```

##### `resetStatus` <a name="@cdktf/provider-okta.AuthServerDefault.resetStatus" id="cdktfprovideroktaauthserverdefaultresetstatus"></a>

```typescript
public resetStatus()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`credentialsLastRotated`](#cdktfprovideroktaauthserverdefaultpropertycredentialslastrotated)<span title="Required">*</span> | `string` | *No description.* |
| [`credentialsNextRotation`](#cdktfprovideroktaauthserverdefaultpropertycredentialsnextrotation)<span title="Required">*</span> | `string` | *No description.* |
| [`issuer`](#cdktfprovideroktaauthserverdefaultpropertyissuer)<span title="Required">*</span> | `string` | *No description.* |
| [`kid`](#cdktfprovideroktaauthserverdefaultpropertykid)<span title="Required">*</span> | `string` | *No description.* |
| [`audiencesInput`](#cdktfprovideroktaauthserverdefaultpropertyaudiencesinput) | `string`[] | *No description.* |
| [`credentialsRotationModeInput`](#cdktfprovideroktaauthserverdefaultpropertycredentialsrotationmodeinput) | `string` | *No description.* |
| [`descriptionInput`](#cdktfprovideroktaauthserverdefaultpropertydescriptioninput) | `string` | *No description.* |
| [`idInput`](#cdktfprovideroktaauthserverdefaultpropertyidinput) | `string` | *No description.* |
| [`issuerModeInput`](#cdktfprovideroktaauthserverdefaultpropertyissuermodeinput) | `string` | *No description.* |
| [`nameInput`](#cdktfprovideroktaauthserverdefaultpropertynameinput) | `string` | *No description.* |
| [`statusInput`](#cdktfprovideroktaauthserverdefaultpropertystatusinput) | `string` | *No description.* |
| [`audiences`](#cdktfprovideroktaauthserverdefaultpropertyaudiences)<span title="Required">*</span> | `string`[] | *No description.* |
| [`credentialsRotationMode`](#cdktfprovideroktaauthserverdefaultpropertycredentialsrotationmode)<span title="Required">*</span> | `string` | *No description.* |
| [`description`](#cdktfprovideroktaauthserverdefaultpropertydescription)<span title="Required">*</span> | `string` | *No description.* |
| [`id`](#cdktfprovideroktaauthserverdefaultpropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`issuerMode`](#cdktfprovideroktaauthserverdefaultpropertyissuermode)<span title="Required">*</span> | `string` | *No description.* |
| [`name`](#cdktfprovideroktaauthserverdefaultpropertyname)<span title="Required">*</span> | `string` | *No description.* |
| [`status`](#cdktfprovideroktaauthserverdefaultpropertystatus)<span title="Required">*</span> | `string` | *No description.* |

---

##### `credentialsLastRotated`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerDefault.property.credentialsLastRotated" id="cdktfprovideroktaauthserverdefaultpropertycredentialslastrotated"></a>

```typescript
public readonly credentialsLastRotated: string;
```

- *Type:* `string`

---

##### `credentialsNextRotation`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerDefault.property.credentialsNextRotation" id="cdktfprovideroktaauthserverdefaultpropertycredentialsnextrotation"></a>

```typescript
public readonly credentialsNextRotation: string;
```

- *Type:* `string`

---

##### `issuer`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerDefault.property.issuer" id="cdktfprovideroktaauthserverdefaultpropertyissuer"></a>

```typescript
public readonly issuer: string;
```

- *Type:* `string`

---

##### `kid`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerDefault.property.kid" id="cdktfprovideroktaauthserverdefaultpropertykid"></a>

```typescript
public readonly kid: string;
```

- *Type:* `string`

---

##### `audiencesInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServerDefault.property.audiencesInput" id="cdktfprovideroktaauthserverdefaultpropertyaudiencesinput"></a>

```typescript
public readonly audiencesInput: string[];
```

- *Type:* `string`[]

---

##### `credentialsRotationModeInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServerDefault.property.credentialsRotationModeInput" id="cdktfprovideroktaauthserverdefaultpropertycredentialsrotationmodeinput"></a>

```typescript
public readonly credentialsRotationModeInput: string;
```

- *Type:* `string`

---

##### `descriptionInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServerDefault.property.descriptionInput" id="cdktfprovideroktaauthserverdefaultpropertydescriptioninput"></a>

```typescript
public readonly descriptionInput: string;
```

- *Type:* `string`

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServerDefault.property.idInput" id="cdktfprovideroktaauthserverdefaultpropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `issuerModeInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServerDefault.property.issuerModeInput" id="cdktfprovideroktaauthserverdefaultpropertyissuermodeinput"></a>

```typescript
public readonly issuerModeInput: string;
```

- *Type:* `string`

---

##### `nameInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServerDefault.property.nameInput" id="cdktfprovideroktaauthserverdefaultpropertynameinput"></a>

```typescript
public readonly nameInput: string;
```

- *Type:* `string`

---

##### `statusInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServerDefault.property.statusInput" id="cdktfprovideroktaauthserverdefaultpropertystatusinput"></a>

```typescript
public readonly statusInput: string;
```

- *Type:* `string`

---

##### `audiences`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerDefault.property.audiences" id="cdktfprovideroktaauthserverdefaultpropertyaudiences"></a>

```typescript
public readonly audiences: string[];
```

- *Type:* `string`[]

---

##### `credentialsRotationMode`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerDefault.property.credentialsRotationMode" id="cdktfprovideroktaauthserverdefaultpropertycredentialsrotationmode"></a>

```typescript
public readonly credentialsRotationMode: string;
```

- *Type:* `string`

---

##### `description`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerDefault.property.description" id="cdktfprovideroktaauthserverdefaultpropertydescription"></a>

```typescript
public readonly description: string;
```

- *Type:* `string`

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerDefault.property.id" id="cdktfprovideroktaauthserverdefaultpropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `issuerMode`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerDefault.property.issuerMode" id="cdktfprovideroktaauthserverdefaultpropertyissuermode"></a>

```typescript
public readonly issuerMode: string;
```

- *Type:* `string`

---

##### `name`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerDefault.property.name" id="cdktfprovideroktaauthserverdefaultpropertyname"></a>

```typescript
public readonly name: string;
```

- *Type:* `string`

---

##### `status`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerDefault.property.status" id="cdktfprovideroktaauthserverdefaultpropertystatus"></a>

```typescript
public readonly status: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktaauthserverdefaultpropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.AuthServerDefault.property.tfResourceType" id="cdktfprovideroktaauthserverdefaultpropertytfresourcetype"></a>

- *Type:* `string`

---

### AuthServerPolicy <a name="@cdktf/provider-okta.AuthServerPolicy" id="cdktfprovideroktaauthserverpolicy"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/r/auth_server_policy okta_auth_server_policy}.

#### Initializers <a name="@cdktf/provider-okta.AuthServerPolicy.Initializer" id="cdktfprovideroktaauthserverpolicyinitializer"></a>

```typescript
import { AuthServerPolicy } from '@cdktf/provider-okta'

new AuthServerPolicy(scope: Construct, id: string, config: AuthServerPolicyConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktaauthserverpolicyparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktaauthserverpolicyparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktaauthserverpolicyparameterconfig)<span title="Required">*</span> | [`@cdktf/provider-okta.AuthServerPolicyConfig`](#@cdktf/provider-okta.AuthServerPolicyConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerPolicy.parameter.scope" id="cdktfprovideroktaauthserverpolicyparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerPolicy.parameter.id" id="cdktfprovideroktaauthserverpolicyparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerPolicy.parameter.config" id="cdktfprovideroktaauthserverpolicyparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.AuthServerPolicyConfig`](#@cdktf/provider-okta.AuthServerPolicyConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`resetId`](#cdktfprovideroktaauthserverpolicyresetid) | *No description.* |
| [`resetStatus`](#cdktfprovideroktaauthserverpolicyresetstatus) | *No description.* |
| [`resetType`](#cdktfprovideroktaauthserverpolicyresettype) | *No description.* |

---

##### `resetId` <a name="@cdktf/provider-okta.AuthServerPolicy.resetId" id="cdktfprovideroktaauthserverpolicyresetid"></a>

```typescript
public resetId()
```

##### `resetStatus` <a name="@cdktf/provider-okta.AuthServerPolicy.resetStatus" id="cdktfprovideroktaauthserverpolicyresetstatus"></a>

```typescript
public resetStatus()
```

##### `resetType` <a name="@cdktf/provider-okta.AuthServerPolicy.resetType" id="cdktfprovideroktaauthserverpolicyresettype"></a>

```typescript
public resetType()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`authServerIdInput`](#cdktfprovideroktaauthserverpolicypropertyauthserveridinput) | `string` | *No description.* |
| [`clientWhitelistInput`](#cdktfprovideroktaauthserverpolicypropertyclientwhitelistinput) | `string`[] | *No description.* |
| [`descriptionInput`](#cdktfprovideroktaauthserverpolicypropertydescriptioninput) | `string` | *No description.* |
| [`idInput`](#cdktfprovideroktaauthserverpolicypropertyidinput) | `string` | *No description.* |
| [`nameInput`](#cdktfprovideroktaauthserverpolicypropertynameinput) | `string` | *No description.* |
| [`priorityInput`](#cdktfprovideroktaauthserverpolicypropertypriorityinput) | `number` | *No description.* |
| [`statusInput`](#cdktfprovideroktaauthserverpolicypropertystatusinput) | `string` | *No description.* |
| [`typeInput`](#cdktfprovideroktaauthserverpolicypropertytypeinput) | `string` | *No description.* |
| [`authServerId`](#cdktfprovideroktaauthserverpolicypropertyauthserverid)<span title="Required">*</span> | `string` | *No description.* |
| [`clientWhitelist`](#cdktfprovideroktaauthserverpolicypropertyclientwhitelist)<span title="Required">*</span> | `string`[] | *No description.* |
| [`description`](#cdktfprovideroktaauthserverpolicypropertydescription)<span title="Required">*</span> | `string` | *No description.* |
| [`id`](#cdktfprovideroktaauthserverpolicypropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`name`](#cdktfprovideroktaauthserverpolicypropertyname)<span title="Required">*</span> | `string` | *No description.* |
| [`priority`](#cdktfprovideroktaauthserverpolicypropertypriority)<span title="Required">*</span> | `number` | *No description.* |
| [`status`](#cdktfprovideroktaauthserverpolicypropertystatus)<span title="Required">*</span> | `string` | *No description.* |
| [`type`](#cdktfprovideroktaauthserverpolicypropertytype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `authServerIdInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServerPolicy.property.authServerIdInput" id="cdktfprovideroktaauthserverpolicypropertyauthserveridinput"></a>

```typescript
public readonly authServerIdInput: string;
```

- *Type:* `string`

---

##### `clientWhitelistInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServerPolicy.property.clientWhitelistInput" id="cdktfprovideroktaauthserverpolicypropertyclientwhitelistinput"></a>

```typescript
public readonly clientWhitelistInput: string[];
```

- *Type:* `string`[]

---

##### `descriptionInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServerPolicy.property.descriptionInput" id="cdktfprovideroktaauthserverpolicypropertydescriptioninput"></a>

```typescript
public readonly descriptionInput: string;
```

- *Type:* `string`

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServerPolicy.property.idInput" id="cdktfprovideroktaauthserverpolicypropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `nameInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServerPolicy.property.nameInput" id="cdktfprovideroktaauthserverpolicypropertynameinput"></a>

```typescript
public readonly nameInput: string;
```

- *Type:* `string`

---

##### `priorityInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServerPolicy.property.priorityInput" id="cdktfprovideroktaauthserverpolicypropertypriorityinput"></a>

```typescript
public readonly priorityInput: number;
```

- *Type:* `number`

---

##### `statusInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServerPolicy.property.statusInput" id="cdktfprovideroktaauthserverpolicypropertystatusinput"></a>

```typescript
public readonly statusInput: string;
```

- *Type:* `string`

---

##### `typeInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServerPolicy.property.typeInput" id="cdktfprovideroktaauthserverpolicypropertytypeinput"></a>

```typescript
public readonly typeInput: string;
```

- *Type:* `string`

---

##### `authServerId`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerPolicy.property.authServerId" id="cdktfprovideroktaauthserverpolicypropertyauthserverid"></a>

```typescript
public readonly authServerId: string;
```

- *Type:* `string`

---

##### `clientWhitelist`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerPolicy.property.clientWhitelist" id="cdktfprovideroktaauthserverpolicypropertyclientwhitelist"></a>

```typescript
public readonly clientWhitelist: string[];
```

- *Type:* `string`[]

---

##### `description`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerPolicy.property.description" id="cdktfprovideroktaauthserverpolicypropertydescription"></a>

```typescript
public readonly description: string;
```

- *Type:* `string`

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerPolicy.property.id" id="cdktfprovideroktaauthserverpolicypropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `name`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerPolicy.property.name" id="cdktfprovideroktaauthserverpolicypropertyname"></a>

```typescript
public readonly name: string;
```

- *Type:* `string`

---

##### `priority`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerPolicy.property.priority" id="cdktfprovideroktaauthserverpolicypropertypriority"></a>

```typescript
public readonly priority: number;
```

- *Type:* `number`

---

##### `status`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerPolicy.property.status" id="cdktfprovideroktaauthserverpolicypropertystatus"></a>

```typescript
public readonly status: string;
```

- *Type:* `string`

---

##### `type`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerPolicy.property.type" id="cdktfprovideroktaauthserverpolicypropertytype"></a>

```typescript
public readonly type: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktaauthserverpolicypropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.AuthServerPolicy.property.tfResourceType" id="cdktfprovideroktaauthserverpolicypropertytfresourcetype"></a>

- *Type:* `string`

---

### AuthServerPolicyRule <a name="@cdktf/provider-okta.AuthServerPolicyRule" id="cdktfprovideroktaauthserverpolicyrule"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/r/auth_server_policy_rule okta_auth_server_policy_rule}.

#### Initializers <a name="@cdktf/provider-okta.AuthServerPolicyRule.Initializer" id="cdktfprovideroktaauthserverpolicyruleinitializer"></a>

```typescript
import { AuthServerPolicyRule } from '@cdktf/provider-okta'

new AuthServerPolicyRule(scope: Construct, id: string, config: AuthServerPolicyRuleConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktaauthserverpolicyruleparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktaauthserverpolicyruleparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktaauthserverpolicyruleparameterconfig)<span title="Required">*</span> | [`@cdktf/provider-okta.AuthServerPolicyRuleConfig`](#@cdktf/provider-okta.AuthServerPolicyRuleConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerPolicyRule.parameter.scope" id="cdktfprovideroktaauthserverpolicyruleparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerPolicyRule.parameter.id" id="cdktfprovideroktaauthserverpolicyruleparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerPolicyRule.parameter.config" id="cdktfprovideroktaauthserverpolicyruleparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.AuthServerPolicyRuleConfig`](#@cdktf/provider-okta.AuthServerPolicyRuleConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`resetAccessTokenLifetimeMinutes`](#cdktfprovideroktaauthserverpolicyruleresetaccesstokenlifetimeminutes) | *No description.* |
| [`resetGroupBlacklist`](#cdktfprovideroktaauthserverpolicyruleresetgroupblacklist) | *No description.* |
| [`resetGroupWhitelist`](#cdktfprovideroktaauthserverpolicyruleresetgroupwhitelist) | *No description.* |
| [`resetId`](#cdktfprovideroktaauthserverpolicyruleresetid) | *No description.* |
| [`resetInlineHookId`](#cdktfprovideroktaauthserverpolicyruleresetinlinehookid) | *No description.* |
| [`resetRefreshTokenLifetimeMinutes`](#cdktfprovideroktaauthserverpolicyruleresetrefreshtokenlifetimeminutes) | *No description.* |
| [`resetRefreshTokenWindowMinutes`](#cdktfprovideroktaauthserverpolicyruleresetrefreshtokenwindowminutes) | *No description.* |
| [`resetScopeWhitelist`](#cdktfprovideroktaauthserverpolicyruleresetscopewhitelist) | *No description.* |
| [`resetStatus`](#cdktfprovideroktaauthserverpolicyruleresetstatus) | *No description.* |
| [`resetType`](#cdktfprovideroktaauthserverpolicyruleresettype) | *No description.* |
| [`resetUserBlacklist`](#cdktfprovideroktaauthserverpolicyruleresetuserblacklist) | *No description.* |
| [`resetUserWhitelist`](#cdktfprovideroktaauthserverpolicyruleresetuserwhitelist) | *No description.* |

---

##### `resetAccessTokenLifetimeMinutes` <a name="@cdktf/provider-okta.AuthServerPolicyRule.resetAccessTokenLifetimeMinutes" id="cdktfprovideroktaauthserverpolicyruleresetaccesstokenlifetimeminutes"></a>

```typescript
public resetAccessTokenLifetimeMinutes()
```

##### `resetGroupBlacklist` <a name="@cdktf/provider-okta.AuthServerPolicyRule.resetGroupBlacklist" id="cdktfprovideroktaauthserverpolicyruleresetgroupblacklist"></a>

```typescript
public resetGroupBlacklist()
```

##### `resetGroupWhitelist` <a name="@cdktf/provider-okta.AuthServerPolicyRule.resetGroupWhitelist" id="cdktfprovideroktaauthserverpolicyruleresetgroupwhitelist"></a>

```typescript
public resetGroupWhitelist()
```

##### `resetId` <a name="@cdktf/provider-okta.AuthServerPolicyRule.resetId" id="cdktfprovideroktaauthserverpolicyruleresetid"></a>

```typescript
public resetId()
```

##### `resetInlineHookId` <a name="@cdktf/provider-okta.AuthServerPolicyRule.resetInlineHookId" id="cdktfprovideroktaauthserverpolicyruleresetinlinehookid"></a>

```typescript
public resetInlineHookId()
```

##### `resetRefreshTokenLifetimeMinutes` <a name="@cdktf/provider-okta.AuthServerPolicyRule.resetRefreshTokenLifetimeMinutes" id="cdktfprovideroktaauthserverpolicyruleresetrefreshtokenlifetimeminutes"></a>

```typescript
public resetRefreshTokenLifetimeMinutes()
```

##### `resetRefreshTokenWindowMinutes` <a name="@cdktf/provider-okta.AuthServerPolicyRule.resetRefreshTokenWindowMinutes" id="cdktfprovideroktaauthserverpolicyruleresetrefreshtokenwindowminutes"></a>

```typescript
public resetRefreshTokenWindowMinutes()
```

##### `resetScopeWhitelist` <a name="@cdktf/provider-okta.AuthServerPolicyRule.resetScopeWhitelist" id="cdktfprovideroktaauthserverpolicyruleresetscopewhitelist"></a>

```typescript
public resetScopeWhitelist()
```

##### `resetStatus` <a name="@cdktf/provider-okta.AuthServerPolicyRule.resetStatus" id="cdktfprovideroktaauthserverpolicyruleresetstatus"></a>

```typescript
public resetStatus()
```

##### `resetType` <a name="@cdktf/provider-okta.AuthServerPolicyRule.resetType" id="cdktfprovideroktaauthserverpolicyruleresettype"></a>

```typescript
public resetType()
```

##### `resetUserBlacklist` <a name="@cdktf/provider-okta.AuthServerPolicyRule.resetUserBlacklist" id="cdktfprovideroktaauthserverpolicyruleresetuserblacklist"></a>

```typescript
public resetUserBlacklist()
```

##### `resetUserWhitelist` <a name="@cdktf/provider-okta.AuthServerPolicyRule.resetUserWhitelist" id="cdktfprovideroktaauthserverpolicyruleresetuserwhitelist"></a>

```typescript
public resetUserWhitelist()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`accessTokenLifetimeMinutesInput`](#cdktfprovideroktaauthserverpolicyrulepropertyaccesstokenlifetimeminutesinput) | `number` | *No description.* |
| [`authServerIdInput`](#cdktfprovideroktaauthserverpolicyrulepropertyauthserveridinput) | `string` | *No description.* |
| [`grantTypeWhitelistInput`](#cdktfprovideroktaauthserverpolicyrulepropertygranttypewhitelistinput) | `string`[] | *No description.* |
| [`groupBlacklistInput`](#cdktfprovideroktaauthserverpolicyrulepropertygroupblacklistinput) | `string`[] | *No description.* |
| [`groupWhitelistInput`](#cdktfprovideroktaauthserverpolicyrulepropertygroupwhitelistinput) | `string`[] | *No description.* |
| [`idInput`](#cdktfprovideroktaauthserverpolicyrulepropertyidinput) | `string` | *No description.* |
| [`inlineHookIdInput`](#cdktfprovideroktaauthserverpolicyrulepropertyinlinehookidinput) | `string` | *No description.* |
| [`nameInput`](#cdktfprovideroktaauthserverpolicyrulepropertynameinput) | `string` | *No description.* |
| [`policyIdInput`](#cdktfprovideroktaauthserverpolicyrulepropertypolicyidinput) | `string` | *No description.* |
| [`priorityInput`](#cdktfprovideroktaauthserverpolicyrulepropertypriorityinput) | `number` | *No description.* |
| [`refreshTokenLifetimeMinutesInput`](#cdktfprovideroktaauthserverpolicyrulepropertyrefreshtokenlifetimeminutesinput) | `number` | *No description.* |
| [`refreshTokenWindowMinutesInput`](#cdktfprovideroktaauthserverpolicyrulepropertyrefreshtokenwindowminutesinput) | `number` | *No description.* |
| [`scopeWhitelistInput`](#cdktfprovideroktaauthserverpolicyrulepropertyscopewhitelistinput) | `string`[] | *No description.* |
| [`statusInput`](#cdktfprovideroktaauthserverpolicyrulepropertystatusinput) | `string` | *No description.* |
| [`typeInput`](#cdktfprovideroktaauthserverpolicyrulepropertytypeinput) | `string` | *No description.* |
| [`userBlacklistInput`](#cdktfprovideroktaauthserverpolicyrulepropertyuserblacklistinput) | `string`[] | *No description.* |
| [`userWhitelistInput`](#cdktfprovideroktaauthserverpolicyrulepropertyuserwhitelistinput) | `string`[] | *No description.* |
| [`accessTokenLifetimeMinutes`](#cdktfprovideroktaauthserverpolicyrulepropertyaccesstokenlifetimeminutes)<span title="Required">*</span> | `number` | *No description.* |
| [`authServerId`](#cdktfprovideroktaauthserverpolicyrulepropertyauthserverid)<span title="Required">*</span> | `string` | *No description.* |
| [`grantTypeWhitelist`](#cdktfprovideroktaauthserverpolicyrulepropertygranttypewhitelist)<span title="Required">*</span> | `string`[] | *No description.* |
| [`groupBlacklist`](#cdktfprovideroktaauthserverpolicyrulepropertygroupblacklist)<span title="Required">*</span> | `string`[] | *No description.* |
| [`groupWhitelist`](#cdktfprovideroktaauthserverpolicyrulepropertygroupwhitelist)<span title="Required">*</span> | `string`[] | *No description.* |
| [`id`](#cdktfprovideroktaauthserverpolicyrulepropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`inlineHookId`](#cdktfprovideroktaauthserverpolicyrulepropertyinlinehookid)<span title="Required">*</span> | `string` | *No description.* |
| [`name`](#cdktfprovideroktaauthserverpolicyrulepropertyname)<span title="Required">*</span> | `string` | *No description.* |
| [`policyId`](#cdktfprovideroktaauthserverpolicyrulepropertypolicyid)<span title="Required">*</span> | `string` | *No description.* |
| [`priority`](#cdktfprovideroktaauthserverpolicyrulepropertypriority)<span title="Required">*</span> | `number` | *No description.* |
| [`refreshTokenLifetimeMinutes`](#cdktfprovideroktaauthserverpolicyrulepropertyrefreshtokenlifetimeminutes)<span title="Required">*</span> | `number` | *No description.* |
| [`refreshTokenWindowMinutes`](#cdktfprovideroktaauthserverpolicyrulepropertyrefreshtokenwindowminutes)<span title="Required">*</span> | `number` | *No description.* |
| [`scopeWhitelist`](#cdktfprovideroktaauthserverpolicyrulepropertyscopewhitelist)<span title="Required">*</span> | `string`[] | *No description.* |
| [`status`](#cdktfprovideroktaauthserverpolicyrulepropertystatus)<span title="Required">*</span> | `string` | *No description.* |
| [`type`](#cdktfprovideroktaauthserverpolicyrulepropertytype)<span title="Required">*</span> | `string` | *No description.* |
| [`userBlacklist`](#cdktfprovideroktaauthserverpolicyrulepropertyuserblacklist)<span title="Required">*</span> | `string`[] | *No description.* |
| [`userWhitelist`](#cdktfprovideroktaauthserverpolicyrulepropertyuserwhitelist)<span title="Required">*</span> | `string`[] | *No description.* |

---

##### `accessTokenLifetimeMinutesInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServerPolicyRule.property.accessTokenLifetimeMinutesInput" id="cdktfprovideroktaauthserverpolicyrulepropertyaccesstokenlifetimeminutesinput"></a>

```typescript
public readonly accessTokenLifetimeMinutesInput: number;
```

- *Type:* `number`

---

##### `authServerIdInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServerPolicyRule.property.authServerIdInput" id="cdktfprovideroktaauthserverpolicyrulepropertyauthserveridinput"></a>

```typescript
public readonly authServerIdInput: string;
```

- *Type:* `string`

---

##### `grantTypeWhitelistInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServerPolicyRule.property.grantTypeWhitelistInput" id="cdktfprovideroktaauthserverpolicyrulepropertygranttypewhitelistinput"></a>

```typescript
public readonly grantTypeWhitelistInput: string[];
```

- *Type:* `string`[]

---

##### `groupBlacklistInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServerPolicyRule.property.groupBlacklistInput" id="cdktfprovideroktaauthserverpolicyrulepropertygroupblacklistinput"></a>

```typescript
public readonly groupBlacklistInput: string[];
```

- *Type:* `string`[]

---

##### `groupWhitelistInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServerPolicyRule.property.groupWhitelistInput" id="cdktfprovideroktaauthserverpolicyrulepropertygroupwhitelistinput"></a>

```typescript
public readonly groupWhitelistInput: string[];
```

- *Type:* `string`[]

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServerPolicyRule.property.idInput" id="cdktfprovideroktaauthserverpolicyrulepropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `inlineHookIdInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServerPolicyRule.property.inlineHookIdInput" id="cdktfprovideroktaauthserverpolicyrulepropertyinlinehookidinput"></a>

```typescript
public readonly inlineHookIdInput: string;
```

- *Type:* `string`

---

##### `nameInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServerPolicyRule.property.nameInput" id="cdktfprovideroktaauthserverpolicyrulepropertynameinput"></a>

```typescript
public readonly nameInput: string;
```

- *Type:* `string`

---

##### `policyIdInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServerPolicyRule.property.policyIdInput" id="cdktfprovideroktaauthserverpolicyrulepropertypolicyidinput"></a>

```typescript
public readonly policyIdInput: string;
```

- *Type:* `string`

---

##### `priorityInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServerPolicyRule.property.priorityInput" id="cdktfprovideroktaauthserverpolicyrulepropertypriorityinput"></a>

```typescript
public readonly priorityInput: number;
```

- *Type:* `number`

---

##### `refreshTokenLifetimeMinutesInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServerPolicyRule.property.refreshTokenLifetimeMinutesInput" id="cdktfprovideroktaauthserverpolicyrulepropertyrefreshtokenlifetimeminutesinput"></a>

```typescript
public readonly refreshTokenLifetimeMinutesInput: number;
```

- *Type:* `number`

---

##### `refreshTokenWindowMinutesInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServerPolicyRule.property.refreshTokenWindowMinutesInput" id="cdktfprovideroktaauthserverpolicyrulepropertyrefreshtokenwindowminutesinput"></a>

```typescript
public readonly refreshTokenWindowMinutesInput: number;
```

- *Type:* `number`

---

##### `scopeWhitelistInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServerPolicyRule.property.scopeWhitelistInput" id="cdktfprovideroktaauthserverpolicyrulepropertyscopewhitelistinput"></a>

```typescript
public readonly scopeWhitelistInput: string[];
```

- *Type:* `string`[]

---

##### `statusInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServerPolicyRule.property.statusInput" id="cdktfprovideroktaauthserverpolicyrulepropertystatusinput"></a>

```typescript
public readonly statusInput: string;
```

- *Type:* `string`

---

##### `typeInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServerPolicyRule.property.typeInput" id="cdktfprovideroktaauthserverpolicyrulepropertytypeinput"></a>

```typescript
public readonly typeInput: string;
```

- *Type:* `string`

---

##### `userBlacklistInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServerPolicyRule.property.userBlacklistInput" id="cdktfprovideroktaauthserverpolicyrulepropertyuserblacklistinput"></a>

```typescript
public readonly userBlacklistInput: string[];
```

- *Type:* `string`[]

---

##### `userWhitelistInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServerPolicyRule.property.userWhitelistInput" id="cdktfprovideroktaauthserverpolicyrulepropertyuserwhitelistinput"></a>

```typescript
public readonly userWhitelistInput: string[];
```

- *Type:* `string`[]

---

##### `accessTokenLifetimeMinutes`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerPolicyRule.property.accessTokenLifetimeMinutes" id="cdktfprovideroktaauthserverpolicyrulepropertyaccesstokenlifetimeminutes"></a>

```typescript
public readonly accessTokenLifetimeMinutes: number;
```

- *Type:* `number`

---

##### `authServerId`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerPolicyRule.property.authServerId" id="cdktfprovideroktaauthserverpolicyrulepropertyauthserverid"></a>

```typescript
public readonly authServerId: string;
```

- *Type:* `string`

---

##### `grantTypeWhitelist`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerPolicyRule.property.grantTypeWhitelist" id="cdktfprovideroktaauthserverpolicyrulepropertygranttypewhitelist"></a>

```typescript
public readonly grantTypeWhitelist: string[];
```

- *Type:* `string`[]

---

##### `groupBlacklist`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerPolicyRule.property.groupBlacklist" id="cdktfprovideroktaauthserverpolicyrulepropertygroupblacklist"></a>

```typescript
public readonly groupBlacklist: string[];
```

- *Type:* `string`[]

---

##### `groupWhitelist`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerPolicyRule.property.groupWhitelist" id="cdktfprovideroktaauthserverpolicyrulepropertygroupwhitelist"></a>

```typescript
public readonly groupWhitelist: string[];
```

- *Type:* `string`[]

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerPolicyRule.property.id" id="cdktfprovideroktaauthserverpolicyrulepropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `inlineHookId`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerPolicyRule.property.inlineHookId" id="cdktfprovideroktaauthserverpolicyrulepropertyinlinehookid"></a>

```typescript
public readonly inlineHookId: string;
```

- *Type:* `string`

---

##### `name`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerPolicyRule.property.name" id="cdktfprovideroktaauthserverpolicyrulepropertyname"></a>

```typescript
public readonly name: string;
```

- *Type:* `string`

---

##### `policyId`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerPolicyRule.property.policyId" id="cdktfprovideroktaauthserverpolicyrulepropertypolicyid"></a>

```typescript
public readonly policyId: string;
```

- *Type:* `string`

---

##### `priority`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerPolicyRule.property.priority" id="cdktfprovideroktaauthserverpolicyrulepropertypriority"></a>

```typescript
public readonly priority: number;
```

- *Type:* `number`

---

##### `refreshTokenLifetimeMinutes`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerPolicyRule.property.refreshTokenLifetimeMinutes" id="cdktfprovideroktaauthserverpolicyrulepropertyrefreshtokenlifetimeminutes"></a>

```typescript
public readonly refreshTokenLifetimeMinutes: number;
```

- *Type:* `number`

---

##### `refreshTokenWindowMinutes`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerPolicyRule.property.refreshTokenWindowMinutes" id="cdktfprovideroktaauthserverpolicyrulepropertyrefreshtokenwindowminutes"></a>

```typescript
public readonly refreshTokenWindowMinutes: number;
```

- *Type:* `number`

---

##### `scopeWhitelist`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerPolicyRule.property.scopeWhitelist" id="cdktfprovideroktaauthserverpolicyrulepropertyscopewhitelist"></a>

```typescript
public readonly scopeWhitelist: string[];
```

- *Type:* `string`[]

---

##### `status`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerPolicyRule.property.status" id="cdktfprovideroktaauthserverpolicyrulepropertystatus"></a>

```typescript
public readonly status: string;
```

- *Type:* `string`

---

##### `type`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerPolicyRule.property.type" id="cdktfprovideroktaauthserverpolicyrulepropertytype"></a>

```typescript
public readonly type: string;
```

- *Type:* `string`

---

##### `userBlacklist`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerPolicyRule.property.userBlacklist" id="cdktfprovideroktaauthserverpolicyrulepropertyuserblacklist"></a>

```typescript
public readonly userBlacklist: string[];
```

- *Type:* `string`[]

---

##### `userWhitelist`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerPolicyRule.property.userWhitelist" id="cdktfprovideroktaauthserverpolicyrulepropertyuserwhitelist"></a>

```typescript
public readonly userWhitelist: string[];
```

- *Type:* `string`[]

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktaauthserverpolicyrulepropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.AuthServerPolicyRule.property.tfResourceType" id="cdktfprovideroktaauthserverpolicyrulepropertytfresourcetype"></a>

- *Type:* `string`

---

### AuthServerScope <a name="@cdktf/provider-okta.AuthServerScope" id="cdktfprovideroktaauthserverscope"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/r/auth_server_scope okta_auth_server_scope}.

#### Initializers <a name="@cdktf/provider-okta.AuthServerScope.Initializer" id="cdktfprovideroktaauthserverscopeinitializer"></a>

```typescript
import { AuthServerScope } from '@cdktf/provider-okta'

new AuthServerScope(scope: Construct, id: string, config: AuthServerScopeConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktaauthserverscopeparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktaauthserverscopeparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktaauthserverscopeparameterconfig)<span title="Required">*</span> | [`@cdktf/provider-okta.AuthServerScopeConfig`](#@cdktf/provider-okta.AuthServerScopeConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerScope.parameter.scope" id="cdktfprovideroktaauthserverscopeparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerScope.parameter.id" id="cdktfprovideroktaauthserverscopeparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerScope.parameter.config" id="cdktfprovideroktaauthserverscopeparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.AuthServerScopeConfig`](#@cdktf/provider-okta.AuthServerScopeConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`resetConsent`](#cdktfprovideroktaauthserverscoperesetconsent) | *No description.* |
| [`resetDefault`](#cdktfprovideroktaauthserverscoperesetdefault) | *No description.* |
| [`resetDescription`](#cdktfprovideroktaauthserverscoperesetdescription) | *No description.* |
| [`resetDisplayName`](#cdktfprovideroktaauthserverscoperesetdisplayname) | *No description.* |
| [`resetId`](#cdktfprovideroktaauthserverscoperesetid) | *No description.* |
| [`resetMetadataPublish`](#cdktfprovideroktaauthserverscoperesetmetadatapublish) | *No description.* |

---

##### `resetConsent` <a name="@cdktf/provider-okta.AuthServerScope.resetConsent" id="cdktfprovideroktaauthserverscoperesetconsent"></a>

```typescript
public resetConsent()
```

##### `resetDefault` <a name="@cdktf/provider-okta.AuthServerScope.resetDefault" id="cdktfprovideroktaauthserverscoperesetdefault"></a>

```typescript
public resetDefault()
```

##### `resetDescription` <a name="@cdktf/provider-okta.AuthServerScope.resetDescription" id="cdktfprovideroktaauthserverscoperesetdescription"></a>

```typescript
public resetDescription()
```

##### `resetDisplayName` <a name="@cdktf/provider-okta.AuthServerScope.resetDisplayName" id="cdktfprovideroktaauthserverscoperesetdisplayname"></a>

```typescript
public resetDisplayName()
```

##### `resetId` <a name="@cdktf/provider-okta.AuthServerScope.resetId" id="cdktfprovideroktaauthserverscoperesetid"></a>

```typescript
public resetId()
```

##### `resetMetadataPublish` <a name="@cdktf/provider-okta.AuthServerScope.resetMetadataPublish" id="cdktfprovideroktaauthserverscoperesetmetadatapublish"></a>

```typescript
public resetMetadataPublish()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`systemAttribute`](#cdktfprovideroktaauthserverscopepropertysystemattribute)<span title="Required">*</span> | [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`authServerIdInput`](#cdktfprovideroktaauthserverscopepropertyauthserveridinput) | `string` | *No description.* |
| [`consentInput`](#cdktfprovideroktaauthserverscopepropertyconsentinput) | `string` | *No description.* |
| [`defaultInput`](#cdktfprovideroktaauthserverscopepropertydefaultinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`descriptionInput`](#cdktfprovideroktaauthserverscopepropertydescriptioninput) | `string` | *No description.* |
| [`displayNameInput`](#cdktfprovideroktaauthserverscopepropertydisplaynameinput) | `string` | *No description.* |
| [`idInput`](#cdktfprovideroktaauthserverscopepropertyidinput) | `string` | *No description.* |
| [`metadataPublishInput`](#cdktfprovideroktaauthserverscopepropertymetadatapublishinput) | `string` | *No description.* |
| [`nameInput`](#cdktfprovideroktaauthserverscopepropertynameinput) | `string` | *No description.* |
| [`authServerId`](#cdktfprovideroktaauthserverscopepropertyauthserverid)<span title="Required">*</span> | `string` | *No description.* |
| [`consent`](#cdktfprovideroktaauthserverscopepropertyconsent)<span title="Required">*</span> | `string` | *No description.* |
| [`default`](#cdktfprovideroktaauthserverscopepropertydefault)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`description`](#cdktfprovideroktaauthserverscopepropertydescription)<span title="Required">*</span> | `string` | *No description.* |
| [`displayName`](#cdktfprovideroktaauthserverscopepropertydisplayname)<span title="Required">*</span> | `string` | *No description.* |
| [`id`](#cdktfprovideroktaauthserverscopepropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`metadataPublish`](#cdktfprovideroktaauthserverscopepropertymetadatapublish)<span title="Required">*</span> | `string` | *No description.* |
| [`name`](#cdktfprovideroktaauthserverscopepropertyname)<span title="Required">*</span> | `string` | *No description.* |

---

##### `systemAttribute`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerScope.property.systemAttribute" id="cdktfprovideroktaauthserverscopepropertysystemattribute"></a>

```typescript
public readonly systemAttribute: IResolvable;
```

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `authServerIdInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServerScope.property.authServerIdInput" id="cdktfprovideroktaauthserverscopepropertyauthserveridinput"></a>

```typescript
public readonly authServerIdInput: string;
```

- *Type:* `string`

---

##### `consentInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServerScope.property.consentInput" id="cdktfprovideroktaauthserverscopepropertyconsentinput"></a>

```typescript
public readonly consentInput: string;
```

- *Type:* `string`

---

##### `defaultInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServerScope.property.defaultInput" id="cdktfprovideroktaauthserverscopepropertydefaultinput"></a>

```typescript
public readonly defaultInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `descriptionInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServerScope.property.descriptionInput" id="cdktfprovideroktaauthserverscopepropertydescriptioninput"></a>

```typescript
public readonly descriptionInput: string;
```

- *Type:* `string`

---

##### `displayNameInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServerScope.property.displayNameInput" id="cdktfprovideroktaauthserverscopepropertydisplaynameinput"></a>

```typescript
public readonly displayNameInput: string;
```

- *Type:* `string`

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServerScope.property.idInput" id="cdktfprovideroktaauthserverscopepropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `metadataPublishInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServerScope.property.metadataPublishInput" id="cdktfprovideroktaauthserverscopepropertymetadatapublishinput"></a>

```typescript
public readonly metadataPublishInput: string;
```

- *Type:* `string`

---

##### `nameInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AuthServerScope.property.nameInput" id="cdktfprovideroktaauthserverscopepropertynameinput"></a>

```typescript
public readonly nameInput: string;
```

- *Type:* `string`

---

##### `authServerId`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerScope.property.authServerId" id="cdktfprovideroktaauthserverscopepropertyauthserverid"></a>

```typescript
public readonly authServerId: string;
```

- *Type:* `string`

---

##### `consent`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerScope.property.consent" id="cdktfprovideroktaauthserverscopepropertyconsent"></a>

```typescript
public readonly consent: string;
```

- *Type:* `string`

---

##### `default`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerScope.property.default" id="cdktfprovideroktaauthserverscopepropertydefault"></a>

```typescript
public readonly default: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `description`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerScope.property.description" id="cdktfprovideroktaauthserverscopepropertydescription"></a>

```typescript
public readonly description: string;
```

- *Type:* `string`

---

##### `displayName`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerScope.property.displayName" id="cdktfprovideroktaauthserverscopepropertydisplayname"></a>

```typescript
public readonly displayName: string;
```

- *Type:* `string`

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerScope.property.id" id="cdktfprovideroktaauthserverscopepropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `metadataPublish`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerScope.property.metadataPublish" id="cdktfprovideroktaauthserverscopepropertymetadatapublish"></a>

```typescript
public readonly metadataPublish: string;
```

- *Type:* `string`

---

##### `name`<sup>Required</sup> <a name="@cdktf/provider-okta.AuthServerScope.property.name" id="cdktfprovideroktaauthserverscopepropertyname"></a>

```typescript
public readonly name: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktaauthserverscopepropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.AuthServerScope.property.tfResourceType" id="cdktfprovideroktaauthserverscopepropertytfresourcetype"></a>

- *Type:* `string`

---

### AutoLoginApp <a name="@cdktf/provider-okta.AutoLoginApp" id="cdktfprovideroktaautologinapp"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/r/auto_login_app okta_auto_login_app}.

#### Initializers <a name="@cdktf/provider-okta.AutoLoginApp.Initializer" id="cdktfprovideroktaautologinappinitializer"></a>

```typescript
import { AutoLoginApp } from '@cdktf/provider-okta'

new AutoLoginApp(scope: Construct, id: string, config: AutoLoginAppConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktaautologinappparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktaautologinappparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktaautologinappparameterconfig)<span title="Required">*</span> | [`@cdktf/provider-okta.AutoLoginAppConfig`](#@cdktf/provider-okta.AutoLoginAppConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.AutoLoginApp.parameter.scope" id="cdktfprovideroktaautologinappparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AutoLoginApp.parameter.id" id="cdktfprovideroktaautologinappparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="@cdktf/provider-okta.AutoLoginApp.parameter.config" id="cdktfprovideroktaautologinappparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.AutoLoginAppConfig`](#@cdktf/provider-okta.AutoLoginAppConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`putTimeouts`](#cdktfprovideroktaautologinappputtimeouts) | *No description.* |
| [`putUsers`](#cdktfprovideroktaautologinappputusers) | *No description.* |
| [`resetAccessibilityErrorRedirectUrl`](#cdktfprovideroktaautologinappresetaccessibilityerrorredirecturl) | *No description.* |
| [`resetAccessibilityLoginRedirectUrl`](#cdktfprovideroktaautologinappresetaccessibilityloginredirecturl) | *No description.* |
| [`resetAccessibilitySelfService`](#cdktfprovideroktaautologinappresetaccessibilityselfservice) | *No description.* |
| [`resetAdminNote`](#cdktfprovideroktaautologinappresetadminnote) | *No description.* |
| [`resetAppLinksJson`](#cdktfprovideroktaautologinappresetapplinksjson) | *No description.* |
| [`resetAppSettingsJson`](#cdktfprovideroktaautologinappresetappsettingsjson) | *No description.* |
| [`resetAutoSubmitToolbar`](#cdktfprovideroktaautologinappresetautosubmittoolbar) | *No description.* |
| [`resetCredentialsScheme`](#cdktfprovideroktaautologinappresetcredentialsscheme) | *No description.* |
| [`resetEnduserNote`](#cdktfprovideroktaautologinappresetendusernote) | *No description.* |
| [`resetGroups`](#cdktfprovideroktaautologinappresetgroups) | *No description.* |
| [`resetHideIos`](#cdktfprovideroktaautologinappresethideios) | *No description.* |
| [`resetHideWeb`](#cdktfprovideroktaautologinappresethideweb) | *No description.* |
| [`resetId`](#cdktfprovideroktaautologinappresetid) | *No description.* |
| [`resetLogo`](#cdktfprovideroktaautologinappresetlogo) | *No description.* |
| [`resetPreconfiguredApp`](#cdktfprovideroktaautologinappresetpreconfiguredapp) | *No description.* |
| [`resetRevealPassword`](#cdktfprovideroktaautologinappresetrevealpassword) | *No description.* |
| [`resetSharedPassword`](#cdktfprovideroktaautologinappresetsharedpassword) | *No description.* |
| [`resetSharedUsername`](#cdktfprovideroktaautologinappresetsharedusername) | *No description.* |
| [`resetSignOnRedirectUrl`](#cdktfprovideroktaautologinappresetsignonredirecturl) | *No description.* |
| [`resetSignOnUrl`](#cdktfprovideroktaautologinappresetsignonurl) | *No description.* |
| [`resetSkipGroups`](#cdktfprovideroktaautologinappresetskipgroups) | *No description.* |
| [`resetSkipUsers`](#cdktfprovideroktaautologinappresetskipusers) | *No description.* |
| [`resetStatus`](#cdktfprovideroktaautologinappresetstatus) | *No description.* |
| [`resetTimeouts`](#cdktfprovideroktaautologinappresettimeouts) | *No description.* |
| [`resetUserNameTemplate`](#cdktfprovideroktaautologinappresetusernametemplate) | *No description.* |
| [`resetUserNameTemplatePushStatus`](#cdktfprovideroktaautologinappresetusernametemplatepushstatus) | *No description.* |
| [`resetUserNameTemplateSuffix`](#cdktfprovideroktaautologinappresetusernametemplatesuffix) | *No description.* |
| [`resetUserNameTemplateType`](#cdktfprovideroktaautologinappresetusernametemplatetype) | *No description.* |
| [`resetUsers`](#cdktfprovideroktaautologinappresetusers) | *No description.* |

---

##### `putTimeouts` <a name="@cdktf/provider-okta.AutoLoginApp.putTimeouts" id="cdktfprovideroktaautologinappputtimeouts"></a>

```typescript
public putTimeouts(value: AutoLoginAppTimeouts)
```

###### `value`<sup>Required</sup> <a name="@cdktf/provider-okta.AutoLoginApp.parameter.value" id="cdktfprovideroktaautologinappparametervalue"></a>

- *Type:* [`@cdktf/provider-okta.AutoLoginAppTimeouts`](#@cdktf/provider-okta.AutoLoginAppTimeouts)

---

##### `putUsers` <a name="@cdktf/provider-okta.AutoLoginApp.putUsers" id="cdktfprovideroktaautologinappputusers"></a>

```typescript
public putUsers(value: IResolvable | AutoLoginAppUsers[])
```

###### `value`<sup>Required</sup> <a name="@cdktf/provider-okta.AutoLoginApp.parameter.value" id="cdktfprovideroktaautologinappparametervalue"></a>

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable) | [`@cdktf/provider-okta.AutoLoginAppUsers`](#@cdktf/provider-okta.AutoLoginAppUsers)[]

---

##### `resetAccessibilityErrorRedirectUrl` <a name="@cdktf/provider-okta.AutoLoginApp.resetAccessibilityErrorRedirectUrl" id="cdktfprovideroktaautologinappresetaccessibilityerrorredirecturl"></a>

```typescript
public resetAccessibilityErrorRedirectUrl()
```

##### `resetAccessibilityLoginRedirectUrl` <a name="@cdktf/provider-okta.AutoLoginApp.resetAccessibilityLoginRedirectUrl" id="cdktfprovideroktaautologinappresetaccessibilityloginredirecturl"></a>

```typescript
public resetAccessibilityLoginRedirectUrl()
```

##### `resetAccessibilitySelfService` <a name="@cdktf/provider-okta.AutoLoginApp.resetAccessibilitySelfService" id="cdktfprovideroktaautologinappresetaccessibilityselfservice"></a>

```typescript
public resetAccessibilitySelfService()
```

##### `resetAdminNote` <a name="@cdktf/provider-okta.AutoLoginApp.resetAdminNote" id="cdktfprovideroktaautologinappresetadminnote"></a>

```typescript
public resetAdminNote()
```

##### `resetAppLinksJson` <a name="@cdktf/provider-okta.AutoLoginApp.resetAppLinksJson" id="cdktfprovideroktaautologinappresetapplinksjson"></a>

```typescript
public resetAppLinksJson()
```

##### `resetAppSettingsJson` <a name="@cdktf/provider-okta.AutoLoginApp.resetAppSettingsJson" id="cdktfprovideroktaautologinappresetappsettingsjson"></a>

```typescript
public resetAppSettingsJson()
```

##### `resetAutoSubmitToolbar` <a name="@cdktf/provider-okta.AutoLoginApp.resetAutoSubmitToolbar" id="cdktfprovideroktaautologinappresetautosubmittoolbar"></a>

```typescript
public resetAutoSubmitToolbar()
```

##### `resetCredentialsScheme` <a name="@cdktf/provider-okta.AutoLoginApp.resetCredentialsScheme" id="cdktfprovideroktaautologinappresetcredentialsscheme"></a>

```typescript
public resetCredentialsScheme()
```

##### `resetEnduserNote` <a name="@cdktf/provider-okta.AutoLoginApp.resetEnduserNote" id="cdktfprovideroktaautologinappresetendusernote"></a>

```typescript
public resetEnduserNote()
```

##### `resetGroups` <a name="@cdktf/provider-okta.AutoLoginApp.resetGroups" id="cdktfprovideroktaautologinappresetgroups"></a>

```typescript
public resetGroups()
```

##### `resetHideIos` <a name="@cdktf/provider-okta.AutoLoginApp.resetHideIos" id="cdktfprovideroktaautologinappresethideios"></a>

```typescript
public resetHideIos()
```

##### `resetHideWeb` <a name="@cdktf/provider-okta.AutoLoginApp.resetHideWeb" id="cdktfprovideroktaautologinappresethideweb"></a>

```typescript
public resetHideWeb()
```

##### `resetId` <a name="@cdktf/provider-okta.AutoLoginApp.resetId" id="cdktfprovideroktaautologinappresetid"></a>

```typescript
public resetId()
```

##### `resetLogo` <a name="@cdktf/provider-okta.AutoLoginApp.resetLogo" id="cdktfprovideroktaautologinappresetlogo"></a>

```typescript
public resetLogo()
```

##### `resetPreconfiguredApp` <a name="@cdktf/provider-okta.AutoLoginApp.resetPreconfiguredApp" id="cdktfprovideroktaautologinappresetpreconfiguredapp"></a>

```typescript
public resetPreconfiguredApp()
```

##### `resetRevealPassword` <a name="@cdktf/provider-okta.AutoLoginApp.resetRevealPassword" id="cdktfprovideroktaautologinappresetrevealpassword"></a>

```typescript
public resetRevealPassword()
```

##### `resetSharedPassword` <a name="@cdktf/provider-okta.AutoLoginApp.resetSharedPassword" id="cdktfprovideroktaautologinappresetsharedpassword"></a>

```typescript
public resetSharedPassword()
```

##### `resetSharedUsername` <a name="@cdktf/provider-okta.AutoLoginApp.resetSharedUsername" id="cdktfprovideroktaautologinappresetsharedusername"></a>

```typescript
public resetSharedUsername()
```

##### `resetSignOnRedirectUrl` <a name="@cdktf/provider-okta.AutoLoginApp.resetSignOnRedirectUrl" id="cdktfprovideroktaautologinappresetsignonredirecturl"></a>

```typescript
public resetSignOnRedirectUrl()
```

##### `resetSignOnUrl` <a name="@cdktf/provider-okta.AutoLoginApp.resetSignOnUrl" id="cdktfprovideroktaautologinappresetsignonurl"></a>

```typescript
public resetSignOnUrl()
```

##### `resetSkipGroups` <a name="@cdktf/provider-okta.AutoLoginApp.resetSkipGroups" id="cdktfprovideroktaautologinappresetskipgroups"></a>

```typescript
public resetSkipGroups()
```

##### `resetSkipUsers` <a name="@cdktf/provider-okta.AutoLoginApp.resetSkipUsers" id="cdktfprovideroktaautologinappresetskipusers"></a>

```typescript
public resetSkipUsers()
```

##### `resetStatus` <a name="@cdktf/provider-okta.AutoLoginApp.resetStatus" id="cdktfprovideroktaautologinappresetstatus"></a>

```typescript
public resetStatus()
```

##### `resetTimeouts` <a name="@cdktf/provider-okta.AutoLoginApp.resetTimeouts" id="cdktfprovideroktaautologinappresettimeouts"></a>

```typescript
public resetTimeouts()
```

##### `resetUserNameTemplate` <a name="@cdktf/provider-okta.AutoLoginApp.resetUserNameTemplate" id="cdktfprovideroktaautologinappresetusernametemplate"></a>

```typescript
public resetUserNameTemplate()
```

##### `resetUserNameTemplatePushStatus` <a name="@cdktf/provider-okta.AutoLoginApp.resetUserNameTemplatePushStatus" id="cdktfprovideroktaautologinappresetusernametemplatepushstatus"></a>

```typescript
public resetUserNameTemplatePushStatus()
```

##### `resetUserNameTemplateSuffix` <a name="@cdktf/provider-okta.AutoLoginApp.resetUserNameTemplateSuffix" id="cdktfprovideroktaautologinappresetusernametemplatesuffix"></a>

```typescript
public resetUserNameTemplateSuffix()
```

##### `resetUserNameTemplateType` <a name="@cdktf/provider-okta.AutoLoginApp.resetUserNameTemplateType" id="cdktfprovideroktaautologinappresetusernametemplatetype"></a>

```typescript
public resetUserNameTemplateType()
```

##### `resetUsers` <a name="@cdktf/provider-okta.AutoLoginApp.resetUsers" id="cdktfprovideroktaautologinappresetusers"></a>

```typescript
public resetUsers()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`logoUrl`](#cdktfprovideroktaautologinapppropertylogourl)<span title="Required">*</span> | `string` | *No description.* |
| [`name`](#cdktfprovideroktaautologinapppropertyname)<span title="Required">*</span> | `string` | *No description.* |
| [`signOnMode`](#cdktfprovideroktaautologinapppropertysignonmode)<span title="Required">*</span> | `string` | *No description.* |
| [`timeouts`](#cdktfprovideroktaautologinapppropertytimeouts)<span title="Required">*</span> | [`@cdktf/provider-okta.AutoLoginAppTimeoutsOutputReference`](#@cdktf/provider-okta.AutoLoginAppTimeoutsOutputReference) | *No description.* |
| [`users`](#cdktfprovideroktaautologinapppropertyusers)<span title="Required">*</span> | [`@cdktf/provider-okta.AutoLoginAppUsersList`](#@cdktf/provider-okta.AutoLoginAppUsersList) | *No description.* |
| [`accessibilityErrorRedirectUrlInput`](#cdktfprovideroktaautologinapppropertyaccessibilityerrorredirecturlinput) | `string` | *No description.* |
| [`accessibilityLoginRedirectUrlInput`](#cdktfprovideroktaautologinapppropertyaccessibilityloginredirecturlinput) | `string` | *No description.* |
| [`accessibilitySelfServiceInput`](#cdktfprovideroktaautologinapppropertyaccessibilityselfserviceinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`adminNoteInput`](#cdktfprovideroktaautologinapppropertyadminnoteinput) | `string` | *No description.* |
| [`appLinksJsonInput`](#cdktfprovideroktaautologinapppropertyapplinksjsoninput) | `string` | *No description.* |
| [`appSettingsJsonInput`](#cdktfprovideroktaautologinapppropertyappsettingsjsoninput) | `string` | *No description.* |
| [`autoSubmitToolbarInput`](#cdktfprovideroktaautologinapppropertyautosubmittoolbarinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`credentialsSchemeInput`](#cdktfprovideroktaautologinapppropertycredentialsschemeinput) | `string` | *No description.* |
| [`enduserNoteInput`](#cdktfprovideroktaautologinapppropertyendusernoteinput) | `string` | *No description.* |
| [`groupsInput`](#cdktfprovideroktaautologinapppropertygroupsinput) | `string`[] | *No description.* |
| [`hideIosInput`](#cdktfprovideroktaautologinapppropertyhideiosinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`hideWebInput`](#cdktfprovideroktaautologinapppropertyhidewebinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`idInput`](#cdktfprovideroktaautologinapppropertyidinput) | `string` | *No description.* |
| [`labelInput`](#cdktfprovideroktaautologinapppropertylabelinput) | `string` | *No description.* |
| [`logoInput`](#cdktfprovideroktaautologinapppropertylogoinput) | `string` | *No description.* |
| [`preconfiguredAppInput`](#cdktfprovideroktaautologinapppropertypreconfiguredappinput) | `string` | *No description.* |
| [`revealPasswordInput`](#cdktfprovideroktaautologinapppropertyrevealpasswordinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`sharedPasswordInput`](#cdktfprovideroktaautologinapppropertysharedpasswordinput) | `string` | *No description.* |
| [`sharedUsernameInput`](#cdktfprovideroktaautologinapppropertysharedusernameinput) | `string` | *No description.* |
| [`signOnRedirectUrlInput`](#cdktfprovideroktaautologinapppropertysignonredirecturlinput) | `string` | *No description.* |
| [`signOnUrlInput`](#cdktfprovideroktaautologinapppropertysignonurlinput) | `string` | *No description.* |
| [`skipGroupsInput`](#cdktfprovideroktaautologinapppropertyskipgroupsinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`skipUsersInput`](#cdktfprovideroktaautologinapppropertyskipusersinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`statusInput`](#cdktfprovideroktaautologinapppropertystatusinput) | `string` | *No description.* |
| [`timeoutsInput`](#cdktfprovideroktaautologinapppropertytimeoutsinput) | [`cdktf.IResolvable`](#cdktf.IResolvable) \| [`@cdktf/provider-okta.AutoLoginAppTimeouts`](#@cdktf/provider-okta.AutoLoginAppTimeouts) | *No description.* |
| [`userNameTemplateInput`](#cdktfprovideroktaautologinapppropertyusernametemplateinput) | `string` | *No description.* |
| [`userNameTemplatePushStatusInput`](#cdktfprovideroktaautologinapppropertyusernametemplatepushstatusinput) | `string` | *No description.* |
| [`userNameTemplateSuffixInput`](#cdktfprovideroktaautologinapppropertyusernametemplatesuffixinput) | `string` | *No description.* |
| [`userNameTemplateTypeInput`](#cdktfprovideroktaautologinapppropertyusernametemplatetypeinput) | `string` | *No description.* |
| [`usersInput`](#cdktfprovideroktaautologinapppropertyusersinput) | [`cdktf.IResolvable`](#cdktf.IResolvable) \| [`@cdktf/provider-okta.AutoLoginAppUsers`](#@cdktf/provider-okta.AutoLoginAppUsers)[] | *No description.* |
| [`accessibilityErrorRedirectUrl`](#cdktfprovideroktaautologinapppropertyaccessibilityerrorredirecturl)<span title="Required">*</span> | `string` | *No description.* |
| [`accessibilityLoginRedirectUrl`](#cdktfprovideroktaautologinapppropertyaccessibilityloginredirecturl)<span title="Required">*</span> | `string` | *No description.* |
| [`accessibilitySelfService`](#cdktfprovideroktaautologinapppropertyaccessibilityselfservice)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`adminNote`](#cdktfprovideroktaautologinapppropertyadminnote)<span title="Required">*</span> | `string` | *No description.* |
| [`appLinksJson`](#cdktfprovideroktaautologinapppropertyapplinksjson)<span title="Required">*</span> | `string` | *No description.* |
| [`appSettingsJson`](#cdktfprovideroktaautologinapppropertyappsettingsjson)<span title="Required">*</span> | `string` | *No description.* |
| [`autoSubmitToolbar`](#cdktfprovideroktaautologinapppropertyautosubmittoolbar)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`credentialsScheme`](#cdktfprovideroktaautologinapppropertycredentialsscheme)<span title="Required">*</span> | `string` | *No description.* |
| [`enduserNote`](#cdktfprovideroktaautologinapppropertyendusernote)<span title="Required">*</span> | `string` | *No description.* |
| [`groups`](#cdktfprovideroktaautologinapppropertygroups)<span title="Required">*</span> | `string`[] | *No description.* |
| [`hideIos`](#cdktfprovideroktaautologinapppropertyhideios)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`hideWeb`](#cdktfprovideroktaautologinapppropertyhideweb)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`id`](#cdktfprovideroktaautologinapppropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`label`](#cdktfprovideroktaautologinapppropertylabel)<span title="Required">*</span> | `string` | *No description.* |
| [`logo`](#cdktfprovideroktaautologinapppropertylogo)<span title="Required">*</span> | `string` | *No description.* |
| [`preconfiguredApp`](#cdktfprovideroktaautologinapppropertypreconfiguredapp)<span title="Required">*</span> | `string` | *No description.* |
| [`revealPassword`](#cdktfprovideroktaautologinapppropertyrevealpassword)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`sharedPassword`](#cdktfprovideroktaautologinapppropertysharedpassword)<span title="Required">*</span> | `string` | *No description.* |
| [`sharedUsername`](#cdktfprovideroktaautologinapppropertysharedusername)<span title="Required">*</span> | `string` | *No description.* |
| [`signOnRedirectUrl`](#cdktfprovideroktaautologinapppropertysignonredirecturl)<span title="Required">*</span> | `string` | *No description.* |
| [`signOnUrl`](#cdktfprovideroktaautologinapppropertysignonurl)<span title="Required">*</span> | `string` | *No description.* |
| [`skipGroups`](#cdktfprovideroktaautologinapppropertyskipgroups)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`skipUsers`](#cdktfprovideroktaautologinapppropertyskipusers)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`status`](#cdktfprovideroktaautologinapppropertystatus)<span title="Required">*</span> | `string` | *No description.* |
| [`userNameTemplate`](#cdktfprovideroktaautologinapppropertyusernametemplate)<span title="Required">*</span> | `string` | *No description.* |
| [`userNameTemplatePushStatus`](#cdktfprovideroktaautologinapppropertyusernametemplatepushstatus)<span title="Required">*</span> | `string` | *No description.* |
| [`userNameTemplateSuffix`](#cdktfprovideroktaautologinapppropertyusernametemplatesuffix)<span title="Required">*</span> | `string` | *No description.* |
| [`userNameTemplateType`](#cdktfprovideroktaautologinapppropertyusernametemplatetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `logoUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.logoUrl" id="cdktfprovideroktaautologinapppropertylogourl"></a>

```typescript
public readonly logoUrl: string;
```

- *Type:* `string`

---

##### `name`<sup>Required</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.name" id="cdktfprovideroktaautologinapppropertyname"></a>

```typescript
public readonly name: string;
```

- *Type:* `string`

---

##### `signOnMode`<sup>Required</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.signOnMode" id="cdktfprovideroktaautologinapppropertysignonmode"></a>

```typescript
public readonly signOnMode: string;
```

- *Type:* `string`

---

##### `timeouts`<sup>Required</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.timeouts" id="cdktfprovideroktaautologinapppropertytimeouts"></a>

```typescript
public readonly timeouts: AutoLoginAppTimeoutsOutputReference;
```

- *Type:* [`@cdktf/provider-okta.AutoLoginAppTimeoutsOutputReference`](#@cdktf/provider-okta.AutoLoginAppTimeoutsOutputReference)

---

##### `users`<sup>Required</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.users" id="cdktfprovideroktaautologinapppropertyusers"></a>

```typescript
public readonly users: AutoLoginAppUsersList;
```

- *Type:* [`@cdktf/provider-okta.AutoLoginAppUsersList`](#@cdktf/provider-okta.AutoLoginAppUsersList)

---

##### `accessibilityErrorRedirectUrlInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.accessibilityErrorRedirectUrlInput" id="cdktfprovideroktaautologinapppropertyaccessibilityerrorredirecturlinput"></a>

```typescript
public readonly accessibilityErrorRedirectUrlInput: string;
```

- *Type:* `string`

---

##### `accessibilityLoginRedirectUrlInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.accessibilityLoginRedirectUrlInput" id="cdktfprovideroktaautologinapppropertyaccessibilityloginredirecturlinput"></a>

```typescript
public readonly accessibilityLoginRedirectUrlInput: string;
```

- *Type:* `string`

---

##### `accessibilitySelfServiceInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.accessibilitySelfServiceInput" id="cdktfprovideroktaautologinapppropertyaccessibilityselfserviceinput"></a>

```typescript
public readonly accessibilitySelfServiceInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `adminNoteInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.adminNoteInput" id="cdktfprovideroktaautologinapppropertyadminnoteinput"></a>

```typescript
public readonly adminNoteInput: string;
```

- *Type:* `string`

---

##### `appLinksJsonInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.appLinksJsonInput" id="cdktfprovideroktaautologinapppropertyapplinksjsoninput"></a>

```typescript
public readonly appLinksJsonInput: string;
```

- *Type:* `string`

---

##### `appSettingsJsonInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.appSettingsJsonInput" id="cdktfprovideroktaautologinapppropertyappsettingsjsoninput"></a>

```typescript
public readonly appSettingsJsonInput: string;
```

- *Type:* `string`

---

##### `autoSubmitToolbarInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.autoSubmitToolbarInput" id="cdktfprovideroktaautologinapppropertyautosubmittoolbarinput"></a>

```typescript
public readonly autoSubmitToolbarInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `credentialsSchemeInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.credentialsSchemeInput" id="cdktfprovideroktaautologinapppropertycredentialsschemeinput"></a>

```typescript
public readonly credentialsSchemeInput: string;
```

- *Type:* `string`

---

##### `enduserNoteInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.enduserNoteInput" id="cdktfprovideroktaautologinapppropertyendusernoteinput"></a>

```typescript
public readonly enduserNoteInput: string;
```

- *Type:* `string`

---

##### `groupsInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.groupsInput" id="cdktfprovideroktaautologinapppropertygroupsinput"></a>

```typescript
public readonly groupsInput: string[];
```

- *Type:* `string`[]

---

##### `hideIosInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.hideIosInput" id="cdktfprovideroktaautologinapppropertyhideiosinput"></a>

```typescript
public readonly hideIosInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `hideWebInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.hideWebInput" id="cdktfprovideroktaautologinapppropertyhidewebinput"></a>

```typescript
public readonly hideWebInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.idInput" id="cdktfprovideroktaautologinapppropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `labelInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.labelInput" id="cdktfprovideroktaautologinapppropertylabelinput"></a>

```typescript
public readonly labelInput: string;
```

- *Type:* `string`

---

##### `logoInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.logoInput" id="cdktfprovideroktaautologinapppropertylogoinput"></a>

```typescript
public readonly logoInput: string;
```

- *Type:* `string`

---

##### `preconfiguredAppInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.preconfiguredAppInput" id="cdktfprovideroktaautologinapppropertypreconfiguredappinput"></a>

```typescript
public readonly preconfiguredAppInput: string;
```

- *Type:* `string`

---

##### `revealPasswordInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.revealPasswordInput" id="cdktfprovideroktaautologinapppropertyrevealpasswordinput"></a>

```typescript
public readonly revealPasswordInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `sharedPasswordInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.sharedPasswordInput" id="cdktfprovideroktaautologinapppropertysharedpasswordinput"></a>

```typescript
public readonly sharedPasswordInput: string;
```

- *Type:* `string`

---

##### `sharedUsernameInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.sharedUsernameInput" id="cdktfprovideroktaautologinapppropertysharedusernameinput"></a>

```typescript
public readonly sharedUsernameInput: string;
```

- *Type:* `string`

---

##### `signOnRedirectUrlInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.signOnRedirectUrlInput" id="cdktfprovideroktaautologinapppropertysignonredirecturlinput"></a>

```typescript
public readonly signOnRedirectUrlInput: string;
```

- *Type:* `string`

---

##### `signOnUrlInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.signOnUrlInput" id="cdktfprovideroktaautologinapppropertysignonurlinput"></a>

```typescript
public readonly signOnUrlInput: string;
```

- *Type:* `string`

---

##### `skipGroupsInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.skipGroupsInput" id="cdktfprovideroktaautologinapppropertyskipgroupsinput"></a>

```typescript
public readonly skipGroupsInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `skipUsersInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.skipUsersInput" id="cdktfprovideroktaautologinapppropertyskipusersinput"></a>

```typescript
public readonly skipUsersInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `statusInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.statusInput" id="cdktfprovideroktaautologinapppropertystatusinput"></a>

```typescript
public readonly statusInput: string;
```

- *Type:* `string`

---

##### `timeoutsInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.timeoutsInput" id="cdktfprovideroktaautologinapppropertytimeoutsinput"></a>

```typescript
public readonly timeoutsInput: IResolvable | AutoLoginAppTimeouts;
```

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable) | [`@cdktf/provider-okta.AutoLoginAppTimeouts`](#@cdktf/provider-okta.AutoLoginAppTimeouts)

---

##### `userNameTemplateInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.userNameTemplateInput" id="cdktfprovideroktaautologinapppropertyusernametemplateinput"></a>

```typescript
public readonly userNameTemplateInput: string;
```

- *Type:* `string`

---

##### `userNameTemplatePushStatusInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.userNameTemplatePushStatusInput" id="cdktfprovideroktaautologinapppropertyusernametemplatepushstatusinput"></a>

```typescript
public readonly userNameTemplatePushStatusInput: string;
```

- *Type:* `string`

---

##### `userNameTemplateSuffixInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.userNameTemplateSuffixInput" id="cdktfprovideroktaautologinapppropertyusernametemplatesuffixinput"></a>

```typescript
public readonly userNameTemplateSuffixInput: string;
```

- *Type:* `string`

---

##### `userNameTemplateTypeInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.userNameTemplateTypeInput" id="cdktfprovideroktaautologinapppropertyusernametemplatetypeinput"></a>

```typescript
public readonly userNameTemplateTypeInput: string;
```

- *Type:* `string`

---

##### `usersInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.usersInput" id="cdktfprovideroktaautologinapppropertyusersinput"></a>

```typescript
public readonly usersInput: IResolvable | AutoLoginAppUsers[];
```

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable) | [`@cdktf/provider-okta.AutoLoginAppUsers`](#@cdktf/provider-okta.AutoLoginAppUsers)[]

---

##### `accessibilityErrorRedirectUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.accessibilityErrorRedirectUrl" id="cdktfprovideroktaautologinapppropertyaccessibilityerrorredirecturl"></a>

```typescript
public readonly accessibilityErrorRedirectUrl: string;
```

- *Type:* `string`

---

##### `accessibilityLoginRedirectUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.accessibilityLoginRedirectUrl" id="cdktfprovideroktaautologinapppropertyaccessibilityloginredirecturl"></a>

```typescript
public readonly accessibilityLoginRedirectUrl: string;
```

- *Type:* `string`

---

##### `accessibilitySelfService`<sup>Required</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.accessibilitySelfService" id="cdktfprovideroktaautologinapppropertyaccessibilityselfservice"></a>

```typescript
public readonly accessibilitySelfService: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `adminNote`<sup>Required</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.adminNote" id="cdktfprovideroktaautologinapppropertyadminnote"></a>

```typescript
public readonly adminNote: string;
```

- *Type:* `string`

---

##### `appLinksJson`<sup>Required</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.appLinksJson" id="cdktfprovideroktaautologinapppropertyapplinksjson"></a>

```typescript
public readonly appLinksJson: string;
```

- *Type:* `string`

---

##### `appSettingsJson`<sup>Required</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.appSettingsJson" id="cdktfprovideroktaautologinapppropertyappsettingsjson"></a>

```typescript
public readonly appSettingsJson: string;
```

- *Type:* `string`

---

##### `autoSubmitToolbar`<sup>Required</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.autoSubmitToolbar" id="cdktfprovideroktaautologinapppropertyautosubmittoolbar"></a>

```typescript
public readonly autoSubmitToolbar: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `credentialsScheme`<sup>Required</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.credentialsScheme" id="cdktfprovideroktaautologinapppropertycredentialsscheme"></a>

```typescript
public readonly credentialsScheme: string;
```

- *Type:* `string`

---

##### `enduserNote`<sup>Required</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.enduserNote" id="cdktfprovideroktaautologinapppropertyendusernote"></a>

```typescript
public readonly enduserNote: string;
```

- *Type:* `string`

---

##### `groups`<sup>Required</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.groups" id="cdktfprovideroktaautologinapppropertygroups"></a>

```typescript
public readonly groups: string[];
```

- *Type:* `string`[]

---

##### `hideIos`<sup>Required</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.hideIos" id="cdktfprovideroktaautologinapppropertyhideios"></a>

```typescript
public readonly hideIos: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `hideWeb`<sup>Required</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.hideWeb" id="cdktfprovideroktaautologinapppropertyhideweb"></a>

```typescript
public readonly hideWeb: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.id" id="cdktfprovideroktaautologinapppropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `label`<sup>Required</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.label" id="cdktfprovideroktaautologinapppropertylabel"></a>

```typescript
public readonly label: string;
```

- *Type:* `string`

---

##### `logo`<sup>Required</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.logo" id="cdktfprovideroktaautologinapppropertylogo"></a>

```typescript
public readonly logo: string;
```

- *Type:* `string`

---

##### `preconfiguredApp`<sup>Required</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.preconfiguredApp" id="cdktfprovideroktaautologinapppropertypreconfiguredapp"></a>

```typescript
public readonly preconfiguredApp: string;
```

- *Type:* `string`

---

##### `revealPassword`<sup>Required</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.revealPassword" id="cdktfprovideroktaautologinapppropertyrevealpassword"></a>

```typescript
public readonly revealPassword: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `sharedPassword`<sup>Required</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.sharedPassword" id="cdktfprovideroktaautologinapppropertysharedpassword"></a>

```typescript
public readonly sharedPassword: string;
```

- *Type:* `string`

---

##### `sharedUsername`<sup>Required</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.sharedUsername" id="cdktfprovideroktaautologinapppropertysharedusername"></a>

```typescript
public readonly sharedUsername: string;
```

- *Type:* `string`

---

##### `signOnRedirectUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.signOnRedirectUrl" id="cdktfprovideroktaautologinapppropertysignonredirecturl"></a>

```typescript
public readonly signOnRedirectUrl: string;
```

- *Type:* `string`

---

##### `signOnUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.signOnUrl" id="cdktfprovideroktaautologinapppropertysignonurl"></a>

```typescript
public readonly signOnUrl: string;
```

- *Type:* `string`

---

##### `skipGroups`<sup>Required</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.skipGroups" id="cdktfprovideroktaautologinapppropertyskipgroups"></a>

```typescript
public readonly skipGroups: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `skipUsers`<sup>Required</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.skipUsers" id="cdktfprovideroktaautologinapppropertyskipusers"></a>

```typescript
public readonly skipUsers: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `status`<sup>Required</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.status" id="cdktfprovideroktaautologinapppropertystatus"></a>

```typescript
public readonly status: string;
```

- *Type:* `string`

---

##### `userNameTemplate`<sup>Required</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.userNameTemplate" id="cdktfprovideroktaautologinapppropertyusernametemplate"></a>

```typescript
public readonly userNameTemplate: string;
```

- *Type:* `string`

---

##### `userNameTemplatePushStatus`<sup>Required</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.userNameTemplatePushStatus" id="cdktfprovideroktaautologinapppropertyusernametemplatepushstatus"></a>

```typescript
public readonly userNameTemplatePushStatus: string;
```

- *Type:* `string`

---

##### `userNameTemplateSuffix`<sup>Required</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.userNameTemplateSuffix" id="cdktfprovideroktaautologinapppropertyusernametemplatesuffix"></a>

```typescript
public readonly userNameTemplateSuffix: string;
```

- *Type:* `string`

---

##### `userNameTemplateType`<sup>Required</sup> <a name="@cdktf/provider-okta.AutoLoginApp.property.userNameTemplateType" id="cdktfprovideroktaautologinapppropertyusernametemplatetype"></a>

```typescript
public readonly userNameTemplateType: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktaautologinapppropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.AutoLoginApp.property.tfResourceType" id="cdktfprovideroktaautologinapppropertytfresourcetype"></a>

- *Type:* `string`

---

### Behavior <a name="@cdktf/provider-okta.Behavior" id="cdktfprovideroktabehavior"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/r/behavior okta_behavior}.

#### Initializers <a name="@cdktf/provider-okta.Behavior.Initializer" id="cdktfprovideroktabehaviorinitializer"></a>

```typescript
import { Behavior } from '@cdktf/provider-okta'

new Behavior(scope: Construct, id: string, config: BehaviorConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktabehaviorparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktabehaviorparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktabehaviorparameterconfig)<span title="Required">*</span> | [`@cdktf/provider-okta.BehaviorConfig`](#@cdktf/provider-okta.BehaviorConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.Behavior.parameter.scope" id="cdktfprovideroktabehaviorparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.Behavior.parameter.id" id="cdktfprovideroktabehaviorparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="@cdktf/provider-okta.Behavior.parameter.config" id="cdktfprovideroktabehaviorparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.BehaviorConfig`](#@cdktf/provider-okta.BehaviorConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`resetId`](#cdktfprovideroktabehaviorresetid) | *No description.* |
| [`resetLocationGranularityType`](#cdktfprovideroktabehaviorresetlocationgranularitytype) | *No description.* |
| [`resetNumberOfAuthentications`](#cdktfprovideroktabehaviorresetnumberofauthentications) | *No description.* |
| [`resetRadiusFromLocation`](#cdktfprovideroktabehaviorresetradiusfromlocation) | *No description.* |
| [`resetStatus`](#cdktfprovideroktabehaviorresetstatus) | *No description.* |
| [`resetVelocity`](#cdktfprovideroktabehaviorresetvelocity) | *No description.* |

---

##### `resetId` <a name="@cdktf/provider-okta.Behavior.resetId" id="cdktfprovideroktabehaviorresetid"></a>

```typescript
public resetId()
```

##### `resetLocationGranularityType` <a name="@cdktf/provider-okta.Behavior.resetLocationGranularityType" id="cdktfprovideroktabehaviorresetlocationgranularitytype"></a>

```typescript
public resetLocationGranularityType()
```

##### `resetNumberOfAuthentications` <a name="@cdktf/provider-okta.Behavior.resetNumberOfAuthentications" id="cdktfprovideroktabehaviorresetnumberofauthentications"></a>

```typescript
public resetNumberOfAuthentications()
```

##### `resetRadiusFromLocation` <a name="@cdktf/provider-okta.Behavior.resetRadiusFromLocation" id="cdktfprovideroktabehaviorresetradiusfromlocation"></a>

```typescript
public resetRadiusFromLocation()
```

##### `resetStatus` <a name="@cdktf/provider-okta.Behavior.resetStatus" id="cdktfprovideroktabehaviorresetstatus"></a>

```typescript
public resetStatus()
```

##### `resetVelocity` <a name="@cdktf/provider-okta.Behavior.resetVelocity" id="cdktfprovideroktabehaviorresetvelocity"></a>

```typescript
public resetVelocity()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`idInput`](#cdktfprovideroktabehaviorpropertyidinput) | `string` | *No description.* |
| [`locationGranularityTypeInput`](#cdktfprovideroktabehaviorpropertylocationgranularitytypeinput) | `string` | *No description.* |
| [`nameInput`](#cdktfprovideroktabehaviorpropertynameinput) | `string` | *No description.* |
| [`numberOfAuthenticationsInput`](#cdktfprovideroktabehaviorpropertynumberofauthenticationsinput) | `number` | *No description.* |
| [`radiusFromLocationInput`](#cdktfprovideroktabehaviorpropertyradiusfromlocationinput) | `number` | *No description.* |
| [`statusInput`](#cdktfprovideroktabehaviorpropertystatusinput) | `string` | *No description.* |
| [`typeInput`](#cdktfprovideroktabehaviorpropertytypeinput) | `string` | *No description.* |
| [`velocityInput`](#cdktfprovideroktabehaviorpropertyvelocityinput) | `number` | *No description.* |
| [`id`](#cdktfprovideroktabehaviorpropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`locationGranularityType`](#cdktfprovideroktabehaviorpropertylocationgranularitytype)<span title="Required">*</span> | `string` | *No description.* |
| [`name`](#cdktfprovideroktabehaviorpropertyname)<span title="Required">*</span> | `string` | *No description.* |
| [`numberOfAuthentications`](#cdktfprovideroktabehaviorpropertynumberofauthentications)<span title="Required">*</span> | `number` | *No description.* |
| [`radiusFromLocation`](#cdktfprovideroktabehaviorpropertyradiusfromlocation)<span title="Required">*</span> | `number` | *No description.* |
| [`status`](#cdktfprovideroktabehaviorpropertystatus)<span title="Required">*</span> | `string` | *No description.* |
| [`type`](#cdktfprovideroktabehaviorpropertytype)<span title="Required">*</span> | `string` | *No description.* |
| [`velocity`](#cdktfprovideroktabehaviorpropertyvelocity)<span title="Required">*</span> | `number` | *No description.* |

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.Behavior.property.idInput" id="cdktfprovideroktabehaviorpropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `locationGranularityTypeInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.Behavior.property.locationGranularityTypeInput" id="cdktfprovideroktabehaviorpropertylocationgranularitytypeinput"></a>

```typescript
public readonly locationGranularityTypeInput: string;
```

- *Type:* `string`

---

##### `nameInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.Behavior.property.nameInput" id="cdktfprovideroktabehaviorpropertynameinput"></a>

```typescript
public readonly nameInput: string;
```

- *Type:* `string`

---

##### `numberOfAuthenticationsInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.Behavior.property.numberOfAuthenticationsInput" id="cdktfprovideroktabehaviorpropertynumberofauthenticationsinput"></a>

```typescript
public readonly numberOfAuthenticationsInput: number;
```

- *Type:* `number`

---

##### `radiusFromLocationInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.Behavior.property.radiusFromLocationInput" id="cdktfprovideroktabehaviorpropertyradiusfromlocationinput"></a>

```typescript
public readonly radiusFromLocationInput: number;
```

- *Type:* `number`

---

##### `statusInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.Behavior.property.statusInput" id="cdktfprovideroktabehaviorpropertystatusinput"></a>

```typescript
public readonly statusInput: string;
```

- *Type:* `string`

---

##### `typeInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.Behavior.property.typeInput" id="cdktfprovideroktabehaviorpropertytypeinput"></a>

```typescript
public readonly typeInput: string;
```

- *Type:* `string`

---

##### `velocityInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.Behavior.property.velocityInput" id="cdktfprovideroktabehaviorpropertyvelocityinput"></a>

```typescript
public readonly velocityInput: number;
```

- *Type:* `number`

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.Behavior.property.id" id="cdktfprovideroktabehaviorpropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `locationGranularityType`<sup>Required</sup> <a name="@cdktf/provider-okta.Behavior.property.locationGranularityType" id="cdktfprovideroktabehaviorpropertylocationgranularitytype"></a>

```typescript
public readonly locationGranularityType: string;
```

- *Type:* `string`

---

##### `name`<sup>Required</sup> <a name="@cdktf/provider-okta.Behavior.property.name" id="cdktfprovideroktabehaviorpropertyname"></a>

```typescript
public readonly name: string;
```

- *Type:* `string`

---

##### `numberOfAuthentications`<sup>Required</sup> <a name="@cdktf/provider-okta.Behavior.property.numberOfAuthentications" id="cdktfprovideroktabehaviorpropertynumberofauthentications"></a>

```typescript
public readonly numberOfAuthentications: number;
```

- *Type:* `number`

---

##### `radiusFromLocation`<sup>Required</sup> <a name="@cdktf/provider-okta.Behavior.property.radiusFromLocation" id="cdktfprovideroktabehaviorpropertyradiusfromlocation"></a>

```typescript
public readonly radiusFromLocation: number;
```

- *Type:* `number`

---

##### `status`<sup>Required</sup> <a name="@cdktf/provider-okta.Behavior.property.status" id="cdktfprovideroktabehaviorpropertystatus"></a>

```typescript
public readonly status: string;
```

- *Type:* `string`

---

##### `type`<sup>Required</sup> <a name="@cdktf/provider-okta.Behavior.property.type" id="cdktfprovideroktabehaviorpropertytype"></a>

```typescript
public readonly type: string;
```

- *Type:* `string`

---

##### `velocity`<sup>Required</sup> <a name="@cdktf/provider-okta.Behavior.property.velocity" id="cdktfprovideroktabehaviorpropertyvelocity"></a>

```typescript
public readonly velocity: number;
```

- *Type:* `number`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktabehaviorpropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.Behavior.property.tfResourceType" id="cdktfprovideroktabehaviorpropertytfresourcetype"></a>

- *Type:* `string`

---

### BookmarkApp <a name="@cdktf/provider-okta.BookmarkApp" id="cdktfprovideroktabookmarkapp"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/r/bookmark_app okta_bookmark_app}.

#### Initializers <a name="@cdktf/provider-okta.BookmarkApp.Initializer" id="cdktfprovideroktabookmarkappinitializer"></a>

```typescript
import { BookmarkApp } from '@cdktf/provider-okta'

new BookmarkApp(scope: Construct, id: string, config: BookmarkAppConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktabookmarkappparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktabookmarkappparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktabookmarkappparameterconfig)<span title="Required">*</span> | [`@cdktf/provider-okta.BookmarkAppConfig`](#@cdktf/provider-okta.BookmarkAppConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.BookmarkApp.parameter.scope" id="cdktfprovideroktabookmarkappparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.BookmarkApp.parameter.id" id="cdktfprovideroktabookmarkappparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="@cdktf/provider-okta.BookmarkApp.parameter.config" id="cdktfprovideroktabookmarkappparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.BookmarkAppConfig`](#@cdktf/provider-okta.BookmarkAppConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`putTimeouts`](#cdktfprovideroktabookmarkappputtimeouts) | *No description.* |
| [`putUsers`](#cdktfprovideroktabookmarkappputusers) | *No description.* |
| [`resetAccessibilityErrorRedirectUrl`](#cdktfprovideroktabookmarkappresetaccessibilityerrorredirecturl) | *No description.* |
| [`resetAccessibilityLoginRedirectUrl`](#cdktfprovideroktabookmarkappresetaccessibilityloginredirecturl) | *No description.* |
| [`resetAccessibilitySelfService`](#cdktfprovideroktabookmarkappresetaccessibilityselfservice) | *No description.* |
| [`resetAdminNote`](#cdktfprovideroktabookmarkappresetadminnote) | *No description.* |
| [`resetAppLinksJson`](#cdktfprovideroktabookmarkappresetapplinksjson) | *No description.* |
| [`resetAutoSubmitToolbar`](#cdktfprovideroktabookmarkappresetautosubmittoolbar) | *No description.* |
| [`resetEnduserNote`](#cdktfprovideroktabookmarkappresetendusernote) | *No description.* |
| [`resetGroups`](#cdktfprovideroktabookmarkappresetgroups) | *No description.* |
| [`resetHideIos`](#cdktfprovideroktabookmarkappresethideios) | *No description.* |
| [`resetHideWeb`](#cdktfprovideroktabookmarkappresethideweb) | *No description.* |
| [`resetId`](#cdktfprovideroktabookmarkappresetid) | *No description.* |
| [`resetLogo`](#cdktfprovideroktabookmarkappresetlogo) | *No description.* |
| [`resetRequestIntegration`](#cdktfprovideroktabookmarkappresetrequestintegration) | *No description.* |
| [`resetSkipGroups`](#cdktfprovideroktabookmarkappresetskipgroups) | *No description.* |
| [`resetSkipUsers`](#cdktfprovideroktabookmarkappresetskipusers) | *No description.* |
| [`resetStatus`](#cdktfprovideroktabookmarkappresetstatus) | *No description.* |
| [`resetTimeouts`](#cdktfprovideroktabookmarkappresettimeouts) | *No description.* |
| [`resetUsers`](#cdktfprovideroktabookmarkappresetusers) | *No description.* |

---

##### `putTimeouts` <a name="@cdktf/provider-okta.BookmarkApp.putTimeouts" id="cdktfprovideroktabookmarkappputtimeouts"></a>

```typescript
public putTimeouts(value: BookmarkAppTimeouts)
```

###### `value`<sup>Required</sup> <a name="@cdktf/provider-okta.BookmarkApp.parameter.value" id="cdktfprovideroktabookmarkappparametervalue"></a>

- *Type:* [`@cdktf/provider-okta.BookmarkAppTimeouts`](#@cdktf/provider-okta.BookmarkAppTimeouts)

---

##### `putUsers` <a name="@cdktf/provider-okta.BookmarkApp.putUsers" id="cdktfprovideroktabookmarkappputusers"></a>

```typescript
public putUsers(value: IResolvable | BookmarkAppUsers[])
```

###### `value`<sup>Required</sup> <a name="@cdktf/provider-okta.BookmarkApp.parameter.value" id="cdktfprovideroktabookmarkappparametervalue"></a>

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable) | [`@cdktf/provider-okta.BookmarkAppUsers`](#@cdktf/provider-okta.BookmarkAppUsers)[]

---

##### `resetAccessibilityErrorRedirectUrl` <a name="@cdktf/provider-okta.BookmarkApp.resetAccessibilityErrorRedirectUrl" id="cdktfprovideroktabookmarkappresetaccessibilityerrorredirecturl"></a>

```typescript
public resetAccessibilityErrorRedirectUrl()
```

##### `resetAccessibilityLoginRedirectUrl` <a name="@cdktf/provider-okta.BookmarkApp.resetAccessibilityLoginRedirectUrl" id="cdktfprovideroktabookmarkappresetaccessibilityloginredirecturl"></a>

```typescript
public resetAccessibilityLoginRedirectUrl()
```

##### `resetAccessibilitySelfService` <a name="@cdktf/provider-okta.BookmarkApp.resetAccessibilitySelfService" id="cdktfprovideroktabookmarkappresetaccessibilityselfservice"></a>

```typescript
public resetAccessibilitySelfService()
```

##### `resetAdminNote` <a name="@cdktf/provider-okta.BookmarkApp.resetAdminNote" id="cdktfprovideroktabookmarkappresetadminnote"></a>

```typescript
public resetAdminNote()
```

##### `resetAppLinksJson` <a name="@cdktf/provider-okta.BookmarkApp.resetAppLinksJson" id="cdktfprovideroktabookmarkappresetapplinksjson"></a>

```typescript
public resetAppLinksJson()
```

##### `resetAutoSubmitToolbar` <a name="@cdktf/provider-okta.BookmarkApp.resetAutoSubmitToolbar" id="cdktfprovideroktabookmarkappresetautosubmittoolbar"></a>

```typescript
public resetAutoSubmitToolbar()
```

##### `resetEnduserNote` <a name="@cdktf/provider-okta.BookmarkApp.resetEnduserNote" id="cdktfprovideroktabookmarkappresetendusernote"></a>

```typescript
public resetEnduserNote()
```

##### `resetGroups` <a name="@cdktf/provider-okta.BookmarkApp.resetGroups" id="cdktfprovideroktabookmarkappresetgroups"></a>

```typescript
public resetGroups()
```

##### `resetHideIos` <a name="@cdktf/provider-okta.BookmarkApp.resetHideIos" id="cdktfprovideroktabookmarkappresethideios"></a>

```typescript
public resetHideIos()
```

##### `resetHideWeb` <a name="@cdktf/provider-okta.BookmarkApp.resetHideWeb" id="cdktfprovideroktabookmarkappresethideweb"></a>

```typescript
public resetHideWeb()
```

##### `resetId` <a name="@cdktf/provider-okta.BookmarkApp.resetId" id="cdktfprovideroktabookmarkappresetid"></a>

```typescript
public resetId()
```

##### `resetLogo` <a name="@cdktf/provider-okta.BookmarkApp.resetLogo" id="cdktfprovideroktabookmarkappresetlogo"></a>

```typescript
public resetLogo()
```

##### `resetRequestIntegration` <a name="@cdktf/provider-okta.BookmarkApp.resetRequestIntegration" id="cdktfprovideroktabookmarkappresetrequestintegration"></a>

```typescript
public resetRequestIntegration()
```

##### `resetSkipGroups` <a name="@cdktf/provider-okta.BookmarkApp.resetSkipGroups" id="cdktfprovideroktabookmarkappresetskipgroups"></a>

```typescript
public resetSkipGroups()
```

##### `resetSkipUsers` <a name="@cdktf/provider-okta.BookmarkApp.resetSkipUsers" id="cdktfprovideroktabookmarkappresetskipusers"></a>

```typescript
public resetSkipUsers()
```

##### `resetStatus` <a name="@cdktf/provider-okta.BookmarkApp.resetStatus" id="cdktfprovideroktabookmarkappresetstatus"></a>

```typescript
public resetStatus()
```

##### `resetTimeouts` <a name="@cdktf/provider-okta.BookmarkApp.resetTimeouts" id="cdktfprovideroktabookmarkappresettimeouts"></a>

```typescript
public resetTimeouts()
```

##### `resetUsers` <a name="@cdktf/provider-okta.BookmarkApp.resetUsers" id="cdktfprovideroktabookmarkappresetusers"></a>

```typescript
public resetUsers()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`logoUrl`](#cdktfprovideroktabookmarkapppropertylogourl)<span title="Required">*</span> | `string` | *No description.* |
| [`name`](#cdktfprovideroktabookmarkapppropertyname)<span title="Required">*</span> | `string` | *No description.* |
| [`signOnMode`](#cdktfprovideroktabookmarkapppropertysignonmode)<span title="Required">*</span> | `string` | *No description.* |
| [`timeouts`](#cdktfprovideroktabookmarkapppropertytimeouts)<span title="Required">*</span> | [`@cdktf/provider-okta.BookmarkAppTimeoutsOutputReference`](#@cdktf/provider-okta.BookmarkAppTimeoutsOutputReference) | *No description.* |
| [`users`](#cdktfprovideroktabookmarkapppropertyusers)<span title="Required">*</span> | [`@cdktf/provider-okta.BookmarkAppUsersList`](#@cdktf/provider-okta.BookmarkAppUsersList) | *No description.* |
| [`accessibilityErrorRedirectUrlInput`](#cdktfprovideroktabookmarkapppropertyaccessibilityerrorredirecturlinput) | `string` | *No description.* |
| [`accessibilityLoginRedirectUrlInput`](#cdktfprovideroktabookmarkapppropertyaccessibilityloginredirecturlinput) | `string` | *No description.* |
| [`accessibilitySelfServiceInput`](#cdktfprovideroktabookmarkapppropertyaccessibilityselfserviceinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`adminNoteInput`](#cdktfprovideroktabookmarkapppropertyadminnoteinput) | `string` | *No description.* |
| [`appLinksJsonInput`](#cdktfprovideroktabookmarkapppropertyapplinksjsoninput) | `string` | *No description.* |
| [`autoSubmitToolbarInput`](#cdktfprovideroktabookmarkapppropertyautosubmittoolbarinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`enduserNoteInput`](#cdktfprovideroktabookmarkapppropertyendusernoteinput) | `string` | *No description.* |
| [`groupsInput`](#cdktfprovideroktabookmarkapppropertygroupsinput) | `string`[] | *No description.* |
| [`hideIosInput`](#cdktfprovideroktabookmarkapppropertyhideiosinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`hideWebInput`](#cdktfprovideroktabookmarkapppropertyhidewebinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`idInput`](#cdktfprovideroktabookmarkapppropertyidinput) | `string` | *No description.* |
| [`labelInput`](#cdktfprovideroktabookmarkapppropertylabelinput) | `string` | *No description.* |
| [`logoInput`](#cdktfprovideroktabookmarkapppropertylogoinput) | `string` | *No description.* |
| [`requestIntegrationInput`](#cdktfprovideroktabookmarkapppropertyrequestintegrationinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`skipGroupsInput`](#cdktfprovideroktabookmarkapppropertyskipgroupsinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`skipUsersInput`](#cdktfprovideroktabookmarkapppropertyskipusersinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`statusInput`](#cdktfprovideroktabookmarkapppropertystatusinput) | `string` | *No description.* |
| [`timeoutsInput`](#cdktfprovideroktabookmarkapppropertytimeoutsinput) | [`cdktf.IResolvable`](#cdktf.IResolvable) \| [`@cdktf/provider-okta.BookmarkAppTimeouts`](#@cdktf/provider-okta.BookmarkAppTimeouts) | *No description.* |
| [`urlInput`](#cdktfprovideroktabookmarkapppropertyurlinput) | `string` | *No description.* |
| [`usersInput`](#cdktfprovideroktabookmarkapppropertyusersinput) | [`cdktf.IResolvable`](#cdktf.IResolvable) \| [`@cdktf/provider-okta.BookmarkAppUsers`](#@cdktf/provider-okta.BookmarkAppUsers)[] | *No description.* |
| [`accessibilityErrorRedirectUrl`](#cdktfprovideroktabookmarkapppropertyaccessibilityerrorredirecturl)<span title="Required">*</span> | `string` | *No description.* |
| [`accessibilityLoginRedirectUrl`](#cdktfprovideroktabookmarkapppropertyaccessibilityloginredirecturl)<span title="Required">*</span> | `string` | *No description.* |
| [`accessibilitySelfService`](#cdktfprovideroktabookmarkapppropertyaccessibilityselfservice)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`adminNote`](#cdktfprovideroktabookmarkapppropertyadminnote)<span title="Required">*</span> | `string` | *No description.* |
| [`appLinksJson`](#cdktfprovideroktabookmarkapppropertyapplinksjson)<span title="Required">*</span> | `string` | *No description.* |
| [`autoSubmitToolbar`](#cdktfprovideroktabookmarkapppropertyautosubmittoolbar)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`enduserNote`](#cdktfprovideroktabookmarkapppropertyendusernote)<span title="Required">*</span> | `string` | *No description.* |
| [`groups`](#cdktfprovideroktabookmarkapppropertygroups)<span title="Required">*</span> | `string`[] | *No description.* |
| [`hideIos`](#cdktfprovideroktabookmarkapppropertyhideios)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`hideWeb`](#cdktfprovideroktabookmarkapppropertyhideweb)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`id`](#cdktfprovideroktabookmarkapppropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`label`](#cdktfprovideroktabookmarkapppropertylabel)<span title="Required">*</span> | `string` | *No description.* |
| [`logo`](#cdktfprovideroktabookmarkapppropertylogo)<span title="Required">*</span> | `string` | *No description.* |
| [`requestIntegration`](#cdktfprovideroktabookmarkapppropertyrequestintegration)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`skipGroups`](#cdktfprovideroktabookmarkapppropertyskipgroups)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`skipUsers`](#cdktfprovideroktabookmarkapppropertyskipusers)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`status`](#cdktfprovideroktabookmarkapppropertystatus)<span title="Required">*</span> | `string` | *No description.* |
| [`url`](#cdktfprovideroktabookmarkapppropertyurl)<span title="Required">*</span> | `string` | *No description.* |

---

##### `logoUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.BookmarkApp.property.logoUrl" id="cdktfprovideroktabookmarkapppropertylogourl"></a>

```typescript
public readonly logoUrl: string;
```

- *Type:* `string`

---

##### `name`<sup>Required</sup> <a name="@cdktf/provider-okta.BookmarkApp.property.name" id="cdktfprovideroktabookmarkapppropertyname"></a>

```typescript
public readonly name: string;
```

- *Type:* `string`

---

##### `signOnMode`<sup>Required</sup> <a name="@cdktf/provider-okta.BookmarkApp.property.signOnMode" id="cdktfprovideroktabookmarkapppropertysignonmode"></a>

```typescript
public readonly signOnMode: string;
```

- *Type:* `string`

---

##### `timeouts`<sup>Required</sup> <a name="@cdktf/provider-okta.BookmarkApp.property.timeouts" id="cdktfprovideroktabookmarkapppropertytimeouts"></a>

```typescript
public readonly timeouts: BookmarkAppTimeoutsOutputReference;
```

- *Type:* [`@cdktf/provider-okta.BookmarkAppTimeoutsOutputReference`](#@cdktf/provider-okta.BookmarkAppTimeoutsOutputReference)

---

##### `users`<sup>Required</sup> <a name="@cdktf/provider-okta.BookmarkApp.property.users" id="cdktfprovideroktabookmarkapppropertyusers"></a>

```typescript
public readonly users: BookmarkAppUsersList;
```

- *Type:* [`@cdktf/provider-okta.BookmarkAppUsersList`](#@cdktf/provider-okta.BookmarkAppUsersList)

---

##### `accessibilityErrorRedirectUrlInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.BookmarkApp.property.accessibilityErrorRedirectUrlInput" id="cdktfprovideroktabookmarkapppropertyaccessibilityerrorredirecturlinput"></a>

```typescript
public readonly accessibilityErrorRedirectUrlInput: string;
```

- *Type:* `string`

---

##### `accessibilityLoginRedirectUrlInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.BookmarkApp.property.accessibilityLoginRedirectUrlInput" id="cdktfprovideroktabookmarkapppropertyaccessibilityloginredirecturlinput"></a>

```typescript
public readonly accessibilityLoginRedirectUrlInput: string;
```

- *Type:* `string`

---

##### `accessibilitySelfServiceInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.BookmarkApp.property.accessibilitySelfServiceInput" id="cdktfprovideroktabookmarkapppropertyaccessibilityselfserviceinput"></a>

```typescript
public readonly accessibilitySelfServiceInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `adminNoteInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.BookmarkApp.property.adminNoteInput" id="cdktfprovideroktabookmarkapppropertyadminnoteinput"></a>

```typescript
public readonly adminNoteInput: string;
```

- *Type:* `string`

---

##### `appLinksJsonInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.BookmarkApp.property.appLinksJsonInput" id="cdktfprovideroktabookmarkapppropertyapplinksjsoninput"></a>

```typescript
public readonly appLinksJsonInput: string;
```

- *Type:* `string`

---

##### `autoSubmitToolbarInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.BookmarkApp.property.autoSubmitToolbarInput" id="cdktfprovideroktabookmarkapppropertyautosubmittoolbarinput"></a>

```typescript
public readonly autoSubmitToolbarInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `enduserNoteInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.BookmarkApp.property.enduserNoteInput" id="cdktfprovideroktabookmarkapppropertyendusernoteinput"></a>

```typescript
public readonly enduserNoteInput: string;
```

- *Type:* `string`

---

##### `groupsInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.BookmarkApp.property.groupsInput" id="cdktfprovideroktabookmarkapppropertygroupsinput"></a>

```typescript
public readonly groupsInput: string[];
```

- *Type:* `string`[]

---

##### `hideIosInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.BookmarkApp.property.hideIosInput" id="cdktfprovideroktabookmarkapppropertyhideiosinput"></a>

```typescript
public readonly hideIosInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `hideWebInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.BookmarkApp.property.hideWebInput" id="cdktfprovideroktabookmarkapppropertyhidewebinput"></a>

```typescript
public readonly hideWebInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.BookmarkApp.property.idInput" id="cdktfprovideroktabookmarkapppropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `labelInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.BookmarkApp.property.labelInput" id="cdktfprovideroktabookmarkapppropertylabelinput"></a>

```typescript
public readonly labelInput: string;
```

- *Type:* `string`

---

##### `logoInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.BookmarkApp.property.logoInput" id="cdktfprovideroktabookmarkapppropertylogoinput"></a>

```typescript
public readonly logoInput: string;
```

- *Type:* `string`

---

##### `requestIntegrationInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.BookmarkApp.property.requestIntegrationInput" id="cdktfprovideroktabookmarkapppropertyrequestintegrationinput"></a>

```typescript
public readonly requestIntegrationInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `skipGroupsInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.BookmarkApp.property.skipGroupsInput" id="cdktfprovideroktabookmarkapppropertyskipgroupsinput"></a>

```typescript
public readonly skipGroupsInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `skipUsersInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.BookmarkApp.property.skipUsersInput" id="cdktfprovideroktabookmarkapppropertyskipusersinput"></a>

```typescript
public readonly skipUsersInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `statusInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.BookmarkApp.property.statusInput" id="cdktfprovideroktabookmarkapppropertystatusinput"></a>

```typescript
public readonly statusInput: string;
```

- *Type:* `string`

---

##### `timeoutsInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.BookmarkApp.property.timeoutsInput" id="cdktfprovideroktabookmarkapppropertytimeoutsinput"></a>

```typescript
public readonly timeoutsInput: IResolvable | BookmarkAppTimeouts;
```

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable) | [`@cdktf/provider-okta.BookmarkAppTimeouts`](#@cdktf/provider-okta.BookmarkAppTimeouts)

---

##### `urlInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.BookmarkApp.property.urlInput" id="cdktfprovideroktabookmarkapppropertyurlinput"></a>

```typescript
public readonly urlInput: string;
```

- *Type:* `string`

---

##### `usersInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.BookmarkApp.property.usersInput" id="cdktfprovideroktabookmarkapppropertyusersinput"></a>

```typescript
public readonly usersInput: IResolvable | BookmarkAppUsers[];
```

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable) | [`@cdktf/provider-okta.BookmarkAppUsers`](#@cdktf/provider-okta.BookmarkAppUsers)[]

---

##### `accessibilityErrorRedirectUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.BookmarkApp.property.accessibilityErrorRedirectUrl" id="cdktfprovideroktabookmarkapppropertyaccessibilityerrorredirecturl"></a>

```typescript
public readonly accessibilityErrorRedirectUrl: string;
```

- *Type:* `string`

---

##### `accessibilityLoginRedirectUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.BookmarkApp.property.accessibilityLoginRedirectUrl" id="cdktfprovideroktabookmarkapppropertyaccessibilityloginredirecturl"></a>

```typescript
public readonly accessibilityLoginRedirectUrl: string;
```

- *Type:* `string`

---

##### `accessibilitySelfService`<sup>Required</sup> <a name="@cdktf/provider-okta.BookmarkApp.property.accessibilitySelfService" id="cdktfprovideroktabookmarkapppropertyaccessibilityselfservice"></a>

```typescript
public readonly accessibilitySelfService: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `adminNote`<sup>Required</sup> <a name="@cdktf/provider-okta.BookmarkApp.property.adminNote" id="cdktfprovideroktabookmarkapppropertyadminnote"></a>

```typescript
public readonly adminNote: string;
```

- *Type:* `string`

---

##### `appLinksJson`<sup>Required</sup> <a name="@cdktf/provider-okta.BookmarkApp.property.appLinksJson" id="cdktfprovideroktabookmarkapppropertyapplinksjson"></a>

```typescript
public readonly appLinksJson: string;
```

- *Type:* `string`

---

##### `autoSubmitToolbar`<sup>Required</sup> <a name="@cdktf/provider-okta.BookmarkApp.property.autoSubmitToolbar" id="cdktfprovideroktabookmarkapppropertyautosubmittoolbar"></a>

```typescript
public readonly autoSubmitToolbar: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `enduserNote`<sup>Required</sup> <a name="@cdktf/provider-okta.BookmarkApp.property.enduserNote" id="cdktfprovideroktabookmarkapppropertyendusernote"></a>

```typescript
public readonly enduserNote: string;
```

- *Type:* `string`

---

##### `groups`<sup>Required</sup> <a name="@cdktf/provider-okta.BookmarkApp.property.groups" id="cdktfprovideroktabookmarkapppropertygroups"></a>

```typescript
public readonly groups: string[];
```

- *Type:* `string`[]

---

##### `hideIos`<sup>Required</sup> <a name="@cdktf/provider-okta.BookmarkApp.property.hideIos" id="cdktfprovideroktabookmarkapppropertyhideios"></a>

```typescript
public readonly hideIos: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `hideWeb`<sup>Required</sup> <a name="@cdktf/provider-okta.BookmarkApp.property.hideWeb" id="cdktfprovideroktabookmarkapppropertyhideweb"></a>

```typescript
public readonly hideWeb: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.BookmarkApp.property.id" id="cdktfprovideroktabookmarkapppropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `label`<sup>Required</sup> <a name="@cdktf/provider-okta.BookmarkApp.property.label" id="cdktfprovideroktabookmarkapppropertylabel"></a>

```typescript
public readonly label: string;
```

- *Type:* `string`

---

##### `logo`<sup>Required</sup> <a name="@cdktf/provider-okta.BookmarkApp.property.logo" id="cdktfprovideroktabookmarkapppropertylogo"></a>

```typescript
public readonly logo: string;
```

- *Type:* `string`

---

##### `requestIntegration`<sup>Required</sup> <a name="@cdktf/provider-okta.BookmarkApp.property.requestIntegration" id="cdktfprovideroktabookmarkapppropertyrequestintegration"></a>

```typescript
public readonly requestIntegration: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `skipGroups`<sup>Required</sup> <a name="@cdktf/provider-okta.BookmarkApp.property.skipGroups" id="cdktfprovideroktabookmarkapppropertyskipgroups"></a>

```typescript
public readonly skipGroups: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `skipUsers`<sup>Required</sup> <a name="@cdktf/provider-okta.BookmarkApp.property.skipUsers" id="cdktfprovideroktabookmarkapppropertyskipusers"></a>

```typescript
public readonly skipUsers: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `status`<sup>Required</sup> <a name="@cdktf/provider-okta.BookmarkApp.property.status" id="cdktfprovideroktabookmarkapppropertystatus"></a>

```typescript
public readonly status: string;
```

- *Type:* `string`

---

##### `url`<sup>Required</sup> <a name="@cdktf/provider-okta.BookmarkApp.property.url" id="cdktfprovideroktabookmarkapppropertyurl"></a>

```typescript
public readonly url: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktabookmarkapppropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.BookmarkApp.property.tfResourceType" id="cdktfprovideroktabookmarkapppropertytfresourcetype"></a>

- *Type:* `string`

---

### Brand <a name="@cdktf/provider-okta.Brand" id="cdktfprovideroktabrand"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/r/brand okta_brand}.

#### Initializers <a name="@cdktf/provider-okta.Brand.Initializer" id="cdktfprovideroktabrandinitializer"></a>

```typescript
import { Brand } from '@cdktf/provider-okta'

new Brand(scope: Construct, id: string, config?: BrandConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktabrandparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktabrandparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktabrandparameterconfig) | [`@cdktf/provider-okta.BrandConfig`](#@cdktf/provider-okta.BrandConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.Brand.parameter.scope" id="cdktfprovideroktabrandparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.Brand.parameter.id" id="cdktfprovideroktabrandparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Optional</sup> <a name="@cdktf/provider-okta.Brand.parameter.config" id="cdktfprovideroktabrandparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.BrandConfig`](#@cdktf/provider-okta.BrandConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`resetAgreeToCustomPrivacyPolicy`](#cdktfprovideroktabrandresetagreetocustomprivacypolicy) | *No description.* |
| [`resetBrandId`](#cdktfprovideroktabrandresetbrandid) | *No description.* |
| [`resetCustomPrivacyPolicyUrl`](#cdktfprovideroktabrandresetcustomprivacypolicyurl) | *No description.* |
| [`resetRemovePoweredByOkta`](#cdktfprovideroktabrandresetremovepoweredbyokta) | *No description.* |

---

##### `resetAgreeToCustomPrivacyPolicy` <a name="@cdktf/provider-okta.Brand.resetAgreeToCustomPrivacyPolicy" id="cdktfprovideroktabrandresetagreetocustomprivacypolicy"></a>

```typescript
public resetAgreeToCustomPrivacyPolicy()
```

##### `resetBrandId` <a name="@cdktf/provider-okta.Brand.resetBrandId" id="cdktfprovideroktabrandresetbrandid"></a>

```typescript
public resetBrandId()
```

##### `resetCustomPrivacyPolicyUrl` <a name="@cdktf/provider-okta.Brand.resetCustomPrivacyPolicyUrl" id="cdktfprovideroktabrandresetcustomprivacypolicyurl"></a>

```typescript
public resetCustomPrivacyPolicyUrl()
```

##### `resetRemovePoweredByOkta` <a name="@cdktf/provider-okta.Brand.resetRemovePoweredByOkta" id="cdktfprovideroktabrandresetremovepoweredbyokta"></a>

```typescript
public resetRemovePoweredByOkta()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`id`](#cdktfprovideroktabrandpropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`links`](#cdktfprovideroktabrandpropertylinks)<span title="Required">*</span> | `string` | *No description.* |
| [`agreeToCustomPrivacyPolicyInput`](#cdktfprovideroktabrandpropertyagreetocustomprivacypolicyinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`brandIdInput`](#cdktfprovideroktabrandpropertybrandidinput) | `string` | *No description.* |
| [`customPrivacyPolicyUrlInput`](#cdktfprovideroktabrandpropertycustomprivacypolicyurlinput) | `string` | *No description.* |
| [`removePoweredByOktaInput`](#cdktfprovideroktabrandpropertyremovepoweredbyoktainput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`agreeToCustomPrivacyPolicy`](#cdktfprovideroktabrandpropertyagreetocustomprivacypolicy)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`brandId`](#cdktfprovideroktabrandpropertybrandid)<span title="Required">*</span> | `string` | *No description.* |
| [`customPrivacyPolicyUrl`](#cdktfprovideroktabrandpropertycustomprivacypolicyurl)<span title="Required">*</span> | `string` | *No description.* |
| [`removePoweredByOkta`](#cdktfprovideroktabrandpropertyremovepoweredbyokta)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.Brand.property.id" id="cdktfprovideroktabrandpropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `links`<sup>Required</sup> <a name="@cdktf/provider-okta.Brand.property.links" id="cdktfprovideroktabrandpropertylinks"></a>

```typescript
public readonly links: string;
```

- *Type:* `string`

---

##### `agreeToCustomPrivacyPolicyInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.Brand.property.agreeToCustomPrivacyPolicyInput" id="cdktfprovideroktabrandpropertyagreetocustomprivacypolicyinput"></a>

```typescript
public readonly agreeToCustomPrivacyPolicyInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `brandIdInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.Brand.property.brandIdInput" id="cdktfprovideroktabrandpropertybrandidinput"></a>

```typescript
public readonly brandIdInput: string;
```

- *Type:* `string`

---

##### `customPrivacyPolicyUrlInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.Brand.property.customPrivacyPolicyUrlInput" id="cdktfprovideroktabrandpropertycustomprivacypolicyurlinput"></a>

```typescript
public readonly customPrivacyPolicyUrlInput: string;
```

- *Type:* `string`

---

##### `removePoweredByOktaInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.Brand.property.removePoweredByOktaInput" id="cdktfprovideroktabrandpropertyremovepoweredbyoktainput"></a>

```typescript
public readonly removePoweredByOktaInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `agreeToCustomPrivacyPolicy`<sup>Required</sup> <a name="@cdktf/provider-okta.Brand.property.agreeToCustomPrivacyPolicy" id="cdktfprovideroktabrandpropertyagreetocustomprivacypolicy"></a>

```typescript
public readonly agreeToCustomPrivacyPolicy: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `brandId`<sup>Required</sup> <a name="@cdktf/provider-okta.Brand.property.brandId" id="cdktfprovideroktabrandpropertybrandid"></a>

```typescript
public readonly brandId: string;
```

- *Type:* `string`

---

##### `customPrivacyPolicyUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.Brand.property.customPrivacyPolicyUrl" id="cdktfprovideroktabrandpropertycustomprivacypolicyurl"></a>

```typescript
public readonly customPrivacyPolicyUrl: string;
```

- *Type:* `string`

---

##### `removePoweredByOkta`<sup>Required</sup> <a name="@cdktf/provider-okta.Brand.property.removePoweredByOkta" id="cdktfprovideroktabrandpropertyremovepoweredbyokta"></a>

```typescript
public readonly removePoweredByOkta: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktabrandpropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.Brand.property.tfResourceType" id="cdktfprovideroktabrandpropertytfresourcetype"></a>

- *Type:* `string`

---

### Captcha <a name="@cdktf/provider-okta.Captcha" id="cdktfprovideroktacaptcha"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/r/captcha okta_captcha}.

#### Initializers <a name="@cdktf/provider-okta.Captcha.Initializer" id="cdktfprovideroktacaptchainitializer"></a>

```typescript
import { Captcha } from '@cdktf/provider-okta'

new Captcha(scope: Construct, id: string, config: CaptchaConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktacaptchaparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktacaptchaparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktacaptchaparameterconfig)<span title="Required">*</span> | [`@cdktf/provider-okta.CaptchaConfig`](#@cdktf/provider-okta.CaptchaConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.Captcha.parameter.scope" id="cdktfprovideroktacaptchaparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.Captcha.parameter.id" id="cdktfprovideroktacaptchaparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="@cdktf/provider-okta.Captcha.parameter.config" id="cdktfprovideroktacaptchaparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.CaptchaConfig`](#@cdktf/provider-okta.CaptchaConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`resetId`](#cdktfprovideroktacaptcharesetid) | *No description.* |

---

##### `resetId` <a name="@cdktf/provider-okta.Captcha.resetId" id="cdktfprovideroktacaptcharesetid"></a>

```typescript
public resetId()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`idInput`](#cdktfprovideroktacaptchapropertyidinput) | `string` | *No description.* |
| [`nameInput`](#cdktfprovideroktacaptchapropertynameinput) | `string` | *No description.* |
| [`secretKeyInput`](#cdktfprovideroktacaptchapropertysecretkeyinput) | `string` | *No description.* |
| [`siteKeyInput`](#cdktfprovideroktacaptchapropertysitekeyinput) | `string` | *No description.* |
| [`typeInput`](#cdktfprovideroktacaptchapropertytypeinput) | `string` | *No description.* |
| [`id`](#cdktfprovideroktacaptchapropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`name`](#cdktfprovideroktacaptchapropertyname)<span title="Required">*</span> | `string` | *No description.* |
| [`secretKey`](#cdktfprovideroktacaptchapropertysecretkey)<span title="Required">*</span> | `string` | *No description.* |
| [`siteKey`](#cdktfprovideroktacaptchapropertysitekey)<span title="Required">*</span> | `string` | *No description.* |
| [`type`](#cdktfprovideroktacaptchapropertytype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.Captcha.property.idInput" id="cdktfprovideroktacaptchapropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `nameInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.Captcha.property.nameInput" id="cdktfprovideroktacaptchapropertynameinput"></a>

```typescript
public readonly nameInput: string;
```

- *Type:* `string`

---

##### `secretKeyInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.Captcha.property.secretKeyInput" id="cdktfprovideroktacaptchapropertysecretkeyinput"></a>

```typescript
public readonly secretKeyInput: string;
```

- *Type:* `string`

---

##### `siteKeyInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.Captcha.property.siteKeyInput" id="cdktfprovideroktacaptchapropertysitekeyinput"></a>

```typescript
public readonly siteKeyInput: string;
```

- *Type:* `string`

---

##### `typeInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.Captcha.property.typeInput" id="cdktfprovideroktacaptchapropertytypeinput"></a>

```typescript
public readonly typeInput: string;
```

- *Type:* `string`

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.Captcha.property.id" id="cdktfprovideroktacaptchapropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `name`<sup>Required</sup> <a name="@cdktf/provider-okta.Captcha.property.name" id="cdktfprovideroktacaptchapropertyname"></a>

```typescript
public readonly name: string;
```

- *Type:* `string`

---

##### `secretKey`<sup>Required</sup> <a name="@cdktf/provider-okta.Captcha.property.secretKey" id="cdktfprovideroktacaptchapropertysecretkey"></a>

```typescript
public readonly secretKey: string;
```

- *Type:* `string`

---

##### `siteKey`<sup>Required</sup> <a name="@cdktf/provider-okta.Captcha.property.siteKey" id="cdktfprovideroktacaptchapropertysitekey"></a>

```typescript
public readonly siteKey: string;
```

- *Type:* `string`

---

##### `type`<sup>Required</sup> <a name="@cdktf/provider-okta.Captcha.property.type" id="cdktfprovideroktacaptchapropertytype"></a>

```typescript
public readonly type: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktacaptchapropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.Captcha.property.tfResourceType" id="cdktfprovideroktacaptchapropertytfresourcetype"></a>

- *Type:* `string`

---

### CaptchaOrgWideSettings <a name="@cdktf/provider-okta.CaptchaOrgWideSettings" id="cdktfprovideroktacaptchaorgwidesettings"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/r/captcha_org_wide_settings okta_captcha_org_wide_settings}.

#### Initializers <a name="@cdktf/provider-okta.CaptchaOrgWideSettings.Initializer" id="cdktfprovideroktacaptchaorgwidesettingsinitializer"></a>

```typescript
import { CaptchaOrgWideSettings } from '@cdktf/provider-okta'

new CaptchaOrgWideSettings(scope: Construct, id: string, config?: CaptchaOrgWideSettingsConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktacaptchaorgwidesettingsparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktacaptchaorgwidesettingsparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktacaptchaorgwidesettingsparameterconfig) | [`@cdktf/provider-okta.CaptchaOrgWideSettingsConfig`](#@cdktf/provider-okta.CaptchaOrgWideSettingsConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.CaptchaOrgWideSettings.parameter.scope" id="cdktfprovideroktacaptchaorgwidesettingsparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.CaptchaOrgWideSettings.parameter.id" id="cdktfprovideroktacaptchaorgwidesettingsparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Optional</sup> <a name="@cdktf/provider-okta.CaptchaOrgWideSettings.parameter.config" id="cdktfprovideroktacaptchaorgwidesettingsparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.CaptchaOrgWideSettingsConfig`](#@cdktf/provider-okta.CaptchaOrgWideSettingsConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`resetCaptchaId`](#cdktfprovideroktacaptchaorgwidesettingsresetcaptchaid) | *No description.* |
| [`resetEnabledFor`](#cdktfprovideroktacaptchaorgwidesettingsresetenabledfor) | *No description.* |
| [`resetId`](#cdktfprovideroktacaptchaorgwidesettingsresetid) | *No description.* |

---

##### `resetCaptchaId` <a name="@cdktf/provider-okta.CaptchaOrgWideSettings.resetCaptchaId" id="cdktfprovideroktacaptchaorgwidesettingsresetcaptchaid"></a>

```typescript
public resetCaptchaId()
```

##### `resetEnabledFor` <a name="@cdktf/provider-okta.CaptchaOrgWideSettings.resetEnabledFor" id="cdktfprovideroktacaptchaorgwidesettingsresetenabledfor"></a>

```typescript
public resetEnabledFor()
```

##### `resetId` <a name="@cdktf/provider-okta.CaptchaOrgWideSettings.resetId" id="cdktfprovideroktacaptchaorgwidesettingsresetid"></a>

```typescript
public resetId()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`captchaIdInput`](#cdktfprovideroktacaptchaorgwidesettingspropertycaptchaidinput) | `string` | *No description.* |
| [`enabledForInput`](#cdktfprovideroktacaptchaorgwidesettingspropertyenabledforinput) | `string`[] | *No description.* |
| [`idInput`](#cdktfprovideroktacaptchaorgwidesettingspropertyidinput) | `string` | *No description.* |
| [`captchaId`](#cdktfprovideroktacaptchaorgwidesettingspropertycaptchaid)<span title="Required">*</span> | `string` | *No description.* |
| [`enabledFor`](#cdktfprovideroktacaptchaorgwidesettingspropertyenabledfor)<span title="Required">*</span> | `string`[] | *No description.* |
| [`id`](#cdktfprovideroktacaptchaorgwidesettingspropertyid)<span title="Required">*</span> | `string` | *No description.* |

---

##### `captchaIdInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.CaptchaOrgWideSettings.property.captchaIdInput" id="cdktfprovideroktacaptchaorgwidesettingspropertycaptchaidinput"></a>

```typescript
public readonly captchaIdInput: string;
```

- *Type:* `string`

---

##### `enabledForInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.CaptchaOrgWideSettings.property.enabledForInput" id="cdktfprovideroktacaptchaorgwidesettingspropertyenabledforinput"></a>

```typescript
public readonly enabledForInput: string[];
```

- *Type:* `string`[]

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.CaptchaOrgWideSettings.property.idInput" id="cdktfprovideroktacaptchaorgwidesettingspropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `captchaId`<sup>Required</sup> <a name="@cdktf/provider-okta.CaptchaOrgWideSettings.property.captchaId" id="cdktfprovideroktacaptchaorgwidesettingspropertycaptchaid"></a>

```typescript
public readonly captchaId: string;
```

- *Type:* `string`

---

##### `enabledFor`<sup>Required</sup> <a name="@cdktf/provider-okta.CaptchaOrgWideSettings.property.enabledFor" id="cdktfprovideroktacaptchaorgwidesettingspropertyenabledfor"></a>

```typescript
public readonly enabledFor: string[];
```

- *Type:* `string`[]

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.CaptchaOrgWideSettings.property.id" id="cdktfprovideroktacaptchaorgwidesettingspropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktacaptchaorgwidesettingspropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.CaptchaOrgWideSettings.property.tfResourceType" id="cdktfprovideroktacaptchaorgwidesettingspropertytfresourcetype"></a>

- *Type:* `string`

---

### DataOktaApp <a name="@cdktf/provider-okta.DataOktaApp" id="cdktfprovideroktadataoktaapp"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/d/app okta_app}.

#### Initializers <a name="@cdktf/provider-okta.DataOktaApp.Initializer" id="cdktfprovideroktadataoktaappinitializer"></a>

```typescript
import { DataOktaApp } from '@cdktf/provider-okta'

new DataOktaApp(scope: Construct, id: string, config?: DataOktaAppConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktadataoktaappparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktadataoktaappparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktadataoktaappparameterconfig) | [`@cdktf/provider-okta.DataOktaAppConfig`](#@cdktf/provider-okta.DataOktaAppConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaApp.parameter.scope" id="cdktfprovideroktadataoktaappparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaApp.parameter.id" id="cdktfprovideroktadataoktaappparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaApp.parameter.config" id="cdktfprovideroktadataoktaappparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.DataOktaAppConfig`](#@cdktf/provider-okta.DataOktaAppConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`resetActiveOnly`](#cdktfprovideroktadataoktaappresetactiveonly) | *No description.* |
| [`resetId`](#cdktfprovideroktadataoktaappresetid) | *No description.* |
| [`resetLabel`](#cdktfprovideroktadataoktaappresetlabel) | *No description.* |
| [`resetLabelPrefix`](#cdktfprovideroktadataoktaappresetlabelprefix) | *No description.* |
| [`resetSkipGroups`](#cdktfprovideroktadataoktaappresetskipgroups) | *No description.* |
| [`resetSkipUsers`](#cdktfprovideroktadataoktaappresetskipusers) | *No description.* |

---

##### `resetActiveOnly` <a name="@cdktf/provider-okta.DataOktaApp.resetActiveOnly" id="cdktfprovideroktadataoktaappresetactiveonly"></a>

```typescript
public resetActiveOnly()
```

##### `resetId` <a name="@cdktf/provider-okta.DataOktaApp.resetId" id="cdktfprovideroktadataoktaappresetid"></a>

```typescript
public resetId()
```

##### `resetLabel` <a name="@cdktf/provider-okta.DataOktaApp.resetLabel" id="cdktfprovideroktadataoktaappresetlabel"></a>

```typescript
public resetLabel()
```

##### `resetLabelPrefix` <a name="@cdktf/provider-okta.DataOktaApp.resetLabelPrefix" id="cdktfprovideroktadataoktaappresetlabelprefix"></a>

```typescript
public resetLabelPrefix()
```

##### `resetSkipGroups` <a name="@cdktf/provider-okta.DataOktaApp.resetSkipGroups" id="cdktfprovideroktadataoktaappresetskipgroups"></a>

```typescript
public resetSkipGroups()
```

##### `resetSkipUsers` <a name="@cdktf/provider-okta.DataOktaApp.resetSkipUsers" id="cdktfprovideroktadataoktaappresetskipusers"></a>

```typescript
public resetSkipUsers()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`groups`](#cdktfprovideroktadataoktaapppropertygroups)<span title="Required">*</span> | `string`[] | *No description.* |
| [`links`](#cdktfprovideroktadataoktaapppropertylinks)<span title="Required">*</span> | `string` | *No description.* |
| [`name`](#cdktfprovideroktadataoktaapppropertyname)<span title="Required">*</span> | `string` | *No description.* |
| [`status`](#cdktfprovideroktadataoktaapppropertystatus)<span title="Required">*</span> | `string` | *No description.* |
| [`users`](#cdktfprovideroktadataoktaapppropertyusers)<span title="Required">*</span> | `string`[] | *No description.* |
| [`activeOnlyInput`](#cdktfprovideroktadataoktaapppropertyactiveonlyinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`idInput`](#cdktfprovideroktadataoktaapppropertyidinput) | `string` | *No description.* |
| [`labelInput`](#cdktfprovideroktadataoktaapppropertylabelinput) | `string` | *No description.* |
| [`labelPrefixInput`](#cdktfprovideroktadataoktaapppropertylabelprefixinput) | `string` | *No description.* |
| [`skipGroupsInput`](#cdktfprovideroktadataoktaapppropertyskipgroupsinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`skipUsersInput`](#cdktfprovideroktadataoktaapppropertyskipusersinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`activeOnly`](#cdktfprovideroktadataoktaapppropertyactiveonly)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`id`](#cdktfprovideroktadataoktaapppropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`label`](#cdktfprovideroktadataoktaapppropertylabel)<span title="Required">*</span> | `string` | *No description.* |
| [`labelPrefix`](#cdktfprovideroktadataoktaapppropertylabelprefix)<span title="Required">*</span> | `string` | *No description.* |
| [`skipGroups`](#cdktfprovideroktadataoktaapppropertyskipgroups)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`skipUsers`](#cdktfprovideroktadataoktaapppropertyskipusers)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |

---

##### `groups`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaApp.property.groups" id="cdktfprovideroktadataoktaapppropertygroups"></a>

```typescript
public readonly groups: string[];
```

- *Type:* `string`[]

---

##### `links`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaApp.property.links" id="cdktfprovideroktadataoktaapppropertylinks"></a>

```typescript
public readonly links: string;
```

- *Type:* `string`

---

##### `name`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaApp.property.name" id="cdktfprovideroktadataoktaapppropertyname"></a>

```typescript
public readonly name: string;
```

- *Type:* `string`

---

##### `status`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaApp.property.status" id="cdktfprovideroktadataoktaapppropertystatus"></a>

```typescript
public readonly status: string;
```

- *Type:* `string`

---

##### `users`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaApp.property.users" id="cdktfprovideroktadataoktaapppropertyusers"></a>

```typescript
public readonly users: string[];
```

- *Type:* `string`[]

---

##### `activeOnlyInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaApp.property.activeOnlyInput" id="cdktfprovideroktadataoktaapppropertyactiveonlyinput"></a>

```typescript
public readonly activeOnlyInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaApp.property.idInput" id="cdktfprovideroktadataoktaapppropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `labelInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaApp.property.labelInput" id="cdktfprovideroktadataoktaapppropertylabelinput"></a>

```typescript
public readonly labelInput: string;
```

- *Type:* `string`

---

##### `labelPrefixInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaApp.property.labelPrefixInput" id="cdktfprovideroktadataoktaapppropertylabelprefixinput"></a>

```typescript
public readonly labelPrefixInput: string;
```

- *Type:* `string`

---

##### `skipGroupsInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaApp.property.skipGroupsInput" id="cdktfprovideroktadataoktaapppropertyskipgroupsinput"></a>

```typescript
public readonly skipGroupsInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `skipUsersInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaApp.property.skipUsersInput" id="cdktfprovideroktadataoktaapppropertyskipusersinput"></a>

```typescript
public readonly skipUsersInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `activeOnly`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaApp.property.activeOnly" id="cdktfprovideroktadataoktaapppropertyactiveonly"></a>

```typescript
public readonly activeOnly: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaApp.property.id" id="cdktfprovideroktadataoktaapppropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `label`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaApp.property.label" id="cdktfprovideroktadataoktaapppropertylabel"></a>

```typescript
public readonly label: string;
```

- *Type:* `string`

---

##### `labelPrefix`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaApp.property.labelPrefix" id="cdktfprovideroktadataoktaapppropertylabelprefix"></a>

```typescript
public readonly labelPrefix: string;
```

- *Type:* `string`

---

##### `skipGroups`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaApp.property.skipGroups" id="cdktfprovideroktadataoktaapppropertyskipgroups"></a>

```typescript
public readonly skipGroups: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `skipUsers`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaApp.property.skipUsers" id="cdktfprovideroktadataoktaapppropertyskipusers"></a>

```typescript
public readonly skipUsers: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktadataoktaapppropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.DataOktaApp.property.tfResourceType" id="cdktfprovideroktadataoktaapppropertytfresourcetype"></a>

- *Type:* `string`

---

### DataOktaAppGroupAssignments <a name="@cdktf/provider-okta.DataOktaAppGroupAssignments" id="cdktfprovideroktadataoktaappgroupassignments"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/d/app_group_assignments okta_app_group_assignments}.

#### Initializers <a name="@cdktf/provider-okta.DataOktaAppGroupAssignments.Initializer" id="cdktfprovideroktadataoktaappgroupassignmentsinitializer"></a>

```typescript
import { DataOktaAppGroupAssignments } from '@cdktf/provider-okta'

new DataOktaAppGroupAssignments(scope: Construct, id: string, config: DataOktaAppGroupAssignmentsConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktadataoktaappgroupassignmentsparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktadataoktaappgroupassignmentsparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktadataoktaappgroupassignmentsparameterconfig)<span title="Required">*</span> | [`@cdktf/provider-okta.DataOktaAppGroupAssignmentsConfig`](#@cdktf/provider-okta.DataOktaAppGroupAssignmentsConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppGroupAssignments.parameter.scope" id="cdktfprovideroktadataoktaappgroupassignmentsparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppGroupAssignments.parameter.id" id="cdktfprovideroktadataoktaappgroupassignmentsparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppGroupAssignments.parameter.config" id="cdktfprovideroktadataoktaappgroupassignmentsparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.DataOktaAppGroupAssignmentsConfig`](#@cdktf/provider-okta.DataOktaAppGroupAssignmentsConfig)

---



#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`groups`](#cdktfprovideroktadataoktaappgroupassignmentspropertygroups)<span title="Required">*</span> | `string`[] | *No description.* |
| [`idInput`](#cdktfprovideroktadataoktaappgroupassignmentspropertyidinput) | `string` | *No description.* |
| [`id`](#cdktfprovideroktadataoktaappgroupassignmentspropertyid)<span title="Required">*</span> | `string` | *No description.* |

---

##### `groups`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppGroupAssignments.property.groups" id="cdktfprovideroktadataoktaappgroupassignmentspropertygroups"></a>

```typescript
public readonly groups: string[];
```

- *Type:* `string`[]

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaAppGroupAssignments.property.idInput" id="cdktfprovideroktadataoktaappgroupassignmentspropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppGroupAssignments.property.id" id="cdktfprovideroktadataoktaappgroupassignmentspropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktadataoktaappgroupassignmentspropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.DataOktaAppGroupAssignments.property.tfResourceType" id="cdktfprovideroktadataoktaappgroupassignmentspropertytfresourcetype"></a>

- *Type:* `string`

---

### DataOktaAppMetadataSaml <a name="@cdktf/provider-okta.DataOktaAppMetadataSaml" id="cdktfprovideroktadataoktaappmetadatasaml"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/d/app_metadata_saml okta_app_metadata_saml}.

#### Initializers <a name="@cdktf/provider-okta.DataOktaAppMetadataSaml.Initializer" id="cdktfprovideroktadataoktaappmetadatasamlinitializer"></a>

```typescript
import { DataOktaAppMetadataSaml } from '@cdktf/provider-okta'

new DataOktaAppMetadataSaml(scope: Construct, id: string, config: DataOktaAppMetadataSamlConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktadataoktaappmetadatasamlparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktadataoktaappmetadatasamlparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktadataoktaappmetadatasamlparameterconfig)<span title="Required">*</span> | [`@cdktf/provider-okta.DataOktaAppMetadataSamlConfig`](#@cdktf/provider-okta.DataOktaAppMetadataSamlConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppMetadataSaml.parameter.scope" id="cdktfprovideroktadataoktaappmetadatasamlparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppMetadataSaml.parameter.id" id="cdktfprovideroktadataoktaappmetadatasamlparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppMetadataSaml.parameter.config" id="cdktfprovideroktadataoktaappmetadatasamlparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.DataOktaAppMetadataSamlConfig`](#@cdktf/provider-okta.DataOktaAppMetadataSamlConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`resetId`](#cdktfprovideroktadataoktaappmetadatasamlresetid) | *No description.* |
| [`resetKeyId`](#cdktfprovideroktadataoktaappmetadatasamlresetkeyid) | *No description.* |

---

##### `resetId` <a name="@cdktf/provider-okta.DataOktaAppMetadataSaml.resetId" id="cdktfprovideroktadataoktaappmetadatasamlresetid"></a>

```typescript
public resetId()
```

##### `resetKeyId` <a name="@cdktf/provider-okta.DataOktaAppMetadataSaml.resetKeyId" id="cdktfprovideroktadataoktaappmetadatasamlresetkeyid"></a>

```typescript
public resetKeyId()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`certificate`](#cdktfprovideroktadataoktaappmetadatasamlpropertycertificate)<span title="Required">*</span> | `string` | *No description.* |
| [`entityId`](#cdktfprovideroktadataoktaappmetadatasamlpropertyentityid)<span title="Required">*</span> | `string` | *No description.* |
| [`httpPostBinding`](#cdktfprovideroktadataoktaappmetadatasamlpropertyhttppostbinding)<span title="Required">*</span> | `string` | *No description.* |
| [`httpRedirectBinding`](#cdktfprovideroktadataoktaappmetadatasamlpropertyhttpredirectbinding)<span title="Required">*</span> | `string` | *No description.* |
| [`metadata`](#cdktfprovideroktadataoktaappmetadatasamlpropertymetadata)<span title="Required">*</span> | `string` | *No description.* |
| [`wantAuthnRequestsSigned`](#cdktfprovideroktadataoktaappmetadatasamlpropertywantauthnrequestssigned)<span title="Required">*</span> | [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`appIdInput`](#cdktfprovideroktadataoktaappmetadatasamlpropertyappidinput) | `string` | *No description.* |
| [`idInput`](#cdktfprovideroktadataoktaappmetadatasamlpropertyidinput) | `string` | *No description.* |
| [`keyIdInput`](#cdktfprovideroktadataoktaappmetadatasamlpropertykeyidinput) | `string` | *No description.* |
| [`appId`](#cdktfprovideroktadataoktaappmetadatasamlpropertyappid)<span title="Required">*</span> | `string` | *No description.* |
| [`id`](#cdktfprovideroktadataoktaappmetadatasamlpropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`keyId`](#cdktfprovideroktadataoktaappmetadatasamlpropertykeyid)<span title="Required">*</span> | `string` | *No description.* |

---

##### `certificate`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppMetadataSaml.property.certificate" id="cdktfprovideroktadataoktaappmetadatasamlpropertycertificate"></a>

```typescript
public readonly certificate: string;
```

- *Type:* `string`

---

##### `entityId`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppMetadataSaml.property.entityId" id="cdktfprovideroktadataoktaappmetadatasamlpropertyentityid"></a>

```typescript
public readonly entityId: string;
```

- *Type:* `string`

---

##### `httpPostBinding`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppMetadataSaml.property.httpPostBinding" id="cdktfprovideroktadataoktaappmetadatasamlpropertyhttppostbinding"></a>

```typescript
public readonly httpPostBinding: string;
```

- *Type:* `string`

---

##### `httpRedirectBinding`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppMetadataSaml.property.httpRedirectBinding" id="cdktfprovideroktadataoktaappmetadatasamlpropertyhttpredirectbinding"></a>

```typescript
public readonly httpRedirectBinding: string;
```

- *Type:* `string`

---

##### `metadata`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppMetadataSaml.property.metadata" id="cdktfprovideroktadataoktaappmetadatasamlpropertymetadata"></a>

```typescript
public readonly metadata: string;
```

- *Type:* `string`

---

##### `wantAuthnRequestsSigned`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppMetadataSaml.property.wantAuthnRequestsSigned" id="cdktfprovideroktadataoktaappmetadatasamlpropertywantauthnrequestssigned"></a>

```typescript
public readonly wantAuthnRequestsSigned: IResolvable;
```

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `appIdInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaAppMetadataSaml.property.appIdInput" id="cdktfprovideroktadataoktaappmetadatasamlpropertyappidinput"></a>

```typescript
public readonly appIdInput: string;
```

- *Type:* `string`

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaAppMetadataSaml.property.idInput" id="cdktfprovideroktadataoktaappmetadatasamlpropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `keyIdInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaAppMetadataSaml.property.keyIdInput" id="cdktfprovideroktadataoktaappmetadatasamlpropertykeyidinput"></a>

```typescript
public readonly keyIdInput: string;
```

- *Type:* `string`

---

##### `appId`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppMetadataSaml.property.appId" id="cdktfprovideroktadataoktaappmetadatasamlpropertyappid"></a>

```typescript
public readonly appId: string;
```

- *Type:* `string`

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppMetadataSaml.property.id" id="cdktfprovideroktadataoktaappmetadatasamlpropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `keyId`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppMetadataSaml.property.keyId" id="cdktfprovideroktadataoktaappmetadatasamlpropertykeyid"></a>

```typescript
public readonly keyId: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktadataoktaappmetadatasamlpropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.DataOktaAppMetadataSaml.property.tfResourceType" id="cdktfprovideroktadataoktaappmetadatasamlpropertytfresourcetype"></a>

- *Type:* `string`

---

### DataOktaAppOauth <a name="@cdktf/provider-okta.DataOktaAppOauth" id="cdktfprovideroktadataoktaappoauth"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/d/app_oauth okta_app_oauth}.

#### Initializers <a name="@cdktf/provider-okta.DataOktaAppOauth.Initializer" id="cdktfprovideroktadataoktaappoauthinitializer"></a>

```typescript
import { DataOktaAppOauth } from '@cdktf/provider-okta'

new DataOktaAppOauth(scope: Construct, id: string, config?: DataOktaAppOauthConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktadataoktaappoauthparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktadataoktaappoauthparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktadataoktaappoauthparameterconfig) | [`@cdktf/provider-okta.DataOktaAppOauthConfig`](#@cdktf/provider-okta.DataOktaAppOauthConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppOauth.parameter.scope" id="cdktfprovideroktadataoktaappoauthparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppOauth.parameter.id" id="cdktfprovideroktadataoktaappoauthparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaAppOauth.parameter.config" id="cdktfprovideroktadataoktaappoauthparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.DataOktaAppOauthConfig`](#@cdktf/provider-okta.DataOktaAppOauthConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`resetActiveOnly`](#cdktfprovideroktadataoktaappoauthresetactiveonly) | *No description.* |
| [`resetId`](#cdktfprovideroktadataoktaappoauthresetid) | *No description.* |
| [`resetLabel`](#cdktfprovideroktadataoktaappoauthresetlabel) | *No description.* |
| [`resetLabelPrefix`](#cdktfprovideroktadataoktaappoauthresetlabelprefix) | *No description.* |
| [`resetSkipGroups`](#cdktfprovideroktadataoktaappoauthresetskipgroups) | *No description.* |
| [`resetSkipUsers`](#cdktfprovideroktadataoktaappoauthresetskipusers) | *No description.* |

---

##### `resetActiveOnly` <a name="@cdktf/provider-okta.DataOktaAppOauth.resetActiveOnly" id="cdktfprovideroktadataoktaappoauthresetactiveonly"></a>

```typescript
public resetActiveOnly()
```

##### `resetId` <a name="@cdktf/provider-okta.DataOktaAppOauth.resetId" id="cdktfprovideroktadataoktaappoauthresetid"></a>

```typescript
public resetId()
```

##### `resetLabel` <a name="@cdktf/provider-okta.DataOktaAppOauth.resetLabel" id="cdktfprovideroktadataoktaappoauthresetlabel"></a>

```typescript
public resetLabel()
```

##### `resetLabelPrefix` <a name="@cdktf/provider-okta.DataOktaAppOauth.resetLabelPrefix" id="cdktfprovideroktadataoktaappoauthresetlabelprefix"></a>

```typescript
public resetLabelPrefix()
```

##### `resetSkipGroups` <a name="@cdktf/provider-okta.DataOktaAppOauth.resetSkipGroups" id="cdktfprovideroktadataoktaappoauthresetskipgroups"></a>

```typescript
public resetSkipGroups()
```

##### `resetSkipUsers` <a name="@cdktf/provider-okta.DataOktaAppOauth.resetSkipUsers" id="cdktfprovideroktadataoktaappoauthresetskipusers"></a>

```typescript
public resetSkipUsers()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`autoSubmitToolbar`](#cdktfprovideroktadataoktaappoauthpropertyautosubmittoolbar)<span title="Required">*</span> | [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`clientId`](#cdktfprovideroktadataoktaappoauthpropertyclientid)<span title="Required">*</span> | `string` | *No description.* |
| [`clientUri`](#cdktfprovideroktadataoktaappoauthpropertyclienturi)<span title="Required">*</span> | `string` | *No description.* |
| [`grantTypes`](#cdktfprovideroktadataoktaappoauthpropertygranttypes)<span title="Required">*</span> | `string`[] | *No description.* |
| [`groups`](#cdktfprovideroktadataoktaappoauthpropertygroups)<span title="Required">*</span> | `string`[] | *No description.* |
| [`hideIos`](#cdktfprovideroktadataoktaappoauthpropertyhideios)<span title="Required">*</span> | [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`hideWeb`](#cdktfprovideroktadataoktaappoauthpropertyhideweb)<span title="Required">*</span> | [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`links`](#cdktfprovideroktadataoktaappoauthpropertylinks)<span title="Required">*</span> | `string` | *No description.* |
| [`loginMode`](#cdktfprovideroktadataoktaappoauthpropertyloginmode)<span title="Required">*</span> | `string` | *No description.* |
| [`loginScopes`](#cdktfprovideroktadataoktaappoauthpropertyloginscopes)<span title="Required">*</span> | `string`[] | *No description.* |
| [`loginUri`](#cdktfprovideroktadataoktaappoauthpropertyloginuri)<span title="Required">*</span> | `string` | *No description.* |
| [`logoUri`](#cdktfprovideroktadataoktaappoauthpropertylogouri)<span title="Required">*</span> | `string` | *No description.* |
| [`name`](#cdktfprovideroktadataoktaappoauthpropertyname)<span title="Required">*</span> | `string` | *No description.* |
| [`policyUri`](#cdktfprovideroktadataoktaappoauthpropertypolicyuri)<span title="Required">*</span> | `string` | *No description.* |
| [`postLogoutRedirectUris`](#cdktfprovideroktadataoktaappoauthpropertypostlogoutredirecturis)<span title="Required">*</span> | `string`[] | *No description.* |
| [`redirectUris`](#cdktfprovideroktadataoktaappoauthpropertyredirecturis)<span title="Required">*</span> | `string`[] | *No description.* |
| [`responseTypes`](#cdktfprovideroktadataoktaappoauthpropertyresponsetypes)<span title="Required">*</span> | `string`[] | *No description.* |
| [`status`](#cdktfprovideroktadataoktaappoauthpropertystatus)<span title="Required">*</span> | `string` | *No description.* |
| [`type`](#cdktfprovideroktadataoktaappoauthpropertytype)<span title="Required">*</span> | `string` | *No description.* |
| [`users`](#cdktfprovideroktadataoktaappoauthpropertyusers)<span title="Required">*</span> | `string`[] | *No description.* |
| [`wildcardRedirect`](#cdktfprovideroktadataoktaappoauthpropertywildcardredirect)<span title="Required">*</span> | `string` | *No description.* |
| [`activeOnlyInput`](#cdktfprovideroktadataoktaappoauthpropertyactiveonlyinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`idInput`](#cdktfprovideroktadataoktaappoauthpropertyidinput) | `string` | *No description.* |
| [`labelInput`](#cdktfprovideroktadataoktaappoauthpropertylabelinput) | `string` | *No description.* |
| [`labelPrefixInput`](#cdktfprovideroktadataoktaappoauthpropertylabelprefixinput) | `string` | *No description.* |
| [`skipGroupsInput`](#cdktfprovideroktadataoktaappoauthpropertyskipgroupsinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`skipUsersInput`](#cdktfprovideroktadataoktaappoauthpropertyskipusersinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`activeOnly`](#cdktfprovideroktadataoktaappoauthpropertyactiveonly)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`id`](#cdktfprovideroktadataoktaappoauthpropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`label`](#cdktfprovideroktadataoktaappoauthpropertylabel)<span title="Required">*</span> | `string` | *No description.* |
| [`labelPrefix`](#cdktfprovideroktadataoktaappoauthpropertylabelprefix)<span title="Required">*</span> | `string` | *No description.* |
| [`skipGroups`](#cdktfprovideroktadataoktaappoauthpropertyskipgroups)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`skipUsers`](#cdktfprovideroktadataoktaappoauthpropertyskipusers)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |

---

##### `autoSubmitToolbar`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppOauth.property.autoSubmitToolbar" id="cdktfprovideroktadataoktaappoauthpropertyautosubmittoolbar"></a>

```typescript
public readonly autoSubmitToolbar: IResolvable;
```

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `clientId`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppOauth.property.clientId" id="cdktfprovideroktadataoktaappoauthpropertyclientid"></a>

```typescript
public readonly clientId: string;
```

- *Type:* `string`

---

##### `clientUri`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppOauth.property.clientUri" id="cdktfprovideroktadataoktaappoauthpropertyclienturi"></a>

```typescript
public readonly clientUri: string;
```

- *Type:* `string`

---

##### `grantTypes`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppOauth.property.grantTypes" id="cdktfprovideroktadataoktaappoauthpropertygranttypes"></a>

```typescript
public readonly grantTypes: string[];
```

- *Type:* `string`[]

---

##### `groups`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppOauth.property.groups" id="cdktfprovideroktadataoktaappoauthpropertygroups"></a>

```typescript
public readonly groups: string[];
```

- *Type:* `string`[]

---

##### `hideIos`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppOauth.property.hideIos" id="cdktfprovideroktadataoktaappoauthpropertyhideios"></a>

```typescript
public readonly hideIos: IResolvable;
```

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `hideWeb`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppOauth.property.hideWeb" id="cdktfprovideroktadataoktaappoauthpropertyhideweb"></a>

```typescript
public readonly hideWeb: IResolvable;
```

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `links`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppOauth.property.links" id="cdktfprovideroktadataoktaappoauthpropertylinks"></a>

```typescript
public readonly links: string;
```

- *Type:* `string`

---

##### `loginMode`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppOauth.property.loginMode" id="cdktfprovideroktadataoktaappoauthpropertyloginmode"></a>

```typescript
public readonly loginMode: string;
```

- *Type:* `string`

---

##### `loginScopes`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppOauth.property.loginScopes" id="cdktfprovideroktadataoktaappoauthpropertyloginscopes"></a>

```typescript
public readonly loginScopes: string[];
```

- *Type:* `string`[]

---

##### `loginUri`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppOauth.property.loginUri" id="cdktfprovideroktadataoktaappoauthpropertyloginuri"></a>

```typescript
public readonly loginUri: string;
```

- *Type:* `string`

---

##### `logoUri`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppOauth.property.logoUri" id="cdktfprovideroktadataoktaappoauthpropertylogouri"></a>

```typescript
public readonly logoUri: string;
```

- *Type:* `string`

---

##### `name`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppOauth.property.name" id="cdktfprovideroktadataoktaappoauthpropertyname"></a>

```typescript
public readonly name: string;
```

- *Type:* `string`

---

##### `policyUri`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppOauth.property.policyUri" id="cdktfprovideroktadataoktaappoauthpropertypolicyuri"></a>

```typescript
public readonly policyUri: string;
```

- *Type:* `string`

---

##### `postLogoutRedirectUris`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppOauth.property.postLogoutRedirectUris" id="cdktfprovideroktadataoktaappoauthpropertypostlogoutredirecturis"></a>

```typescript
public readonly postLogoutRedirectUris: string[];
```

- *Type:* `string`[]

---

##### `redirectUris`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppOauth.property.redirectUris" id="cdktfprovideroktadataoktaappoauthpropertyredirecturis"></a>

```typescript
public readonly redirectUris: string[];
```

- *Type:* `string`[]

---

##### `responseTypes`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppOauth.property.responseTypes" id="cdktfprovideroktadataoktaappoauthpropertyresponsetypes"></a>

```typescript
public readonly responseTypes: string[];
```

- *Type:* `string`[]

---

##### `status`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppOauth.property.status" id="cdktfprovideroktadataoktaappoauthpropertystatus"></a>

```typescript
public readonly status: string;
```

- *Type:* `string`

---

##### `type`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppOauth.property.type" id="cdktfprovideroktadataoktaappoauthpropertytype"></a>

```typescript
public readonly type: string;
```

- *Type:* `string`

---

##### `users`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppOauth.property.users" id="cdktfprovideroktadataoktaappoauthpropertyusers"></a>

```typescript
public readonly users: string[];
```

- *Type:* `string`[]

---

##### `wildcardRedirect`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppOauth.property.wildcardRedirect" id="cdktfprovideroktadataoktaappoauthpropertywildcardredirect"></a>

```typescript
public readonly wildcardRedirect: string;
```

- *Type:* `string`

---

##### `activeOnlyInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaAppOauth.property.activeOnlyInput" id="cdktfprovideroktadataoktaappoauthpropertyactiveonlyinput"></a>

```typescript
public readonly activeOnlyInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaAppOauth.property.idInput" id="cdktfprovideroktadataoktaappoauthpropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `labelInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaAppOauth.property.labelInput" id="cdktfprovideroktadataoktaappoauthpropertylabelinput"></a>

```typescript
public readonly labelInput: string;
```

- *Type:* `string`

---

##### `labelPrefixInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaAppOauth.property.labelPrefixInput" id="cdktfprovideroktadataoktaappoauthpropertylabelprefixinput"></a>

```typescript
public readonly labelPrefixInput: string;
```

- *Type:* `string`

---

##### `skipGroupsInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaAppOauth.property.skipGroupsInput" id="cdktfprovideroktadataoktaappoauthpropertyskipgroupsinput"></a>

```typescript
public readonly skipGroupsInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `skipUsersInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaAppOauth.property.skipUsersInput" id="cdktfprovideroktadataoktaappoauthpropertyskipusersinput"></a>

```typescript
public readonly skipUsersInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `activeOnly`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppOauth.property.activeOnly" id="cdktfprovideroktadataoktaappoauthpropertyactiveonly"></a>

```typescript
public readonly activeOnly: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppOauth.property.id" id="cdktfprovideroktadataoktaappoauthpropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `label`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppOauth.property.label" id="cdktfprovideroktadataoktaappoauthpropertylabel"></a>

```typescript
public readonly label: string;
```

- *Type:* `string`

---

##### `labelPrefix`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppOauth.property.labelPrefix" id="cdktfprovideroktadataoktaappoauthpropertylabelprefix"></a>

```typescript
public readonly labelPrefix: string;
```

- *Type:* `string`

---

##### `skipGroups`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppOauth.property.skipGroups" id="cdktfprovideroktadataoktaappoauthpropertyskipgroups"></a>

```typescript
public readonly skipGroups: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `skipUsers`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppOauth.property.skipUsers" id="cdktfprovideroktadataoktaappoauthpropertyskipusers"></a>

```typescript
public readonly skipUsers: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktadataoktaappoauthpropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.DataOktaAppOauth.property.tfResourceType" id="cdktfprovideroktadataoktaappoauthpropertytfresourcetype"></a>

- *Type:* `string`

---

### DataOktaAppSaml <a name="@cdktf/provider-okta.DataOktaAppSaml" id="cdktfprovideroktadataoktaappsaml"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/d/app_saml okta_app_saml}.

#### Initializers <a name="@cdktf/provider-okta.DataOktaAppSaml.Initializer" id="cdktfprovideroktadataoktaappsamlinitializer"></a>

```typescript
import { DataOktaAppSaml } from '@cdktf/provider-okta'

new DataOktaAppSaml(scope: Construct, id: string, config?: DataOktaAppSamlConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktadataoktaappsamlparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktadataoktaappsamlparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktadataoktaappsamlparameterconfig) | [`@cdktf/provider-okta.DataOktaAppSamlConfig`](#@cdktf/provider-okta.DataOktaAppSamlConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppSaml.parameter.scope" id="cdktfprovideroktadataoktaappsamlparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppSaml.parameter.id" id="cdktfprovideroktadataoktaappsamlparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaAppSaml.parameter.config" id="cdktfprovideroktadataoktaappsamlparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.DataOktaAppSamlConfig`](#@cdktf/provider-okta.DataOktaAppSamlConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`resetActiveOnly`](#cdktfprovideroktadataoktaappsamlresetactiveonly) | *No description.* |
| [`resetId`](#cdktfprovideroktadataoktaappsamlresetid) | *No description.* |
| [`resetLabel`](#cdktfprovideroktadataoktaappsamlresetlabel) | *No description.* |
| [`resetLabelPrefix`](#cdktfprovideroktadataoktaappsamlresetlabelprefix) | *No description.* |
| [`resetRequestCompressed`](#cdktfprovideroktadataoktaappsamlresetrequestcompressed) | *No description.* |
| [`resetSkipGroups`](#cdktfprovideroktadataoktaappsamlresetskipgroups) | *No description.* |
| [`resetSkipUsers`](#cdktfprovideroktadataoktaappsamlresetskipusers) | *No description.* |

---

##### `resetActiveOnly` <a name="@cdktf/provider-okta.DataOktaAppSaml.resetActiveOnly" id="cdktfprovideroktadataoktaappsamlresetactiveonly"></a>

```typescript
public resetActiveOnly()
```

##### `resetId` <a name="@cdktf/provider-okta.DataOktaAppSaml.resetId" id="cdktfprovideroktadataoktaappsamlresetid"></a>

```typescript
public resetId()
```

##### `resetLabel` <a name="@cdktf/provider-okta.DataOktaAppSaml.resetLabel" id="cdktfprovideroktadataoktaappsamlresetlabel"></a>

```typescript
public resetLabel()
```

##### `resetLabelPrefix` <a name="@cdktf/provider-okta.DataOktaAppSaml.resetLabelPrefix" id="cdktfprovideroktadataoktaappsamlresetlabelprefix"></a>

```typescript
public resetLabelPrefix()
```

##### `resetRequestCompressed` <a name="@cdktf/provider-okta.DataOktaAppSaml.resetRequestCompressed" id="cdktfprovideroktadataoktaappsamlresetrequestcompressed"></a>

```typescript
public resetRequestCompressed()
```

##### `resetSkipGroups` <a name="@cdktf/provider-okta.DataOktaAppSaml.resetSkipGroups" id="cdktfprovideroktadataoktaappsamlresetskipgroups"></a>

```typescript
public resetSkipGroups()
```

##### `resetSkipUsers` <a name="@cdktf/provider-okta.DataOktaAppSaml.resetSkipUsers" id="cdktfprovideroktadataoktaappsamlresetskipusers"></a>

```typescript
public resetSkipUsers()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`accessibilityErrorRedirectUrl`](#cdktfprovideroktadataoktaappsamlpropertyaccessibilityerrorredirecturl)<span title="Required">*</span> | `string` | *No description.* |
| [`accessibilityLoginRedirectUrl`](#cdktfprovideroktadataoktaappsamlpropertyaccessibilityloginredirecturl)<span title="Required">*</span> | `string` | *No description.* |
| [`accessibilitySelfService`](#cdktfprovideroktadataoktaappsamlpropertyaccessibilityselfservice)<span title="Required">*</span> | [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`acsEndpoints`](#cdktfprovideroktadataoktaappsamlpropertyacsendpoints)<span title="Required">*</span> | `string`[] | *No description.* |
| [`appSettingsJson`](#cdktfprovideroktadataoktaappsamlpropertyappsettingsjson)<span title="Required">*</span> | `string` | *No description.* |
| [`assertionSigned`](#cdktfprovideroktadataoktaappsamlpropertyassertionsigned)<span title="Required">*</span> | [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`attributeStatements`](#cdktfprovideroktadataoktaappsamlpropertyattributestatements)<span title="Required">*</span> | [`@cdktf/provider-okta.DataOktaAppSamlAttributeStatementsList`](#@cdktf/provider-okta.DataOktaAppSamlAttributeStatementsList) | *No description.* |
| [`audience`](#cdktfprovideroktadataoktaappsamlpropertyaudience)<span title="Required">*</span> | `string` | *No description.* |
| [`authnContextClassRef`](#cdktfprovideroktadataoktaappsamlpropertyauthncontextclassref)<span title="Required">*</span> | `string` | *No description.* |
| [`autoSubmitToolbar`](#cdktfprovideroktadataoktaappsamlpropertyautosubmittoolbar)<span title="Required">*</span> | [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`defaultRelayState`](#cdktfprovideroktadataoktaappsamlpropertydefaultrelaystate)<span title="Required">*</span> | `string` | *No description.* |
| [`destination`](#cdktfprovideroktadataoktaappsamlpropertydestination)<span title="Required">*</span> | `string` | *No description.* |
| [`digestAlgorithm`](#cdktfprovideroktadataoktaappsamlpropertydigestalgorithm)<span title="Required">*</span> | `string` | *No description.* |
| [`features`](#cdktfprovideroktadataoktaappsamlpropertyfeatures)<span title="Required">*</span> | `string`[] | *No description.* |
| [`groups`](#cdktfprovideroktadataoktaappsamlpropertygroups)<span title="Required">*</span> | `string`[] | *No description.* |
| [`hideIos`](#cdktfprovideroktadataoktaappsamlpropertyhideios)<span title="Required">*</span> | [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`hideWeb`](#cdktfprovideroktadataoktaappsamlpropertyhideweb)<span title="Required">*</span> | [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`honorForceAuthn`](#cdktfprovideroktadataoktaappsamlpropertyhonorforceauthn)<span title="Required">*</span> | [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`idpIssuer`](#cdktfprovideroktadataoktaappsamlpropertyidpissuer)<span title="Required">*</span> | `string` | *No description.* |
| [`inlineHookId`](#cdktfprovideroktadataoktaappsamlpropertyinlinehookid)<span title="Required">*</span> | `string` | *No description.* |
| [`keyId`](#cdktfprovideroktadataoktaappsamlpropertykeyid)<span title="Required">*</span> | `string` | *No description.* |
| [`links`](#cdktfprovideroktadataoktaappsamlpropertylinks)<span title="Required">*</span> | `string` | *No description.* |
| [`name`](#cdktfprovideroktadataoktaappsamlpropertyname)<span title="Required">*</span> | `string` | *No description.* |
| [`recipient`](#cdktfprovideroktadataoktaappsamlpropertyrecipient)<span title="Required">*</span> | `string` | *No description.* |
| [`responseSigned`](#cdktfprovideroktadataoktaappsamlpropertyresponsesigned)<span title="Required">*</span> | [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`signatureAlgorithm`](#cdktfprovideroktadataoktaappsamlpropertysignaturealgorithm)<span title="Required">*</span> | `string` | *No description.* |
| [`singleLogoutCertificate`](#cdktfprovideroktadataoktaappsamlpropertysinglelogoutcertificate)<span title="Required">*</span> | `string` | *No description.* |
| [`singleLogoutIssuer`](#cdktfprovideroktadataoktaappsamlpropertysinglelogoutissuer)<span title="Required">*</span> | `string` | *No description.* |
| [`singleLogoutUrl`](#cdktfprovideroktadataoktaappsamlpropertysinglelogouturl)<span title="Required">*</span> | `string` | *No description.* |
| [`spIssuer`](#cdktfprovideroktadataoktaappsamlpropertyspissuer)<span title="Required">*</span> | `string` | *No description.* |
| [`ssoUrl`](#cdktfprovideroktadataoktaappsamlpropertyssourl)<span title="Required">*</span> | `string` | *No description.* |
| [`status`](#cdktfprovideroktadataoktaappsamlpropertystatus)<span title="Required">*</span> | `string` | *No description.* |
| [`subjectNameIdFormat`](#cdktfprovideroktadataoktaappsamlpropertysubjectnameidformat)<span title="Required">*</span> | `string` | *No description.* |
| [`subjectNameIdTemplate`](#cdktfprovideroktadataoktaappsamlpropertysubjectnameidtemplate)<span title="Required">*</span> | `string` | *No description.* |
| [`userNameTemplate`](#cdktfprovideroktadataoktaappsamlpropertyusernametemplate)<span title="Required">*</span> | `string` | *No description.* |
| [`userNameTemplatePushStatus`](#cdktfprovideroktadataoktaappsamlpropertyusernametemplatepushstatus)<span title="Required">*</span> | `string` | *No description.* |
| [`userNameTemplateSuffix`](#cdktfprovideroktadataoktaappsamlpropertyusernametemplatesuffix)<span title="Required">*</span> | `string` | *No description.* |
| [`userNameTemplateType`](#cdktfprovideroktadataoktaappsamlpropertyusernametemplatetype)<span title="Required">*</span> | `string` | *No description.* |
| [`users`](#cdktfprovideroktadataoktaappsamlpropertyusers)<span title="Required">*</span> | `string`[] | *No description.* |
| [`activeOnlyInput`](#cdktfprovideroktadataoktaappsamlpropertyactiveonlyinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`idInput`](#cdktfprovideroktadataoktaappsamlpropertyidinput) | `string` | *No description.* |
| [`labelInput`](#cdktfprovideroktadataoktaappsamlpropertylabelinput) | `string` | *No description.* |
| [`labelPrefixInput`](#cdktfprovideroktadataoktaappsamlpropertylabelprefixinput) | `string` | *No description.* |
| [`requestCompressedInput`](#cdktfprovideroktadataoktaappsamlpropertyrequestcompressedinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`skipGroupsInput`](#cdktfprovideroktadataoktaappsamlpropertyskipgroupsinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`skipUsersInput`](#cdktfprovideroktadataoktaappsamlpropertyskipusersinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`activeOnly`](#cdktfprovideroktadataoktaappsamlpropertyactiveonly)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`id`](#cdktfprovideroktadataoktaappsamlpropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`label`](#cdktfprovideroktadataoktaappsamlpropertylabel)<span title="Required">*</span> | `string` | *No description.* |
| [`labelPrefix`](#cdktfprovideroktadataoktaappsamlpropertylabelprefix)<span title="Required">*</span> | `string` | *No description.* |
| [`requestCompressed`](#cdktfprovideroktadataoktaappsamlpropertyrequestcompressed)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`skipGroups`](#cdktfprovideroktadataoktaappsamlpropertyskipgroups)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`skipUsers`](#cdktfprovideroktadataoktaappsamlpropertyskipusers)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |

---

##### `accessibilityErrorRedirectUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppSaml.property.accessibilityErrorRedirectUrl" id="cdktfprovideroktadataoktaappsamlpropertyaccessibilityerrorredirecturl"></a>

```typescript
public readonly accessibilityErrorRedirectUrl: string;
```

- *Type:* `string`

---

##### `accessibilityLoginRedirectUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppSaml.property.accessibilityLoginRedirectUrl" id="cdktfprovideroktadataoktaappsamlpropertyaccessibilityloginredirecturl"></a>

```typescript
public readonly accessibilityLoginRedirectUrl: string;
```

- *Type:* `string`

---

##### `accessibilitySelfService`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppSaml.property.accessibilitySelfService" id="cdktfprovideroktadataoktaappsamlpropertyaccessibilityselfservice"></a>

```typescript
public readonly accessibilitySelfService: IResolvable;
```

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `acsEndpoints`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppSaml.property.acsEndpoints" id="cdktfprovideroktadataoktaappsamlpropertyacsendpoints"></a>

```typescript
public readonly acsEndpoints: string[];
```

- *Type:* `string`[]

---

##### `appSettingsJson`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppSaml.property.appSettingsJson" id="cdktfprovideroktadataoktaappsamlpropertyappsettingsjson"></a>

```typescript
public readonly appSettingsJson: string;
```

- *Type:* `string`

---

##### `assertionSigned`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppSaml.property.assertionSigned" id="cdktfprovideroktadataoktaappsamlpropertyassertionsigned"></a>

```typescript
public readonly assertionSigned: IResolvable;
```

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `attributeStatements`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppSaml.property.attributeStatements" id="cdktfprovideroktadataoktaappsamlpropertyattributestatements"></a>

```typescript
public readonly attributeStatements: DataOktaAppSamlAttributeStatementsList;
```

- *Type:* [`@cdktf/provider-okta.DataOktaAppSamlAttributeStatementsList`](#@cdktf/provider-okta.DataOktaAppSamlAttributeStatementsList)

---

##### `audience`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppSaml.property.audience" id="cdktfprovideroktadataoktaappsamlpropertyaudience"></a>

```typescript
public readonly audience: string;
```

- *Type:* `string`

---

##### `authnContextClassRef`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppSaml.property.authnContextClassRef" id="cdktfprovideroktadataoktaappsamlpropertyauthncontextclassref"></a>

```typescript
public readonly authnContextClassRef: string;
```

- *Type:* `string`

---

##### `autoSubmitToolbar`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppSaml.property.autoSubmitToolbar" id="cdktfprovideroktadataoktaappsamlpropertyautosubmittoolbar"></a>

```typescript
public readonly autoSubmitToolbar: IResolvable;
```

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `defaultRelayState`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppSaml.property.defaultRelayState" id="cdktfprovideroktadataoktaappsamlpropertydefaultrelaystate"></a>

```typescript
public readonly defaultRelayState: string;
```

- *Type:* `string`

---

##### `destination`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppSaml.property.destination" id="cdktfprovideroktadataoktaappsamlpropertydestination"></a>

```typescript
public readonly destination: string;
```

- *Type:* `string`

---

##### `digestAlgorithm`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppSaml.property.digestAlgorithm" id="cdktfprovideroktadataoktaappsamlpropertydigestalgorithm"></a>

```typescript
public readonly digestAlgorithm: string;
```

- *Type:* `string`

---

##### `features`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppSaml.property.features" id="cdktfprovideroktadataoktaappsamlpropertyfeatures"></a>

```typescript
public readonly features: string[];
```

- *Type:* `string`[]

---

##### `groups`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppSaml.property.groups" id="cdktfprovideroktadataoktaappsamlpropertygroups"></a>

```typescript
public readonly groups: string[];
```

- *Type:* `string`[]

---

##### `hideIos`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppSaml.property.hideIos" id="cdktfprovideroktadataoktaappsamlpropertyhideios"></a>

```typescript
public readonly hideIos: IResolvable;
```

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `hideWeb`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppSaml.property.hideWeb" id="cdktfprovideroktadataoktaappsamlpropertyhideweb"></a>

```typescript
public readonly hideWeb: IResolvable;
```

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `honorForceAuthn`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppSaml.property.honorForceAuthn" id="cdktfprovideroktadataoktaappsamlpropertyhonorforceauthn"></a>

```typescript
public readonly honorForceAuthn: IResolvable;
```

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `idpIssuer`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppSaml.property.idpIssuer" id="cdktfprovideroktadataoktaappsamlpropertyidpissuer"></a>

```typescript
public readonly idpIssuer: string;
```

- *Type:* `string`

---

##### `inlineHookId`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppSaml.property.inlineHookId" id="cdktfprovideroktadataoktaappsamlpropertyinlinehookid"></a>

```typescript
public readonly inlineHookId: string;
```

- *Type:* `string`

---

##### `keyId`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppSaml.property.keyId" id="cdktfprovideroktadataoktaappsamlpropertykeyid"></a>

```typescript
public readonly keyId: string;
```

- *Type:* `string`

---

##### `links`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppSaml.property.links" id="cdktfprovideroktadataoktaappsamlpropertylinks"></a>

```typescript
public readonly links: string;
```

- *Type:* `string`

---

##### `name`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppSaml.property.name" id="cdktfprovideroktadataoktaappsamlpropertyname"></a>

```typescript
public readonly name: string;
```

- *Type:* `string`

---

##### `recipient`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppSaml.property.recipient" id="cdktfprovideroktadataoktaappsamlpropertyrecipient"></a>

```typescript
public readonly recipient: string;
```

- *Type:* `string`

---

##### `responseSigned`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppSaml.property.responseSigned" id="cdktfprovideroktadataoktaappsamlpropertyresponsesigned"></a>

```typescript
public readonly responseSigned: IResolvable;
```

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `signatureAlgorithm`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppSaml.property.signatureAlgorithm" id="cdktfprovideroktadataoktaappsamlpropertysignaturealgorithm"></a>

```typescript
public readonly signatureAlgorithm: string;
```

- *Type:* `string`

---

##### `singleLogoutCertificate`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppSaml.property.singleLogoutCertificate" id="cdktfprovideroktadataoktaappsamlpropertysinglelogoutcertificate"></a>

```typescript
public readonly singleLogoutCertificate: string;
```

- *Type:* `string`

---

##### `singleLogoutIssuer`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppSaml.property.singleLogoutIssuer" id="cdktfprovideroktadataoktaappsamlpropertysinglelogoutissuer"></a>

```typescript
public readonly singleLogoutIssuer: string;
```

- *Type:* `string`

---

##### `singleLogoutUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppSaml.property.singleLogoutUrl" id="cdktfprovideroktadataoktaappsamlpropertysinglelogouturl"></a>

```typescript
public readonly singleLogoutUrl: string;
```

- *Type:* `string`

---

##### `spIssuer`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppSaml.property.spIssuer" id="cdktfprovideroktadataoktaappsamlpropertyspissuer"></a>

```typescript
public readonly spIssuer: string;
```

- *Type:* `string`

---

##### `ssoUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppSaml.property.ssoUrl" id="cdktfprovideroktadataoktaappsamlpropertyssourl"></a>

```typescript
public readonly ssoUrl: string;
```

- *Type:* `string`

---

##### `status`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppSaml.property.status" id="cdktfprovideroktadataoktaappsamlpropertystatus"></a>

```typescript
public readonly status: string;
```

- *Type:* `string`

---

##### `subjectNameIdFormat`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppSaml.property.subjectNameIdFormat" id="cdktfprovideroktadataoktaappsamlpropertysubjectnameidformat"></a>

```typescript
public readonly subjectNameIdFormat: string;
```

- *Type:* `string`

---

##### `subjectNameIdTemplate`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppSaml.property.subjectNameIdTemplate" id="cdktfprovideroktadataoktaappsamlpropertysubjectnameidtemplate"></a>

```typescript
public readonly subjectNameIdTemplate: string;
```

- *Type:* `string`

---

##### `userNameTemplate`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppSaml.property.userNameTemplate" id="cdktfprovideroktadataoktaappsamlpropertyusernametemplate"></a>

```typescript
public readonly userNameTemplate: string;
```

- *Type:* `string`

---

##### `userNameTemplatePushStatus`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppSaml.property.userNameTemplatePushStatus" id="cdktfprovideroktadataoktaappsamlpropertyusernametemplatepushstatus"></a>

```typescript
public readonly userNameTemplatePushStatus: string;
```

- *Type:* `string`

---

##### `userNameTemplateSuffix`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppSaml.property.userNameTemplateSuffix" id="cdktfprovideroktadataoktaappsamlpropertyusernametemplatesuffix"></a>

```typescript
public readonly userNameTemplateSuffix: string;
```

- *Type:* `string`

---

##### `userNameTemplateType`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppSaml.property.userNameTemplateType" id="cdktfprovideroktadataoktaappsamlpropertyusernametemplatetype"></a>

```typescript
public readonly userNameTemplateType: string;
```

- *Type:* `string`

---

##### `users`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppSaml.property.users" id="cdktfprovideroktadataoktaappsamlpropertyusers"></a>

```typescript
public readonly users: string[];
```

- *Type:* `string`[]

---

##### `activeOnlyInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaAppSaml.property.activeOnlyInput" id="cdktfprovideroktadataoktaappsamlpropertyactiveonlyinput"></a>

```typescript
public readonly activeOnlyInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaAppSaml.property.idInput" id="cdktfprovideroktadataoktaappsamlpropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `labelInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaAppSaml.property.labelInput" id="cdktfprovideroktadataoktaappsamlpropertylabelinput"></a>

```typescript
public readonly labelInput: string;
```

- *Type:* `string`

---

##### `labelPrefixInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaAppSaml.property.labelPrefixInput" id="cdktfprovideroktadataoktaappsamlpropertylabelprefixinput"></a>

```typescript
public readonly labelPrefixInput: string;
```

- *Type:* `string`

---

##### `requestCompressedInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaAppSaml.property.requestCompressedInput" id="cdktfprovideroktadataoktaappsamlpropertyrequestcompressedinput"></a>

```typescript
public readonly requestCompressedInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `skipGroupsInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaAppSaml.property.skipGroupsInput" id="cdktfprovideroktadataoktaappsamlpropertyskipgroupsinput"></a>

```typescript
public readonly skipGroupsInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `skipUsersInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaAppSaml.property.skipUsersInput" id="cdktfprovideroktadataoktaappsamlpropertyskipusersinput"></a>

```typescript
public readonly skipUsersInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `activeOnly`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppSaml.property.activeOnly" id="cdktfprovideroktadataoktaappsamlpropertyactiveonly"></a>

```typescript
public readonly activeOnly: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppSaml.property.id" id="cdktfprovideroktadataoktaappsamlpropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `label`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppSaml.property.label" id="cdktfprovideroktadataoktaappsamlpropertylabel"></a>

```typescript
public readonly label: string;
```

- *Type:* `string`

---

##### `labelPrefix`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppSaml.property.labelPrefix" id="cdktfprovideroktadataoktaappsamlpropertylabelprefix"></a>

```typescript
public readonly labelPrefix: string;
```

- *Type:* `string`

---

##### `requestCompressed`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppSaml.property.requestCompressed" id="cdktfprovideroktadataoktaappsamlpropertyrequestcompressed"></a>

```typescript
public readonly requestCompressed: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `skipGroups`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppSaml.property.skipGroups" id="cdktfprovideroktadataoktaappsamlpropertyskipgroups"></a>

```typescript
public readonly skipGroups: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `skipUsers`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppSaml.property.skipUsers" id="cdktfprovideroktadataoktaappsamlpropertyskipusers"></a>

```typescript
public readonly skipUsers: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktadataoktaappsamlpropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.DataOktaAppSaml.property.tfResourceType" id="cdktfprovideroktadataoktaappsamlpropertytfresourcetype"></a>

- *Type:* `string`

---

### DataOktaAppSignonPolicy <a name="@cdktf/provider-okta.DataOktaAppSignonPolicy" id="cdktfprovideroktadataoktaappsignonpolicy"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/d/app_signon_policy okta_app_signon_policy}.

#### Initializers <a name="@cdktf/provider-okta.DataOktaAppSignonPolicy.Initializer" id="cdktfprovideroktadataoktaappsignonpolicyinitializer"></a>

```typescript
import { DataOktaAppSignonPolicy } from '@cdktf/provider-okta'

new DataOktaAppSignonPolicy(scope: Construct, id: string, config: DataOktaAppSignonPolicyConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktadataoktaappsignonpolicyparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktadataoktaappsignonpolicyparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktadataoktaappsignonpolicyparameterconfig)<span title="Required">*</span> | [`@cdktf/provider-okta.DataOktaAppSignonPolicyConfig`](#@cdktf/provider-okta.DataOktaAppSignonPolicyConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppSignonPolicy.parameter.scope" id="cdktfprovideroktadataoktaappsignonpolicyparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppSignonPolicy.parameter.id" id="cdktfprovideroktadataoktaappsignonpolicyparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppSignonPolicy.parameter.config" id="cdktfprovideroktadataoktaappsignonpolicyparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.DataOktaAppSignonPolicyConfig`](#@cdktf/provider-okta.DataOktaAppSignonPolicyConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`resetId`](#cdktfprovideroktadataoktaappsignonpolicyresetid) | *No description.* |

---

##### `resetId` <a name="@cdktf/provider-okta.DataOktaAppSignonPolicy.resetId" id="cdktfprovideroktadataoktaappsignonpolicyresetid"></a>

```typescript
public resetId()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`name`](#cdktfprovideroktadataoktaappsignonpolicypropertyname)<span title="Required">*</span> | `string` | *No description.* |
| [`appIdInput`](#cdktfprovideroktadataoktaappsignonpolicypropertyappidinput) | `string` | *No description.* |
| [`idInput`](#cdktfprovideroktadataoktaappsignonpolicypropertyidinput) | `string` | *No description.* |
| [`appId`](#cdktfprovideroktadataoktaappsignonpolicypropertyappid)<span title="Required">*</span> | `string` | *No description.* |
| [`id`](#cdktfprovideroktadataoktaappsignonpolicypropertyid)<span title="Required">*</span> | `string` | *No description.* |

---

##### `name`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppSignonPolicy.property.name" id="cdktfprovideroktadataoktaappsignonpolicypropertyname"></a>

```typescript
public readonly name: string;
```

- *Type:* `string`

---

##### `appIdInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaAppSignonPolicy.property.appIdInput" id="cdktfprovideroktadataoktaappsignonpolicypropertyappidinput"></a>

```typescript
public readonly appIdInput: string;
```

- *Type:* `string`

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaAppSignonPolicy.property.idInput" id="cdktfprovideroktadataoktaappsignonpolicypropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `appId`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppSignonPolicy.property.appId" id="cdktfprovideroktadataoktaappsignonpolicypropertyappid"></a>

```typescript
public readonly appId: string;
```

- *Type:* `string`

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppSignonPolicy.property.id" id="cdktfprovideroktadataoktaappsignonpolicypropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktadataoktaappsignonpolicypropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.DataOktaAppSignonPolicy.property.tfResourceType" id="cdktfprovideroktadataoktaappsignonpolicypropertytfresourcetype"></a>

- *Type:* `string`

---

### DataOktaAppUserAssignments <a name="@cdktf/provider-okta.DataOktaAppUserAssignments" id="cdktfprovideroktadataoktaappuserassignments"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/d/app_user_assignments okta_app_user_assignments}.

#### Initializers <a name="@cdktf/provider-okta.DataOktaAppUserAssignments.Initializer" id="cdktfprovideroktadataoktaappuserassignmentsinitializer"></a>

```typescript
import { DataOktaAppUserAssignments } from '@cdktf/provider-okta'

new DataOktaAppUserAssignments(scope: Construct, id: string, config: DataOktaAppUserAssignmentsConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktadataoktaappuserassignmentsparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktadataoktaappuserassignmentsparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktadataoktaappuserassignmentsparameterconfig)<span title="Required">*</span> | [`@cdktf/provider-okta.DataOktaAppUserAssignmentsConfig`](#@cdktf/provider-okta.DataOktaAppUserAssignmentsConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppUserAssignments.parameter.scope" id="cdktfprovideroktadataoktaappuserassignmentsparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppUserAssignments.parameter.id" id="cdktfprovideroktadataoktaappuserassignmentsparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppUserAssignments.parameter.config" id="cdktfprovideroktadataoktaappuserassignmentsparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.DataOktaAppUserAssignmentsConfig`](#@cdktf/provider-okta.DataOktaAppUserAssignmentsConfig)

---



#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`users`](#cdktfprovideroktadataoktaappuserassignmentspropertyusers)<span title="Required">*</span> | `string`[] | *No description.* |
| [`idInput`](#cdktfprovideroktadataoktaappuserassignmentspropertyidinput) | `string` | *No description.* |
| [`id`](#cdktfprovideroktadataoktaappuserassignmentspropertyid)<span title="Required">*</span> | `string` | *No description.* |

---

##### `users`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppUserAssignments.property.users" id="cdktfprovideroktadataoktaappuserassignmentspropertyusers"></a>

```typescript
public readonly users: string[];
```

- *Type:* `string`[]

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaAppUserAssignments.property.idInput" id="cdktfprovideroktadataoktaappuserassignmentspropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAppUserAssignments.property.id" id="cdktfprovideroktadataoktaappuserassignmentspropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktadataoktaappuserassignmentspropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.DataOktaAppUserAssignments.property.tfResourceType" id="cdktfprovideroktadataoktaappuserassignmentspropertytfresourcetype"></a>

- *Type:* `string`

---

### DataOktaAuthenticator <a name="@cdktf/provider-okta.DataOktaAuthenticator" id="cdktfprovideroktadataoktaauthenticator"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/d/authenticator okta_authenticator}.

#### Initializers <a name="@cdktf/provider-okta.DataOktaAuthenticator.Initializer" id="cdktfprovideroktadataoktaauthenticatorinitializer"></a>

```typescript
import { DataOktaAuthenticator } from '@cdktf/provider-okta'

new DataOktaAuthenticator(scope: Construct, id: string, config?: DataOktaAuthenticatorConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktadataoktaauthenticatorparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktadataoktaauthenticatorparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktadataoktaauthenticatorparameterconfig) | [`@cdktf/provider-okta.DataOktaAuthenticatorConfig`](#@cdktf/provider-okta.DataOktaAuthenticatorConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthenticator.parameter.scope" id="cdktfprovideroktadataoktaauthenticatorparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthenticator.parameter.id" id="cdktfprovideroktadataoktaauthenticatorparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaAuthenticator.parameter.config" id="cdktfprovideroktadataoktaauthenticatorparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.DataOktaAuthenticatorConfig`](#@cdktf/provider-okta.DataOktaAuthenticatorConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`resetId`](#cdktfprovideroktadataoktaauthenticatorresetid) | *No description.* |
| [`resetKey`](#cdktfprovideroktadataoktaauthenticatorresetkey) | *No description.* |
| [`resetName`](#cdktfprovideroktadataoktaauthenticatorresetname) | *No description.* |

---

##### `resetId` <a name="@cdktf/provider-okta.DataOktaAuthenticator.resetId" id="cdktfprovideroktadataoktaauthenticatorresetid"></a>

```typescript
public resetId()
```

##### `resetKey` <a name="@cdktf/provider-okta.DataOktaAuthenticator.resetKey" id="cdktfprovideroktadataoktaauthenticatorresetkey"></a>

```typescript
public resetKey()
```

##### `resetName` <a name="@cdktf/provider-okta.DataOktaAuthenticator.resetName" id="cdktfprovideroktadataoktaauthenticatorresetname"></a>

```typescript
public resetName()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`providerAuthPort`](#cdktfprovideroktadataoktaauthenticatorpropertyproviderauthport)<span title="Required">*</span> | `number` | *No description.* |
| [`providerHostname`](#cdktfprovideroktadataoktaauthenticatorpropertyproviderhostname)<span title="Required">*</span> | `string` | *No description.* |
| [`providerInstanceId`](#cdktfprovideroktadataoktaauthenticatorpropertyproviderinstanceid)<span title="Required">*</span> | `string` | *No description.* |
| [`providerType`](#cdktfprovideroktadataoktaauthenticatorpropertyprovidertype)<span title="Required">*</span> | `string` | *No description.* |
| [`providerUserNameTemplate`](#cdktfprovideroktadataoktaauthenticatorpropertyproviderusernametemplate)<span title="Required">*</span> | `string` | *No description.* |
| [`settings`](#cdktfprovideroktadataoktaauthenticatorpropertysettings)<span title="Required">*</span> | `string` | *No description.* |
| [`status`](#cdktfprovideroktadataoktaauthenticatorpropertystatus)<span title="Required">*</span> | `string` | *No description.* |
| [`type`](#cdktfprovideroktadataoktaauthenticatorpropertytype)<span title="Required">*</span> | `string` | *No description.* |
| [`idInput`](#cdktfprovideroktadataoktaauthenticatorpropertyidinput) | `string` | *No description.* |
| [`keyInput`](#cdktfprovideroktadataoktaauthenticatorpropertykeyinput) | `string` | *No description.* |
| [`nameInput`](#cdktfprovideroktadataoktaauthenticatorpropertynameinput) | `string` | *No description.* |
| [`id`](#cdktfprovideroktadataoktaauthenticatorpropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`key`](#cdktfprovideroktadataoktaauthenticatorpropertykey)<span title="Required">*</span> | `string` | *No description.* |
| [`name`](#cdktfprovideroktadataoktaauthenticatorpropertyname)<span title="Required">*</span> | `string` | *No description.* |

---

##### `providerAuthPort`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthenticator.property.providerAuthPort" id="cdktfprovideroktadataoktaauthenticatorpropertyproviderauthport"></a>

```typescript
public readonly providerAuthPort: number;
```

- *Type:* `number`

---

##### `providerHostname`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthenticator.property.providerHostname" id="cdktfprovideroktadataoktaauthenticatorpropertyproviderhostname"></a>

```typescript
public readonly providerHostname: string;
```

- *Type:* `string`

---

##### `providerInstanceId`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthenticator.property.providerInstanceId" id="cdktfprovideroktadataoktaauthenticatorpropertyproviderinstanceid"></a>

```typescript
public readonly providerInstanceId: string;
```

- *Type:* `string`

---

##### `providerType`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthenticator.property.providerType" id="cdktfprovideroktadataoktaauthenticatorpropertyprovidertype"></a>

```typescript
public readonly providerType: string;
```

- *Type:* `string`

---

##### `providerUserNameTemplate`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthenticator.property.providerUserNameTemplate" id="cdktfprovideroktadataoktaauthenticatorpropertyproviderusernametemplate"></a>

```typescript
public readonly providerUserNameTemplate: string;
```

- *Type:* `string`

---

##### `settings`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthenticator.property.settings" id="cdktfprovideroktadataoktaauthenticatorpropertysettings"></a>

```typescript
public readonly settings: string;
```

- *Type:* `string`

---

##### `status`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthenticator.property.status" id="cdktfprovideroktadataoktaauthenticatorpropertystatus"></a>

```typescript
public readonly status: string;
```

- *Type:* `string`

---

##### `type`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthenticator.property.type" id="cdktfprovideroktadataoktaauthenticatorpropertytype"></a>

```typescript
public readonly type: string;
```

- *Type:* `string`

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaAuthenticator.property.idInput" id="cdktfprovideroktadataoktaauthenticatorpropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `keyInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaAuthenticator.property.keyInput" id="cdktfprovideroktadataoktaauthenticatorpropertykeyinput"></a>

```typescript
public readonly keyInput: string;
```

- *Type:* `string`

---

##### `nameInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaAuthenticator.property.nameInput" id="cdktfprovideroktadataoktaauthenticatorpropertynameinput"></a>

```typescript
public readonly nameInput: string;
```

- *Type:* `string`

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthenticator.property.id" id="cdktfprovideroktadataoktaauthenticatorpropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `key`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthenticator.property.key" id="cdktfprovideroktadataoktaauthenticatorpropertykey"></a>

```typescript
public readonly key: string;
```

- *Type:* `string`

---

##### `name`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthenticator.property.name" id="cdktfprovideroktadataoktaauthenticatorpropertyname"></a>

```typescript
public readonly name: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktadataoktaauthenticatorpropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.DataOktaAuthenticator.property.tfResourceType" id="cdktfprovideroktadataoktaauthenticatorpropertytfresourcetype"></a>

- *Type:* `string`

---

### DataOktaAuthServer <a name="@cdktf/provider-okta.DataOktaAuthServer" id="cdktfprovideroktadataoktaauthserver"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/d/auth_server okta_auth_server}.

#### Initializers <a name="@cdktf/provider-okta.DataOktaAuthServer.Initializer" id="cdktfprovideroktadataoktaauthserverinitializer"></a>

```typescript
import { DataOktaAuthServer } from '@cdktf/provider-okta'

new DataOktaAuthServer(scope: Construct, id: string, config: DataOktaAuthServerConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktadataoktaauthserverparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktadataoktaauthserverparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktadataoktaauthserverparameterconfig)<span title="Required">*</span> | [`@cdktf/provider-okta.DataOktaAuthServerConfig`](#@cdktf/provider-okta.DataOktaAuthServerConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthServer.parameter.scope" id="cdktfprovideroktadataoktaauthserverparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthServer.parameter.id" id="cdktfprovideroktadataoktaauthserverparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthServer.parameter.config" id="cdktfprovideroktadataoktaauthserverparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.DataOktaAuthServerConfig`](#@cdktf/provider-okta.DataOktaAuthServerConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`resetId`](#cdktfprovideroktadataoktaauthserverresetid) | *No description.* |

---

##### `resetId` <a name="@cdktf/provider-okta.DataOktaAuthServer.resetId" id="cdktfprovideroktadataoktaauthserverresetid"></a>

```typescript
public resetId()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`audiences`](#cdktfprovideroktadataoktaauthserverpropertyaudiences)<span title="Required">*</span> | `string`[] | *No description.* |
| [`credentialsLastRotated`](#cdktfprovideroktadataoktaauthserverpropertycredentialslastrotated)<span title="Required">*</span> | `string` | *No description.* |
| [`credentialsNextRotation`](#cdktfprovideroktadataoktaauthserverpropertycredentialsnextrotation)<span title="Required">*</span> | `string` | *No description.* |
| [`credentialsRotationMode`](#cdktfprovideroktadataoktaauthserverpropertycredentialsrotationmode)<span title="Required">*</span> | `string` | *No description.* |
| [`description`](#cdktfprovideroktadataoktaauthserverpropertydescription)<span title="Required">*</span> | `string` | *No description.* |
| [`issuer`](#cdktfprovideroktadataoktaauthserverpropertyissuer)<span title="Required">*</span> | `string` | *No description.* |
| [`issuerMode`](#cdktfprovideroktadataoktaauthserverpropertyissuermode)<span title="Required">*</span> | `string` | *No description.* |
| [`kid`](#cdktfprovideroktadataoktaauthserverpropertykid)<span title="Required">*</span> | `string` | *No description.* |
| [`status`](#cdktfprovideroktadataoktaauthserverpropertystatus)<span title="Required">*</span> | `string` | *No description.* |
| [`idInput`](#cdktfprovideroktadataoktaauthserverpropertyidinput) | `string` | *No description.* |
| [`nameInput`](#cdktfprovideroktadataoktaauthserverpropertynameinput) | `string` | *No description.* |
| [`id`](#cdktfprovideroktadataoktaauthserverpropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`name`](#cdktfprovideroktadataoktaauthserverpropertyname)<span title="Required">*</span> | `string` | *No description.* |

---

##### `audiences`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthServer.property.audiences" id="cdktfprovideroktadataoktaauthserverpropertyaudiences"></a>

```typescript
public readonly audiences: string[];
```

- *Type:* `string`[]

---

##### `credentialsLastRotated`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthServer.property.credentialsLastRotated" id="cdktfprovideroktadataoktaauthserverpropertycredentialslastrotated"></a>

```typescript
public readonly credentialsLastRotated: string;
```

- *Type:* `string`

---

##### `credentialsNextRotation`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthServer.property.credentialsNextRotation" id="cdktfprovideroktadataoktaauthserverpropertycredentialsnextrotation"></a>

```typescript
public readonly credentialsNextRotation: string;
```

- *Type:* `string`

---

##### `credentialsRotationMode`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthServer.property.credentialsRotationMode" id="cdktfprovideroktadataoktaauthserverpropertycredentialsrotationmode"></a>

```typescript
public readonly credentialsRotationMode: string;
```

- *Type:* `string`

---

##### `description`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthServer.property.description" id="cdktfprovideroktadataoktaauthserverpropertydescription"></a>

```typescript
public readonly description: string;
```

- *Type:* `string`

---

##### `issuer`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthServer.property.issuer" id="cdktfprovideroktadataoktaauthserverpropertyissuer"></a>

```typescript
public readonly issuer: string;
```

- *Type:* `string`

---

##### `issuerMode`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthServer.property.issuerMode" id="cdktfprovideroktadataoktaauthserverpropertyissuermode"></a>

```typescript
public readonly issuerMode: string;
```

- *Type:* `string`

---

##### `kid`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthServer.property.kid" id="cdktfprovideroktadataoktaauthserverpropertykid"></a>

```typescript
public readonly kid: string;
```

- *Type:* `string`

---

##### `status`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthServer.property.status" id="cdktfprovideroktadataoktaauthserverpropertystatus"></a>

```typescript
public readonly status: string;
```

- *Type:* `string`

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaAuthServer.property.idInput" id="cdktfprovideroktadataoktaauthserverpropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `nameInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaAuthServer.property.nameInput" id="cdktfprovideroktadataoktaauthserverpropertynameinput"></a>

```typescript
public readonly nameInput: string;
```

- *Type:* `string`

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthServer.property.id" id="cdktfprovideroktadataoktaauthserverpropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `name`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthServer.property.name" id="cdktfprovideroktadataoktaauthserverpropertyname"></a>

```typescript
public readonly name: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktadataoktaauthserverpropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.DataOktaAuthServer.property.tfResourceType" id="cdktfprovideroktadataoktaauthserverpropertytfresourcetype"></a>

- *Type:* `string`

---

### DataOktaAuthServerClaim <a name="@cdktf/provider-okta.DataOktaAuthServerClaim" id="cdktfprovideroktadataoktaauthserverclaim"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/d/auth_server_claim okta_auth_server_claim}.

#### Initializers <a name="@cdktf/provider-okta.DataOktaAuthServerClaim.Initializer" id="cdktfprovideroktadataoktaauthserverclaiminitializer"></a>

```typescript
import { DataOktaAuthServerClaim } from '@cdktf/provider-okta'

new DataOktaAuthServerClaim(scope: Construct, id: string, config: DataOktaAuthServerClaimConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktadataoktaauthserverclaimparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktadataoktaauthserverclaimparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktadataoktaauthserverclaimparameterconfig)<span title="Required">*</span> | [`@cdktf/provider-okta.DataOktaAuthServerClaimConfig`](#@cdktf/provider-okta.DataOktaAuthServerClaimConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthServerClaim.parameter.scope" id="cdktfprovideroktadataoktaauthserverclaimparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthServerClaim.parameter.id" id="cdktfprovideroktadataoktaauthserverclaimparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthServerClaim.parameter.config" id="cdktfprovideroktadataoktaauthserverclaimparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.DataOktaAuthServerClaimConfig`](#@cdktf/provider-okta.DataOktaAuthServerClaimConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`resetId`](#cdktfprovideroktadataoktaauthserverclaimresetid) | *No description.* |
| [`resetName`](#cdktfprovideroktadataoktaauthserverclaimresetname) | *No description.* |

---

##### `resetId` <a name="@cdktf/provider-okta.DataOktaAuthServerClaim.resetId" id="cdktfprovideroktadataoktaauthserverclaimresetid"></a>

```typescript
public resetId()
```

##### `resetName` <a name="@cdktf/provider-okta.DataOktaAuthServerClaim.resetName" id="cdktfprovideroktadataoktaauthserverclaimresetname"></a>

```typescript
public resetName()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`alwaysIncludeInToken`](#cdktfprovideroktadataoktaauthserverclaimpropertyalwaysincludeintoken)<span title="Required">*</span> | [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`claimType`](#cdktfprovideroktadataoktaauthserverclaimpropertyclaimtype)<span title="Required">*</span> | `string` | *No description.* |
| [`scopes`](#cdktfprovideroktadataoktaauthserverclaimpropertyscopes)<span title="Required">*</span> | `string`[] | *No description.* |
| [`status`](#cdktfprovideroktadataoktaauthserverclaimpropertystatus)<span title="Required">*</span> | `string` | *No description.* |
| [`value`](#cdktfprovideroktadataoktaauthserverclaimpropertyvalue)<span title="Required">*</span> | `string` | *No description.* |
| [`valueType`](#cdktfprovideroktadataoktaauthserverclaimpropertyvaluetype)<span title="Required">*</span> | `string` | *No description.* |
| [`authServerIdInput`](#cdktfprovideroktadataoktaauthserverclaimpropertyauthserveridinput) | `string` | *No description.* |
| [`idInput`](#cdktfprovideroktadataoktaauthserverclaimpropertyidinput) | `string` | *No description.* |
| [`nameInput`](#cdktfprovideroktadataoktaauthserverclaimpropertynameinput) | `string` | *No description.* |
| [`authServerId`](#cdktfprovideroktadataoktaauthserverclaimpropertyauthserverid)<span title="Required">*</span> | `string` | *No description.* |
| [`id`](#cdktfprovideroktadataoktaauthserverclaimpropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`name`](#cdktfprovideroktadataoktaauthserverclaimpropertyname)<span title="Required">*</span> | `string` | *No description.* |

---

##### `alwaysIncludeInToken`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthServerClaim.property.alwaysIncludeInToken" id="cdktfprovideroktadataoktaauthserverclaimpropertyalwaysincludeintoken"></a>

```typescript
public readonly alwaysIncludeInToken: IResolvable;
```

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `claimType`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthServerClaim.property.claimType" id="cdktfprovideroktadataoktaauthserverclaimpropertyclaimtype"></a>

```typescript
public readonly claimType: string;
```

- *Type:* `string`

---

##### `scopes`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthServerClaim.property.scopes" id="cdktfprovideroktadataoktaauthserverclaimpropertyscopes"></a>

```typescript
public readonly scopes: string[];
```

- *Type:* `string`[]

---

##### `status`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthServerClaim.property.status" id="cdktfprovideroktadataoktaauthserverclaimpropertystatus"></a>

```typescript
public readonly status: string;
```

- *Type:* `string`

---

##### `value`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthServerClaim.property.value" id="cdktfprovideroktadataoktaauthserverclaimpropertyvalue"></a>

```typescript
public readonly value: string;
```

- *Type:* `string`

---

##### `valueType`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthServerClaim.property.valueType" id="cdktfprovideroktadataoktaauthserverclaimpropertyvaluetype"></a>

```typescript
public readonly valueType: string;
```

- *Type:* `string`

---

##### `authServerIdInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaAuthServerClaim.property.authServerIdInput" id="cdktfprovideroktadataoktaauthserverclaimpropertyauthserveridinput"></a>

```typescript
public readonly authServerIdInput: string;
```

- *Type:* `string`

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaAuthServerClaim.property.idInput" id="cdktfprovideroktadataoktaauthserverclaimpropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `nameInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaAuthServerClaim.property.nameInput" id="cdktfprovideroktadataoktaauthserverclaimpropertynameinput"></a>

```typescript
public readonly nameInput: string;
```

- *Type:* `string`

---

##### `authServerId`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthServerClaim.property.authServerId" id="cdktfprovideroktadataoktaauthserverclaimpropertyauthserverid"></a>

```typescript
public readonly authServerId: string;
```

- *Type:* `string`

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthServerClaim.property.id" id="cdktfprovideroktadataoktaauthserverclaimpropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `name`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthServerClaim.property.name" id="cdktfprovideroktadataoktaauthserverclaimpropertyname"></a>

```typescript
public readonly name: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktadataoktaauthserverclaimpropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.DataOktaAuthServerClaim.property.tfResourceType" id="cdktfprovideroktadataoktaauthserverclaimpropertytfresourcetype"></a>

- *Type:* `string`

---

### DataOktaAuthServerClaims <a name="@cdktf/provider-okta.DataOktaAuthServerClaims" id="cdktfprovideroktadataoktaauthserverclaims"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/d/auth_server_claims okta_auth_server_claims}.

#### Initializers <a name="@cdktf/provider-okta.DataOktaAuthServerClaims.Initializer" id="cdktfprovideroktadataoktaauthserverclaimsinitializer"></a>

```typescript
import { DataOktaAuthServerClaims } from '@cdktf/provider-okta'

new DataOktaAuthServerClaims(scope: Construct, id: string, config: DataOktaAuthServerClaimsConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktadataoktaauthserverclaimsparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktadataoktaauthserverclaimsparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktadataoktaauthserverclaimsparameterconfig)<span title="Required">*</span> | [`@cdktf/provider-okta.DataOktaAuthServerClaimsConfig`](#@cdktf/provider-okta.DataOktaAuthServerClaimsConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthServerClaims.parameter.scope" id="cdktfprovideroktadataoktaauthserverclaimsparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthServerClaims.parameter.id" id="cdktfprovideroktadataoktaauthserverclaimsparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthServerClaims.parameter.config" id="cdktfprovideroktadataoktaauthserverclaimsparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.DataOktaAuthServerClaimsConfig`](#@cdktf/provider-okta.DataOktaAuthServerClaimsConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`resetId`](#cdktfprovideroktadataoktaauthserverclaimsresetid) | *No description.* |

---

##### `resetId` <a name="@cdktf/provider-okta.DataOktaAuthServerClaims.resetId" id="cdktfprovideroktadataoktaauthserverclaimsresetid"></a>

```typescript
public resetId()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`claims`](#cdktfprovideroktadataoktaauthserverclaimspropertyclaims)<span title="Required">*</span> | [`@cdktf/provider-okta.DataOktaAuthServerClaimsClaimsList`](#@cdktf/provider-okta.DataOktaAuthServerClaimsClaimsList) | *No description.* |
| [`authServerIdInput`](#cdktfprovideroktadataoktaauthserverclaimspropertyauthserveridinput) | `string` | *No description.* |
| [`idInput`](#cdktfprovideroktadataoktaauthserverclaimspropertyidinput) | `string` | *No description.* |
| [`authServerId`](#cdktfprovideroktadataoktaauthserverclaimspropertyauthserverid)<span title="Required">*</span> | `string` | *No description.* |
| [`id`](#cdktfprovideroktadataoktaauthserverclaimspropertyid)<span title="Required">*</span> | `string` | *No description.* |

---

##### `claims`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthServerClaims.property.claims" id="cdktfprovideroktadataoktaauthserverclaimspropertyclaims"></a>

```typescript
public readonly claims: DataOktaAuthServerClaimsClaimsList;
```

- *Type:* [`@cdktf/provider-okta.DataOktaAuthServerClaimsClaimsList`](#@cdktf/provider-okta.DataOktaAuthServerClaimsClaimsList)

---

##### `authServerIdInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaAuthServerClaims.property.authServerIdInput" id="cdktfprovideroktadataoktaauthserverclaimspropertyauthserveridinput"></a>

```typescript
public readonly authServerIdInput: string;
```

- *Type:* `string`

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaAuthServerClaims.property.idInput" id="cdktfprovideroktadataoktaauthserverclaimspropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `authServerId`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthServerClaims.property.authServerId" id="cdktfprovideroktadataoktaauthserverclaimspropertyauthserverid"></a>

```typescript
public readonly authServerId: string;
```

- *Type:* `string`

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthServerClaims.property.id" id="cdktfprovideroktadataoktaauthserverclaimspropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktadataoktaauthserverclaimspropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.DataOktaAuthServerClaims.property.tfResourceType" id="cdktfprovideroktadataoktaauthserverclaimspropertytfresourcetype"></a>

- *Type:* `string`

---

### DataOktaAuthServerPolicy <a name="@cdktf/provider-okta.DataOktaAuthServerPolicy" id="cdktfprovideroktadataoktaauthserverpolicy"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/d/auth_server_policy okta_auth_server_policy}.

#### Initializers <a name="@cdktf/provider-okta.DataOktaAuthServerPolicy.Initializer" id="cdktfprovideroktadataoktaauthserverpolicyinitializer"></a>

```typescript
import { DataOktaAuthServerPolicy } from '@cdktf/provider-okta'

new DataOktaAuthServerPolicy(scope: Construct, id: string, config: DataOktaAuthServerPolicyConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktadataoktaauthserverpolicyparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktadataoktaauthserverpolicyparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktadataoktaauthserverpolicyparameterconfig)<span title="Required">*</span> | [`@cdktf/provider-okta.DataOktaAuthServerPolicyConfig`](#@cdktf/provider-okta.DataOktaAuthServerPolicyConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthServerPolicy.parameter.scope" id="cdktfprovideroktadataoktaauthserverpolicyparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthServerPolicy.parameter.id" id="cdktfprovideroktadataoktaauthserverpolicyparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthServerPolicy.parameter.config" id="cdktfprovideroktadataoktaauthserverpolicyparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.DataOktaAuthServerPolicyConfig`](#@cdktf/provider-okta.DataOktaAuthServerPolicyConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`resetId`](#cdktfprovideroktadataoktaauthserverpolicyresetid) | *No description.* |

---

##### `resetId` <a name="@cdktf/provider-okta.DataOktaAuthServerPolicy.resetId" id="cdktfprovideroktadataoktaauthserverpolicyresetid"></a>

```typescript
public resetId()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`assignedClients`](#cdktfprovideroktadataoktaauthserverpolicypropertyassignedclients)<span title="Required">*</span> | `string`[] | *No description.* |
| [`description`](#cdktfprovideroktadataoktaauthserverpolicypropertydescription)<span title="Required">*</span> | `string` | *No description.* |
| [`priority`](#cdktfprovideroktadataoktaauthserverpolicypropertypriority)<span title="Required">*</span> | `number` | *No description.* |
| [`authServerIdInput`](#cdktfprovideroktadataoktaauthserverpolicypropertyauthserveridinput) | `string` | *No description.* |
| [`idInput`](#cdktfprovideroktadataoktaauthserverpolicypropertyidinput) | `string` | *No description.* |
| [`nameInput`](#cdktfprovideroktadataoktaauthserverpolicypropertynameinput) | `string` | *No description.* |
| [`authServerId`](#cdktfprovideroktadataoktaauthserverpolicypropertyauthserverid)<span title="Required">*</span> | `string` | *No description.* |
| [`id`](#cdktfprovideroktadataoktaauthserverpolicypropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`name`](#cdktfprovideroktadataoktaauthserverpolicypropertyname)<span title="Required">*</span> | `string` | *No description.* |

---

##### `assignedClients`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthServerPolicy.property.assignedClients" id="cdktfprovideroktadataoktaauthserverpolicypropertyassignedclients"></a>

```typescript
public readonly assignedClients: string[];
```

- *Type:* `string`[]

---

##### `description`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthServerPolicy.property.description" id="cdktfprovideroktadataoktaauthserverpolicypropertydescription"></a>

```typescript
public readonly description: string;
```

- *Type:* `string`

---

##### `priority`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthServerPolicy.property.priority" id="cdktfprovideroktadataoktaauthserverpolicypropertypriority"></a>

```typescript
public readonly priority: number;
```

- *Type:* `number`

---

##### `authServerIdInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaAuthServerPolicy.property.authServerIdInput" id="cdktfprovideroktadataoktaauthserverpolicypropertyauthserveridinput"></a>

```typescript
public readonly authServerIdInput: string;
```

- *Type:* `string`

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaAuthServerPolicy.property.idInput" id="cdktfprovideroktadataoktaauthserverpolicypropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `nameInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaAuthServerPolicy.property.nameInput" id="cdktfprovideroktadataoktaauthserverpolicypropertynameinput"></a>

```typescript
public readonly nameInput: string;
```

- *Type:* `string`

---

##### `authServerId`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthServerPolicy.property.authServerId" id="cdktfprovideroktadataoktaauthserverpolicypropertyauthserverid"></a>

```typescript
public readonly authServerId: string;
```

- *Type:* `string`

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthServerPolicy.property.id" id="cdktfprovideroktadataoktaauthserverpolicypropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `name`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthServerPolicy.property.name" id="cdktfprovideroktadataoktaauthserverpolicypropertyname"></a>

```typescript
public readonly name: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktadataoktaauthserverpolicypropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.DataOktaAuthServerPolicy.property.tfResourceType" id="cdktfprovideroktadataoktaauthserverpolicypropertytfresourcetype"></a>

- *Type:* `string`

---

### DataOktaAuthServerScopes <a name="@cdktf/provider-okta.DataOktaAuthServerScopes" id="cdktfprovideroktadataoktaauthserverscopes"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/d/auth_server_scopes okta_auth_server_scopes}.

#### Initializers <a name="@cdktf/provider-okta.DataOktaAuthServerScopes.Initializer" id="cdktfprovideroktadataoktaauthserverscopesinitializer"></a>

```typescript
import { DataOktaAuthServerScopes } from '@cdktf/provider-okta'

new DataOktaAuthServerScopes(scope: Construct, id: string, config: DataOktaAuthServerScopesConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktadataoktaauthserverscopesparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktadataoktaauthserverscopesparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktadataoktaauthserverscopesparameterconfig)<span title="Required">*</span> | [`@cdktf/provider-okta.DataOktaAuthServerScopesConfig`](#@cdktf/provider-okta.DataOktaAuthServerScopesConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthServerScopes.parameter.scope" id="cdktfprovideroktadataoktaauthserverscopesparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthServerScopes.parameter.id" id="cdktfprovideroktadataoktaauthserverscopesparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthServerScopes.parameter.config" id="cdktfprovideroktadataoktaauthserverscopesparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.DataOktaAuthServerScopesConfig`](#@cdktf/provider-okta.DataOktaAuthServerScopesConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`resetId`](#cdktfprovideroktadataoktaauthserverscopesresetid) | *No description.* |

---

##### `resetId` <a name="@cdktf/provider-okta.DataOktaAuthServerScopes.resetId" id="cdktfprovideroktadataoktaauthserverscopesresetid"></a>

```typescript
public resetId()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scopes`](#cdktfprovideroktadataoktaauthserverscopespropertyscopes)<span title="Required">*</span> | [`@cdktf/provider-okta.DataOktaAuthServerScopesScopesList`](#@cdktf/provider-okta.DataOktaAuthServerScopesScopesList) | *No description.* |
| [`authServerIdInput`](#cdktfprovideroktadataoktaauthserverscopespropertyauthserveridinput) | `string` | *No description.* |
| [`idInput`](#cdktfprovideroktadataoktaauthserverscopespropertyidinput) | `string` | *No description.* |
| [`authServerId`](#cdktfprovideroktadataoktaauthserverscopespropertyauthserverid)<span title="Required">*</span> | `string` | *No description.* |
| [`id`](#cdktfprovideroktadataoktaauthserverscopespropertyid)<span title="Required">*</span> | `string` | *No description.* |

---

##### `scopes`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthServerScopes.property.scopes" id="cdktfprovideroktadataoktaauthserverscopespropertyscopes"></a>

```typescript
public readonly scopes: DataOktaAuthServerScopesScopesList;
```

- *Type:* [`@cdktf/provider-okta.DataOktaAuthServerScopesScopesList`](#@cdktf/provider-okta.DataOktaAuthServerScopesScopesList)

---

##### `authServerIdInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaAuthServerScopes.property.authServerIdInput" id="cdktfprovideroktadataoktaauthserverscopespropertyauthserveridinput"></a>

```typescript
public readonly authServerIdInput: string;
```

- *Type:* `string`

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaAuthServerScopes.property.idInput" id="cdktfprovideroktadataoktaauthserverscopespropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `authServerId`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthServerScopes.property.authServerId" id="cdktfprovideroktadataoktaauthserverscopespropertyauthserverid"></a>

```typescript
public readonly authServerId: string;
```

- *Type:* `string`

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaAuthServerScopes.property.id" id="cdktfprovideroktadataoktaauthserverscopespropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktadataoktaauthserverscopespropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.DataOktaAuthServerScopes.property.tfResourceType" id="cdktfprovideroktadataoktaauthserverscopespropertytfresourcetype"></a>

- *Type:* `string`

---

### DataOktaBehavior <a name="@cdktf/provider-okta.DataOktaBehavior" id="cdktfprovideroktadataoktabehavior"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/d/behavior okta_behavior}.

#### Initializers <a name="@cdktf/provider-okta.DataOktaBehavior.Initializer" id="cdktfprovideroktadataoktabehaviorinitializer"></a>

```typescript
import { DataOktaBehavior } from '@cdktf/provider-okta'

new DataOktaBehavior(scope: Construct, id: string, config?: DataOktaBehaviorConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktadataoktabehaviorparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktadataoktabehaviorparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktadataoktabehaviorparameterconfig) | [`@cdktf/provider-okta.DataOktaBehaviorConfig`](#@cdktf/provider-okta.DataOktaBehaviorConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaBehavior.parameter.scope" id="cdktfprovideroktadataoktabehaviorparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaBehavior.parameter.id" id="cdktfprovideroktadataoktabehaviorparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaBehavior.parameter.config" id="cdktfprovideroktadataoktabehaviorparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.DataOktaBehaviorConfig`](#@cdktf/provider-okta.DataOktaBehaviorConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`resetId`](#cdktfprovideroktadataoktabehaviorresetid) | *No description.* |
| [`resetName`](#cdktfprovideroktadataoktabehaviorresetname) | *No description.* |

---

##### `resetId` <a name="@cdktf/provider-okta.DataOktaBehavior.resetId" id="cdktfprovideroktadataoktabehaviorresetid"></a>

```typescript
public resetId()
```

##### `resetName` <a name="@cdktf/provider-okta.DataOktaBehavior.resetName" id="cdktfprovideroktadataoktabehaviorresetname"></a>

```typescript
public resetName()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`settings`](#cdktfprovideroktadataoktabehaviorpropertysettings)<span title="Required">*</span> | [`cdktf.StringMap`](#cdktf.StringMap) | *No description.* |
| [`status`](#cdktfprovideroktadataoktabehaviorpropertystatus)<span title="Required">*</span> | `string` | *No description.* |
| [`type`](#cdktfprovideroktadataoktabehaviorpropertytype)<span title="Required">*</span> | `string` | *No description.* |
| [`idInput`](#cdktfprovideroktadataoktabehaviorpropertyidinput) | `string` | *No description.* |
| [`nameInput`](#cdktfprovideroktadataoktabehaviorpropertynameinput) | `string` | *No description.* |
| [`id`](#cdktfprovideroktadataoktabehaviorpropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`name`](#cdktfprovideroktadataoktabehaviorpropertyname)<span title="Required">*</span> | `string` | *No description.* |

---

##### `settings`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaBehavior.property.settings" id="cdktfprovideroktadataoktabehaviorpropertysettings"></a>

```typescript
public readonly settings: StringMap;
```

- *Type:* [`cdktf.StringMap`](#cdktf.StringMap)

---

##### `status`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaBehavior.property.status" id="cdktfprovideroktadataoktabehaviorpropertystatus"></a>

```typescript
public readonly status: string;
```

- *Type:* `string`

---

##### `type`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaBehavior.property.type" id="cdktfprovideroktadataoktabehaviorpropertytype"></a>

```typescript
public readonly type: string;
```

- *Type:* `string`

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaBehavior.property.idInput" id="cdktfprovideroktadataoktabehaviorpropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `nameInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaBehavior.property.nameInput" id="cdktfprovideroktadataoktabehaviorpropertynameinput"></a>

```typescript
public readonly nameInput: string;
```

- *Type:* `string`

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaBehavior.property.id" id="cdktfprovideroktadataoktabehaviorpropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `name`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaBehavior.property.name" id="cdktfprovideroktadataoktabehaviorpropertyname"></a>

```typescript
public readonly name: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktadataoktabehaviorpropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.DataOktaBehavior.property.tfResourceType" id="cdktfprovideroktadataoktabehaviorpropertytfresourcetype"></a>

- *Type:* `string`

---

### DataOktaBehaviors <a name="@cdktf/provider-okta.DataOktaBehaviors" id="cdktfprovideroktadataoktabehaviors"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/d/behaviors okta_behaviors}.

#### Initializers <a name="@cdktf/provider-okta.DataOktaBehaviors.Initializer" id="cdktfprovideroktadataoktabehaviorsinitializer"></a>

```typescript
import { DataOktaBehaviors } from '@cdktf/provider-okta'

new DataOktaBehaviors(scope: Construct, id: string, config?: DataOktaBehaviorsConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktadataoktabehaviorsparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktadataoktabehaviorsparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktadataoktabehaviorsparameterconfig) | [`@cdktf/provider-okta.DataOktaBehaviorsConfig`](#@cdktf/provider-okta.DataOktaBehaviorsConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaBehaviors.parameter.scope" id="cdktfprovideroktadataoktabehaviorsparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaBehaviors.parameter.id" id="cdktfprovideroktadataoktabehaviorsparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaBehaviors.parameter.config" id="cdktfprovideroktadataoktabehaviorsparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.DataOktaBehaviorsConfig`](#@cdktf/provider-okta.DataOktaBehaviorsConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`resetId`](#cdktfprovideroktadataoktabehaviorsresetid) | *No description.* |
| [`resetQ`](#cdktfprovideroktadataoktabehaviorsresetq) | *No description.* |

---

##### `resetId` <a name="@cdktf/provider-okta.DataOktaBehaviors.resetId" id="cdktfprovideroktadataoktabehaviorsresetid"></a>

```typescript
public resetId()
```

##### `resetQ` <a name="@cdktf/provider-okta.DataOktaBehaviors.resetQ" id="cdktfprovideroktadataoktabehaviorsresetq"></a>

```typescript
public resetQ()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`behaviors`](#cdktfprovideroktadataoktabehaviorspropertybehaviors)<span title="Required">*</span> | [`@cdktf/provider-okta.DataOktaBehaviorsBehaviorsList`](#@cdktf/provider-okta.DataOktaBehaviorsBehaviorsList) | *No description.* |
| [`idInput`](#cdktfprovideroktadataoktabehaviorspropertyidinput) | `string` | *No description.* |
| [`qInput`](#cdktfprovideroktadataoktabehaviorspropertyqinput) | `string` | *No description.* |
| [`id`](#cdktfprovideroktadataoktabehaviorspropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`q`](#cdktfprovideroktadataoktabehaviorspropertyq)<span title="Required">*</span> | `string` | *No description.* |

---

##### `behaviors`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaBehaviors.property.behaviors" id="cdktfprovideroktadataoktabehaviorspropertybehaviors"></a>

```typescript
public readonly behaviors: DataOktaBehaviorsBehaviorsList;
```

- *Type:* [`@cdktf/provider-okta.DataOktaBehaviorsBehaviorsList`](#@cdktf/provider-okta.DataOktaBehaviorsBehaviorsList)

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaBehaviors.property.idInput" id="cdktfprovideroktadataoktabehaviorspropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `qInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaBehaviors.property.qInput" id="cdktfprovideroktadataoktabehaviorspropertyqinput"></a>

```typescript
public readonly qInput: string;
```

- *Type:* `string`

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaBehaviors.property.id" id="cdktfprovideroktadataoktabehaviorspropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `q`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaBehaviors.property.q" id="cdktfprovideroktadataoktabehaviorspropertyq"></a>

```typescript
public readonly q: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktadataoktabehaviorspropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.DataOktaBehaviors.property.tfResourceType" id="cdktfprovideroktadataoktabehaviorspropertytfresourcetype"></a>

- *Type:* `string`

---

### DataOktaBrand <a name="@cdktf/provider-okta.DataOktaBrand" id="cdktfprovideroktadataoktabrand"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/d/brand okta_brand}.

#### Initializers <a name="@cdktf/provider-okta.DataOktaBrand.Initializer" id="cdktfprovideroktadataoktabrandinitializer"></a>

```typescript
import { DataOktaBrand } from '@cdktf/provider-okta'

new DataOktaBrand(scope: Construct, id: string, config: DataOktaBrandConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktadataoktabrandparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktadataoktabrandparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktadataoktabrandparameterconfig)<span title="Required">*</span> | [`@cdktf/provider-okta.DataOktaBrandConfig`](#@cdktf/provider-okta.DataOktaBrandConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaBrand.parameter.scope" id="cdktfprovideroktadataoktabrandparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaBrand.parameter.id" id="cdktfprovideroktadataoktabrandparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaBrand.parameter.config" id="cdktfprovideroktadataoktabrandparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.DataOktaBrandConfig`](#@cdktf/provider-okta.DataOktaBrandConfig)

---



#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`customPrivacyPolicyUrl`](#cdktfprovideroktadataoktabrandpropertycustomprivacypolicyurl)<span title="Required">*</span> | `string` | *No description.* |
| [`id`](#cdktfprovideroktadataoktabrandpropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`links`](#cdktfprovideroktadataoktabrandpropertylinks)<span title="Required">*</span> | `string` | *No description.* |
| [`removePoweredByOkta`](#cdktfprovideroktadataoktabrandpropertyremovepoweredbyokta)<span title="Required">*</span> | [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`brandIdInput`](#cdktfprovideroktadataoktabrandpropertybrandidinput) | `string` | *No description.* |
| [`brandId`](#cdktfprovideroktadataoktabrandpropertybrandid)<span title="Required">*</span> | `string` | *No description.* |

---

##### `customPrivacyPolicyUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaBrand.property.customPrivacyPolicyUrl" id="cdktfprovideroktadataoktabrandpropertycustomprivacypolicyurl"></a>

```typescript
public readonly customPrivacyPolicyUrl: string;
```

- *Type:* `string`

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaBrand.property.id" id="cdktfprovideroktadataoktabrandpropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `links`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaBrand.property.links" id="cdktfprovideroktadataoktabrandpropertylinks"></a>

```typescript
public readonly links: string;
```

- *Type:* `string`

---

##### `removePoweredByOkta`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaBrand.property.removePoweredByOkta" id="cdktfprovideroktadataoktabrandpropertyremovepoweredbyokta"></a>

```typescript
public readonly removePoweredByOkta: IResolvable;
```

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `brandIdInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaBrand.property.brandIdInput" id="cdktfprovideroktadataoktabrandpropertybrandidinput"></a>

```typescript
public readonly brandIdInput: string;
```

- *Type:* `string`

---

##### `brandId`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaBrand.property.brandId" id="cdktfprovideroktadataoktabrandpropertybrandid"></a>

```typescript
public readonly brandId: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktadataoktabrandpropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.DataOktaBrand.property.tfResourceType" id="cdktfprovideroktadataoktabrandpropertytfresourcetype"></a>

- *Type:* `string`

---

### DataOktaBrands <a name="@cdktf/provider-okta.DataOktaBrands" id="cdktfprovideroktadataoktabrands"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/d/brands okta_brands}.

#### Initializers <a name="@cdktf/provider-okta.DataOktaBrands.Initializer" id="cdktfprovideroktadataoktabrandsinitializer"></a>

```typescript
import { DataOktaBrands } from '@cdktf/provider-okta'

new DataOktaBrands(scope: Construct, id: string, config?: DataOktaBrandsConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktadataoktabrandsparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktadataoktabrandsparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktadataoktabrandsparameterconfig) | [`@cdktf/provider-okta.DataOktaBrandsConfig`](#@cdktf/provider-okta.DataOktaBrandsConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaBrands.parameter.scope" id="cdktfprovideroktadataoktabrandsparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaBrands.parameter.id" id="cdktfprovideroktadataoktabrandsparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaBrands.parameter.config" id="cdktfprovideroktadataoktabrandsparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.DataOktaBrandsConfig`](#@cdktf/provider-okta.DataOktaBrandsConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`resetId`](#cdktfprovideroktadataoktabrandsresetid) | *No description.* |

---

##### `resetId` <a name="@cdktf/provider-okta.DataOktaBrands.resetId" id="cdktfprovideroktadataoktabrandsresetid"></a>

```typescript
public resetId()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`brands`](#cdktfprovideroktadataoktabrandspropertybrands)<span title="Required">*</span> | [`@cdktf/provider-okta.DataOktaBrandsBrandsList`](#@cdktf/provider-okta.DataOktaBrandsBrandsList) | *No description.* |
| [`idInput`](#cdktfprovideroktadataoktabrandspropertyidinput) | `string` | *No description.* |
| [`id`](#cdktfprovideroktadataoktabrandspropertyid)<span title="Required">*</span> | `string` | *No description.* |

---

##### `brands`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaBrands.property.brands" id="cdktfprovideroktadataoktabrandspropertybrands"></a>

```typescript
public readonly brands: DataOktaBrandsBrandsList;
```

- *Type:* [`@cdktf/provider-okta.DataOktaBrandsBrandsList`](#@cdktf/provider-okta.DataOktaBrandsBrandsList)

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaBrands.property.idInput" id="cdktfprovideroktadataoktabrandspropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaBrands.property.id" id="cdktfprovideroktadataoktabrandspropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktadataoktabrandspropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.DataOktaBrands.property.tfResourceType" id="cdktfprovideroktadataoktabrandspropertytfresourcetype"></a>

- *Type:* `string`

---

### DataOktaDefaultPolicies <a name="@cdktf/provider-okta.DataOktaDefaultPolicies" id="cdktfprovideroktadataoktadefaultpolicies"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/d/default_policies okta_default_policies}.

#### Initializers <a name="@cdktf/provider-okta.DataOktaDefaultPolicies.Initializer" id="cdktfprovideroktadataoktadefaultpoliciesinitializer"></a>

```typescript
import { DataOktaDefaultPolicies } from '@cdktf/provider-okta'

new DataOktaDefaultPolicies(scope: Construct, id: string, config: DataOktaDefaultPoliciesConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktadataoktadefaultpoliciesparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktadataoktadefaultpoliciesparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktadataoktadefaultpoliciesparameterconfig)<span title="Required">*</span> | [`@cdktf/provider-okta.DataOktaDefaultPoliciesConfig`](#@cdktf/provider-okta.DataOktaDefaultPoliciesConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaDefaultPolicies.parameter.scope" id="cdktfprovideroktadataoktadefaultpoliciesparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaDefaultPolicies.parameter.id" id="cdktfprovideroktadataoktadefaultpoliciesparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaDefaultPolicies.parameter.config" id="cdktfprovideroktadataoktadefaultpoliciesparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.DataOktaDefaultPoliciesConfig`](#@cdktf/provider-okta.DataOktaDefaultPoliciesConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`resetId`](#cdktfprovideroktadataoktadefaultpoliciesresetid) | *No description.* |

---

##### `resetId` <a name="@cdktf/provider-okta.DataOktaDefaultPolicies.resetId" id="cdktfprovideroktadataoktadefaultpoliciesresetid"></a>

```typescript
public resetId()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`idInput`](#cdktfprovideroktadataoktadefaultpoliciespropertyidinput) | `string` | *No description.* |
| [`typeInput`](#cdktfprovideroktadataoktadefaultpoliciespropertytypeinput) | `string` | *No description.* |
| [`id`](#cdktfprovideroktadataoktadefaultpoliciespropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`type`](#cdktfprovideroktadataoktadefaultpoliciespropertytype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaDefaultPolicies.property.idInput" id="cdktfprovideroktadataoktadefaultpoliciespropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `typeInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaDefaultPolicies.property.typeInput" id="cdktfprovideroktadataoktadefaultpoliciespropertytypeinput"></a>

```typescript
public readonly typeInput: string;
```

- *Type:* `string`

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaDefaultPolicies.property.id" id="cdktfprovideroktadataoktadefaultpoliciespropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `type`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaDefaultPolicies.property.type" id="cdktfprovideroktadataoktadefaultpoliciespropertytype"></a>

```typescript
public readonly type: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktadataoktadefaultpoliciespropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.DataOktaDefaultPolicies.property.tfResourceType" id="cdktfprovideroktadataoktadefaultpoliciespropertytfresourcetype"></a>

- *Type:* `string`

---

### DataOktaDefaultPolicy <a name="@cdktf/provider-okta.DataOktaDefaultPolicy" id="cdktfprovideroktadataoktadefaultpolicy"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/d/default_policy okta_default_policy}.

#### Initializers <a name="@cdktf/provider-okta.DataOktaDefaultPolicy.Initializer" id="cdktfprovideroktadataoktadefaultpolicyinitializer"></a>

```typescript
import { DataOktaDefaultPolicy } from '@cdktf/provider-okta'

new DataOktaDefaultPolicy(scope: Construct, id: string, config: DataOktaDefaultPolicyConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktadataoktadefaultpolicyparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktadataoktadefaultpolicyparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktadataoktadefaultpolicyparameterconfig)<span title="Required">*</span> | [`@cdktf/provider-okta.DataOktaDefaultPolicyConfig`](#@cdktf/provider-okta.DataOktaDefaultPolicyConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaDefaultPolicy.parameter.scope" id="cdktfprovideroktadataoktadefaultpolicyparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaDefaultPolicy.parameter.id" id="cdktfprovideroktadataoktadefaultpolicyparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaDefaultPolicy.parameter.config" id="cdktfprovideroktadataoktadefaultpolicyparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.DataOktaDefaultPolicyConfig`](#@cdktf/provider-okta.DataOktaDefaultPolicyConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`resetId`](#cdktfprovideroktadataoktadefaultpolicyresetid) | *No description.* |

---

##### `resetId` <a name="@cdktf/provider-okta.DataOktaDefaultPolicy.resetId" id="cdktfprovideroktadataoktadefaultpolicyresetid"></a>

```typescript
public resetId()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`idInput`](#cdktfprovideroktadataoktadefaultpolicypropertyidinput) | `string` | *No description.* |
| [`typeInput`](#cdktfprovideroktadataoktadefaultpolicypropertytypeinput) | `string` | *No description.* |
| [`id`](#cdktfprovideroktadataoktadefaultpolicypropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`type`](#cdktfprovideroktadataoktadefaultpolicypropertytype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaDefaultPolicy.property.idInput" id="cdktfprovideroktadataoktadefaultpolicypropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `typeInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaDefaultPolicy.property.typeInput" id="cdktfprovideroktadataoktadefaultpolicypropertytypeinput"></a>

```typescript
public readonly typeInput: string;
```

- *Type:* `string`

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaDefaultPolicy.property.id" id="cdktfprovideroktadataoktadefaultpolicypropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `type`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaDefaultPolicy.property.type" id="cdktfprovideroktadataoktadefaultpolicypropertytype"></a>

```typescript
public readonly type: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktadataoktadefaultpolicypropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.DataOktaDefaultPolicy.property.tfResourceType" id="cdktfprovideroktadataoktadefaultpolicypropertytfresourcetype"></a>

- *Type:* `string`

---

### DataOktaEmailCustomization <a name="@cdktf/provider-okta.DataOktaEmailCustomization" id="cdktfprovideroktadataoktaemailcustomization"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/d/email_customization okta_email_customization}.

#### Initializers <a name="@cdktf/provider-okta.DataOktaEmailCustomization.Initializer" id="cdktfprovideroktadataoktaemailcustomizationinitializer"></a>

```typescript
import { DataOktaEmailCustomization } from '@cdktf/provider-okta'

new DataOktaEmailCustomization(scope: Construct, id: string, config: DataOktaEmailCustomizationConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktadataoktaemailcustomizationparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktadataoktaemailcustomizationparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktadataoktaemailcustomizationparameterconfig)<span title="Required">*</span> | [`@cdktf/provider-okta.DataOktaEmailCustomizationConfig`](#@cdktf/provider-okta.DataOktaEmailCustomizationConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaEmailCustomization.parameter.scope" id="cdktfprovideroktadataoktaemailcustomizationparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaEmailCustomization.parameter.id" id="cdktfprovideroktadataoktaemailcustomizationparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaEmailCustomization.parameter.config" id="cdktfprovideroktadataoktaemailcustomizationparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.DataOktaEmailCustomizationConfig`](#@cdktf/provider-okta.DataOktaEmailCustomizationConfig)

---



#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`body`](#cdktfprovideroktadataoktaemailcustomizationpropertybody)<span title="Required">*</span> | `string` | *No description.* |
| [`id`](#cdktfprovideroktadataoktaemailcustomizationpropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`isDefault`](#cdktfprovideroktadataoktaemailcustomizationpropertyisdefault)<span title="Required">*</span> | [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`language`](#cdktfprovideroktadataoktaemailcustomizationpropertylanguage)<span title="Required">*</span> | `string` | *No description.* |
| [`links`](#cdktfprovideroktadataoktaemailcustomizationpropertylinks)<span title="Required">*</span> | `string` | *No description.* |
| [`subject`](#cdktfprovideroktadataoktaemailcustomizationpropertysubject)<span title="Required">*</span> | `string` | *No description.* |
| [`brandIdInput`](#cdktfprovideroktadataoktaemailcustomizationpropertybrandidinput) | `string` | *No description.* |
| [`customizationIdInput`](#cdktfprovideroktadataoktaemailcustomizationpropertycustomizationidinput) | `string` | *No description.* |
| [`templateNameInput`](#cdktfprovideroktadataoktaemailcustomizationpropertytemplatenameinput) | `string` | *No description.* |
| [`brandId`](#cdktfprovideroktadataoktaemailcustomizationpropertybrandid)<span title="Required">*</span> | `string` | *No description.* |
| [`customizationId`](#cdktfprovideroktadataoktaemailcustomizationpropertycustomizationid)<span title="Required">*</span> | `string` | *No description.* |
| [`templateName`](#cdktfprovideroktadataoktaemailcustomizationpropertytemplatename)<span title="Required">*</span> | `string` | *No description.* |

---

##### `body`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaEmailCustomization.property.body" id="cdktfprovideroktadataoktaemailcustomizationpropertybody"></a>

```typescript
public readonly body: string;
```

- *Type:* `string`

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaEmailCustomization.property.id" id="cdktfprovideroktadataoktaemailcustomizationpropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `isDefault`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaEmailCustomization.property.isDefault" id="cdktfprovideroktadataoktaemailcustomizationpropertyisdefault"></a>

```typescript
public readonly isDefault: IResolvable;
```

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `language`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaEmailCustomization.property.language" id="cdktfprovideroktadataoktaemailcustomizationpropertylanguage"></a>

```typescript
public readonly language: string;
```

- *Type:* `string`

---

##### `links`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaEmailCustomization.property.links" id="cdktfprovideroktadataoktaemailcustomizationpropertylinks"></a>

```typescript
public readonly links: string;
```

- *Type:* `string`

---

##### `subject`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaEmailCustomization.property.subject" id="cdktfprovideroktadataoktaemailcustomizationpropertysubject"></a>

```typescript
public readonly subject: string;
```

- *Type:* `string`

---

##### `brandIdInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaEmailCustomization.property.brandIdInput" id="cdktfprovideroktadataoktaemailcustomizationpropertybrandidinput"></a>

```typescript
public readonly brandIdInput: string;
```

- *Type:* `string`

---

##### `customizationIdInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaEmailCustomization.property.customizationIdInput" id="cdktfprovideroktadataoktaemailcustomizationpropertycustomizationidinput"></a>

```typescript
public readonly customizationIdInput: string;
```

- *Type:* `string`

---

##### `templateNameInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaEmailCustomization.property.templateNameInput" id="cdktfprovideroktadataoktaemailcustomizationpropertytemplatenameinput"></a>

```typescript
public readonly templateNameInput: string;
```

- *Type:* `string`

---

##### `brandId`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaEmailCustomization.property.brandId" id="cdktfprovideroktadataoktaemailcustomizationpropertybrandid"></a>

```typescript
public readonly brandId: string;
```

- *Type:* `string`

---

##### `customizationId`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaEmailCustomization.property.customizationId" id="cdktfprovideroktadataoktaemailcustomizationpropertycustomizationid"></a>

```typescript
public readonly customizationId: string;
```

- *Type:* `string`

---

##### `templateName`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaEmailCustomization.property.templateName" id="cdktfprovideroktadataoktaemailcustomizationpropertytemplatename"></a>

```typescript
public readonly templateName: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktadataoktaemailcustomizationpropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.DataOktaEmailCustomization.property.tfResourceType" id="cdktfprovideroktadataoktaemailcustomizationpropertytfresourcetype"></a>

- *Type:* `string`

---

### DataOktaEmailCustomizations <a name="@cdktf/provider-okta.DataOktaEmailCustomizations" id="cdktfprovideroktadataoktaemailcustomizations"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/d/email_customizations okta_email_customizations}.

#### Initializers <a name="@cdktf/provider-okta.DataOktaEmailCustomizations.Initializer" id="cdktfprovideroktadataoktaemailcustomizationsinitializer"></a>

```typescript
import { DataOktaEmailCustomizations } from '@cdktf/provider-okta'

new DataOktaEmailCustomizations(scope: Construct, id: string, config: DataOktaEmailCustomizationsConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktadataoktaemailcustomizationsparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktadataoktaemailcustomizationsparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktadataoktaemailcustomizationsparameterconfig)<span title="Required">*</span> | [`@cdktf/provider-okta.DataOktaEmailCustomizationsConfig`](#@cdktf/provider-okta.DataOktaEmailCustomizationsConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaEmailCustomizations.parameter.scope" id="cdktfprovideroktadataoktaemailcustomizationsparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaEmailCustomizations.parameter.id" id="cdktfprovideroktadataoktaemailcustomizationsparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaEmailCustomizations.parameter.config" id="cdktfprovideroktadataoktaemailcustomizationsparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.DataOktaEmailCustomizationsConfig`](#@cdktf/provider-okta.DataOktaEmailCustomizationsConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`resetId`](#cdktfprovideroktadataoktaemailcustomizationsresetid) | *No description.* |

---

##### `resetId` <a name="@cdktf/provider-okta.DataOktaEmailCustomizations.resetId" id="cdktfprovideroktadataoktaemailcustomizationsresetid"></a>

```typescript
public resetId()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`emailCustomizations`](#cdktfprovideroktadataoktaemailcustomizationspropertyemailcustomizations)<span title="Required">*</span> | [`@cdktf/provider-okta.DataOktaEmailCustomizationsEmailCustomizationsList`](#@cdktf/provider-okta.DataOktaEmailCustomizationsEmailCustomizationsList) | *No description.* |
| [`brandIdInput`](#cdktfprovideroktadataoktaemailcustomizationspropertybrandidinput) | `string` | *No description.* |
| [`idInput`](#cdktfprovideroktadataoktaemailcustomizationspropertyidinput) | `string` | *No description.* |
| [`templateNameInput`](#cdktfprovideroktadataoktaemailcustomizationspropertytemplatenameinput) | `string` | *No description.* |
| [`brandId`](#cdktfprovideroktadataoktaemailcustomizationspropertybrandid)<span title="Required">*</span> | `string` | *No description.* |
| [`id`](#cdktfprovideroktadataoktaemailcustomizationspropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`templateName`](#cdktfprovideroktadataoktaemailcustomizationspropertytemplatename)<span title="Required">*</span> | `string` | *No description.* |

---

##### `emailCustomizations`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaEmailCustomizations.property.emailCustomizations" id="cdktfprovideroktadataoktaemailcustomizationspropertyemailcustomizations"></a>

```typescript
public readonly emailCustomizations: DataOktaEmailCustomizationsEmailCustomizationsList;
```

- *Type:* [`@cdktf/provider-okta.DataOktaEmailCustomizationsEmailCustomizationsList`](#@cdktf/provider-okta.DataOktaEmailCustomizationsEmailCustomizationsList)

---

##### `brandIdInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaEmailCustomizations.property.brandIdInput" id="cdktfprovideroktadataoktaemailcustomizationspropertybrandidinput"></a>

```typescript
public readonly brandIdInput: string;
```

- *Type:* `string`

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaEmailCustomizations.property.idInput" id="cdktfprovideroktadataoktaemailcustomizationspropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `templateNameInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaEmailCustomizations.property.templateNameInput" id="cdktfprovideroktadataoktaemailcustomizationspropertytemplatenameinput"></a>

```typescript
public readonly templateNameInput: string;
```

- *Type:* `string`

---

##### `brandId`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaEmailCustomizations.property.brandId" id="cdktfprovideroktadataoktaemailcustomizationspropertybrandid"></a>

```typescript
public readonly brandId: string;
```

- *Type:* `string`

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaEmailCustomizations.property.id" id="cdktfprovideroktadataoktaemailcustomizationspropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `templateName`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaEmailCustomizations.property.templateName" id="cdktfprovideroktadataoktaemailcustomizationspropertytemplatename"></a>

```typescript
public readonly templateName: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktadataoktaemailcustomizationspropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.DataOktaEmailCustomizations.property.tfResourceType" id="cdktfprovideroktadataoktaemailcustomizationspropertytfresourcetype"></a>

- *Type:* `string`

---

### DataOktaEmailTemplate <a name="@cdktf/provider-okta.DataOktaEmailTemplate" id="cdktfprovideroktadataoktaemailtemplate"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/d/email_template okta_email_template}.

#### Initializers <a name="@cdktf/provider-okta.DataOktaEmailTemplate.Initializer" id="cdktfprovideroktadataoktaemailtemplateinitializer"></a>

```typescript
import { DataOktaEmailTemplate } from '@cdktf/provider-okta'

new DataOktaEmailTemplate(scope: Construct, id: string, config: DataOktaEmailTemplateConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktadataoktaemailtemplateparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktadataoktaemailtemplateparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktadataoktaemailtemplateparameterconfig)<span title="Required">*</span> | [`@cdktf/provider-okta.DataOktaEmailTemplateConfig`](#@cdktf/provider-okta.DataOktaEmailTemplateConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaEmailTemplate.parameter.scope" id="cdktfprovideroktadataoktaemailtemplateparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaEmailTemplate.parameter.id" id="cdktfprovideroktadataoktaemailtemplateparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaEmailTemplate.parameter.config" id="cdktfprovideroktadataoktaemailtemplateparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.DataOktaEmailTemplateConfig`](#@cdktf/provider-okta.DataOktaEmailTemplateConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`resetId`](#cdktfprovideroktadataoktaemailtemplateresetid) | *No description.* |

---

##### `resetId` <a name="@cdktf/provider-okta.DataOktaEmailTemplate.resetId" id="cdktfprovideroktadataoktaemailtemplateresetid"></a>

```typescript
public resetId()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`links`](#cdktfprovideroktadataoktaemailtemplatepropertylinks)<span title="Required">*</span> | `string` | *No description.* |
| [`brandIdInput`](#cdktfprovideroktadataoktaemailtemplatepropertybrandidinput) | `string` | *No description.* |
| [`idInput`](#cdktfprovideroktadataoktaemailtemplatepropertyidinput) | `string` | *No description.* |
| [`nameInput`](#cdktfprovideroktadataoktaemailtemplatepropertynameinput) | `string` | *No description.* |
| [`brandId`](#cdktfprovideroktadataoktaemailtemplatepropertybrandid)<span title="Required">*</span> | `string` | *No description.* |
| [`id`](#cdktfprovideroktadataoktaemailtemplatepropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`name`](#cdktfprovideroktadataoktaemailtemplatepropertyname)<span title="Required">*</span> | `string` | *No description.* |

---

##### `links`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaEmailTemplate.property.links" id="cdktfprovideroktadataoktaemailtemplatepropertylinks"></a>

```typescript
public readonly links: string;
```

- *Type:* `string`

---

##### `brandIdInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaEmailTemplate.property.brandIdInput" id="cdktfprovideroktadataoktaemailtemplatepropertybrandidinput"></a>

```typescript
public readonly brandIdInput: string;
```

- *Type:* `string`

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaEmailTemplate.property.idInput" id="cdktfprovideroktadataoktaemailtemplatepropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `nameInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaEmailTemplate.property.nameInput" id="cdktfprovideroktadataoktaemailtemplatepropertynameinput"></a>

```typescript
public readonly nameInput: string;
```

- *Type:* `string`

---

##### `brandId`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaEmailTemplate.property.brandId" id="cdktfprovideroktadataoktaemailtemplatepropertybrandid"></a>

```typescript
public readonly brandId: string;
```

- *Type:* `string`

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaEmailTemplate.property.id" id="cdktfprovideroktadataoktaemailtemplatepropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `name`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaEmailTemplate.property.name" id="cdktfprovideroktadataoktaemailtemplatepropertyname"></a>

```typescript
public readonly name: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktadataoktaemailtemplatepropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.DataOktaEmailTemplate.property.tfResourceType" id="cdktfprovideroktadataoktaemailtemplatepropertytfresourcetype"></a>

- *Type:* `string`

---

### DataOktaEmailTemplates <a name="@cdktf/provider-okta.DataOktaEmailTemplates" id="cdktfprovideroktadataoktaemailtemplates"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/d/email_templates okta_email_templates}.

#### Initializers <a name="@cdktf/provider-okta.DataOktaEmailTemplates.Initializer" id="cdktfprovideroktadataoktaemailtemplatesinitializer"></a>

```typescript
import { DataOktaEmailTemplates } from '@cdktf/provider-okta'

new DataOktaEmailTemplates(scope: Construct, id: string, config: DataOktaEmailTemplatesConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktadataoktaemailtemplatesparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktadataoktaemailtemplatesparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktadataoktaemailtemplatesparameterconfig)<span title="Required">*</span> | [`@cdktf/provider-okta.DataOktaEmailTemplatesConfig`](#@cdktf/provider-okta.DataOktaEmailTemplatesConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaEmailTemplates.parameter.scope" id="cdktfprovideroktadataoktaemailtemplatesparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaEmailTemplates.parameter.id" id="cdktfprovideroktadataoktaemailtemplatesparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaEmailTemplates.parameter.config" id="cdktfprovideroktadataoktaemailtemplatesparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.DataOktaEmailTemplatesConfig`](#@cdktf/provider-okta.DataOktaEmailTemplatesConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`resetId`](#cdktfprovideroktadataoktaemailtemplatesresetid) | *No description.* |

---

##### `resetId` <a name="@cdktf/provider-okta.DataOktaEmailTemplates.resetId" id="cdktfprovideroktadataoktaemailtemplatesresetid"></a>

```typescript
public resetId()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`emailTemplates`](#cdktfprovideroktadataoktaemailtemplatespropertyemailtemplates)<span title="Required">*</span> | [`@cdktf/provider-okta.DataOktaEmailTemplatesEmailTemplatesList`](#@cdktf/provider-okta.DataOktaEmailTemplatesEmailTemplatesList) | *No description.* |
| [`brandIdInput`](#cdktfprovideroktadataoktaemailtemplatespropertybrandidinput) | `string` | *No description.* |
| [`idInput`](#cdktfprovideroktadataoktaemailtemplatespropertyidinput) | `string` | *No description.* |
| [`brandId`](#cdktfprovideroktadataoktaemailtemplatespropertybrandid)<span title="Required">*</span> | `string` | *No description.* |
| [`id`](#cdktfprovideroktadataoktaemailtemplatespropertyid)<span title="Required">*</span> | `string` | *No description.* |

---

##### `emailTemplates`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaEmailTemplates.property.emailTemplates" id="cdktfprovideroktadataoktaemailtemplatespropertyemailtemplates"></a>

```typescript
public readonly emailTemplates: DataOktaEmailTemplatesEmailTemplatesList;
```

- *Type:* [`@cdktf/provider-okta.DataOktaEmailTemplatesEmailTemplatesList`](#@cdktf/provider-okta.DataOktaEmailTemplatesEmailTemplatesList)

---

##### `brandIdInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaEmailTemplates.property.brandIdInput" id="cdktfprovideroktadataoktaemailtemplatespropertybrandidinput"></a>

```typescript
public readonly brandIdInput: string;
```

- *Type:* `string`

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaEmailTemplates.property.idInput" id="cdktfprovideroktadataoktaemailtemplatespropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `brandId`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaEmailTemplates.property.brandId" id="cdktfprovideroktadataoktaemailtemplatespropertybrandid"></a>

```typescript
public readonly brandId: string;
```

- *Type:* `string`

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaEmailTemplates.property.id" id="cdktfprovideroktadataoktaemailtemplatespropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktadataoktaemailtemplatespropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.DataOktaEmailTemplates.property.tfResourceType" id="cdktfprovideroktadataoktaemailtemplatespropertytfresourcetype"></a>

- *Type:* `string`

---

### DataOktaEveryoneGroup <a name="@cdktf/provider-okta.DataOktaEveryoneGroup" id="cdktfprovideroktadataoktaeveryonegroup"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/d/everyone_group okta_everyone_group}.

#### Initializers <a name="@cdktf/provider-okta.DataOktaEveryoneGroup.Initializer" id="cdktfprovideroktadataoktaeveryonegroupinitializer"></a>

```typescript
import { DataOktaEveryoneGroup } from '@cdktf/provider-okta'

new DataOktaEveryoneGroup(scope: Construct, id: string, config?: DataOktaEveryoneGroupConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktadataoktaeveryonegroupparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktadataoktaeveryonegroupparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktadataoktaeveryonegroupparameterconfig) | [`@cdktf/provider-okta.DataOktaEveryoneGroupConfig`](#@cdktf/provider-okta.DataOktaEveryoneGroupConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaEveryoneGroup.parameter.scope" id="cdktfprovideroktadataoktaeveryonegroupparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaEveryoneGroup.parameter.id" id="cdktfprovideroktadataoktaeveryonegroupparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaEveryoneGroup.parameter.config" id="cdktfprovideroktadataoktaeveryonegroupparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.DataOktaEveryoneGroupConfig`](#@cdktf/provider-okta.DataOktaEveryoneGroupConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`resetId`](#cdktfprovideroktadataoktaeveryonegroupresetid) | *No description.* |
| [`resetIncludeUsers`](#cdktfprovideroktadataoktaeveryonegroupresetincludeusers) | *No description.* |

---

##### `resetId` <a name="@cdktf/provider-okta.DataOktaEveryoneGroup.resetId" id="cdktfprovideroktadataoktaeveryonegroupresetid"></a>

```typescript
public resetId()
```

##### `resetIncludeUsers` <a name="@cdktf/provider-okta.DataOktaEveryoneGroup.resetIncludeUsers" id="cdktfprovideroktadataoktaeveryonegroupresetincludeusers"></a>

```typescript
public resetIncludeUsers()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`description`](#cdktfprovideroktadataoktaeveryonegrouppropertydescription)<span title="Required">*</span> | `string` | *No description.* |
| [`idInput`](#cdktfprovideroktadataoktaeveryonegrouppropertyidinput) | `string` | *No description.* |
| [`includeUsersInput`](#cdktfprovideroktadataoktaeveryonegrouppropertyincludeusersinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`id`](#cdktfprovideroktadataoktaeveryonegrouppropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`includeUsers`](#cdktfprovideroktadataoktaeveryonegrouppropertyincludeusers)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |

---

##### `description`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaEveryoneGroup.property.description" id="cdktfprovideroktadataoktaeveryonegrouppropertydescription"></a>

```typescript
public readonly description: string;
```

- *Type:* `string`

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaEveryoneGroup.property.idInput" id="cdktfprovideroktadataoktaeveryonegrouppropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `includeUsersInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaEveryoneGroup.property.includeUsersInput" id="cdktfprovideroktadataoktaeveryonegrouppropertyincludeusersinput"></a>

```typescript
public readonly includeUsersInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaEveryoneGroup.property.id" id="cdktfprovideroktadataoktaeveryonegrouppropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `includeUsers`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaEveryoneGroup.property.includeUsers" id="cdktfprovideroktadataoktaeveryonegrouppropertyincludeusers"></a>

```typescript
public readonly includeUsers: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktadataoktaeveryonegrouppropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.DataOktaEveryoneGroup.property.tfResourceType" id="cdktfprovideroktadataoktaeveryonegrouppropertytfresourcetype"></a>

- *Type:* `string`

---

### DataOktaGroup <a name="@cdktf/provider-okta.DataOktaGroup" id="cdktfprovideroktadataoktagroup"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/d/group okta_group}.

#### Initializers <a name="@cdktf/provider-okta.DataOktaGroup.Initializer" id="cdktfprovideroktadataoktagroupinitializer"></a>

```typescript
import { DataOktaGroup } from '@cdktf/provider-okta'

new DataOktaGroup(scope: Construct, id: string, config?: DataOktaGroupConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktadataoktagroupparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktadataoktagroupparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktadataoktagroupparameterconfig) | [`@cdktf/provider-okta.DataOktaGroupConfig`](#@cdktf/provider-okta.DataOktaGroupConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaGroup.parameter.scope" id="cdktfprovideroktadataoktagroupparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaGroup.parameter.id" id="cdktfprovideroktadataoktagroupparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaGroup.parameter.config" id="cdktfprovideroktadataoktagroupparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.DataOktaGroupConfig`](#@cdktf/provider-okta.DataOktaGroupConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`resetDelayReadSeconds`](#cdktfprovideroktadataoktagroupresetdelayreadseconds) | *No description.* |
| [`resetId`](#cdktfprovideroktadataoktagroupresetid) | *No description.* |
| [`resetIncludeUsers`](#cdktfprovideroktadataoktagroupresetincludeusers) | *No description.* |
| [`resetName`](#cdktfprovideroktadataoktagroupresetname) | *No description.* |
| [`resetType`](#cdktfprovideroktadataoktagroupresettype) | *No description.* |

---

##### `resetDelayReadSeconds` <a name="@cdktf/provider-okta.DataOktaGroup.resetDelayReadSeconds" id="cdktfprovideroktadataoktagroupresetdelayreadseconds"></a>

```typescript
public resetDelayReadSeconds()
```

##### `resetId` <a name="@cdktf/provider-okta.DataOktaGroup.resetId" id="cdktfprovideroktadataoktagroupresetid"></a>

```typescript
public resetId()
```

##### `resetIncludeUsers` <a name="@cdktf/provider-okta.DataOktaGroup.resetIncludeUsers" id="cdktfprovideroktadataoktagroupresetincludeusers"></a>

```typescript
public resetIncludeUsers()
```

##### `resetName` <a name="@cdktf/provider-okta.DataOktaGroup.resetName" id="cdktfprovideroktadataoktagroupresetname"></a>

```typescript
public resetName()
```

##### `resetType` <a name="@cdktf/provider-okta.DataOktaGroup.resetType" id="cdktfprovideroktadataoktagroupresettype"></a>

```typescript
public resetType()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`description`](#cdktfprovideroktadataoktagrouppropertydescription)<span title="Required">*</span> | `string` | *No description.* |
| [`users`](#cdktfprovideroktadataoktagrouppropertyusers)<span title="Required">*</span> | `string`[] | *No description.* |
| [`delayReadSecondsInput`](#cdktfprovideroktadataoktagrouppropertydelayreadsecondsinput) | `string` | *No description.* |
| [`idInput`](#cdktfprovideroktadataoktagrouppropertyidinput) | `string` | *No description.* |
| [`includeUsersInput`](#cdktfprovideroktadataoktagrouppropertyincludeusersinput) | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`nameInput`](#cdktfprovideroktadataoktagrouppropertynameinput) | `string` | *No description.* |
| [`typeInput`](#cdktfprovideroktadataoktagrouppropertytypeinput) | `string` | *No description.* |
| [`delayReadSeconds`](#cdktfprovideroktadataoktagrouppropertydelayreadseconds)<span title="Required">*</span> | `string` | *No description.* |
| [`id`](#cdktfprovideroktadataoktagrouppropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`includeUsers`](#cdktfprovideroktadataoktagrouppropertyincludeusers)<span title="Required">*</span> | `boolean` \| [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`name`](#cdktfprovideroktadataoktagrouppropertyname)<span title="Required">*</span> | `string` | *No description.* |
| [`type`](#cdktfprovideroktadataoktagrouppropertytype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `description`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaGroup.property.description" id="cdktfprovideroktadataoktagrouppropertydescription"></a>

```typescript
public readonly description: string;
```

- *Type:* `string`

---

##### `users`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaGroup.property.users" id="cdktfprovideroktadataoktagrouppropertyusers"></a>

```typescript
public readonly users: string[];
```

- *Type:* `string`[]

---

##### `delayReadSecondsInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaGroup.property.delayReadSecondsInput" id="cdktfprovideroktadataoktagrouppropertydelayreadsecondsinput"></a>

```typescript
public readonly delayReadSecondsInput: string;
```

- *Type:* `string`

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaGroup.property.idInput" id="cdktfprovideroktadataoktagrouppropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `includeUsersInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaGroup.property.includeUsersInput" id="cdktfprovideroktadataoktagrouppropertyincludeusersinput"></a>

```typescript
public readonly includeUsersInput: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `nameInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaGroup.property.nameInput" id="cdktfprovideroktadataoktagrouppropertynameinput"></a>

```typescript
public readonly nameInput: string;
```

- *Type:* `string`

---

##### `typeInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaGroup.property.typeInput" id="cdktfprovideroktadataoktagrouppropertytypeinput"></a>

```typescript
public readonly typeInput: string;
```

- *Type:* `string`

---

##### `delayReadSeconds`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaGroup.property.delayReadSeconds" id="cdktfprovideroktadataoktagrouppropertydelayreadseconds"></a>

```typescript
public readonly delayReadSeconds: string;
```

- *Type:* `string`

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaGroup.property.id" id="cdktfprovideroktadataoktagrouppropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `includeUsers`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaGroup.property.includeUsers" id="cdktfprovideroktadataoktagrouppropertyincludeusers"></a>

```typescript
public readonly includeUsers: boolean | IResolvable;
```

- *Type:* `boolean` | [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `name`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaGroup.property.name" id="cdktfprovideroktadataoktagrouppropertyname"></a>

```typescript
public readonly name: string;
```

- *Type:* `string`

---

##### `type`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaGroup.property.type" id="cdktfprovideroktadataoktagrouppropertytype"></a>

```typescript
public readonly type: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktadataoktagrouppropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.DataOktaGroup.property.tfResourceType" id="cdktfprovideroktadataoktagrouppropertytfresourcetype"></a>

- *Type:* `string`

---

### DataOktaGroups <a name="@cdktf/provider-okta.DataOktaGroups" id="cdktfprovideroktadataoktagroups"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/d/groups okta_groups}.

#### Initializers <a name="@cdktf/provider-okta.DataOktaGroups.Initializer" id="cdktfprovideroktadataoktagroupsinitializer"></a>

```typescript
import { DataOktaGroups } from '@cdktf/provider-okta'

new DataOktaGroups(scope: Construct, id: string, config?: DataOktaGroupsConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktadataoktagroupsparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktadataoktagroupsparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktadataoktagroupsparameterconfig) | [`@cdktf/provider-okta.DataOktaGroupsConfig`](#@cdktf/provider-okta.DataOktaGroupsConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaGroups.parameter.scope" id="cdktfprovideroktadataoktagroupsparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaGroups.parameter.id" id="cdktfprovideroktadataoktagroupsparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaGroups.parameter.config" id="cdktfprovideroktadataoktagroupsparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.DataOktaGroupsConfig`](#@cdktf/provider-okta.DataOktaGroupsConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`resetId`](#cdktfprovideroktadataoktagroupsresetid) | *No description.* |
| [`resetQ`](#cdktfprovideroktadataoktagroupsresetq) | *No description.* |
| [`resetSearch`](#cdktfprovideroktadataoktagroupsresetsearch) | *No description.* |
| [`resetType`](#cdktfprovideroktadataoktagroupsresettype) | *No description.* |

---

##### `resetId` <a name="@cdktf/provider-okta.DataOktaGroups.resetId" id="cdktfprovideroktadataoktagroupsresetid"></a>

```typescript
public resetId()
```

##### `resetQ` <a name="@cdktf/provider-okta.DataOktaGroups.resetQ" id="cdktfprovideroktadataoktagroupsresetq"></a>

```typescript
public resetQ()
```

##### `resetSearch` <a name="@cdktf/provider-okta.DataOktaGroups.resetSearch" id="cdktfprovideroktadataoktagroupsresetsearch"></a>

```typescript
public resetSearch()
```

##### `resetType` <a name="@cdktf/provider-okta.DataOktaGroups.resetType" id="cdktfprovideroktadataoktagroupsresettype"></a>

```typescript
public resetType()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`groups`](#cdktfprovideroktadataoktagroupspropertygroups)<span title="Required">*</span> | [`@cdktf/provider-okta.DataOktaGroupsGroupsList`](#@cdktf/provider-okta.DataOktaGroupsGroupsList) | *No description.* |
| [`idInput`](#cdktfprovideroktadataoktagroupspropertyidinput) | `string` | *No description.* |
| [`qInput`](#cdktfprovideroktadataoktagroupspropertyqinput) | `string` | *No description.* |
| [`searchInput`](#cdktfprovideroktadataoktagroupspropertysearchinput) | `string` | *No description.* |
| [`typeInput`](#cdktfprovideroktadataoktagroupspropertytypeinput) | `string` | *No description.* |
| [`id`](#cdktfprovideroktadataoktagroupspropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`q`](#cdktfprovideroktadataoktagroupspropertyq)<span title="Required">*</span> | `string` | *No description.* |
| [`search`](#cdktfprovideroktadataoktagroupspropertysearch)<span title="Required">*</span> | `string` | *No description.* |
| [`type`](#cdktfprovideroktadataoktagroupspropertytype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `groups`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaGroups.property.groups" id="cdktfprovideroktadataoktagroupspropertygroups"></a>

```typescript
public readonly groups: DataOktaGroupsGroupsList;
```

- *Type:* [`@cdktf/provider-okta.DataOktaGroupsGroupsList`](#@cdktf/provider-okta.DataOktaGroupsGroupsList)

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaGroups.property.idInput" id="cdktfprovideroktadataoktagroupspropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `qInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaGroups.property.qInput" id="cdktfprovideroktadataoktagroupspropertyqinput"></a>

```typescript
public readonly qInput: string;
```

- *Type:* `string`

---

##### `searchInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaGroups.property.searchInput" id="cdktfprovideroktadataoktagroupspropertysearchinput"></a>

```typescript
public readonly searchInput: string;
```

- *Type:* `string`

---

##### `typeInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaGroups.property.typeInput" id="cdktfprovideroktadataoktagroupspropertytypeinput"></a>

```typescript
public readonly typeInput: string;
```

- *Type:* `string`

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaGroups.property.id" id="cdktfprovideroktadataoktagroupspropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `q`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaGroups.property.q" id="cdktfprovideroktadataoktagroupspropertyq"></a>

```typescript
public readonly q: string;
```

- *Type:* `string`

---

##### `search`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaGroups.property.search" id="cdktfprovideroktadataoktagroupspropertysearch"></a>

```typescript
public readonly search: string;
```

- *Type:* `string`

---

##### `type`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaGroups.property.type" id="cdktfprovideroktadataoktagroupspropertytype"></a>

```typescript
public readonly type: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktadataoktagroupspropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.DataOktaGroups.property.tfResourceType" id="cdktfprovideroktadataoktagroupspropertytfresourcetype"></a>

- *Type:* `string`

---

### DataOktaIdpMetadataSaml <a name="@cdktf/provider-okta.DataOktaIdpMetadataSaml" id="cdktfprovideroktadataoktaidpmetadatasaml"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/d/idp_metadata_saml okta_idp_metadata_saml}.

#### Initializers <a name="@cdktf/provider-okta.DataOktaIdpMetadataSaml.Initializer" id="cdktfprovideroktadataoktaidpmetadatasamlinitializer"></a>

```typescript
import { DataOktaIdpMetadataSaml } from '@cdktf/provider-okta'

new DataOktaIdpMetadataSaml(scope: Construct, id: string, config?: DataOktaIdpMetadataSamlConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktadataoktaidpmetadatasamlparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktadataoktaidpmetadatasamlparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktadataoktaidpmetadatasamlparameterconfig) | [`@cdktf/provider-okta.DataOktaIdpMetadataSamlConfig`](#@cdktf/provider-okta.DataOktaIdpMetadataSamlConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpMetadataSaml.parameter.scope" id="cdktfprovideroktadataoktaidpmetadatasamlparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpMetadataSaml.parameter.id" id="cdktfprovideroktadataoktaidpmetadatasamlparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaIdpMetadataSaml.parameter.config" id="cdktfprovideroktadataoktaidpmetadatasamlparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.DataOktaIdpMetadataSamlConfig`](#@cdktf/provider-okta.DataOktaIdpMetadataSamlConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`resetId`](#cdktfprovideroktadataoktaidpmetadatasamlresetid) | *No description.* |
| [`resetIdpId`](#cdktfprovideroktadataoktaidpmetadatasamlresetidpid) | *No description.* |

---

##### `resetId` <a name="@cdktf/provider-okta.DataOktaIdpMetadataSaml.resetId" id="cdktfprovideroktadataoktaidpmetadatasamlresetid"></a>

```typescript
public resetId()
```

##### `resetIdpId` <a name="@cdktf/provider-okta.DataOktaIdpMetadataSaml.resetIdpId" id="cdktfprovideroktadataoktaidpmetadatasamlresetidpid"></a>

```typescript
public resetIdpId()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`assertionsSigned`](#cdktfprovideroktadataoktaidpmetadatasamlpropertyassertionssigned)<span title="Required">*</span> | [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`authnRequestSigned`](#cdktfprovideroktadataoktaidpmetadatasamlpropertyauthnrequestsigned)<span title="Required">*</span> | [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`encryptionCertificate`](#cdktfprovideroktadataoktaidpmetadatasamlpropertyencryptioncertificate)<span title="Required">*</span> | `string` | *No description.* |
| [`entityId`](#cdktfprovideroktadataoktaidpmetadatasamlpropertyentityid)<span title="Required">*</span> | `string` | *No description.* |
| [`httpPostBinding`](#cdktfprovideroktadataoktaidpmetadatasamlpropertyhttppostbinding)<span title="Required">*</span> | `string` | *No description.* |
| [`httpRedirectBinding`](#cdktfprovideroktadataoktaidpmetadatasamlpropertyhttpredirectbinding)<span title="Required">*</span> | `string` | *No description.* |
| [`metadata`](#cdktfprovideroktadataoktaidpmetadatasamlpropertymetadata)<span title="Required">*</span> | `string` | *No description.* |
| [`signingCertificate`](#cdktfprovideroktadataoktaidpmetadatasamlpropertysigningcertificate)<span title="Required">*</span> | `string` | *No description.* |
| [`idInput`](#cdktfprovideroktadataoktaidpmetadatasamlpropertyidinput) | `string` | *No description.* |
| [`idpIdInput`](#cdktfprovideroktadataoktaidpmetadatasamlpropertyidpidinput) | `string` | *No description.* |
| [`id`](#cdktfprovideroktadataoktaidpmetadatasamlpropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`idpId`](#cdktfprovideroktadataoktaidpmetadatasamlpropertyidpid)<span title="Required">*</span> | `string` | *No description.* |

---

##### `assertionsSigned`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpMetadataSaml.property.assertionsSigned" id="cdktfprovideroktadataoktaidpmetadatasamlpropertyassertionssigned"></a>

```typescript
public readonly assertionsSigned: IResolvable;
```

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `authnRequestSigned`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpMetadataSaml.property.authnRequestSigned" id="cdktfprovideroktadataoktaidpmetadatasamlpropertyauthnrequestsigned"></a>

```typescript
public readonly authnRequestSigned: IResolvable;
```

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `encryptionCertificate`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpMetadataSaml.property.encryptionCertificate" id="cdktfprovideroktadataoktaidpmetadatasamlpropertyencryptioncertificate"></a>

```typescript
public readonly encryptionCertificate: string;
```

- *Type:* `string`

---

##### `entityId`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpMetadataSaml.property.entityId" id="cdktfprovideroktadataoktaidpmetadatasamlpropertyentityid"></a>

```typescript
public readonly entityId: string;
```

- *Type:* `string`

---

##### `httpPostBinding`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpMetadataSaml.property.httpPostBinding" id="cdktfprovideroktadataoktaidpmetadatasamlpropertyhttppostbinding"></a>

```typescript
public readonly httpPostBinding: string;
```

- *Type:* `string`

---

##### `httpRedirectBinding`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpMetadataSaml.property.httpRedirectBinding" id="cdktfprovideroktadataoktaidpmetadatasamlpropertyhttpredirectbinding"></a>

```typescript
public readonly httpRedirectBinding: string;
```

- *Type:* `string`

---

##### `metadata`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpMetadataSaml.property.metadata" id="cdktfprovideroktadataoktaidpmetadatasamlpropertymetadata"></a>

```typescript
public readonly metadata: string;
```

- *Type:* `string`

---

##### `signingCertificate`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpMetadataSaml.property.signingCertificate" id="cdktfprovideroktadataoktaidpmetadatasamlpropertysigningcertificate"></a>

```typescript
public readonly signingCertificate: string;
```

- *Type:* `string`

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaIdpMetadataSaml.property.idInput" id="cdktfprovideroktadataoktaidpmetadatasamlpropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `idpIdInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaIdpMetadataSaml.property.idpIdInput" id="cdktfprovideroktadataoktaidpmetadatasamlpropertyidpidinput"></a>

```typescript
public readonly idpIdInput: string;
```

- *Type:* `string`

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpMetadataSaml.property.id" id="cdktfprovideroktadataoktaidpmetadatasamlpropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `idpId`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpMetadataSaml.property.idpId" id="cdktfprovideroktadataoktaidpmetadatasamlpropertyidpid"></a>

```typescript
public readonly idpId: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktadataoktaidpmetadatasamlpropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.DataOktaIdpMetadataSaml.property.tfResourceType" id="cdktfprovideroktadataoktaidpmetadatasamlpropertytfresourcetype"></a>

- *Type:* `string`

---

### DataOktaIdpOidc <a name="@cdktf/provider-okta.DataOktaIdpOidc" id="cdktfprovideroktadataoktaidpoidc"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/d/idp_oidc okta_idp_oidc}.

#### Initializers <a name="@cdktf/provider-okta.DataOktaIdpOidc.Initializer" id="cdktfprovideroktadataoktaidpoidcinitializer"></a>

```typescript
import { DataOktaIdpOidc } from '@cdktf/provider-okta'

new DataOktaIdpOidc(scope: Construct, id: string, config?: DataOktaIdpOidcConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktadataoktaidpoidcparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktadataoktaidpoidcparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktadataoktaidpoidcparameterconfig) | [`@cdktf/provider-okta.DataOktaIdpOidcConfig`](#@cdktf/provider-okta.DataOktaIdpOidcConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpOidc.parameter.scope" id="cdktfprovideroktadataoktaidpoidcparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpOidc.parameter.id" id="cdktfprovideroktadataoktaidpoidcparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaIdpOidc.parameter.config" id="cdktfprovideroktadataoktaidpoidcparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.DataOktaIdpOidcConfig`](#@cdktf/provider-okta.DataOktaIdpOidcConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`resetId`](#cdktfprovideroktadataoktaidpoidcresetid) | *No description.* |
| [`resetName`](#cdktfprovideroktadataoktaidpoidcresetname) | *No description.* |

---

##### `resetId` <a name="@cdktf/provider-okta.DataOktaIdpOidc.resetId" id="cdktfprovideroktadataoktaidpoidcresetid"></a>

```typescript
public resetId()
```

##### `resetName` <a name="@cdktf/provider-okta.DataOktaIdpOidc.resetName" id="cdktfprovideroktadataoktaidpoidcresetname"></a>

```typescript
public resetName()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`authorizationBinding`](#cdktfprovideroktadataoktaidpoidcpropertyauthorizationbinding)<span title="Required">*</span> | `string` | *No description.* |
| [`authorizationUrl`](#cdktfprovideroktadataoktaidpoidcpropertyauthorizationurl)<span title="Required">*</span> | `string` | *No description.* |
| [`clientId`](#cdktfprovideroktadataoktaidpoidcpropertyclientid)<span title="Required">*</span> | `string` | *No description.* |
| [`clientSecret`](#cdktfprovideroktadataoktaidpoidcpropertyclientsecret)<span title="Required">*</span> | `string` | *No description.* |
| [`issuerMode`](#cdktfprovideroktadataoktaidpoidcpropertyissuermode)<span title="Required">*</span> | `string` | *No description.* |
| [`issuerUrl`](#cdktfprovideroktadataoktaidpoidcpropertyissuerurl)<span title="Required">*</span> | `string` | *No description.* |
| [`jwksBinding`](#cdktfprovideroktadataoktaidpoidcpropertyjwksbinding)<span title="Required">*</span> | `string` | *No description.* |
| [`jwksUrl`](#cdktfprovideroktadataoktaidpoidcpropertyjwksurl)<span title="Required">*</span> | `string` | *No description.* |
| [`maxClockSkew`](#cdktfprovideroktadataoktaidpoidcpropertymaxclockskew)<span title="Required">*</span> | `number` | *No description.* |
| [`protocolType`](#cdktfprovideroktadataoktaidpoidcpropertyprotocoltype)<span title="Required">*</span> | `string` | *No description.* |
| [`scopes`](#cdktfprovideroktadataoktaidpoidcpropertyscopes)<span title="Required">*</span> | `string`[] | *No description.* |
| [`tokenBinding`](#cdktfprovideroktadataoktaidpoidcpropertytokenbinding)<span title="Required">*</span> | `string` | *No description.* |
| [`tokenUrl`](#cdktfprovideroktadataoktaidpoidcpropertytokenurl)<span title="Required">*</span> | `string` | *No description.* |
| [`type`](#cdktfprovideroktadataoktaidpoidcpropertytype)<span title="Required">*</span> | `string` | *No description.* |
| [`userInfoBinding`](#cdktfprovideroktadataoktaidpoidcpropertyuserinfobinding)<span title="Required">*</span> | `string` | *No description.* |
| [`userInfoUrl`](#cdktfprovideroktadataoktaidpoidcpropertyuserinfourl)<span title="Required">*</span> | `string` | *No description.* |
| [`idInput`](#cdktfprovideroktadataoktaidpoidcpropertyidinput) | `string` | *No description.* |
| [`nameInput`](#cdktfprovideroktadataoktaidpoidcpropertynameinput) | `string` | *No description.* |
| [`id`](#cdktfprovideroktadataoktaidpoidcpropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`name`](#cdktfprovideroktadataoktaidpoidcpropertyname)<span title="Required">*</span> | `string` | *No description.* |

---

##### `authorizationBinding`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpOidc.property.authorizationBinding" id="cdktfprovideroktadataoktaidpoidcpropertyauthorizationbinding"></a>

```typescript
public readonly authorizationBinding: string;
```

- *Type:* `string`

---

##### `authorizationUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpOidc.property.authorizationUrl" id="cdktfprovideroktadataoktaidpoidcpropertyauthorizationurl"></a>

```typescript
public readonly authorizationUrl: string;
```

- *Type:* `string`

---

##### `clientId`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpOidc.property.clientId" id="cdktfprovideroktadataoktaidpoidcpropertyclientid"></a>

```typescript
public readonly clientId: string;
```

- *Type:* `string`

---

##### `clientSecret`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpOidc.property.clientSecret" id="cdktfprovideroktadataoktaidpoidcpropertyclientsecret"></a>

```typescript
public readonly clientSecret: string;
```

- *Type:* `string`

---

##### `issuerMode`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpOidc.property.issuerMode" id="cdktfprovideroktadataoktaidpoidcpropertyissuermode"></a>

```typescript
public readonly issuerMode: string;
```

- *Type:* `string`

---

##### `issuerUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpOidc.property.issuerUrl" id="cdktfprovideroktadataoktaidpoidcpropertyissuerurl"></a>

```typescript
public readonly issuerUrl: string;
```

- *Type:* `string`

---

##### `jwksBinding`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpOidc.property.jwksBinding" id="cdktfprovideroktadataoktaidpoidcpropertyjwksbinding"></a>

```typescript
public readonly jwksBinding: string;
```

- *Type:* `string`

---

##### `jwksUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpOidc.property.jwksUrl" id="cdktfprovideroktadataoktaidpoidcpropertyjwksurl"></a>

```typescript
public readonly jwksUrl: string;
```

- *Type:* `string`

---

##### `maxClockSkew`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpOidc.property.maxClockSkew" id="cdktfprovideroktadataoktaidpoidcpropertymaxclockskew"></a>

```typescript
public readonly maxClockSkew: number;
```

- *Type:* `number`

---

##### `protocolType`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpOidc.property.protocolType" id="cdktfprovideroktadataoktaidpoidcpropertyprotocoltype"></a>

```typescript
public readonly protocolType: string;
```

- *Type:* `string`

---

##### `scopes`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpOidc.property.scopes" id="cdktfprovideroktadataoktaidpoidcpropertyscopes"></a>

```typescript
public readonly scopes: string[];
```

- *Type:* `string`[]

---

##### `tokenBinding`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpOidc.property.tokenBinding" id="cdktfprovideroktadataoktaidpoidcpropertytokenbinding"></a>

```typescript
public readonly tokenBinding: string;
```

- *Type:* `string`

---

##### `tokenUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpOidc.property.tokenUrl" id="cdktfprovideroktadataoktaidpoidcpropertytokenurl"></a>

```typescript
public readonly tokenUrl: string;
```

- *Type:* `string`

---

##### `type`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpOidc.property.type" id="cdktfprovideroktadataoktaidpoidcpropertytype"></a>

```typescript
public readonly type: string;
```

- *Type:* `string`

---

##### `userInfoBinding`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpOidc.property.userInfoBinding" id="cdktfprovideroktadataoktaidpoidcpropertyuserinfobinding"></a>

```typescript
public readonly userInfoBinding: string;
```

- *Type:* `string`

---

##### `userInfoUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpOidc.property.userInfoUrl" id="cdktfprovideroktadataoktaidpoidcpropertyuserinfourl"></a>

```typescript
public readonly userInfoUrl: string;
```

- *Type:* `string`

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaIdpOidc.property.idInput" id="cdktfprovideroktadataoktaidpoidcpropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `nameInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaIdpOidc.property.nameInput" id="cdktfprovideroktadataoktaidpoidcpropertynameinput"></a>

```typescript
public readonly nameInput: string;
```

- *Type:* `string`

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpOidc.property.id" id="cdktfprovideroktadataoktaidpoidcpropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `name`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpOidc.property.name" id="cdktfprovideroktadataoktaidpoidcpropertyname"></a>

```typescript
public readonly name: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktadataoktaidpoidcpropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.DataOktaIdpOidc.property.tfResourceType" id="cdktfprovideroktadataoktaidpoidcpropertytfresourcetype"></a>

- *Type:* `string`

---

### DataOktaIdpSaml <a name="@cdktf/provider-okta.DataOktaIdpSaml" id="cdktfprovideroktadataoktaidpsaml"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/d/idp_saml okta_idp_saml}.

#### Initializers <a name="@cdktf/provider-okta.DataOktaIdpSaml.Initializer" id="cdktfprovideroktadataoktaidpsamlinitializer"></a>

```typescript
import { DataOktaIdpSaml } from '@cdktf/provider-okta'

new DataOktaIdpSaml(scope: Construct, id: string, config?: DataOktaIdpSamlConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktadataoktaidpsamlparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktadataoktaidpsamlparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktadataoktaidpsamlparameterconfig) | [`@cdktf/provider-okta.DataOktaIdpSamlConfig`](#@cdktf/provider-okta.DataOktaIdpSamlConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpSaml.parameter.scope" id="cdktfprovideroktadataoktaidpsamlparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpSaml.parameter.id" id="cdktfprovideroktadataoktaidpsamlparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaIdpSaml.parameter.config" id="cdktfprovideroktadataoktaidpsamlparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.DataOktaIdpSamlConfig`](#@cdktf/provider-okta.DataOktaIdpSamlConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`resetId`](#cdktfprovideroktadataoktaidpsamlresetid) | *No description.* |
| [`resetName`](#cdktfprovideroktadataoktaidpsamlresetname) | *No description.* |

---

##### `resetId` <a name="@cdktf/provider-okta.DataOktaIdpSaml.resetId" id="cdktfprovideroktadataoktaidpsamlresetid"></a>

```typescript
public resetId()
```

##### `resetName` <a name="@cdktf/provider-okta.DataOktaIdpSaml.resetName" id="cdktfprovideroktadataoktaidpsamlresetname"></a>

```typescript
public resetName()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`acsBinding`](#cdktfprovideroktadataoktaidpsamlpropertyacsbinding)<span title="Required">*</span> | `string` | *No description.* |
| [`acsType`](#cdktfprovideroktadataoktaidpsamlpropertyacstype)<span title="Required">*</span> | `string` | *No description.* |
| [`audience`](#cdktfprovideroktadataoktaidpsamlpropertyaudience)<span title="Required">*</span> | `string` | *No description.* |
| [`issuer`](#cdktfprovideroktadataoktaidpsamlpropertyissuer)<span title="Required">*</span> | `string` | *No description.* |
| [`issuerMode`](#cdktfprovideroktadataoktaidpsamlpropertyissuermode)<span title="Required">*</span> | `string` | *No description.* |
| [`kid`](#cdktfprovideroktadataoktaidpsamlpropertykid)<span title="Required">*</span> | `string` | *No description.* |
| [`ssoBinding`](#cdktfprovideroktadataoktaidpsamlpropertyssobinding)<span title="Required">*</span> | `string` | *No description.* |
| [`ssoDestination`](#cdktfprovideroktadataoktaidpsamlpropertyssodestination)<span title="Required">*</span> | `string` | *No description.* |
| [`ssoUrl`](#cdktfprovideroktadataoktaidpsamlpropertyssourl)<span title="Required">*</span> | `string` | *No description.* |
| [`subjectFilter`](#cdktfprovideroktadataoktaidpsamlpropertysubjectfilter)<span title="Required">*</span> | `string` | *No description.* |
| [`subjectFormat`](#cdktfprovideroktadataoktaidpsamlpropertysubjectformat)<span title="Required">*</span> | `string`[] | *No description.* |
| [`type`](#cdktfprovideroktadataoktaidpsamlpropertytype)<span title="Required">*</span> | `string` | *No description.* |
| [`idInput`](#cdktfprovideroktadataoktaidpsamlpropertyidinput) | `string` | *No description.* |
| [`nameInput`](#cdktfprovideroktadataoktaidpsamlpropertynameinput) | `string` | *No description.* |
| [`id`](#cdktfprovideroktadataoktaidpsamlpropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`name`](#cdktfprovideroktadataoktaidpsamlpropertyname)<span title="Required">*</span> | `string` | *No description.* |

---

##### `acsBinding`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpSaml.property.acsBinding" id="cdktfprovideroktadataoktaidpsamlpropertyacsbinding"></a>

```typescript
public readonly acsBinding: string;
```

- *Type:* `string`

---

##### `acsType`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpSaml.property.acsType" id="cdktfprovideroktadataoktaidpsamlpropertyacstype"></a>

```typescript
public readonly acsType: string;
```

- *Type:* `string`

---

##### `audience`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpSaml.property.audience" id="cdktfprovideroktadataoktaidpsamlpropertyaudience"></a>

```typescript
public readonly audience: string;
```

- *Type:* `string`

---

##### `issuer`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpSaml.property.issuer" id="cdktfprovideroktadataoktaidpsamlpropertyissuer"></a>

```typescript
public readonly issuer: string;
```

- *Type:* `string`

---

##### `issuerMode`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpSaml.property.issuerMode" id="cdktfprovideroktadataoktaidpsamlpropertyissuermode"></a>

```typescript
public readonly issuerMode: string;
```

- *Type:* `string`

---

##### `kid`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpSaml.property.kid" id="cdktfprovideroktadataoktaidpsamlpropertykid"></a>

```typescript
public readonly kid: string;
```

- *Type:* `string`

---

##### `ssoBinding`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpSaml.property.ssoBinding" id="cdktfprovideroktadataoktaidpsamlpropertyssobinding"></a>

```typescript
public readonly ssoBinding: string;
```

- *Type:* `string`

---

##### `ssoDestination`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpSaml.property.ssoDestination" id="cdktfprovideroktadataoktaidpsamlpropertyssodestination"></a>

```typescript
public readonly ssoDestination: string;
```

- *Type:* `string`

---

##### `ssoUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpSaml.property.ssoUrl" id="cdktfprovideroktadataoktaidpsamlpropertyssourl"></a>

```typescript
public readonly ssoUrl: string;
```

- *Type:* `string`

---

##### `subjectFilter`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpSaml.property.subjectFilter" id="cdktfprovideroktadataoktaidpsamlpropertysubjectfilter"></a>

```typescript
public readonly subjectFilter: string;
```

- *Type:* `string`

---

##### `subjectFormat`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpSaml.property.subjectFormat" id="cdktfprovideroktadataoktaidpsamlpropertysubjectformat"></a>

```typescript
public readonly subjectFormat: string[];
```

- *Type:* `string`[]

---

##### `type`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpSaml.property.type" id="cdktfprovideroktadataoktaidpsamlpropertytype"></a>

```typescript
public readonly type: string;
```

- *Type:* `string`

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaIdpSaml.property.idInput" id="cdktfprovideroktadataoktaidpsamlpropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `nameInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaIdpSaml.property.nameInput" id="cdktfprovideroktadataoktaidpsamlpropertynameinput"></a>

```typescript
public readonly nameInput: string;
```

- *Type:* `string`

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpSaml.property.id" id="cdktfprovideroktadataoktaidpsamlpropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `name`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpSaml.property.name" id="cdktfprovideroktadataoktaidpsamlpropertyname"></a>

```typescript
public readonly name: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktadataoktaidpsamlpropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.DataOktaIdpSaml.property.tfResourceType" id="cdktfprovideroktadataoktaidpsamlpropertytfresourcetype"></a>

- *Type:* `string`

---

### DataOktaIdpSocial <a name="@cdktf/provider-okta.DataOktaIdpSocial" id="cdktfprovideroktadataoktaidpsocial"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/d/idp_social okta_idp_social}.

#### Initializers <a name="@cdktf/provider-okta.DataOktaIdpSocial.Initializer" id="cdktfprovideroktadataoktaidpsocialinitializer"></a>

```typescript
import { DataOktaIdpSocial } from '@cdktf/provider-okta'

new DataOktaIdpSocial(scope: Construct, id: string, config?: DataOktaIdpSocialConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktadataoktaidpsocialparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktadataoktaidpsocialparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktadataoktaidpsocialparameterconfig) | [`@cdktf/provider-okta.DataOktaIdpSocialConfig`](#@cdktf/provider-okta.DataOktaIdpSocialConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpSocial.parameter.scope" id="cdktfprovideroktadataoktaidpsocialparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpSocial.parameter.id" id="cdktfprovideroktadataoktaidpsocialparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaIdpSocial.parameter.config" id="cdktfprovideroktadataoktaidpsocialparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.DataOktaIdpSocialConfig`](#@cdktf/provider-okta.DataOktaIdpSocialConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`resetId`](#cdktfprovideroktadataoktaidpsocialresetid) | *No description.* |
| [`resetName`](#cdktfprovideroktadataoktaidpsocialresetname) | *No description.* |

---

##### `resetId` <a name="@cdktf/provider-okta.DataOktaIdpSocial.resetId" id="cdktfprovideroktadataoktaidpsocialresetid"></a>

```typescript
public resetId()
```

##### `resetName` <a name="@cdktf/provider-okta.DataOktaIdpSocial.resetName" id="cdktfprovideroktadataoktaidpsocialresetname"></a>

```typescript
public resetName()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`accountLinkAction`](#cdktfprovideroktadataoktaidpsocialpropertyaccountlinkaction)<span title="Required">*</span> | `string` | *No description.* |
| [`accountLinkGroupInclude`](#cdktfprovideroktadataoktaidpsocialpropertyaccountlinkgroupinclude)<span title="Required">*</span> | `string`[] | *No description.* |
| [`authorizationBinding`](#cdktfprovideroktadataoktaidpsocialpropertyauthorizationbinding)<span title="Required">*</span> | `string` | *No description.* |
| [`authorizationUrl`](#cdktfprovideroktadataoktaidpsocialpropertyauthorizationurl)<span title="Required">*</span> | `string` | *No description.* |
| [`clientId`](#cdktfprovideroktadataoktaidpsocialpropertyclientid)<span title="Required">*</span> | `string` | *No description.* |
| [`clientSecret`](#cdktfprovideroktadataoktaidpsocialpropertyclientsecret)<span title="Required">*</span> | `string` | *No description.* |
| [`deprovisionedAction`](#cdktfprovideroktadataoktaidpsocialpropertydeprovisionedaction)<span title="Required">*</span> | `string` | *No description.* |
| [`groupsAction`](#cdktfprovideroktadataoktaidpsocialpropertygroupsaction)<span title="Required">*</span> | `string` | *No description.* |
| [`groupsAssignment`](#cdktfprovideroktadataoktaidpsocialpropertygroupsassignment)<span title="Required">*</span> | `string`[] | *No description.* |
| [`groupsAttribute`](#cdktfprovideroktadataoktaidpsocialpropertygroupsattribute)<span title="Required">*</span> | `string` | *No description.* |
| [`groupsFilter`](#cdktfprovideroktadataoktaidpsocialpropertygroupsfilter)<span title="Required">*</span> | `string`[] | *No description.* |
| [`issuerMode`](#cdktfprovideroktadataoktaidpsocialpropertyissuermode)<span title="Required">*</span> | `string` | *No description.* |
| [`maxClockSkew`](#cdktfprovideroktadataoktaidpsocialpropertymaxclockskew)<span title="Required">*</span> | `number` | *No description.* |
| [`profileMaster`](#cdktfprovideroktadataoktaidpsocialpropertyprofilemaster)<span title="Required">*</span> | [`cdktf.IResolvable`](#cdktf.IResolvable) | *No description.* |
| [`protocolType`](#cdktfprovideroktadataoktaidpsocialpropertyprotocoltype)<span title="Required">*</span> | `string` | *No description.* |
| [`provisioningAction`](#cdktfprovideroktadataoktaidpsocialpropertyprovisioningaction)<span title="Required">*</span> | `string` | *No description.* |
| [`scopes`](#cdktfprovideroktadataoktaidpsocialpropertyscopes)<span title="Required">*</span> | `string`[] | *No description.* |
| [`status`](#cdktfprovideroktadataoktaidpsocialpropertystatus)<span title="Required">*</span> | `string` | *No description.* |
| [`subjectMatchAttribute`](#cdktfprovideroktadataoktaidpsocialpropertysubjectmatchattribute)<span title="Required">*</span> | `string` | *No description.* |
| [`subjectMatchType`](#cdktfprovideroktadataoktaidpsocialpropertysubjectmatchtype)<span title="Required">*</span> | `string` | *No description.* |
| [`suspendedAction`](#cdktfprovideroktadataoktaidpsocialpropertysuspendedaction)<span title="Required">*</span> | `string` | *No description.* |
| [`tokenBinding`](#cdktfprovideroktadataoktaidpsocialpropertytokenbinding)<span title="Required">*</span> | `string` | *No description.* |
| [`tokenUrl`](#cdktfprovideroktadataoktaidpsocialpropertytokenurl)<span title="Required">*</span> | `string` | *No description.* |
| [`type`](#cdktfprovideroktadataoktaidpsocialpropertytype)<span title="Required">*</span> | `string` | *No description.* |
| [`usernameTemplate`](#cdktfprovideroktadataoktaidpsocialpropertyusernametemplate)<span title="Required">*</span> | `string` | *No description.* |
| [`idInput`](#cdktfprovideroktadataoktaidpsocialpropertyidinput) | `string` | *No description.* |
| [`nameInput`](#cdktfprovideroktadataoktaidpsocialpropertynameinput) | `string` | *No description.* |
| [`id`](#cdktfprovideroktadataoktaidpsocialpropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`name`](#cdktfprovideroktadataoktaidpsocialpropertyname)<span title="Required">*</span> | `string` | *No description.* |

---

##### `accountLinkAction`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpSocial.property.accountLinkAction" id="cdktfprovideroktadataoktaidpsocialpropertyaccountlinkaction"></a>

```typescript
public readonly accountLinkAction: string;
```

- *Type:* `string`

---

##### `accountLinkGroupInclude`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpSocial.property.accountLinkGroupInclude" id="cdktfprovideroktadataoktaidpsocialpropertyaccountlinkgroupinclude"></a>

```typescript
public readonly accountLinkGroupInclude: string[];
```

- *Type:* `string`[]

---

##### `authorizationBinding`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpSocial.property.authorizationBinding" id="cdktfprovideroktadataoktaidpsocialpropertyauthorizationbinding"></a>

```typescript
public readonly authorizationBinding: string;
```

- *Type:* `string`

---

##### `authorizationUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpSocial.property.authorizationUrl" id="cdktfprovideroktadataoktaidpsocialpropertyauthorizationurl"></a>

```typescript
public readonly authorizationUrl: string;
```

- *Type:* `string`

---

##### `clientId`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpSocial.property.clientId" id="cdktfprovideroktadataoktaidpsocialpropertyclientid"></a>

```typescript
public readonly clientId: string;
```

- *Type:* `string`

---

##### `clientSecret`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpSocial.property.clientSecret" id="cdktfprovideroktadataoktaidpsocialpropertyclientsecret"></a>

```typescript
public readonly clientSecret: string;
```

- *Type:* `string`

---

##### `deprovisionedAction`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpSocial.property.deprovisionedAction" id="cdktfprovideroktadataoktaidpsocialpropertydeprovisionedaction"></a>

```typescript
public readonly deprovisionedAction: string;
```

- *Type:* `string`

---

##### `groupsAction`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpSocial.property.groupsAction" id="cdktfprovideroktadataoktaidpsocialpropertygroupsaction"></a>

```typescript
public readonly groupsAction: string;
```

- *Type:* `string`

---

##### `groupsAssignment`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpSocial.property.groupsAssignment" id="cdktfprovideroktadataoktaidpsocialpropertygroupsassignment"></a>

```typescript
public readonly groupsAssignment: string[];
```

- *Type:* `string`[]

---

##### `groupsAttribute`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpSocial.property.groupsAttribute" id="cdktfprovideroktadataoktaidpsocialpropertygroupsattribute"></a>

```typescript
public readonly groupsAttribute: string;
```

- *Type:* `string`

---

##### `groupsFilter`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpSocial.property.groupsFilter" id="cdktfprovideroktadataoktaidpsocialpropertygroupsfilter"></a>

```typescript
public readonly groupsFilter: string[];
```

- *Type:* `string`[]

---

##### `issuerMode`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpSocial.property.issuerMode" id="cdktfprovideroktadataoktaidpsocialpropertyissuermode"></a>

```typescript
public readonly issuerMode: string;
```

- *Type:* `string`

---

##### `maxClockSkew`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpSocial.property.maxClockSkew" id="cdktfprovideroktadataoktaidpsocialpropertymaxclockskew"></a>

```typescript
public readonly maxClockSkew: number;
```

- *Type:* `number`

---

##### `profileMaster`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpSocial.property.profileMaster" id="cdktfprovideroktadataoktaidpsocialpropertyprofilemaster"></a>

```typescript
public readonly profileMaster: IResolvable;
```

- *Type:* [`cdktf.IResolvable`](#cdktf.IResolvable)

---

##### `protocolType`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpSocial.property.protocolType" id="cdktfprovideroktadataoktaidpsocialpropertyprotocoltype"></a>

```typescript
public readonly protocolType: string;
```

- *Type:* `string`

---

##### `provisioningAction`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpSocial.property.provisioningAction" id="cdktfprovideroktadataoktaidpsocialpropertyprovisioningaction"></a>

```typescript
public readonly provisioningAction: string;
```

- *Type:* `string`

---

##### `scopes`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpSocial.property.scopes" id="cdktfprovideroktadataoktaidpsocialpropertyscopes"></a>

```typescript
public readonly scopes: string[];
```

- *Type:* `string`[]

---

##### `status`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpSocial.property.status" id="cdktfprovideroktadataoktaidpsocialpropertystatus"></a>

```typescript
public readonly status: string;
```

- *Type:* `string`

---

##### `subjectMatchAttribute`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpSocial.property.subjectMatchAttribute" id="cdktfprovideroktadataoktaidpsocialpropertysubjectmatchattribute"></a>

```typescript
public readonly subjectMatchAttribute: string;
```

- *Type:* `string`

---

##### `subjectMatchType`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpSocial.property.subjectMatchType" id="cdktfprovideroktadataoktaidpsocialpropertysubjectmatchtype"></a>

```typescript
public readonly subjectMatchType: string;
```

- *Type:* `string`

---

##### `suspendedAction`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpSocial.property.suspendedAction" id="cdktfprovideroktadataoktaidpsocialpropertysuspendedaction"></a>

```typescript
public readonly suspendedAction: string;
```

- *Type:* `string`

---

##### `tokenBinding`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpSocial.property.tokenBinding" id="cdktfprovideroktadataoktaidpsocialpropertytokenbinding"></a>

```typescript
public readonly tokenBinding: string;
```

- *Type:* `string`

---

##### `tokenUrl`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpSocial.property.tokenUrl" id="cdktfprovideroktadataoktaidpsocialpropertytokenurl"></a>

```typescript
public readonly tokenUrl: string;
```

- *Type:* `string`

---

##### `type`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpSocial.property.type" id="cdktfprovideroktadataoktaidpsocialpropertytype"></a>

```typescript
public readonly type: string;
```

- *Type:* `string`

---

##### `usernameTemplate`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpSocial.property.usernameTemplate" id="cdktfprovideroktadataoktaidpsocialpropertyusernametemplate"></a>

```typescript
public readonly usernameTemplate: string;
```

- *Type:* `string`

---

##### `idInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaIdpSocial.property.idInput" id="cdktfprovideroktadataoktaidpsocialpropertyidinput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* `string`

---

##### `nameInput`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaIdpSocial.property.nameInput" id="cdktfprovideroktadataoktaidpsocialpropertynameinput"></a>

```typescript
public readonly nameInput: string;
```

- *Type:* `string`

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpSocial.property.id" id="cdktfprovideroktadataoktaidpsocialpropertyid"></a>

```typescript
public readonly id: string;
```

- *Type:* `string`

---

##### `name`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaIdpSocial.property.name" id="cdktfprovideroktadataoktaidpsocialpropertyname"></a>

```typescript
public readonly name: string;
```

- *Type:* `string`

---

#### Constants <a name="Constants" id="constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`tfResourceType`](#cdktfprovideroktadataoktaidpsocialpropertytfresourcetype)<span title="Required">*</span> | `string` | *No description.* |

---

##### `tfResourceType` <a name="@cdktf/provider-okta.DataOktaIdpSocial.property.tfResourceType" id="cdktfprovideroktadataoktaidpsocialpropertytfresourcetype"></a>

- *Type:* `string`

---

### DataOktaNetworkZone <a name="@cdktf/provider-okta.DataOktaNetworkZone" id="cdktfprovideroktadataoktanetworkzone"></a>

Represents a {@link https://www.terraform.io/docs/providers/okta/d/network_zone okta_network_zone}.

#### Initializers <a name="@cdktf/provider-okta.DataOktaNetworkZone.Initializer" id="cdktfprovideroktadataoktanetworkzoneinitializer"></a>

```typescript
import { DataOktaNetworkZone } from '@cdktf/provider-okta'

new DataOktaNetworkZone(scope: Construct, id: string, config?: DataOktaNetworkZoneConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`scope`](#cdktfprovideroktadataoktanetworkzoneparameterscope)<span title="Required">*</span> | [`constructs.Construct`](#constructs.Construct) | The scope in which to define this construct. |
| [`id`](#cdktfprovideroktadataoktanetworkzoneparameterid)<span title="Required">*</span> | `string` | The scoped construct ID. |
| [`config`](#cdktfprovideroktadataoktanetworkzoneparameterconfig) | [`@cdktf/provider-okta.DataOktaNetworkZoneConfig`](#@cdktf/provider-okta.DataOktaNetworkZoneConfig) | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaNetworkZone.parameter.scope" id="cdktfprovideroktadataoktanetworkzoneparameterscope"></a>

- *Type:* [`constructs.Construct`](#constructs.Construct)

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="@cdktf/provider-okta.DataOktaNetworkZone.parameter.id" id="cdktfprovideroktadataoktanetworkzoneparameterid"></a>

- *Type:* `string`

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Optional</sup> <a name="@cdktf/provider-okta.DataOktaNetworkZone.parameter.config" id="cdktfprovideroktadataoktanetworkzoneparameterconfig"></a>

- *Type:* [`@cdktf/provider-okta.DataOktaNetworkZoneConfig`](#@cdktf/provider-okta.DataOktaNetworkZoneConfig)

---

#### Methods <a name="Methods" id="methods"></a>

| **Name** | **Description** |
| --- | --- |
| [`resetId`](#cdktfprovideroktadataoktanetworkzoneresetid) | *No description.* |
| [`resetName`](#cdktfprovideroktadataoktanetworkzoneresetname) | *No description.* |

---

##### `resetId` <a name="@cdktf/provider-okta.DataOktaNetworkZone.resetId" id="cdktfprovideroktadataoktanetworkzoneresetid"></a>

```typescript
public resetId()
```

##### `resetName` <a name="@cdktf/provider-okta.DataOktaNetworkZone.resetName" id="cdktfprovideroktadataoktanetworkzoneresetname"></a>

```typescript
public resetName()
```


#### Properties <a name="Properties" id="properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| [`asns`](#cdktfprovideroktadataoktanetworkzonepropertyasns)<span title="Required">*</span> | `string`[] | *No description.* |
| [`dynamicLocations`](#cdktfprovideroktadataoktanetworkzonepropertydynamiclocations)<span title="Required">*</span> | `string`[] | *No description.* |
| [`dynamicProxyType`](#cdktfprovideroktadataoktanetworkzonepropertydynamicproxytype)<span title="Required">*</span> | `string` | *No description.* |
| [`gateways`](#cdktfprovideroktadataoktanetworkzonepropertygateways)<span title="Required">*</span> | `string`[] | *No description.* |
| [`proxies`](#cdktfprovideroktadataoktanetworkzonepropertyproxies)<span title="Required">*</span> | `string`[] | *No description.* |
| [`type`](#cdktfprovideroktadataoktanetworkzonepropertytype)<span title="Required">*</span> | `string` | *No description.* |
| [`usage`](#cdktfprovideroktadataoktanetworkzonepropertyusage)<span title="Required">*</span> | `string` | *No description.* |
| [`idInput`](#cdktfprovideroktadataoktanetworkzonepropertyidinput) | `string` | *No description.* |
| [`nameInput`](#cdktfprovideroktadataoktanetworkzonepropertynameinput) | `string` | *No description.* |
| [`id`](#cdktfprovideroktadataoktanetworkzonepropertyid)<span title="Required">*</span> | `string` | *No description.* |
| [`name`](#cdktfprovideroktadataoktanetworkzonepropertyname)<span title="Required">*</span> | `string` | *No descripti