import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AdminRoleCustomAssignmentsConfig extends cdktf.TerraformMetaArguments {
    /**
    * ID of the Custom Role
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/admin_role_custom_assignments#custom_role_id AdminRoleCustomAssignments#custom_role_id}
    */
    readonly customRoleId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/admin_role_custom_assignments#id AdminRoleCustomAssignments#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The hrefs that point to User(s) and/or Group(s) that receive the Role
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/admin_role_custom_assignments#members AdminRoleCustomAssignments#members}
    */
    readonly members?: string[];
    /**
    * ID of the target Resource Set
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/admin_role_custom_assignments#resource_set_id AdminRoleCustomAssignments#resource_set_id}
    */
    readonly resourceSetId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/admin_role_custom_assignments okta_admin_role_custom_assignments}
*/
export declare class AdminRoleCustomAssignments extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_admin_role_custom_assignments";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/admin_role_custom_assignments okta_admin_role_custom_assignments} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AdminRoleCustomAssignmentsConfig
    */
    constructor(scope: Construct, id: string, config: AdminRoleCustomAssignmentsConfig);
    private _customRoleId?;
    get customRoleId(): string;
    set customRoleId(value: string);
    get customRoleIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _members?;
    get members(): string[];
    set members(value: string[]);
    resetMembers(): void;
    get membersInput(): string[] | undefined;
    private _resourceSetId?;
    get resourceSetId(): string;
    set resourceSetId(value: string);
    get resourceSetIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
