import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AdminRoleCustomConfig extends cdktf.TerraformMetaArguments {
    /**
    * A human-readable description of the new Role
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/admin_role_custom#description AdminRoleCustom#description}
    */
    readonly description: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/admin_role_custom#id AdminRoleCustom#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name given to the new Role
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/admin_role_custom#label AdminRoleCustom#label}
    */
    readonly label: string;
    /**
    * The permissions that the new Role grants.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/admin_role_custom#permissions AdminRoleCustom#permissions}
    */
    readonly permissions?: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/admin_role_custom okta_admin_role_custom}
*/
export declare class AdminRoleCustom extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_admin_role_custom";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/admin_role_custom okta_admin_role_custom} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AdminRoleCustomConfig
    */
    constructor(scope: Construct, id: string, config: AdminRoleCustomConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _label?;
    get label(): string;
    set label(value: string);
    get labelInput(): string | undefined;
    private _permissions?;
    get permissions(): string[];
    set permissions(value: string[]);
    resetPermissions(): void;
    get permissionsInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
