import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AdminRoleTargetsConfig extends cdktf.TerraformMetaArguments {
    /**
    * List of app names (name represents set of app instances) or a combination of app name and app instance ID (like 'salesforce' or 'facebook.0oapsqQ6dv19pqyEo0g3')
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/admin_role_targets#apps AdminRoleTargets#apps}
    */
    readonly apps?: string[];
    /**
    * List of group IDs
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/admin_role_targets#groups AdminRoleTargets#groups}
    */
    readonly groups?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/admin_role_targets#id AdminRoleTargets#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Type of the role that is assigned to the user and supports optional targets
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/admin_role_targets#role_type AdminRoleTargets#role_type}
    */
    readonly roleType: string;
    /**
    * User associated with the role
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/admin_role_targets#user_id AdminRoleTargets#user_id}
    */
    readonly userId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/admin_role_targets okta_admin_role_targets}
*/
export declare class AdminRoleTargets extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_admin_role_targets";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/admin_role_targets okta_admin_role_targets} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AdminRoleTargetsConfig
    */
    constructor(scope: Construct, id: string, config: AdminRoleTargetsConfig);
    private _apps?;
    get apps(): string[];
    set apps(value: string[]);
    resetApps(): void;
    get appsInput(): string[] | undefined;
    private _groups?;
    get groups(): string[];
    set groups(value: string[]);
    resetGroups(): void;
    get groupsInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get roleId(): string;
    private _roleType?;
    get roleType(): string;
    set roleType(value: string);
    get roleTypeInput(): string | undefined;
    private _userId?;
    get userId(): string;
    set userId(value: string);
    get userIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
